// third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.BrowsingTopicsDocumentServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.BrowsingTopicsDocumentService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.BrowsingTopicsDocumentServiceInterface }
 */
blink.mojom.BrowsingTopicsDocumentServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.BrowsingTopicsDocumentServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.BrowsingTopicsDocumentServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.BrowsingTopicsDocumentServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } observe
   * @return {!Promise<{
        result: !blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result,
   *  }>}
   */

  getBrowsingTopics(
      observe) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ParamsSpec.$,
        blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParamsSpec.$,
        [
          observe
        ],
        true);
  }
};

/**
 * An object which receives request messages for the BrowsingTopicsDocumentService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.BrowsingTopicsDocumentServiceReceiver = class {
  /**
   * @param {!blink.mojom.BrowsingTopicsDocumentServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.BrowsingTopicsDocumentServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.BrowsingTopicsDocumentServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BrowsingTopicsDocumentServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ParamsSpec.$,
        blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParamsSpec.$,
        impl.getBrowsingTopics.bind(impl),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.BrowsingTopicsDocumentService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BrowsingTopicsDocumentService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.BrowsingTopicsDocumentServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.BrowsingTopicsDocumentServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the BrowsingTopicsDocumentService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.BrowsingTopicsDocumentServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.BrowsingTopicsDocumentServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BrowsingTopicsDocumentServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getBrowsingTopics =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ParamsSpec.$,
        blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParamsSpec.$,
        this.getBrowsingTopics.createReceiverHandler(true /* expectsResponse */),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EpochTopicSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.EpochTopicSpec.$,
    'EpochTopic',
    [
      mojo.internal.StructField(
        'topic', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'version', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'configVersion', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modelVersion', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'taxonomyVersion', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.EpochTopic = class {
  constructor() {
    /** @export { !number } */
    this.topic;
    /** @export { !string } */
    this.version;
    /** @export { !string } */
    this.configVersion;
    /** @export { !string } */
    this.modelVersion;
    /** @export { !string } */
    this.taxonomyVersion;
  }
};



mojo.internal.Struct(
    blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ParamsSpec.$,
    'BrowsingTopicsDocumentService_GetBrowsingTopics_Params',
    [
      mojo.internal.StructField(
        'observe', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.observe;
  }
};



mojo.internal.Struct(
    blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParamsSpec.$,
    'BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Union(
    blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultSpec.$, 'BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(blink.mojom.EpochTopicSpec.$, false),
      },
      'failure': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!blink.mojom.EpochTopic>|undefined),
 *   failure: (!string|undefined),
 * } }
 */
blink.mojom.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result;
