// third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom-params-data.h"
#include "third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

BroadcastChannelClient::IPCStableHashFunction BroadcastChannelClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BroadcastChannelClient>(message.name())) {
    case messages::BroadcastChannelClient::kOnMessage: {
      return &BroadcastChannelClient::OnMessage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BroadcastChannelClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BroadcastChannelClient>(message.name())) {
      case messages::BroadcastChannelClient::kOnMessage:
            return "Receive blink::mojom::BroadcastChannelClient::OnMessage";
    }
  } else {
    switch (static_cast<messages::BroadcastChannelClient>(message.name())) {
      case messages::BroadcastChannelClient::kOnMessage:
            return "Receive reply blink::mojom::BroadcastChannelClient::OnMessage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BroadcastChannelClient::OnMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd0b0b02;  // IPCStableHash for blink::mojom::BroadcastChannelClient::OnMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BroadcastChannelClientProxy::BroadcastChannelClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BroadcastChannelClientProxy::OnMessage(
    ::blink::BlinkCloneableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BroadcastChannelClient::OnMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::blink::BlinkCloneableMessage>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BroadcastChannelClient::kOnMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BroadcastChannelClient_OnMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CloneableMessageDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in BroadcastChannelClient.OnMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BroadcastChannelClient::Name_);
  message.set_method_name("OnMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BroadcastChannelClientStubDispatch::Accept(
    BroadcastChannelClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BroadcastChannelClient>(message->header()->name)) {
    case messages::BroadcastChannelClient::kOnMessage: {
      DCHECK(message->is_serialized());
      internal::BroadcastChannelClient_OnMessage_Params_Data* params =
          reinterpret_cast<internal::BroadcastChannelClient_OnMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BroadcastChannelClient.0
      bool success = true;
      ::blink::BlinkCloneableMessage p_message{};
      BroadcastChannelClient_OnMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BroadcastChannelClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMessage(        
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool BroadcastChannelClientStubDispatch::AcceptWithResponder(
    BroadcastChannelClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BroadcastChannelClient>(message->header()->name)) {
    case messages::BroadcastChannelClient::kOnMessage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBroadcastChannelClientValidationInfo[] = {
    { &internal::BroadcastChannelClient_OnMessage_Params_Data::Validate,
     nullptr /* no response */},
};

bool BroadcastChannelClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::BroadcastChannelClient::Name_,
    kBroadcastChannelClientValidationInfo);
}

// The declaration includes the definition on other builds.

BroadcastChannelProvider::IPCStableHashFunction BroadcastChannelProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BroadcastChannelProvider>(message.name())) {
    case messages::BroadcastChannelProvider::kConnectToChannel: {
      return &BroadcastChannelProvider::ConnectToChannel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BroadcastChannelProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BroadcastChannelProvider>(message.name())) {
      case messages::BroadcastChannelProvider::kConnectToChannel:
            return "Receive blink::mojom::BroadcastChannelProvider::ConnectToChannel";
    }
  } else {
    switch (static_cast<messages::BroadcastChannelProvider>(message.name())) {
      case messages::BroadcastChannelProvider::kConnectToChannel:
            return "Receive reply blink::mojom::BroadcastChannelProvider::ConnectToChannel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BroadcastChannelProvider::ConnectToChannel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1db4a252;  // IPCStableHash for blink::mojom::BroadcastChannelProvider::ConnectToChannel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BroadcastChannelProviderProxy::BroadcastChannelProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BroadcastChannelProviderProxy::ConnectToChannel(
    const ::blink::String& in_name, ::mojo::PendingAssociatedRemote<BroadcastChannelClient> in_client, ::mojo::PendingAssociatedReceiver<BroadcastChannelClient> in_connection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BroadcastChannelProvider::ConnectToChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<BroadcastChannelClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection"), in_connection,
                        "<value of type ::mojo::PendingAssociatedReceiver<BroadcastChannelClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BroadcastChannelProvider::kConnectToChannel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BroadcastChannelProvider_ConnectToChannel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in BroadcastChannelProvider.ConnectToChannel request");

  
  mojo::internal::Serialize<::blink::mojom::BroadcastChannelClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in BroadcastChannelProvider.ConnectToChannel request");

  
  mojo::internal::Serialize<::blink::mojom::BroadcastChannelClientAssociatedRequestDataView>(
    in_connection,
    &params->connection,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->connection)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid connection in BroadcastChannelProvider.ConnectToChannel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BroadcastChannelProvider::Name_);
  message.set_method_name("ConnectToChannel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BroadcastChannelProviderStubDispatch::Accept(
    BroadcastChannelProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BroadcastChannelProvider>(message->header()->name)) {
    case messages::BroadcastChannelProvider::kConnectToChannel: {
      DCHECK(message->is_serialized());
      internal::BroadcastChannelProvider_ConnectToChannel_Params_Data* params =
          reinterpret_cast<internal::BroadcastChannelProvider_ConnectToChannel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BroadcastChannelProvider.0
      bool success = true;
      ::blink::String p_name{};
      ::mojo::PendingAssociatedRemote<BroadcastChannelClient> p_client{};
      ::mojo::PendingAssociatedReceiver<BroadcastChannelClient> p_connection{};
      BroadcastChannelProvider_ConnectToChannel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_connection =
            input_data_view.TakeConnection<decltype(p_connection)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BroadcastChannelProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToChannel(        
        std::move(p_name), 
        std::move(p_client), 
        std::move(p_connection));
      return true;
    }
  }
  return false;
}

// static
bool BroadcastChannelProviderStubDispatch::AcceptWithResponder(
    BroadcastChannelProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BroadcastChannelProvider>(message->header()->name)) {
    case messages::BroadcastChannelProvider::kConnectToChannel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBroadcastChannelProviderValidationInfo[] = {
    { &internal::BroadcastChannelProvider_ConnectToChannel_Params_Data::Validate,
     nullptr /* no response */},
};

bool BroadcastChannelProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::BroadcastChannelProvider::Name_,
    kBroadcastChannelProviderValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void BroadcastChannelClientInterceptorForTesting::OnMessage(::blink::BlinkCloneableMessage message) {
  GetForwardingInterface()->OnMessage(
    std::move(message)
    );
}
BroadcastChannelClientAsyncWaiter::BroadcastChannelClientAsyncWaiter(
    BroadcastChannelClient* proxy) : proxy_(proxy) {}

BroadcastChannelClientAsyncWaiter::~BroadcastChannelClientAsyncWaiter() = default;





void BroadcastChannelProviderInterceptorForTesting::ConnectToChannel(const ::blink::String& name, ::mojo::PendingAssociatedRemote<BroadcastChannelClient> client, ::mojo::PendingAssociatedReceiver<BroadcastChannelClient> connection) {
  GetForwardingInterface()->ConnectToChannel(
    std::move(name)
    , 
    std::move(client)
    , 
    std::move(connection)
    );
}
BroadcastChannelProviderAsyncWaiter::BroadcastChannelProviderAsyncWaiter(
    BroadcastChannelProvider* proxy) : proxy_(proxy) {}

BroadcastChannelProviderAsyncWaiter::~BroadcastChannelProviderAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif