// third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT WebBluetoothServiceInterceptorForTesting : public WebBluetoothService {
  virtual WebBluetoothService* GetForwardingInterface() = 0;
  void GetAvailability(GetAvailabilityCallback callback) override;
  void RequestDevice(WebBluetoothRequestDeviceOptionsPtr options, RequestDeviceCallback callback) override;
  void GetDevices(GetDevicesCallback callback) override;
  void ForgetDevice(const ::blink::WebBluetoothDeviceId& device_id, ForgetDeviceCallback callback) override;
  void RemoteServerConnect(const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> client, RemoteServerConnectCallback callback) override;
  void RemoteServerDisconnect(const ::blink::WebBluetoothDeviceId& device_id) override;
  void RemoteServerGetPrimaryServices(const ::blink::WebBluetoothDeviceId& device_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& services_uuid, RemoteServerGetPrimaryServicesCallback callback) override;
  void RemoteServiceGetCharacteristics(const std::string& service_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& characteristics_uuid, RemoteServiceGetCharacteristicsCallback callback) override;
  void RemoteCharacteristicReadValue(const std::string& characteristic_instance_id, RemoteCharacteristicReadValueCallback callback) override;
  void RemoteCharacteristicWriteValue(const std::string& characteristic_instance_id, ::base::span<const ::uint8_t> value, WebBluetoothWriteType write_type, RemoteCharacteristicWriteValueCallback callback) override;
  void RemoteCharacteristicStartNotifications(const std::string& characteristic_instance_id, ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> client, RemoteCharacteristicStartNotificationsCallback callback) override;
  void RemoteCharacteristicStopNotifications(const std::string& characteristic_instance_id, RemoteCharacteristicStopNotificationsCallback callback) override;
  void RemoteCharacteristicGetDescriptors(const std::string& characteristics_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& descriptor_uuid, RemoteCharacteristicGetDescriptorsCallback callback) override;
  void RemoteDescriptorReadValue(const std::string& descriptor_instance_id, RemoteDescriptorReadValueCallback callback) override;
  void RemoteDescriptorWriteValue(const std::string& descriptor_instance_id, ::base::span<const ::uint8_t> value, RemoteDescriptorWriteValueCallback callback) override;
  void RequestScanningStart(::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothRequestLEScanOptionsPtr options, RequestScanningStartCallback callback) override;
  void WatchAdvertisementsForDevice(const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WatchAdvertisementsForDeviceCallback callback) override;
};
class BLINK_COMMON_EXPORT WebBluetoothServiceAsyncWaiter {
 public:
  explicit WebBluetoothServiceAsyncWaiter(WebBluetoothService* proxy);

  WebBluetoothServiceAsyncWaiter(const WebBluetoothServiceAsyncWaiter&) = delete;
  WebBluetoothServiceAsyncWaiter& operator=(const WebBluetoothServiceAsyncWaiter&) = delete;

  ~WebBluetoothServiceAsyncWaiter();
  void GetAvailability(
      bool* out_is_available);
  bool GetAvailability();
  void RequestDevice(
      WebBluetoothRequestDeviceOptionsPtr options, WebBluetoothResult* out_result, WebBluetoothDevicePtr* out_device);
  
  void GetDevices(
      std::vector<WebBluetoothDevicePtr>* out_devices);
  std::vector<WebBluetoothDevicePtr> GetDevices();
  void ForgetDevice(
      const ::blink::WebBluetoothDeviceId& device_id);
  
  void RemoteServerConnect(
      const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> client, WebBluetoothResult* out_result);
  WebBluetoothResult RemoteServerConnect(const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> client);
  void RemoteServerGetPrimaryServices(
      const ::blink::WebBluetoothDeviceId& device_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& services_uuid, WebBluetoothResult* out_result, std::optional<std::vector<WebBluetoothRemoteGATTServicePtr>>* out_services);
  
  void RemoteServiceGetCharacteristics(
      const std::string& service_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& characteristics_uuid, WebBluetoothResult* out_result, std::optional<std::vector<WebBluetoothRemoteGATTCharacteristicPtr>>* out_characteristics);
  
  void RemoteCharacteristicReadValue(
      const std::string& characteristic_instance_id, WebBluetoothResult* out_result, ::base::span<const ::uint8_t>* out_value);
  
  void RemoteCharacteristicWriteValue(
      const std::string& characteristic_instance_id, ::base::span<const ::uint8_t> value, WebBluetoothWriteType write_type, WebBluetoothResult* out_result);
  WebBluetoothResult RemoteCharacteristicWriteValue(const std::string& characteristic_instance_id, ::base::span<const ::uint8_t> value, WebBluetoothWriteType write_type);
  void RemoteCharacteristicStartNotifications(
      const std::string& characteristic_instance_id, ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> client, WebBluetoothResult* out_result);
  WebBluetoothResult RemoteCharacteristicStartNotifications(const std::string& characteristic_instance_id, ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> client);
  void RemoteCharacteristicStopNotifications(
      const std::string& characteristic_instance_id);
  
  void RemoteCharacteristicGetDescriptors(
      const std::string& characteristics_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& descriptor_uuid, WebBluetoothResult* out_result, std::optional<std::vector<WebBluetoothRemoteGATTDescriptorPtr>>* out_descriptors);
  
  void RemoteDescriptorReadValue(
      const std::string& descriptor_instance_id, WebBluetoothResult* out_result, ::base::span<const ::uint8_t>* out_value);
  
  void RemoteDescriptorWriteValue(
      const std::string& descriptor_instance_id, ::base::span<const ::uint8_t> value, WebBluetoothResult* out_result);
  WebBluetoothResult RemoteDescriptorWriteValue(const std::string& descriptor_instance_id, ::base::span<const ::uint8_t> value);
  void RequestScanningStart(
      ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothRequestLEScanOptionsPtr options, WebBluetoothResult* out_result);
  WebBluetoothResult RequestScanningStart(::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothRequestLEScanOptionsPtr options);
  void WatchAdvertisementsForDevice(
      const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothResult* out_result);
  WebBluetoothResult WatchAdvertisementsForDevice(const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client);

 private:
  WebBluetoothService* const proxy_;
};


class BLINK_COMMON_EXPORT WebBluetoothServerClientInterceptorForTesting : public WebBluetoothServerClient {
  virtual WebBluetoothServerClient* GetForwardingInterface() = 0;
  void GATTServerDisconnected() override;
};
class BLINK_COMMON_EXPORT WebBluetoothServerClientAsyncWaiter {
 public:
  explicit WebBluetoothServerClientAsyncWaiter(WebBluetoothServerClient* proxy);

  WebBluetoothServerClientAsyncWaiter(const WebBluetoothServerClientAsyncWaiter&) = delete;
  WebBluetoothServerClientAsyncWaiter& operator=(const WebBluetoothServerClientAsyncWaiter&) = delete;

  ~WebBluetoothServerClientAsyncWaiter();

 private:
  WebBluetoothServerClient* const proxy_;
};


class BLINK_COMMON_EXPORT WebBluetoothCharacteristicClientInterceptorForTesting : public WebBluetoothCharacteristicClient {
  virtual WebBluetoothCharacteristicClient* GetForwardingInterface() = 0;
  void RemoteCharacteristicValueChanged(::base::span<const ::uint8_t> value) override;
};
class BLINK_COMMON_EXPORT WebBluetoothCharacteristicClientAsyncWaiter {
 public:
  explicit WebBluetoothCharacteristicClientAsyncWaiter(WebBluetoothCharacteristicClient* proxy);

  WebBluetoothCharacteristicClientAsyncWaiter(const WebBluetoothCharacteristicClientAsyncWaiter&) = delete;
  WebBluetoothCharacteristicClientAsyncWaiter& operator=(const WebBluetoothCharacteristicClientAsyncWaiter&) = delete;

  ~WebBluetoothCharacteristicClientAsyncWaiter();

 private:
  WebBluetoothCharacteristicClient* const proxy_;
};


class BLINK_COMMON_EXPORT WebBluetoothAdvertisementClientInterceptorForTesting : public WebBluetoothAdvertisementClient {
  virtual WebBluetoothAdvertisementClient* GetForwardingInterface() = 0;
  void AdvertisingEvent(WebBluetoothAdvertisingEventPtr result) override;
};
class BLINK_COMMON_EXPORT WebBluetoothAdvertisementClientAsyncWaiter {
 public:
  explicit WebBluetoothAdvertisementClientAsyncWaiter(WebBluetoothAdvertisementClient* proxy);

  WebBluetoothAdvertisementClientAsyncWaiter(const WebBluetoothAdvertisementClientAsyncWaiter&) = delete;
  WebBluetoothAdvertisementClientAsyncWaiter& operator=(const WebBluetoothAdvertisementClientAsyncWaiter&) = delete;

  ~WebBluetoothAdvertisementClientAsyncWaiter();

 private:
  WebBluetoothAdvertisementClient* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_TEST_UTILS_H_