// third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"


namespace blink::mojom {
class WebBluetoothLeScanFilterDataView;

class WebBluetoothCompanyDataView;

class WebBluetoothDataFilterDataView;

class WebBluetoothRequestDeviceOptionsDataView;

class WebBluetoothRequestLEScanOptionsDataView;

class WebBluetoothDeviceIdDataView;

class WebBluetoothDeviceDataView;

class WebBluetoothRemoteGATTServiceDataView;

class WebBluetoothRemoteGATTCharacteristicDataView;

class WebBluetoothAdvertisingEventDataView;

class WebBluetoothRemoteGATTDescriptorDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothLeScanFilterDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothLeScanFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothCompanyDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothCompany_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothDataFilterDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothDataFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothRequestDeviceOptionsDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothRequestDeviceOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothRequestLEScanOptionsDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothRequestLEScanOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothDeviceIdDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothDeviceId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothDeviceDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothDevice_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothRemoteGATTServiceDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothRemoteGATTService_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothRemoteGATTCharacteristicDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothRemoteGATTCharacteristic_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothAdvertisingEventDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothAdvertisingEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothRemoteGATTDescriptorDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothRemoteGATTDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class WebBluetoothResult : int32_t {
  
  SUCCESS = 0,
  
  WATCH_ADVERTISEMENTS_ABORTED = 1,
  
  GATT_INVALID_ATTRIBUTE_LENGTH = 2,
  
  CONNECT_INVALID_ARGS = 3,
  
  SERVICE_NO_LONGER_EXISTS = 4,
  
  CHARACTERISTIC_NO_LONGER_EXISTS = 5,
  
  PROMPT_CANCELED = 6,
  
  CONNECT_DOES_NOT_EXIST = 7,
  
  CONNECT_ALREADY_IN_PROGRESS = 8,
  
  CONNECT_AUTH_CANCELED = 9,
  
  CONNECT_AUTH_FAILED = 10,
  
  CONNECT_AUTH_REJECTED = 11,
  
  CONNECT_AUTH_TIMEOUT = 12,
  
  CONNECT_UNKNOWN_ERROR = 13,
  
  CONNECT_UNKNOWN_FAILURE = 14,
  
  CONNECT_UNSUPPORTED_DEVICE = 15,
  
  DEVICE_NO_LONGER_IN_RANGE = 16,
  
  GATT_NOT_PAIRED = 17,
  
  GATT_OPERATION_IN_PROGRESS = 18,
  
  CONNECT_CONN_FAILED = 19,
  
  CONNECT_NOT_READY = 20,
  
  CONNECT_ALREADY_CONNECTED = 21,
  
  CONNECT_ALREADY_EXISTS = 22,
  
  CONNECT_NOT_CONNECTED = 23,
  
  CONNECT_NON_AUTH_TIMEOUT = 24,
  
  CONNECT_NO_MEMORY = 25,
  
  CONNECT_JNI_ENVIRONMENT = 26,
  
  CONNECT_JNI_THREAD_ATTACH = 27,
  
  CONNECT_WAKELOCK = 28,
  
  CONNECT_UNEXPECTED_STATE = 29,
  
  CONNECT_SOCKET_ERROR = 30,
  
  NO_BLUETOOTH_ADAPTER = 31,
  
  CHOSEN_DEVICE_VANISHED = 32,
  
  CHOOSER_CANCELLED = 33,
  
  CHOOSER_NOT_SHOWN_API_GLOBALLY_DISABLED = 34,
  
  CHOOSER_NOT_SHOWN_API_LOCALLY_DISABLED = 35,
  
  CHOOSER_NOT_SHOWN_USER_DENIED_PERMISSION_TO_SCAN = 36,
  
  SERVICE_NOT_FOUND = 37,
  
  NO_SERVICES_FOUND = 38,
  
  CHARACTERISTIC_NOT_FOUND = 39,
  
  NO_CHARACTERISTICS_FOUND = 40,
  
  DESCRIPTOR_NOT_FOUND = 41,
  
  NO_DESCRIPTORS_FOUND = 42,
  
  WEB_BLUETOOTH_NOT_SUPPORTED = 43,
  
  BLUETOOTH_LOW_ENERGY_NOT_AVAILABLE = 44,
  
  GATT_UNKNOWN_ERROR = 45,
  
  GATT_UNKNOWN_FAILURE = 46,
  
  GATT_NOT_PERMITTED = 47,
  
  GATT_NOT_SUPPORTED = 48,
  
  GATT_UNTRANSLATED_ERROR_CODE = 49,
  
  GATT_NOT_AUTHORIZED = 50,
  
  BLOCKLISTED_DESCRIPTOR_UUID = 51,
  
  BLOCKLISTED_CHARACTERISTIC_UUID = 52,
  
  BLOCKLISTED_READ = 53,
  
  BLOCKLISTED_WRITE = 54,
  
  NOT_ALLOWED_TO_ACCESS_ANY_SERVICE = 55,
  
  NOT_ALLOWED_TO_ACCESS_SERVICE = 56,
  
  REQUEST_DEVICE_WITH_BLOCKLISTED_UUID_OR_MANUFACTURER_DATA = 57,
  
  DESCRIPTOR_NO_LONGER_EXISTS = 58,
  
  PERMISSIONS_POLICY_VIOLATION = 59,
  
  SCANNING_BLOCKED = 60,
  kMinValue = 0,
  kMaxValue = 60,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebBluetoothResult value);
inline bool IsKnownEnumValue(WebBluetoothResult value) {
  return internal::WebBluetoothResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebBluetoothGATTQueryQuantity : int32_t {
  
  SINGLE = 0,
  
  MULTIPLE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebBluetoothGATTQueryQuantity value);
inline bool IsKnownEnumValue(WebBluetoothGATTQueryQuantity value) {
  return internal::WebBluetoothGATTQueryQuantity_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebBluetoothWriteType : int32_t {
  
  kWriteDefaultDeprecated = 0,
  
  kWriteWithResponse = 1,
  
  kWriteWithoutResponse = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebBluetoothWriteType value);
inline bool IsKnownEnumValue(WebBluetoothWriteType value) {
  return internal::WebBluetoothWriteType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebBluetoothServiceInterfaceBase {};

using WebBluetoothServicePtrDataView =
    mojo::InterfacePtrDataView<WebBluetoothServiceInterfaceBase>;
using WebBluetoothServiceRequestDataView =
    mojo::InterfaceRequestDataView<WebBluetoothServiceInterfaceBase>;
using WebBluetoothServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBluetoothServiceInterfaceBase>;
using WebBluetoothServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBluetoothServiceInterfaceBase>;
class WebBluetoothServerClientInterfaceBase {};

using WebBluetoothServerClientPtrDataView =
    mojo::InterfacePtrDataView<WebBluetoothServerClientInterfaceBase>;
using WebBluetoothServerClientRequestDataView =
    mojo::InterfaceRequestDataView<WebBluetoothServerClientInterfaceBase>;
using WebBluetoothServerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBluetoothServerClientInterfaceBase>;
using WebBluetoothServerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBluetoothServerClientInterfaceBase>;
class WebBluetoothCharacteristicClientInterfaceBase {};

using WebBluetoothCharacteristicClientPtrDataView =
    mojo::InterfacePtrDataView<WebBluetoothCharacteristicClientInterfaceBase>;
using WebBluetoothCharacteristicClientRequestDataView =
    mojo::InterfaceRequestDataView<WebBluetoothCharacteristicClientInterfaceBase>;
using WebBluetoothCharacteristicClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBluetoothCharacteristicClientInterfaceBase>;
using WebBluetoothCharacteristicClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBluetoothCharacteristicClientInterfaceBase>;
class WebBluetoothAdvertisementClientInterfaceBase {};

using WebBluetoothAdvertisementClientPtrDataView =
    mojo::InterfacePtrDataView<WebBluetoothAdvertisementClientInterfaceBase>;
using WebBluetoothAdvertisementClientRequestDataView =
    mojo::InterfaceRequestDataView<WebBluetoothAdvertisementClientInterfaceBase>;
using WebBluetoothAdvertisementClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBluetoothAdvertisementClientInterfaceBase>;
using WebBluetoothAdvertisementClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBluetoothAdvertisementClientInterfaceBase>;


class WebBluetoothLeScanFilterDataView {
 public:
  WebBluetoothLeScanFilterDataView() = default;

  WebBluetoothLeScanFilterDataView(
      internal::WebBluetoothLeScanFilter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServicesDataView(
      mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServices(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>, UserType>(),
    "Attempting to read the optional `services` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServices` instead "
    "of `ReadServices if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->services.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNamePrefixDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNamePrefix(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name_prefix` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNamePrefix` instead "
    "of `ReadNamePrefix if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name_prefix.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetManufacturerDataDataView(
      mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<WebBluetoothDataFilterDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManufacturerData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::blink::mojom::WebBluetoothCompanyDataView, mojo::ArrayDataView<::blink::mojom::WebBluetoothDataFilterDataView>>, UserType>(),
    "Attempting to read the optional `manufacturer_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadManufacturerData` instead "
    "of `ReadManufacturerData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->manufacturer_data.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::WebBluetoothCompanyDataView, mojo::ArrayDataView<::blink::mojom::WebBluetoothDataFilterDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothLeScanFilter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothCompanyDataView {
 public:
  WebBluetoothCompanyDataView() = default;

  WebBluetoothCompanyDataView(
      internal::WebBluetoothCompany_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t id() const {
    return data_->id;
  }
 private:
  internal::WebBluetoothCompany_Data* data_ = nullptr;
};


class WebBluetoothDataFilterDataView {
 public:
  WebBluetoothDataFilterDataView() = default;

  WebBluetoothDataFilterDataView(
      internal::WebBluetoothDataFilter_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t data() const {
    return data_->data;
  }
  uint8_t mask() const {
    return data_->mask;
  }
 private:
  internal::WebBluetoothDataFilter_Data* data_ = nullptr;
};


class WebBluetoothRequestDeviceOptionsDataView {
 public:
  WebBluetoothRequestDeviceOptionsDataView() = default;

  WebBluetoothRequestDeviceOptionsDataView(
      internal::WebBluetoothRequestDeviceOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFiltersDataView(
      mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>, UserType>(),
    "Attempting to read the optional `filters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFilters` instead "
    "of `ReadFilters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
        pointer, output, message_);
  }
  inline void GetExclusionFiltersDataView(
      mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExclusionFilters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>, UserType>(),
    "Attempting to read the optional `exclusion_filters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExclusionFilters` instead "
    "of `ReadExclusionFilters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->exclusion_filters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
        pointer, output, message_);
  }
  inline void GetOptionalServicesDataView(
      mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptionalServices(UserType* output) {
    
    auto* pointer = data_->optional_services.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
        pointer, output, message_);
  }
  inline void GetOptionalManufacturerDataDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptionalManufacturerData(UserType* output) {
    
    auto* pointer = data_->optional_manufacturer_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
  bool accept_all_devices() const {
    return data_->accept_all_devices;
  }
 private:
  internal::WebBluetoothRequestDeviceOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothRequestLEScanOptionsDataView {
 public:
  WebBluetoothRequestLEScanOptionsDataView() = default;

  WebBluetoothRequestLEScanOptionsDataView(
      internal::WebBluetoothRequestLEScanOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFiltersDataView(
      mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>, UserType>(),
    "Attempting to read the optional `filters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFilters` instead "
    "of `ReadFilters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
        pointer, output, message_);
  }
  bool keep_repeated_devices() const {
    return data_->keep_repeated_devices;
  }
  bool accept_all_advertisements() const {
    return data_->accept_all_advertisements;
  }
 private:
  internal::WebBluetoothRequestLEScanOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothDeviceIdDataView {
 public:
  WebBluetoothDeviceIdDataView() = default;

  WebBluetoothDeviceIdDataView(
      internal::WebBluetoothDeviceId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothDeviceId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothDeviceDataView {
 public:
  WebBluetoothDeviceDataView() = default;

  WebBluetoothDeviceDataView(
      internal::WebBluetoothDevice_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      WebBluetoothDeviceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebBluetoothDeviceIdDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothDevice_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothRemoteGATTServiceDataView {
 public:
  WebBluetoothRemoteGATTServiceDataView() = default;

  WebBluetoothRemoteGATTServiceDataView(
      internal::WebBluetoothRemoteGATTService_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInstanceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceId(UserType* output) {
    
    auto* pointer = data_->instance_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothRemoteGATTService_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothRemoteGATTCharacteristicDataView {
 public:
  WebBluetoothRemoteGATTCharacteristicDataView() = default;

  WebBluetoothRemoteGATTCharacteristicDataView(
      internal::WebBluetoothRemoteGATTCharacteristic_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInstanceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceId(UserType* output) {
    
    auto* pointer = data_->instance_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  uint32_t properties() const {
    return data_->properties;
  }
 private:
  internal::WebBluetoothRemoteGATTCharacteristic_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothAdvertisingEventDataView {
 public:
  WebBluetoothAdvertisingEventDataView() = default;

  WebBluetoothAdvertisingEventDataView(
      internal::WebBluetoothAdvertisingEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceDataView(
      WebBluetoothDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebBluetoothDeviceDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidsDataView(
      mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuids(UserType* output) {
    
    auto* pointer = data_->uuids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
        pointer, output, message_);
  }
  bool appearance_is_set() const {
    return data_->appearance_is_set;
  }
  uint16_t appearance() const {
    return data_->appearance;
  }
  bool tx_power_is_set() const {
    return data_->tx_power_is_set;
  }
  uint8_t tx_power() const {
    return data_->tx_power;
  }
  bool rssi_is_set() const {
    return data_->rssi_is_set;
  }
  uint8_t rssi() const {
    return data_->rssi;
  }
  inline void GetManufacturerDataDataView(
      mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManufacturerData(UserType* output) {
    
    auto* pointer = data_->manufacturer_data.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::WebBluetoothCompanyDataView, mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  inline void GetServiceDataDataView(
      mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceData(UserType* output) {
    
    auto* pointer = data_->service_data.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothAdvertisingEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothRemoteGATTDescriptorDataView {
 public:
  WebBluetoothRemoteGATTDescriptorDataView() = default;

  WebBluetoothRemoteGATTDescriptorDataView(
      internal::WebBluetoothRemoteGATTDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInstanceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceId(UserType* output) {
    
    auto* pointer = data_->instance_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothRemoteGATTDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_DATA_VIEW_H_