// third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom-params-data.h"
#include "third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom-import-headers.h"
#include "third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

FileBackedBlobFactory::IPCStableHashFunction FileBackedBlobFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileBackedBlobFactory>(message.name())) {
    case messages::FileBackedBlobFactory::kRegisterBlob: {
      return &FileBackedBlobFactory::RegisterBlob_Sym::IPCStableHash;
    }
    case messages::FileBackedBlobFactory::kRegisterBlobSync: {
      return &FileBackedBlobFactory::RegisterBlobSync_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileBackedBlobFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileBackedBlobFactory>(message.name())) {
      case messages::FileBackedBlobFactory::kRegisterBlob:
            return "Receive blink::mojom::FileBackedBlobFactory::RegisterBlob";
      case messages::FileBackedBlobFactory::kRegisterBlobSync:
            return "Receive blink::mojom::FileBackedBlobFactory::RegisterBlobSync";
    }
  } else {
    switch (static_cast<messages::FileBackedBlobFactory>(message.name())) {
      case messages::FileBackedBlobFactory::kRegisterBlob:
            return "Receive reply blink::mojom::FileBackedBlobFactory::RegisterBlob";
      case messages::FileBackedBlobFactory::kRegisterBlobSync:
            return "Receive reply blink::mojom::FileBackedBlobFactory::RegisterBlobSync";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileBackedBlobFactory::RegisterBlob_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10971552;  // IPCStableHash for blink::mojom::FileBackedBlobFactory::RegisterBlob
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileBackedBlobFactory::RegisterBlobSync_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd7428e33;  // IPCStableHash for blink::mojom::FileBackedBlobFactory::RegisterBlobSync
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FileBackedBlobFactory::RegisterBlobSync(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, const std::string& content_type, ::blink::mojom::DataElementFilePtr file) {
  NOTREACHED();
}
class FileBackedBlobFactory_RegisterBlobSync_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileBackedBlobFactory_RegisterBlobSync_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  FileBackedBlobFactory_RegisterBlobSync_HandleSyncResponse(const FileBackedBlobFactory_RegisterBlobSync_HandleSyncResponse&) = delete;
  FileBackedBlobFactory_RegisterBlobSync_HandleSyncResponse& operator=(const FileBackedBlobFactory_RegisterBlobSync_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class FileBackedBlobFactory_RegisterBlobSync_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileBackedBlobFactory_RegisterBlobSync_ForwardToCallback(
      FileBackedBlobFactory::RegisterBlobSyncCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileBackedBlobFactory_RegisterBlobSync_ForwardToCallback(const FileBackedBlobFactory_RegisterBlobSync_ForwardToCallback&) = delete;
  FileBackedBlobFactory_RegisterBlobSync_ForwardToCallback& operator=(const FileBackedBlobFactory_RegisterBlobSync_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileBackedBlobFactory::RegisterBlobSyncCallback callback_;
};

FileBackedBlobFactoryProxy::FileBackedBlobFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileBackedBlobFactoryProxy::RegisterBlob(
    ::mojo::PendingReceiver<::blink::mojom::Blob> in_blob, const std::string& in_uuid, const std::string& in_content_type, ::blink::mojom::DataElementFilePtr in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileBackedBlobFactory::RegisterBlob", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), in_content_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::blink::mojom::DataElementFilePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileBackedBlobFactory::kRegisterBlob), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileBackedBlobFactory_RegisterBlob_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
    in_blob,
    &params->blob,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blob)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid blob in FileBackedBlobFactory.RegisterBlob request");
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in FileBackedBlobFactory.RegisterBlob request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_type)::BaseType> content_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_content_type,
    content_type_fragment);

  params->content_type.Set(
      content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_type in FileBackedBlobFactory.RegisterBlob request");
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DataElementFileDataView>(
    in_file,
    file_fragment);

  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file in FileBackedBlobFactory.RegisterBlob request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileBackedBlobFactory::Name_);
  message.set_method_name("RegisterBlob");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool FileBackedBlobFactoryProxy::RegisterBlobSync(
    ::mojo::PendingReceiver<::blink::mojom::Blob> param_blob, const std::string& param_uuid, const std::string& param_content_type, ::blink::mojom::DataElementFilePtr param_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileBackedBlobFactory::RegisterBlobSync (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), param_blob,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), param_uuid,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), param_content_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), param_file,
                        "<value of type ::blink::mojom::DataElementFilePtr>");
   });
#else
  TRACE_EVENT0("mojom", "FileBackedBlobFactory::RegisterBlobSync");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileBackedBlobFactory::kRegisterBlobSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileBackedBlobFactory_RegisterBlobSync_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
    param_blob,
    &params->blob,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blob)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid blob in FileBackedBlobFactory.RegisterBlobSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in FileBackedBlobFactory.RegisterBlobSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_type)::BaseType> content_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_content_type,
    content_type_fragment);

  params->content_type.Set(
      content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_type in FileBackedBlobFactory.RegisterBlobSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DataElementFileDataView>(
    param_file,
    file_fragment);

  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file in FileBackedBlobFactory.RegisterBlobSync request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileBackedBlobFactory::Name_);
  message.set_method_name("RegisterBlobSync");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileBackedBlobFactory_RegisterBlobSync_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "FileBackedBlobFactory::RegisterBlobSync");
#endif
  return result;
}

void FileBackedBlobFactoryProxy::RegisterBlobSync(
    ::mojo::PendingReceiver<::blink::mojom::Blob> in_blob, const std::string& in_uuid, const std::string& in_content_type, ::blink::mojom::DataElementFilePtr in_file, RegisterBlobSyncCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileBackedBlobFactory::RegisterBlobSync", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), in_content_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::blink::mojom::DataElementFilePtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileBackedBlobFactory::kRegisterBlobSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileBackedBlobFactory_RegisterBlobSync_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
    in_blob,
    &params->blob,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blob)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid blob in FileBackedBlobFactory.RegisterBlobSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in FileBackedBlobFactory.RegisterBlobSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_type)::BaseType> content_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_content_type,
    content_type_fragment);

  params->content_type.Set(
      content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_type in FileBackedBlobFactory.RegisterBlobSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DataElementFileDataView>(
    in_file,
    file_fragment);

  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file in FileBackedBlobFactory.RegisterBlobSync request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileBackedBlobFactory::Name_);
  message.set_method_name("RegisterBlobSync");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileBackedBlobFactory_RegisterBlobSync_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FileBackedBlobFactory_RegisterBlobSync_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileBackedBlobFactory::RegisterBlobSyncCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileBackedBlobFactory_RegisterBlobSync_ProxyToResponder> proxy(
        new FileBackedBlobFactory_RegisterBlobSync_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileBackedBlobFactory_RegisterBlobSync_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileBackedBlobFactory_RegisterBlobSync_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileBackedBlobFactory_RegisterBlobSync_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileBackedBlobFactory::RegisterBlobSyncCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FileBackedBlobFactory_RegisterBlobSync_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileBackedBlobFactory_RegisterBlobSync_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileBackedBlobFactory_RegisterBlobSync_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileBackedBlobFactory.1
  bool success = true;
  FileBackedBlobFactory_RegisterBlobSync_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileBackedBlobFactory::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FileBackedBlobFactory_RegisterBlobSync_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::FileBackedBlobFactory::RegisterBlobSync");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileBackedBlobFactory::kRegisterBlobSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileBackedBlobFactory_RegisterBlobSync_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileBackedBlobFactory::Name_);
  message.set_method_name("RegisterBlobSync");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileBackedBlobFactory_RegisterBlobSync_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileBackedBlobFactory_RegisterBlobSync_ResponseParams_Data* params =
      reinterpret_cast<internal::FileBackedBlobFactory_RegisterBlobSync_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileBackedBlobFactory.1
  bool success = true;
  FileBackedBlobFactory_RegisterBlobSync_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileBackedBlobFactory::Name_, 1, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool FileBackedBlobFactoryStubDispatch::Accept(
    FileBackedBlobFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileBackedBlobFactory>(message->header()->name)) {
    case messages::FileBackedBlobFactory::kRegisterBlob: {
      DCHECK(message->is_serialized());
      internal::FileBackedBlobFactory_RegisterBlob_Params_Data* params =
          reinterpret_cast<internal::FileBackedBlobFactory_RegisterBlob_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileBackedBlobFactory.0
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::Blob> p_blob{};
      std::string p_uuid{};
      std::string p_content_type{};
      ::blink::mojom::DataElementFilePtr p_file{};
      FileBackedBlobFactory_RegisterBlob_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadContentType(&p_content_type))
        success = false;
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileBackedBlobFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterBlob(        
        std::move(p_blob), 
        std::move(p_uuid), 
        std::move(p_content_type), 
        std::move(p_file));
      return true;
    }
    case messages::FileBackedBlobFactory::kRegisterBlobSync: {
      break;
    }
  }
  return false;
}

// static
bool FileBackedBlobFactoryStubDispatch::AcceptWithResponder(
    FileBackedBlobFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileBackedBlobFactory>(message->header()->name)) {
    case messages::FileBackedBlobFactory::kRegisterBlob: {
      break;
    }
    case messages::FileBackedBlobFactory::kRegisterBlobSync: {
      internal::FileBackedBlobFactory_RegisterBlobSync_Params_Data* params =
          reinterpret_cast<
              internal::FileBackedBlobFactory_RegisterBlobSync_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileBackedBlobFactory.1
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::Blob> p_blob{};
      std::string p_uuid{};
      std::string p_content_type{};
      ::blink::mojom::DataElementFilePtr p_file{};
      FileBackedBlobFactory_RegisterBlobSync_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadContentType(&p_content_type))
        success = false;
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileBackedBlobFactory::Name_, 1, false);
        return false;
      }
      auto callback =
          FileBackedBlobFactory_RegisterBlobSync_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterBlobSync(        
        std::move(p_blob), 
        std::move(p_uuid), 
        std::move(p_content_type), 
        std::move(p_file), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileBackedBlobFactoryValidationInfo[] = {
    { &internal::FileBackedBlobFactory_RegisterBlob_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileBackedBlobFactory_RegisterBlobSync_Params_Data::Validate,
     &internal::FileBackedBlobFactory_RegisterBlobSync_ResponseParams_Data::Validate},
};

bool FileBackedBlobFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FileBackedBlobFactory::Name_,
    kFileBackedBlobFactoryValidationInfo);
}

bool FileBackedBlobFactoryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::FileBackedBlobFactory::Name_,
    kFileBackedBlobFactoryValidationInfo);
}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void FileBackedBlobFactoryInterceptorForTesting::RegisterBlob(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, const std::string& content_type, ::blink::mojom::DataElementFilePtr file) {
  GetForwardingInterface()->RegisterBlob(
    std::move(blob)
    , 
    std::move(uuid)
    , 
    std::move(content_type)
    , 
    std::move(file)
    );
}
void FileBackedBlobFactoryInterceptorForTesting::RegisterBlobSync(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, const std::string& content_type, ::blink::mojom::DataElementFilePtr file, RegisterBlobSyncCallback callback) {
  GetForwardingInterface()->RegisterBlobSync(
    std::move(blob)
    , 
    std::move(uuid)
    , 
    std::move(content_type)
    , 
    std::move(file)
    , std::move(callback));
}
FileBackedBlobFactoryAsyncWaiter::FileBackedBlobFactoryAsyncWaiter(
    FileBackedBlobFactory* proxy) : proxy_(proxy) {}

FileBackedBlobFactoryAsyncWaiter::~FileBackedBlobFactoryAsyncWaiter() = default;


void FileBackedBlobFactoryAsyncWaiter::RegisterBlobSync(
    ::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, const std::string& content_type, ::blink::mojom::DataElementFilePtr file) {
  base::RunLoop loop;
  proxy_->RegisterBlobSync(
      std::move(blob),
      std::move(uuid),
      std::move(content_type),
      std::move(file),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif