// third_party/blink/public/mojom/blob/blob_registry.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/blob/blob_registry.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/blob.mojom', 'blob.mojom.js');
  }
  var blob_url_store$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/blob_url_store.mojom', 'blob_url_store.mojom.js');
  }
  var data_element$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/data_element.mojom', 'data_element.mojom.js');
  }
  var serialized_blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/serialized_blob.mojom', 'serialized_blob.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }



  function ProgressClient_OnProgress_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ProgressClient_OnProgress_Params.prototype.initDefaults_ = function() {
    this.delta = 0;
  };
  ProgressClient_OnProgress_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ProgressClient_OnProgress_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ProgressClient_OnProgress_Params.encodedSize = codec.kStructHeaderSize + 8;

  ProgressClient_OnProgress_Params.decode = function(decoder) {
    var packed;
    var val = new ProgressClient_OnProgress_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.delta =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  ProgressClient_OnProgress_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ProgressClient_OnProgress_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.delta);
  };
  function BlobRegistry_Register_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BlobRegistry_Register_Params.prototype.initDefaults_ = function() {
    this.blob = new bindings.InterfaceRequest();
    this.uuid = null;
    this.contentType = null;
    this.contentDisposition = null;
    this.elements = null;
  };
  BlobRegistry_Register_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BlobRegistry_Register_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlobRegistry_Register_Params.blob
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlobRegistry_Register_Params.uuid
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlobRegistry_Register_Params.contentType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlobRegistry_Register_Params.contentDisposition
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlobRegistry_Register_Params.elements
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 16, data_element$.DataElement, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BlobRegistry_Register_Params.encodedSize = codec.kStructHeaderSize + 40;

  BlobRegistry_Register_Params.decode = function(decoder) {
    var packed;
    var val = new BlobRegistry_Register_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.blob =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.uuid =
        decoder.decodeStruct(codec.String);
    val.contentType =
        decoder.decodeStruct(codec.String);
    val.contentDisposition =
        decoder.decodeStruct(codec.String);
    val.elements =
        decoder.decodeArrayPointer(data_element$.DataElement);
    return val;
  };

  BlobRegistry_Register_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BlobRegistry_Register_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.blob);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.uuid);
    encoder.encodeStruct(codec.String, val.contentType);
    encoder.encodeStruct(codec.String, val.contentDisposition);
    encoder.encodeArrayPointer(data_element$.DataElement, val.elements);
  };
  function BlobRegistry_Register_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BlobRegistry_Register_ResponseParams.prototype.initDefaults_ = function() {
  };
  BlobRegistry_Register_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BlobRegistry_Register_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BlobRegistry_Register_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  BlobRegistry_Register_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BlobRegistry_Register_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  BlobRegistry_Register_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BlobRegistry_Register_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function BlobRegistry_RegisterFromStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BlobRegistry_RegisterFromStream_Params.prototype.initDefaults_ = function() {
    this.contentType = null;
    this.contentDisposition = null;
    this.lengthHint = 0;
    this.data = null;
    this.progressClient = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  BlobRegistry_RegisterFromStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BlobRegistry_RegisterFromStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlobRegistry_RegisterFromStream_Params.contentType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlobRegistry_RegisterFromStream_Params.contentDisposition
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate BlobRegistry_RegisterFromStream_Params.data
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlobRegistry_RegisterFromStream_Params.progressClient
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 28, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BlobRegistry_RegisterFromStream_Params.encodedSize = codec.kStructHeaderSize + 40;

  BlobRegistry_RegisterFromStream_Params.decode = function(decoder) {
    var packed;
    var val = new BlobRegistry_RegisterFromStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.contentType =
        decoder.decodeStruct(codec.String);
    val.contentDisposition =
        decoder.decodeStruct(codec.String);
    val.lengthHint =
        decoder.decodeStruct(codec.Uint64);
    val.data =
        decoder.decodeStruct(codec.Handle);
    val.progressClient =
        decoder.decodeStruct(codec.NullableAssociatedInterfacePtrInfo);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BlobRegistry_RegisterFromStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BlobRegistry_RegisterFromStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.contentType);
    encoder.encodeStruct(codec.String, val.contentDisposition);
    encoder.encodeStruct(codec.Uint64, val.lengthHint);
    encoder.encodeStruct(codec.Handle, val.data);
    encoder.encodeStruct(codec.NullableAssociatedInterfacePtrInfo, val.progressClient);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BlobRegistry_RegisterFromStream_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BlobRegistry_RegisterFromStream_ResponseParams.prototype.initDefaults_ = function() {
    this.blob = null;
  };
  BlobRegistry_RegisterFromStream_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BlobRegistry_RegisterFromStream_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlobRegistry_RegisterFromStream_ResponseParams.blob
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, serialized_blob$.SerializedBlob, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BlobRegistry_RegisterFromStream_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  BlobRegistry_RegisterFromStream_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BlobRegistry_RegisterFromStream_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.blob =
        decoder.decodeStructPointer(serialized_blob$.SerializedBlob);
    return val;
  };

  BlobRegistry_RegisterFromStream_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BlobRegistry_RegisterFromStream_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(serialized_blob$.SerializedBlob, val.blob);
  };
  var kProgressClient_OnProgress_Name = 0;

  function ProgressClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ProgressClient,
                                                   handleOrPtrInfo);
  }

  function ProgressClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ProgressClient, associatedInterfacePtrInfo);
  }

  ProgressClientAssociatedPtr.prototype =
      Object.create(ProgressClientPtr.prototype);
  ProgressClientAssociatedPtr.prototype.constructor =
      ProgressClientAssociatedPtr;

  function ProgressClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  ProgressClientPtr.prototype.onProgress = function() {
    return ProgressClientProxy.prototype.onProgress
        .apply(this.ptr.getProxy(), arguments);
  };

  ProgressClientProxy.prototype.onProgress = function(delta) {
    var params_ = new ProgressClient_OnProgress_Params();
    params_.delta = delta;
    var builder = new codec.MessageV0Builder(
        kProgressClient_OnProgress_Name,
        codec.align(ProgressClient_OnProgress_Params.encodedSize));
    builder.encodeStruct(ProgressClient_OnProgress_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ProgressClientStub(delegate) {
    this.delegate_ = delegate;
  }
  ProgressClientStub.prototype.onProgress = function(delta) {
    return this.delegate_ && this.delegate_.onProgress && this.delegate_.onProgress(delta);
  }

  ProgressClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kProgressClient_OnProgress_Name:
      var params = reader.decodeStruct(ProgressClient_OnProgress_Params);
      this.onProgress(params.delta);
      return true;
    default:
      return false;
    }
  };

  ProgressClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateProgressClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kProgressClient_OnProgress_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ProgressClient_OnProgress_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateProgressClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ProgressClient = {
    name: 'blink.mojom.ProgressClient',
    kVersion: 0,
    ptrClass: ProgressClientPtr,
    proxyClass: ProgressClientProxy,
    stubClass: ProgressClientStub,
    validateRequest: validateProgressClientRequest,
    validateResponse: null,
  };
  ProgressClientStub.prototype.validator = validateProgressClientRequest;
  ProgressClientProxy.prototype.validator = null;
  var kBlobRegistry_Register_Name = 0;
  var kBlobRegistry_RegisterFromStream_Name = 1;

  function BlobRegistryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(BlobRegistry,
                                                   handleOrPtrInfo);
  }

  function BlobRegistryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        BlobRegistry, associatedInterfacePtrInfo);
  }

  BlobRegistryAssociatedPtr.prototype =
      Object.create(BlobRegistryPtr.prototype);
  BlobRegistryAssociatedPtr.prototype.constructor =
      BlobRegistryAssociatedPtr;

  function BlobRegistryProxy(receiver) {
    this.receiver_ = receiver;
  }
  BlobRegistryPtr.prototype.register = function() {
    return BlobRegistryProxy.prototype.register
        .apply(this.ptr.getProxy(), arguments);
  };

  BlobRegistryProxy.prototype.register = function(blob, uuid, contentType, contentDisposition, elements) {
    var params_ = new BlobRegistry_Register_Params();
    params_.blob = blob;
    params_.uuid = uuid;
    params_.contentType = contentType;
    params_.contentDisposition = contentDisposition;
    params_.elements = elements;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBlobRegistry_Register_Name,
          codec.align(BlobRegistry_Register_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BlobRegistry_Register_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BlobRegistry_Register_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  BlobRegistryPtr.prototype.registerFromStream = function() {
    return BlobRegistryProxy.prototype.registerFromStream
        .apply(this.ptr.getProxy(), arguments);
  };

  BlobRegistryProxy.prototype.registerFromStream = function(contentType, contentDisposition, lengthHint, data, progressClient) {
    var params_ = new BlobRegistry_RegisterFromStream_Params();
    params_.contentType = contentType;
    params_.contentDisposition = contentDisposition;
    params_.lengthHint = lengthHint;
    params_.data = data;
    params_.progressClient = progressClient;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kBlobRegistry_RegisterFromStream_Name,
          codec.align(BlobRegistry_RegisterFromStream_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(BlobRegistry_RegisterFromStream_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BlobRegistry_RegisterFromStream_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function BlobRegistryStub(delegate) {
    this.delegate_ = delegate;
  }
  BlobRegistryStub.prototype.register = function(blob, uuid, contentType, contentDisposition, elements) {
    return this.delegate_ && this.delegate_.register && this.delegate_.register(blob, uuid, contentType, contentDisposition, elements);
  }
  BlobRegistryStub.prototype.registerFromStream = function(contentType, contentDisposition, lengthHint, data, progressClient) {
    return this.delegate_ && this.delegate_.registerFromStream && this.delegate_.registerFromStream(contentType, contentDisposition, lengthHint, data, progressClient);
  }

  BlobRegistryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  BlobRegistryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kBlobRegistry_Register_Name:
      var params = reader.decodeStruct(BlobRegistry_Register_Params);
      this.register(params.blob, params.uuid, params.contentType, params.contentDisposition, params.elements).then(function(response) {
        var responseParams =
            new BlobRegistry_Register_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kBlobRegistry_Register_Name,
            codec.align(BlobRegistry_Register_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BlobRegistry_Register_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kBlobRegistry_RegisterFromStream_Name:
      var params = reader.decodeStruct(BlobRegistry_RegisterFromStream_Params);
      this.registerFromStream(params.contentType, params.contentDisposition, params.lengthHint, params.data, params.progressClient).then(function(response) {
        var responseParams =
            new BlobRegistry_RegisterFromStream_ResponseParams();
        responseParams.blob = response.blob;
        var builder = new codec.MessageV2Builder(
            kBlobRegistry_RegisterFromStream_Name,
            codec.align(BlobRegistry_RegisterFromStream_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(BlobRegistry_RegisterFromStream_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateBlobRegistryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kBlobRegistry_Register_Name:
        if (message.expectsResponse())
          paramsClass = BlobRegistry_Register_Params;
      break;
      case kBlobRegistry_RegisterFromStream_Name:
        if (message.expectsResponse())
          paramsClass = BlobRegistry_RegisterFromStream_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateBlobRegistryResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kBlobRegistry_Register_Name:
        if (message.isResponse())
          paramsClass = BlobRegistry_Register_ResponseParams;
        break;
      case kBlobRegistry_RegisterFromStream_Name:
        if (message.isResponse())
          paramsClass = BlobRegistry_RegisterFromStream_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var BlobRegistry = {
    name: 'blink.mojom.BlobRegistry',
    kVersion: 0,
    ptrClass: BlobRegistryPtr,
    proxyClass: BlobRegistryProxy,
    stubClass: BlobRegistryStub,
    validateRequest: validateBlobRegistryRequest,
    validateResponse: validateBlobRegistryResponse,
  };
  BlobRegistryStub.prototype.validator = validateBlobRegistryRequest;
  BlobRegistryProxy.prototype.validator = validateBlobRegistryResponse;
  exports.ProgressClient = ProgressClient;
  exports.ProgressClientPtr = ProgressClientPtr;
  exports.ProgressClientAssociatedPtr = ProgressClientAssociatedPtr;
  exports.BlobRegistry = BlobRegistry;
  exports.BlobRegistryPtr = BlobRegistryPtr;
  exports.BlobRegistryAssociatedPtr = BlobRegistryAssociatedPtr;
})();