// third_party/blink/public/mojom/badging/badging.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BADGING_BADGING_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BADGING_BADGING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/badging/badging.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/badging/badging.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/badging/badging.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class BadgeServiceProxy;

template <typename ImplRefTraits>
class BadgeServiceStub;

class BadgeServiceRequestValidator;


class BLINK_COMMON_EXPORT BadgeService
    : public BadgeServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.BadgeService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BadgeServiceInterfaceBase;
  using Proxy_ = BadgeServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = BadgeServiceStub<ImplRefTraits>;

  using RequestValidator_ = BadgeServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetBadgeMinVersion = 0,
    kClearBadgeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetBadge_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearBadge_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BadgeService() = default;

  virtual void SetBadge(BadgeValuePtr value) = 0;

  virtual void ClearBadge() = 0;
};



class BLINK_COMMON_EXPORT BadgeServiceProxy
    : public BadgeService {
 public:
  using InterfaceType = BadgeService;

  explicit BadgeServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetBadge(BadgeValuePtr value) final;
  
  void ClearBadge() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT BadgeServiceStubDispatch {
 public:
  static bool Accept(BadgeService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BadgeService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BadgeService>>
class BadgeServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BadgeServiceStub() = default;
  ~BadgeServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BadgeServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BadgeServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT BadgeServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT BadgeValue {
 public:
  using DataView = BadgeValueDataView;
  using Data_ = internal::BadgeValue_Data;
  using Tag = Data_::BadgeValue_Tag;

  template <typename... Args>
  static BadgeValuePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |flag|.
  static BadgeValuePtr NewFlag(
      uint8_t value);
  // Construct an instance holding |number|.
  static BadgeValuePtr NewNumber(
      uint64_t value);

  template <typename U>
  static BadgeValuePtr From(const U& u) {
    return mojo::TypeConverter<BadgeValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BadgeValue>::Convert(*this);
  }
  ~BadgeValue();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = BadgeValuePtr>
  BadgeValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, BadgeValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, BadgeValue>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_flag() const { return tag_ == Tag::kFlag; }
  uint8_t get_flag() const {
    CHECK(tag_ == Tag::kFlag);
    return data_.flag;
  }
  void set_flag(uint8_t flag);

  bool is_number() const { return tag_ == Tag::kNumber; }
  uint64_t get_number() const {
    CHECK(tag_ == Tag::kNumber);
    return data_.number;
  }
  void set_number(uint64_t number);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BadgeValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<BadgeValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFlag)>,
        uint8_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNumber)>,
        uint64_t value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    uint8_t flag;
    uint64_t number;
  };

  BadgeValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kFlag)>,
      uint8_t value);
  BadgeValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kNumber)>,
      uint64_t value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
BadgeValuePtr BadgeValue::Clone() const {
  switch (tag_) {
    case Tag::kFlag:
      return NewFlag(
          mojo::Clone(data_.flag));
    case Tag::kNumber:
      return NewNumber(
          mojo::Clone(data_.number));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, BadgeValue>::value>::type*>
bool BadgeValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFlag:
      return mojo::Equals(data_.flag, other.data_.flag);
    case Tag::kNumber:
      return mojo::Equals(data_.number, other.data_.number);
  }

  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::BadgeValue::DataView,
                                        ::blink::mojom::BadgeValuePtr> {
  static bool IsNull(const ::blink::mojom::BadgeValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::BadgeValuePtr* output) { output->reset(); }

  static ::blink::mojom::BadgeValue::Tag GetTag(const ::blink::mojom::BadgeValuePtr& input) {
    return input->which();
  }

  static  uint8_t flag(const ::blink::mojom::BadgeValuePtr& input) {
    return input->get_flag();
  }

  static  uint64_t number(const ::blink::mojom::BadgeValuePtr& input) {
    return input->get_number();
  }

  static bool Read(::blink::mojom::BadgeValue::DataView input, ::blink::mojom::BadgeValuePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BADGING_BADGING_MOJOM_H_