// third_party/blink/public/mojom/badging/badging.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/badging/badging.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/badging/badging.mojom-params-data.h"
#include "third_party/blink/public/mojom/badging/badging.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/badging/badging.mojom-import-headers.h"
#include "third_party/blink/public/mojom/badging/badging.mojom-test-utils.h"


namespace blink::mojom {
BadgeValuePtr
BadgeValue::NewFlag(
    uint8_t value) {
  return BadgeValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFlag)>,
      std::move(value));
}

BadgeValuePtr
BadgeValue::NewNumber(
    uint64_t value) {
  return BadgeValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNumber)>,
      std::move(value));
}

BadgeValue::BadgeValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kFlag)>,
    uint8_t value)
    : tag_(Tag::kFlag),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFlag)>,
            std::move(value)) {}

BadgeValue::BadgeValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kNumber)>,
    uint64_t value)
    : tag_(Tag::kNumber),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNumber)>,
            std::move(value)) {}
BadgeValue::~BadgeValue() {
  DestroyActive();
}

void BadgeValue::set_flag(uint8_t flag) {
  if (tag_ != Tag::kFlag) {
    DestroyActive();
    tag_ = Tag::kFlag;
  }
  data_.flag = flag;
}

void BadgeValue::set_number(uint64_t number) {
  if (tag_ != Tag::kNumber) {
    DestroyActive();
    tag_ = Tag::kNumber;
  }
  data_.number = number;
}


BadgeValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFlag)>,
    uint8_t value)
    : flag(std::move(value)) {}

BadgeValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNumber)>,
    uint64_t value)
    : number(std::move(value)) {}

void BadgeValue::DestroyActive() {
  switch (tag_) {

    case Tag::kFlag:
      std::destroy_at(&data_.flag);
      break;
    case Tag::kNumber:
      std::destroy_at(&data_.number);
      break;
  }
}
size_t BadgeValue::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kFlag:
      return mojo::internal::Hash(seed, data_.flag);
    case Tag::kNumber:
      return mojo::internal::Hash(seed, data_.number);
    default:
      NOTREACHED();
  }
}

bool BadgeValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

BadgeService::IPCStableHashFunction BadgeService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BadgeService>(message.name())) {
    case messages::BadgeService::kSetBadge: {
      return &BadgeService::SetBadge_Sym::IPCStableHash;
    }
    case messages::BadgeService::kClearBadge: {
      return &BadgeService::ClearBadge_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BadgeService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BadgeService>(message.name())) {
      case messages::BadgeService::kSetBadge:
            return "Receive blink::mojom::BadgeService::SetBadge";
      case messages::BadgeService::kClearBadge:
            return "Receive blink::mojom::BadgeService::ClearBadge";
    }
  } else {
    switch (static_cast<messages::BadgeService>(message.name())) {
      case messages::BadgeService::kSetBadge:
            return "Receive reply blink::mojom::BadgeService::SetBadge";
      case messages::BadgeService::kClearBadge:
            return "Receive reply blink::mojom::BadgeService::ClearBadge";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BadgeService::SetBadge_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x98e25759;  // IPCStableHash for blink::mojom::BadgeService::SetBadge
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BadgeService::ClearBadge_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6d2186f3;  // IPCStableHash for blink::mojom::BadgeService::ClearBadge
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BadgeServiceProxy::BadgeServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BadgeServiceProxy::SetBadge(
    BadgeValuePtr in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BadgeService::SetBadge", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type BadgeValuePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BadgeService::kSetBadge), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BadgeService_SetBadge_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->value)>
      value_fragment(params.message());
  value_fragment.Claim(&params->value);
  
  mojo::internal::Serialize<::blink::mojom::BadgeValueDataView>(
    in_value,
    value_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in BadgeService.SetBadge request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BadgeService::Name_);
  message.set_method_name("SetBadge");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BadgeServiceProxy::ClearBadge(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::BadgeService::ClearBadge");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BadgeService::kClearBadge), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BadgeService_ClearBadge_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BadgeService::Name_);
  message.set_method_name("ClearBadge");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BadgeServiceStubDispatch::Accept(
    BadgeService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BadgeService>(message->header()->name)) {
    case messages::BadgeService::kSetBadge: {
      DCHECK(message->is_serialized());
      internal::BadgeService_SetBadge_Params_Data* params =
          reinterpret_cast<internal::BadgeService_SetBadge_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BadgeService.0
      bool success = true;
      BadgeValuePtr p_value{};
      BadgeService_SetBadge_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BadgeService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBadge(        
        std::move(p_value));
      return true;
    }
    case messages::BadgeService::kClearBadge: {
      DCHECK(message->is_serialized());
      internal::BadgeService_ClearBadge_Params_Data* params =
          reinterpret_cast<internal::BadgeService_ClearBadge_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BadgeService.1
      bool success = true;
      BadgeService_ClearBadge_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BadgeService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearBadge(        );
      return true;
    }
  }
  return false;
}

// static
bool BadgeServiceStubDispatch::AcceptWithResponder(
    BadgeService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BadgeService>(message->header()->name)) {
    case messages::BadgeService::kSetBadge: {
      break;
    }
    case messages::BadgeService::kClearBadge: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBadgeServiceValidationInfo[] = {
    { &internal::BadgeService_SetBadge_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BadgeService_ClearBadge_Params_Data::Validate,
     nullptr /* no response */},
};

bool BadgeServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::BadgeService::Name_,
    kBadgeServiceValidationInfo);
}



}  // blink::mojom


namespace mojo {

// static
bool UnionTraits<::blink::mojom::BadgeValue::DataView, ::blink::mojom::BadgeValuePtr>::Read(
    ::blink::mojom::BadgeValue::DataView input,
    ::blink::mojom::BadgeValuePtr* output) {
  using UnionType = ::blink::mojom::BadgeValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFlag: {
      *output = UnionType::NewFlag(input.flag());
      break;
    }
    case Tag::kNumber: {
      *output = UnionType::NewNumber(input.number());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void BadgeServiceInterceptorForTesting::SetBadge(BadgeValuePtr value) {
  GetForwardingInterface()->SetBadge(
    std::move(value)
    );
}
void BadgeServiceInterceptorForTesting::ClearBadge() {
  GetForwardingInterface()->ClearBadge();
}
BadgeServiceAsyncWaiter::BadgeServiceAsyncWaiter(
    BadgeService* proxy) : proxy_(proxy) {}

BadgeServiceAsyncWaiter::~BadgeServiceAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif