// third_party/blink/public/mojom/annotation/annotation.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANNOTATION_ANNOTATION_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANNOTATION_ANNOTATION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/annotation/annotation.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/annotation/annotation.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/annotation/annotation.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class AnnotationAgentProxy;

template <typename ImplRefTraits>
class AnnotationAgentStub;

class AnnotationAgentRequestValidator;


class PLATFORM_EXPORT AnnotationAgent
    : public AnnotationAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AnnotationAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AnnotationAgentInterfaceBase;
  using Proxy_ = AnnotationAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = AnnotationAgentStub<ImplRefTraits>;

  using RequestValidator_ = AnnotationAgentRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kScrollIntoViewMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ScrollIntoView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AnnotationAgent() = default;

  virtual void ScrollIntoView(bool applies_focus) = 0;
};

class AnnotationAgentHostProxy;

template <typename ImplRefTraits>
class AnnotationAgentHostStub;

class AnnotationAgentHostRequestValidator;


class PLATFORM_EXPORT AnnotationAgentHost
    : public AnnotationAgentHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AnnotationAgentHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AnnotationAgentHostInterfaceBase;
  using Proxy_ = AnnotationAgentHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = AnnotationAgentHostStub<ImplRefTraits>;

  using RequestValidator_ = AnnotationAgentHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidFinishAttachmentMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidFinishAttachment_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AnnotationAgentHost() = default;

  virtual void DidFinishAttachment(const ::gfx::Rect& document_relative_rect, AttachmentResult attachment_result) = 0;
};

class AnnotationAgentContainerProxy;

template <typename ImplRefTraits>
class AnnotationAgentContainerStub;

class AnnotationAgentContainerRequestValidator;
class AnnotationAgentContainerResponseValidator;


class PLATFORM_EXPORT AnnotationAgentContainer
    : public AnnotationAgentContainerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AnnotationAgentContainer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AnnotationAgentContainerInterfaceBase;
  using Proxy_ = AnnotationAgentContainerProxy;

  template <typename ImplRefTraits>
  using Stub_ = AnnotationAgentContainerStub<ImplRefTraits>;

  using RequestValidator_ = AnnotationAgentContainerRequestValidator;
  using ResponseValidator_ = AnnotationAgentContainerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateAgentMinVersion = 0,
    kCreateAgentFromSelectionMinVersion = 0,
    kRemoveAgentsOfTypeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateAgent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateAgentFromSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveAgentsOfType_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AnnotationAgentContainer() = default;

  virtual void CreateAgent(::mojo::PendingRemote<AnnotationAgentHost> host_remote, ::mojo::PendingReceiver<AnnotationAgent> agent_receiver, AnnotationType type, SelectorPtr selector, std::optional<int32_t> search_range_start_node_id) = 0;

  using CreateAgentFromSelectionCallback = base::OnceCallback<void(SelectorCreationResultPtr, ::shared_highlighting::LinkGenerationError, ::shared_highlighting::LinkGenerationReadyStatus)>;
  using CreateAgentFromSelectionMojoCallback = base::OnceCallback<void(SelectorCreationResultPtr, ::shared_highlighting::LinkGenerationError, ::shared_highlighting::LinkGenerationReadyStatus)>;

  virtual void CreateAgentFromSelection(AnnotationType type, CreateAgentFromSelectionCallback callback) = 0;

  virtual void RemoveAgentsOfType(AnnotationType type) = 0;
};



class PLATFORM_EXPORT AnnotationAgentProxy
    : public AnnotationAgent {
 public:
  using InterfaceType = AnnotationAgent;

  explicit AnnotationAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ScrollIntoView(bool applies_focus) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT AnnotationAgentHostProxy
    : public AnnotationAgentHost {
 public:
  using InterfaceType = AnnotationAgentHost;

  explicit AnnotationAgentHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidFinishAttachment(const ::gfx::Rect& document_relative_rect, AttachmentResult attachment_result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT AnnotationAgentContainerProxy
    : public AnnotationAgentContainer {
 public:
  using InterfaceType = AnnotationAgentContainer;

  explicit AnnotationAgentContainerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateAgent(::mojo::PendingRemote<AnnotationAgentHost> host_remote, ::mojo::PendingReceiver<AnnotationAgent> agent_receiver, AnnotationType type, SelectorPtr selector, std::optional<int32_t> search_range_start_node_id) final;
  
  void CreateAgentFromSelection(AnnotationType type, CreateAgentFromSelectionCallback callback) final;
  
  void RemoveAgentsOfType(AnnotationType type) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT AnnotationAgentStubDispatch {
 public:
  static bool Accept(AnnotationAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AnnotationAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AnnotationAgent>>
class AnnotationAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AnnotationAgentStub() = default;
  ~AnnotationAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AnnotationAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AnnotationAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AnnotationAgentHostStubDispatch {
 public:
  static bool Accept(AnnotationAgentHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AnnotationAgentHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AnnotationAgentHost>>
class AnnotationAgentHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AnnotationAgentHostStub() = default;
  ~AnnotationAgentHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AnnotationAgentHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AnnotationAgentHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AnnotationAgentContainerStubDispatch {
 public:
  static bool Accept(AnnotationAgentContainer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AnnotationAgentContainer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AnnotationAgentContainer>>
class AnnotationAgentContainerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AnnotationAgentContainerStub() = default;
  ~AnnotationAgentContainerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AnnotationAgentContainerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AnnotationAgentContainerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AnnotationAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT AnnotationAgentHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT AnnotationAgentContainerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT AnnotationAgentContainerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class PLATFORM_EXPORT Selector {
 public:
  using DataView = SelectorDataView;
  using Data_ = internal::Selector_Data;
  using Tag = Data_::Selector_Tag;

  template <typename... Args>
  static SelectorPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |serialized_selector|.
  static SelectorPtr NewSerializedSelector(
      const ::blink::String& value);
  // Construct an instance holding |node_id|.
  static SelectorPtr NewNodeId(
      int32_t value);

  template <typename U>
  static SelectorPtr From(const U& u) {
    return mojo::TypeConverter<SelectorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Selector>::Convert(*this);
  }
  ~Selector();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  Selector(const Selector& other) = delete;
  Selector& operator=(const Selector& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SelectorPtr>
  SelectorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Selector>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, Selector>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_serialized_selector() const { return tag_ == Tag::kSerializedSelector; }
  const ::blink::String& get_serialized_selector() const {
    CHECK(tag_ == Tag::kSerializedSelector);
    return data_.serialized_selector;
  }
  ::blink::String& get_serialized_selector() {
    CHECK(tag_ == Tag::kSerializedSelector);
    return data_.serialized_selector;
  }
  void set_serialized_selector(const ::blink::String& serialized_selector);

  bool is_node_id() const { return tag_ == Tag::kNodeId; }
  int32_t get_node_id() const {
    CHECK(tag_ == Tag::kNodeId);
    return data_.node_id;
  }
  void set_node_id(int32_t node_id);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Selector::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Selector::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSerializedSelector)>,
        const ::blink::String& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNodeId)>,
        int32_t value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::String serialized_selector;
    int32_t node_id;
  };

  Selector(
      std::in_place_index_t<static_cast<size_t>(Tag::kSerializedSelector)>,
      const ::blink::String& value);
  Selector(
      std::in_place_index_t<static_cast<size_t>(Tag::kNodeId)>,
      int32_t value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT SelectorCreationResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectorCreationResult, T>::value>;
  using DataView = SelectorCreationResultDataView;
  using Data_ = internal::SelectorCreationResult_Data;

  template <typename... Args>
  static SelectorCreationResultPtr New(Args&&... args) {
    return SelectorCreationResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectorCreationResultPtr From(const U& u) {
    return mojo::TypeConverter<SelectorCreationResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectorCreationResult>::Convert(*this);
  }


  SelectorCreationResult();

  SelectorCreationResult(
      ::mojo::PendingReceiver<AnnotationAgentHost> host_receiver,
      ::mojo::PendingRemote<AnnotationAgent> agent_remote,
      const ::blink::String& serialized_selector,
      const ::blink::String& selected_text);

SelectorCreationResult(const SelectorCreationResult&) = delete;
SelectorCreationResult& operator=(const SelectorCreationResult&) = delete;

  ~SelectorCreationResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectorCreationResultPtr>
  SelectorCreationResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectorCreationResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectorCreationResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectorCreationResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectorCreationResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectorCreationResult_UnserializedMessageContext<
            UserType, SelectorCreationResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectorCreationResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectorCreationResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectorCreationResult_UnserializedMessageContext<
            UserType, SelectorCreationResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectorCreationResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingReceiver<AnnotationAgentHost> host_receiver;
  
  ::mojo::PendingRemote<AnnotationAgent> agent_remote;
  
  ::blink::String serialized_selector;
  
  ::blink::String selected_text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectorCreationResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectorCreationResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectorCreationResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectorCreationResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
SelectorPtr Selector::Clone() const {
  switch (tag_) {
    case Tag::kSerializedSelector:
      return NewSerializedSelector(
          mojo::Clone(data_.serialized_selector));
    case Tag::kNodeId:
      return NewNodeId(
          mojo::Clone(data_.node_id));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Selector>::value>::type*>
bool Selector::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSerializedSelector:
      return mojo::Equals(data_.serialized_selector, other.data_.serialized_selector);
    case Tag::kNodeId:
      return mojo::Equals(data_.node_id, other.data_.node_id);
  }

  return false;
}
template <typename StructPtrType>
SelectorCreationResultPtr SelectorCreationResult::Clone() const {
  return New(
      mojo::Clone(host_receiver),
      mojo::Clone(agent_remote),
      mojo::Clone(serialized_selector),
      mojo::Clone(selected_text)
  );
}

template <typename T, SelectorCreationResult::EnableIfSame<T>*>
bool SelectorCreationResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->host_receiver, other_struct.host_receiver))
    return false;
  if (!mojo::Equals(this->agent_remote, other_struct.agent_remote))
    return false;
  if (!mojo::Equals(this->serialized_selector, other_struct.serialized_selector))
    return false;
  if (!mojo::Equals(this->selected_text, other_struct.selected_text))
    return false;
  return true;
}

template <typename T, SelectorCreationResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.host_receiver < rhs.host_receiver)
    return true;
  if (rhs.host_receiver < lhs.host_receiver)
    return false;
  if (lhs.agent_remote < rhs.agent_remote)
    return true;
  if (rhs.agent_remote < lhs.agent_remote)
    return false;
  if (lhs.serialized_selector < rhs.serialized_selector)
    return true;
  if (rhs.serialized_selector < lhs.serialized_selector)
    return false;
  if (lhs.selected_text < rhs.selected_text)
    return true;
  if (rhs.selected_text < lhs.selected_text)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SelectorCreationResult::DataView,
                                         ::blink::mojom::blink::SelectorCreationResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::SelectorCreationResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SelectorCreationResultPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::SelectorCreationResult::host_receiver)& host_receiver(
       ::blink::mojom::blink::SelectorCreationResultPtr& input) {
    return input->host_receiver;
  }

  static  decltype(::blink::mojom::blink::SelectorCreationResult::agent_remote)& agent_remote(
       ::blink::mojom::blink::SelectorCreationResultPtr& input) {
    return input->agent_remote;
  }

  static const decltype(::blink::mojom::blink::SelectorCreationResult::serialized_selector)& serialized_selector(
      const ::blink::mojom::blink::SelectorCreationResultPtr& input) {
    return input->serialized_selector;
  }

  static const decltype(::blink::mojom::blink::SelectorCreationResult::selected_text)& selected_text(
      const ::blink::mojom::blink::SelectorCreationResultPtr& input) {
    return input->selected_text;
  }

  static bool Read(::blink::mojom::blink::SelectorCreationResult::DataView input, ::blink::mojom::blink::SelectorCreationResultPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::Selector::DataView,
                                        ::blink::mojom::blink::SelectorPtr> {
  static bool IsNull(const ::blink::mojom::blink::SelectorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SelectorPtr* output) { output->reset(); }

  static ::blink::mojom::blink::Selector::Tag GetTag(const ::blink::mojom::blink::SelectorPtr& input) {
    return input->which();
  }

  static const ::blink::String& serialized_selector(const ::blink::mojom::blink::SelectorPtr& input) {
    return input->get_serialized_selector();
  }

  static  int32_t node_id(const ::blink::mojom::blink::SelectorPtr& input) {
    return input->get_node_id();
  }

  static bool Read(::blink::mojom::blink::Selector::DataView input, ::blink::mojom::blink::SelectorPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANNOTATION_ANNOTATION_MOJOM_BLINK_H_