// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated from template:
//   templates/origin_trials.cc.tmpl
// and input files:
//   ../../third_party/blink/renderer/platform/runtime_enabled_features.json5


#include "third_party/blink/public/common/origin_trials/origin_trials.h"

#include <algorithm>
#include <array>
#include <iterator>
#include <string_view>

#include "base/containers/contains.h"
#include "build/build_config.h"
#include "build/buildflag.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"

// For testing. See OriginTrialsSampleAPIInvalidOS.
#define BUILDFLAG_INTERNAL_IS_INVALID() (0)

namespace blink {

namespace {

static constexpr size_t kMaxFeaturesPerTrial = 3;
static constexpr struct TrialToFeature {
  const char* trial_name;
  unsigned feature_count;
  std::array<mojom::OriginTrialFeature, kMaxFeaturesPerTrial> features;
} kTrialToFeaturesMap[] = {
    { "AdInterestGroupAPI", 1, {mojom::OriginTrialFeature::kAdInterestGroupAPI, } },
    { "AIPromptAPIMultimodalInput", 3, {mojom::OriginTrialFeature::kAIPromptAPI,mojom::OriginTrialFeature::kAIPromptAPIMultimodalInput,mojom::OriginTrialFeature::kBuiltInAIAPI, } },
    { "AIProofreaderAPI", 1, {mojom::OriginTrialFeature::kAIProofreadingAPI, } },
    { "AIRewriterAPI", 1, {mojom::OriginTrialFeature::kAIRewriterAPI, } },
    { "AIWriterAPI", 1, {mojom::OriginTrialFeature::kAIWriterAPI, } },
    { "AppTitle", 1, {mojom::OriginTrialFeature::kAppTitle, } },
    { "AudioContextPlayoutStats", 1, {mojom::OriginTrialFeature::kAudioContextPlayoutStats, } },
    { "AutoDarkMode", 1, {mojom::OriginTrialFeature::kAutoDarkMode, } },
    { "BackForwardCacheExperimentHTTPHeader", 1, {mojom::OriginTrialFeature::kBackForwardCacheExperimentHTTPHeader, } },
    { "BackForwardCacheNotRestoredReasons", 1, {mojom::OriginTrialFeature::kBackForwardCacheNotRestoredReasons, } },
    { "BackgroundPageFreezeOptOut", 1, {mojom::OriginTrialFeature::kBackgroundPageFreezeOptOut, } },
    { "CacheStorageCodeCacheHint", 1, {mojom::OriginTrialFeature::kCacheStorageCodeCacheHint, } },
    { "Canvas2dMesh", 1, {mojom::OriginTrialFeature::kCanvas2dMesh, } },
    { "CanvasTextNg", 1, {mojom::OriginTrialFeature::kCanvasTextNg, } },
    { "ClipboardChangeEvent", 1, {mojom::OriginTrialFeature::kClipboardChangeEvent, } },
    { "CoopRestrictProperties", 1, {mojom::OriginTrialFeature::kCoopRestrictProperties, } },
    { "CrashReportingStorageAPI", 1, {mojom::OriginTrialFeature::kCrashReportingStorageAPI, } },
    { "CSPExtendedScriptSrcHashes", 1, {mojom::OriginTrialFeature::kCSPHashesV1, } },
    { "DeprecateUnloadOptOut", 1, {mojom::OriginTrialFeature::kDeprecateUnloadOptOut, } },
    { "DeviceBoundSessionCredentials", 1, {mojom::OriginTrialFeature::kDeviceBoundSessionCredentials, } },
    { "DeviceBoundSessionCredentials2", 1, {mojom::OriginTrialFeature::kDeviceBoundSessionCredentials2, } },
    { "DigitalGoodsV2", 1, {mojom::OriginTrialFeature::kDigitalGoods, } },
    { "DisableDifferentOriginSubframeDialogSuppression", 1, {mojom::OriginTrialFeature::kDisableDifferentOriginSubframeDialogSuppression, } },
    { "DisableReduceAcceptLanguage", 1, {mojom::OriginTrialFeature::kDisableReduceAcceptLanguage, } },
    { "DocumentIsolationPolicy", 1, {mojom::OriginTrialFeature::kDocumentIsolationPolicy, } },
    { "DocumentPolicyNegotiation", 1, {mojom::OriginTrialFeature::kDocumentPolicyNegotiation, } },
    { "FedCmMultipleIdentityProviders", 1, {mojom::OriginTrialFeature::kFedCmMultipleIdentityProviders, } },
    { "FetchRetry", 1, {mojom::OriginTrialFeature::kFetchRetry, } },
    { "FledgeBiddingAndAuctionServer", 1, {mojom::OriginTrialFeature::kFledgeBiddingAndAuctionServerAPI, } },
    { "Focusgroup", 1, {mojom::OriginTrialFeature::kFocusgroup, } },
    { "HrefTranslate", 1, {mojom::OriginTrialFeature::kHrefTranslate, } },
    { "IncomingCallNotifications", 1, {mojom::OriginTrialFeature::kIncomingCallNotifications, } },
    { "JavaScriptCompileHintsPerFunctionMagic", 1, {mojom::OriginTrialFeature::kJavaScriptCompileHintsPerFunctionMagicRuntime, } },
    { "LanguageDetectionAPI", 1, {mojom::OriginTrialFeature::kLanguageDetectionAPI, } },
    { "LimitThirdPartyCookies", 1, {mojom::OriginTrialFeature::kLimitThirdPartyCookies, } },
    { "LocalNetworkAccessNonSecureContextAllowed", 1, {mojom::OriginTrialFeature::kLocalNetworkAccessNonSecureContextAllowed, } },
    { "MediaCaptureBackgroundBlur", 2, {mojom::OriginTrialFeature::kMediaCaptureBackgroundBlur,mojom::OriginTrialFeature::kMediaCaptureConfigurationChange, } },
    { "MediaPlaybackWhileNotVisiblePermissionPolicy", 1, {mojom::OriginTrialFeature::kMediaPlaybackWhileNotVisiblePermissionPolicy, } },
    { "MediaSourceExtensionsForWebCodecs", 1, {mojom::OriginTrialFeature::kMediaSourceExtensionsForWebCodecs, } },
    { "SoftNavigationHeuristics", 2, {mojom::OriginTrialFeature::kNavigationId,mojom::OriginTrialFeature::kSoftNavigationHeuristics, } },
    { "NotificationTriggers", 1, {mojom::OriginTrialFeature::kNotificationTriggers, } },
    { "Frobulate", 2, {mojom::OriginTrialFeature::kOriginTrialsSampleAPI,mojom::OriginTrialFeature::kProtectedOriginTrialsSampleAPI, } },
    { "FrobulateBrowserReadWrite", 1, {mojom::OriginTrialFeature::kOriginTrialsSampleAPIBrowserReadWrite, } },
    { "FrobulateDeprecation", 1, {mojom::OriginTrialFeature::kOriginTrialsSampleAPIDeprecation, } },
    { "FrobulateExpiryGracePeriod", 1, {mojom::OriginTrialFeature::kOriginTrialsSampleAPIExpiryGracePeriod, } },
    { "FrobulateExpiryGracePeriodThirdParty", 1, {mojom::OriginTrialFeature::kOriginTrialsSampleAPIExpiryGracePeriodThirdParty, } },
    { "FrobulateImplied", 2, {mojom::OriginTrialFeature::kOriginTrialsSampleAPIImplied,mojom::OriginTrialFeature::kProtectedOriginTrialsSampleAPIImplied, } },
    { "FrobulateInvalidOS", 1, {mojom::OriginTrialFeature::kOriginTrialsSampleAPIInvalidOS, } },
    { "FrobulateNavigation", 1, {mojom::OriginTrialFeature::kOriginTrialsSampleAPINavigation, } },
    { "FrobulatePersistentExpiryGracePeriod", 1, {mojom::OriginTrialFeature::kOriginTrialsSampleAPIPersistentExpiryGracePeriod, } },
    { "FrobulatePersistent", 1, {mojom::OriginTrialFeature::kOriginTrialsSampleAPIPersistentFeature, } },
    { "FrobulatePersistentInvalidOS", 1, {mojom::OriginTrialFeature::kOriginTrialsSampleAPIPersistentInvalidOS, } },
    { "FrobulatePersistentThirdPartyDeprecation", 1, {mojom::OriginTrialFeature::kOriginTrialsSampleAPIPersistentThirdPartyDeprecationFeature, } },
    { "FrobulateThirdParty", 1, {mojom::OriginTrialFeature::kOriginTrialsSampleAPIThirdParty, } },
    { "Parakeet", 1, {mojom::OriginTrialFeature::kParakeet, } },
    { "PerformanceNavigationTimingConfidence", 1, {mojom::OriginTrialFeature::kPerformanceNavigationTimingConfidence, } },
    { "PerMethodCanMakePaymentQuota", 1, {mojom::OriginTrialFeature::kPerMethodCanMakePaymentQuota, } },
    { "PermissionElement", 1, {mojom::OriginTrialFeature::kPermissionElement, } },
    { "PNaCl", 1, {mojom::OriginTrialFeature::kPNaCl, } },
    { "PreferredAudioOutputDevices", 1, {mojom::OriginTrialFeature::kPreferredAudioOutputDevices, } },
    { "RenderBlockingFullFrameRate", 1, {mojom::OriginTrialFeature::kRenderBlockingFullFrameRate, } },
    { "RtcAudioJitterBufferMaxPackets", 1, {mojom::OriginTrialFeature::kRtcAudioJitterBufferMaxPackets, } },
    { "RTCEncodedFrameSetMetadata", 1, {mojom::OriginTrialFeature::kRTCEncodedFrameSetMetadata, } },
    { "RTCLegacyCallbackBasedGetStats", 1, {mojom::OriginTrialFeature::kRTCLegacyCallbackBasedGetStats, } },
    { "RTCStatsRelativePacketArrivalDelay", 1, {mojom::OriginTrialFeature::kRTCStatsRelativePacketArrivalDelay, } },
    { "SecurePaymentConfirmationOptOut", 1, {mojom::OriginTrialFeature::kSecurePaymentConfirmationOptOut, } },
    { "ShadowRootReferenceTarget", 1, {mojom::OriginTrialFeature::kShadowRootReferenceTarget, } },
    { "SharedWorkerOnAndroid", 1, {mojom::OriginTrialFeature::kSharedWorker, } },
    { "SharedWorkerExtendedLifetime", 1, {mojom::OriginTrialFeature::kSharedWorkerExtendedLifetime, } },
    { "DisableStandardizedBrowserZoom", 1, {mojom::OriginTrialFeature::kStandardizedBrowserZoomOptOut, } },
    { "TestFeatureForBrowserProcessReadWriteAccessOriginTrial", 1, {mojom::OriginTrialFeature::kTestFeatureForBrowserProcessReadWriteAccessOriginTrial, } },
    { "TextFragmentIdentifiers", 1, {mojom::OriginTrialFeature::kTextFragmentIdentifiers, } },
    { "TopLevelTpcd", 1, {mojom::OriginTrialFeature::kTopLevelTpcd, } },
    { "ForceTouchEventFeatureDetectionForInspector", 1, {mojom::OriginTrialFeature::kTouchEventFeatureDetection, } },
    { "Tpcd", 1, {mojom::OriginTrialFeature::kTpcd, } },
    { "TranslationAPI", 1, {mojom::OriginTrialFeature::kTranslationAPI, } },
    { "UnrestrictedSharedArrayBuffer", 1, {mojom::OriginTrialFeature::kUnrestrictedSharedArrayBuffer, } },
    { "WebAppScopeExtensions", 1, {mojom::OriginTrialFeature::kWebAppScopeExtensions, } },
    { "WebAssemblyCustomDescriptors", 1, {mojom::OriginTrialFeature::kWebAssemblyCustomDescriptors, } },
    { "WebAssemblyJSPromiseIntegration", 1, {mojom::OriginTrialFeature::kWebAssemblyJSPromiseIntegration, } },
    { "WebAuthnAttestationFormats", 1, {mojom::OriginTrialFeature::kWebAuthenticationAttestationFormats, } },
    { "WebAuthenticationImmediateGet", 1, {mojom::OriginTrialFeature::kWebAuthenticationImmediateGet, } },
    { "WebGPUCompatibilityMode", 1, {mojom::OriginTrialFeature::kWebGPUCompatibilityMode, } },
    { "WebTransportCustomCertificates", 1, {mojom::OriginTrialFeature::kWebTransportCustomCertificates, } },
    { "WebXRImageTracking", 1, {mojom::OriginTrialFeature::kWebXRImageTracking, } },
    { "WebXRPlaneDetection", 1, {mojom::OriginTrialFeature::kWebXRPlaneDetection, } },
    // For testing
    { "This trial does not exist", 1, { mojom::OriginTrialFeature::kNonExisting } },
};

} // namespace

bool origin_trials::IsTrialValid(std::string_view trial_name) {
  return base::Contains(kTrialToFeaturesMap, trial_name,
                        &TrialToFeature::trial_name);
}

bool origin_trials::IsTrialEnabledForInsecureContext(std::string_view trial_name) {
  static const char* const kEnabledForInsecureContext[] = {
      "DeprecateUnloadOptOut",
      "DisableDifferentOriginSubframeDialogSuppression",
      "DisableReduceAcceptLanguage",
      "LocalNetworkAccessNonSecureContextAllowed",
      "FrobulateDeprecation",
      "DisableStandardizedBrowserZoom",
  };
  return base::Contains(kEnabledForInsecureContext, trial_name);
}

bool origin_trials::IsTrialEnabledForThirdPartyOrigins(std::string_view trial_name) {
  static const char* const kEnabledForThirdPartyOrigins[] = {
      "AIPromptAPIMultimodalInput",
      "AIProofreaderAPI",
      "AIRewriterAPI",
      "AIWriterAPI",
      "Canvas2dMesh",
      "DeprecateUnloadOptOut",
      "DisableReduceAcceptLanguage",
      "FedCmMultipleIdentityProviders",
      "FetchRetry",
      "FledgeBiddingAndAuctionServer",
      "LanguageDetectionAPI",
      "FrobulateExpiryGracePeriodThirdParty",
      "FrobulatePersistent",
      "FrobulatePersistentInvalidOS",
      "FrobulatePersistentThirdPartyDeprecation",
      "FrobulateThirdParty",
      "PreferredAudioOutputDevices",
      "SecurePaymentConfirmationOptOut",
      "SharedWorkerOnAndroid",
      "SharedWorkerExtendedLifetime",
      "SoftNavigationHeuristics",
      "DisableStandardizedBrowserZoom",
      "Tpcd",
      "TranslationAPI",
      "WebAuthnAttestationFormats",
  };
  return base::Contains(kEnabledForThirdPartyOrigins, trial_name);
}

bool origin_trials::IsTrialEnabledForBrowserProcessReadAccess(std::string_view trial_name) {
  // Select all features that represent origin trials and have
  // browser_process_read_write_access enabled. Determine if that list of
  // features contains the  `trial_name` provided.
  static const char* const kEnabledForBrowserProcessReadWriteAccess[] = {
      "FrobulateBrowserReadWrite",
      "TestFeatureForBrowserProcessReadWriteAccessOriginTrial",
  };
  return base::Contains(kEnabledForBrowserProcessReadWriteAccess, trial_name);
}

bool origin_trials::IsDeprecationTrial(std::string_view trial_name) {
  for (auto feature : FeaturesForTrial(trial_name)) {
    if (GetTrialType(feature) == OriginTrialType::kDeprecation) {
      return true;
    }
  }
  return false;
}

OriginTrialType origin_trials::GetTrialType(mojom::OriginTrialFeature feature) {
  switch (feature) {
    case mojom::OriginTrialFeature::kBackgroundPageFreezeOptOut:
      return OriginTrialType::kDeprecation;
    case mojom::OriginTrialFeature::kDeprecateUnloadOptOut:
      return OriginTrialType::kDeprecation;
    case mojom::OriginTrialFeature::kDisableDifferentOriginSubframeDialogSuppression:
      return OriginTrialType::kDeprecation;
    case mojom::OriginTrialFeature::kDisableReduceAcceptLanguage:
      return OriginTrialType::kDeprecation;
    case mojom::OriginTrialFeature::kLocalNetworkAccessNonSecureContextAllowed:
      return OriginTrialType::kDeprecation;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIDeprecation:
      return OriginTrialType::kDeprecation;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIPersistentThirdPartyDeprecationFeature:
      return OriginTrialType::kDeprecation;
    case mojom::OriginTrialFeature::kStandardizedBrowserZoomOptOut:
      return OriginTrialType::kDeprecation;
    case mojom::OriginTrialFeature::kTopLevelTpcd:
      return OriginTrialType::kDeprecation;
    case mojom::OriginTrialFeature::kTpcd:
      return OriginTrialType::kDeprecation;
    default:
      return OriginTrialType::kDefault;
  }
}


base::span<const mojom::OriginTrialFeature> origin_trials::FeaturesForTrial(
    std::string_view trial_name) {
  auto it = std::ranges::find(kTrialToFeaturesMap, trial_name,
                               &TrialToFeature::trial_name);
  DCHECK(it != std::end(kTrialToFeaturesMap));
  return {it->features.begin(), it->feature_count};
}

base::span<const mojom::OriginTrialFeature> origin_trials::GetImpliedFeatures(
    mojom::OriginTrialFeature feature) {
  if (feature == mojom::OriginTrialFeature::kParakeet) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kAdInterestGroupAPI,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kAIPromptAPIMultimodalInput) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kAIPromptAPI,mojom::OriginTrialFeature::kBuiltInAIAPI,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kAIPromptAPI) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kBuiltInAIAPI,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kAIRewriterAPI) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kBuiltInAIAPI,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kAIWriterAPI) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kBuiltInAIAPI,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kLanguageDetectionAPI) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kBuiltInAIAPI,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kTranslationAPI) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kBuiltInAIAPI,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kAIProofreadingAPI) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kBuiltInAIAPI,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kMediaCaptureBackgroundBlur) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kMediaCaptureConfigurationChange,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kSoftNavigationHeuristics) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kNavigationId,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kOriginTrialsSampleAPI) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kOriginTrialsSampleAPIImplied,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kOriginTrialsSampleAPIInvalidOS) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kOriginTrialsSampleAPIImplied,};
    return implied_features;
  }
  if (feature == mojom::OriginTrialFeature::kProtectedOriginTrialsSampleAPI) {
    static constexpr mojom::OriginTrialFeature implied_features[] = {mojom::OriginTrialFeature::kProtectedOriginTrialsSampleAPIImplied,};
    return implied_features;
  }
  return {};
}

bool origin_trials::FeatureEnabledForOS(mojom::OriginTrialFeature feature) {
  switch (feature) {
    case mojom::OriginTrialFeature::kAdInterestGroupAPI:
      return true;
    case mojom::OriginTrialFeature::kAIPromptAPI:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kAIPromptAPIMultimodalInput:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kAIProofreadingAPI:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kAIRewriterAPI:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kAIWriterAPI:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kAppTitle:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_CHROMEOS)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kAudioContextPlayoutStats:
      return true;
    case mojom::OriginTrialFeature::kAutoDarkMode:
      return true;
    case mojom::OriginTrialFeature::kBackForwardCacheExperimentHTTPHeader:
      return true;
    case mojom::OriginTrialFeature::kBackForwardCacheNotRestoredReasons:
      return true;
    case mojom::OriginTrialFeature::kBackgroundPageFreezeOptOut:
      return true;
    case mojom::OriginTrialFeature::kBuiltInAIAPI:
      return true;
    case mojom::OriginTrialFeature::kCacheStorageCodeCacheHint:
      return true;
    case mojom::OriginTrialFeature::kCanvas2dMesh:
      return true;
    case mojom::OriginTrialFeature::kCanvasTextNg:
      return true;
    case mojom::OriginTrialFeature::kClipboardChangeEvent:
      return true;
    case mojom::OriginTrialFeature::kCoopRestrictProperties:
      return true;
    case mojom::OriginTrialFeature::kCrashReportingStorageAPI:
      return true;
    case mojom::OriginTrialFeature::kCSPHashesV1:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_ANDROID) || BUILDFLAG(IS_CHROMEOS)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kDeprecateUnloadOptOut:
      return true;
    case mojom::OriginTrialFeature::kDeviceBoundSessionCredentials:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_MAC)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kDeviceBoundSessionCredentials2:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_MAC)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kDigitalGoods:
#if BUILDFLAG(IS_ANDROID) || BUILDFLAG(IS_CHROMEOS)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kDisableDifferentOriginSubframeDialogSuppression:
      return true;
    case mojom::OriginTrialFeature::kDisableReduceAcceptLanguage:
      return true;
    case mojom::OriginTrialFeature::kDocumentIsolationPolicy:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_CHROMEOS)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kDocumentPolicyNegotiation:
      return true;
    case mojom::OriginTrialFeature::kFedCmMultipleIdentityProviders:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_CHROMEOS)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kFetchRetry:
      return true;
    case mojom::OriginTrialFeature::kFledgeBiddingAndAuctionServerAPI:
      return true;
    case mojom::OriginTrialFeature::kFocusgroup:
      return true;
    case mojom::OriginTrialFeature::kHrefTranslate:
      return true;
    case mojom::OriginTrialFeature::kIncomingCallNotifications:
#if BUILDFLAG(IS_WIN)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kJavaScriptCompileHintsPerFunctionMagicRuntime:
      return true;
    case mojom::OriginTrialFeature::kLanguageDetectionAPI:
      return true;
    case mojom::OriginTrialFeature::kLimitThirdPartyCookies:
      return true;
    case mojom::OriginTrialFeature::kLocalNetworkAccessNonSecureContextAllowed:
      return true;
    case mojom::OriginTrialFeature::kMediaCaptureBackgroundBlur:
      return true;
    case mojom::OriginTrialFeature::kMediaCaptureConfigurationChange:
      return true;
    case mojom::OriginTrialFeature::kMediaPlaybackWhileNotVisiblePermissionPolicy:
      return true;
    case mojom::OriginTrialFeature::kMediaSourceExtensionsForWebCodecs:
      return true;
    case mojom::OriginTrialFeature::kNavigationId:
      return true;
    case mojom::OriginTrialFeature::kNotificationTriggers:
      return true;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPI:
      return true;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIBrowserReadWrite:
      return true;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIDeprecation:
      return true;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIExpiryGracePeriod:
      return true;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIExpiryGracePeriodThirdParty:
      return true;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIImplied:
      return true;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIInvalidOS:
#if BUILDFLAG(IS_INVALID)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPINavigation:
      return true;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIPersistentExpiryGracePeriod:
      return true;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIPersistentFeature:
      return true;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIPersistentInvalidOS:
#if BUILDFLAG(IS_INVALID)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIPersistentThirdPartyDeprecationFeature:
      return true;
    case mojom::OriginTrialFeature::kOriginTrialsSampleAPIThirdParty:
      return true;
    case mojom::OriginTrialFeature::kParakeet:
      return true;
    case mojom::OriginTrialFeature::kPerformanceNavigationTimingConfidence:
      return true;
    case mojom::OriginTrialFeature::kPerMethodCanMakePaymentQuota:
      return true;
    case mojom::OriginTrialFeature::kPermissionElement:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_FUCHSIA) || BUILDFLAG(IS_CHROMEOS) || BUILDFLAG(IS_ANDROID)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kPNaCl:
      return true;
    case mojom::OriginTrialFeature::kPreferredAudioOutputDevices:
      return true;
    case mojom::OriginTrialFeature::kProtectedOriginTrialsSampleAPI:
      return true;
    case mojom::OriginTrialFeature::kProtectedOriginTrialsSampleAPIImplied:
      return true;
    case mojom::OriginTrialFeature::kRenderBlockingFullFrameRate:
      return true;
    case mojom::OriginTrialFeature::kRtcAudioJitterBufferMaxPackets:
      return true;
    case mojom::OriginTrialFeature::kRTCEncodedFrameSetMetadata:
      return true;
    case mojom::OriginTrialFeature::kRTCLegacyCallbackBasedGetStats:
      return true;
    case mojom::OriginTrialFeature::kRTCStatsRelativePacketArrivalDelay:
      return true;
    case mojom::OriginTrialFeature::kSecurePaymentConfirmationOptOut:
      return true;
    case mojom::OriginTrialFeature::kShadowRootReferenceTarget:
      return true;
    case mojom::OriginTrialFeature::kSharedWorker:
#if BUILDFLAG(IS_ANDROID)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kSharedWorkerExtendedLifetime:
      return true;
    case mojom::OriginTrialFeature::kSoftNavigationHeuristics:
      return true;
    case mojom::OriginTrialFeature::kStandardizedBrowserZoomOptOut:
      return true;
    case mojom::OriginTrialFeature::kTestFeatureForBrowserProcessReadWriteAccessOriginTrial:
      return true;
    case mojom::OriginTrialFeature::kTextFragmentIdentifiers:
      return true;
    case mojom::OriginTrialFeature::kTopLevelTpcd:
      return true;
    case mojom::OriginTrialFeature::kTouchEventFeatureDetection:
      return true;
    case mojom::OriginTrialFeature::kTpcd:
      return true;
    case mojom::OriginTrialFeature::kTranslationAPI:
      return true;
    case mojom::OriginTrialFeature::kUnrestrictedSharedArrayBuffer:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_FUCHSIA) || BUILDFLAG(IS_CHROMEOS)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kWebAppScopeExtensions:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_CHROMEOS)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kWebAssemblyCustomDescriptors:
      return true;
    case mojom::OriginTrialFeature::kWebAssemblyJSPromiseIntegration:
      return true;
    case mojom::OriginTrialFeature::kWebAuthenticationAttestationFormats:
#if BUILDFLAG(IS_ANDROID)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kWebAuthenticationImmediateGet:
#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_CHROMEOS)
      return true;
#else
      return false;
#endif
    case mojom::OriginTrialFeature::kWebGPUCompatibilityMode:
      return true;
    case mojom::OriginTrialFeature::kWebTransportCustomCertificates:
      return true;
    case mojom::OriginTrialFeature::kWebXRImageTracking:
      return true;
    case mojom::OriginTrialFeature::kWebXRPlaneDetection:
      return true;
    // For testing
    case mojom::OriginTrialFeature::kNonExisting:
      return true;
  }
}

} // namespace blink
