// storage/browser/quota/quota_manager_observer.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  BucketInfoSpec as storage_mojom_BucketInfoSpec,
  BucketInfo as storage_mojom_BucketInfo
} from './bucket_info.mojom-webui.js';
import {
  BucketLocatorSpec as storage_mojom_BucketLocatorSpec,
  BucketLocator as storage_mojom_BucketLocator
} from './bucket_locator.mojom-webui.js';







export type QuotaManagerObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<QuotaManagerObserverPendingReceiver>;

export class QuotaManagerObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<QuotaManagerObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<QuotaManagerObserverPendingReceiver>;
  constructor(handle: MojoHandle|QuotaManagerObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'storage.mojom.QuotaManagerObserver',
        scope);
  }
}

export interface QuotaManagerObserverInterface {
  onCreateOrUpdateBucket(bucketInfo: storage_mojom_BucketInfo): void;
  onDeleteBucket(bucketLocator: storage_mojom_BucketLocator): void;
}

export class QuotaManagerObserverRemote implements QuotaManagerObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<QuotaManagerObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<QuotaManagerObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|QuotaManagerObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          QuotaManagerObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onCreateOrUpdateBucket(
      bucketInfo: storage_mojom_BucketInfo): void {
    this.proxy.sendMessage(
        0,
        QuotaManagerObserver_OnCreateOrUpdateBucket_ParamsSpec.$,
        null,
        [
          bucketInfo
        ],
        false);
  }

  onDeleteBucket(
      bucketLocator: storage_mojom_BucketLocator): void {
    this.proxy.sendMessage(
        1,
        QuotaManagerObserver_OnDeleteBucket_ParamsSpec.$,
        null,
        [
          bucketLocator
        ],
        false);
  }
};

/**
 * An object which receives request messages for the QuotaManagerObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class QuotaManagerObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    QuotaManagerObserverRemote, QuotaManagerObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    QuotaManagerObserverRemote, QuotaManagerObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: QuotaManagerObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        QuotaManagerObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        QuotaManagerObserver_OnCreateOrUpdateBucket_ParamsSpec.$,
        null,
        impl.onCreateOrUpdateBucket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        QuotaManagerObserver_OnDeleteBucket_ParamsSpec.$,
        null,
        impl.onDeleteBucket.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class QuotaManagerObserver {
  static get $interfaceName(): string {
    return "storage.mojom.QuotaManagerObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): QuotaManagerObserverRemote {
    let remote = new QuotaManagerObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the QuotaManagerObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class QuotaManagerObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    QuotaManagerObserverRemote, QuotaManagerObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    QuotaManagerObserverRemote, QuotaManagerObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onCreateOrUpdateBucket: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onDeleteBucket: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      QuotaManagerObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onCreateOrUpdateBucket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        QuotaManagerObserver_OnCreateOrUpdateBucket_ParamsSpec.$,
        null,
        this.onCreateOrUpdateBucket.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onDeleteBucket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        QuotaManagerObserver_OnDeleteBucket_ParamsSpec.$,
        null,
        this.onDeleteBucket.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const QuotaManagerObserver_OnCreateOrUpdateBucket_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaManagerObserver_OnDeleteBucket_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface QuotaManagerObserver_OnCreateOrUpdateBucket_ParamsMojoType {
  bucketInfo: storage_mojom_BucketInfo;
}


export type QuotaManagerObserver_OnCreateOrUpdateBucket_Params = QuotaManagerObserver_OnCreateOrUpdateBucket_ParamsMojoType;
mojo.internal.Struct<QuotaManagerObserver_OnCreateOrUpdateBucket_ParamsMojoType>(
    QuotaManagerObserver_OnCreateOrUpdateBucket_ParamsSpec.$,
    'QuotaManagerObserver_OnCreateOrUpdateBucket_Params',
    [
      mojo.internal.StructField<QuotaManagerObserver_OnCreateOrUpdateBucket_ParamsMojoType, storage_mojom_BucketInfo>(
        'bucketInfo', 0,
        0,
        storage_mojom_BucketInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface QuotaManagerObserver_OnDeleteBucket_ParamsMojoType {
  bucketLocator: storage_mojom_BucketLocator;
}


export type QuotaManagerObserver_OnDeleteBucket_Params = QuotaManagerObserver_OnDeleteBucket_ParamsMojoType;
mojo.internal.Struct<QuotaManagerObserver_OnDeleteBucket_ParamsMojoType>(
    QuotaManagerObserver_OnDeleteBucket_ParamsSpec.$,
    'QuotaManagerObserver_OnDeleteBucket_Params',
    [
      mojo.internal.StructField<QuotaManagerObserver_OnDeleteBucket_ParamsMojoType, storage_mojom_BucketLocator>(
        'bucketLocator', 0,
        0,
        storage_mojom_BucketLocatorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



