// services/webnn/public/mojom/webnn_graph_builder.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/webnn/public/mojom/webnn_graph_builder.mojom-features.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_graph_builder.mojom-shared.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_graph_builder.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom.h"
#include "services/webnn/public/mojom/webnn_device.mojom-forward.h"
#include "services/webnn/public/mojom/webnn_error.mojom.h"
#include "services/webnn/public/mojom/webnn_graph.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/types/expected.h"
#include "base/component_export.h"




namespace webnn::mojom {

class WebNNGraphBuilderProxy;

template <typename ImplRefTraits>
class WebNNGraphBuilderStub;

class WebNNGraphBuilderRequestValidator;
class WebNNGraphBuilderResponseValidator;


class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNGraphBuilder
    : public WebNNGraphBuilderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "webnn.mojom.WebNNGraphBuilder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebNNGraphBuilderInterfaceBase;
  using Proxy_ = WebNNGraphBuilderProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebNNGraphBuilderStub<ImplRefTraits>;

  using RequestValidator_ = WebNNGraphBuilderRequestValidator;
  using ResponseValidator_ = WebNNGraphBuilderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreatePendingConstantMinVersion = 0,
    kCreateGraphMinVersion = 0,
    kIsValidGraphForTestingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePendingConstant_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateGraph_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsValidGraphForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebNNGraphBuilder() = default;

  virtual void CreatePendingConstant(const ::blink::WebNNPendingConstantToken& constant_handle, ::webnn::OperandDataType data_type, ::mojo_base::BigBuffer data) = 0;

  using CreateGraphCallback = base::OnceCallback<void(base::expected<
  CreateGraphSuccessPtr,
  ::webnn::mojom::ErrorPtr>)>;
  using CreateGraphResult = base::expected<
  CreateGraphSuccessPtr,
  ::webnn::mojom::ErrorPtr>;
  using CreateGraphMojoCallback = base::OnceCallback<void(WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr)>;

  virtual void CreateGraph(::webnn::mojom::GraphInfoPtr graph_info, CreateGraphCallback callback) = 0;

  using IsValidGraphForTestingCallback = base::OnceCallback<void(bool)>;
  using IsValidGraphForTestingMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsValidGraphForTesting(const ::webnn::ContextProperties& context_properties, ::webnn::mojom::GraphInfoPtr graph_info, IsValidGraphForTestingCallback callback) = 0;
};



class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNGraphBuilderProxy
    : public WebNNGraphBuilder {
 public:
  using InterfaceType = WebNNGraphBuilder;

  explicit WebNNGraphBuilderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePendingConstant(const ::blink::WebNNPendingConstantToken& constant_handle, ::webnn::OperandDataType data_type, ::mojo_base::BigBuffer data) final;
  
  void CreateGraph(::webnn::mojom::GraphInfoPtr graph_info, CreateGraphCallback callback) final;
  
  void IsValidGraphForTesting(const ::webnn::ContextProperties& context_properties, ::webnn::mojom::GraphInfoPtr graph_info, IsValidGraphForTestingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNGraphBuilderStubDispatch {
 public:
  static bool Accept(WebNNGraphBuilder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebNNGraphBuilder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebNNGraphBuilder>>
class WebNNGraphBuilderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebNNGraphBuilderStub() = default;
  ~WebNNGraphBuilderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebNNGraphBuilderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebNNGraphBuilderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNGraphBuilderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNGraphBuilderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNGraphBuilder_CreateGraph_ResponseParam_Result {
 public:
  using DataView = WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView;
  using Data_ = internal::WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data;
  using Tag = Data_::WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Tag;

  template <typename... Args>
  static WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr NewSuccess(
      CreateGraphSuccessPtr value);
  // Construct an instance holding |failure|.
  static WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr NewFailure(
      ::webnn::mojom::ErrorPtr value);

  template <typename U>
  static WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebNNGraphBuilder_CreateGraph_ResponseParam_Result>::Convert(*this);
  }
  ~WebNNGraphBuilder_CreateGraph_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WebNNGraphBuilder_CreateGraph_ResponseParam_Result(const WebNNGraphBuilder_CreateGraph_ResponseParam_Result& other) = delete;
  WebNNGraphBuilder_CreateGraph_ResponseParam_Result& operator=(const WebNNGraphBuilder_CreateGraph_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr>
  WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebNNGraphBuilder_CreateGraph_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebNNGraphBuilder_CreateGraph_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const CreateGraphSuccessPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  CreateGraphSuccessPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(CreateGraphSuccessPtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const ::webnn::mojom::ErrorPtr& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  ::webnn::mojom::ErrorPtr& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::webnn::mojom::ErrorPtr failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebNNGraphBuilder_CreateGraph_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebNNGraphBuilder_CreateGraph_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        CreateGraphSuccessPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::webnn::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    CreateGraphSuccessPtr success;
    ::webnn::mojom::ErrorPtr failure;
  };

  WebNNGraphBuilder_CreateGraph_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      CreateGraphSuccessPtr value);
  WebNNGraphBuilder_CreateGraph_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::webnn::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class COMPONENT_EXPORT(WEBNN_MOJOM) CreateGraphSuccess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateGraphSuccess, T>::value>;
  using DataView = CreateGraphSuccessDataView;
  using Data_ = internal::CreateGraphSuccess_Data;

  template <typename... Args>
  static CreateGraphSuccessPtr New(Args&&... args) {
    return CreateGraphSuccessPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateGraphSuccessPtr From(const U& u) {
    return mojo::TypeConverter<CreateGraphSuccessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateGraphSuccess>::Convert(*this);
  }


  CreateGraphSuccess();

  CreateGraphSuccess(
      ::mojo::PendingAssociatedRemote<::webnn::mojom::WebNNGraph> graph_remote,
      std::vector<::webnn::mojom::Device> devices);

CreateGraphSuccess(const CreateGraphSuccess&) = delete;
CreateGraphSuccess& operator=(const CreateGraphSuccess&) = delete;

  ~CreateGraphSuccess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateGraphSuccessPtr>
  CreateGraphSuccessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateGraphSuccess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateGraphSuccess::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateGraphSuccess::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateGraphSuccess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateGraphSuccess_UnserializedMessageContext<
            UserType, CreateGraphSuccess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateGraphSuccess::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateGraphSuccess::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateGraphSuccess_UnserializedMessageContext<
            UserType, CreateGraphSuccess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateGraphSuccess::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedRemote<::webnn::mojom::WebNNGraph> graph_remote;
  
  std::vector<::webnn::mojom::Device> devices;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateGraphSuccess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateGraphSuccess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateGraphSuccess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateGraphSuccess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr WebNNGraphBuilder_CreateGraph_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebNNGraphBuilder_CreateGraph_ResponseParam_Result>::value>::type*>
bool WebNNGraphBuilder_CreateGraph_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename StructPtrType>
CreateGraphSuccessPtr CreateGraphSuccess::Clone() const {
  return New(
      mojo::Clone(graph_remote),
      mojo::Clone(devices)
  );
}

template <typename T, CreateGraphSuccess::EnableIfSame<T>*>
bool CreateGraphSuccess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->graph_remote, other_struct.graph_remote))
    return false;
  if (!mojo::Equals(this->devices, other_struct.devices))
    return false;
  return true;
}

template <typename T, CreateGraphSuccess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.graph_remote < rhs.graph_remote)
    return true;
  if (rhs.graph_remote < lhs.graph_remote)
    return false;
  if (lhs.devices < rhs.devices)
    return true;
  if (rhs.devices < lhs.devices)
    return false;
  return false;
}


}  // webnn::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::CreateGraphSuccess::DataView,
                                         ::webnn::mojom::CreateGraphSuccessPtr> {
  static bool IsNull(const ::webnn::mojom::CreateGraphSuccessPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::CreateGraphSuccessPtr* output) { output->reset(); }

  static  decltype(::webnn::mojom::CreateGraphSuccess::graph_remote)& graph_remote(
       ::webnn::mojom::CreateGraphSuccessPtr& input) {
    return input->graph_remote;
  }

  static const decltype(::webnn::mojom::CreateGraphSuccess::devices)& devices(
      const ::webnn::mojom::CreateGraphSuccessPtr& input) {
    return input->devices;
  }

  static bool Read(::webnn::mojom::CreateGraphSuccess::DataView input, ::webnn::mojom::CreateGraphSuccessPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) UnionTraits<::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_Result::DataView,
                                        ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr> {
  static bool IsNull(const ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_Result::Tag GetTag(const ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  ::webnn::mojom::CreateGraphSuccessPtr& success( ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::webnn::mojom::ErrorPtr& failure(const ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_Result::DataView input, ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_H_