// services/webnn/public/mojom/webnn_graph_builder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/webnn/public/mojom/webnn_graph_builder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_graph_builder.mojom-params-data.h"
#include "services/webnn/public/mojom/webnn_graph_builder.mojom-shared-message-ids.h"

#include "services/webnn/public/mojom/webnn_graph_builder.mojom-import-headers.h"
#include "services/webnn/public/mojom/webnn_graph_builder.mojom-test-utils.h"


namespace webnn::mojom {
CreateGraphSuccess::CreateGraphSuccess()
    : graph_remote(),
      devices() {}

CreateGraphSuccess::CreateGraphSuccess(
    ::mojo::PendingAssociatedRemote<::webnn::mojom::WebNNGraph> graph_remote_in,
    std::vector<::webnn::mojom::Device> devices_in)
    : graph_remote(std::move(graph_remote_in)),
      devices(std::move(devices_in)) {}

CreateGraphSuccess::~CreateGraphSuccess() = default;

void CreateGraphSuccess::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "graph_remote"), this->graph_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<::webnn::mojom::WebNNGraph>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devices"), this->devices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::webnn::mojom::Device>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateGraphSuccess::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr
WebNNGraphBuilder_CreateGraph_ResponseParam_Result::NewSuccess(
    CreateGraphSuccessPtr value) {
  return WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr
WebNNGraphBuilder_CreateGraph_ResponseParam_Result::NewFailure(
    ::webnn::mojom::ErrorPtr value) {
  return WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

WebNNGraphBuilder_CreateGraph_ResponseParam_Result::WebNNGraphBuilder_CreateGraph_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    CreateGraphSuccessPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

WebNNGraphBuilder_CreateGraph_ResponseParam_Result::WebNNGraphBuilder_CreateGraph_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::webnn::mojom::ErrorPtr value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
WebNNGraphBuilder_CreateGraph_ResponseParam_Result::~WebNNGraphBuilder_CreateGraph_ResponseParam_Result() {
  DestroyActive();
}

void WebNNGraphBuilder_CreateGraph_ResponseParam_Result::set_success(CreateGraphSuccessPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) CreateGraphSuccessPtr(
        std::move(success));
  }
}

void WebNNGraphBuilder_CreateGraph_ResponseParam_Result::set_failure(::webnn::mojom::ErrorPtr failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) ::webnn::mojom::ErrorPtr(
        std::move(failure));
  }
}


WebNNGraphBuilder_CreateGraph_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    CreateGraphSuccessPtr value)
    : success(std::move(value)) {}

WebNNGraphBuilder_CreateGraph_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::webnn::mojom::ErrorPtr value)
    : failure(std::move(value)) {}

void WebNNGraphBuilder_CreateGraph_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool WebNNGraphBuilder_CreateGraph_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

WebNNGraphBuilder::IPCStableHashFunction WebNNGraphBuilder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebNNGraphBuilder>(message.name())) {
    case messages::WebNNGraphBuilder::kCreatePendingConstant: {
      return &WebNNGraphBuilder::CreatePendingConstant_Sym::IPCStableHash;
    }
    case messages::WebNNGraphBuilder::kCreateGraph: {
      return &WebNNGraphBuilder::CreateGraph_Sym::IPCStableHash;
    }
    case messages::WebNNGraphBuilder::kIsValidGraphForTesting: {
      return &WebNNGraphBuilder::IsValidGraphForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebNNGraphBuilder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebNNGraphBuilder>(message.name())) {
      case messages::WebNNGraphBuilder::kCreatePendingConstant:
            return "Receive webnn::mojom::WebNNGraphBuilder::CreatePendingConstant";
      case messages::WebNNGraphBuilder::kCreateGraph:
            return "Receive webnn::mojom::WebNNGraphBuilder::CreateGraph";
      case messages::WebNNGraphBuilder::kIsValidGraphForTesting:
            return "Receive webnn::mojom::WebNNGraphBuilder::IsValidGraphForTesting";
    }
  } else {
    switch (static_cast<messages::WebNNGraphBuilder>(message.name())) {
      case messages::WebNNGraphBuilder::kCreatePendingConstant:
            return "Receive reply webnn::mojom::WebNNGraphBuilder::CreatePendingConstant";
      case messages::WebNNGraphBuilder::kCreateGraph:
            return "Receive reply webnn::mojom::WebNNGraphBuilder::CreateGraph";
      case messages::WebNNGraphBuilder::kIsValidGraphForTesting:
            return "Receive reply webnn::mojom::WebNNGraphBuilder::IsValidGraphForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebNNGraphBuilder::CreatePendingConstant_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8a0c7632;  // IPCStableHash for webnn::mojom::WebNNGraphBuilder::CreatePendingConstant
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebNNGraphBuilder::CreateGraph_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x77bbbefe;  // IPCStableHash for webnn::mojom::WebNNGraphBuilder::CreateGraph
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebNNGraphBuilder::IsValidGraphForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb42cfda;  // IPCStableHash for webnn::mojom::WebNNGraphBuilder::IsValidGraphForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebNNGraphBuilder_CreateGraph_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebNNGraphBuilder_CreateGraph_ForwardToCallback(
      WebNNGraphBuilder::CreateGraphCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebNNGraphBuilder_CreateGraph_ForwardToCallback(const WebNNGraphBuilder_CreateGraph_ForwardToCallback&) = delete;
  WebNNGraphBuilder_CreateGraph_ForwardToCallback& operator=(const WebNNGraphBuilder_CreateGraph_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebNNGraphBuilder::CreateGraphCallback callback_;
};

class WebNNGraphBuilder_IsValidGraphForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebNNGraphBuilder_IsValidGraphForTesting_ForwardToCallback(
      WebNNGraphBuilder::IsValidGraphForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebNNGraphBuilder_IsValidGraphForTesting_ForwardToCallback(const WebNNGraphBuilder_IsValidGraphForTesting_ForwardToCallback&) = delete;
  WebNNGraphBuilder_IsValidGraphForTesting_ForwardToCallback& operator=(const WebNNGraphBuilder_IsValidGraphForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebNNGraphBuilder::IsValidGraphForTestingCallback callback_;
};

WebNNGraphBuilderProxy::WebNNGraphBuilderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebNNGraphBuilderProxy::CreatePendingConstant(
    const ::blink::WebNNPendingConstantToken& in_constant_handle, ::webnn::OperandDataType in_data_type, ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webnn::mojom::WebNNGraphBuilder::CreatePendingConstant", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("constant_handle"), in_constant_handle,
                        "<value of type const ::blink::WebNNPendingConstantToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_type"), in_data_type,
                        "<value of type ::webnn::OperandDataType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNGraphBuilder::kCreatePendingConstant), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNGraphBuilder_CreatePendingConstant_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->constant_handle)::BaseType> constant_handle_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebNNPendingConstantTokenDataView>(
    in_constant_handle,
    constant_handle_fragment);

  params->constant_handle.Set(
      constant_handle_fragment.is_null() ? nullptr : constant_handle_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->constant_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null constant_handle in WebNNGraphBuilder.CreatePendingConstant request");

  
  mojo::internal::Serialize<::webnn::mojom::DataType>(
    in_data_type,
    &params->data_type);
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in WebNNGraphBuilder.CreatePendingConstant request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNGraphBuilder::Name_);
  message.set_method_name("CreatePendingConstant");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebNNGraphBuilderProxy::CreateGraph(
    ::webnn::mojom::GraphInfoPtr in_graph_info, CreateGraphCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webnn::mojom::WebNNGraphBuilder::CreateGraph", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("graph_info"), in_graph_info,
                        "<value of type ::webnn::mojom::GraphInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNGraphBuilder::kCreateGraph), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNGraphBuilder_CreateGraph_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->graph_info)::BaseType> graph_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::webnn::mojom::GraphInfoDataView>(
    in_graph_info,
    graph_info_fragment);

  params->graph_info.Set(
      graph_info_fragment.is_null() ? nullptr : graph_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->graph_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null graph_info in WebNNGraphBuilder.CreateGraph request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNGraphBuilder::Name_);
  message.set_method_name("CreateGraph");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebNNGraphBuilder_CreateGraph_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebNNGraphBuilderProxy::IsValidGraphForTesting(
    const ::webnn::ContextProperties& in_context_properties, ::webnn::mojom::GraphInfoPtr in_graph_info, IsValidGraphForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webnn::mojom::WebNNGraphBuilder::IsValidGraphForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_properties"), in_context_properties,
                        "<value of type const ::webnn::ContextProperties&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("graph_info"), in_graph_info,
                        "<value of type ::webnn::mojom::GraphInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNGraphBuilder::kIsValidGraphForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNGraphBuilder_IsValidGraphForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->context_properties)::BaseType> context_properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::webnn::mojom::ContextPropertiesDataView>(
    in_context_properties,
    context_properties_fragment);

  params->context_properties.Set(
      context_properties_fragment.is_null() ? nullptr : context_properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->context_properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null context_properties in WebNNGraphBuilder.IsValidGraphForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->graph_info)::BaseType> graph_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::webnn::mojom::GraphInfoDataView>(
    in_graph_info,
    graph_info_fragment);

  params->graph_info.Set(
      graph_info_fragment.is_null() ? nullptr : graph_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->graph_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null graph_info in WebNNGraphBuilder.IsValidGraphForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNGraphBuilder::Name_);
  message.set_method_name("IsValidGraphForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebNNGraphBuilder_IsValidGraphForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebNNGraphBuilder_CreateGraph_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebNNGraphBuilder::CreateGraphCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebNNGraphBuilder_CreateGraph_ProxyToResponder> proxy(
        new WebNNGraphBuilder_CreateGraph_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&WebNNGraphBuilder_CreateGraph_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr Transform(base::expected<
  CreateGraphSuccessPtr,
  ::webnn::mojom::ErrorPtr> in) {
    return in.has_value() ? ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~WebNNGraphBuilder_CreateGraph_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebNNGraphBuilder_CreateGraph_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebNNGraphBuilder::CreateGraphCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr in_result);
};

bool WebNNGraphBuilder_CreateGraph_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebNNGraphBuilder_CreateGraph_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebNNGraphBuilder_CreateGraph_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebNNGraphBuilder.1
  bool success = true;
  WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr p_result{};
  WebNNGraphBuilder_CreateGraph_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebNNGraphBuilder::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void WebNNGraphBuilder_CreateGraph_ProxyToResponder::Run(
    WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webnn::mojom::WebNNGraphBuilder::CreateGraph", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNGraphBuilder::kCreateGraph), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNGraphBuilder_CreateGraph_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNGraphBuilder::Name_);
  message.set_method_name("CreateGraph");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebNNGraphBuilder_IsValidGraphForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebNNGraphBuilder::IsValidGraphForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebNNGraphBuilder_IsValidGraphForTesting_ProxyToResponder> proxy(
        new WebNNGraphBuilder_IsValidGraphForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebNNGraphBuilder_IsValidGraphForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebNNGraphBuilder_IsValidGraphForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebNNGraphBuilder_IsValidGraphForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebNNGraphBuilder::IsValidGraphForTestingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_valid);
};

bool WebNNGraphBuilder_IsValidGraphForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebNNGraphBuilder.2
  bool success = true;
  bool p_is_valid{};
  WebNNGraphBuilder_IsValidGraphForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_valid = input_data_view.is_valid();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebNNGraphBuilder::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_valid));
  }
  return true;
}

void WebNNGraphBuilder_IsValidGraphForTesting_ProxyToResponder::Run(
    bool in_is_valid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webnn::mojom::WebNNGraphBuilder::IsValidGraphForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_valid"), in_is_valid,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNGraphBuilder::kIsValidGraphForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_valid = in_is_valid;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNGraphBuilder::Name_);
  message.set_method_name("IsValidGraphForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebNNGraphBuilderStubDispatch::Accept(
    WebNNGraphBuilder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebNNGraphBuilder>(message->header()->name)) {
    case messages::WebNNGraphBuilder::kCreatePendingConstant: {
      DCHECK(message->is_serialized());
      internal::WebNNGraphBuilder_CreatePendingConstant_Params_Data* params =
          reinterpret_cast<internal::WebNNGraphBuilder_CreatePendingConstant_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebNNGraphBuilder.0
      bool success = true;
      ::blink::WebNNPendingConstantToken p_constant_handle{};
      ::webnn::OperandDataType p_data_type{};
      ::mojo_base::BigBuffer p_data{};
      WebNNGraphBuilder_CreatePendingConstant_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConstantHandle(&p_constant_handle))
        success = false;
      if (success && !input_data_view.ReadDataType(&p_data_type))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNGraphBuilder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePendingConstant(        
        std::move(p_constant_handle), 
        std::move(p_data_type), 
        std::move(p_data));
      return true;
    }
    case messages::WebNNGraphBuilder::kCreateGraph: {
      break;
    }
    case messages::WebNNGraphBuilder::kIsValidGraphForTesting: {
      break;
    }
  }
  return false;
}

// static
bool WebNNGraphBuilderStubDispatch::AcceptWithResponder(
    WebNNGraphBuilder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebNNGraphBuilder>(message->header()->name)) {
    case messages::WebNNGraphBuilder::kCreatePendingConstant: {
      break;
    }
    case messages::WebNNGraphBuilder::kCreateGraph: {
      internal::WebNNGraphBuilder_CreateGraph_Params_Data* params =
          reinterpret_cast<
              internal::WebNNGraphBuilder_CreateGraph_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebNNGraphBuilder.1
      bool success = true;
      ::webnn::mojom::GraphInfoPtr p_graph_info{};
      WebNNGraphBuilder_CreateGraph_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGraphInfo(&p_graph_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNGraphBuilder::Name_, 1, false);
        return false;
      }
      auto callback =
          WebNNGraphBuilder_CreateGraph_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGraph(        
        std::move(p_graph_info), std::move(callback));
      return true;
    }
    case messages::WebNNGraphBuilder::kIsValidGraphForTesting: {
      internal::WebNNGraphBuilder_IsValidGraphForTesting_Params_Data* params =
          reinterpret_cast<
              internal::WebNNGraphBuilder_IsValidGraphForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebNNGraphBuilder.2
      bool success = true;
      ::webnn::ContextProperties p_context_properties{mojo::internal::DefaultConstructTag()};
      ::webnn::mojom::GraphInfoPtr p_graph_info{};
      WebNNGraphBuilder_IsValidGraphForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContextProperties(&p_context_properties))
        success = false;
      if (success && !input_data_view.ReadGraphInfo(&p_graph_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNGraphBuilder::Name_, 2, false);
        return false;
      }
      auto callback =
          WebNNGraphBuilder_IsValidGraphForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsValidGraphForTesting(        
        std::move(p_context_properties), 
        std::move(p_graph_info), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebNNGraphBuilderValidationInfo[] = {
    { &internal::WebNNGraphBuilder_CreatePendingConstant_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebNNGraphBuilder_CreateGraph_Params_Data::Validate,
     &internal::WebNNGraphBuilder_CreateGraph_ResponseParams_Data::Validate},
    { &internal::WebNNGraphBuilder_IsValidGraphForTesting_Params_Data::Validate,
     &internal::WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data::Validate},
};

bool WebNNGraphBuilderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::webnn::mojom::WebNNGraphBuilder::Name_,
    kWebNNGraphBuilderValidationInfo);
}

bool WebNNGraphBuilderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::webnn::mojom::WebNNGraphBuilder::Name_,
    kWebNNGraphBuilderValidationInfo);
}


}  // webnn::mojom


namespace mojo {


// static
bool StructTraits<::webnn::mojom::CreateGraphSuccess::DataView, ::webnn::mojom::CreateGraphSuccessPtr>::Read(
    ::webnn::mojom::CreateGraphSuccess::DataView input,
    ::webnn::mojom::CreateGraphSuccessPtr* output) {
  bool success = true;
  ::webnn::mojom::CreateGraphSuccessPtr result(::webnn::mojom::CreateGraphSuccess::New());
  
      if (success) {
        result->graph_remote =
            input.TakeGraphRemote<decltype(result->graph_remote)>();
      }
      if (success && !input.ReadDevices(&result->devices))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_Result::DataView, ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr>::Read(
    ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_Result::DataView input,
    ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultPtr* output) {
  using UnionType = ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::webnn::mojom::CreateGraphSuccessPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::webnn::mojom::ErrorPtr result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace webnn::mojom {


void WebNNGraphBuilderInterceptorForTesting::CreatePendingConstant(const ::blink::WebNNPendingConstantToken& constant_handle, ::webnn::OperandDataType data_type, ::mojo_base::BigBuffer data) {
  GetForwardingInterface()->CreatePendingConstant(
    std::move(constant_handle)
    , 
    std::move(data_type)
    , 
    std::move(data)
    );
}
void WebNNGraphBuilderInterceptorForTesting::CreateGraph(::webnn::mojom::GraphInfoPtr graph_info, CreateGraphCallback callback) {
  GetForwardingInterface()->CreateGraph(
    std::move(graph_info)
    , std::move(callback));
}
void WebNNGraphBuilderInterceptorForTesting::IsValidGraphForTesting(const ::webnn::ContextProperties& context_properties, ::webnn::mojom::GraphInfoPtr graph_info, IsValidGraphForTestingCallback callback) {
  GetForwardingInterface()->IsValidGraphForTesting(
    std::move(context_properties)
    , 
    std::move(graph_info)
    , std::move(callback));
}
WebNNGraphBuilderAsyncWaiter::WebNNGraphBuilderAsyncWaiter(
    WebNNGraphBuilder* proxy) : proxy_(proxy) {}

WebNNGraphBuilderAsyncWaiter::~WebNNGraphBuilderAsyncWaiter() = default;


void WebNNGraphBuilderAsyncWaiter::IsValidGraphForTesting(
    const ::webnn::ContextProperties& context_properties, ::webnn::mojom::GraphInfoPtr graph_info, bool* out_is_valid) {
  base::RunLoop loop;
  proxy_->IsValidGraphForTesting(
      std::move(context_properties),
      std::move(graph_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_valid
,
             bool is_valid) {*out_is_valid = std::move(is_valid);
            loop->Quit();
          },
          &loop,
          out_is_valid));
  loop.Run();
}

bool WebNNGraphBuilderAsyncWaiter::IsValidGraphForTesting(
    const ::webnn::ContextProperties& context_properties, ::webnn::mojom::GraphInfoPtr graph_info) {
  bool async_wait_result;
  IsValidGraphForTesting(std::move(context_properties),std::move(graph_info),&async_wait_result);
  return async_wait_result;
}






}  // webnn::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif