// services/webnn/public/mojom/webnn_graph.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/webnn/public/mojom/webnn_graph.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_graph.mojom-params-data.h"
namespace webnn {
namespace mojom {

NOINLINE static const char* DataTypeToStringHelper(DataType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DataType::kFloat32:
      return "kFloat32";
    case DataType::kFloat16:
      return "kFloat16";
    case DataType::kInt32:
      return "kInt32";
    case DataType::kUint32:
      return "kUint32";
    case DataType::kInt64:
      return "kInt64";
    case DataType::kUint64:
      return "kUint64";
    case DataType::kInt8:
      return "kInt8";
    case DataType::kUint8:
      return "kUint8";
    case DataType::kInt4:
      return "kInt4";
    case DataType::kUint4:
      return "kUint4";
    default:
      return nullptr;
  }
}

std::string DataTypeToString(DataType value) {
  const char *str = DataTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DataType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DataType value) {
  return os << DataTypeToString(value);
}

NOINLINE static const char* RecurrentNetworkActivationToStringHelper(RecurrentNetworkActivation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RecurrentNetworkActivation::kRelu:
      return "kRelu";
    case RecurrentNetworkActivation::kSigmoid:
      return "kSigmoid";
    case RecurrentNetworkActivation::kTanh:
      return "kTanh";
    default:
      return nullptr;
  }
}

std::string RecurrentNetworkActivationToString(RecurrentNetworkActivation value) {
  const char *str = RecurrentNetworkActivationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RecurrentNetworkActivation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RecurrentNetworkActivation value) {
  return os << RecurrentNetworkActivationToString(value);
}

NOINLINE static const char* RecurrentNetworkDirectionToStringHelper(RecurrentNetworkDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RecurrentNetworkDirection::kForward:
      return "kForward";
    case RecurrentNetworkDirection::kBackward:
      return "kBackward";
    case RecurrentNetworkDirection::kBoth:
      return "kBoth";
    default:
      return nullptr;
  }
}

std::string RecurrentNetworkDirectionToString(RecurrentNetworkDirection value) {
  const char *str = RecurrentNetworkDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RecurrentNetworkDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RecurrentNetworkDirection value) {
  return os << RecurrentNetworkDirectionToString(value);
}

NOINLINE static const char* GruWeightLayoutToStringHelper(GruWeightLayout value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GruWeightLayout::kZrn:
      return "kZrn";
    case GruWeightLayout::kRzn:
      return "kRzn";
    default:
      return nullptr;
  }
}

std::string GruWeightLayoutToString(GruWeightLayout value) {
  const char *str = GruWeightLayoutToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GruWeightLayout value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GruWeightLayout value) {
  return os << GruWeightLayoutToString(value);
}

NOINLINE static const char* LstmWeightLayoutToStringHelper(LstmWeightLayout value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LstmWeightLayout::kIofg:
      return "kIofg";
    case LstmWeightLayout::kIfgo:
      return "kIfgo";
    default:
      return nullptr;
  }
}

std::string LstmWeightLayoutToString(LstmWeightLayout value) {
  const char *str = LstmWeightLayoutToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LstmWeightLayout value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LstmWeightLayout value) {
  return os << LstmWeightLayoutToString(value);
}

NOINLINE static const char* Operand_KindToStringHelper(Operand_Kind value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Operand_Kind::kInput:
      return "kInput";
    case Operand_Kind::kConstant:
      return "kConstant";
    case Operand_Kind::kOutput:
      return "kOutput";
    default:
      return nullptr;
  }
}

std::string Operand_KindToString(Operand_Kind value) {
  const char *str = Operand_KindToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Operand_Kind value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Operand_Kind value) {
  return os << Operand_KindToString(value);
}

NOINLINE static const char* ArgMinMax_KindToStringHelper(ArgMinMax_Kind value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ArgMinMax_Kind::kMin:
      return "kMin";
    case ArgMinMax_Kind::kMax:
      return "kMax";
    default:
      return nullptr;
  }
}

std::string ArgMinMax_KindToString(ArgMinMax_Kind value) {
  const char *str = ArgMinMax_KindToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ArgMinMax_Kind value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ArgMinMax_Kind value) {
  return os << ArgMinMax_KindToString(value);
}

NOINLINE static const char* Conv2d_KindToStringHelper(Conv2d_Kind value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Conv2d_Kind::kDirect:
      return "kDirect";
    case Conv2d_Kind::kTransposed:
      return "kTransposed";
    default:
      return nullptr;
  }
}

std::string Conv2d_KindToString(Conv2d_Kind value) {
  const char *str = Conv2d_KindToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Conv2d_Kind value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Conv2d_Kind value) {
  return os << Conv2d_KindToString(value);
}

NOINLINE static const char* ElementWiseBinary_KindToStringHelper(ElementWiseBinary_Kind value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ElementWiseBinary_Kind::kAdd:
      return "kAdd";
    case ElementWiseBinary_Kind::kSub:
      return "kSub";
    case ElementWiseBinary_Kind::kMul:
      return "kMul";
    case ElementWiseBinary_Kind::kDiv:
      return "kDiv";
    case ElementWiseBinary_Kind::kMax:
      return "kMax";
    case ElementWiseBinary_Kind::kMin:
      return "kMin";
    case ElementWiseBinary_Kind::kPow:
      return "kPow";
    case ElementWiseBinary_Kind::kEqual:
      return "kEqual";
    case ElementWiseBinary_Kind::kGreater:
      return "kGreater";
    case ElementWiseBinary_Kind::kGreaterOrEqual:
      return "kGreaterOrEqual";
    case ElementWiseBinary_Kind::kLesser:
      return "kLesser";
    case ElementWiseBinary_Kind::kLesserOrEqual:
      return "kLesserOrEqual";
    case ElementWiseBinary_Kind::kNotEqual:
      return "kNotEqual";
    case ElementWiseBinary_Kind::kLogicalAnd:
      return "kLogicalAnd";
    case ElementWiseBinary_Kind::kLogicalOr:
      return "kLogicalOr";
    case ElementWiseBinary_Kind::kLogicalXor:
      return "kLogicalXor";
    default:
      return nullptr;
  }
}

std::string ElementWiseBinary_KindToString(ElementWiseBinary_Kind value) {
  const char *str = ElementWiseBinary_KindToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ElementWiseBinary_Kind value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ElementWiseBinary_Kind value) {
  return os << ElementWiseBinary_KindToString(value);
}

NOINLINE static const char* ElementWiseUnary_KindToStringHelper(ElementWiseUnary_Kind value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ElementWiseUnary_Kind::kAbs:
      return "kAbs";
    case ElementWiseUnary_Kind::kCeil:
      return "kCeil";
    case ElementWiseUnary_Kind::kCos:
      return "kCos";
    case ElementWiseUnary_Kind::kExp:
      return "kExp";
    case ElementWiseUnary_Kind::kFloor:
      return "kFloor";
    case ElementWiseUnary_Kind::kLog:
      return "kLog";
    case ElementWiseUnary_Kind::kNeg:
      return "kNeg";
    case ElementWiseUnary_Kind::kSign:
      return "kSign";
    case ElementWiseUnary_Kind::kRoundEven:
      return "kRoundEven";
    case ElementWiseUnary_Kind::kSin:
      return "kSin";
    case ElementWiseUnary_Kind::kTan:
      return "kTan";
    case ElementWiseUnary_Kind::kIsNaN:
      return "kIsNaN";
    case ElementWiseUnary_Kind::kIsInfinite:
      return "kIsInfinite";
    case ElementWiseUnary_Kind::kLogicalNot:
      return "kLogicalNot";
    case ElementWiseUnary_Kind::kIdentity:
      return "kIdentity";
    case ElementWiseUnary_Kind::kSqrt:
      return "kSqrt";
    case ElementWiseUnary_Kind::kErf:
      return "kErf";
    case ElementWiseUnary_Kind::kReciprocal:
      return "kReciprocal";
    case ElementWiseUnary_Kind::kCast:
      return "kCast";
    default:
      return nullptr;
  }
}

std::string ElementWiseUnary_KindToString(ElementWiseUnary_Kind value) {
  const char *str = ElementWiseUnary_KindToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ElementWiseUnary_Kind value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ElementWiseUnary_Kind value) {
  return os << ElementWiseUnary_KindToString(value);
}

NOINLINE static const char* Reduce_KindToStringHelper(Reduce_Kind value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Reduce_Kind::kL1:
      return "kL1";
    case Reduce_Kind::kL2:
      return "kL2";
    case Reduce_Kind::kLogSum:
      return "kLogSum";
    case Reduce_Kind::kLogSumExp:
      return "kLogSumExp";
    case Reduce_Kind::kMax:
      return "kMax";
    case Reduce_Kind::kMean:
      return "kMean";
    case Reduce_Kind::kMin:
      return "kMin";
    case Reduce_Kind::kProduct:
      return "kProduct";
    case Reduce_Kind::kSum:
      return "kSum";
    case Reduce_Kind::kSumSquare:
      return "kSumSquare";
    default:
      return nullptr;
  }
}

std::string Reduce_KindToString(Reduce_Kind value) {
  const char *str = Reduce_KindToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Reduce_Kind value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Reduce_Kind value) {
  return os << Reduce_KindToString(value);
}

NOINLINE static const char* Pool2d_KindToStringHelper(Pool2d_Kind value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Pool2d_Kind::kAveragePool2d:
      return "kAveragePool2d";
    case Pool2d_Kind::kL2Pool2d:
      return "kL2Pool2d";
    case Pool2d_Kind::kMaxPool2d:
      return "kMaxPool2d";
    default:
      return nullptr;
  }
}

std::string Pool2d_KindToString(Pool2d_Kind value) {
  const char *str = Pool2d_KindToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Pool2d_Kind value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Pool2d_Kind value) {
  return os << Pool2d_KindToString(value);
}

NOINLINE static const char* Resample2d_InterpolationModeToStringHelper(Resample2d_InterpolationMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Resample2d_InterpolationMode::kNearestNeighbor:
      return "kNearestNeighbor";
    case Resample2d_InterpolationMode::kLinear:
      return "kLinear";
    default:
      return nullptr;
  }
}

std::string Resample2d_InterpolationModeToString(Resample2d_InterpolationMode value) {
  const char *str = Resample2d_InterpolationModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Resample2d_InterpolationMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Resample2d_InterpolationMode value) {
  return os << Resample2d_InterpolationModeToString(value);
}

namespace internal {
// static
bool Number_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const Number_Data* object = static_cast<const Number_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case Number_Tag::kFloatingPoint: {

      return true;
    }
    case Number_Tag::kSignedInteger: {

      return true;
    }
    case Number_Tag::kUnsignedInteger: {

      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in Number");
      return false;
    }
  }
}
// static
bool PaddingMode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PaddingMode_Data* object = static_cast<const PaddingMode_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PaddingMode_Tag::kConstant: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_constant, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_constant, validation_context))
        return false;
      return true;
    }
    case PaddingMode_Tag::kEdge: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_edge, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_edge, validation_context))
        return false;
      return true;
    }
    case PaddingMode_Tag::kReflection: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_reflection, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_reflection, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PaddingMode");
      return false;
    }
  }
}
// static
bool Operation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const Operation_Data* object = static_cast<const Operation_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case Operation_Tag::kArgMinMax: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_arg_min_max, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_arg_min_max, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kBatchNormalization: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_batch_normalization, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_batch_normalization, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kClamp: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_clamp, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_clamp, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kConcat: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_concat, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_concat, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kConv2d: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_conv2d, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_conv2d, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kCumulativeSum: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_cumulative_sum, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_cumulative_sum, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kDequantizeLinear: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_dequantize_linear, 7, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_dequantize_linear, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kElementWiseBinary: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_element_wise_binary, 8, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_element_wise_binary, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kElu: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_elu, 9, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_elu, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kElementWiseUnary: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_element_wise_unary, 10, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_element_wise_unary, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kExpand: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_expand, 11, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_expand, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kGather: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_gather, 12, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_gather, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kGatherElements: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_gather_elements, 13, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_gather_elements, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kGatherNd: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_gather_nd, 14, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_gather_nd, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kGelu: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_gelu, 15, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_gelu, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kGemm: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_gemm, 16, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_gemm, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kGru: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_gru, 17, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_gru, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kGruCell: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_gru_cell, 18, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_gru_cell, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kHardSigmoid: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_hard_sigmoid, 19, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_hard_sigmoid, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kHardSwish: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_hard_swish, 20, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_hard_swish, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kLayerNormalization: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_layer_normalization, 21, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_layer_normalization, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kInstanceNormalization: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_instance_normalization, 22, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_instance_normalization, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kLeakyRelu: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_leaky_relu, 23, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_leaky_relu, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kLinear: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_linear, 24, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_linear, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kLstm: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_lstm, 25, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_lstm, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kLstmCell: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_lstm_cell, 26, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_lstm_cell, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kMatmul: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_matmul, 27, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_matmul, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kPad: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_pad, 28, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_pad, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kPool2d: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_pool2d, 29, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_pool2d, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kPrelu: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_prelu, 30, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_prelu, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kQuantizeLinear: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_quantize_linear, 31, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_quantize_linear, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kReduce: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_reduce, 32, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_reduce, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kRelu: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_relu, 33, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_relu, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kResample2d: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_resample2d, 34, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_resample2d, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kReshape: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_reshape, 35, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_reshape, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kReverse: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_reverse, 36, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_reverse, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kScatterElements: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_scatter_elements, 37, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_scatter_elements, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kScatterNd: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_scatter_nd, 38, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_scatter_nd, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kSigmoid: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_sigmoid, 39, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_sigmoid, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kSlice: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_slice, 40, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_slice, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kSoftmax: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_softmax, 41, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_softmax, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kSoftplus: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_softplus, 42, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_softplus, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kSoftsign: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_softsign, 43, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_softsign, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kSplit: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_split, 44, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_split, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kTanh: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tanh, 45, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tanh, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kTile: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tile, 46, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tile, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kTranspose: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_transpose, 47, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_transpose, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kTriangular: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_triangular, 48, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_triangular, validation_context))
        return false;
      return true;
    }
    case Operation_Tag::kWhere: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_where, 49, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_where, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in Operation");
      return false;
    }
  }
}


// static
bool OperandDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OperandDescriptor_Data* object =
      static_cast<const OperandDescriptor_Data*>(data);


  if (!::webnn::mojom::internal::DataType_Data
        ::Validate(object->data_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shape, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& shape_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->shape, validation_context,
                                         &shape_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pending_permutation, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pending_permutation_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pending_permutation, validation_context,
                                         &pending_permutation_validate_params)) {
    return false;
  }

  return true;
}

OperandDescriptor_Data::OperandDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OperandId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OperandId_Data* object =
      static_cast<const OperandId_Data*>(data);

  return true;
}

OperandId_Data::OperandId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Operand_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Operand_Data* object =
      static_cast<const Operand_Data*>(data);


  if (!::webnn::mojom::internal::Operand_Kind_Data
        ::Validate(object->kind, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->descriptor, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

Operand_Data::Operand_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ArgMinMax_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ArgMinMax_Data* object =
      static_cast<const ArgMinMax_Data*>(data);


  if (!::webnn::mojom::internal::ArgMinMax_Kind_Data
        ::Validate(object->kind, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

ArgMinMax_Data::ArgMinMax_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BatchNormalization_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BatchNormalization_Data* object =
      static_cast<const BatchNormalization_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mean_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mean_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->variance_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->variance_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->scale_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bias_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

BatchNormalization_Data::BatchNormalization_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Clamp_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Clamp_Data* object =
      static_cast<const Clamp_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->min_value, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->min_value, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->max_value, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->max_value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Clamp_Data::Clamp_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Concat_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Concat_Data* object =
      static_cast<const Concat_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_operand_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input_operand_ids, validation_context,
                                         &input_operand_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Concat_Data::Concat_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Size2d_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Size2d_Data* object =
      static_cast<const Size2d_Data*>(data);

  return true;
}

Size2d_Data::Size2d_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Padding2d_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Padding2d_Data* object =
      static_cast<const Padding2d_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->beginning, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->beginning, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ending, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ending, validation_context))
    return false;

  return true;
}

Padding2d_Data::Padding2d_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Conv2d_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Conv2d_Data* object =
      static_cast<const Conv2d_Data*>(data);


  if (!::webnn::mojom::internal::Conv2d_Kind_Data
        ::Validate(object->kind, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filter_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->padding, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->padding, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->strides, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->strides, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dilations, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dilations, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bias_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Conv2d_Data::Conv2d_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CumulativeSum_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CumulativeSum_Data* object =
      static_cast<const CumulativeSum_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

CumulativeSum_Data::CumulativeSum_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DequantizeLinear_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DequantizeLinear_Data* object =
      static_cast<const DequantizeLinear_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scale_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scale_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->zero_point_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->zero_point_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

DequantizeLinear_Data::DequantizeLinear_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ElementWiseBinary_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ElementWiseBinary_Data* object =
      static_cast<const ElementWiseBinary_Data*>(data);


  if (!::webnn::mojom::internal::ElementWiseBinary_Kind_Data
        ::Validate(object->kind, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lhs_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lhs_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rhs_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rhs_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

ElementWiseBinary_Data::ElementWiseBinary_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ElementWiseUnary_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ElementWiseUnary_Data* object =
      static_cast<const ElementWiseUnary_Data*>(data);


  if (!::webnn::mojom::internal::ElementWiseUnary_Kind_Data
        ::Validate(object->kind, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

ElementWiseUnary_Data::ElementWiseUnary_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Expand_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Expand_Data* object =
      static_cast<const Expand_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Expand_Data::Expand_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConstantPadding_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConstantPadding_Data* object =
      static_cast<const ConstantPadding_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->value, validation_context))
    return false;

  return true;
}

ConstantPadding_Data::ConstantPadding_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EdgePadding_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EdgePadding_Data* object =
      static_cast<const EdgePadding_Data*>(data);

  return true;
}

EdgePadding_Data::EdgePadding_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReflectionPadding_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReflectionPadding_Data* object =
      static_cast<const ReflectionPadding_Data*>(data);

  return true;
}

ReflectionPadding_Data::ReflectionPadding_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InstanceNormalization_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InstanceNormalization_Data* object =
      static_cast<const InstanceNormalization_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->scale_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bias_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

InstanceNormalization_Data::InstanceNormalization_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Matmul_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Matmul_Data* object =
      static_cast<const Matmul_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->a_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->a_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->b_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->b_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Matmul_Data::Matmul_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Pad_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Pad_Data* object =
      static_cast<const Pad_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->beginning_padding, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& beginning_padding_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->beginning_padding, validation_context,
                                         &beginning_padding_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ending_padding, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ending_padding_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ending_padding, validation_context,
                                         &ending_padding_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->mode, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Pad_Data::Pad_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Reduce_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Reduce_Data* object =
      static_cast<const Reduce_Data*>(data);


  if (!::webnn::mojom::internal::Reduce_Kind_Data
        ::Validate(object->kind, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->axes, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& axes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->axes, validation_context,
                                         &axes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Reduce_Data::Reduce_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Pool2d_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Pool2d_Data* object =
      static_cast<const Pool2d_Data*>(data);


  if (!::webnn::mojom::internal::Pool2d_Kind_Data
        ::Validate(object->kind, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_dimensions, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->window_dimensions, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->padding, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->padding, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->strides, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->strides, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dilations, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dilations, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Pool2d_Data::Pool2d_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Range_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Range_Data* object =
      static_cast<const Range_Data*>(data);

  return true;
}

Range_Data::Range_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Slice_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Slice_Data* object =
      static_cast<const Slice_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ranges, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ranges_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ranges, validation_context,
                                         &ranges_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Slice_Data::Slice_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Elu_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Elu_Data* object =
      static_cast<const Elu_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Elu_Data::Elu_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Gather_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Gather_Data* object =
      static_cast<const Gather_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->indices_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->indices_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Gather_Data::Gather_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GatherElements_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GatherElements_Data* object =
      static_cast<const GatherElements_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->indices_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->indices_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

GatherElements_Data::GatherElements_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GatherND_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GatherND_Data* object =
      static_cast<const GatherND_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->indices_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->indices_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

GatherND_Data::GatherND_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Gelu_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Gelu_Data* object =
      static_cast<const Gelu_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Gelu_Data::Gelu_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Gru_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Gru_Data* object =
      static_cast<const Gru_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->weight_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->weight_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recurrent_weight_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->recurrent_weight_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_ids, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& output_operand_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->output_operand_ids, validation_context,
                                         &output_operand_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->bias_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->recurrent_bias_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initial_hidden_state_operand_id, validation_context))
    return false;


  if (!::webnn::mojom::internal::RecurrentNetworkDirection_Data
        ::Validate(object->direction, validation_context))
    return false;


  if (!::webnn::mojom::internal::GruWeightLayout_Data
        ::Validate(object->layout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->activations, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& activations_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<2, false, ::webnn::mojom::internal::RecurrentNetworkActivation_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->activations, validation_context,
                                         &activations_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Gru_Data::Gru_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GruCell_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 96, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GruCell_Data* object =
      static_cast<const GruCell_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->weight_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->weight_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recurrent_weight_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->recurrent_weight_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hidden_state_operand_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hidden_state_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bias_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->recurrent_bias_operand_id, validation_context))
    return false;


  if (!::webnn::mojom::internal::GruWeightLayout_Data
        ::Validate(object->layout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->activations, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& activations_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<2, false, ::webnn::mojom::internal::RecurrentNetworkActivation_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->activations, validation_context,
                                         &activations_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

GruCell_Data::GruCell_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Gemm_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Gemm_Data* object =
      static_cast<const Gemm_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->a_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->a_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->b_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->b_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->c_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Gemm_Data::Gemm_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HardSigmoid_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HardSigmoid_Data* object =
      static_cast<const HardSigmoid_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

HardSigmoid_Data::HardSigmoid_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HardSwish_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HardSwish_Data* object =
      static_cast<const HardSwish_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

HardSwish_Data::HardSwish_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayerNormalization_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerNormalization_Data* object =
      static_cast<const LayerNormalization_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->scale_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bias_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->axes, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& axes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->axes, validation_context,
                                         &axes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

LayerNormalization_Data::LayerNormalization_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LeakyRelu_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LeakyRelu_Data* object =
      static_cast<const LeakyRelu_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

LeakyRelu_Data::LeakyRelu_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Linear_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Linear_Data* object =
      static_cast<const Linear_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Linear_Data::Linear_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Lstm_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 120, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Lstm_Data* object =
      static_cast<const Lstm_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->weight_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->weight_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recurrent_weight_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->recurrent_weight_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_ids, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& output_operand_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->output_operand_ids, validation_context,
                                         &output_operand_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->bias_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->recurrent_bias_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->peephole_weight_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initial_hidden_state_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initial_cell_state_operand_id, validation_context))
    return false;


  if (!::webnn::mojom::internal::RecurrentNetworkDirection_Data
        ::Validate(object->direction, validation_context))
    return false;


  if (!::webnn::mojom::internal::LstmWeightLayout_Data
        ::Validate(object->layout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->activations, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& activations_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<3, false, ::webnn::mojom::internal::RecurrentNetworkActivation_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->activations, validation_context,
                                         &activations_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 16, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Lstm_Data::Lstm_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LstmCell_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LstmCell_Data* object =
      static_cast<const LstmCell_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->weight_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->weight_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recurrent_weight_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->recurrent_weight_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hidden_state_operand_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hidden_state_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cell_state_operand_id, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cell_state_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_ids, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& output_operand_ids_validate_params =
      mojo::internal::GetArrayValidator<2, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->output_operand_ids, validation_context,
                                         &output_operand_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->bias_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->recurrent_bias_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->peephole_weight_operand_id, validation_context))
    return false;


  if (!::webnn::mojom::internal::LstmWeightLayout_Data
        ::Validate(object->layout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->activations, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& activations_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<3, false, ::webnn::mojom::internal::RecurrentNetworkActivation_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->activations, validation_context,
                                         &activations_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

LstmCell_Data::LstmCell_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Prelu_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Prelu_Data* object =
      static_cast<const Prelu_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->slope_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->slope_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Prelu_Data::Prelu_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuantizeLinear_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuantizeLinear_Data* object =
      static_cast<const QuantizeLinear_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scale_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scale_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->zero_point_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->zero_point_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

QuantizeLinear_Data::QuantizeLinear_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Relu_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Relu_Data* object =
      static_cast<const Relu_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Relu_Data::Relu_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Reshape_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Reshape_Data* object =
      static_cast<const Reshape_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Reshape_Data::Reshape_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Reverse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Reverse_Data* object =
      static_cast<const Reverse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->axes, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& axes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->axes, validation_context,
                                         &axes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Reverse_Data::Reverse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScatterElements_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScatterElements_Data* object =
      static_cast<const ScatterElements_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->indices_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->indices_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->updates_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->updates_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

ScatterElements_Data::ScatterElements_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScatterND_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScatterND_Data* object =
      static_cast<const ScatterND_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->indices_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->indices_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->updates_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->updates_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

ScatterND_Data::ScatterND_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sigmoid_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Sigmoid_Data* object =
      static_cast<const Sigmoid_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Sigmoid_Data::Sigmoid_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Softmax_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Softmax_Data* object =
      static_cast<const Softmax_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Softmax_Data::Softmax_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Softplus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Softplus_Data* object =
      static_cast<const Softplus_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Softplus_Data::Softplus_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Softsign_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Softsign_Data* object =
      static_cast<const Softsign_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Softsign_Data::Softsign_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Split_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Split_Data* object =
      static_cast<const Split_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_ids, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& output_operand_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->output_operand_ids, validation_context,
                                         &output_operand_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Split_Data::Split_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Tanh_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Tanh_Data* object =
      static_cast<const Tanh_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Tanh_Data::Tanh_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Tile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Tile_Data* object =
      static_cast<const Tile_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->repetitions, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& repetitions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->repetitions, validation_context,
                                         &repetitions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Tile_Data::Tile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Transpose_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Transpose_Data* object =
      static_cast<const Transpose_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permutation, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& permutation_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->permutation, validation_context,
                                         &permutation_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Transpose_Data::Transpose_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Triangular_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Triangular_Data* object =
      static_cast<const Triangular_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Triangular_Data::Triangular_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Resample2d_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Resample2d_Data* object =
      static_cast<const Resample2d_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;


  if (!::webnn::mojom::internal::Resample2d_InterpolationMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& scales_validate_params =
      mojo::internal::GetArrayValidator<2, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scales, validation_context,
                                         &scales_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->axes, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& axes_validate_params =
      mojo::internal::GetArrayValidator<2, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->axes, validation_context,
                                         &axes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Resample2d_Data::Resample2d_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Where_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Where_Data* object =
      static_cast<const Where_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->condition_operand_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->condition_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->true_value_operand_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->true_value_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->false_value_operand_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->false_value_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operand_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_operand_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Where_Data::Where_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphInfo_Data* object =
      static_cast<const GraphInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->operands, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& operands_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->operands, validation_context,
                                         &operands_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_operands, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_operands_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input_operands, validation_context,
                                         &input_operands_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_operands, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& output_operands_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->output_operands, validation_context,
                                         &output_operands_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->operations, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& operations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->operations, validation_context,
                                         &operations_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->constant_operand_ids_to_handles, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& constant_operand_ids_to_handles_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->constant_operand_ids_to_handles, validation_context,
                                         &constant_operand_ids_to_handles_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id_to_constant_tensor_operand_map, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_to_constant_tensor_operand_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->id_to_constant_tensor_operand_map, validation_context,
                                         &id_to_constant_tensor_operand_map_validate_params)) {
    return false;
  }

  return true;
}

GraphInfo_Data::GraphInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNGraph_Dispatch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNGraph_Dispatch_Params_Data* object =
      static_cast<const WebNNGraph_Dispatch_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->named_inputs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& named_inputs_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->named_inputs, validation_context,
                                         &named_inputs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->named_outputs, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& named_outputs_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->named_outputs, validation_context,
                                         &named_outputs_validate_params)) {
    return false;
  }

  return true;
}

WebNNGraph_Dispatch_Params_Data::WebNNGraph_Dispatch_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace webnn

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::DataType>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::DataType value) {
  return std::move(context).WriteString(::webnn::mojom::DataTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::RecurrentNetworkActivation>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::RecurrentNetworkActivation value) {
  return std::move(context).WriteString(::webnn::mojom::RecurrentNetworkActivationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::RecurrentNetworkDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::RecurrentNetworkDirection value) {
  return std::move(context).WriteString(::webnn::mojom::RecurrentNetworkDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::GruWeightLayout>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::GruWeightLayout value) {
  return std::move(context).WriteString(::webnn::mojom::GruWeightLayoutToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::LstmWeightLayout>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::LstmWeightLayout value) {
  return std::move(context).WriteString(::webnn::mojom::LstmWeightLayoutToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::Operand_Kind>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::Operand_Kind value) {
  return std::move(context).WriteString(::webnn::mojom::Operand_KindToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::ArgMinMax_Kind>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::ArgMinMax_Kind value) {
  return std::move(context).WriteString(::webnn::mojom::ArgMinMax_KindToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::Conv2d_Kind>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::Conv2d_Kind value) {
  return std::move(context).WriteString(::webnn::mojom::Conv2d_KindToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::ElementWiseBinary_Kind>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::ElementWiseBinary_Kind value) {
  return std::move(context).WriteString(::webnn::mojom::ElementWiseBinary_KindToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::ElementWiseUnary_Kind>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::ElementWiseUnary_Kind value) {
  return std::move(context).WriteString(::webnn::mojom::ElementWiseUnary_KindToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::Reduce_Kind>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::Reduce_Kind value) {
  return std::move(context).WriteString(::webnn::mojom::Reduce_KindToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::Pool2d_Kind>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::Pool2d_Kind value) {
  return std::move(context).WriteString(::webnn::mojom::Pool2d_KindToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::Resample2d_InterpolationMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::Resample2d_InterpolationMode value) {
  return std::move(context).WriteString(::webnn::mojom::Resample2d_InterpolationModeToString(value));
}

} // namespace perfetto