// services/webnn/public/mojom/webnn_context_provider.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_DATA_VIEW_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/webnn/public/mojom/webnn_context_provider.mojom-shared-internal.h"
#include "services/webnn/public/mojom/features.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_context.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_device.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"


namespace webnn::mojom {
class CreateContextOptionsDataView;

class CreateContextSuccessDataView;

class CreateContextResultDataView;


}  // webnn::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::webnn::mojom::CreateContextOptionsDataView> {
  using Data = ::webnn::mojom::internal::CreateContextOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::CreateContextSuccessDataView> {
  using Data = ::webnn::mojom::internal::CreateContextSuccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::CreateContextResultDataView> {
  using Data = ::webnn::mojom::internal::CreateContextResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace webnn::mojom {


enum class CreateContextOptions_PowerPreference : int32_t {
  
  kDefault = 0,
  
  kHighPerformance = 1,
  
  kLowPower = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, CreateContextOptions_PowerPreference value);
inline bool IsKnownEnumValue(CreateContextOptions_PowerPreference value) {
  return internal::CreateContextOptions_PowerPreference_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebNNContextProviderInterfaceBase {};

using WebNNContextProviderPtrDataView =
    mojo::InterfacePtrDataView<WebNNContextProviderInterfaceBase>;
using WebNNContextProviderRequestDataView =
    mojo::InterfaceRequestDataView<WebNNContextProviderInterfaceBase>;
using WebNNContextProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebNNContextProviderInterfaceBase>;
using WebNNContextProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebNNContextProviderInterfaceBase>;


class CreateContextOptionsDataView {
 public:
  CreateContextOptionsDataView() = default;

  CreateContextOptionsDataView(
      internal::CreateContextOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) const {
    auto data_value = data_->device;
    return mojo::internal::Deserialize<::webnn::mojom::Device>(
        data_value, output);
  }
  ::webnn::mojom::Device device() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::Device>(data_->device));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPowerPreference(UserType* output) const {
    auto data_value = data_->power_preference;
    return mojo::internal::Deserialize<::webnn::mojom::CreateContextOptions_PowerPreference>(
        data_value, output);
  }
  CreateContextOptions_PowerPreference power_preference() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::CreateContextOptions_PowerPreference>(data_->power_preference));
  }
 private:
  internal::CreateContextOptions_Data* data_ = nullptr;
};


class CreateContextSuccessDataView {
 public:
  CreateContextSuccessDataView() = default;

  CreateContextSuccessDataView(
      internal::CreateContextSuccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeContextRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::webnn::mojom::WebNNContextAssociatedPtrInfoDataView>(
            &data_->context_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetContextPropertiesDataView(
      ::webnn::mojom::ContextPropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContextProperties(UserType* output) {
    
    auto* pointer = data_->context_properties.Get();
    return mojo::internal::Deserialize<::webnn::mojom::ContextPropertiesDataView>(
        pointer, output, message_);
  }
  inline void GetContextHandleDataView(
      ::blink::mojom::WebNNContextTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContextHandle(UserType* output) {
    
    auto* pointer = data_->context_handle.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebNNContextTokenDataView>(
        pointer, output, message_);
  }
  mojo::ScopedDataPipeProducerHandle TakeWriteTensorProducer() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->write_tensor_producer, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeConsumerHandle TakeReadTensorConsumer() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->read_tensor_consumer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CreateContextSuccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateContextResultDataView {
 public:
  using Tag = internal::CreateContextResult_Data::CreateContextResult_Tag;

  CreateContextResultDataView() = default;

  CreateContextResultDataView(
      internal::CreateContextResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      CreateContextSuccessDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::webnn::mojom::CreateContextSuccessDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      ::webnn::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<::webnn::mojom::ErrorDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::CreateContextResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // webnn::mojom

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_DATA_VIEW_H_