// services/webnn/public/mojom/webnn_context.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_PARAMS_DATA_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace webnn::mojom {
namespace internal {
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) WebNNContext_CreateGraphBuilder_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedEndpointHandle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<WebNNContext_CreateGraphBuilder_Params_Data>;

  WebNNContext_CreateGraphBuilder_Params_Data();
  ~WebNNContext_CreateGraphBuilder_Params_Data() = delete;
};
static_assert(sizeof(WebNNContext_CreateGraphBuilder_Params_Data) == 16,
              "Bad sizeof(WebNNContext_CreateGraphBuilder_Params_Data)");
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) WebNNContext_CreateTensor_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::webnn::mojom::internal::TensorInfo_Data> tensor_info;
  ::mojo_base::mojom::internal::BigBuffer_Data tensor_data;

 private:
  friend class mojo::internal::MessageFragment<WebNNContext_CreateTensor_Params_Data>;

  WebNNContext_CreateTensor_Params_Data();
  ~WebNNContext_CreateTensor_Params_Data() = delete;
};
static_assert(sizeof(WebNNContext_CreateTensor_Params_Data) == 32,
              "Bad sizeof(WebNNContext_CreateTensor_Params_Data)");
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) WebNNContext_CreateTensor_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::CreateTensorResult_Data result;

 private:
  friend class mojo::internal::MessageFragment<WebNNContext_CreateTensor_ResponseParams_Data>;

  WebNNContext_CreateTensor_ResponseParams_Data();
  ~WebNNContext_CreateTensor_ResponseParams_Data() = delete;
};
static_assert(sizeof(WebNNContext_CreateTensor_ResponseParams_Data) == 24,
              "Bad sizeof(WebNNContext_CreateTensor_ResponseParams_Data)");
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) WebNNContext_CreateTensorFromMailbox_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::webnn::mojom::internal::TensorInfo_Data> tensor_info;
  mojo::internal::Pointer<::gpu::mojom::internal::Mailbox_Data> mailbox;
  mojo::internal::Pointer<::gpu::mojom::internal::SyncToken_Data> fence;

 private:
  friend class mojo::internal::MessageFragment<WebNNContext_CreateTensorFromMailbox_Params_Data>;

  WebNNContext_CreateTensorFromMailbox_Params_Data();
  ~WebNNContext_CreateTensorFromMailbox_Params_Data() = delete;
};
static_assert(sizeof(WebNNContext_CreateTensorFromMailbox_Params_Data) == 32,
              "Bad sizeof(WebNNContext_CreateTensorFromMailbox_Params_Data)");
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) WebNNContext_CreateTensorFromMailbox_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::CreateTensorResult_Data result;

 private:
  friend class mojo::internal::MessageFragment<WebNNContext_CreateTensorFromMailbox_ResponseParams_Data>;

  WebNNContext_CreateTensorFromMailbox_ResponseParams_Data();
  ~WebNNContext_CreateTensorFromMailbox_ResponseParams_Data() = delete;
};
static_assert(sizeof(WebNNContext_CreateTensorFromMailbox_ResponseParams_Data) == 24,
              "Bad sizeof(WebNNContext_CreateTensorFromMailbox_ResponseParams_Data)");

}  // namespace internal


class WebNNContext_CreateGraphBuilder_ParamsDataView {
 public:
  WebNNContext_CreateGraphBuilder_ParamsDataView() = default;

  WebNNContext_CreateGraphBuilder_ParamsDataView(
      internal::WebNNContext_CreateGraphBuilder_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::webnn::mojom::WebNNGraphBuilderAssociatedRequestDataView>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::WebNNContext_CreateGraphBuilder_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebNNContext_CreateTensor_ParamsDataView {
 public:
  WebNNContext_CreateTensor_ParamsDataView() = default;

  WebNNContext_CreateTensor_ParamsDataView(
      internal::WebNNContext_CreateTensor_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTensorInfoDataView(
      ::webnn::mojom::TensorInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTensorInfo(UserType* output) {
    
    auto* pointer = data_->tensor_info.Get();
    return mojo::internal::Deserialize<::webnn::mojom::TensorInfoDataView>(
        pointer, output, message_);
  }
  inline void GetTensorDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTensorData(UserType* output) {
    
    auto* pointer = !data_->tensor_data.is_null() ? &data_->tensor_data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebNNContext_CreateTensor_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebNNContext_CreateTensor_ResponseParamsDataView {
 public:
  WebNNContext_CreateTensor_ResponseParamsDataView() = default;

  WebNNContext_CreateTensor_ResponseParamsDataView(
      internal::WebNNContext_CreateTensor_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      CreateTensorResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::webnn::mojom::CreateTensorResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebNNContext_CreateTensor_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebNNContext_CreateTensorFromMailbox_ParamsDataView {
 public:
  WebNNContext_CreateTensorFromMailbox_ParamsDataView() = default;

  WebNNContext_CreateTensorFromMailbox_ParamsDataView(
      internal::WebNNContext_CreateTensorFromMailbox_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTensorInfoDataView(
      ::webnn::mojom::TensorInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTensorInfo(UserType* output) {
    
    auto* pointer = data_->tensor_info.Get();
    return mojo::internal::Deserialize<::webnn::mojom::TensorInfoDataView>(
        pointer, output, message_);
  }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetFenceDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFence(UserType* output) {
    
    auto* pointer = data_->fence.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebNNContext_CreateTensorFromMailbox_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebNNContext_CreateTensorFromMailbox_ResponseParamsDataView {
 public:
  WebNNContext_CreateTensorFromMailbox_ResponseParamsDataView() = default;

  WebNNContext_CreateTensorFromMailbox_ResponseParamsDataView(
      internal::WebNNContext_CreateTensorFromMailbox_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      CreateTensorResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::webnn::mojom::CreateTensorResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebNNContext_CreateTensorFromMailbox_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



inline void WebNNContext_CreateTensor_ParamsDataView::GetTensorInfoDataView(
    ::webnn::mojom::TensorInfoDataView* output) {
  auto pointer = data_->tensor_info.Get();
  *output = ::webnn::mojom::TensorInfoDataView(pointer, message_);
}
inline void WebNNContext_CreateTensor_ParamsDataView::GetTensorDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->tensor_data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void WebNNContext_CreateTensor_ResponseParamsDataView::GetResultDataView(
    CreateTensorResultDataView* output) {
  auto pointer = &data_->result;
  *output = CreateTensorResultDataView(pointer, message_);
}


inline void WebNNContext_CreateTensorFromMailbox_ParamsDataView::GetTensorInfoDataView(
    ::webnn::mojom::TensorInfoDataView* output) {
  auto pointer = data_->tensor_info.Get();
  *output = ::webnn::mojom::TensorInfoDataView(pointer, message_);
}
inline void WebNNContext_CreateTensorFromMailbox_ParamsDataView::GetMailboxDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->mailbox.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}
inline void WebNNContext_CreateTensorFromMailbox_ParamsDataView::GetFenceDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->fence.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}


inline void WebNNContext_CreateTensorFromMailbox_ResponseParamsDataView::GetResultDataView(
    CreateTensorResultDataView* output) {
  auto pointer = &data_->result;
  *output = CreateTensorResultDataView(pointer, message_);
}



}  // webnn::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_PARAMS_DATA_H_