// services/viz/public/mojom/compositing/view_transition_request.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_REQUEST_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_REQUEST_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/view_transition_request.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"

#include "services/viz/public/mojom/compositing/view_transition_request.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::ViewTransitionRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ViewTransitionRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ViewTransitionRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::viz::mojom::CompositorFrameTransitionDirectiveType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::transition_token(input)) in_transition_token = Traits::transition_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transition_token)::BaseType> transition_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ViewTransitionTokenDataView, send_validation>(
        in_transition_token,
        transition_token_fragment);

      fragment->transition_token.Set(
          transition_token_fragment.is_null() ? nullptr : transition_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transition_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transition_token in ViewTransitionRequest struct");

      fragment->maybe_cross_frame_sink = Traits::maybe_cross_frame_sink(input);

      fragment->sequence_id = Traits::sequence_id(input);

      decltype(Traits::capture_resource_ids(input)) in_capture_resource_ids = Traits::capture_resource_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->capture_resource_ids)::BaseType>
          capture_resource_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& capture_resource_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ViewTransitionElementResourceIdDataView>, send_validation>(
        in_capture_resource_ids,
        capture_resource_ids_fragment,
        &capture_resource_ids_validate_params);

      fragment->capture_resource_ids.Set(
          capture_resource_ids_fragment.is_null() ? nullptr : capture_resource_ids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->capture_resource_ids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null capture_resource_ids in ViewTransitionRequest struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_REQUEST_MOJOM_SEND_VALIDATION_H_