// services/viz/public/mojom/compositing/video_detector_observer.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('viz.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
viz.mojom.VideoDetectorObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        viz.mojom.VideoDetectorObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { viz.mojom.VideoDetectorObserverInterface }
 */
viz.mojom.VideoDetectorObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!viz.mojom.VideoDetectorObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          viz.mojom.VideoDetectorObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!viz.mojom.VideoDetectorObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onVideoActivityStarted() {
    this.proxy.sendMessage(
        0,
        viz.mojom.VideoDetectorObserver_OnVideoActivityStarted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onVideoActivityEnded() {
    this.proxy.sendMessage(
        1,
        viz.mojom.VideoDetectorObserver_OnVideoActivityEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoDetectorObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
viz.mojom.VideoDetectorObserverReceiver = class {
  /**
   * @param {!viz.mojom.VideoDetectorObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!viz.mojom.VideoDetectorObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        viz.mojom.VideoDetectorObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.VideoDetectorObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        viz.mojom.VideoDetectorObserver_OnVideoActivityStarted_ParamsSpec.$,
        null,
        impl.onVideoActivityStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        viz.mojom.VideoDetectorObserver_OnVideoActivityEnded_ParamsSpec.$,
        null,
        impl.onVideoActivityEnded.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
viz.mojom.VideoDetectorObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.VideoDetectorObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!viz.mojom.VideoDetectorObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new viz.mojom.VideoDetectorObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoDetectorObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
viz.mojom.VideoDetectorObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      viz.mojom.VideoDetectorObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.VideoDetectorObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVideoActivityStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        viz.mojom.VideoDetectorObserver_OnVideoActivityStarted_ParamsSpec.$,
        null,
        this.onVideoActivityStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVideoActivityEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        viz.mojom.VideoDetectorObserver_OnVideoActivityEnded_ParamsSpec.$,
        null,
        this.onVideoActivityEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.VideoDetectorObserver_OnVideoActivityStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.VideoDetectorObserver_OnVideoActivityEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    viz.mojom.VideoDetectorObserver_OnVideoActivityStarted_ParamsSpec.$,
    'VideoDetectorObserver_OnVideoActivityStarted_Params',
    [
    ],
    [[0, 8],]);





/** @record */
viz.mojom.VideoDetectorObserver_OnVideoActivityStarted_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    viz.mojom.VideoDetectorObserver_OnVideoActivityEnded_ParamsSpec.$,
    'VideoDetectorObserver_OnVideoActivityEnded_Params',
    [
    ],
    [[0, 8],]);





/** @record */
viz.mojom.VideoDetectorObserver_OnVideoActivityEnded_Params = class {
  constructor() {
  }
};

