// services/viz/public/mojom/compositing/tiling.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/tiling.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/tiling.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/tiling.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/tiling.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/tiling.mojom-test-utils.h"


namespace viz::mojom {
TileResource::TileResource()
    : resource(),
      is_checkered() {}

TileResource::TileResource(
    const ::viz::TransferableResource& resource_in,
    bool is_checkered_in)
    : resource(std::move(resource_in)),
      is_checkered(std::move(is_checkered_in)) {}

TileResource::~TileResource() = default;

void TileResource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource"), this->resource,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::TransferableResource&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_checkered"), this->is_checkered,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TileResource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Tile::Tile()
    : column_index(),
      row_index(),
      contents() {}

Tile::Tile(
    uint32_t column_index_in,
    uint32_t row_index_in,
    TileContentsPtr contents_in)
    : column_index(std::move(column_index_in)),
      row_index(std::move(row_index_in)),
      contents(std::move(contents_in)) {}

Tile::~Tile() = default;

void Tile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "column_index"), this->column_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "row_index"), this->row_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents"), this->contents,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TileContentsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Tile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Tiling::Tiling()
    : layer_id(),
      raster_translation(),
      raster_scale(),
      tile_size(),
      tiling_rect(),
      tiles(),
      scale_key(),
      is_deleted() {}

Tiling::Tiling(
    int64_t layer_id_in,
    const ::gfx::Vector2dF& raster_translation_in,
    const ::gfx::Vector2dF& raster_scale_in,
    const ::gfx::Size& tile_size_in,
    const ::gfx::Rect& tiling_rect_in,
    std::vector<TilePtr> tiles_in,
    float scale_key_in,
    bool is_deleted_in)
    : layer_id(std::move(layer_id_in)),
      raster_translation(std::move(raster_translation_in)),
      raster_scale(std::move(raster_scale_in)),
      tile_size(std::move(tile_size_in)),
      tiling_rect(std::move(tiling_rect_in)),
      tiles(std::move(tiles_in)),
      scale_key(std::move(scale_key_in)),
      is_deleted(std::move(is_deleted_in)) {}

Tiling::~Tiling() = default;

void Tiling::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_id"), this->layer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raster_translation"), this->raster_translation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raster_scale"), this->raster_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tile_size"), this->tile_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tiling_rect"), this->tiling_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tiles"), this->tiles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TilePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_key"), this->scale_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_deleted"), this->is_deleted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Tiling::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TileContentsPtr
TileContents::NewMissingReason(
    ::cc::mojom::MissingTileReason value) {
  return TileContentsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kMissingReason)>,
      std::move(value));
}

TileContentsPtr
TileContents::NewResource(
    TileResourcePtr value) {
  return TileContentsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kResource)>,
      std::move(value));
}

TileContentsPtr
TileContents::NewSolidColor(
    const ::SkColor4f& value) {
  return TileContentsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSolidColor)>,
      std::move(value));
}

TileContents::TileContents(
    std::in_place_index_t<static_cast<size_t>(Tag::kMissingReason)>,
    ::cc::mojom::MissingTileReason value)
    : tag_(Tag::kMissingReason),
      data_(std::in_place_index<static_cast<size_t>(Tag::kMissingReason)>,
            std::move(value)) {}

TileContents::TileContents(
    std::in_place_index_t<static_cast<size_t>(Tag::kResource)>,
    TileResourcePtr value)
    : tag_(Tag::kResource),
      data_(std::in_place_index<static_cast<size_t>(Tag::kResource)>,
            std::move(value)) {}

TileContents::TileContents(
    std::in_place_index_t<static_cast<size_t>(Tag::kSolidColor)>,
    const ::SkColor4f& value)
    : tag_(Tag::kSolidColor),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSolidColor)>,
            std::move(value)) {}
TileContents::~TileContents() {
  DestroyActive();
}

void TileContents::set_missing_reason(::cc::mojom::MissingTileReason missing_reason) {
  if (tag_ != Tag::kMissingReason) {
    DestroyActive();
    tag_ = Tag::kMissingReason;
  }
  data_.missing_reason = missing_reason;
}

void TileContents::set_resource(TileResourcePtr resource) {
  if (tag_ == Tag::kResource) {
    data_.resource = std::move(resource);
  } else {
    DestroyActive();
    tag_ = Tag::kResource;
    new (&data_.resource) TileResourcePtr(
        std::move(resource));
  }
}

void TileContents::set_solid_color(const ::SkColor4f& solid_color) {
  if (tag_ == Tag::kSolidColor) {
    data_.solid_color = std::move(solid_color);
  } else {
    DestroyActive();
    tag_ = Tag::kSolidColor;
    new (&data_.solid_color) ::SkColor4f(
        std::move(solid_color));
  }
}


TileContents::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kMissingReason)>,
    ::cc::mojom::MissingTileReason value)
    : missing_reason(std::move(value)) {}

TileContents::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kResource)>,
    TileResourcePtr value)
    : resource(std::move(value)) {}

TileContents::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSolidColor)>,
    const ::SkColor4f& value)
    : solid_color(std::move(value)) {}

void TileContents::DestroyActive() {
  switch (tag_) {

    case Tag::kMissingReason:
      std::destroy_at(&data_.missing_reason);
      break;
    case Tag::kResource:
      std::destroy_at(&data_.resource);
      break;
    case Tag::kSolidColor:
      std::destroy_at(&data_.solid_color);
      break;
  }
}

bool TileContents::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::TileResource::DataView, ::viz::mojom::TileResourcePtr>::Read(
    ::viz::mojom::TileResource::DataView input,
    ::viz::mojom::TileResourcePtr* output) {
  bool success = true;
  ::viz::mojom::TileResourcePtr result(::viz::mojom::TileResource::New());
  
      if (success && !input.ReadResource(&result->resource))
        success = false;
      if (success)
        result->is_checkered = input.is_checkered();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::Tile::DataView, ::viz::mojom::TilePtr>::Read(
    ::viz::mojom::Tile::DataView input,
    ::viz::mojom::TilePtr* output) {
  bool success = true;
  ::viz::mojom::TilePtr result(::viz::mojom::Tile::New());
  
      if (success)
        result->column_index = input.column_index();
      if (success)
        result->row_index = input.row_index();
      if (success && !input.ReadContents(&result->contents))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::Tiling::DataView, ::viz::mojom::TilingPtr>::Read(
    ::viz::mojom::Tiling::DataView input,
    ::viz::mojom::TilingPtr* output) {
  bool success = true;
  ::viz::mojom::TilingPtr result(::viz::mojom::Tiling::New());
  
      if (success)
        result->layer_id = input.layer_id();
      if (success && !input.ReadRasterTranslation(&result->raster_translation))
        success = false;
      if (success && !input.ReadRasterScale(&result->raster_scale))
        success = false;
      if (success && !input.ReadTileSize(&result->tile_size))
        success = false;
      if (success && !input.ReadTilingRect(&result->tiling_rect))
        success = false;
      if (success && !input.ReadTiles(&result->tiles))
        success = false;
      if (success)
        result->scale_key = input.scale_key();
      if (success)
        result->is_deleted = input.is_deleted();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::viz::mojom::TileContents::DataView, ::viz::mojom::TileContentsPtr>::Read(
    ::viz::mojom::TileContents::DataView input,
    ::viz::mojom::TileContentsPtr* output) {
  using UnionType = ::viz::mojom::TileContents;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kMissingReason: {
      ::cc::mojom::MissingTileReason result_missing_reason;
      if (!input.ReadMissingReason(&result_missing_reason))
        return false;

      *output = UnionType::NewMissingReason(result_missing_reason);
      break;
    }
    case Tag::kResource: {
      ::viz::mojom::TileResourcePtr result_resource{};
      if (!input.ReadResource(&result_resource))
        return false;

      *output = UnionType::NewResource(
          std::move(result_resource));
      break;
    }
    case Tag::kSolidColor: {
      ::SkColor4f result_solid_color{};
      if (!input.ReadSolidColor(&result_solid_color))
        return false;

      *output = UnionType::NewSolidColor(
          std::move(result_solid_color));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif