// services/viz/public/mojom/compositing/layer_context.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/layer_context.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_params.mojom-shared.h"
#include "cc/mojom/browser_controls_offset_tag_modifications.mojom-shared.h"
#include "cc/mojom/layer_selection_bound.mojom-shared.h"
#include "cc/mojom/layer_tree_debug_state.mojom-shared.h"
#include "cc/mojom/ui_resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/animation.mojom-shared.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "services/viz/public/mojom/compositing/layer.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-shared.h"
#include "services/viz/public/mojom/compositing/tiling.mojom-shared.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_request.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"
#include "ui/gfx/mojom/overlay_transform.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/viz/public/mojom/compositing/layer_context.mojom-data-view.h"




namespace std {

template <>
struct hash<::viz::mojom::TransferableUIResourceRequest_Type>
    : public mojo::internal::EnumHashImpl<::viz::mojom::TransferableUIResourceRequest_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TransferableUIResourceRequest_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::TransferableUIResourceRequest_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::TransferableUIResourceRequest_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TransferableUIResourceRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TransferableUIResourceRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TransferableUIResourceRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::viz::mojom::TransferableUIResourceRequest_Type>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::uid(input)) in_uid = Traits::uid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uid)::BaseType> uid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::cc::mojom::UIResourceIdDataView>(
      in_uid,
      uid_fragment);

    fragment->uid.Set(
        uid_fragment.is_null() ? nullptr : uid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->uid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uid in TransferableUIResourceRequest struct");

    decltype(Traits::transferable_resource(input)) in_transferable_resource = Traits::transferable_resource(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transferable_resource)::BaseType> transferable_resource_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::TransferableResourceDataView>(
      in_transferable_resource,
      transferable_resource_fragment);

    fragment->transferable_resource.Set(
        transferable_resource_fragment.is_null() ? nullptr : transferable_resource_fragment.data());

    fragment->opaque = Traits::opaque(input);
  }

  static bool Deserialize(::viz::mojom::internal::TransferableUIResourceRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TransferableUIResourceRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::LayerTreeUpdateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::LayerTreeUpdateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::LayerTreeUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::begin_frame_args(input)) in_begin_frame_args = Traits::begin_frame_args(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->begin_frame_args)::BaseType> begin_frame_args_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::BeginFrameArgsDataView>(
      in_begin_frame_args,
      begin_frame_args_fragment);

    fragment->begin_frame_args.Set(
        begin_frame_args_fragment.is_null() ? nullptr : begin_frame_args_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->begin_frame_args.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null begin_frame_args in LayerTreeUpdate struct");

    fragment->source_frame_number = Traits::source_frame_number(input);

    fragment->trace_id = Traits::trace_id(input);

    fragment->primary_main_frame_item_sequence_number = Traits::primary_main_frame_item_sequence_number(input);

    decltype(Traits::selection(input)) in_selection = Traits::selection(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selection)::BaseType> selection_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::cc::mojom::LayerSelectionDataView>(
      in_selection,
      selection_fragment);

    fragment->selection.Set(
        selection_fragment.is_null() ? nullptr : selection_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selection.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selection in LayerTreeUpdate struct");

    fragment->page_scale_factor = Traits::page_scale_factor(input);

    fragment->min_page_scale_factor = Traits::min_page_scale_factor(input);

    fragment->max_page_scale_factor = Traits::max_page_scale_factor(input);

    fragment->external_page_scale_factor = Traits::external_page_scale_factor(input);

    decltype(Traits::device_viewport(input)) in_device_viewport = Traits::device_viewport(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_viewport)::BaseType> device_viewport_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_device_viewport,
      device_viewport_fragment);

    fragment->device_viewport.Set(
        device_viewport_fragment.is_null() ? nullptr : device_viewport_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_viewport.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_viewport in LayerTreeUpdate struct");

    fragment->device_scale_factor = Traits::device_scale_factor(input);

    fragment->painted_device_scale_factor = Traits::painted_device_scale_factor(input);

    decltype(Traits::display_color_spaces(input)) in_display_color_spaces = Traits::display_color_spaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_color_spaces)::BaseType> display_color_spaces_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::DisplayColorSpacesDataView>(
      in_display_color_spaces,
      display_color_spaces_fragment);

    fragment->display_color_spaces.Set(
        display_color_spaces_fragment.is_null() ? nullptr : display_color_spaces_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_color_spaces.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_color_spaces in LayerTreeUpdate struct");

    decltype(Traits::local_surface_id_from_parent(input)) in_local_surface_id_from_parent = Traits::local_surface_id_from_parent(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_surface_id_from_parent)::BaseType> local_surface_id_from_parent_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id_from_parent,
      local_surface_id_from_parent_fragment);

    fragment->local_surface_id_from_parent.Set(
        local_surface_id_from_parent_fragment.is_null() ? nullptr : local_surface_id_from_parent_fragment.data());

    decltype(Traits::current_local_surface_id(input)) in_current_local_surface_id = Traits::current_local_surface_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->current_local_surface_id)::BaseType> current_local_surface_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_current_local_surface_id,
      current_local_surface_id_fragment);

    fragment->current_local_surface_id.Set(
        current_local_surface_id_fragment.is_null() ? nullptr : current_local_surface_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->current_local_surface_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null current_local_surface_id in LayerTreeUpdate struct");

    fragment->next_frame_token = Traits::next_frame_token(input);

    fragment->send_frame_token_to_embedder = Traits::send_frame_token_to_embedder(input);

    decltype(Traits::target_local_surface_id(input)) in_target_local_surface_id = Traits::target_local_surface_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_local_surface_id)::BaseType> target_local_surface_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_target_local_surface_id,
      target_local_surface_id_fragment);

    fragment->target_local_surface_id.Set(
        target_local_surface_id_fragment.is_null() ? nullptr : target_local_surface_id_fragment.data());

    decltype(Traits::background_color(input)) in_background_color = Traits::background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_color)::BaseType> background_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
      in_background_color,
      background_color_fragment);

    fragment->background_color.Set(
        background_color_fragment.is_null() ? nullptr : background_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->background_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background_color in LayerTreeUpdate struct");

    fragment->overscroll_elasticity_transform = Traits::overscroll_elasticity_transform(input);

    fragment->page_scale_transform = Traits::page_scale_transform(input);

    fragment->inner_scroll = Traits::inner_scroll(input);

    fragment->outer_clip = Traits::outer_clip(input);

    fragment->outer_scroll = Traits::outer_scroll(input);

    decltype(Traits::viewport_damage_rect(input)) in_viewport_damage_rect = Traits::viewport_damage_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewport_damage_rect)::BaseType> viewport_damage_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_viewport_damage_rect,
      viewport_damage_rect_fragment);

    fragment->viewport_damage_rect.Set(
        viewport_damage_rect_fragment.is_null() ? nullptr : viewport_damage_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->viewport_damage_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null viewport_damage_rect in LayerTreeUpdate struct");

    decltype(Traits::debug_state(input)) in_debug_state = Traits::debug_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_state)::BaseType> debug_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::cc::mojom::LayerTreeDebugStateDataView>(
      in_debug_state,
      debug_state_fragment);

    fragment->debug_state.Set(
        debug_state_fragment.is_null() ? nullptr : debug_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->debug_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_state in LayerTreeUpdate struct");

    
    mojo::internal::Serialize<::gfx::mojom::OverlayTransform>(
      Traits::display_transform_hint(input),
      &fragment->display_transform_hint);

    fragment->max_safe_area_inset_bottom = Traits::max_safe_area_inset_bottom(input);

    decltype(Traits::browser_controls_params(input)) in_browser_controls_params = Traits::browser_controls_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browser_controls_params)::BaseType> browser_controls_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::cc::mojom::BrowserControlsParamsDataView>(
      in_browser_controls_params,
      browser_controls_params_fragment);

    fragment->browser_controls_params.Set(
        browser_controls_params_fragment.is_null() ? nullptr : browser_controls_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->browser_controls_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_controls_params in LayerTreeUpdate struct");

    decltype(Traits::browser_controls_offset_tag_modifications(input)) in_browser_controls_offset_tag_modifications = Traits::browser_controls_offset_tag_modifications(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browser_controls_offset_tag_modifications)::BaseType> browser_controls_offset_tag_modifications_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::cc::mojom::BrowserControlsOffsetTagModificationsDataView>(
      in_browser_controls_offset_tag_modifications,
      browser_controls_offset_tag_modifications_fragment);

    fragment->browser_controls_offset_tag_modifications.Set(
        browser_controls_offset_tag_modifications_fragment.is_null() ? nullptr : browser_controls_offset_tag_modifications_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->browser_controls_offset_tag_modifications.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_controls_offset_tag_modifications in LayerTreeUpdate struct");

    fragment->top_controls_shown_ratio = Traits::top_controls_shown_ratio(input);

    fragment->bottom_controls_shown_ratio = Traits::bottom_controls_shown_ratio(input);

    decltype(Traits::ui_resource_requests(input)) in_ui_resource_requests = Traits::ui_resource_requests(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ui_resource_requests)::BaseType>
        ui_resource_requests_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ui_resource_requests_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::TransferableUIResourceRequestDataView>>(
      in_ui_resource_requests,
      ui_resource_requests_fragment,
      &ui_resource_requests_validate_params);

    fragment->ui_resource_requests.Set(
        ui_resource_requests_fragment.is_null() ? nullptr : ui_resource_requests_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ui_resource_requests.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ui_resource_requests in LayerTreeUpdate struct");

    decltype(Traits::layers(input)) in_layers = Traits::layers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->layers)::BaseType>
        layers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& layers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::LayerDataView>>(
      in_layers,
      layers_fragment,
      &layers_validate_params);

    fragment->layers.Set(
        layers_fragment.is_null() ? nullptr : layers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->layers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null layers in LayerTreeUpdate struct");

    decltype(Traits::layer_order(input)) in_layer_order = Traits::layer_order(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->layer_order)::BaseType>
        layer_order_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& layer_order_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_layer_order,
      layer_order_fragment,
      &layer_order_validate_params);

    fragment->layer_order.Set(
        layer_order_fragment.is_null() ? nullptr : layer_order_fragment.data());

    decltype(Traits::transform_tree_update(input)) in_transform_tree_update = Traits::transform_tree_update(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transform_tree_update)::BaseType> transform_tree_update_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::TransformTreeUpdateDataView>(
      in_transform_tree_update,
      transform_tree_update_fragment);

    fragment->transform_tree_update.Set(
        transform_tree_update_fragment.is_null() ? nullptr : transform_tree_update_fragment.data());

    decltype(Traits::scroll_tree_update(input)) in_scroll_tree_update = Traits::scroll_tree_update(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_tree_update)::BaseType> scroll_tree_update_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::ScrollTreeUpdateDataView>(
      in_scroll_tree_update,
      scroll_tree_update_fragment);

    fragment->scroll_tree_update.Set(
        scroll_tree_update_fragment.is_null() ? nullptr : scroll_tree_update_fragment.data());

    decltype(Traits::transform_nodes(input)) in_transform_nodes = Traits::transform_nodes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transform_nodes)::BaseType>
        transform_nodes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& transform_nodes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::TransformNodeDataView>>(
      in_transform_nodes,
      transform_nodes_fragment,
      &transform_nodes_validate_params);

    fragment->transform_nodes.Set(
        transform_nodes_fragment.is_null() ? nullptr : transform_nodes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->transform_nodes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transform_nodes in LayerTreeUpdate struct");

    decltype(Traits::clip_nodes(input)) in_clip_nodes = Traits::clip_nodes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->clip_nodes)::BaseType>
        clip_nodes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& clip_nodes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ClipNodeDataView>>(
      in_clip_nodes,
      clip_nodes_fragment,
      &clip_nodes_validate_params);

    fragment->clip_nodes.Set(
        clip_nodes_fragment.is_null() ? nullptr : clip_nodes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->clip_nodes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clip_nodes in LayerTreeUpdate struct");

    decltype(Traits::effect_nodes(input)) in_effect_nodes = Traits::effect_nodes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->effect_nodes)::BaseType>
        effect_nodes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& effect_nodes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::EffectNodeDataView>>(
      in_effect_nodes,
      effect_nodes_fragment,
      &effect_nodes_validate_params);

    fragment->effect_nodes.Set(
        effect_nodes_fragment.is_null() ? nullptr : effect_nodes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->effect_nodes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null effect_nodes in LayerTreeUpdate struct");

    decltype(Traits::scroll_nodes(input)) in_scroll_nodes = Traits::scroll_nodes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_nodes)::BaseType>
        scroll_nodes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& scroll_nodes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ScrollNodeDataView>>(
      in_scroll_nodes,
      scroll_nodes_fragment,
      &scroll_nodes_validate_params);

    fragment->scroll_nodes.Set(
        scroll_nodes_fragment.is_null() ? nullptr : scroll_nodes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scroll_nodes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scroll_nodes in LayerTreeUpdate struct");

    fragment->num_transform_nodes = Traits::num_transform_nodes(input);

    fragment->num_clip_nodes = Traits::num_clip_nodes(input);

    fragment->num_effect_nodes = Traits::num_effect_nodes(input);

    fragment->num_scroll_nodes = Traits::num_scroll_nodes(input);

    decltype(Traits::tilings(input)) in_tilings = Traits::tilings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tilings)::BaseType>
        tilings_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tilings_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::TilingDataView>>(
      in_tilings,
      tilings_fragment,
      &tilings_validate_params);

    fragment->tilings.Set(
        tilings_fragment.is_null() ? nullptr : tilings_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tilings.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tilings in LayerTreeUpdate struct");

    decltype(Traits::surface_ranges(input)) in_surface_ranges = Traits::surface_ranges(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->surface_ranges)::BaseType>
        surface_ranges_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& surface_ranges_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::SurfaceRangeDataView>>(
      in_surface_ranges,
      surface_ranges_fragment,
      &surface_ranges_validate_params);

    fragment->surface_ranges.Set(
        surface_ranges_fragment.is_null() ? nullptr : surface_ranges_fragment.data());

    decltype(Traits::view_transition_requests(input)) in_view_transition_requests = Traits::view_transition_requests(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->view_transition_requests)::BaseType>
        view_transition_requests_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& view_transition_requests_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ViewTransitionRequestDataView>>(
      in_view_transition_requests,
      view_transition_requests_fragment,
      &view_transition_requests_validate_params);

    fragment->view_transition_requests.Set(
        view_transition_requests_fragment.is_null() ? nullptr : view_transition_requests_fragment.data());

    decltype(Traits::animation_timelines(input)) in_animation_timelines = Traits::animation_timelines(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->animation_timelines)::BaseType>
        animation_timelines_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& animation_timelines_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>>(
      in_animation_timelines,
      animation_timelines_fragment,
      &animation_timelines_validate_params);

    fragment->animation_timelines.Set(
        animation_timelines_fragment.is_null() ? nullptr : animation_timelines_fragment.data());

    decltype(Traits::removed_animation_timelines(input)) in_removed_animation_timelines = Traits::removed_animation_timelines(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->removed_animation_timelines)::BaseType>
        removed_animation_timelines_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& removed_animation_timelines_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_removed_animation_timelines,
      removed_animation_timelines_fragment,
      &removed_animation_timelines_validate_params);

    fragment->removed_animation_timelines.Set(
        removed_animation_timelines_fragment.is_null() ? nullptr : removed_animation_timelines_fragment.data());
  }

  static bool Deserialize(::viz::mojom::internal::LayerTreeUpdate_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::LayerTreeUpdateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::PendingLayerContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::PendingLayerContextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::PendingLayerContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::receiver(input)) in_receiver = Traits::receiver(input);

    
    mojo::internal::Serialize<::viz::mojom::LayerContextAssociatedRequestDataView>(
      in_receiver,
      &fragment->receiver,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->receiver)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid receiver in PendingLayerContext struct");

    decltype(Traits::client(input)) in_client = Traits::client(input);

    
    mojo::internal::Serialize<::viz::mojom::LayerContextClientAssociatedPtrInfoDataView>(
      in_client,
      &fragment->client,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->client)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in PendingLayerContext struct");
  }

  static bool Deserialize(::viz::mojom::internal::PendingLayerContext_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::PendingLayerContextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void TransferableUIResourceRequestDataView::GetUidDataView(
    ::cc::mojom::UIResourceIdDataView* output) {
  auto pointer = data_->uid.Get();
  *output = ::cc::mojom::UIResourceIdDataView(pointer, message_);
}
inline void TransferableUIResourceRequestDataView::GetTransferableResourceDataView(
    ::viz::mojom::TransferableResourceDataView* output) {
  auto pointer = data_->transferable_resource.Get();
  *output = ::viz::mojom::TransferableResourceDataView(pointer, message_);
}


inline void LayerTreeUpdateDataView::GetBeginFrameArgsDataView(
    ::viz::mojom::BeginFrameArgsDataView* output) {
  auto pointer = data_->begin_frame_args.Get();
  *output = ::viz::mojom::BeginFrameArgsDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetSelectionDataView(
    ::cc::mojom::LayerSelectionDataView* output) {
  auto pointer = data_->selection.Get();
  *output = ::cc::mojom::LayerSelectionDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetDeviceViewportDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->device_viewport.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetDisplayColorSpacesDataView(
    ::gfx::mojom::DisplayColorSpacesDataView* output) {
  auto pointer = data_->display_color_spaces.Get();
  *output = ::gfx::mojom::DisplayColorSpacesDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetLocalSurfaceIdFromParentDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->local_surface_id_from_parent.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetCurrentLocalSurfaceIdDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->current_local_surface_id.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetTargetLocalSurfaceIdDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->target_local_surface_id.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetBackgroundColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->background_color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetViewportDamageRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->viewport_damage_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetDebugStateDataView(
    ::cc::mojom::LayerTreeDebugStateDataView* output) {
  auto pointer = data_->debug_state.Get();
  *output = ::cc::mojom::LayerTreeDebugStateDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetBrowserControlsParamsDataView(
    ::cc::mojom::BrowserControlsParamsDataView* output) {
  auto pointer = data_->browser_controls_params.Get();
  *output = ::cc::mojom::BrowserControlsParamsDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetBrowserControlsOffsetTagModificationsDataView(
    ::cc::mojom::BrowserControlsOffsetTagModificationsDataView* output) {
  auto pointer = data_->browser_controls_offset_tag_modifications.Get();
  *output = ::cc::mojom::BrowserControlsOffsetTagModificationsDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetUiResourceRequestsDataView(
    mojo::ArrayDataView<TransferableUIResourceRequestDataView>* output) {
  auto pointer = data_->ui_resource_requests.Get();
  *output = mojo::ArrayDataView<TransferableUIResourceRequestDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetLayersDataView(
    mojo::ArrayDataView<::viz::mojom::LayerDataView>* output) {
  auto pointer = data_->layers.Get();
  *output = mojo::ArrayDataView<::viz::mojom::LayerDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetLayerOrderDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->layer_order.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetTransformTreeUpdateDataView(
    ::viz::mojom::TransformTreeUpdateDataView* output) {
  auto pointer = data_->transform_tree_update.Get();
  *output = ::viz::mojom::TransformTreeUpdateDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetScrollTreeUpdateDataView(
    ::viz::mojom::ScrollTreeUpdateDataView* output) {
  auto pointer = data_->scroll_tree_update.Get();
  *output = ::viz::mojom::ScrollTreeUpdateDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetTransformNodesDataView(
    mojo::ArrayDataView<::viz::mojom::TransformNodeDataView>* output) {
  auto pointer = data_->transform_nodes.Get();
  *output = mojo::ArrayDataView<::viz::mojom::TransformNodeDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetClipNodesDataView(
    mojo::ArrayDataView<::viz::mojom::ClipNodeDataView>* output) {
  auto pointer = data_->clip_nodes.Get();
  *output = mojo::ArrayDataView<::viz::mojom::ClipNodeDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetEffectNodesDataView(
    mojo::ArrayDataView<::viz::mojom::EffectNodeDataView>* output) {
  auto pointer = data_->effect_nodes.Get();
  *output = mojo::ArrayDataView<::viz::mojom::EffectNodeDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetScrollNodesDataView(
    mojo::ArrayDataView<::viz::mojom::ScrollNodeDataView>* output) {
  auto pointer = data_->scroll_nodes.Get();
  *output = mojo::ArrayDataView<::viz::mojom::ScrollNodeDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetTilingsDataView(
    mojo::ArrayDataView<::viz::mojom::TilingDataView>* output) {
  auto pointer = data_->tilings.Get();
  *output = mojo::ArrayDataView<::viz::mojom::TilingDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetSurfaceRangesDataView(
    mojo::ArrayDataView<::viz::mojom::SurfaceRangeDataView>* output) {
  auto pointer = data_->surface_ranges.Get();
  *output = mojo::ArrayDataView<::viz::mojom::SurfaceRangeDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetViewTransitionRequestsDataView(
    mojo::ArrayDataView<::viz::mojom::ViewTransitionRequestDataView>* output) {
  auto pointer = data_->view_transition_requests.Get();
  *output = mojo::ArrayDataView<::viz::mojom::ViewTransitionRequestDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetAnimationTimelinesDataView(
    mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>* output) {
  auto pointer = data_->animation_timelines.Get();
  *output = mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetRemovedAnimationTimelinesDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->removed_animation_timelines.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}





}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::TransferableUIResourceRequest_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::TransferableUIResourceRequest_Type value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_SHARED_H_