// services/viz/public/mojom/compositing/layer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/layer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/layer.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/layer.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/layer.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/layer.mojom-test-utils.h"


namespace viz::mojom {
RareProperties::RareProperties()
    : filter_quality(mojo::internal::ConvertEnumValue<::cc::mojom::FilterQuality, ::cc::PaintFlags::FilterQuality>(::cc::mojom::FilterQuality::kLow)),
      dynamic_range_limit(),
      capture_bounds() {}

RareProperties::RareProperties(
    ::cc::PaintFlags::FilterQuality filter_quality_in,
    const ::cc::PaintFlags::DynamicRangeLimitMixture& dynamic_range_limit_in,
    const ::viz::RegionCaptureBounds& capture_bounds_in)
    : filter_quality(std::move(filter_quality_in)),
      dynamic_range_limit(std::move(dynamic_range_limit_in)),
      capture_bounds(std::move(capture_bounds_in)) {}

RareProperties::~RareProperties() = default;

void RareProperties::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filter_quality"), this->filter_quality,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::PaintFlags::FilterQuality>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dynamic_range_limit"), this->dynamic_range_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::cc::PaintFlags::DynamicRangeLimitMixture&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_bounds"), this->capture_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::RegionCaptureBounds&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RareProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MirrorLayerExtra::MirrorLayerExtra()
    : mirrored_layer_id() {}

MirrorLayerExtra::MirrorLayerExtra(
    int32_t mirrored_layer_id_in)
    : mirrored_layer_id(std::move(mirrored_layer_id_in)) {}

MirrorLayerExtra::~MirrorLayerExtra() = default;
size_t MirrorLayerExtra::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->mirrored_layer_id);
  return seed;
}

void MirrorLayerExtra::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mirrored_layer_id"), this->mirrored_layer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MirrorLayerExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SurfaceLayerExtra::SurfaceLayerExtra()
    : surface_range(),
      deadline_in_frames(),
      stretch_content_to_fill_bounds(),
      surface_hit_testable(),
      has_pointer_events_none(),
      is_reflection(),
      will_draw_needs_reset(),
      override_child_paint_flags() {}

SurfaceLayerExtra::SurfaceLayerExtra(
    const ::viz::SurfaceRange& surface_range_in,
    std::optional<uint32_t> deadline_in_frames_in,
    bool stretch_content_to_fill_bounds_in,
    bool surface_hit_testable_in,
    bool has_pointer_events_none_in,
    bool is_reflection_in,
    bool will_draw_needs_reset_in,
    bool override_child_paint_flags_in)
    : surface_range(std::move(surface_range_in)),
      deadline_in_frames(std::move(deadline_in_frames_in)),
      stretch_content_to_fill_bounds(std::move(stretch_content_to_fill_bounds_in)),
      surface_hit_testable(std::move(surface_hit_testable_in)),
      has_pointer_events_none(std::move(has_pointer_events_none_in)),
      is_reflection(std::move(is_reflection_in)),
      will_draw_needs_reset(std::move(will_draw_needs_reset_in)),
      override_child_paint_flags(std::move(override_child_paint_flags_in)) {}

SurfaceLayerExtra::~SurfaceLayerExtra() = default;

void SurfaceLayerExtra::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_range"), this->surface_range,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::SurfaceRange&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deadline_in_frames"), this->deadline_in_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stretch_content_to_fill_bounds"), this->stretch_content_to_fill_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_hit_testable"), this->surface_hit_testable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_pointer_events_none"), this->has_pointer_events_none,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_reflection"), this->is_reflection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "will_draw_needs_reset"), this->will_draw_needs_reset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "override_child_paint_flags"), this->override_child_paint_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SurfaceLayerExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextureLayerExtra::TextureLayerExtra()
    : blend_background_color(),
      force_texture_to_opaque(),
      uv_top_left(),
      uv_bottom_right(),
      transferable_resource() {}

TextureLayerExtra::TextureLayerExtra(
    bool blend_background_color_in,
    bool force_texture_to_opaque_in,
    const ::gfx::PointF& uv_top_left_in,
    const ::gfx::PointF& uv_bottom_right_in,
    const std::optional<::viz::TransferableResource>& transferable_resource_in)
    : blend_background_color(std::move(blend_background_color_in)),
      force_texture_to_opaque(std::move(force_texture_to_opaque_in)),
      uv_top_left(std::move(uv_top_left_in)),
      uv_bottom_right(std::move(uv_bottom_right_in)),
      transferable_resource(std::move(transferable_resource_in)) {}

TextureLayerExtra::~TextureLayerExtra() = default;

void TextureLayerExtra::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blend_background_color"), this->blend_background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_texture_to_opaque"), this->force_texture_to_opaque,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uv_top_left"), this->uv_top_left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uv_bottom_right"), this->uv_bottom_right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transferable_resource"), this->transferable_resource,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::viz::TransferableResource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TextureLayerExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UIResourceLayerExtra::UIResourceLayerExtra()
    : ui_resource_id(),
      image_bounds(),
      uv_top_left(),
      uv_bottom_right() {}

UIResourceLayerExtra::UIResourceLayerExtra(
    ::cc::UIResourceId ui_resource_id_in,
    const ::gfx::Size& image_bounds_in,
    const ::gfx::PointF& uv_top_left_in,
    const ::gfx::PointF& uv_bottom_right_in)
    : ui_resource_id(std::move(ui_resource_id_in)),
      image_bounds(std::move(image_bounds_in)),
      uv_top_left(std::move(uv_top_left_in)),
      uv_bottom_right(std::move(uv_bottom_right_in)) {}

UIResourceLayerExtra::~UIResourceLayerExtra() = default;

void UIResourceLayerExtra::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ui_resource_id"), this->ui_resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::UIResourceId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_bounds"), this->image_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uv_top_left"), this->uv_top_left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uv_bottom_right"), this->uv_bottom_right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UIResourceLayerExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TileDisplayLayerExtra::TileDisplayLayerExtra()
    : solid_color(),
      is_backdrop_filter_mask(),
      is_directly_composited_image(),
      nearest_neighbor(),
      content_color_usage() {}

TileDisplayLayerExtra::TileDisplayLayerExtra(
    const std::optional<::SkColor4f>& solid_color_in,
    bool is_backdrop_filter_mask_in,
    bool is_directly_composited_image_in,
    bool nearest_neighbor_in,
    ::gfx::ContentColorUsage content_color_usage_in)
    : solid_color(std::move(solid_color_in)),
      is_backdrop_filter_mask(std::move(is_backdrop_filter_mask_in)),
      is_directly_composited_image(std::move(is_directly_composited_image_in)),
      nearest_neighbor(std::move(nearest_neighbor_in)),
      content_color_usage(std::move(content_color_usage_in)) {}

TileDisplayLayerExtra::~TileDisplayLayerExtra() = default;

void TileDisplayLayerExtra::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "solid_color"), this->solid_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::SkColor4f>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_backdrop_filter_mask"), this->is_backdrop_filter_mask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_directly_composited_image"), this->is_directly_composited_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nearest_neighbor"), this->nearest_neighbor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_color_usage"), this->content_color_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::ContentColorUsage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TileDisplayLayerExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollbarLayerBaseExtra::ScrollbarLayerBaseExtra()
    : scroll_element_id(),
      is_overlay_scrollbar(),
      is_web_test(),
      thumb_thickness_scale_factor(),
      current_pos(),
      clip_layer_length(),
      scroll_layer_length(),
      is_horizontal_orientation(),
      is_left_side_vertical_scrollbar(),
      vertical_adjust(),
      has_find_in_page_tickmarks() {}

ScrollbarLayerBaseExtra::ScrollbarLayerBaseExtra(
    ::cc::ElementId scroll_element_id_in,
    bool is_overlay_scrollbar_in,
    bool is_web_test_in,
    float thumb_thickness_scale_factor_in,
    float current_pos_in,
    float clip_layer_length_in,
    float scroll_layer_length_in,
    bool is_horizontal_orientation_in,
    bool is_left_side_vertical_scrollbar_in,
    float vertical_adjust_in,
    bool has_find_in_page_tickmarks_in)
    : scroll_element_id(std::move(scroll_element_id_in)),
      is_overlay_scrollbar(std::move(is_overlay_scrollbar_in)),
      is_web_test(std::move(is_web_test_in)),
      thumb_thickness_scale_factor(std::move(thumb_thickness_scale_factor_in)),
      current_pos(std::move(current_pos_in)),
      clip_layer_length(std::move(clip_layer_length_in)),
      scroll_layer_length(std::move(scroll_layer_length_in)),
      is_horizontal_orientation(std::move(is_horizontal_orientation_in)),
      is_left_side_vertical_scrollbar(std::move(is_left_side_vertical_scrollbar_in)),
      vertical_adjust(std::move(vertical_adjust_in)),
      has_find_in_page_tickmarks(std::move(has_find_in_page_tickmarks_in)) {}

ScrollbarLayerBaseExtra::~ScrollbarLayerBaseExtra() = default;

void ScrollbarLayerBaseExtra::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_element_id"), this->scroll_element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_overlay_scrollbar"), this->is_overlay_scrollbar,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_web_test"), this->is_web_test,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thumb_thickness_scale_factor"), this->thumb_thickness_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_pos"), this->current_pos,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_layer_length"), this->clip_layer_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_layer_length"), this->scroll_layer_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_horizontal_orientation"), this->is_horizontal_orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_left_side_vertical_scrollbar"), this->is_left_side_vertical_scrollbar,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vertical_adjust"), this->vertical_adjust,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_find_in_page_tickmarks"), this->has_find_in_page_tickmarks,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollbarLayerBaseExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NinePatchThumbScrollbarLayerExtra::NinePatchThumbScrollbarLayerExtra()
    : scrollbar_base_extra(),
      thumb_thickness(),
      thumb_length(),
      track_start(),
      track_length(),
      image_bounds(),
      aperture(),
      thumb_ui_resource_id(),
      track_and_buttons_ui_resource_id() {}

NinePatchThumbScrollbarLayerExtra::NinePatchThumbScrollbarLayerExtra(
    ScrollbarLayerBaseExtraPtr scrollbar_base_extra_in,
    int32_t thumb_thickness_in,
    int32_t thumb_length_in,
    int32_t track_start_in,
    int32_t track_length_in,
    const ::gfx::Size& image_bounds_in,
    const ::gfx::Rect& aperture_in,
    ::cc::UIResourceId thumb_ui_resource_id_in,
    ::cc::UIResourceId track_and_buttons_ui_resource_id_in)
    : scrollbar_base_extra(std::move(scrollbar_base_extra_in)),
      thumb_thickness(std::move(thumb_thickness_in)),
      thumb_length(std::move(thumb_length_in)),
      track_start(std::move(track_start_in)),
      track_length(std::move(track_length_in)),
      image_bounds(std::move(image_bounds_in)),
      aperture(std::move(aperture_in)),
      thumb_ui_resource_id(std::move(thumb_ui_resource_id_in)),
      track_and_buttons_ui_resource_id(std::move(track_and_buttons_ui_resource_id_in)) {}

NinePatchThumbScrollbarLayerExtra::~NinePatchThumbScrollbarLayerExtra() = default;

void NinePatchThumbScrollbarLayerExtra::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrollbar_base_extra"), this->scrollbar_base_extra,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollbarLayerBaseExtraPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thumb_thickness"), this->thumb_thickness,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thumb_length"), this->thumb_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "track_start"), this->track_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "track_length"), this->track_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_bounds"), this->image_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aperture"), this->aperture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thumb_ui_resource_id"), this->thumb_ui_resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::UIResourceId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "track_and_buttons_ui_resource_id"), this->track_and_buttons_ui_resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::UIResourceId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NinePatchThumbScrollbarLayerExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaintedScrollbarLayerExtra::PaintedScrollbarLayerExtra()
    : scrollbar_base_extra(),
      internal_contents_scale(),
      internal_content_bounds(),
      jump_on_track_click(),
      supports_drag_snap_back(),
      thumb_thickness(),
      thumb_length(),
      back_button_rect(),
      forward_button_rect(),
      track_rect(),
      thumb_color(),
      uses_nine_patch_track_and_buttons(),
      track_and_buttons_image_bounds(),
      track_and_buttons_aperture(),
      painted_opacity(),
      track_and_buttons_ui_resource_id(),
      thumb_ui_resource_id() {}

PaintedScrollbarLayerExtra::PaintedScrollbarLayerExtra(
    ScrollbarLayerBaseExtraPtr scrollbar_base_extra_in,
    float internal_contents_scale_in,
    const ::gfx::Size& internal_content_bounds_in,
    bool jump_on_track_click_in,
    bool supports_drag_snap_back_in,
    int32_t thumb_thickness_in,
    int32_t thumb_length_in,
    const ::gfx::Rect& back_button_rect_in,
    const ::gfx::Rect& forward_button_rect_in,
    const ::gfx::Rect& track_rect_in,
    const std::optional<::SkColor4f>& thumb_color_in,
    bool uses_nine_patch_track_and_buttons_in,
    const ::gfx::Size& track_and_buttons_image_bounds_in,
    const ::gfx::Rect& track_and_buttons_aperture_in,
    float painted_opacity_in,
    ::cc::UIResourceId track_and_buttons_ui_resource_id_in,
    ::cc::UIResourceId thumb_ui_resource_id_in)
    : scrollbar_base_extra(std::move(scrollbar_base_extra_in)),
      internal_contents_scale(std::move(internal_contents_scale_in)),
      internal_content_bounds(std::move(internal_content_bounds_in)),
      jump_on_track_click(std::move(jump_on_track_click_in)),
      supports_drag_snap_back(std::move(supports_drag_snap_back_in)),
      thumb_thickness(std::move(thumb_thickness_in)),
      thumb_length(std::move(thumb_length_in)),
      back_button_rect(std::move(back_button_rect_in)),
      forward_button_rect(std::move(forward_button_rect_in)),
      track_rect(std::move(track_rect_in)),
      thumb_color(std::move(thumb_color_in)),
      uses_nine_patch_track_and_buttons(std::move(uses_nine_patch_track_and_buttons_in)),
      track_and_buttons_image_bounds(std::move(track_and_buttons_image_bounds_in)),
      track_and_buttons_aperture(std::move(track_and_buttons_aperture_in)),
      painted_opacity(std::move(painted_opacity_in)),
      track_and_buttons_ui_resource_id(std::move(track_and_buttons_ui_resource_id_in)),
      thumb_ui_resource_id(std::move(thumb_ui_resource_id_in)) {}

PaintedScrollbarLayerExtra::~PaintedScrollbarLayerExtra() = default;

void PaintedScrollbarLayerExtra::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrollbar_base_extra"), this->scrollbar_base_extra,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollbarLayerBaseExtraPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "internal_contents_scale"), this->internal_contents_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "internal_content_bounds"), this->internal_content_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "jump_on_track_click"), this->jump_on_track_click,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_drag_snap_back"), this->supports_drag_snap_back,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thumb_thickness"), this->thumb_thickness,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thumb_length"), this->thumb_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "back_button_rect"), this->back_button_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "forward_button_rect"), this->forward_button_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "track_rect"), this->track_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thumb_color"), this->thumb_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::SkColor4f>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uses_nine_patch_track_and_buttons"), this->uses_nine_patch_track_and_buttons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "track_and_buttons_image_bounds"), this->track_and_buttons_image_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "track_and_buttons_aperture"), this->track_and_buttons_aperture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "painted_opacity"), this->painted_opacity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "track_and_buttons_ui_resource_id"), this->track_and_buttons_ui_resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::UIResourceId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thumb_ui_resource_id"), this->thumb_ui_resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::UIResourceId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaintedScrollbarLayerExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SolidColorScrollbarLayerExtra::SolidColorScrollbarLayerExtra()
    : scrollbar_base_extra(),
      thumb_thickness(),
      track_start(),
      color() {}

SolidColorScrollbarLayerExtra::SolidColorScrollbarLayerExtra(
    ScrollbarLayerBaseExtraPtr scrollbar_base_extra_in,
    int32_t thumb_thickness_in,
    int32_t track_start_in,
    const ::SkColor4f& color_in)
    : scrollbar_base_extra(std::move(scrollbar_base_extra_in)),
      thumb_thickness(std::move(thumb_thickness_in)),
      track_start(std::move(track_start_in)),
      color(std::move(color_in)) {}

SolidColorScrollbarLayerExtra::~SolidColorScrollbarLayerExtra() = default;

void SolidColorScrollbarLayerExtra::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrollbar_base_extra"), this->scrollbar_base_extra,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollbarLayerBaseExtraPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thumb_thickness"), this->thumb_thickness,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "track_start"), this->track_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SolidColorScrollbarLayerExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ViewTransitionContentLayerExtra::ViewTransitionContentLayerExtra()
    : resource_id(),
      is_live_content_layer(),
      max_extents_rect() {}

ViewTransitionContentLayerExtra::ViewTransitionContentLayerExtra(
    const ::viz::ViewTransitionElementResourceId& resource_id_in,
    bool is_live_content_layer_in,
    const ::gfx::RectF& max_extents_rect_in)
    : resource_id(std::move(resource_id_in)),
      is_live_content_layer(std::move(is_live_content_layer_in)),
      max_extents_rect(std::move(max_extents_rect_in)) {}

ViewTransitionContentLayerExtra::~ViewTransitionContentLayerExtra() = default;

void ViewTransitionContentLayerExtra::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_id"), this->resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::ViewTransitionElementResourceId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_live_content_layer"), this->is_live_content_layer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_extents_rect"), this->max_extents_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ViewTransitionContentLayerExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NinePatchLayerExtra::NinePatchLayerExtra()
    : image_aperture(),
      border(),
      layer_occlusion(),
      fill_center(),
      ui_resource_id(),
      image_bounds(),
      uv_top_left(),
      uv_bottom_right() {}

NinePatchLayerExtra::NinePatchLayerExtra(
    const ::gfx::Rect& image_aperture_in,
    const ::gfx::Rect& border_in,
    const ::gfx::Rect& layer_occlusion_in,
    bool fill_center_in,
    ::cc::UIResourceId ui_resource_id_in,
    const ::gfx::Size& image_bounds_in,
    const ::gfx::PointF& uv_top_left_in,
    const ::gfx::PointF& uv_bottom_right_in)
    : image_aperture(std::move(image_aperture_in)),
      border(std::move(border_in)),
      layer_occlusion(std::move(layer_occlusion_in)),
      fill_center(std::move(fill_center_in)),
      ui_resource_id(std::move(ui_resource_id_in)),
      image_bounds(std::move(image_bounds_in)),
      uv_top_left(std::move(uv_top_left_in)),
      uv_bottom_right(std::move(uv_bottom_right_in)) {}

NinePatchLayerExtra::~NinePatchLayerExtra() = default;

void NinePatchLayerExtra::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_aperture"), this->image_aperture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "border"), this->border,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_occlusion"), this->layer_occlusion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fill_center"), this->fill_center,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ui_resource_id"), this->ui_resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::UIResourceId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_bounds"), this->image_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uv_top_left"), this->uv_top_left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uv_bottom_right"), this->uv_bottom_right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NinePatchLayerExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Layer::Layer()
    : id(),
      type(),
      bounds(),
      contents_opaque(),
      contents_opaque_for_text(),
      is_drawable(),
      layer_property_changed_not_from_property_trees(),
      layer_property_changed_from_property_trees(),
      hit_test_opaqueness(),
      background_color(),
      safe_opaque_background_color(),
      element_id(),
      update_rect(),
      offset_to_transform_parent(),
      transform_tree_index(),
      clip_tree_index(),
      effect_tree_index(),
      scroll_tree_index(),
      should_check_backface_visibility(),
      rare_properties(),
      layer_extra() {}

Layer::Layer(
    int64_t id_in,
    ::cc::mojom::LayerType type_in,
    const ::gfx::Size& bounds_in,
    bool contents_opaque_in,
    bool contents_opaque_for_text_in,
    bool is_drawable_in,
    bool layer_property_changed_not_from_property_trees_in,
    bool layer_property_changed_from_property_trees_in,
    ::cc::HitTestOpaqueness hit_test_opaqueness_in,
    const ::SkColor4f& background_color_in,
    const ::SkColor4f& safe_opaque_background_color_in,
    ::cc::ElementId element_id_in,
    const ::gfx::Rect& update_rect_in,
    const ::gfx::Vector2dF& offset_to_transform_parent_in,
    int32_t transform_tree_index_in,
    int32_t clip_tree_index_in,
    int32_t effect_tree_index_in,
    int32_t scroll_tree_index_in,
    bool should_check_backface_visibility_in,
    RarePropertiesPtr rare_properties_in,
    LayerExtraPtr layer_extra_in)
    : id(std::move(id_in)),
      type(std::move(type_in)),
      bounds(std::move(bounds_in)),
      contents_opaque(std::move(contents_opaque_in)),
      contents_opaque_for_text(std::move(contents_opaque_for_text_in)),
      is_drawable(std::move(is_drawable_in)),
      layer_property_changed_not_from_property_trees(std::move(layer_property_changed_not_from_property_trees_in)),
      layer_property_changed_from_property_trees(std::move(layer_property_changed_from_property_trees_in)),
      hit_test_opaqueness(std::move(hit_test_opaqueness_in)),
      background_color(std::move(background_color_in)),
      safe_opaque_background_color(std::move(safe_opaque_background_color_in)),
      element_id(std::move(element_id_in)),
      update_rect(std::move(update_rect_in)),
      offset_to_transform_parent(std::move(offset_to_transform_parent_in)),
      transform_tree_index(std::move(transform_tree_index_in)),
      clip_tree_index(std::move(clip_tree_index_in)),
      effect_tree_index(std::move(effect_tree_index_in)),
      scroll_tree_index(std::move(scroll_tree_index_in)),
      should_check_backface_visibility(std::move(should_check_backface_visibility_in)),
      rare_properties(std::move(rare_properties_in)),
      layer_extra(std::move(layer_extra_in)) {}

Layer::~Layer() = default;

void Layer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::mojom::LayerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents_opaque"), this->contents_opaque,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents_opaque_for_text"), this->contents_opaque_for_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_drawable"), this->is_drawable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_property_changed_not_from_property_trees"), this->layer_property_changed_not_from_property_trees,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_property_changed_from_property_trees"), this->layer_property_changed_from_property_trees,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_test_opaqueness"), this->hit_test_opaqueness,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::HitTestOpaqueness>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "safe_opaque_background_color"), this->safe_opaque_background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_rect"), this->update_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset_to_transform_parent"), this->offset_to_transform_parent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_tree_index"), this->transform_tree_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_tree_index"), this->clip_tree_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "effect_tree_index"), this->effect_tree_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_tree_index"), this->scroll_tree_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_check_backface_visibility"), this->should_check_backface_visibility,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rare_properties"), this->rare_properties,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RarePropertiesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_extra"), this->layer_extra,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LayerExtraPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Layer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorPositionScrollData::AnchorPositionScrollData()
    : adjustment_container_ids(),
      accumulated_scroll_origin(),
      needs_scroll_adjustment_in_x(),
      needs_scroll_adjustment_in_y() {}

AnchorPositionScrollData::AnchorPositionScrollData(
    std::vector<::cc::ElementId> adjustment_container_ids_in,
    const ::gfx::Vector2d& accumulated_scroll_origin_in,
    bool needs_scroll_adjustment_in_x_in,
    bool needs_scroll_adjustment_in_y_in)
    : adjustment_container_ids(std::move(adjustment_container_ids_in)),
      accumulated_scroll_origin(std::move(accumulated_scroll_origin_in)),
      needs_scroll_adjustment_in_x(std::move(needs_scroll_adjustment_in_x_in)),
      needs_scroll_adjustment_in_y(std::move(needs_scroll_adjustment_in_y_in)) {}

AnchorPositionScrollData::~AnchorPositionScrollData() = default;

void AnchorPositionScrollData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "adjustment_container_ids"), this->adjustment_container_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::cc::ElementId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accumulated_scroll_origin"), this->accumulated_scroll_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2d&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_scroll_adjustment_in_x"), this->needs_scroll_adjustment_in_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_scroll_adjustment_in_y"), this->needs_scroll_adjustment_in_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorPositionScrollData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StickyPositionNodeData::StickyPositionNodeData()
    : scroll_ancestor(),
      is_anchored_left(),
      is_anchored_right(),
      is_anchored_top(),
      is_anchored_bottom(),
      left_offset(),
      right_offset(),
      top_offset(),
      bottom_offset(),
      constraint_box_rect(),
      scroll_container_relative_sticky_box_rect(),
      scroll_container_relative_containing_block_rect(),
      pixel_snap_offset(),
      nearest_node_shifting_sticky_box(),
      nearest_node_shifting_containing_block(),
      total_sticky_box_sticky_offset(),
      total_containing_block_sticky_offset() {}

StickyPositionNodeData::StickyPositionNodeData(
    int32_t scroll_ancestor_in,
    bool is_anchored_left_in,
    bool is_anchored_right_in,
    bool is_anchored_top_in,
    bool is_anchored_bottom_in,
    float left_offset_in,
    float right_offset_in,
    float top_offset_in,
    float bottom_offset_in,
    const ::gfx::RectF& constraint_box_rect_in,
    const ::gfx::RectF& scroll_container_relative_sticky_box_rect_in,
    const ::gfx::RectF& scroll_container_relative_containing_block_rect_in,
    const ::gfx::Vector2dF& pixel_snap_offset_in,
    int32_t nearest_node_shifting_sticky_box_in,
    int32_t nearest_node_shifting_containing_block_in,
    const ::gfx::Vector2dF& total_sticky_box_sticky_offset_in,
    const ::gfx::Vector2dF& total_containing_block_sticky_offset_in)
    : scroll_ancestor(std::move(scroll_ancestor_in)),
      is_anchored_left(std::move(is_anchored_left_in)),
      is_anchored_right(std::move(is_anchored_right_in)),
      is_anchored_top(std::move(is_anchored_top_in)),
      is_anchored_bottom(std::move(is_anchored_bottom_in)),
      left_offset(std::move(left_offset_in)),
      right_offset(std::move(right_offset_in)),
      top_offset(std::move(top_offset_in)),
      bottom_offset(std::move(bottom_offset_in)),
      constraint_box_rect(std::move(constraint_box_rect_in)),
      scroll_container_relative_sticky_box_rect(std::move(scroll_container_relative_sticky_box_rect_in)),
      scroll_container_relative_containing_block_rect(std::move(scroll_container_relative_containing_block_rect_in)),
      pixel_snap_offset(std::move(pixel_snap_offset_in)),
      nearest_node_shifting_sticky_box(std::move(nearest_node_shifting_sticky_box_in)),
      nearest_node_shifting_containing_block(std::move(nearest_node_shifting_containing_block_in)),
      total_sticky_box_sticky_offset(std::move(total_sticky_box_sticky_offset_in)),
      total_containing_block_sticky_offset(std::move(total_containing_block_sticky_offset_in)) {}

StickyPositionNodeData::~StickyPositionNodeData() = default;

void StickyPositionNodeData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_ancestor"), this->scroll_ancestor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_anchored_left"), this->is_anchored_left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_anchored_right"), this->is_anchored_right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_anchored_top"), this->is_anchored_top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_anchored_bottom"), this->is_anchored_bottom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left_offset"), this->left_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right_offset"), this->right_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_offset"), this->top_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bottom_offset"), this->bottom_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "constraint_box_rect"), this->constraint_box_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_container_relative_sticky_box_rect"), this->scroll_container_relative_sticky_box_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_container_relative_containing_block_rect"), this->scroll_container_relative_containing_block_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_snap_offset"), this->pixel_snap_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nearest_node_shifting_sticky_box"), this->nearest_node_shifting_sticky_box,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nearest_node_shifting_containing_block"), this->nearest_node_shifting_containing_block,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_sticky_box_sticky_offset"), this->total_sticky_box_sticky_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_containing_block_sticky_offset"), this->total_containing_block_sticky_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StickyPositionNodeData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TransformTreeUpdate::TransformTreeUpdate()
    : page_scale_factor(),
      device_scale_factor(),
      device_transform_scale_factor(),
      nodes_affected_by_outer_viewport_bounds_delta(),
      nodes_affected_by_safe_area_bottom(),
      sticky_position_data(),
      anchor_position_scroll_data() {}

TransformTreeUpdate::TransformTreeUpdate(
    float page_scale_factor_in,
    float device_scale_factor_in,
    float device_transform_scale_factor_in,
    std::vector<int32_t> nodes_affected_by_outer_viewport_bounds_delta_in,
    std::vector<int32_t> nodes_affected_by_safe_area_bottom_in,
    std::vector<StickyPositionNodeDataPtr> sticky_position_data_in,
    std::vector<AnchorPositionScrollDataPtr> anchor_position_scroll_data_in)
    : page_scale_factor(std::move(page_scale_factor_in)),
      device_scale_factor(std::move(device_scale_factor_in)),
      device_transform_scale_factor(std::move(device_transform_scale_factor_in)),
      nodes_affected_by_outer_viewport_bounds_delta(std::move(nodes_affected_by_outer_viewport_bounds_delta_in)),
      nodes_affected_by_safe_area_bottom(std::move(nodes_affected_by_safe_area_bottom_in)),
      sticky_position_data(std::move(sticky_position_data_in)),
      anchor_position_scroll_data(std::move(anchor_position_scroll_data_in)) {}

TransformTreeUpdate::~TransformTreeUpdate() = default;

void TransformTreeUpdate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_transform_scale_factor"), this->device_transform_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nodes_affected_by_outer_viewport_bounds_delta"), this->nodes_affected_by_outer_viewport_bounds_delta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nodes_affected_by_safe_area_bottom"), this->nodes_affected_by_safe_area_bottom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sticky_position_data"), this->sticky_position_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<StickyPositionNodeDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_position_scroll_data"), this->anchor_position_scroll_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AnchorPositionScrollDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TransformTreeUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TransformNode::TransformNode()
    : id(),
      parent_id(),
      parent_frame_id(),
      element_id(),
      local(),
      origin(),
      post_translation(),
      to_parent(),
      scroll_offset(),
      snap_amount(),
      sticky_position_constraint_id(),
      anchor_position_scroll_data_id(),
      sorting_context_id(),
      has_potential_animation(),
      is_currently_animating(),
      flattens_inherited_transform(),
      scrolls(),
      should_undo_overscroll(),
      should_be_snapped(),
      moved_by_outer_viewport_bounds_delta_y(),
      in_subtree_of_page_scale_layer(),
      transform_changed(),
      delegates_to_parent_for_backface(),
      will_change_transform(),
      maximum_animation_scale(),
      node_and_ancestors_are_animated_or_invertible(),
      is_invertible(),
      ancestors_are_invertible(),
      node_and_ancestors_are_flat(),
      node_or_ancestors_will_change_transform(),
      visible_frame_element_id(),
      damage_reasons_bit_mask(),
      moved_by_safe_area_bottom() {}

TransformNode::TransformNode(
    int32_t id_in,
    int32_t parent_id_in,
    int32_t parent_frame_id_in,
    ::cc::ElementId element_id_in,
    const ::gfx::Transform& local_in,
    const ::gfx::Point3F& origin_in,
    const ::gfx::Vector2dF& post_translation_in,
    const ::gfx::Transform& to_parent_in,
    const ::gfx::PointF& scroll_offset_in,
    const ::gfx::Vector2dF& snap_amount_in,
    std::optional<uint32_t> sticky_position_constraint_id_in,
    std::optional<uint32_t> anchor_position_scroll_data_id_in,
    int32_t sorting_context_id_in,
    bool has_potential_animation_in,
    bool is_currently_animating_in,
    bool flattens_inherited_transform_in,
    bool scrolls_in,
    bool should_undo_overscroll_in,
    bool should_be_snapped_in,
    bool moved_by_outer_viewport_bounds_delta_y_in,
    bool in_subtree_of_page_scale_layer_in,
    bool transform_changed_in,
    bool delegates_to_parent_for_backface_in,
    bool will_change_transform_in,
    float maximum_animation_scale_in,
    bool node_and_ancestors_are_animated_or_invertible_in,
    bool is_invertible_in,
    bool ancestors_are_invertible_in,
    bool node_and_ancestors_are_flat_in,
    bool node_or_ancestors_will_change_transform_in,
    ::cc::ElementId visible_frame_element_id_in,
    uint64_t damage_reasons_bit_mask_in,
    bool moved_by_safe_area_bottom_in)
    : id(std::move(id_in)),
      parent_id(std::move(parent_id_in)),
      parent_frame_id(std::move(parent_frame_id_in)),
      element_id(std::move(element_id_in)),
      local(std::move(local_in)),
      origin(std::move(origin_in)),
      post_translation(std::move(post_translation_in)),
      to_parent(std::move(to_parent_in)),
      scroll_offset(std::move(scroll_offset_in)),
      snap_amount(std::move(snap_amount_in)),
      sticky_position_constraint_id(std::move(sticky_position_constraint_id_in)),
      anchor_position_scroll_data_id(std::move(anchor_position_scroll_data_id_in)),
      sorting_context_id(std::move(sorting_context_id_in)),
      has_potential_animation(std::move(has_potential_animation_in)),
      is_currently_animating(std::move(is_currently_animating_in)),
      flattens_inherited_transform(std::move(flattens_inherited_transform_in)),
      scrolls(std::move(scrolls_in)),
      should_undo_overscroll(std::move(should_undo_overscroll_in)),
      should_be_snapped(std::move(should_be_snapped_in)),
      moved_by_outer_viewport_bounds_delta_y(std::move(moved_by_outer_viewport_bounds_delta_y_in)),
      in_subtree_of_page_scale_layer(std::move(in_subtree_of_page_scale_layer_in)),
      transform_changed(std::move(transform_changed_in)),
      delegates_to_parent_for_backface(std::move(delegates_to_parent_for_backface_in)),
      will_change_transform(std::move(will_change_transform_in)),
      maximum_animation_scale(std::move(maximum_animation_scale_in)),
      node_and_ancestors_are_animated_or_invertible(std::move(node_and_ancestors_are_animated_or_invertible_in)),
      is_invertible(std::move(is_invertible_in)),
      ancestors_are_invertible(std::move(ancestors_are_invertible_in)),
      node_and_ancestors_are_flat(std::move(node_and_ancestors_are_flat_in)),
      node_or_ancestors_will_change_transform(std::move(node_or_ancestors_will_change_transform_in)),
      visible_frame_element_id(std::move(visible_frame_element_id_in)),
      damage_reasons_bit_mask(std::move(damage_reasons_bit_mask_in)),
      moved_by_safe_area_bottom(std::move(moved_by_safe_area_bottom_in)) {}

TransformNode::~TransformNode() = default;

void TransformNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_id"), this->parent_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_frame_id"), this->parent_frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local"), this->local,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point3F&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "post_translation"), this->post_translation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "to_parent"), this->to_parent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_offset"), this->scroll_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "snap_amount"), this->snap_amount,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sticky_position_constraint_id"), this->sticky_position_constraint_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_position_scroll_data_id"), this->anchor_position_scroll_data_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sorting_context_id"), this->sorting_context_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_potential_animation"), this->has_potential_animation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_currently_animating"), this->is_currently_animating,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flattens_inherited_transform"), this->flattens_inherited_transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrolls"), this->scrolls,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_undo_overscroll"), this->should_undo_overscroll,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_be_snapped"), this->should_be_snapped,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "moved_by_outer_viewport_bounds_delta_y"), this->moved_by_outer_viewport_bounds_delta_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_subtree_of_page_scale_layer"), this->in_subtree_of_page_scale_layer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_changed"), this->transform_changed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegates_to_parent_for_backface"), this->delegates_to_parent_for_backface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "will_change_transform"), this->will_change_transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maximum_animation_scale"), this->maximum_animation_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_and_ancestors_are_animated_or_invertible"), this->node_and_ancestors_are_animated_or_invertible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_invertible"), this->is_invertible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ancestors_are_invertible"), this->ancestors_are_invertible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_and_ancestors_are_flat"), this->node_and_ancestors_are_flat,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_or_ancestors_will_change_transform"), this->node_or_ancestors_will_change_transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_frame_element_id"), this->visible_frame_element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "damage_reasons_bit_mask"), this->damage_reasons_bit_mask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "moved_by_safe_area_bottom"), this->moved_by_safe_area_bottom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TransformNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ClipNode::ClipNode()
    : id(),
      parent_id(),
      transform_id(),
      clip(),
      pixel_moving_filter_id() {}

ClipNode::ClipNode(
    int32_t id_in,
    int32_t parent_id_in,
    int32_t transform_id_in,
    const ::gfx::RectF& clip_in,
    int32_t pixel_moving_filter_id_in)
    : id(std::move(id_in)),
      parent_id(std::move(parent_id_in)),
      transform_id(std::move(transform_id_in)),
      clip(std::move(clip_in)),
      pixel_moving_filter_id(std::move(pixel_moving_filter_id_in)) {}

ClipNode::~ClipNode() = default;

void ClipNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_id"), this->parent_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_id"), this->transform_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip"), this->clip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_moving_filter_id"), this->pixel_moving_filter_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClipNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EffectNode::EffectNode()
    : id(),
      parent_id(),
      transform_id(),
      clip_id(),
      element_id(),
      opacity(),
      render_surface_reason(),
      surface_contents_scale(),
      subtree_capture_id(),
      subtree_size(),
      blend_mode(),
      target_id(),
      view_transition_target_id(),
      closest_ancestor_with_cached_render_surface_id(),
      closest_ancestor_with_copy_request_id(),
      closest_ancestor_being_captured_id(),
      closest_ancestor_with_shared_element_id(),
      view_transition_element_resource_id(),
      filters(),
      backdrop_filters(),
      backdrop_filter_bounds(),
      backdrop_filter_quality(),
      backdrop_mask_element_id(),
      mask_filter_info(),
      cache_render_surface(),
      double_sided(),
      trilinear_filtering(),
      subtree_hidden(),
      has_potential_filter_animation(),
      has_potential_backdrop_filter_animation(),
      has_potential_opacity_animation(),
      subtree_has_copy_request(),
      is_fast_rounded_corner(),
      may_have_backdrop_effect(),
      needs_effect_for_2d_scale_transform(),
      copy_output_requests() {}

EffectNode::EffectNode(
    int32_t id_in,
    int32_t parent_id_in,
    int32_t transform_id_in,
    int32_t clip_id_in,
    ::cc::ElementId element_id_in,
    float opacity_in,
    ::cc::RenderSurfaceReason render_surface_reason_in,
    const ::gfx::Vector2dF& surface_contents_scale_in,
    const ::viz::SubtreeCaptureId& subtree_capture_id_in,
    const ::gfx::Size& subtree_size_in,
    uint32_t blend_mode_in,
    int32_t target_id_in,
    int32_t view_transition_target_id_in,
    int32_t closest_ancestor_with_cached_render_surface_id_in,
    int32_t closest_ancestor_with_copy_request_id_in,
    int32_t closest_ancestor_being_captured_id_in,
    int32_t closest_ancestor_with_shared_element_id_in,
    const ::viz::ViewTransitionElementResourceId& view_transition_element_resource_id_in,
    const ::cc::FilterOperations& filters_in,
    const ::cc::FilterOperations& backdrop_filters_in,
    const std::optional<::SkPath>& backdrop_filter_bounds_in,
    float backdrop_filter_quality_in,
    ::cc::ElementId backdrop_mask_element_id_in,
    const ::gfx::MaskFilterInfo& mask_filter_info_in,
    bool cache_render_surface_in,
    bool double_sided_in,
    bool trilinear_filtering_in,
    bool subtree_hidden_in,
    bool has_potential_filter_animation_in,
    bool has_potential_backdrop_filter_animation_in,
    bool has_potential_opacity_animation_in,
    bool subtree_has_copy_request_in,
    bool is_fast_rounded_corner_in,
    bool may_have_backdrop_effect_in,
    bool needs_effect_for_2d_scale_transform_in,
    std::vector<::std::unique_ptr<::viz::CopyOutputRequest>> copy_output_requests_in)
    : id(std::move(id_in)),
      parent_id(std::move(parent_id_in)),
      transform_id(std::move(transform_id_in)),
      clip_id(std::move(clip_id_in)),
      element_id(std::move(element_id_in)),
      opacity(std::move(opacity_in)),
      render_surface_reason(std::move(render_surface_reason_in)),
      surface_contents_scale(std::move(surface_contents_scale_in)),
      subtree_capture_id(std::move(subtree_capture_id_in)),
      subtree_size(std::move(subtree_size_in)),
      blend_mode(std::move(blend_mode_in)),
      target_id(std::move(target_id_in)),
      view_transition_target_id(std::move(view_transition_target_id_in)),
      closest_ancestor_with_cached_render_surface_id(std::move(closest_ancestor_with_cached_render_surface_id_in)),
      closest_ancestor_with_copy_request_id(std::move(closest_ancestor_with_copy_request_id_in)),
      closest_ancestor_being_captured_id(std::move(closest_ancestor_being_captured_id_in)),
      closest_ancestor_with_shared_element_id(std::move(closest_ancestor_with_shared_element_id_in)),
      view_transition_element_resource_id(std::move(view_transition_element_resource_id_in)),
      filters(std::move(filters_in)),
      backdrop_filters(std::move(backdrop_filters_in)),
      backdrop_filter_bounds(std::move(backdrop_filter_bounds_in)),
      backdrop_filter_quality(std::move(backdrop_filter_quality_in)),
      backdrop_mask_element_id(std::move(backdrop_mask_element_id_in)),
      mask_filter_info(std::move(mask_filter_info_in)),
      cache_render_surface(std::move(cache_render_surface_in)),
      double_sided(std::move(double_sided_in)),
      trilinear_filtering(std::move(trilinear_filtering_in)),
      subtree_hidden(std::move(subtree_hidden_in)),
      has_potential_filter_animation(std::move(has_potential_filter_animation_in)),
      has_potential_backdrop_filter_animation(std::move(has_potential_backdrop_filter_animation_in)),
      has_potential_opacity_animation(std::move(has_potential_opacity_animation_in)),
      subtree_has_copy_request(std::move(subtree_has_copy_request_in)),
      is_fast_rounded_corner(std::move(is_fast_rounded_corner_in)),
      may_have_backdrop_effect(std::move(may_have_backdrop_effect_in)),
      needs_effect_for_2d_scale_transform(std::move(needs_effect_for_2d_scale_transform_in)),
      copy_output_requests(std::move(copy_output_requests_in)) {}

EffectNode::~EffectNode() = default;

void EffectNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_id"), this->parent_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_id"), this->transform_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_id"), this->clip_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opacity"), this->opacity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_surface_reason"), this->render_surface_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::RenderSurfaceReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_contents_scale"), this->surface_contents_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subtree_capture_id"), this->subtree_capture_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::SubtreeCaptureId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subtree_size"), this->subtree_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blend_mode"), this->blend_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_id"), this->target_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_transition_target_id"), this->view_transition_target_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "closest_ancestor_with_cached_render_surface_id"), this->closest_ancestor_with_cached_render_surface_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "closest_ancestor_with_copy_request_id"), this->closest_ancestor_with_copy_request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "closest_ancestor_being_captured_id"), this->closest_ancestor_being_captured_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "closest_ancestor_with_shared_element_id"), this->closest_ancestor_with_shared_element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_transition_element_resource_id"), this->view_transition_element_resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::ViewTransitionElementResourceId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters"), this->filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::cc::FilterOperations&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "backdrop_filters"), this->backdrop_filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::cc::FilterOperations&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "backdrop_filter_bounds"), this->backdrop_filter_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::SkPath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "backdrop_filter_quality"), this->backdrop_filter_quality,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "backdrop_mask_element_id"), this->backdrop_mask_element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mask_filter_info"), this->mask_filter_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::MaskFilterInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_render_surface"), this->cache_render_surface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "double_sided"), this->double_sided,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trilinear_filtering"), this->trilinear_filtering,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subtree_hidden"), this->subtree_hidden,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_potential_filter_animation"), this->has_potential_filter_animation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_potential_backdrop_filter_animation"), this->has_potential_backdrop_filter_animation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_potential_opacity_animation"), this->has_potential_opacity_animation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subtree_has_copy_request"), this->subtree_has_copy_request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_fast_rounded_corner"), this->is_fast_rounded_corner,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "may_have_backdrop_effect"), this->may_have_backdrop_effect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_effect_for_2d_scale_transform"), this->needs_effect_for_2d_scale_transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copy_output_requests"), this->copy_output_requests,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::std::unique_ptr<::viz::CopyOutputRequest>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EffectNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollTreeUpdate::ScrollTreeUpdate()
    : synced_scroll_offsets(),
      scrolling_contents_cull_rects(),
      elastic_overscroll() {}

ScrollTreeUpdate::ScrollTreeUpdate(
    const base::flat_map<::cc::ElementId, ::scoped_refptr<::cc::SyncedScrollOffset>>& synced_scroll_offsets_in,
    const base::flat_map<::cc::ElementId, ::gfx::Rect>& scrolling_contents_cull_rects_in,
    const base::flat_map<::cc::ElementId, ::gfx::Vector2dF>& elastic_overscroll_in)
    : synced_scroll_offsets(std::move(synced_scroll_offsets_in)),
      scrolling_contents_cull_rects(std::move(scrolling_contents_cull_rects_in)),
      elastic_overscroll(std::move(elastic_overscroll_in)) {}

ScrollTreeUpdate::~ScrollTreeUpdate() = default;

void ScrollTreeUpdate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "synced_scroll_offsets"), this->synced_scroll_offsets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::cc::ElementId, ::scoped_refptr<::cc::SyncedScrollOffset>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrolling_contents_cull_rects"), this->scrolling_contents_cull_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::cc::ElementId, ::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "elastic_overscroll"), this->elastic_overscroll,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::cc::ElementId, ::gfx::Vector2dF>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollTreeUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollNode::ScrollNode()
    : id(),
      parent_id(),
      transform_id(),
      container_bounds(),
      bounds(),
      element_id(),
      max_scroll_offset_affected_by_page_scale(),
      scrolls_inner_viewport(),
      scrolls_outer_viewport(),
      prevent_viewport_scrolling_from_inner(),
      user_scrollable_horizontal(),
      user_scrollable_vertical(),
      is_composited() {}

ScrollNode::ScrollNode(
    int32_t id_in,
    int32_t parent_id_in,
    int32_t transform_id_in,
    const ::gfx::Size& container_bounds_in,
    const ::gfx::Size& bounds_in,
    ::cc::ElementId element_id_in,
    bool max_scroll_offset_affected_by_page_scale_in,
    bool scrolls_inner_viewport_in,
    bool scrolls_outer_viewport_in,
    bool prevent_viewport_scrolling_from_inner_in,
    bool user_scrollable_horizontal_in,
    bool user_scrollable_vertical_in,
    bool is_composited_in)
    : id(std::move(id_in)),
      parent_id(std::move(parent_id_in)),
      transform_id(std::move(transform_id_in)),
      container_bounds(std::move(container_bounds_in)),
      bounds(std::move(bounds_in)),
      element_id(std::move(element_id_in)),
      max_scroll_offset_affected_by_page_scale(std::move(max_scroll_offset_affected_by_page_scale_in)),
      scrolls_inner_viewport(std::move(scrolls_inner_viewport_in)),
      scrolls_outer_viewport(std::move(scrolls_outer_viewport_in)),
      prevent_viewport_scrolling_from_inner(std::move(prevent_viewport_scrolling_from_inner_in)),
      user_scrollable_horizontal(std::move(user_scrollable_horizontal_in)),
      user_scrollable_vertical(std::move(user_scrollable_vertical_in)),
      is_composited(std::move(is_composited_in)) {}

ScrollNode::~ScrollNode() = default;

void ScrollNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_id"), this->parent_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_id"), this->transform_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "container_bounds"), this->container_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_scroll_offset_affected_by_page_scale"), this->max_scroll_offset_affected_by_page_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrolls_inner_viewport"), this->scrolls_inner_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrolls_outer_viewport"), this->scrolls_outer_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prevent_viewport_scrolling_from_inner"), this->prevent_viewport_scrolling_from_inner,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_scrollable_horizontal"), this->user_scrollable_horizontal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_scrollable_vertical"), this->user_scrollable_vertical,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_composited"), this->is_composited,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LayerExtraPtr
LayerExtra::NewMirrorLayerExtra(
    MirrorLayerExtraPtr value) {
  return LayerExtraPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kMirrorLayerExtra)>,
      std::move(value));
}

LayerExtraPtr
LayerExtra::NewNinePatchThumbScrollbarLayerExtra(
    NinePatchThumbScrollbarLayerExtraPtr value) {
  return LayerExtraPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNinePatchThumbScrollbarLayerExtra)>,
      std::move(value));
}

LayerExtraPtr
LayerExtra::NewPaintedScrollbarLayerExtra(
    PaintedScrollbarLayerExtraPtr value) {
  return LayerExtraPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPaintedScrollbarLayerExtra)>,
      std::move(value));
}

LayerExtraPtr
LayerExtra::NewSolidColorScrollbarLayerExtra(
    SolidColorScrollbarLayerExtraPtr value) {
  return LayerExtraPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSolidColorScrollbarLayerExtra)>,
      std::move(value));
}

LayerExtraPtr
LayerExtra::NewSurfaceLayerExtra(
    SurfaceLayerExtraPtr value) {
  return LayerExtraPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSurfaceLayerExtra)>,
      std::move(value));
}

LayerExtraPtr
LayerExtra::NewTextureLayerExtra(
    TextureLayerExtraPtr value) {
  return LayerExtraPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTextureLayerExtra)>,
      std::move(value));
}

LayerExtraPtr
LayerExtra::NewUiResourceLayerExtra(
    UIResourceLayerExtraPtr value) {
  return LayerExtraPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUiResourceLayerExtra)>,
      std::move(value));
}

LayerExtraPtr
LayerExtra::NewTileDisplayLayerExtra(
    TileDisplayLayerExtraPtr value) {
  return LayerExtraPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTileDisplayLayerExtra)>,
      std::move(value));
}

LayerExtraPtr
LayerExtra::NewViewTransitionContentLayerExtra(
    ViewTransitionContentLayerExtraPtr value) {
  return LayerExtraPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kViewTransitionContentLayerExtra)>,
      std::move(value));
}

LayerExtraPtr
LayerExtra::NewNinePatchLayerExtra(
    NinePatchLayerExtraPtr value) {
  return LayerExtraPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNinePatchLayerExtra)>,
      std::move(value));
}

LayerExtra::LayerExtra(
    std::in_place_index_t<static_cast<size_t>(Tag::kMirrorLayerExtra)>,
    MirrorLayerExtraPtr value)
    : tag_(Tag::kMirrorLayerExtra),
      data_(std::in_place_index<static_cast<size_t>(Tag::kMirrorLayerExtra)>,
            std::move(value)) {}

LayerExtra::LayerExtra(
    std::in_place_index_t<static_cast<size_t>(Tag::kNinePatchThumbScrollbarLayerExtra)>,
    NinePatchThumbScrollbarLayerExtraPtr value)
    : tag_(Tag::kNinePatchThumbScrollbarLayerExtra),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNinePatchThumbScrollbarLayerExtra)>,
            std::move(value)) {}

LayerExtra::LayerExtra(
    std::in_place_index_t<static_cast<size_t>(Tag::kPaintedScrollbarLayerExtra)>,
    PaintedScrollbarLayerExtraPtr value)
    : tag_(Tag::kPaintedScrollbarLayerExtra),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPaintedScrollbarLayerExtra)>,
            std::move(value)) {}

LayerExtra::LayerExtra(
    std::in_place_index_t<static_cast<size_t>(Tag::kSolidColorScrollbarLayerExtra)>,
    SolidColorScrollbarLayerExtraPtr value)
    : tag_(Tag::kSolidColorScrollbarLayerExtra),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSolidColorScrollbarLayerExtra)>,
            std::move(value)) {}

LayerExtra::LayerExtra(
    std::in_place_index_t<static_cast<size_t>(Tag::kSurfaceLayerExtra)>,
    SurfaceLayerExtraPtr value)
    : tag_(Tag::kSurfaceLayerExtra),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSurfaceLayerExtra)>,
            std::move(value)) {}

LayerExtra::LayerExtra(
    std::in_place_index_t<static_cast<size_t>(Tag::kTextureLayerExtra)>,
    TextureLayerExtraPtr value)
    : tag_(Tag::kTextureLayerExtra),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTextureLayerExtra)>,
            std::move(value)) {}

LayerExtra::LayerExtra(
    std::in_place_index_t<static_cast<size_t>(Tag::kUiResourceLayerExtra)>,
    UIResourceLayerExtraPtr value)
    : tag_(Tag::kUiResourceLayerExtra),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUiResourceLayerExtra)>,
            std::move(value)) {}

LayerExtra::LayerExtra(
    std::in_place_index_t<static_cast<size_t>(Tag::kTileDisplayLayerExtra)>,
    TileDisplayLayerExtraPtr value)
    : tag_(Tag::kTileDisplayLayerExtra),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTileDisplayLayerExtra)>,
            std::move(value)) {}

LayerExtra::LayerExtra(
    std::in_place_index_t<static_cast<size_t>(Tag::kViewTransitionContentLayerExtra)>,
    ViewTransitionContentLayerExtraPtr value)
    : tag_(Tag::kViewTransitionContentLayerExtra),
      data_(std::in_place_index<static_cast<size_t>(Tag::kViewTransitionContentLayerExtra)>,
            std::move(value)) {}

LayerExtra::LayerExtra(
    std::in_place_index_t<static_cast<size_t>(Tag::kNinePatchLayerExtra)>,
    NinePatchLayerExtraPtr value)
    : tag_(Tag::kNinePatchLayerExtra),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNinePatchLayerExtra)>,
            std::move(value)) {}
LayerExtra::~LayerExtra() {
  DestroyActive();
}

void LayerExtra::set_mirror_layer_extra(MirrorLayerExtraPtr mirror_layer_extra) {
  if (tag_ == Tag::kMirrorLayerExtra) {
    data_.mirror_layer_extra = std::move(mirror_layer_extra);
  } else {
    DestroyActive();
    tag_ = Tag::kMirrorLayerExtra;
    new (&data_.mirror_layer_extra) MirrorLayerExtraPtr(
        std::move(mirror_layer_extra));
  }
}

void LayerExtra::set_nine_patch_thumb_scrollbar_layer_extra(NinePatchThumbScrollbarLayerExtraPtr nine_patch_thumb_scrollbar_layer_extra) {
  if (tag_ == Tag::kNinePatchThumbScrollbarLayerExtra) {
    data_.nine_patch_thumb_scrollbar_layer_extra = std::move(nine_patch_thumb_scrollbar_layer_extra);
  } else {
    DestroyActive();
    tag_ = Tag::kNinePatchThumbScrollbarLayerExtra;
    new (&data_.nine_patch_thumb_scrollbar_layer_extra) NinePatchThumbScrollbarLayerExtraPtr(
        std::move(nine_patch_thumb_scrollbar_layer_extra));
  }
}

void LayerExtra::set_painted_scrollbar_layer_extra(PaintedScrollbarLayerExtraPtr painted_scrollbar_layer_extra) {
  if (tag_ == Tag::kPaintedScrollbarLayerExtra) {
    data_.painted_scrollbar_layer_extra = std::move(painted_scrollbar_layer_extra);
  } else {
    DestroyActive();
    tag_ = Tag::kPaintedScrollbarLayerExtra;
    new (&data_.painted_scrollbar_layer_extra) PaintedScrollbarLayerExtraPtr(
        std::move(painted_scrollbar_layer_extra));
  }
}

void LayerExtra::set_solid_color_scrollbar_layer_extra(SolidColorScrollbarLayerExtraPtr solid_color_scrollbar_layer_extra) {
  if (tag_ == Tag::kSolidColorScrollbarLayerExtra) {
    data_.solid_color_scrollbar_layer_extra = std::move(solid_color_scrollbar_layer_extra);
  } else {
    DestroyActive();
    tag_ = Tag::kSolidColorScrollbarLayerExtra;
    new (&data_.solid_color_scrollbar_layer_extra) SolidColorScrollbarLayerExtraPtr(
        std::move(solid_color_scrollbar_layer_extra));
  }
}

void LayerExtra::set_surface_layer_extra(SurfaceLayerExtraPtr surface_layer_extra) {
  if (tag_ == Tag::kSurfaceLayerExtra) {
    data_.surface_layer_extra = std::move(surface_layer_extra);
  } else {
    DestroyActive();
    tag_ = Tag::kSurfaceLayerExtra;
    new (&data_.surface_layer_extra) SurfaceLayerExtraPtr(
        std::move(surface_layer_extra));
  }
}

void LayerExtra::set_texture_layer_extra(TextureLayerExtraPtr texture_layer_extra) {
  if (tag_ == Tag::kTextureLayerExtra) {
    data_.texture_layer_extra = std::move(texture_layer_extra);
  } else {
    DestroyActive();
    tag_ = Tag::kTextureLayerExtra;
    new (&data_.texture_layer_extra) TextureLayerExtraPtr(
        std::move(texture_layer_extra));
  }
}

void LayerExtra::set_ui_resource_layer_extra(UIResourceLayerExtraPtr ui_resource_layer_extra) {
  if (tag_ == Tag::kUiResourceLayerExtra) {
    data_.ui_resource_layer_extra = std::move(ui_resource_layer_extra);
  } else {
    DestroyActive();
    tag_ = Tag::kUiResourceLayerExtra;
    new (&data_.ui_resource_layer_extra) UIResourceLayerExtraPtr(
        std::move(ui_resource_layer_extra));
  }
}

void LayerExtra::set_tile_display_layer_extra(TileDisplayLayerExtraPtr tile_display_layer_extra) {
  if (tag_ == Tag::kTileDisplayLayerExtra) {
    data_.tile_display_layer_extra = std::move(tile_display_layer_extra);
  } else {
    DestroyActive();
    tag_ = Tag::kTileDisplayLayerExtra;
    new (&data_.tile_display_layer_extra) TileDisplayLayerExtraPtr(
        std::move(tile_display_layer_extra));
  }
}

void LayerExtra::set_view_transition_content_layer_extra(ViewTransitionContentLayerExtraPtr view_transition_content_layer_extra) {
  if (tag_ == Tag::kViewTransitionContentLayerExtra) {
    data_.view_transition_content_layer_extra = std::move(view_transition_content_layer_extra);
  } else {
    DestroyActive();
    tag_ = Tag::kViewTransitionContentLayerExtra;
    new (&data_.view_transition_content_layer_extra) ViewTransitionContentLayerExtraPtr(
        std::move(view_transition_content_layer_extra));
  }
}

void LayerExtra::set_nine_patch_layer_extra(NinePatchLayerExtraPtr nine_patch_layer_extra) {
  if (tag_ == Tag::kNinePatchLayerExtra) {
    data_.nine_patch_layer_extra = std::move(nine_patch_layer_extra);
  } else {
    DestroyActive();
    tag_ = Tag::kNinePatchLayerExtra;
    new (&data_.nine_patch_layer_extra) NinePatchLayerExtraPtr(
        std::move(nine_patch_layer_extra));
  }
}


LayerExtra::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kMirrorLayerExtra)>,
    MirrorLayerExtraPtr value)
    : mirror_layer_extra(std::move(value)) {}

LayerExtra::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNinePatchThumbScrollbarLayerExtra)>,
    NinePatchThumbScrollbarLayerExtraPtr value)
    : nine_patch_thumb_scrollbar_layer_extra(std::move(value)) {}

LayerExtra::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPaintedScrollbarLayerExtra)>,
    PaintedScrollbarLayerExtraPtr value)
    : painted_scrollbar_layer_extra(std::move(value)) {}

LayerExtra::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSolidColorScrollbarLayerExtra)>,
    SolidColorScrollbarLayerExtraPtr value)
    : solid_color_scrollbar_layer_extra(std::move(value)) {}

LayerExtra::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSurfaceLayerExtra)>,
    SurfaceLayerExtraPtr value)
    : surface_layer_extra(std::move(value)) {}

LayerExtra::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTextureLayerExtra)>,
    TextureLayerExtraPtr value)
    : texture_layer_extra(std::move(value)) {}

LayerExtra::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUiResourceLayerExtra)>,
    UIResourceLayerExtraPtr value)
    : ui_resource_layer_extra(std::move(value)) {}

LayerExtra::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTileDisplayLayerExtra)>,
    TileDisplayLayerExtraPtr value)
    : tile_display_layer_extra(std::move(value)) {}

LayerExtra::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kViewTransitionContentLayerExtra)>,
    ViewTransitionContentLayerExtraPtr value)
    : view_transition_content_layer_extra(std::move(value)) {}

LayerExtra::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNinePatchLayerExtra)>,
    NinePatchLayerExtraPtr value)
    : nine_patch_layer_extra(std::move(value)) {}

void LayerExtra::DestroyActive() {
  switch (tag_) {

    case Tag::kMirrorLayerExtra:
      std::destroy_at(&data_.mirror_layer_extra);
      break;
    case Tag::kNinePatchThumbScrollbarLayerExtra:
      std::destroy_at(&data_.nine_patch_thumb_scrollbar_layer_extra);
      break;
    case Tag::kPaintedScrollbarLayerExtra:
      std::destroy_at(&data_.painted_scrollbar_layer_extra);
      break;
    case Tag::kSolidColorScrollbarLayerExtra:
      std::destroy_at(&data_.solid_color_scrollbar_layer_extra);
      break;
    case Tag::kSurfaceLayerExtra:
      std::destroy_at(&data_.surface_layer_extra);
      break;
    case Tag::kTextureLayerExtra:
      std::destroy_at(&data_.texture_layer_extra);
      break;
    case Tag::kUiResourceLayerExtra:
      std::destroy_at(&data_.ui_resource_layer_extra);
      break;
    case Tag::kTileDisplayLayerExtra:
      std::destroy_at(&data_.tile_display_layer_extra);
      break;
    case Tag::kViewTransitionContentLayerExtra:
      std::destroy_at(&data_.view_transition_content_layer_extra);
      break;
    case Tag::kNinePatchLayerExtra:
      std::destroy_at(&data_.nine_patch_layer_extra);
      break;
  }
}

bool LayerExtra::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::RareProperties::DataView, ::viz::mojom::RarePropertiesPtr>::Read(
    ::viz::mojom::RareProperties::DataView input,
    ::viz::mojom::RarePropertiesPtr* output) {
  bool success = true;
  ::viz::mojom::RarePropertiesPtr result(::viz::mojom::RareProperties::New());
  
      if (success && !input.ReadFilterQuality(&result->filter_quality))
        success = false;
      if (success && !input.ReadDynamicRangeLimit(&result->dynamic_range_limit))
        success = false;
      if (success && !input.ReadCaptureBounds(&result->capture_bounds))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::MirrorLayerExtra::DataView, ::viz::mojom::MirrorLayerExtraPtr>::Read(
    ::viz::mojom::MirrorLayerExtra::DataView input,
    ::viz::mojom::MirrorLayerExtraPtr* output) {
  bool success = true;
  ::viz::mojom::MirrorLayerExtraPtr result(::viz::mojom::MirrorLayerExtra::New());
  
      if (success)
        result->mirrored_layer_id = input.mirrored_layer_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::SurfaceLayerExtra::DataView, ::viz::mojom::SurfaceLayerExtraPtr>::Read(
    ::viz::mojom::SurfaceLayerExtra::DataView input,
    ::viz::mojom::SurfaceLayerExtraPtr* output) {
  bool success = true;
  ::viz::mojom::SurfaceLayerExtraPtr result(::viz::mojom::SurfaceLayerExtra::New());
  
      if (success && !input.ReadSurfaceRange(&result->surface_range))
        success = false;
      if (success) {
        result->deadline_in_frames = input.deadline_in_frames();
      }
      if (success)
        result->stretch_content_to_fill_bounds = input.stretch_content_to_fill_bounds();
      if (success)
        result->surface_hit_testable = input.surface_hit_testable();
      if (success)
        result->has_pointer_events_none = input.has_pointer_events_none();
      if (success)
        result->is_reflection = input.is_reflection();
      if (success)
        result->will_draw_needs_reset = input.will_draw_needs_reset();
      if (success)
        result->override_child_paint_flags = input.override_child_paint_flags();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::TextureLayerExtra::DataView, ::viz::mojom::TextureLayerExtraPtr>::Read(
    ::viz::mojom::TextureLayerExtra::DataView input,
    ::viz::mojom::TextureLayerExtraPtr* output) {
  bool success = true;
  ::viz::mojom::TextureLayerExtraPtr result(::viz::mojom::TextureLayerExtra::New());
  
      if (success)
        result->blend_background_color = input.blend_background_color();
      if (success)
        result->force_texture_to_opaque = input.force_texture_to_opaque();
      if (success && !input.ReadUvTopLeft(&result->uv_top_left))
        success = false;
      if (success && !input.ReadUvBottomRight(&result->uv_bottom_right))
        success = false;
      if (success && !input.ReadTransferableResource(&result->transferable_resource))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::UIResourceLayerExtra::DataView, ::viz::mojom::UIResourceLayerExtraPtr>::Read(
    ::viz::mojom::UIResourceLayerExtra::DataView input,
    ::viz::mojom::UIResourceLayerExtraPtr* output) {
  bool success = true;
  ::viz::mojom::UIResourceLayerExtraPtr result(::viz::mojom::UIResourceLayerExtra::New());
  
      if (success && !input.ReadUiResourceId(&result->ui_resource_id))
        success = false;
      if (success && !input.ReadImageBounds(&result->image_bounds))
        success = false;
      if (success && !input.ReadUvTopLeft(&result->uv_top_left))
        success = false;
      if (success && !input.ReadUvBottomRight(&result->uv_bottom_right))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::TileDisplayLayerExtra::DataView, ::viz::mojom::TileDisplayLayerExtraPtr>::Read(
    ::viz::mojom::TileDisplayLayerExtra::DataView input,
    ::viz::mojom::TileDisplayLayerExtraPtr* output) {
  bool success = true;
  ::viz::mojom::TileDisplayLayerExtraPtr result(::viz::mojom::TileDisplayLayerExtra::New());
  
      if (success && !input.ReadSolidColor(&result->solid_color))
        success = false;
      if (success)
        result->is_backdrop_filter_mask = input.is_backdrop_filter_mask();
      if (success)
        result->is_directly_composited_image = input.is_directly_composited_image();
      if (success)
        result->nearest_neighbor = input.nearest_neighbor();
      if (success && !input.ReadContentColorUsage(&result->content_color_usage))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::ScrollbarLayerBaseExtra::DataView, ::viz::mojom::ScrollbarLayerBaseExtraPtr>::Read(
    ::viz::mojom::ScrollbarLayerBaseExtra::DataView input,
    ::viz::mojom::ScrollbarLayerBaseExtraPtr* output) {
  bool success = true;
  ::viz::mojom::ScrollbarLayerBaseExtraPtr result(::viz::mojom::ScrollbarLayerBaseExtra::New());
  
      if (success && !input.ReadScrollElementId(&result->scroll_element_id))
        success = false;
      if (success)
        result->is_overlay_scrollbar = input.is_overlay_scrollbar();
      if (success)
        result->is_web_test = input.is_web_test();
      if (success)
        result->thumb_thickness_scale_factor = input.thumb_thickness_scale_factor();
      if (success)
        result->current_pos = input.current_pos();
      if (success)
        result->clip_layer_length = input.clip_layer_length();
      if (success)
        result->scroll_layer_length = input.scroll_layer_length();
      if (success)
        result->is_horizontal_orientation = input.is_horizontal_orientation();
      if (success)
        result->is_left_side_vertical_scrollbar = input.is_left_side_vertical_scrollbar();
      if (success)
        result->vertical_adjust = input.vertical_adjust();
      if (success)
        result->has_find_in_page_tickmarks = input.has_find_in_page_tickmarks();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::NinePatchThumbScrollbarLayerExtra::DataView, ::viz::mojom::NinePatchThumbScrollbarLayerExtraPtr>::Read(
    ::viz::mojom::NinePatchThumbScrollbarLayerExtra::DataView input,
    ::viz::mojom::NinePatchThumbScrollbarLayerExtraPtr* output) {
  bool success = true;
  ::viz::mojom::NinePatchThumbScrollbarLayerExtraPtr result(::viz::mojom::NinePatchThumbScrollbarLayerExtra::New());
  
      if (success && !input.ReadScrollbarBaseExtra(&result->scrollbar_base_extra))
        success = false;
      if (success)
        result->thumb_thickness = input.thumb_thickness();
      if (success)
        result->thumb_length = input.thumb_length();
      if (success)
        result->track_start = input.track_start();
      if (success)
        result->track_length = input.track_length();
      if (success && !input.ReadImageBounds(&result->image_bounds))
        success = false;
      if (success && !input.ReadAperture(&result->aperture))
        success = false;
      if (success && !input.ReadThumbUiResourceId(&result->thumb_ui_resource_id))
        success = false;
      if (success && !input.ReadTrackAndButtonsUiResourceId(&result->track_and_buttons_ui_resource_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::PaintedScrollbarLayerExtra::DataView, ::viz::mojom::PaintedScrollbarLayerExtraPtr>::Read(
    ::viz::mojom::PaintedScrollbarLayerExtra::DataView input,
    ::viz::mojom::PaintedScrollbarLayerExtraPtr* output) {
  bool success = true;
  ::viz::mojom::PaintedScrollbarLayerExtraPtr result(::viz::mojom::PaintedScrollbarLayerExtra::New());
  
      if (success && !input.ReadScrollbarBaseExtra(&result->scrollbar_base_extra))
        success = false;
      if (success)
        result->internal_contents_scale = input.internal_contents_scale();
      if (success && !input.ReadInternalContentBounds(&result->internal_content_bounds))
        success = false;
      if (success)
        result->jump_on_track_click = input.jump_on_track_click();
      if (success)
        result->supports_drag_snap_back = input.supports_drag_snap_back();
      if (success)
        result->thumb_thickness = input.thumb_thickness();
      if (success)
        result->thumb_length = input.thumb_length();
      if (success && !input.ReadBackButtonRect(&result->back_button_rect))
        success = false;
      if (success && !input.ReadForwardButtonRect(&result->forward_button_rect))
        success = false;
      if (success && !input.ReadTrackRect(&result->track_rect))
        success = false;
      if (success && !input.ReadThumbColor(&result->thumb_color))
        success = false;
      if (success)
        result->uses_nine_patch_track_and_buttons = input.uses_nine_patch_track_and_buttons();
      if (success && !input.ReadTrackAndButtonsImageBounds(&result->track_and_buttons_image_bounds))
        success = false;
      if (success && !input.ReadTrackAndButtonsAperture(&result->track_and_buttons_aperture))
        success = false;
      if (success)
        result->painted_opacity = input.painted_opacity();
      if (success && !input.ReadTrackAndButtonsUiResourceId(&result->track_and_buttons_ui_resource_id))
        success = false;
      if (success && !input.ReadThumbUiResourceId(&result->thumb_ui_resource_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::SolidColorScrollbarLayerExtra::DataView, ::viz::mojom::SolidColorScrollbarLayerExtraPtr>::Read(
    ::viz::mojom::SolidColorScrollbarLayerExtra::DataView input,
    ::viz::mojom::SolidColorScrollbarLayerExtraPtr* output) {
  bool success = true;
  ::viz::mojom::SolidColorScrollbarLayerExtraPtr result(::viz::mojom::SolidColorScrollbarLayerExtra::New());
  
      if (success && !input.ReadScrollbarBaseExtra(&result->scrollbar_base_extra))
        success = false;
      if (success)
        result->thumb_thickness = input.thumb_thickness();
      if (success)
        result->track_start = input.track_start();
      if (success && !input.ReadColor(&result->color))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::ViewTransitionContentLayerExtra::DataView, ::viz::mojom::ViewTransitionContentLayerExtraPtr>::Read(
    ::viz::mojom::ViewTransitionContentLayerExtra::DataView input,
    ::viz::mojom::ViewTransitionContentLayerExtraPtr* output) {
  bool success = true;
  ::viz::mojom::ViewTransitionContentLayerExtraPtr result(::viz::mojom::ViewTransitionContentLayerExtra::New());
  
      if (success && !input.ReadResourceId(&result->resource_id))
        success = false;
      if (success)
        result->is_live_content_layer = input.is_live_content_layer();
      if (success && !input.ReadMaxExtentsRect(&result->max_extents_rect))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::NinePatchLayerExtra::DataView, ::viz::mojom::NinePatchLayerExtraPtr>::Read(
    ::viz::mojom::NinePatchLayerExtra::DataView input,
    ::viz::mojom::NinePatchLayerExtraPtr* output) {
  bool success = true;
  ::viz::mojom::NinePatchLayerExtraPtr result(::viz::mojom::NinePatchLayerExtra::New());
  
      if (success && !input.ReadImageAperture(&result->image_aperture))
        success = false;
      if (success && !input.ReadBorder(&result->border))
        success = false;
      if (success && !input.ReadLayerOcclusion(&result->layer_occlusion))
        success = false;
      if (success)
        result->fill_center = input.fill_center();
      if (success && !input.ReadUiResourceId(&result->ui_resource_id))
        success = false;
      if (success && !input.ReadImageBounds(&result->image_bounds))
        success = false;
      if (success && !input.ReadUvTopLeft(&result->uv_top_left))
        success = false;
      if (success && !input.ReadUvBottomRight(&result->uv_bottom_right))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::Layer::DataView, ::viz::mojom::LayerPtr>::Read(
    ::viz::mojom::Layer::DataView input,
    ::viz::mojom::LayerPtr* output) {
  bool success = true;
  ::viz::mojom::LayerPtr result(::viz::mojom::Layer::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
      if (success)
        result->contents_opaque = input.contents_opaque();
      if (success)
        result->contents_opaque_for_text = input.contents_opaque_for_text();
      if (success)
        result->is_drawable = input.is_drawable();
      if (success)
        result->layer_property_changed_not_from_property_trees = input.layer_property_changed_not_from_property_trees();
      if (success)
        result->layer_property_changed_from_property_trees = input.layer_property_changed_from_property_trees();
      if (success && !input.ReadHitTestOpaqueness(&result->hit_test_opaqueness))
        success = false;
      if (success && !input.ReadBackgroundColor(&result->background_color))
        success = false;
      if (success && !input.ReadSafeOpaqueBackgroundColor(&result->safe_opaque_background_color))
        success = false;
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success && !input.ReadUpdateRect(&result->update_rect))
        success = false;
      if (success && !input.ReadOffsetToTransformParent(&result->offset_to_transform_parent))
        success = false;
      if (success)
        result->transform_tree_index = input.transform_tree_index();
      if (success)
        result->clip_tree_index = input.clip_tree_index();
      if (success)
        result->effect_tree_index = input.effect_tree_index();
      if (success)
        result->scroll_tree_index = input.scroll_tree_index();
      if (success)
        result->should_check_backface_visibility = input.should_check_backface_visibility();
      if (success && !input.ReadRareProperties(&result->rare_properties))
        success = false;
      if (success && !input.ReadLayerExtra(&result->layer_extra))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::AnchorPositionScrollData::DataView, ::viz::mojom::AnchorPositionScrollDataPtr>::Read(
    ::viz::mojom::AnchorPositionScrollData::DataView input,
    ::viz::mojom::AnchorPositionScrollDataPtr* output) {
  bool success = true;
  ::viz::mojom::AnchorPositionScrollDataPtr result(::viz::mojom::AnchorPositionScrollData::New());
  
      if (success && !input.ReadAdjustmentContainerIds(&result->adjustment_container_ids))
        success = false;
      if (success && !input.ReadAccumulatedScrollOrigin(&result->accumulated_scroll_origin))
        success = false;
      if (success)
        result->needs_scroll_adjustment_in_x = input.needs_scroll_adjustment_in_x();
      if (success)
        result->needs_scroll_adjustment_in_y = input.needs_scroll_adjustment_in_y();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::StickyPositionNodeData::DataView, ::viz::mojom::StickyPositionNodeDataPtr>::Read(
    ::viz::mojom::StickyPositionNodeData::DataView input,
    ::viz::mojom::StickyPositionNodeDataPtr* output) {
  bool success = true;
  ::viz::mojom::StickyPositionNodeDataPtr result(::viz::mojom::StickyPositionNodeData::New());
  
      if (success)
        result->scroll_ancestor = input.scroll_ancestor();
      if (success)
        result->is_anchored_left = input.is_anchored_left();
      if (success)
        result->is_anchored_right = input.is_anchored_right();
      if (success)
        result->is_anchored_top = input.is_anchored_top();
      if (success)
        result->is_anchored_bottom = input.is_anchored_bottom();
      if (success)
        result->left_offset = input.left_offset();
      if (success)
        result->right_offset = input.right_offset();
      if (success)
        result->top_offset = input.top_offset();
      if (success)
        result->bottom_offset = input.bottom_offset();
      if (success && !input.ReadConstraintBoxRect(&result->constraint_box_rect))
        success = false;
      if (success && !input.ReadScrollContainerRelativeStickyBoxRect(&result->scroll_container_relative_sticky_box_rect))
        success = false;
      if (success && !input.ReadScrollContainerRelativeContainingBlockRect(&result->scroll_container_relative_containing_block_rect))
        success = false;
      if (success && !input.ReadPixelSnapOffset(&result->pixel_snap_offset))
        success = false;
      if (success)
        result->nearest_node_shifting_sticky_box = input.nearest_node_shifting_sticky_box();
      if (success)
        result->nearest_node_shifting_containing_block = input.nearest_node_shifting_containing_block();
      if (success && !input.ReadTotalStickyBoxStickyOffset(&result->total_sticky_box_sticky_offset))
        success = false;
      if (success && !input.ReadTotalContainingBlockStickyOffset(&result->total_containing_block_sticky_offset))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::TransformTreeUpdate::DataView, ::viz::mojom::TransformTreeUpdatePtr>::Read(
    ::viz::mojom::TransformTreeUpdate::DataView input,
    ::viz::mojom::TransformTreeUpdatePtr* output) {
  bool success = true;
  ::viz::mojom::TransformTreeUpdatePtr result(::viz::mojom::TransformTreeUpdate::New());
  
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success)
        result->device_transform_scale_factor = input.device_transform_scale_factor();
      if (success && !input.ReadNodesAffectedByOuterViewportBoundsDelta(&result->nodes_affected_by_outer_viewport_bounds_delta))
        success = false;
      if (success && !input.ReadNodesAffectedBySafeAreaBottom(&result->nodes_affected_by_safe_area_bottom))
        success = false;
      if (success && !input.ReadStickyPositionData(&result->sticky_position_data))
        success = false;
      if (success && !input.ReadAnchorPositionScrollData(&result->anchor_position_scroll_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::TransformNode::DataView, ::viz::mojom::TransformNodePtr>::Read(
    ::viz::mojom::TransformNode::DataView input,
    ::viz::mojom::TransformNodePtr* output) {
  bool success = true;
  ::viz::mojom::TransformNodePtr result(::viz::mojom::TransformNode::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->parent_id = input.parent_id();
      if (success)
        result->parent_frame_id = input.parent_frame_id();
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success && !input.ReadLocal(&result->local))
        success = false;
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadPostTranslation(&result->post_translation))
        success = false;
      if (success && !input.ReadToParent(&result->to_parent))
        success = false;
      if (success && !input.ReadScrollOffset(&result->scroll_offset))
        success = false;
      if (success && !input.ReadSnapAmount(&result->snap_amount))
        success = false;
      if (success) {
        result->sticky_position_constraint_id = input.sticky_position_constraint_id();
      }
      if (success) {
        result->anchor_position_scroll_data_id = input.anchor_position_scroll_data_id();
      }
      if (success)
        result->sorting_context_id = input.sorting_context_id();
      if (success)
        result->has_potential_animation = input.has_potential_animation();
      if (success)
        result->is_currently_animating = input.is_currently_animating();
      if (success)
        result->flattens_inherited_transform = input.flattens_inherited_transform();
      if (success)
        result->scrolls = input.scrolls();
      if (success)
        result->should_undo_overscroll = input.should_undo_overscroll();
      if (success)
        result->should_be_snapped = input.should_be_snapped();
      if (success)
        result->moved_by_outer_viewport_bounds_delta_y = input.moved_by_outer_viewport_bounds_delta_y();
      if (success)
        result->in_subtree_of_page_scale_layer = input.in_subtree_of_page_scale_layer();
      if (success)
        result->transform_changed = input.transform_changed();
      if (success)
        result->delegates_to_parent_for_backface = input.delegates_to_parent_for_backface();
      if (success)
        result->will_change_transform = input.will_change_transform();
      if (success)
        result->maximum_animation_scale = input.maximum_animation_scale();
      if (success)
        result->node_and_ancestors_are_animated_or_invertible = input.node_and_ancestors_are_animated_or_invertible();
      if (success)
        result->is_invertible = input.is_invertible();
      if (success)
        result->ancestors_are_invertible = input.ancestors_are_invertible();
      if (success)
        result->node_and_ancestors_are_flat = input.node_and_ancestors_are_flat();
      if (success)
        result->node_or_ancestors_will_change_transform = input.node_or_ancestors_will_change_transform();
      if (success && !input.ReadVisibleFrameElementId(&result->visible_frame_element_id))
        success = false;
      if (success)
        result->damage_reasons_bit_mask = input.damage_reasons_bit_mask();
      if (success)
        result->moved_by_safe_area_bottom = input.moved_by_safe_area_bottom();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::ClipNode::DataView, ::viz::mojom::ClipNodePtr>::Read(
    ::viz::mojom::ClipNode::DataView input,
    ::viz::mojom::ClipNodePtr* output) {
  bool success = true;
  ::viz::mojom::ClipNodePtr result(::viz::mojom::ClipNode::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->parent_id = input.parent_id();
      if (success)
        result->transform_id = input.transform_id();
      if (success && !input.ReadClip(&result->clip))
        success = false;
      if (success)
        result->pixel_moving_filter_id = input.pixel_moving_filter_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::EffectNode::DataView, ::viz::mojom::EffectNodePtr>::Read(
    ::viz::mojom::EffectNode::DataView input,
    ::viz::mojom::EffectNodePtr* output) {
  bool success = true;
  ::viz::mojom::EffectNodePtr result(::viz::mojom::EffectNode::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->parent_id = input.parent_id();
      if (success)
        result->transform_id = input.transform_id();
      if (success)
        result->clip_id = input.clip_id();
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success)
        result->opacity = input.opacity();
      if (success && !input.ReadRenderSurfaceReason(&result->render_surface_reason))
        success = false;
      if (success && !input.ReadSurfaceContentsScale(&result->surface_contents_scale))
        success = false;
      if (success && !input.ReadSubtreeCaptureId(&result->subtree_capture_id))
        success = false;
      if (success && !input.ReadSubtreeSize(&result->subtree_size))
        success = false;
      if (success)
        result->blend_mode = input.blend_mode();
      if (success)
        result->target_id = input.target_id();
      if (success)
        result->view_transition_target_id = input.view_transition_target_id();
      if (success)
        result->closest_ancestor_with_cached_render_surface_id = input.closest_ancestor_with_cached_render_surface_id();
      if (success)
        result->closest_ancestor_with_copy_request_id = input.closest_ancestor_with_copy_request_id();
      if (success)
        result->closest_ancestor_being_captured_id = input.closest_ancestor_being_captured_id();
      if (success)
        result->closest_ancestor_with_shared_element_id = input.closest_ancestor_with_shared_element_id();
      if (success && !input.ReadViewTransitionElementResourceId(&result->view_transition_element_resource_id))
        success = false;
      if (success && !input.ReadFilters(&result->filters))
        success = false;
      if (success && !input.ReadBackdropFilters(&result->backdrop_filters))
        success = false;
      if (success && !input.ReadBackdropFilterBounds(&result->backdrop_filter_bounds))
        success = false;
      if (success)
        result->backdrop_filter_quality = input.backdrop_filter_quality();
      if (success && !input.ReadBackdropMaskElementId(&result->backdrop_mask_element_id))
        success = false;
      if (success && !input.ReadMaskFilterInfo(&result->mask_filter_info))
        success = false;
      if (success)
        result->cache_render_surface = input.cache_render_surface();
      if (success)
        result->double_sided = input.double_sided();
      if (success)
        result->trilinear_filtering = input.trilinear_filtering();
      if (success)
        result->subtree_hidden = input.subtree_hidden();
      if (success)
        result->has_potential_filter_animation = input.has_potential_filter_animation();
      if (success)
        result->has_potential_backdrop_filter_animation = input.has_potential_backdrop_filter_animation();
      if (success)
        result->has_potential_opacity_animation = input.has_potential_opacity_animation();
      if (success)
        result->subtree_has_copy_request = input.subtree_has_copy_request();
      if (success)
        result->is_fast_rounded_corner = input.is_fast_rounded_corner();
      if (success)
        result->may_have_backdrop_effect = input.may_have_backdrop_effect();
      if (success)
        result->needs_effect_for_2d_scale_transform = input.needs_effect_for_2d_scale_transform();
      if (success && !input.ReadCopyOutputRequests(&result->copy_output_requests))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::ScrollTreeUpdate::DataView, ::viz::mojom::ScrollTreeUpdatePtr>::Read(
    ::viz::mojom::ScrollTreeUpdate::DataView input,
    ::viz::mojom::ScrollTreeUpdatePtr* output) {
  bool success = true;
  ::viz::mojom::ScrollTreeUpdatePtr result(::viz::mojom::ScrollTreeUpdate::New());
  
      if (success && !input.ReadSyncedScrollOffsets(&result->synced_scroll_offsets))
        success = false;
      if (success && !input.ReadScrollingContentsCullRects(&result->scrolling_contents_cull_rects))
        success = false;
      if (success && !input.ReadElasticOverscroll(&result->elastic_overscroll))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::ScrollNode::DataView, ::viz::mojom::ScrollNodePtr>::Read(
    ::viz::mojom::ScrollNode::DataView input,
    ::viz::mojom::ScrollNodePtr* output) {
  bool success = true;
  ::viz::mojom::ScrollNodePtr result(::viz::mojom::ScrollNode::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->parent_id = input.parent_id();
      if (success)
        result->transform_id = input.transform_id();
      if (success && !input.ReadContainerBounds(&result->container_bounds))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success)
        result->max_scroll_offset_affected_by_page_scale = input.max_scroll_offset_affected_by_page_scale();
      if (success)
        result->scrolls_inner_viewport = input.scrolls_inner_viewport();
      if (success)
        result->scrolls_outer_viewport = input.scrolls_outer_viewport();
      if (success)
        result->prevent_viewport_scrolling_from_inner = input.prevent_viewport_scrolling_from_inner();
      if (success)
        result->user_scrollable_horizontal = input.user_scrollable_horizontal();
      if (success)
        result->user_scrollable_vertical = input.user_scrollable_vertical();
      if (success)
        result->is_composited = input.is_composited();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::viz::mojom::LayerExtra::DataView, ::viz::mojom::LayerExtraPtr>::Read(
    ::viz::mojom::LayerExtra::DataView input,
    ::viz::mojom::LayerExtraPtr* output) {
  using UnionType = ::viz::mojom::LayerExtra;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kMirrorLayerExtra: {
      ::viz::mojom::MirrorLayerExtraPtr result_mirror_layer_extra{};
      if (!input.ReadMirrorLayerExtra(&result_mirror_layer_extra))
        return false;

      *output = UnionType::NewMirrorLayerExtra(
          std::move(result_mirror_layer_extra));
      break;
    }
    case Tag::kNinePatchThumbScrollbarLayerExtra: {
      ::viz::mojom::NinePatchThumbScrollbarLayerExtraPtr result_nine_patch_thumb_scrollbar_layer_extra{};
      if (!input.ReadNinePatchThumbScrollbarLayerExtra(&result_nine_patch_thumb_scrollbar_layer_extra))
        return false;

      *output = UnionType::NewNinePatchThumbScrollbarLayerExtra(
          std::move(result_nine_patch_thumb_scrollbar_layer_extra));
      break;
    }
    case Tag::kPaintedScrollbarLayerExtra: {
      ::viz::mojom::PaintedScrollbarLayerExtraPtr result_painted_scrollbar_layer_extra{};
      if (!input.ReadPaintedScrollbarLayerExtra(&result_painted_scrollbar_layer_extra))
        return false;

      *output = UnionType::NewPaintedScrollbarLayerExtra(
          std::move(result_painted_scrollbar_layer_extra));
      break;
    }
    case Tag::kSolidColorScrollbarLayerExtra: {
      ::viz::mojom::SolidColorScrollbarLayerExtraPtr result_solid_color_scrollbar_layer_extra{};
      if (!input.ReadSolidColorScrollbarLayerExtra(&result_solid_color_scrollbar_layer_extra))
        return false;

      *output = UnionType::NewSolidColorScrollbarLayerExtra(
          std::move(result_solid_color_scrollbar_layer_extra));
      break;
    }
    case Tag::kSurfaceLayerExtra: {
      ::viz::mojom::SurfaceLayerExtraPtr result_surface_layer_extra{};
      if (!input.ReadSurfaceLayerExtra(&result_surface_layer_extra))
        return false;

      *output = UnionType::NewSurfaceLayerExtra(
          std::move(result_surface_layer_extra));
      break;
    }
    case Tag::kTextureLayerExtra: {
      ::viz::mojom::TextureLayerExtraPtr result_texture_layer_extra{};
      if (!input.ReadTextureLayerExtra(&result_texture_layer_extra))
        return false;

      *output = UnionType::NewTextureLayerExtra(
          std::move(result_texture_layer_extra));
      break;
    }
    case Tag::kUiResourceLayerExtra: {
      ::viz::mojom::UIResourceLayerExtraPtr result_ui_resource_layer_extra{};
      if (!input.ReadUiResourceLayerExtra(&result_ui_resource_layer_extra))
        return false;

      *output = UnionType::NewUiResourceLayerExtra(
          std::move(result_ui_resource_layer_extra));
      break;
    }
    case Tag::kTileDisplayLayerExtra: {
      ::viz::mojom::TileDisplayLayerExtraPtr result_tile_display_layer_extra{};
      if (!input.ReadTileDisplayLayerExtra(&result_tile_display_layer_extra))
        return false;

      *output = UnionType::NewTileDisplayLayerExtra(
          std::move(result_tile_display_layer_extra));
      break;
    }
    case Tag::kViewTransitionContentLayerExtra: {
      ::viz::mojom::ViewTransitionContentLayerExtraPtr result_view_transition_content_layer_extra{};
      if (!input.ReadViewTransitionContentLayerExtra(&result_view_transition_content_layer_extra))
        return false;

      *output = UnionType::NewViewTransitionContentLayerExtra(
          std::move(result_view_transition_content_layer_extra));
      break;
    }
    case Tag::kNinePatchLayerExtra: {
      ::viz::mojom::NinePatchLayerExtraPtr result_nine_patch_layer_extra{};
      if (!input.ReadNinePatchLayerExtra(&result_nine_patch_layer_extra))
        return false;

      *output = UnionType::NewNinePatchLayerExtra(
          std::move(result_nine_patch_layer_extra));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif