// services/viz/public/mojom/compositing/layer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/layer.mojom-shared-internal.h"
#include "cc/mojom/element_id.mojom-shared.h"
#include "cc/mojom/hit_test_opaqueness.mojom-shared.h"
#include "cc/mojom/layer_type.mojom-shared.h"
#include "cc/mojom/paint_flags.mojom-shared.h"
#include "cc/mojom/render_surface_reason.mojom-shared.h"
#include "cc/mojom/synced_scroll_offset.mojom-shared.h"
#include "cc/mojom/ui_resource_id.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "skia/public/mojom/skpath.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/mask_filter_info.mojom-shared.h"
#include "ui/gfx/mojom/rrect_f.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"
#include "services/viz/public/mojom/compositing/filter_operations.mojom-shared.h"
#include "services/viz/public/mojom/compositing/region_capture_bounds.mojom-shared.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"


namespace viz::mojom {
class RarePropertiesDataView;

class MirrorLayerExtraDataView;

class SurfaceLayerExtraDataView;

class TextureLayerExtraDataView;

class UIResourceLayerExtraDataView;

class TileDisplayLayerExtraDataView;

class ScrollbarLayerBaseExtraDataView;

class NinePatchThumbScrollbarLayerExtraDataView;

class PaintedScrollbarLayerExtraDataView;

class SolidColorScrollbarLayerExtraDataView;

class ViewTransitionContentLayerExtraDataView;

class NinePatchLayerExtraDataView;

class LayerDataView;

class AnchorPositionScrollDataDataView;

class StickyPositionNodeDataDataView;

class TransformTreeUpdateDataView;

class TransformNodeDataView;

class ClipNodeDataView;

class EffectNodeDataView;

class ScrollTreeUpdateDataView;

class ScrollNodeDataView;

class LayerExtraDataView;


}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::RarePropertiesDataView> {
  using Data = ::viz::mojom::internal::RareProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::MirrorLayerExtraDataView> {
  using Data = ::viz::mojom::internal::MirrorLayerExtra_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::SurfaceLayerExtraDataView> {
  using Data = ::viz::mojom::internal::SurfaceLayerExtra_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TextureLayerExtraDataView> {
  using Data = ::viz::mojom::internal::TextureLayerExtra_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::UIResourceLayerExtraDataView> {
  using Data = ::viz::mojom::internal::UIResourceLayerExtra_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TileDisplayLayerExtraDataView> {
  using Data = ::viz::mojom::internal::TileDisplayLayerExtra_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::ScrollbarLayerBaseExtraDataView> {
  using Data = ::viz::mojom::internal::ScrollbarLayerBaseExtra_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::NinePatchThumbScrollbarLayerExtraDataView> {
  using Data = ::viz::mojom::internal::NinePatchThumbScrollbarLayerExtra_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::PaintedScrollbarLayerExtraDataView> {
  using Data = ::viz::mojom::internal::PaintedScrollbarLayerExtra_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::SolidColorScrollbarLayerExtraDataView> {
  using Data = ::viz::mojom::internal::SolidColorScrollbarLayerExtra_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::ViewTransitionContentLayerExtraDataView> {
  using Data = ::viz::mojom::internal::ViewTransitionContentLayerExtra_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::NinePatchLayerExtraDataView> {
  using Data = ::viz::mojom::internal::NinePatchLayerExtra_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::LayerDataView> {
  using Data = ::viz::mojom::internal::Layer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnchorPositionScrollDataDataView> {
  using Data = ::viz::mojom::internal::AnchorPositionScrollData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::StickyPositionNodeDataDataView> {
  using Data = ::viz::mojom::internal::StickyPositionNodeData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TransformTreeUpdateDataView> {
  using Data = ::viz::mojom::internal::TransformTreeUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TransformNodeDataView> {
  using Data = ::viz::mojom::internal::TransformNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::ClipNodeDataView> {
  using Data = ::viz::mojom::internal::ClipNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::EffectNodeDataView> {
  using Data = ::viz::mojom::internal::EffectNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::ScrollTreeUpdateDataView> {
  using Data = ::viz::mojom::internal::ScrollTreeUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::ScrollNodeDataView> {
  using Data = ::viz::mojom::internal::ScrollNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::LayerExtraDataView> {
  using Data = ::viz::mojom::internal::LayerExtra_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class RarePropertiesDataView {
 public:
  RarePropertiesDataView() = default;

  RarePropertiesDataView(
      internal::RareProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFilterQuality(UserType* output) const {
    auto data_value = data_->filter_quality;
    return mojo::internal::Deserialize<::cc::mojom::FilterQuality>(
        data_value, output);
  }
  ::cc::mojom::FilterQuality filter_quality() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::cc::mojom::FilterQuality>(data_->filter_quality));
  }
  inline void GetDynamicRangeLimitDataView(
      ::cc::mojom::DynamicRangeLimitDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDynamicRangeLimit(UserType* output) {
    
    auto* pointer = data_->dynamic_range_limit.Get();
    return mojo::internal::Deserialize<::cc::mojom::DynamicRangeLimitDataView>(
        pointer, output, message_);
  }
  inline void GetCaptureBoundsDataView(
      ::viz::mojom::RegionCaptureBoundsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCaptureBounds(UserType* output) {
    
    auto* pointer = data_->capture_bounds.Get();
    return mojo::internal::Deserialize<::viz::mojom::RegionCaptureBoundsDataView>(
        pointer, output, message_);
  }
 private:
  internal::RareProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MirrorLayerExtraDataView {
 public:
  MirrorLayerExtraDataView() = default;

  MirrorLayerExtraDataView(
      internal::MirrorLayerExtra_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t mirrored_layer_id() const {
    return data_->mirrored_layer_id;
  }
 private:
  internal::MirrorLayerExtra_Data* data_ = nullptr;
};


class SurfaceLayerExtraDataView {
 public:
  SurfaceLayerExtraDataView() = default;

  SurfaceLayerExtraDataView(
      internal::SurfaceLayerExtra_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSurfaceRangeDataView(
      ::viz::mojom::SurfaceRangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSurfaceRange(UserType* output) {
    
    auto* pointer = data_->surface_range.Get();
    return mojo::internal::Deserialize<::viz::mojom::SurfaceRangeDataView>(
        pointer, output, message_);
  }
  std::optional<uint32_t> deadline_in_frames() const {

    return data_->deadline_in_frames_$flag
        ? std::make_optional(data_->deadline_in_frames_$value)
        : std::nullopt;
  }
  bool stretch_content_to_fill_bounds() const {
    return data_->stretch_content_to_fill_bounds;
  }
  bool surface_hit_testable() const {
    return data_->surface_hit_testable;
  }
  bool has_pointer_events_none() const {
    return data_->has_pointer_events_none;
  }
  bool is_reflection() const {
    return data_->is_reflection;
  }
  bool will_draw_needs_reset() const {
    return data_->will_draw_needs_reset;
  }
  bool override_child_paint_flags() const {
    return data_->override_child_paint_flags;
  }
 private:
  internal::SurfaceLayerExtra_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextureLayerExtraDataView {
 public:
  TextureLayerExtraDataView() = default;

  TextureLayerExtraDataView(
      internal::TextureLayerExtra_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool blend_background_color() const {
    return data_->blend_background_color;
  }
  bool force_texture_to_opaque() const {
    return data_->force_texture_to_opaque;
  }
  inline void GetUvTopLeftDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUvTopLeft(UserType* output) {
    
    auto* pointer = data_->uv_top_left.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetUvBottomRightDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUvBottomRight(UserType* output) {
    
    auto* pointer = data_->uv_bottom_right.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetTransferableResourceDataView(
      ::viz::mojom::TransferableResourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransferableResource(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::TransferableResourceDataView, UserType>(),
    "Attempting to read the optional `transferable_resource` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTransferableResource` instead "
    "of `ReadTransferableResource if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->transferable_resource.Get();
    return mojo::internal::Deserialize<::viz::mojom::TransferableResourceDataView>(
        pointer, output, message_);
  }
 private:
  internal::TextureLayerExtra_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UIResourceLayerExtraDataView {
 public:
  UIResourceLayerExtraDataView() = default;

  UIResourceLayerExtraDataView(
      internal::UIResourceLayerExtra_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUiResourceIdDataView(
      ::cc::mojom::UIResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUiResourceId(UserType* output) {
    
    auto* pointer = data_->ui_resource_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::UIResourceIdDataView>(
        pointer, output, message_);
  }
  inline void GetImageBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageBounds(UserType* output) {
    
    auto* pointer = data_->image_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetUvTopLeftDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUvTopLeft(UserType* output) {
    
    auto* pointer = data_->uv_top_left.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetUvBottomRightDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUvBottomRight(UserType* output) {
    
    auto* pointer = data_->uv_bottom_right.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
 private:
  internal::UIResourceLayerExtra_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TileDisplayLayerExtraDataView {
 public:
  TileDisplayLayerExtraDataView() = default;

  TileDisplayLayerExtraDataView(
      internal::TileDisplayLayerExtra_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSolidColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSolidColor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkColor4fDataView, UserType>(),
    "Attempting to read the optional `solid_color` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSolidColor` instead "
    "of `ReadSolidColor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->solid_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  bool is_backdrop_filter_mask() const {
    return data_->is_backdrop_filter_mask;
  }
  bool is_directly_composited_image() const {
    return data_->is_directly_composited_image;
  }
  bool nearest_neighbor() const {
    return data_->nearest_neighbor;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContentColorUsage(UserType* output) const {
    auto data_value = data_->content_color_usage;
    return mojo::internal::Deserialize<::gfx::mojom::ContentColorUsage>(
        data_value, output);
  }
  ::gfx::mojom::ContentColorUsage content_color_usage() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::ContentColorUsage>(data_->content_color_usage));
  }
 private:
  internal::TileDisplayLayerExtra_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollbarLayerBaseExtraDataView {
 public:
  ScrollbarLayerBaseExtraDataView() = default;

  ScrollbarLayerBaseExtraDataView(
      internal::ScrollbarLayerBaseExtra_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScrollElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollElementId(UserType* output) {
    
    auto* pointer = data_->scroll_element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  bool is_overlay_scrollbar() const {
    return data_->is_overlay_scrollbar;
  }
  bool is_web_test() const {
    return data_->is_web_test;
  }
  float thumb_thickness_scale_factor() const {
    return data_->thumb_thickness_scale_factor;
  }
  float current_pos() const {
    return data_->current_pos;
  }
  float clip_layer_length() const {
    return data_->clip_layer_length;
  }
  float scroll_layer_length() const {
    return data_->scroll_layer_length;
  }
  bool is_horizontal_orientation() const {
    return data_->is_horizontal_orientation;
  }
  bool is_left_side_vertical_scrollbar() const {
    return data_->is_left_side_vertical_scrollbar;
  }
  float vertical_adjust() const {
    return data_->vertical_adjust;
  }
  bool has_find_in_page_tickmarks() const {
    return data_->has_find_in_page_tickmarks;
  }
 private:
  internal::ScrollbarLayerBaseExtra_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NinePatchThumbScrollbarLayerExtraDataView {
 public:
  NinePatchThumbScrollbarLayerExtraDataView() = default;

  NinePatchThumbScrollbarLayerExtraDataView(
      internal::NinePatchThumbScrollbarLayerExtra_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScrollbarBaseExtraDataView(
      ScrollbarLayerBaseExtraDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollbarBaseExtra(UserType* output) {
    
    auto* pointer = data_->scrollbar_base_extra.Get();
    return mojo::internal::Deserialize<::viz::mojom::ScrollbarLayerBaseExtraDataView>(
        pointer, output, message_);
  }
  int32_t thumb_thickness() const {
    return data_->thumb_thickness;
  }
  int32_t thumb_length() const {
    return data_->thumb_length;
  }
  int32_t track_start() const {
    return data_->track_start;
  }
  int32_t track_length() const {
    return data_->track_length;
  }
  inline void GetImageBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageBounds(UserType* output) {
    
    auto* pointer = data_->image_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetApertureDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAperture(UserType* output) {
    
    auto* pointer = data_->aperture.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetThumbUiResourceIdDataView(
      ::cc::mojom::UIResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadThumbUiResourceId(UserType* output) {
    
    auto* pointer = data_->thumb_ui_resource_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::UIResourceIdDataView>(
        pointer, output, message_);
  }
  inline void GetTrackAndButtonsUiResourceIdDataView(
      ::cc::mojom::UIResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackAndButtonsUiResourceId(UserType* output) {
    
    auto* pointer = data_->track_and_buttons_ui_resource_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::UIResourceIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::NinePatchThumbScrollbarLayerExtra_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaintedScrollbarLayerExtraDataView {
 public:
  PaintedScrollbarLayerExtraDataView() = default;

  PaintedScrollbarLayerExtraDataView(
      internal::PaintedScrollbarLayerExtra_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScrollbarBaseExtraDataView(
      ScrollbarLayerBaseExtraDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollbarBaseExtra(UserType* output) {
    
    auto* pointer = data_->scrollbar_base_extra.Get();
    return mojo::internal::Deserialize<::viz::mojom::ScrollbarLayerBaseExtraDataView>(
        pointer, output, message_);
  }
  float internal_contents_scale() const {
    return data_->internal_contents_scale;
  }
  inline void GetInternalContentBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInternalContentBounds(UserType* output) {
    
    auto* pointer = data_->internal_content_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool jump_on_track_click() const {
    return data_->jump_on_track_click;
  }
  bool supports_drag_snap_back() const {
    return data_->supports_drag_snap_back;
  }
  int32_t thumb_thickness() const {
    return data_->thumb_thickness;
  }
  int32_t thumb_length() const {
    return data_->thumb_length;
  }
  inline void GetBackButtonRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackButtonRect(UserType* output) {
    
    auto* pointer = data_->back_button_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetForwardButtonRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadForwardButtonRect(UserType* output) {
    
    auto* pointer = data_->forward_button_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetTrackRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackRect(UserType* output) {
    
    auto* pointer = data_->track_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetThumbColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadThumbColor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkColor4fDataView, UserType>(),
    "Attempting to read the optional `thumb_color` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadThumbColor` instead "
    "of `ReadThumbColor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->thumb_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  bool uses_nine_patch_track_and_buttons() const {
    return data_->uses_nine_patch_track_and_buttons;
  }
  inline void GetTrackAndButtonsImageBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackAndButtonsImageBounds(UserType* output) {
    
    auto* pointer = data_->track_and_buttons_image_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetTrackAndButtonsApertureDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackAndButtonsAperture(UserType* output) {
    
    auto* pointer = data_->track_and_buttons_aperture.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  float painted_opacity() const {
    return data_->painted_opacity;
  }
  inline void GetTrackAndButtonsUiResourceIdDataView(
      ::cc::mojom::UIResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackAndButtonsUiResourceId(UserType* output) {
    
    auto* pointer = data_->track_and_buttons_ui_resource_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::UIResourceIdDataView>(
        pointer, output, message_);
  }
  inline void GetThumbUiResourceIdDataView(
      ::cc::mojom::UIResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadThumbUiResourceId(UserType* output) {
    
    auto* pointer = data_->thumb_ui_resource_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::UIResourceIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaintedScrollbarLayerExtra_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SolidColorScrollbarLayerExtraDataView {
 public:
  SolidColorScrollbarLayerExtraDataView() = default;

  SolidColorScrollbarLayerExtraDataView(
      internal::SolidColorScrollbarLayerExtra_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScrollbarBaseExtraDataView(
      ScrollbarLayerBaseExtraDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollbarBaseExtra(UserType* output) {
    
    auto* pointer = data_->scrollbar_base_extra.Get();
    return mojo::internal::Deserialize<::viz::mojom::ScrollbarLayerBaseExtraDataView>(
        pointer, output, message_);
  }
  int32_t thumb_thickness() const {
    return data_->thumb_thickness;
  }
  int32_t track_start() const {
    return data_->track_start;
  }
  inline void GetColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) {
    
    auto* pointer = data_->color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
 private:
  internal::SolidColorScrollbarLayerExtra_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ViewTransitionContentLayerExtraDataView {
 public:
  ViewTransitionContentLayerExtraDataView() = default;

  ViewTransitionContentLayerExtraDataView(
      internal::ViewTransitionContentLayerExtra_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResourceIdDataView(
      ::viz::mojom::ViewTransitionElementResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResourceId(UserType* output) {
    
    auto* pointer = data_->resource_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
        pointer, output, message_);
  }
  bool is_live_content_layer() const {
    return data_->is_live_content_layer;
  }
  inline void GetMaxExtentsRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxExtentsRect(UserType* output) {
    
    auto* pointer = data_->max_extents_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
 private:
  internal::ViewTransitionContentLayerExtra_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NinePatchLayerExtraDataView {
 public:
  NinePatchLayerExtraDataView() = default;

  NinePatchLayerExtraDataView(
      internal::NinePatchLayerExtra_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageApertureDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageAperture(UserType* output) {
    
    auto* pointer = data_->image_aperture.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetBorderDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBorder(UserType* output) {
    
    auto* pointer = data_->border.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetLayerOcclusionDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayerOcclusion(UserType* output) {
    
    auto* pointer = data_->layer_occlusion.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  bool fill_center() const {
    return data_->fill_center;
  }
  inline void GetUiResourceIdDataView(
      ::cc::mojom::UIResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUiResourceId(UserType* output) {
    
    auto* pointer = data_->ui_resource_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::UIResourceIdDataView>(
        pointer, output, message_);
  }
  inline void GetImageBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageBounds(UserType* output) {
    
    auto* pointer = data_->image_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetUvTopLeftDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUvTopLeft(UserType* output) {
    
    auto* pointer = data_->uv_top_left.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetUvBottomRightDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUvBottomRight(UserType* output) {
    
    auto* pointer = data_->uv_bottom_right.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
 private:
  internal::NinePatchLayerExtra_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LayerDataView {
 public:
  LayerDataView() = default;

  LayerDataView(
      internal::Layer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::cc::mojom::LayerType>(
        data_value, output);
  }
  ::cc::mojom::LayerType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::cc::mojom::LayerType>(data_->type));
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool contents_opaque() const {
    return data_->contents_opaque;
  }
  bool contents_opaque_for_text() const {
    return data_->contents_opaque_for_text;
  }
  bool is_drawable() const {
    return data_->is_drawable;
  }
  bool layer_property_changed_not_from_property_trees() const {
    return data_->layer_property_changed_not_from_property_trees;
  }
  bool layer_property_changed_from_property_trees() const {
    return data_->layer_property_changed_from_property_trees;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHitTestOpaqueness(UserType* output) const {
    auto data_value = data_->hit_test_opaqueness;
    return mojo::internal::Deserialize<::cc::mojom::HitTestOpaqueness>(
        data_value, output);
  }
  ::cc::mojom::HitTestOpaqueness hit_test_opaqueness() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::cc::mojom::HitTestOpaqueness>(data_->hit_test_opaqueness));
  }
  inline void GetBackgroundColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundColor(UserType* output) {
    
    auto* pointer = data_->background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  inline void GetSafeOpaqueBackgroundColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSafeOpaqueBackgroundColor(UserType* output) {
    
    auto* pointer = data_->safe_opaque_background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  inline void GetUpdateRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateRect(UserType* output) {
    
    auto* pointer = data_->update_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetOffsetToTransformParentDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffsetToTransformParent(UserType* output) {
    
    auto* pointer = data_->offset_to_transform_parent.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  int32_t transform_tree_index() const {
    return data_->transform_tree_index;
  }
  int32_t clip_tree_index() const {
    return data_->clip_tree_index;
  }
  int32_t effect_tree_index() const {
    return data_->effect_tree_index;
  }
  int32_t scroll_tree_index() const {
    return data_->scroll_tree_index;
  }
  bool should_check_backface_visibility() const {
    return data_->should_check_backface_visibility;
  }
  inline void GetRarePropertiesDataView(
      RarePropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRareProperties(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::RarePropertiesDataView, UserType>(),
    "Attempting to read the optional `rare_properties` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRareProperties` instead "
    "of `ReadRareProperties if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->rare_properties.Get();
    return mojo::internal::Deserialize<::viz::mojom::RarePropertiesDataView>(
        pointer, output, message_);
  }
  inline void GetLayerExtraDataView(
      LayerExtraDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayerExtra(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::LayerExtraDataView, UserType>(),
    "Attempting to read the optional `layer_extra` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLayerExtra` instead "
    "of `ReadLayerExtra if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->layer_extra.is_null() ? &data_->layer_extra : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::LayerExtraDataView>(
        pointer, output, message_);
  }
 private:
  internal::Layer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnchorPositionScrollDataDataView {
 public:
  AnchorPositionScrollDataDataView() = default;

  AnchorPositionScrollDataDataView(
      internal::AnchorPositionScrollData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAdjustmentContainerIdsDataView(
      mojo::ArrayDataView<::cc::mojom::ElementIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdjustmentContainerIds(UserType* output) {
    
    auto* pointer = data_->adjustment_container_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::cc::mojom::ElementIdDataView>>(
        pointer, output, message_);
  }
  inline void GetAccumulatedScrollOriginDataView(
      ::gfx::mojom::Vector2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccumulatedScrollOrigin(UserType* output) {
    
    auto* pointer = data_->accumulated_scroll_origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dDataView>(
        pointer, output, message_);
  }
  bool needs_scroll_adjustment_in_x() const {
    return data_->needs_scroll_adjustment_in_x;
  }
  bool needs_scroll_adjustment_in_y() const {
    return data_->needs_scroll_adjustment_in_y;
  }
 private:
  internal::AnchorPositionScrollData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StickyPositionNodeDataDataView {
 public:
  StickyPositionNodeDataDataView() = default;

  StickyPositionNodeDataDataView(
      internal::StickyPositionNodeData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t scroll_ancestor() const {
    return data_->scroll_ancestor;
  }
  bool is_anchored_left() const {
    return data_->is_anchored_left;
  }
  bool is_anchored_right() const {
    return data_->is_anchored_right;
  }
  bool is_anchored_top() const {
    return data_->is_anchored_top;
  }
  bool is_anchored_bottom() const {
    return data_->is_anchored_bottom;
  }
  float left_offset() const {
    return data_->left_offset;
  }
  float right_offset() const {
    return data_->right_offset;
  }
  float top_offset() const {
    return data_->top_offset;
  }
  float bottom_offset() const {
    return data_->bottom_offset;
  }
  inline void GetConstraintBoxRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConstraintBoxRect(UserType* output) {
    
    auto* pointer = data_->constraint_box_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetScrollContainerRelativeStickyBoxRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollContainerRelativeStickyBoxRect(UserType* output) {
    
    auto* pointer = data_->scroll_container_relative_sticky_box_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetScrollContainerRelativeContainingBlockRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollContainerRelativeContainingBlockRect(UserType* output) {
    
    auto* pointer = data_->scroll_container_relative_containing_block_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetPixelSnapOffsetDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelSnapOffset(UserType* output) {
    
    auto* pointer = data_->pixel_snap_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  int32_t nearest_node_shifting_sticky_box() const {
    return data_->nearest_node_shifting_sticky_box;
  }
  int32_t nearest_node_shifting_containing_block() const {
    return data_->nearest_node_shifting_containing_block;
  }
  inline void GetTotalStickyBoxStickyOffsetDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotalStickyBoxStickyOffset(UserType* output) {
    
    auto* pointer = data_->total_sticky_box_sticky_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetTotalContainingBlockStickyOffsetDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotalContainingBlockStickyOffset(UserType* output) {
    
    auto* pointer = data_->total_containing_block_sticky_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
 private:
  internal::StickyPositionNodeData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TransformTreeUpdateDataView {
 public:
  TransformTreeUpdateDataView() = default;

  TransformTreeUpdateDataView(
      internal::TransformTreeUpdate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  float page_scale_factor() const {
    return data_->page_scale_factor;
  }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  float device_transform_scale_factor() const {
    return data_->device_transform_scale_factor;
  }
  inline void GetNodesAffectedByOuterViewportBoundsDeltaDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNodesAffectedByOuterViewportBoundsDelta(UserType* output) {
    
    auto* pointer = data_->nodes_affected_by_outer_viewport_bounds_delta.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetNodesAffectedBySafeAreaBottomDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNodesAffectedBySafeAreaBottom(UserType* output) {
    
    auto* pointer = data_->nodes_affected_by_safe_area_bottom.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetStickyPositionDataDataView(
      mojo::ArrayDataView<StickyPositionNodeDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStickyPositionData(UserType* output) {
    
    auto* pointer = data_->sticky_position_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::StickyPositionNodeDataDataView>>(
        pointer, output, message_);
  }
  inline void GetAnchorPositionScrollDataDataView(
      mojo::ArrayDataView<AnchorPositionScrollDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnchorPositionScrollData(UserType* output) {
    
    auto* pointer = data_->anchor_position_scroll_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::AnchorPositionScrollDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TransformTreeUpdate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TransformNodeDataView {
 public:
  TransformNodeDataView() = default;

  TransformNodeDataView(
      internal::TransformNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t parent_id() const {
    return data_->parent_id;
  }
  int32_t parent_frame_id() const {
    return data_->parent_frame_id;
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  inline void GetLocalDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocal(UserType* output) {
    
    auto* pointer = data_->local.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetOriginDataView(
      ::gfx::mojom::Point3FDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Point3FDataView>(
        pointer, output, message_);
  }
  inline void GetPostTranslationDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPostTranslation(UserType* output) {
    
    auto* pointer = data_->post_translation.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetToParentDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToParent(UserType* output) {
    
    auto* pointer = data_->to_parent.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetScrollOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollOffset(UserType* output) {
    
    auto* pointer = data_->scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetSnapAmountDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSnapAmount(UserType* output) {
    
    auto* pointer = data_->snap_amount.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  std::optional<uint32_t> sticky_position_constraint_id() const {

    return data_->sticky_position_constraint_id_$flag
        ? std::make_optional(data_->sticky_position_constraint_id_$value)
        : std::nullopt;
  }
  std::optional<uint32_t> anchor_position_scroll_data_id() const {

    return data_->anchor_position_scroll_data_id_$flag
        ? std::make_optional(data_->anchor_position_scroll_data_id_$value)
        : std::nullopt;
  }
  int32_t sorting_context_id() const {
    return data_->sorting_context_id;
  }
  bool has_potential_animation() const {
    return data_->has_potential_animation;
  }
  bool is_currently_animating() const {
    return data_->is_currently_animating;
  }
  bool flattens_inherited_transform() const {
    return data_->flattens_inherited_transform;
  }
  bool scrolls() const {
    return data_->scrolls;
  }
  bool should_undo_overscroll() const {
    return data_->should_undo_overscroll;
  }
  bool should_be_snapped() const {
    return data_->should_be_snapped;
  }
  bool moved_by_outer_viewport_bounds_delta_y() const {
    return data_->moved_by_outer_viewport_bounds_delta_y;
  }
  bool in_subtree_of_page_scale_layer() const {
    return data_->in_subtree_of_page_scale_layer;
  }
  bool transform_changed() const {
    return data_->transform_changed;
  }
  bool delegates_to_parent_for_backface() const {
    return data_->delegates_to_parent_for_backface;
  }
  bool will_change_transform() const {
    return data_->will_change_transform;
  }
  float maximum_animation_scale() const {
    return data_->maximum_animation_scale;
  }
  bool node_and_ancestors_are_animated_or_invertible() const {
    return data_->node_and_ancestors_are_animated_or_invertible;
  }
  bool is_invertible() const {
    return data_->is_invertible;
  }
  bool ancestors_are_invertible() const {
    return data_->ancestors_are_invertible;
  }
  bool node_and_ancestors_are_flat() const {
    return data_->node_and_ancestors_are_flat;
  }
  bool node_or_ancestors_will_change_transform() const {
    return data_->node_or_ancestors_will_change_transform;
  }
  inline void GetVisibleFrameElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleFrameElementId(UserType* output) {
    
    auto* pointer = data_->visible_frame_element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  uint64_t damage_reasons_bit_mask() const {
    return data_->damage_reasons_bit_mask;
  }
  bool moved_by_safe_area_bottom() const {
    return data_->moved_by_safe_area_bottom;
  }
 private:
  internal::TransformNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClipNodeDataView {
 public:
  ClipNodeDataView() = default;

  ClipNodeDataView(
      internal::ClipNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t parent_id() const {
    return data_->parent_id;
  }
  int32_t transform_id() const {
    return data_->transform_id;
  }
  inline void GetClipDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClip(UserType* output) {
    
    auto* pointer = data_->clip.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  int32_t pixel_moving_filter_id() const {
    return data_->pixel_moving_filter_id;
  }
 private:
  internal::ClipNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EffectNodeDataView {
 public:
  EffectNodeDataView() = default;

  EffectNodeDataView(
      internal::EffectNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t parent_id() const {
    return data_->parent_id;
  }
  int32_t transform_id() const {
    return data_->transform_id;
  }
  int32_t clip_id() const {
    return data_->clip_id;
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  float opacity() const {
    return data_->opacity;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRenderSurfaceReason(UserType* output) const {
    auto data_value = data_->render_surface_reason;
    return mojo::internal::Deserialize<::cc::mojom::RenderSurfaceReason>(
        data_value, output);
  }
  ::cc::mojom::RenderSurfaceReason render_surface_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::cc::mojom::RenderSurfaceReason>(data_->render_surface_reason));
  }
  inline void GetSurfaceContentsScaleDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSurfaceContentsScale(UserType* output) {
    
    auto* pointer = data_->surface_contents_scale.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetSubtreeCaptureIdDataView(
      ::viz::mojom::SubtreeCaptureIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubtreeCaptureId(UserType* output) {
    
    auto* pointer = data_->subtree_capture_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::SubtreeCaptureIdDataView>(
        pointer, output, message_);
  }
  inline void GetSubtreeSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubtreeSize(UserType* output) {
    
    auto* pointer = data_->subtree_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  uint32_t blend_mode() const {
    return data_->blend_mode;
  }
  int32_t target_id() const {
    return data_->target_id;
  }
  int32_t view_transition_target_id() const {
    return data_->view_transition_target_id;
  }
  int32_t closest_ancestor_with_cached_render_surface_id() const {
    return data_->closest_ancestor_with_cached_render_surface_id;
  }
  int32_t closest_ancestor_with_copy_request_id() const {
    return data_->closest_ancestor_with_copy_request_id;
  }
  int32_t closest_ancestor_being_captured_id() const {
    return data_->closest_ancestor_being_captured_id;
  }
  int32_t closest_ancestor_with_shared_element_id() const {
    return data_->closest_ancestor_with_shared_element_id;
  }
  inline void GetViewTransitionElementResourceIdDataView(
      ::viz::mojom::ViewTransitionElementResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewTransitionElementResourceId(UserType* output) {
    
    auto* pointer = data_->view_transition_element_resource_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
        pointer, output, message_);
  }
  inline void GetFiltersDataView(
      ::viz::mojom::FilterOperationsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<::viz::mojom::FilterOperationsDataView>(
        pointer, output, message_);
  }
  inline void GetBackdropFiltersDataView(
      ::viz::mojom::FilterOperationsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackdropFilters(UserType* output) {
    
    auto* pointer = data_->backdrop_filters.Get();
    return mojo::internal::Deserialize<::viz::mojom::FilterOperationsDataView>(
        pointer, output, message_);
  }
  inline void GetBackdropFilterBoundsDataView(
      ::skia::mojom::SkPathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackdropFilterBounds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkPathDataView, UserType>(),
    "Attempting to read the optional `backdrop_filter_bounds` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBackdropFilterBounds` instead "
    "of `ReadBackdropFilterBounds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->backdrop_filter_bounds.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkPathDataView>(
        pointer, output, message_);
  }
  float backdrop_filter_quality() const {
    return data_->backdrop_filter_quality;
  }
  inline void GetBackdropMaskElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackdropMaskElementId(UserType* output) {
    
    auto* pointer = data_->backdrop_mask_element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  inline void GetMaskFilterInfoDataView(
      ::gfx::mojom::MaskFilterInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaskFilterInfo(UserType* output) {
    
    auto* pointer = data_->mask_filter_info.Get();
    return mojo::internal::Deserialize<::gfx::mojom::MaskFilterInfoDataView>(
        pointer, output, message_);
  }
  bool cache_render_surface() const {
    return data_->cache_render_surface;
  }
  bool double_sided() const {
    return data_->double_sided;
  }
  bool trilinear_filtering() const {
    return data_->trilinear_filtering;
  }
  bool subtree_hidden() const {
    return data_->subtree_hidden;
  }
  bool has_potential_filter_animation() const {
    return data_->has_potential_filter_animation;
  }
  bool has_potential_backdrop_filter_animation() const {
    return data_->has_potential_backdrop_filter_animation;
  }
  bool has_potential_opacity_animation() const {
    return data_->has_potential_opacity_animation;
  }
  bool subtree_has_copy_request() const {
    return data_->subtree_has_copy_request;
  }
  bool is_fast_rounded_corner() const {
    return data_->is_fast_rounded_corner;
  }
  bool may_have_backdrop_effect() const {
    return data_->may_have_backdrop_effect;
  }
  bool needs_effect_for_2d_scale_transform() const {
    return data_->needs_effect_for_2d_scale_transform;
  }
  inline void GetCopyOutputRequestsDataView(
      mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCopyOutputRequests(UserType* output) {
    
    auto* pointer = data_->copy_output_requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>>(
        pointer, output, message_);
  }
 private:
  internal::EffectNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollTreeUpdateDataView {
 public:
  ScrollTreeUpdateDataView() = default;

  ScrollTreeUpdateDataView(
      internal::ScrollTreeUpdate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSyncedScrollOffsetsDataView(
      mojo::MapDataView<::cc::mojom::ElementIdDataView, ::cc::mojom::SyncedScrollOffsetDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncedScrollOffsets(UserType* output) {
    
    auto* pointer = data_->synced_scroll_offsets.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::cc::mojom::ElementIdDataView, ::cc::mojom::SyncedScrollOffsetDataView>>(
        pointer, output, message_);
  }
  inline void GetScrollingContentsCullRectsDataView(
      mojo::MapDataView<::cc::mojom::ElementIdDataView, ::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollingContentsCullRects(UserType* output) {
    
    auto* pointer = data_->scrolling_contents_cull_rects.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::cc::mojom::ElementIdDataView, ::gfx::mojom::RectDataView>>(
        pointer, output, message_);
  }
  inline void GetElasticOverscrollDataView(
      mojo::MapDataView<::cc::mojom::ElementIdDataView, ::gfx::mojom::Vector2dFDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElasticOverscroll(UserType* output) {
    
    auto* pointer = data_->elastic_overscroll.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::cc::mojom::ElementIdDataView, ::gfx::mojom::Vector2dFDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ScrollTreeUpdate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollNodeDataView {
 public:
  ScrollNodeDataView() = default;

  ScrollNodeDataView(
      internal::ScrollNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t parent_id() const {
    return data_->parent_id;
  }
  int32_t transform_id() const {
    return data_->transform_id;
  }
  inline void GetContainerBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContainerBounds(UserType* output) {
    
    auto* pointer = data_->container_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  bool max_scroll_offset_affected_by_page_scale() const {
    return data_->max_scroll_offset_affected_by_page_scale;
  }
  bool scrolls_inner_viewport() const {
    return data_->scrolls_inner_viewport;
  }
  bool scrolls_outer_viewport() const {
    return data_->scrolls_outer_viewport;
  }
  bool prevent_viewport_scrolling_from_inner() const {
    return data_->prevent_viewport_scrolling_from_inner;
  }
  bool user_scrollable_horizontal() const {
    return data_->user_scrollable_horizontal;
  }
  bool user_scrollable_vertical() const {
    return data_->user_scrollable_vertical;
  }
  bool is_composited() const {
    return data_->is_composited;
  }
 private:
  internal::ScrollNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LayerExtraDataView {
 public:
  using Tag = internal::LayerExtra_Data::LayerExtra_Tag;

  LayerExtraDataView() = default;

  LayerExtraDataView(
      internal::LayerExtra_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_mirror_layer_extra() const { return data_->tag == Tag::kMirrorLayerExtra; }
  inline void GetMirrorLayerExtraDataView(
      MirrorLayerExtraDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMirrorLayerExtra(UserType* output) const {
    
    CHECK(is_mirror_layer_extra());
    return mojo::internal::Deserialize<::viz::mojom::MirrorLayerExtraDataView>(
        data_->data.f_mirror_layer_extra.Get(), output, message_);
  }
  bool is_nine_patch_thumb_scrollbar_layer_extra() const { return data_->tag == Tag::kNinePatchThumbScrollbarLayerExtra; }
  inline void GetNinePatchThumbScrollbarLayerExtraDataView(
      NinePatchThumbScrollbarLayerExtraDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNinePatchThumbScrollbarLayerExtra(UserType* output) const {
    
    CHECK(is_nine_patch_thumb_scrollbar_layer_extra());
    return mojo::internal::Deserialize<::viz::mojom::NinePatchThumbScrollbarLayerExtraDataView>(
        data_->data.f_nine_patch_thumb_scrollbar_layer_extra.Get(), output, message_);
  }
  bool is_painted_scrollbar_layer_extra() const { return data_->tag == Tag::kPaintedScrollbarLayerExtra; }
  inline void GetPaintedScrollbarLayerExtraDataView(
      PaintedScrollbarLayerExtraDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPaintedScrollbarLayerExtra(UserType* output) const {
    
    CHECK(is_painted_scrollbar_layer_extra());
    return mojo::internal::Deserialize<::viz::mojom::PaintedScrollbarLayerExtraDataView>(
        data_->data.f_painted_scrollbar_layer_extra.Get(), output, message_);
  }
  bool is_solid_color_scrollbar_layer_extra() const { return data_->tag == Tag::kSolidColorScrollbarLayerExtra; }
  inline void GetSolidColorScrollbarLayerExtraDataView(
      SolidColorScrollbarLayerExtraDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSolidColorScrollbarLayerExtra(UserType* output) const {
    
    CHECK(is_solid_color_scrollbar_layer_extra());
    return mojo::internal::Deserialize<::viz::mojom::SolidColorScrollbarLayerExtraDataView>(
        data_->data.f_solid_color_scrollbar_layer_extra.Get(), output, message_);
  }
  bool is_surface_layer_extra() const { return data_->tag == Tag::kSurfaceLayerExtra; }
  inline void GetSurfaceLayerExtraDataView(
      SurfaceLayerExtraDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSurfaceLayerExtra(UserType* output) const {
    
    CHECK(is_surface_layer_extra());
    return mojo::internal::Deserialize<::viz::mojom::SurfaceLayerExtraDataView>(
        data_->data.f_surface_layer_extra.Get(), output, message_);
  }
  bool is_texture_layer_extra() const { return data_->tag == Tag::kTextureLayerExtra; }
  inline void GetTextureLayerExtraDataView(
      TextureLayerExtraDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTextureLayerExtra(UserType* output) const {
    
    CHECK(is_texture_layer_extra());
    return mojo::internal::Deserialize<::viz::mojom::TextureLayerExtraDataView>(
        data_->data.f_texture_layer_extra.Get(), output, message_);
  }
  bool is_ui_resource_layer_extra() const { return data_->tag == Tag::kUiResourceLayerExtra; }
  inline void GetUiResourceLayerExtraDataView(
      UIResourceLayerExtraDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUiResourceLayerExtra(UserType* output) const {
    
    CHECK(is_ui_resource_layer_extra());
    return mojo::internal::Deserialize<::viz::mojom::UIResourceLayerExtraDataView>(
        data_->data.f_ui_resource_layer_extra.Get(), output, message_);
  }
  bool is_tile_display_layer_extra() const { return data_->tag == Tag::kTileDisplayLayerExtra; }
  inline void GetTileDisplayLayerExtraDataView(
      TileDisplayLayerExtraDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTileDisplayLayerExtra(UserType* output) const {
    
    CHECK(is_tile_display_layer_extra());
    return mojo::internal::Deserialize<::viz::mojom::TileDisplayLayerExtraDataView>(
        data_->data.f_tile_display_layer_extra.Get(), output, message_);
  }
  bool is_view_transition_content_layer_extra() const { return data_->tag == Tag::kViewTransitionContentLayerExtra; }
  inline void GetViewTransitionContentLayerExtraDataView(
      ViewTransitionContentLayerExtraDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadViewTransitionContentLayerExtra(UserType* output) const {
    
    CHECK(is_view_transition_content_layer_extra());
    return mojo::internal::Deserialize<::viz::mojom::ViewTransitionContentLayerExtraDataView>(
        data_->data.f_view_transition_content_layer_extra.Get(), output, message_);
  }
  bool is_nine_patch_layer_extra() const { return data_->tag == Tag::kNinePatchLayerExtra; }
  inline void GetNinePatchLayerExtraDataView(
      NinePatchLayerExtraDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNinePatchLayerExtra(UserType* output) const {
    
    CHECK(is_nine_patch_layer_extra());
    return mojo::internal::Deserialize<::viz::mojom::NinePatchLayerExtraDataView>(
        data_->data.f_nine_patch_layer_extra.Get(), output, message_);
  }

 private:
  internal::LayerExtra_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_DATA_VIEW_H_