// services/viz/public/mojom/compositing/layer.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/layer.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/layer.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/layer.mojom-blink-forward.h"  // IWYU pragma: export
#include "cc/mojom/element_id.mojom-blink.h"
#include "cc/mojom/hit_test_opaqueness.mojom-blink-forward.h"
#include "cc/mojom/layer_type.mojom-blink-forward.h"
#include "cc/mojom/paint_flags.mojom-blink.h"
#include "cc/mojom/render_surface_reason.mojom-blink-forward.h"
#include "cc/mojom/synced_scroll_offset.mojom-blink.h"
#include "cc/mojom/ui_resource_id.mojom-blink.h"
#include "skia/public/mojom/skcolor4f.mojom-blink.h"
#include "skia/public/mojom/skpath.mojom-blink.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/mask_filter_info.mojom-blink.h"
#include "ui/gfx/mojom/rrect_f.mojom-blink-forward.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-blink.h"
#include "services/viz/public/mojom/compositing/filter_operations.mojom-blink.h"
#include "services/viz/public/mojom/compositing/region_capture_bounds.mojom-blink.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-blink-forward.h"
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-blink.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-blink.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-blink.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-blink.h"
#include "ui/gfx/mojom/transform.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {






class BLINK_PLATFORM_EXPORT MirrorLayerExtra {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MirrorLayerExtra, T>::value>;
  using DataView = MirrorLayerExtraDataView;
  using Data_ = internal::MirrorLayerExtra_Data;

  template <typename... Args>
  static MirrorLayerExtraPtr New(Args&&... args) {
    return MirrorLayerExtraPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MirrorLayerExtraPtr From(const U& u) {
    return mojo::TypeConverter<MirrorLayerExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MirrorLayerExtra>::Convert(*this);
  }


  MirrorLayerExtra();

  explicit MirrorLayerExtra(
      int32_t mirrored_layer_id);


  ~MirrorLayerExtra();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MirrorLayerExtraPtr>
  MirrorLayerExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MirrorLayerExtra::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MirrorLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MirrorLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MirrorLayerExtra::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MirrorLayerExtra::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MirrorLayerExtra::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MirrorLayerExtra_UnserializedMessageContext<
            UserType, MirrorLayerExtra::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MirrorLayerExtra::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MirrorLayerExtra::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MirrorLayerExtra_UnserializedMessageContext<
            UserType, MirrorLayerExtra::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MirrorLayerExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t mirrored_layer_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MirrorLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MirrorLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MirrorLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MirrorLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}
























class BLINK_PLATFORM_EXPORT LayerExtra {
 public:
  using DataView = LayerExtraDataView;
  using Data_ = internal::LayerExtra_Data;
  using Tag = Data_::LayerExtra_Tag;

  template <typename... Args>
  static LayerExtraPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |mirror_layer_extra|.
  static LayerExtraPtr NewMirrorLayerExtra(
      MirrorLayerExtraPtr value);
  // Construct an instance holding |nine_patch_thumb_scrollbar_layer_extra|.
  static LayerExtraPtr NewNinePatchThumbScrollbarLayerExtra(
      NinePatchThumbScrollbarLayerExtraPtr value);
  // Construct an instance holding |painted_scrollbar_layer_extra|.
  static LayerExtraPtr NewPaintedScrollbarLayerExtra(
      PaintedScrollbarLayerExtraPtr value);
  // Construct an instance holding |solid_color_scrollbar_layer_extra|.
  static LayerExtraPtr NewSolidColorScrollbarLayerExtra(
      SolidColorScrollbarLayerExtraPtr value);
  // Construct an instance holding |surface_layer_extra|.
  static LayerExtraPtr NewSurfaceLayerExtra(
      SurfaceLayerExtraPtr value);
  // Construct an instance holding |texture_layer_extra|.
  static LayerExtraPtr NewTextureLayerExtra(
      TextureLayerExtraPtr value);
  // Construct an instance holding |ui_resource_layer_extra|.
  static LayerExtraPtr NewUiResourceLayerExtra(
      UIResourceLayerExtraPtr value);
  // Construct an instance holding |tile_display_layer_extra|.
  static LayerExtraPtr NewTileDisplayLayerExtra(
      TileDisplayLayerExtraPtr value);
  // Construct an instance holding |view_transition_content_layer_extra|.
  static LayerExtraPtr NewViewTransitionContentLayerExtra(
      ViewTransitionContentLayerExtraPtr value);
  // Construct an instance holding |nine_patch_layer_extra|.
  static LayerExtraPtr NewNinePatchLayerExtra(
      NinePatchLayerExtraPtr value);

  template <typename U>
  static LayerExtraPtr From(const U& u) {
    return mojo::TypeConverter<LayerExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayerExtra>::Convert(*this);
  }
  ~LayerExtra();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  LayerExtra(const LayerExtra& other) = delete;
  LayerExtra& operator=(const LayerExtra& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = LayerExtraPtr>
  LayerExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, LayerExtra>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, LayerExtra>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_mirror_layer_extra() const { return tag_ == Tag::kMirrorLayerExtra; }
  const MirrorLayerExtraPtr& get_mirror_layer_extra() const {
    CHECK(tag_ == Tag::kMirrorLayerExtra);
    return data_.mirror_layer_extra;
  }
  MirrorLayerExtraPtr& get_mirror_layer_extra() {
    CHECK(tag_ == Tag::kMirrorLayerExtra);
    return data_.mirror_layer_extra;
  }
  void set_mirror_layer_extra(MirrorLayerExtraPtr mirror_layer_extra);

  bool is_nine_patch_thumb_scrollbar_layer_extra() const { return tag_ == Tag::kNinePatchThumbScrollbarLayerExtra; }
  const NinePatchThumbScrollbarLayerExtraPtr& get_nine_patch_thumb_scrollbar_layer_extra() const {
    CHECK(tag_ == Tag::kNinePatchThumbScrollbarLayerExtra);
    return data_.nine_patch_thumb_scrollbar_layer_extra;
  }
  NinePatchThumbScrollbarLayerExtraPtr& get_nine_patch_thumb_scrollbar_layer_extra() {
    CHECK(tag_ == Tag::kNinePatchThumbScrollbarLayerExtra);
    return data_.nine_patch_thumb_scrollbar_layer_extra;
  }
  void set_nine_patch_thumb_scrollbar_layer_extra(NinePatchThumbScrollbarLayerExtraPtr nine_patch_thumb_scrollbar_layer_extra);

  bool is_painted_scrollbar_layer_extra() const { return tag_ == Tag::kPaintedScrollbarLayerExtra; }
  const PaintedScrollbarLayerExtraPtr& get_painted_scrollbar_layer_extra() const {
    CHECK(tag_ == Tag::kPaintedScrollbarLayerExtra);
    return data_.painted_scrollbar_layer_extra;
  }
  PaintedScrollbarLayerExtraPtr& get_painted_scrollbar_layer_extra() {
    CHECK(tag_ == Tag::kPaintedScrollbarLayerExtra);
    return data_.painted_scrollbar_layer_extra;
  }
  void set_painted_scrollbar_layer_extra(PaintedScrollbarLayerExtraPtr painted_scrollbar_layer_extra);

  bool is_solid_color_scrollbar_layer_extra() const { return tag_ == Tag::kSolidColorScrollbarLayerExtra; }
  const SolidColorScrollbarLayerExtraPtr& get_solid_color_scrollbar_layer_extra() const {
    CHECK(tag_ == Tag::kSolidColorScrollbarLayerExtra);
    return data_.solid_color_scrollbar_layer_extra;
  }
  SolidColorScrollbarLayerExtraPtr& get_solid_color_scrollbar_layer_extra() {
    CHECK(tag_ == Tag::kSolidColorScrollbarLayerExtra);
    return data_.solid_color_scrollbar_layer_extra;
  }
  void set_solid_color_scrollbar_layer_extra(SolidColorScrollbarLayerExtraPtr solid_color_scrollbar_layer_extra);

  bool is_surface_layer_extra() const { return tag_ == Tag::kSurfaceLayerExtra; }
  const SurfaceLayerExtraPtr& get_surface_layer_extra() const {
    CHECK(tag_ == Tag::kSurfaceLayerExtra);
    return data_.surface_layer_extra;
  }
  SurfaceLayerExtraPtr& get_surface_layer_extra() {
    CHECK(tag_ == Tag::kSurfaceLayerExtra);
    return data_.surface_layer_extra;
  }
  void set_surface_layer_extra(SurfaceLayerExtraPtr surface_layer_extra);

  bool is_texture_layer_extra() const { return tag_ == Tag::kTextureLayerExtra; }
  const TextureLayerExtraPtr& get_texture_layer_extra() const {
    CHECK(tag_ == Tag::kTextureLayerExtra);
    return data_.texture_layer_extra;
  }
  TextureLayerExtraPtr& get_texture_layer_extra() {
    CHECK(tag_ == Tag::kTextureLayerExtra);
    return data_.texture_layer_extra;
  }
  void set_texture_layer_extra(TextureLayerExtraPtr texture_layer_extra);

  bool is_ui_resource_layer_extra() const { return tag_ == Tag::kUiResourceLayerExtra; }
  const UIResourceLayerExtraPtr& get_ui_resource_layer_extra() const {
    CHECK(tag_ == Tag::kUiResourceLayerExtra);
    return data_.ui_resource_layer_extra;
  }
  UIResourceLayerExtraPtr& get_ui_resource_layer_extra() {
    CHECK(tag_ == Tag::kUiResourceLayerExtra);
    return data_.ui_resource_layer_extra;
  }
  void set_ui_resource_layer_extra(UIResourceLayerExtraPtr ui_resource_layer_extra);

  bool is_tile_display_layer_extra() const { return tag_ == Tag::kTileDisplayLayerExtra; }
  const TileDisplayLayerExtraPtr& get_tile_display_layer_extra() const {
    CHECK(tag_ == Tag::kTileDisplayLayerExtra);
    return data_.tile_display_layer_extra;
  }
  TileDisplayLayerExtraPtr& get_tile_display_layer_extra() {
    CHECK(tag_ == Tag::kTileDisplayLayerExtra);
    return data_.tile_display_layer_extra;
  }
  void set_tile_display_layer_extra(TileDisplayLayerExtraPtr tile_display_layer_extra);

  bool is_view_transition_content_layer_extra() const { return tag_ == Tag::kViewTransitionContentLayerExtra; }
  const ViewTransitionContentLayerExtraPtr& get_view_transition_content_layer_extra() const {
    CHECK(tag_ == Tag::kViewTransitionContentLayerExtra);
    return data_.view_transition_content_layer_extra;
  }
  ViewTransitionContentLayerExtraPtr& get_view_transition_content_layer_extra() {
    CHECK(tag_ == Tag::kViewTransitionContentLayerExtra);
    return data_.view_transition_content_layer_extra;
  }
  void set_view_transition_content_layer_extra(ViewTransitionContentLayerExtraPtr view_transition_content_layer_extra);

  bool is_nine_patch_layer_extra() const { return tag_ == Tag::kNinePatchLayerExtra; }
  const NinePatchLayerExtraPtr& get_nine_patch_layer_extra() const {
    CHECK(tag_ == Tag::kNinePatchLayerExtra);
    return data_.nine_patch_layer_extra;
  }
  NinePatchLayerExtraPtr& get_nine_patch_layer_extra() {
    CHECK(tag_ == Tag::kNinePatchLayerExtra);
    return data_.nine_patch_layer_extra;
  }
  void set_nine_patch_layer_extra(NinePatchLayerExtraPtr nine_patch_layer_extra);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayerExtra::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<LayerExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMirrorLayerExtra)>,
        MirrorLayerExtraPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNinePatchThumbScrollbarLayerExtra)>,
        NinePatchThumbScrollbarLayerExtraPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPaintedScrollbarLayerExtra)>,
        PaintedScrollbarLayerExtraPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSolidColorScrollbarLayerExtra)>,
        SolidColorScrollbarLayerExtraPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSurfaceLayerExtra)>,
        SurfaceLayerExtraPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTextureLayerExtra)>,
        TextureLayerExtraPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUiResourceLayerExtra)>,
        UIResourceLayerExtraPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTileDisplayLayerExtra)>,
        TileDisplayLayerExtraPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kViewTransitionContentLayerExtra)>,
        ViewTransitionContentLayerExtraPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNinePatchLayerExtra)>,
        NinePatchLayerExtraPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    MirrorLayerExtraPtr mirror_layer_extra;
    NinePatchThumbScrollbarLayerExtraPtr nine_patch_thumb_scrollbar_layer_extra;
    PaintedScrollbarLayerExtraPtr painted_scrollbar_layer_extra;
    SolidColorScrollbarLayerExtraPtr solid_color_scrollbar_layer_extra;
    SurfaceLayerExtraPtr surface_layer_extra;
    TextureLayerExtraPtr texture_layer_extra;
    UIResourceLayerExtraPtr ui_resource_layer_extra;
    TileDisplayLayerExtraPtr tile_display_layer_extra;
    ViewTransitionContentLayerExtraPtr view_transition_content_layer_extra;
    NinePatchLayerExtraPtr nine_patch_layer_extra;
  };

  LayerExtra(
      std::in_place_index_t<static_cast<size_t>(Tag::kMirrorLayerExtra)>,
      MirrorLayerExtraPtr value);
  LayerExtra(
      std::in_place_index_t<static_cast<size_t>(Tag::kNinePatchThumbScrollbarLayerExtra)>,
      NinePatchThumbScrollbarLayerExtraPtr value);
  LayerExtra(
      std::in_place_index_t<static_cast<size_t>(Tag::kPaintedScrollbarLayerExtra)>,
      PaintedScrollbarLayerExtraPtr value);
  LayerExtra(
      std::in_place_index_t<static_cast<size_t>(Tag::kSolidColorScrollbarLayerExtra)>,
      SolidColorScrollbarLayerExtraPtr value);
  LayerExtra(
      std::in_place_index_t<static_cast<size_t>(Tag::kSurfaceLayerExtra)>,
      SurfaceLayerExtraPtr value);
  LayerExtra(
      std::in_place_index_t<static_cast<size_t>(Tag::kTextureLayerExtra)>,
      TextureLayerExtraPtr value);
  LayerExtra(
      std::in_place_index_t<static_cast<size_t>(Tag::kUiResourceLayerExtra)>,
      UIResourceLayerExtraPtr value);
  LayerExtra(
      std::in_place_index_t<static_cast<size_t>(Tag::kTileDisplayLayerExtra)>,
      TileDisplayLayerExtraPtr value);
  LayerExtra(
      std::in_place_index_t<static_cast<size_t>(Tag::kViewTransitionContentLayerExtra)>,
      ViewTransitionContentLayerExtraPtr value);
  LayerExtra(
      std::in_place_index_t<static_cast<size_t>(Tag::kNinePatchLayerExtra)>,
      NinePatchLayerExtraPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT RareProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RareProperties, T>::value>;
  using DataView = RarePropertiesDataView;
  using Data_ = internal::RareProperties_Data;

  template <typename... Args>
  static RarePropertiesPtr New(Args&&... args) {
    return RarePropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RarePropertiesPtr From(const U& u) {
    return mojo::TypeConverter<RarePropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RareProperties>::Convert(*this);
  }


  RareProperties();

  RareProperties(
      ::cc::mojom::blink::FilterQuality filter_quality,
      ::cc::mojom::blink::DynamicRangeLimitPtr dynamic_range_limit,
      const ::viz::RegionCaptureBounds& capture_bounds);

RareProperties(const RareProperties&) = delete;
RareProperties& operator=(const RareProperties&) = delete;

  ~RareProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RarePropertiesPtr>
  RarePropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RareProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RareProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RareProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RareProperties::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RareProperties::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RareProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RareProperties_UnserializedMessageContext<
            UserType, RareProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RareProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RareProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RareProperties_UnserializedMessageContext<
            UserType, RareProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RareProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::cc::mojom::blink::FilterQuality filter_quality;
  
  ::cc::mojom::blink::DynamicRangeLimitPtr dynamic_range_limit;
  
  ::viz::RegionCaptureBounds capture_bounds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RareProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RareProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RareProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RareProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT SurfaceLayerExtra {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SurfaceLayerExtra, T>::value>;
  using DataView = SurfaceLayerExtraDataView;
  using Data_ = internal::SurfaceLayerExtra_Data;

  template <typename... Args>
  static SurfaceLayerExtraPtr New(Args&&... args) {
    return SurfaceLayerExtraPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SurfaceLayerExtraPtr From(const U& u) {
    return mojo::TypeConverter<SurfaceLayerExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SurfaceLayerExtra>::Convert(*this);
  }


  SurfaceLayerExtra();

  SurfaceLayerExtra(
      const ::viz::SurfaceRange& surface_range,
      std::optional<uint32_t> deadline_in_frames,
      bool stretch_content_to_fill_bounds,
      bool surface_hit_testable,
      bool has_pointer_events_none,
      bool is_reflection,
      bool will_draw_needs_reset,
      bool override_child_paint_flags);


  ~SurfaceLayerExtra();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SurfaceLayerExtraPtr>
  SurfaceLayerExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SurfaceLayerExtra::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SurfaceLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SurfaceLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SurfaceLayerExtra::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SurfaceLayerExtra::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SurfaceLayerExtra::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SurfaceLayerExtra_UnserializedMessageContext<
            UserType, SurfaceLayerExtra::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SurfaceLayerExtra::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SurfaceLayerExtra::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SurfaceLayerExtra_UnserializedMessageContext<
            UserType, SurfaceLayerExtra::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SurfaceLayerExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::SurfaceRange surface_range;
  
  std::optional<uint32_t> deadline_in_frames;
  
  bool stretch_content_to_fill_bounds;
  
  bool surface_hit_testable;
  
  bool has_pointer_events_none;
  
  bool is_reflection;
  
  bool will_draw_needs_reset;
  
  bool override_child_paint_flags;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SurfaceLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SurfaceLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SurfaceLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SurfaceLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT TextureLayerExtra {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TextureLayerExtra, T>::value>;
  using DataView = TextureLayerExtraDataView;
  using Data_ = internal::TextureLayerExtra_Data;

  template <typename... Args>
  static TextureLayerExtraPtr New(Args&&... args) {
    return TextureLayerExtraPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextureLayerExtraPtr From(const U& u) {
    return mojo::TypeConverter<TextureLayerExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TextureLayerExtra>::Convert(*this);
  }


  TextureLayerExtra();

  TextureLayerExtra(
      bool blend_background_color,
      bool force_texture_to_opaque,
      const ::gfx::PointF& uv_top_left,
      const ::gfx::PointF& uv_bottom_right,
      ::viz::mojom::blink::TransferableResourcePtr transferable_resource);

TextureLayerExtra(const TextureLayerExtra&) = delete;
TextureLayerExtra& operator=(const TextureLayerExtra&) = delete;

  ~TextureLayerExtra();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextureLayerExtraPtr>
  TextureLayerExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TextureLayerExtra::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TextureLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TextureLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TextureLayerExtra::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TextureLayerExtra::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TextureLayerExtra::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TextureLayerExtra_UnserializedMessageContext<
            UserType, TextureLayerExtra::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TextureLayerExtra::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TextureLayerExtra::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TextureLayerExtra_UnserializedMessageContext<
            UserType, TextureLayerExtra::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TextureLayerExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool blend_background_color;
  
  bool force_texture_to_opaque;
  
  ::gfx::PointF uv_top_left;
  
  ::gfx::PointF uv_bottom_right;
  
  ::viz::mojom::blink::TransferableResourcePtr transferable_resource;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TextureLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TextureLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TextureLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TextureLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT UIResourceLayerExtra {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UIResourceLayerExtra, T>::value>;
  using DataView = UIResourceLayerExtraDataView;
  using Data_ = internal::UIResourceLayerExtra_Data;

  template <typename... Args>
  static UIResourceLayerExtraPtr New(Args&&... args) {
    return UIResourceLayerExtraPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UIResourceLayerExtraPtr From(const U& u) {
    return mojo::TypeConverter<UIResourceLayerExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UIResourceLayerExtra>::Convert(*this);
  }


  UIResourceLayerExtra();

  UIResourceLayerExtra(
      ::cc::mojom::blink::UIResourceIdPtr ui_resource_id,
      const ::gfx::Size& image_bounds,
      const ::gfx::PointF& uv_top_left,
      const ::gfx::PointF& uv_bottom_right);

UIResourceLayerExtra(const UIResourceLayerExtra&) = delete;
UIResourceLayerExtra& operator=(const UIResourceLayerExtra&) = delete;

  ~UIResourceLayerExtra();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UIResourceLayerExtraPtr>
  UIResourceLayerExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UIResourceLayerExtra::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UIResourceLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UIResourceLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UIResourceLayerExtra::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UIResourceLayerExtra::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UIResourceLayerExtra::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UIResourceLayerExtra_UnserializedMessageContext<
            UserType, UIResourceLayerExtra::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UIResourceLayerExtra::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UIResourceLayerExtra::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UIResourceLayerExtra_UnserializedMessageContext<
            UserType, UIResourceLayerExtra::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UIResourceLayerExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::cc::mojom::blink::UIResourceIdPtr ui_resource_id;
  
  ::gfx::Size image_bounds;
  
  ::gfx::PointF uv_top_left;
  
  ::gfx::PointF uv_bottom_right;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UIResourceLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UIResourceLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UIResourceLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UIResourceLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT TileDisplayLayerExtra {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TileDisplayLayerExtra, T>::value>;
  using DataView = TileDisplayLayerExtraDataView;
  using Data_ = internal::TileDisplayLayerExtra_Data;

  template <typename... Args>
  static TileDisplayLayerExtraPtr New(Args&&... args) {
    return TileDisplayLayerExtraPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TileDisplayLayerExtraPtr From(const U& u) {
    return mojo::TypeConverter<TileDisplayLayerExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TileDisplayLayerExtra>::Convert(*this);
  }


  TileDisplayLayerExtra();

  TileDisplayLayerExtra(
      const std::optional<::SkColor4f>& solid_color,
      bool is_backdrop_filter_mask,
      bool is_directly_composited_image,
      bool nearest_neighbor,
      ::gfx::ContentColorUsage content_color_usage);


  ~TileDisplayLayerExtra();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TileDisplayLayerExtraPtr>
  TileDisplayLayerExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TileDisplayLayerExtra::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TileDisplayLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TileDisplayLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TileDisplayLayerExtra::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TileDisplayLayerExtra::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TileDisplayLayerExtra::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TileDisplayLayerExtra_UnserializedMessageContext<
            UserType, TileDisplayLayerExtra::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TileDisplayLayerExtra::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TileDisplayLayerExtra::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TileDisplayLayerExtra_UnserializedMessageContext<
            UserType, TileDisplayLayerExtra::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TileDisplayLayerExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::SkColor4f> solid_color;
  
  bool is_backdrop_filter_mask;
  
  bool is_directly_composited_image;
  
  bool nearest_neighbor;
  
  ::gfx::ContentColorUsage content_color_usage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TileDisplayLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TileDisplayLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TileDisplayLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TileDisplayLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ScrollbarLayerBaseExtra {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollbarLayerBaseExtra, T>::value>;
  using DataView = ScrollbarLayerBaseExtraDataView;
  using Data_ = internal::ScrollbarLayerBaseExtra_Data;

  template <typename... Args>
  static ScrollbarLayerBaseExtraPtr New(Args&&... args) {
    return ScrollbarLayerBaseExtraPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollbarLayerBaseExtraPtr From(const U& u) {
    return mojo::TypeConverter<ScrollbarLayerBaseExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollbarLayerBaseExtra>::Convert(*this);
  }


  ScrollbarLayerBaseExtra();

  ScrollbarLayerBaseExtra(
      ::cc::mojom::blink::ElementIdPtr scroll_element_id,
      bool is_overlay_scrollbar,
      bool is_web_test,
      float thumb_thickness_scale_factor,
      float current_pos,
      float clip_layer_length,
      float scroll_layer_length,
      bool is_horizontal_orientation,
      bool is_left_side_vertical_scrollbar,
      float vertical_adjust,
      bool has_find_in_page_tickmarks);

ScrollbarLayerBaseExtra(const ScrollbarLayerBaseExtra&) = delete;
ScrollbarLayerBaseExtra& operator=(const ScrollbarLayerBaseExtra&) = delete;

  ~ScrollbarLayerBaseExtra();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollbarLayerBaseExtraPtr>
  ScrollbarLayerBaseExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollbarLayerBaseExtra::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollbarLayerBaseExtra::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollbarLayerBaseExtra::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollbarLayerBaseExtra::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollbarLayerBaseExtra::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollbarLayerBaseExtra::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollbarLayerBaseExtra_UnserializedMessageContext<
            UserType, ScrollbarLayerBaseExtra::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollbarLayerBaseExtra::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollbarLayerBaseExtra::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollbarLayerBaseExtra_UnserializedMessageContext<
            UserType, ScrollbarLayerBaseExtra::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollbarLayerBaseExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::cc::mojom::blink::ElementIdPtr scroll_element_id;
  
  bool is_overlay_scrollbar;
  
  bool is_web_test;
  
  float thumb_thickness_scale_factor;
  
  float current_pos;
  
  float clip_layer_length;
  
  float scroll_layer_length;
  
  bool is_horizontal_orientation;
  
  bool is_left_side_vertical_scrollbar;
  
  float vertical_adjust;
  
  bool has_find_in_page_tickmarks;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollbarLayerBaseExtra::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollbarLayerBaseExtra::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollbarLayerBaseExtra::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollbarLayerBaseExtra::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT NinePatchThumbScrollbarLayerExtra {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NinePatchThumbScrollbarLayerExtra, T>::value>;
  using DataView = NinePatchThumbScrollbarLayerExtraDataView;
  using Data_ = internal::NinePatchThumbScrollbarLayerExtra_Data;

  template <typename... Args>
  static NinePatchThumbScrollbarLayerExtraPtr New(Args&&... args) {
    return NinePatchThumbScrollbarLayerExtraPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NinePatchThumbScrollbarLayerExtraPtr From(const U& u) {
    return mojo::TypeConverter<NinePatchThumbScrollbarLayerExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NinePatchThumbScrollbarLayerExtra>::Convert(*this);
  }


  NinePatchThumbScrollbarLayerExtra();

  NinePatchThumbScrollbarLayerExtra(
      ScrollbarLayerBaseExtraPtr scrollbar_base_extra,
      int32_t thumb_thickness,
      int32_t thumb_length,
      int32_t track_start,
      int32_t track_length,
      const ::gfx::Size& image_bounds,
      const ::gfx::Rect& aperture,
      ::cc::mojom::blink::UIResourceIdPtr thumb_ui_resource_id,
      ::cc::mojom::blink::UIResourceIdPtr track_and_buttons_ui_resource_id);

NinePatchThumbScrollbarLayerExtra(const NinePatchThumbScrollbarLayerExtra&) = delete;
NinePatchThumbScrollbarLayerExtra& operator=(const NinePatchThumbScrollbarLayerExtra&) = delete;

  ~NinePatchThumbScrollbarLayerExtra();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NinePatchThumbScrollbarLayerExtraPtr>
  NinePatchThumbScrollbarLayerExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NinePatchThumbScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NinePatchThumbScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NinePatchThumbScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NinePatchThumbScrollbarLayerExtra::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NinePatchThumbScrollbarLayerExtra::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NinePatchThumbScrollbarLayerExtra::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NinePatchThumbScrollbarLayerExtra_UnserializedMessageContext<
            UserType, NinePatchThumbScrollbarLayerExtra::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NinePatchThumbScrollbarLayerExtra::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NinePatchThumbScrollbarLayerExtra::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NinePatchThumbScrollbarLayerExtra_UnserializedMessageContext<
            UserType, NinePatchThumbScrollbarLayerExtra::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NinePatchThumbScrollbarLayerExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ScrollbarLayerBaseExtraPtr scrollbar_base_extra;
  
  int32_t thumb_thickness;
  
  int32_t thumb_length;
  
  int32_t track_start;
  
  int32_t track_length;
  
  ::gfx::Size image_bounds;
  
  ::gfx::Rect aperture;
  
  ::cc::mojom::blink::UIResourceIdPtr thumb_ui_resource_id;
  
  ::cc::mojom::blink::UIResourceIdPtr track_and_buttons_ui_resource_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NinePatchThumbScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NinePatchThumbScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NinePatchThumbScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NinePatchThumbScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT PaintedScrollbarLayerExtra {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaintedScrollbarLayerExtra, T>::value>;
  using DataView = PaintedScrollbarLayerExtraDataView;
  using Data_ = internal::PaintedScrollbarLayerExtra_Data;

  template <typename... Args>
  static PaintedScrollbarLayerExtraPtr New(Args&&... args) {
    return PaintedScrollbarLayerExtraPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaintedScrollbarLayerExtraPtr From(const U& u) {
    return mojo::TypeConverter<PaintedScrollbarLayerExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaintedScrollbarLayerExtra>::Convert(*this);
  }


  PaintedScrollbarLayerExtra();

  PaintedScrollbarLayerExtra(
      ScrollbarLayerBaseExtraPtr scrollbar_base_extra,
      float internal_contents_scale,
      const ::gfx::Size& internal_content_bounds,
      bool jump_on_track_click,
      bool supports_drag_snap_back,
      int32_t thumb_thickness,
      int32_t thumb_length,
      const ::gfx::Rect& back_button_rect,
      const ::gfx::Rect& forward_button_rect,
      const ::gfx::Rect& track_rect,
      const std::optional<::SkColor4f>& thumb_color,
      bool uses_nine_patch_track_and_buttons,
      const ::gfx::Size& track_and_buttons_image_bounds,
      const ::gfx::Rect& track_and_buttons_aperture,
      float painted_opacity,
      ::cc::mojom::blink::UIResourceIdPtr track_and_buttons_ui_resource_id,
      ::cc::mojom::blink::UIResourceIdPtr thumb_ui_resource_id);

PaintedScrollbarLayerExtra(const PaintedScrollbarLayerExtra&) = delete;
PaintedScrollbarLayerExtra& operator=(const PaintedScrollbarLayerExtra&) = delete;

  ~PaintedScrollbarLayerExtra();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaintedScrollbarLayerExtraPtr>
  PaintedScrollbarLayerExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaintedScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaintedScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaintedScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaintedScrollbarLayerExtra::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaintedScrollbarLayerExtra::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaintedScrollbarLayerExtra::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaintedScrollbarLayerExtra_UnserializedMessageContext<
            UserType, PaintedScrollbarLayerExtra::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaintedScrollbarLayerExtra::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaintedScrollbarLayerExtra::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaintedScrollbarLayerExtra_UnserializedMessageContext<
            UserType, PaintedScrollbarLayerExtra::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaintedScrollbarLayerExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ScrollbarLayerBaseExtraPtr scrollbar_base_extra;
  
  float internal_contents_scale;
  
  ::gfx::Size internal_content_bounds;
  
  bool jump_on_track_click;
  
  bool supports_drag_snap_back;
  
  int32_t thumb_thickness;
  
  int32_t thumb_length;
  
  ::gfx::Rect back_button_rect;
  
  ::gfx::Rect forward_button_rect;
  
  ::gfx::Rect track_rect;
  
  std::optional<::SkColor4f> thumb_color;
  
  bool uses_nine_patch_track_and_buttons;
  
  ::gfx::Size track_and_buttons_image_bounds;
  
  ::gfx::Rect track_and_buttons_aperture;
  
  float painted_opacity;
  
  ::cc::mojom::blink::UIResourceIdPtr track_and_buttons_ui_resource_id;
  
  ::cc::mojom::blink::UIResourceIdPtr thumb_ui_resource_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaintedScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaintedScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaintedScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaintedScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SolidColorScrollbarLayerExtra {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SolidColorScrollbarLayerExtra, T>::value>;
  using DataView = SolidColorScrollbarLayerExtraDataView;
  using Data_ = internal::SolidColorScrollbarLayerExtra_Data;

  template <typename... Args>
  static SolidColorScrollbarLayerExtraPtr New(Args&&... args) {
    return SolidColorScrollbarLayerExtraPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SolidColorScrollbarLayerExtraPtr From(const U& u) {
    return mojo::TypeConverter<SolidColorScrollbarLayerExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SolidColorScrollbarLayerExtra>::Convert(*this);
  }


  SolidColorScrollbarLayerExtra();

  SolidColorScrollbarLayerExtra(
      ScrollbarLayerBaseExtraPtr scrollbar_base_extra,
      int32_t thumb_thickness,
      int32_t track_start,
      const ::SkColor4f& color);

SolidColorScrollbarLayerExtra(const SolidColorScrollbarLayerExtra&) = delete;
SolidColorScrollbarLayerExtra& operator=(const SolidColorScrollbarLayerExtra&) = delete;

  ~SolidColorScrollbarLayerExtra();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SolidColorScrollbarLayerExtraPtr>
  SolidColorScrollbarLayerExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SolidColorScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SolidColorScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SolidColorScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SolidColorScrollbarLayerExtra::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SolidColorScrollbarLayerExtra::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SolidColorScrollbarLayerExtra::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SolidColorScrollbarLayerExtra_UnserializedMessageContext<
            UserType, SolidColorScrollbarLayerExtra::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SolidColorScrollbarLayerExtra::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SolidColorScrollbarLayerExtra::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SolidColorScrollbarLayerExtra_UnserializedMessageContext<
            UserType, SolidColorScrollbarLayerExtra::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SolidColorScrollbarLayerExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ScrollbarLayerBaseExtraPtr scrollbar_base_extra;
  
  int32_t thumb_thickness;
  
  int32_t track_start;
  
  ::SkColor4f color;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SolidColorScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SolidColorScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SolidColorScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SolidColorScrollbarLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ViewTransitionContentLayerExtra {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewTransitionContentLayerExtra, T>::value>;
  using DataView = ViewTransitionContentLayerExtraDataView;
  using Data_ = internal::ViewTransitionContentLayerExtra_Data;

  template <typename... Args>
  static ViewTransitionContentLayerExtraPtr New(Args&&... args) {
    return ViewTransitionContentLayerExtraPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewTransitionContentLayerExtraPtr From(const U& u) {
    return mojo::TypeConverter<ViewTransitionContentLayerExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewTransitionContentLayerExtra>::Convert(*this);
  }


  ViewTransitionContentLayerExtra();

  ViewTransitionContentLayerExtra(
      ::viz::mojom::blink::ViewTransitionElementResourceIdPtr resource_id,
      bool is_live_content_layer,
      const ::gfx::RectF& max_extents_rect);

ViewTransitionContentLayerExtra(const ViewTransitionContentLayerExtra&) = delete;
ViewTransitionContentLayerExtra& operator=(const ViewTransitionContentLayerExtra&) = delete;

  ~ViewTransitionContentLayerExtra();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewTransitionContentLayerExtraPtr>
  ViewTransitionContentLayerExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewTransitionContentLayerExtra::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewTransitionContentLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewTransitionContentLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionContentLayerExtra::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionContentLayerExtra::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewTransitionContentLayerExtra::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewTransitionContentLayerExtra_UnserializedMessageContext<
            UserType, ViewTransitionContentLayerExtra::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewTransitionContentLayerExtra::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewTransitionContentLayerExtra::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewTransitionContentLayerExtra_UnserializedMessageContext<
            UserType, ViewTransitionContentLayerExtra::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewTransitionContentLayerExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::mojom::blink::ViewTransitionElementResourceIdPtr resource_id;
  
  bool is_live_content_layer;
  
  ::gfx::RectF max_extents_rect;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewTransitionContentLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewTransitionContentLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewTransitionContentLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewTransitionContentLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT NinePatchLayerExtra {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NinePatchLayerExtra, T>::value>;
  using DataView = NinePatchLayerExtraDataView;
  using Data_ = internal::NinePatchLayerExtra_Data;

  template <typename... Args>
  static NinePatchLayerExtraPtr New(Args&&... args) {
    return NinePatchLayerExtraPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NinePatchLayerExtraPtr From(const U& u) {
    return mojo::TypeConverter<NinePatchLayerExtraPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NinePatchLayerExtra>::Convert(*this);
  }


  NinePatchLayerExtra();

  NinePatchLayerExtra(
      const ::gfx::Rect& image_aperture,
      const ::gfx::Rect& border,
      const ::gfx::Rect& layer_occlusion,
      bool fill_center,
      ::cc::mojom::blink::UIResourceIdPtr ui_resource_id,
      const ::gfx::Size& image_bounds,
      const ::gfx::PointF& uv_top_left,
      const ::gfx::PointF& uv_bottom_right);

NinePatchLayerExtra(const NinePatchLayerExtra&) = delete;
NinePatchLayerExtra& operator=(const NinePatchLayerExtra&) = delete;

  ~NinePatchLayerExtra();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NinePatchLayerExtraPtr>
  NinePatchLayerExtraPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NinePatchLayerExtra::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NinePatchLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NinePatchLayerExtra::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NinePatchLayerExtra::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NinePatchLayerExtra::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NinePatchLayerExtra::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NinePatchLayerExtra_UnserializedMessageContext<
            UserType, NinePatchLayerExtra::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NinePatchLayerExtra::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NinePatchLayerExtra::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NinePatchLayerExtra_UnserializedMessageContext<
            UserType, NinePatchLayerExtra::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NinePatchLayerExtra::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Rect image_aperture;
  
  ::gfx::Rect border;
  
  ::gfx::Rect layer_occlusion;
  
  bool fill_center;
  
  ::cc::mojom::blink::UIResourceIdPtr ui_resource_id;
  
  ::gfx::Size image_bounds;
  
  ::gfx::PointF uv_top_left;
  
  ::gfx::PointF uv_bottom_right;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NinePatchLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NinePatchLayerExtra::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NinePatchLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NinePatchLayerExtra::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT Layer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Layer, T>::value>;
  using DataView = LayerDataView;
  using Data_ = internal::Layer_Data;

  template <typename... Args>
  static LayerPtr New(Args&&... args) {
    return LayerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayerPtr From(const U& u) {
    return mojo::TypeConverter<LayerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Layer>::Convert(*this);
  }


  Layer();

  Layer(
      int64_t id,
      ::cc::mojom::blink::LayerType type,
      const ::gfx::Size& bounds,
      bool contents_opaque,
      bool contents_opaque_for_text,
      bool is_drawable,
      bool layer_property_changed_not_from_property_trees,
      bool layer_property_changed_from_property_trees,
      ::cc::mojom::blink::HitTestOpaqueness hit_test_opaqueness,
      const ::SkColor4f& background_color,
      const ::SkColor4f& safe_opaque_background_color,
      ::cc::mojom::blink::ElementIdPtr element_id,
      const ::gfx::Rect& update_rect,
      const ::gfx::Vector2dF& offset_to_transform_parent,
      int32_t transform_tree_index,
      int32_t clip_tree_index,
      int32_t effect_tree_index,
      int32_t scroll_tree_index,
      bool should_check_backface_visibility,
      RarePropertiesPtr rare_properties,
      LayerExtraPtr layer_extra);

Layer(const Layer&) = delete;
Layer& operator=(const Layer&) = delete;

  ~Layer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayerPtr>
  LayerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Layer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Layer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Layer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Layer::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Layer::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Layer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Layer_UnserializedMessageContext<
            UserType, Layer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Layer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Layer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Layer_UnserializedMessageContext<
            UserType, Layer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Layer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  ::cc::mojom::blink::LayerType type;
  
  ::gfx::Size bounds;
  
  bool contents_opaque;
  
  bool contents_opaque_for_text;
  
  bool is_drawable;
  
  bool layer_property_changed_not_from_property_trees;
  
  bool layer_property_changed_from_property_trees;
  
  ::cc::mojom::blink::HitTestOpaqueness hit_test_opaqueness;
  
  ::SkColor4f background_color;
  
  ::SkColor4f safe_opaque_background_color;
  
  ::cc::mojom::blink::ElementIdPtr element_id;
  
  ::gfx::Rect update_rect;
  
  ::gfx::Vector2dF offset_to_transform_parent;
  
  int32_t transform_tree_index;
  
  int32_t clip_tree_index;
  
  int32_t effect_tree_index;
  
  int32_t scroll_tree_index;
  
  bool should_check_backface_visibility;
  
  RarePropertiesPtr rare_properties;
  
  LayerExtraPtr layer_extra;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Layer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Layer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Layer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Layer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT AnchorPositionScrollData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorPositionScrollData, T>::value>;
  using DataView = AnchorPositionScrollDataDataView;
  using Data_ = internal::AnchorPositionScrollData_Data;

  template <typename... Args>
  static AnchorPositionScrollDataPtr New(Args&&... args) {
    return AnchorPositionScrollDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorPositionScrollDataPtr From(const U& u) {
    return mojo::TypeConverter<AnchorPositionScrollDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorPositionScrollData>::Convert(*this);
  }


  AnchorPositionScrollData();

  AnchorPositionScrollData(
      ::blink::Vector<::cc::mojom::blink::ElementIdPtr> adjustment_container_ids,
      const ::gfx::Vector2d& accumulated_scroll_origin,
      bool needs_scroll_adjustment_in_x,
      bool needs_scroll_adjustment_in_y);

AnchorPositionScrollData(const AnchorPositionScrollData&) = delete;
AnchorPositionScrollData& operator=(const AnchorPositionScrollData&) = delete;

  ~AnchorPositionScrollData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorPositionScrollDataPtr>
  AnchorPositionScrollDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorPositionScrollData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorPositionScrollData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorPositionScrollData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorPositionScrollData_UnserializedMessageContext<
            UserType, AnchorPositionScrollData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorPositionScrollData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorPositionScrollData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorPositionScrollData_UnserializedMessageContext<
            UserType, AnchorPositionScrollData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorPositionScrollData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::cc::mojom::blink::ElementIdPtr> adjustment_container_ids;
  
  ::gfx::Vector2d accumulated_scroll_origin;
  
  bool needs_scroll_adjustment_in_x;
  
  bool needs_scroll_adjustment_in_y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT StickyPositionNodeData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StickyPositionNodeData, T>::value>;
  using DataView = StickyPositionNodeDataDataView;
  using Data_ = internal::StickyPositionNodeData_Data;

  template <typename... Args>
  static StickyPositionNodeDataPtr New(Args&&... args) {
    return StickyPositionNodeDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StickyPositionNodeDataPtr From(const U& u) {
    return mojo::TypeConverter<StickyPositionNodeDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StickyPositionNodeData>::Convert(*this);
  }


  StickyPositionNodeData();

  StickyPositionNodeData(
      int32_t scroll_ancestor,
      bool is_anchored_left,
      bool is_anchored_right,
      bool is_anchored_top,
      bool is_anchored_bottom,
      float left_offset,
      float right_offset,
      float top_offset,
      float bottom_offset,
      const ::gfx::RectF& constraint_box_rect,
      const ::gfx::RectF& scroll_container_relative_sticky_box_rect,
      const ::gfx::RectF& scroll_container_relative_containing_block_rect,
      const ::gfx::Vector2dF& pixel_snap_offset,
      int32_t nearest_node_shifting_sticky_box,
      int32_t nearest_node_shifting_containing_block,
      const ::gfx::Vector2dF& total_sticky_box_sticky_offset,
      const ::gfx::Vector2dF& total_containing_block_sticky_offset);


  ~StickyPositionNodeData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StickyPositionNodeDataPtr>
  StickyPositionNodeDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StickyPositionNodeData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StickyPositionNodeData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StickyPositionNodeData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StickyPositionNodeData_UnserializedMessageContext<
            UserType, StickyPositionNodeData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StickyPositionNodeData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StickyPositionNodeData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StickyPositionNodeData_UnserializedMessageContext<
            UserType, StickyPositionNodeData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StickyPositionNodeData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t scroll_ancestor;
  
  bool is_anchored_left;
  
  bool is_anchored_right;
  
  bool is_anchored_top;
  
  bool is_anchored_bottom;
  
  float left_offset;
  
  float right_offset;
  
  float top_offset;
  
  float bottom_offset;
  
  ::gfx::RectF constraint_box_rect;
  
  ::gfx::RectF scroll_container_relative_sticky_box_rect;
  
  ::gfx::RectF scroll_container_relative_containing_block_rect;
  
  ::gfx::Vector2dF pixel_snap_offset;
  
  int32_t nearest_node_shifting_sticky_box;
  
  int32_t nearest_node_shifting_containing_block;
  
  ::gfx::Vector2dF total_sticky_box_sticky_offset;
  
  ::gfx::Vector2dF total_containing_block_sticky_offset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT TransformTreeUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TransformTreeUpdate, T>::value>;
  using DataView = TransformTreeUpdateDataView;
  using Data_ = internal::TransformTreeUpdate_Data;

  template <typename... Args>
  static TransformTreeUpdatePtr New(Args&&... args) {
    return TransformTreeUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransformTreeUpdatePtr From(const U& u) {
    return mojo::TypeConverter<TransformTreeUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransformTreeUpdate>::Convert(*this);
  }


  TransformTreeUpdate();

  TransformTreeUpdate(
      float page_scale_factor,
      float device_scale_factor,
      float device_transform_scale_factor,
      ::blink::Vector<int32_t> nodes_affected_by_outer_viewport_bounds_delta,
      ::blink::Vector<int32_t> nodes_affected_by_safe_area_bottom,
      ::blink::Vector<StickyPositionNodeDataPtr> sticky_position_data,
      ::blink::Vector<AnchorPositionScrollDataPtr> anchor_position_scroll_data);

TransformTreeUpdate(const TransformTreeUpdate&) = delete;
TransformTreeUpdate& operator=(const TransformTreeUpdate&) = delete;

  ~TransformTreeUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransformTreeUpdatePtr>
  TransformTreeUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TransformTreeUpdate::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TransformTreeUpdate::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransformTreeUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TransformTreeUpdate_UnserializedMessageContext<
            UserType, TransformTreeUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TransformTreeUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TransformTreeUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TransformTreeUpdate_UnserializedMessageContext<
            UserType, TransformTreeUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TransformTreeUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float page_scale_factor;
  
  float device_scale_factor;
  
  float device_transform_scale_factor;
  
  ::blink::Vector<int32_t> nodes_affected_by_outer_viewport_bounds_delta;
  
  ::blink::Vector<int32_t> nodes_affected_by_safe_area_bottom;
  
  ::blink::Vector<StickyPositionNodeDataPtr> sticky_position_data;
  
  ::blink::Vector<AnchorPositionScrollDataPtr> anchor_position_scroll_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT TransformNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TransformNode, T>::value>;
  using DataView = TransformNodeDataView;
  using Data_ = internal::TransformNode_Data;

  template <typename... Args>
  static TransformNodePtr New(Args&&... args) {
    return TransformNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransformNodePtr From(const U& u) {
    return mojo::TypeConverter<TransformNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransformNode>::Convert(*this);
  }


  TransformNode();

  TransformNode(
      int32_t id,
      int32_t parent_id,
      int32_t parent_frame_id,
      ::cc::mojom::blink::ElementIdPtr element_id,
      const ::gfx::Transform& local,
      const ::gfx::Point3F& origin,
      const ::gfx::Vector2dF& post_translation,
      const ::gfx::Transform& to_parent,
      const ::gfx::PointF& scroll_offset,
      const ::gfx::Vector2dF& snap_amount,
      std::optional<uint32_t> sticky_position_constraint_id,
      std::optional<uint32_t> anchor_position_scroll_data_id,
      int32_t sorting_context_id,
      bool has_potential_animation,
      bool is_currently_animating,
      bool flattens_inherited_transform,
      bool scrolls,
      bool should_undo_overscroll,
      bool should_be_snapped,
      bool moved_by_outer_viewport_bounds_delta_y,
      bool in_subtree_of_page_scale_layer,
      bool transform_changed,
      bool delegates_to_parent_for_backface,
      bool will_change_transform,
      float maximum_animation_scale,
      bool node_and_ancestors_are_animated_or_invertible,
      bool is_invertible,
      bool ancestors_are_invertible,
      bool node_and_ancestors_are_flat,
      bool node_or_ancestors_will_change_transform,
      ::cc::mojom::blink::ElementIdPtr visible_frame_element_id,
      uint64_t damage_reasons_bit_mask,
      bool moved_by_safe_area_bottom);

TransformNode(const TransformNode&) = delete;
TransformNode& operator=(const TransformNode&) = delete;

  ~TransformNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransformNodePtr>
  TransformNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TransformNode::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TransformNode::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransformNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TransformNode_UnserializedMessageContext<
            UserType, TransformNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TransformNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TransformNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TransformNode_UnserializedMessageContext<
            UserType, TransformNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TransformNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  int32_t parent_id;
  
  int32_t parent_frame_id;
  
  ::cc::mojom::blink::ElementIdPtr element_id;
  
  ::gfx::Transform local;
  
  ::gfx::Point3F origin;
  
  ::gfx::Vector2dF post_translation;
  
  ::gfx::Transform to_parent;
  
  ::gfx::PointF scroll_offset;
  
  ::gfx::Vector2dF snap_amount;
  
  std::optional<uint32_t> sticky_position_constraint_id;
  
  std::optional<uint32_t> anchor_position_scroll_data_id;
  
  int32_t sorting_context_id;
  
  bool has_potential_animation;
  
  bool is_currently_animating;
  
  bool flattens_inherited_transform;
  
  bool scrolls;
  
  bool should_undo_overscroll;
  
  bool should_be_snapped;
  
  bool moved_by_outer_viewport_bounds_delta_y;
  
  bool in_subtree_of_page_scale_layer;
  
  bool transform_changed;
  
  bool delegates_to_parent_for_backface;
  
  bool will_change_transform;
  
  float maximum_animation_scale;
  
  bool node_and_ancestors_are_animated_or_invertible;
  
  bool is_invertible;
  
  bool ancestors_are_invertible;
  
  bool node_and_ancestors_are_flat;
  
  bool node_or_ancestors_will_change_transform;
  
  ::cc::mojom::blink::ElementIdPtr visible_frame_element_id;
  
  uint64_t damage_reasons_bit_mask;
  
  bool moved_by_safe_area_bottom;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ClipNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClipNode, T>::value>;
  using DataView = ClipNodeDataView;
  using Data_ = internal::ClipNode_Data;

  template <typename... Args>
  static ClipNodePtr New(Args&&... args) {
    return ClipNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClipNodePtr From(const U& u) {
    return mojo::TypeConverter<ClipNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClipNode>::Convert(*this);
  }


  ClipNode();

  ClipNode(
      int32_t id,
      int32_t parent_id,
      int32_t transform_id,
      const ::gfx::RectF& clip,
      int32_t pixel_moving_filter_id);


  ~ClipNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClipNodePtr>
  ClipNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClipNode::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClipNode::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClipNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClipNode_UnserializedMessageContext<
            UserType, ClipNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClipNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClipNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClipNode_UnserializedMessageContext<
            UserType, ClipNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClipNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  int32_t parent_id;
  
  int32_t transform_id;
  
  ::gfx::RectF clip;
  
  int32_t pixel_moving_filter_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT EffectNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EffectNode, T>::value>;
  using DataView = EffectNodeDataView;
  using Data_ = internal::EffectNode_Data;

  template <typename... Args>
  static EffectNodePtr New(Args&&... args) {
    return EffectNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EffectNodePtr From(const U& u) {
    return mojo::TypeConverter<EffectNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EffectNode>::Convert(*this);
  }


  EffectNode();

  EffectNode(
      int32_t id,
      int32_t parent_id,
      int32_t transform_id,
      int32_t clip_id,
      ::cc::mojom::blink::ElementIdPtr element_id,
      float opacity,
      ::cc::mojom::blink::RenderSurfaceReason render_surface_reason,
      const ::gfx::Vector2dF& surface_contents_scale,
      const ::viz::SubtreeCaptureId& subtree_capture_id,
      const ::gfx::Size& subtree_size,
      uint32_t blend_mode,
      int32_t target_id,
      int32_t view_transition_target_id,
      int32_t closest_ancestor_with_cached_render_surface_id,
      int32_t closest_ancestor_with_copy_request_id,
      int32_t closest_ancestor_being_captured_id,
      int32_t closest_ancestor_with_shared_element_id,
      ::viz::mojom::blink::ViewTransitionElementResourceIdPtr view_transition_element_resource_id,
      ::viz::mojom::blink::FilterOperationsPtr filters,
      ::viz::mojom::blink::FilterOperationsPtr backdrop_filters,
      const std::optional<::SkPath>& backdrop_filter_bounds,
      float backdrop_filter_quality,
      ::cc::mojom::blink::ElementIdPtr backdrop_mask_element_id,
      ::gfx::mojom::blink::MaskFilterInfoPtr mask_filter_info,
      bool cache_render_surface,
      bool double_sided,
      bool trilinear_filtering,
      bool subtree_hidden,
      bool has_potential_filter_animation,
      bool has_potential_backdrop_filter_animation,
      bool has_potential_opacity_animation,
      bool subtree_has_copy_request,
      bool is_fast_rounded_corner,
      bool may_have_backdrop_effect,
      bool needs_effect_for_2d_scale_transform,
      ::blink::Vector<::viz::mojom::blink::CopyOutputRequestPtr> copy_output_requests);

EffectNode(const EffectNode&) = delete;
EffectNode& operator=(const EffectNode&) = delete;

  ~EffectNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EffectNodePtr>
  EffectNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EffectNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EffectNode_UnserializedMessageContext<
            UserType, EffectNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EffectNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EffectNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EffectNode_UnserializedMessageContext<
            UserType, EffectNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EffectNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  int32_t parent_id;
  
  int32_t transform_id;
  
  int32_t clip_id;
  
  ::cc::mojom::blink::ElementIdPtr element_id;
  
  float opacity;
  
  ::cc::mojom::blink::RenderSurfaceReason render_surface_reason;
  
  ::gfx::Vector2dF surface_contents_scale;
  
  ::viz::SubtreeCaptureId subtree_capture_id;
  
  ::gfx::Size subtree_size;
  
  uint32_t blend_mode;
  
  int32_t target_id;
  
  int32_t view_transition_target_id;
  
  int32_t closest_ancestor_with_cached_render_surface_id;
  
  int32_t closest_ancestor_with_copy_request_id;
  
  int32_t closest_ancestor_being_captured_id;
  
  int32_t closest_ancestor_with_shared_element_id;
  
  ::viz::mojom::blink::ViewTransitionElementResourceIdPtr view_transition_element_resource_id;
  
  ::viz::mojom::blink::FilterOperationsPtr filters;
  
  ::viz::mojom::blink::FilterOperationsPtr backdrop_filters;
  
  std::optional<::SkPath> backdrop_filter_bounds;
  
  float backdrop_filter_quality;
  
  ::cc::mojom::blink::ElementIdPtr backdrop_mask_element_id;
  
  ::gfx::mojom::blink::MaskFilterInfoPtr mask_filter_info;
  
  bool cache_render_surface;
  
  bool double_sided;
  
  bool trilinear_filtering;
  
  bool subtree_hidden;
  
  bool has_potential_filter_animation;
  
  bool has_potential_backdrop_filter_animation;
  
  bool has_potential_opacity_animation;
  
  bool subtree_has_copy_request;
  
  bool is_fast_rounded_corner;
  
  bool may_have_backdrop_effect;
  
  bool needs_effect_for_2d_scale_transform;
  
  ::blink::Vector<::viz::mojom::blink::CopyOutputRequestPtr> copy_output_requests;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ScrollTreeUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollTreeUpdate, T>::value>;
  using DataView = ScrollTreeUpdateDataView;
  using Data_ = internal::ScrollTreeUpdate_Data;

  template <typename... Args>
  static ScrollTreeUpdatePtr New(Args&&... args) {
    return ScrollTreeUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollTreeUpdatePtr From(const U& u) {
    return mojo::TypeConverter<ScrollTreeUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollTreeUpdate>::Convert(*this);
  }


  ScrollTreeUpdate();

  ScrollTreeUpdate(
      ::blink::HashMap<::cc::mojom::blink::ElementIdPtr, ::cc::mojom::blink::SyncedScrollOffsetPtr> synced_scroll_offsets,
      ::blink::HashMap<::cc::mojom::blink::ElementIdPtr, ::gfx::Rect> scrolling_contents_cull_rects,
      ::blink::HashMap<::cc::mojom::blink::ElementIdPtr, ::gfx::Vector2dF> elastic_overscroll);

ScrollTreeUpdate(const ScrollTreeUpdate&) = delete;
ScrollTreeUpdate& operator=(const ScrollTreeUpdate&) = delete;

  ~ScrollTreeUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollTreeUpdatePtr>
  ScrollTreeUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollTreeUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollTreeUpdate::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollTreeUpdate::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollTreeUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollTreeUpdate_UnserializedMessageContext<
            UserType, ScrollTreeUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollTreeUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollTreeUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollTreeUpdate_UnserializedMessageContext<
            UserType, ScrollTreeUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollTreeUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::HashMap<::cc::mojom::blink::ElementIdPtr, ::cc::mojom::blink::SyncedScrollOffsetPtr> synced_scroll_offsets;
  
  ::blink::HashMap<::cc::mojom::blink::ElementIdPtr, ::gfx::Rect> scrolling_contents_cull_rects;
  
  ::blink::HashMap<::cc::mojom::blink::ElementIdPtr, ::gfx::Vector2dF> elastic_overscroll;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ScrollNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollNode, T>::value>;
  using DataView = ScrollNodeDataView;
  using Data_ = internal::ScrollNode_Data;

  template <typename... Args>
  static ScrollNodePtr New(Args&&... args) {
    return ScrollNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollNodePtr From(const U& u) {
    return mojo::TypeConverter<ScrollNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollNode>::Convert(*this);
  }


  ScrollNode();

  ScrollNode(
      int32_t id,
      int32_t parent_id,
      int32_t transform_id,
      const ::gfx::Size& container_bounds,
      const ::gfx::Size& bounds,
      ::cc::mojom::blink::ElementIdPtr element_id,
      bool max_scroll_offset_affected_by_page_scale,
      bool scrolls_inner_viewport,
      bool scrolls_outer_viewport,
      bool prevent_viewport_scrolling_from_inner,
      bool user_scrollable_horizontal,
      bool user_scrollable_vertical,
      bool is_composited);

ScrollNode(const ScrollNode&) = delete;
ScrollNode& operator=(const ScrollNode&) = delete;

  ~ScrollNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollNodePtr>
  ScrollNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollNode::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollNode::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollNode_UnserializedMessageContext<
            UserType, ScrollNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollNode_UnserializedMessageContext<
            UserType, ScrollNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  int32_t parent_id;
  
  int32_t transform_id;
  
  ::gfx::Size container_bounds;
  
  ::gfx::Size bounds;
  
  ::cc::mojom::blink::ElementIdPtr element_id;
  
  bool max_scroll_offset_affected_by_page_scale;
  
  bool scrolls_inner_viewport;
  
  bool scrolls_outer_viewport;
  
  bool prevent_viewport_scrolling_from_inner;
  
  bool user_scrollable_horizontal;
  
  bool user_scrollable_vertical;
  
  bool is_composited;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
LayerExtraPtr LayerExtra::Clone() const {
  switch (tag_) {
    case Tag::kMirrorLayerExtra:
      return NewMirrorLayerExtra(
          mojo::Clone(data_.mirror_layer_extra));
    case Tag::kNinePatchThumbScrollbarLayerExtra:
      return NewNinePatchThumbScrollbarLayerExtra(
          mojo::Clone(data_.nine_patch_thumb_scrollbar_layer_extra));
    case Tag::kPaintedScrollbarLayerExtra:
      return NewPaintedScrollbarLayerExtra(
          mojo::Clone(data_.painted_scrollbar_layer_extra));
    case Tag::kSolidColorScrollbarLayerExtra:
      return NewSolidColorScrollbarLayerExtra(
          mojo::Clone(data_.solid_color_scrollbar_layer_extra));
    case Tag::kSurfaceLayerExtra:
      return NewSurfaceLayerExtra(
          mojo::Clone(data_.surface_layer_extra));
    case Tag::kTextureLayerExtra:
      return NewTextureLayerExtra(
          mojo::Clone(data_.texture_layer_extra));
    case Tag::kUiResourceLayerExtra:
      return NewUiResourceLayerExtra(
          mojo::Clone(data_.ui_resource_layer_extra));
    case Tag::kTileDisplayLayerExtra:
      return NewTileDisplayLayerExtra(
          mojo::Clone(data_.tile_display_layer_extra));
    case Tag::kViewTransitionContentLayerExtra:
      return NewViewTransitionContentLayerExtra(
          mojo::Clone(data_.view_transition_content_layer_extra));
    case Tag::kNinePatchLayerExtra:
      return NewNinePatchLayerExtra(
          mojo::Clone(data_.nine_patch_layer_extra));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, LayerExtra>::value>::type*>
bool LayerExtra::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kMirrorLayerExtra:
      return mojo::Equals(data_.mirror_layer_extra, other.data_.mirror_layer_extra);
    case Tag::kNinePatchThumbScrollbarLayerExtra:
      return mojo::Equals(data_.nine_patch_thumb_scrollbar_layer_extra, other.data_.nine_patch_thumb_scrollbar_layer_extra);
    case Tag::kPaintedScrollbarLayerExtra:
      return mojo::Equals(data_.painted_scrollbar_layer_extra, other.data_.painted_scrollbar_layer_extra);
    case Tag::kSolidColorScrollbarLayerExtra:
      return mojo::Equals(data_.solid_color_scrollbar_layer_extra, other.data_.solid_color_scrollbar_layer_extra);
    case Tag::kSurfaceLayerExtra:
      return mojo::Equals(data_.surface_layer_extra, other.data_.surface_layer_extra);
    case Tag::kTextureLayerExtra:
      return mojo::Equals(data_.texture_layer_extra, other.data_.texture_layer_extra);
    case Tag::kUiResourceLayerExtra:
      return mojo::Equals(data_.ui_resource_layer_extra, other.data_.ui_resource_layer_extra);
    case Tag::kTileDisplayLayerExtra:
      return mojo::Equals(data_.tile_display_layer_extra, other.data_.tile_display_layer_extra);
    case Tag::kViewTransitionContentLayerExtra:
      return mojo::Equals(data_.view_transition_content_layer_extra, other.data_.view_transition_content_layer_extra);
    case Tag::kNinePatchLayerExtra:
      return mojo::Equals(data_.nine_patch_layer_extra, other.data_.nine_patch_layer_extra);
  }

  return false;
}
template <typename StructPtrType>
RarePropertiesPtr RareProperties::Clone() const {
  return New(
      mojo::Clone(filter_quality),
      mojo::Clone(dynamic_range_limit),
      mojo::Clone(capture_bounds)
  );
}

template <typename T, RareProperties::EnableIfSame<T>*>
bool RareProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filter_quality, other_struct.filter_quality))
    return false;
  if (!mojo::Equals(this->dynamic_range_limit, other_struct.dynamic_range_limit))
    return false;
  if (!mojo::Equals(this->capture_bounds, other_struct.capture_bounds))
    return false;
  return true;
}

template <typename T, RareProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.filter_quality < rhs.filter_quality)
    return true;
  if (rhs.filter_quality < lhs.filter_quality)
    return false;
  if (lhs.dynamic_range_limit < rhs.dynamic_range_limit)
    return true;
  if (rhs.dynamic_range_limit < lhs.dynamic_range_limit)
    return false;
  if (lhs.capture_bounds < rhs.capture_bounds)
    return true;
  if (rhs.capture_bounds < lhs.capture_bounds)
    return false;
  return false;
}
template <typename StructPtrType>
MirrorLayerExtraPtr MirrorLayerExtra::Clone() const {
  return New(
      mojo::Clone(mirrored_layer_id)
  );
}

template <typename T, MirrorLayerExtra::EnableIfSame<T>*>
bool MirrorLayerExtra::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mirrored_layer_id, other_struct.mirrored_layer_id))
    return false;
  return true;
}

template <typename T, MirrorLayerExtra::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mirrored_layer_id < rhs.mirrored_layer_id)
    return true;
  if (rhs.mirrored_layer_id < lhs.mirrored_layer_id)
    return false;
  return false;
}
template <typename StructPtrType>
SurfaceLayerExtraPtr SurfaceLayerExtra::Clone() const {
  return New(
      mojo::Clone(surface_range),
      mojo::Clone(deadline_in_frames),
      mojo::Clone(stretch_content_to_fill_bounds),
      mojo::Clone(surface_hit_testable),
      mojo::Clone(has_pointer_events_none),
      mojo::Clone(is_reflection),
      mojo::Clone(will_draw_needs_reset),
      mojo::Clone(override_child_paint_flags)
  );
}

template <typename T, SurfaceLayerExtra::EnableIfSame<T>*>
bool SurfaceLayerExtra::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->surface_range, other_struct.surface_range))
    return false;
  if (!mojo::Equals(this->deadline_in_frames, other_struct.deadline_in_frames))
    return false;
  if (!mojo::Equals(this->stretch_content_to_fill_bounds, other_struct.stretch_content_to_fill_bounds))
    return false;
  if (!mojo::Equals(this->surface_hit_testable, other_struct.surface_hit_testable))
    return false;
  if (!mojo::Equals(this->has_pointer_events_none, other_struct.has_pointer_events_none))
    return false;
  if (!mojo::Equals(this->is_reflection, other_struct.is_reflection))
    return false;
  if (!mojo::Equals(this->will_draw_needs_reset, other_struct.will_draw_needs_reset))
    return false;
  if (!mojo::Equals(this->override_child_paint_flags, other_struct.override_child_paint_flags))
    return false;
  return true;
}

template <typename T, SurfaceLayerExtra::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.surface_range < rhs.surface_range)
    return true;
  if (rhs.surface_range < lhs.surface_range)
    return false;
  if (lhs.deadline_in_frames < rhs.deadline_in_frames)
    return true;
  if (rhs.deadline_in_frames < lhs.deadline_in_frames)
    return false;
  if (lhs.stretch_content_to_fill_bounds < rhs.stretch_content_to_fill_bounds)
    return true;
  if (rhs.stretch_content_to_fill_bounds < lhs.stretch_content_to_fill_bounds)
    return false;
  if (lhs.surface_hit_testable < rhs.surface_hit_testable)
    return true;
  if (rhs.surface_hit_testable < lhs.surface_hit_testable)
    return false;
  if (lhs.has_pointer_events_none < rhs.has_pointer_events_none)
    return true;
  if (rhs.has_pointer_events_none < lhs.has_pointer_events_none)
    return false;
  if (lhs.is_reflection < rhs.is_reflection)
    return true;
  if (rhs.is_reflection < lhs.is_reflection)
    return false;
  if (lhs.will_draw_needs_reset < rhs.will_draw_needs_reset)
    return true;
  if (rhs.will_draw_needs_reset < lhs.will_draw_needs_reset)
    return false;
  if (lhs.override_child_paint_flags < rhs.override_child_paint_flags)
    return true;
  if (rhs.override_child_paint_flags < lhs.override_child_paint_flags)
    return false;
  return false;
}
template <typename StructPtrType>
TextureLayerExtraPtr TextureLayerExtra::Clone() const {
  return New(
      mojo::Clone(blend_background_color),
      mojo::Clone(force_texture_to_opaque),
      mojo::Clone(uv_top_left),
      mojo::Clone(uv_bottom_right),
      mojo::Clone(transferable_resource)
  );
}

template <typename T, TextureLayerExtra::EnableIfSame<T>*>
bool TextureLayerExtra::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->blend_background_color, other_struct.blend_background_color))
    return false;
  if (!mojo::Equals(this->force_texture_to_opaque, other_struct.force_texture_to_opaque))
    return false;
  if (!mojo::Equals(this->uv_top_left, other_struct.uv_top_left))
    return false;
  if (!mojo::Equals(this->uv_bottom_right, other_struct.uv_bottom_right))
    return false;
  if (!mojo::Equals(this->transferable_resource, other_struct.transferable_resource))
    return false;
  return true;
}

template <typename T, TextureLayerExtra::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.blend_background_color < rhs.blend_background_color)
    return true;
  if (rhs.blend_background_color < lhs.blend_background_color)
    return false;
  if (lhs.force_texture_to_opaque < rhs.force_texture_to_opaque)
    return true;
  if (rhs.force_texture_to_opaque < lhs.force_texture_to_opaque)
    return false;
  if (lhs.uv_top_left < rhs.uv_top_left)
    return true;
  if (rhs.uv_top_left < lhs.uv_top_left)
    return false;
  if (lhs.uv_bottom_right < rhs.uv_bottom_right)
    return true;
  if (rhs.uv_bottom_right < lhs.uv_bottom_right)
    return false;
  if (lhs.transferable_resource < rhs.transferable_resource)
    return true;
  if (rhs.transferable_resource < lhs.transferable_resource)
    return false;
  return false;
}
template <typename StructPtrType>
UIResourceLayerExtraPtr UIResourceLayerExtra::Clone() const {
  return New(
      mojo::Clone(ui_resource_id),
      mojo::Clone(image_bounds),
      mojo::Clone(uv_top_left),
      mojo::Clone(uv_bottom_right)
  );
}

template <typename T, UIResourceLayerExtra::EnableIfSame<T>*>
bool UIResourceLayerExtra::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ui_resource_id, other_struct.ui_resource_id))
    return false;
  if (!mojo::Equals(this->image_bounds, other_struct.image_bounds))
    return false;
  if (!mojo::Equals(this->uv_top_left, other_struct.uv_top_left))
    return false;
  if (!mojo::Equals(this->uv_bottom_right, other_struct.uv_bottom_right))
    return false;
  return true;
}

template <typename T, UIResourceLayerExtra::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ui_resource_id < rhs.ui_resource_id)
    return true;
  if (rhs.ui_resource_id < lhs.ui_resource_id)
    return false;
  if (lhs.image_bounds < rhs.image_bounds)
    return true;
  if (rhs.image_bounds < lhs.image_bounds)
    return false;
  if (lhs.uv_top_left < rhs.uv_top_left)
    return true;
  if (rhs.uv_top_left < lhs.uv_top_left)
    return false;
  if (lhs.uv_bottom_right < rhs.uv_bottom_right)
    return true;
  if (rhs.uv_bottom_right < lhs.uv_bottom_right)
    return false;
  return false;
}
template <typename StructPtrType>
TileDisplayLayerExtraPtr TileDisplayLayerExtra::Clone() const {
  return New(
      mojo::Clone(solid_color),
      mojo::Clone(is_backdrop_filter_mask),
      mojo::Clone(is_directly_composited_image),
      mojo::Clone(nearest_neighbor),
      mojo::Clone(content_color_usage)
  );
}

template <typename T, TileDisplayLayerExtra::EnableIfSame<T>*>
bool TileDisplayLayerExtra::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->solid_color, other_struct.solid_color))
    return false;
  if (!mojo::Equals(this->is_backdrop_filter_mask, other_struct.is_backdrop_filter_mask))
    return false;
  if (!mojo::Equals(this->is_directly_composited_image, other_struct.is_directly_composited_image))
    return false;
  if (!mojo::Equals(this->nearest_neighbor, other_struct.nearest_neighbor))
    return false;
  if (!mojo::Equals(this->content_color_usage, other_struct.content_color_usage))
    return false;
  return true;
}

template <typename T, TileDisplayLayerExtra::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.solid_color < rhs.solid_color)
    return true;
  if (rhs.solid_color < lhs.solid_color)
    return false;
  if (lhs.is_backdrop_filter_mask < rhs.is_backdrop_filter_mask)
    return true;
  if (rhs.is_backdrop_filter_mask < lhs.is_backdrop_filter_mask)
    return false;
  if (lhs.is_directly_composited_image < rhs.is_directly_composited_image)
    return true;
  if (rhs.is_directly_composited_image < lhs.is_directly_composited_image)
    return false;
  if (lhs.nearest_neighbor < rhs.nearest_neighbor)
    return true;
  if (rhs.nearest_neighbor < lhs.nearest_neighbor)
    return false;
  if (lhs.content_color_usage < rhs.content_color_usage)
    return true;
  if (rhs.content_color_usage < lhs.content_color_usage)
    return false;
  return false;
}
template <typename StructPtrType>
ScrollbarLayerBaseExtraPtr ScrollbarLayerBaseExtra::Clone() const {
  return New(
      mojo::Clone(scroll_element_id),
      mojo::Clone(is_overlay_scrollbar),
      mojo::Clone(is_web_test),
      mojo::Clone(thumb_thickness_scale_factor),
      mojo::Clone(current_pos),
      mojo::Clone(clip_layer_length),
      mojo::Clone(scroll_layer_length),
      mojo::Clone(is_horizontal_orientation),
      mojo::Clone(is_left_side_vertical_scrollbar),
      mojo::Clone(vertical_adjust),
      mojo::Clone(has_find_in_page_tickmarks)
  );
}

template <typename T, ScrollbarLayerBaseExtra::EnableIfSame<T>*>
bool ScrollbarLayerBaseExtra::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scroll_element_id, other_struct.scroll_element_id))
    return false;
  if (!mojo::Equals(this->is_overlay_scrollbar, other_struct.is_overlay_scrollbar))
    return false;
  if (!mojo::Equals(this->is_web_test, other_struct.is_web_test))
    return false;
  if (!mojo::Equals(this->thumb_thickness_scale_factor, other_struct.thumb_thickness_scale_factor))
    return false;
  if (!mojo::Equals(this->current_pos, other_struct.current_pos))
    return false;
  if (!mojo::Equals(this->clip_layer_length, other_struct.clip_layer_length))
    return false;
  if (!mojo::Equals(this->scroll_layer_length, other_struct.scroll_layer_length))
    return false;
  if (!mojo::Equals(this->is_horizontal_orientation, other_struct.is_horizontal_orientation))
    return false;
  if (!mojo::Equals(this->is_left_side_vertical_scrollbar, other_struct.is_left_side_vertical_scrollbar))
    return false;
  if (!mojo::Equals(this->vertical_adjust, other_struct.vertical_adjust))
    return false;
  if (!mojo::Equals(this->has_find_in_page_tickmarks, other_struct.has_find_in_page_tickmarks))
    return false;
  return true;
}

template <typename T, ScrollbarLayerBaseExtra::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scroll_element_id < rhs.scroll_element_id)
    return true;
  if (rhs.scroll_element_id < lhs.scroll_element_id)
    return false;
  if (lhs.is_overlay_scrollbar < rhs.is_overlay_scrollbar)
    return true;
  if (rhs.is_overlay_scrollbar < lhs.is_overlay_scrollbar)
    return false;
  if (lhs.is_web_test < rhs.is_web_test)
    return true;
  if (rhs.is_web_test < lhs.is_web_test)
    return false;
  if (lhs.thumb_thickness_scale_factor < rhs.thumb_thickness_scale_factor)
    return true;
  if (rhs.thumb_thickness_scale_factor < lhs.thumb_thickness_scale_factor)
    return false;
  if (lhs.current_pos < rhs.current_pos)
    return true;
  if (rhs.current_pos < lhs.current_pos)
    return false;
  if (lhs.clip_layer_length < rhs.clip_layer_length)
    return true;
  if (rhs.clip_layer_length < lhs.clip_layer_length)
    return false;
  if (lhs.scroll_layer_length < rhs.scroll_layer_length)
    return true;
  if (rhs.scroll_layer_length < lhs.scroll_layer_length)
    return false;
  if (lhs.is_horizontal_orientation < rhs.is_horizontal_orientation)
    return true;
  if (rhs.is_horizontal_orientation < lhs.is_horizontal_orientation)
    return false;
  if (lhs.is_left_side_vertical_scrollbar < rhs.is_left_side_vertical_scrollbar)
    return true;
  if (rhs.is_left_side_vertical_scrollbar < lhs.is_left_side_vertical_scrollbar)
    return false;
  if (lhs.vertical_adjust < rhs.vertical_adjust)
    return true;
  if (rhs.vertical_adjust < lhs.vertical_adjust)
    return false;
  if (lhs.has_find_in_page_tickmarks < rhs.has_find_in_page_tickmarks)
    return true;
  if (rhs.has_find_in_page_tickmarks < lhs.has_find_in_page_tickmarks)
    return false;
  return false;
}
template <typename StructPtrType>
NinePatchThumbScrollbarLayerExtraPtr NinePatchThumbScrollbarLayerExtra::Clone() const {
  return New(
      mojo::Clone(scrollbar_base_extra),
      mojo::Clone(thumb_thickness),
      mojo::Clone(thumb_length),
      mojo::Clone(track_start),
      mojo::Clone(track_length),
      mojo::Clone(image_bounds),
      mojo::Clone(aperture),
      mojo::Clone(thumb_ui_resource_id),
      mojo::Clone(track_and_buttons_ui_resource_id)
  );
}

template <typename T, NinePatchThumbScrollbarLayerExtra::EnableIfSame<T>*>
bool NinePatchThumbScrollbarLayerExtra::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scrollbar_base_extra, other_struct.scrollbar_base_extra))
    return false;
  if (!mojo::Equals(this->thumb_thickness, other_struct.thumb_thickness))
    return false;
  if (!mojo::Equals(this->thumb_length, other_struct.thumb_length))
    return false;
  if (!mojo::Equals(this->track_start, other_struct.track_start))
    return false;
  if (!mojo::Equals(this->track_length, other_struct.track_length))
    return false;
  if (!mojo::Equals(this->image_bounds, other_struct.image_bounds))
    return false;
  if (!mojo::Equals(this->aperture, other_struct.aperture))
    return false;
  if (!mojo::Equals(this->thumb_ui_resource_id, other_struct.thumb_ui_resource_id))
    return false;
  if (!mojo::Equals(this->track_and_buttons_ui_resource_id, other_struct.track_and_buttons_ui_resource_id))
    return false;
  return true;
}

template <typename T, NinePatchThumbScrollbarLayerExtra::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scrollbar_base_extra < rhs.scrollbar_base_extra)
    return true;
  if (rhs.scrollbar_base_extra < lhs.scrollbar_base_extra)
    return false;
  if (lhs.thumb_thickness < rhs.thumb_thickness)
    return true;
  if (rhs.thumb_thickness < lhs.thumb_thickness)
    return false;
  if (lhs.thumb_length < rhs.thumb_length)
    return true;
  if (rhs.thumb_length < lhs.thumb_length)
    return false;
  if (lhs.track_start < rhs.track_start)
    return true;
  if (rhs.track_start < lhs.track_start)
    return false;
  if (lhs.track_length < rhs.track_length)
    return true;
  if (rhs.track_length < lhs.track_length)
    return false;
  if (lhs.image_bounds < rhs.image_bounds)
    return true;
  if (rhs.image_bounds < lhs.image_bounds)
    return false;
  if (lhs.aperture < rhs.aperture)
    return true;
  if (rhs.aperture < lhs.aperture)
    return false;
  if (lhs.thumb_ui_resource_id < rhs.thumb_ui_resource_id)
    return true;
  if (rhs.thumb_ui_resource_id < lhs.thumb_ui_resource_id)
    return false;
  if (lhs.track_and_buttons_ui_resource_id < rhs.track_and_buttons_ui_resource_id)
    return true;
  if (rhs.track_and_buttons_ui_resource_id < lhs.track_and_buttons_ui_resource_id)
    return false;
  return false;
}
template <typename StructPtrType>
PaintedScrollbarLayerExtraPtr PaintedScrollbarLayerExtra::Clone() const {
  return New(
      mojo::Clone(scrollbar_base_extra),
      mojo::Clone(internal_contents_scale),
      mojo::Clone(internal_content_bounds),
      mojo::Clone(jump_on_track_click),
      mojo::Clone(supports_drag_snap_back),
      mojo::Clone(thumb_thickness),
      mojo::Clone(thumb_length),
      mojo::Clone(back_button_rect),
      mojo::Clone(forward_button_rect),
      mojo::Clone(track_rect),
      mojo::Clone(thumb_color),
      mojo::Clone(uses_nine_patch_track_and_buttons),
      mojo::Clone(track_and_buttons_image_bounds),
      mojo::Clone(track_and_buttons_aperture),
      mojo::Clone(painted_opacity),
      mojo::Clone(track_and_buttons_ui_resource_id),
      mojo::Clone(thumb_ui_resource_id)
  );
}

template <typename T, PaintedScrollbarLayerExtra::EnableIfSame<T>*>
bool PaintedScrollbarLayerExtra::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scrollbar_base_extra, other_struct.scrollbar_base_extra))
    return false;
  if (!mojo::Equals(this->internal_contents_scale, other_struct.internal_contents_scale))
    return false;
  if (!mojo::Equals(this->internal_content_bounds, other_struct.internal_content_bounds))
    return false;
  if (!mojo::Equals(this->jump_on_track_click, other_struct.jump_on_track_click))
    return false;
  if (!mojo::Equals(this->supports_drag_snap_back, other_struct.supports_drag_snap_back))
    return false;
  if (!mojo::Equals(this->thumb_thickness, other_struct.thumb_thickness))
    return false;
  if (!mojo::Equals(this->thumb_length, other_struct.thumb_length))
    return false;
  if (!mojo::Equals(this->back_button_rect, other_struct.back_button_rect))
    return false;
  if (!mojo::Equals(this->forward_button_rect, other_struct.forward_button_rect))
    return false;
  if (!mojo::Equals(this->track_rect, other_struct.track_rect))
    return false;
  if (!mojo::Equals(this->thumb_color, other_struct.thumb_color))
    return false;
  if (!mojo::Equals(this->uses_nine_patch_track_and_buttons, other_struct.uses_nine_patch_track_and_buttons))
    return false;
  if (!mojo::Equals(this->track_and_buttons_image_bounds, other_struct.track_and_buttons_image_bounds))
    return false;
  if (!mojo::Equals(this->track_and_buttons_aperture, other_struct.track_and_buttons_aperture))
    return false;
  if (!mojo::Equals(this->painted_opacity, other_struct.painted_opacity))
    return false;
  if (!mojo::Equals(this->track_and_buttons_ui_resource_id, other_struct.track_and_buttons_ui_resource_id))
    return false;
  if (!mojo::Equals(this->thumb_ui_resource_id, other_struct.thumb_ui_resource_id))
    return false;
  return true;
}

template <typename T, PaintedScrollbarLayerExtra::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scrollbar_base_extra < rhs.scrollbar_base_extra)
    return true;
  if (rhs.scrollbar_base_extra < lhs.scrollbar_base_extra)
    return false;
  if (lhs.internal_contents_scale < rhs.internal_contents_scale)
    return true;
  if (rhs.internal_contents_scale < lhs.internal_contents_scale)
    return false;
  if (lhs.internal_content_bounds < rhs.internal_content_bounds)
    return true;
  if (rhs.internal_content_bounds < lhs.internal_content_bounds)
    return false;
  if (lhs.jump_on_track_click < rhs.jump_on_track_click)
    return true;
  if (rhs.jump_on_track_click < lhs.jump_on_track_click)
    return false;
  if (lhs.supports_drag_snap_back < rhs.supports_drag_snap_back)
    return true;
  if (rhs.supports_drag_snap_back < lhs.supports_drag_snap_back)
    return false;
  if (lhs.thumb_thickness < rhs.thumb_thickness)
    return true;
  if (rhs.thumb_thickness < lhs.thumb_thickness)
    return false;
  if (lhs.thumb_length < rhs.thumb_length)
    return true;
  if (rhs.thumb_length < lhs.thumb_length)
    return false;
  if (lhs.back_button_rect < rhs.back_button_rect)
    return true;
  if (rhs.back_button_rect < lhs.back_button_rect)
    return false;
  if (lhs.forward_button_rect < rhs.forward_button_rect)
    return true;
  if (rhs.forward_button_rect < lhs.forward_button_rect)
    return false;
  if (lhs.track_rect < rhs.track_rect)
    return true;
  if (rhs.track_rect < lhs.track_rect)
    return false;
  if (lhs.thumb_color < rhs.thumb_color)
    return true;
  if (rhs.thumb_color < lhs.thumb_color)
    return false;
  if (lhs.uses_nine_patch_track_and_buttons < rhs.uses_nine_patch_track_and_buttons)
    return true;
  if (rhs.uses_nine_patch_track_and_buttons < lhs.uses_nine_patch_track_and_buttons)
    return false;
  if (lhs.track_and_buttons_image_bounds < rhs.track_and_buttons_image_bounds)
    return true;
  if (rhs.track_and_buttons_image_bounds < lhs.track_and_buttons_image_bounds)
    return false;
  if (lhs.track_and_buttons_aperture < rhs.track_and_buttons_aperture)
    return true;
  if (rhs.track_and_buttons_aperture < lhs.track_and_buttons_aperture)
    return false;
  if (lhs.painted_opacity < rhs.painted_opacity)
    return true;
  if (rhs.painted_opacity < lhs.painted_opacity)
    return false;
  if (lhs.track_and_buttons_ui_resource_id < rhs.track_and_buttons_ui_resource_id)
    return true;
  if (rhs.track_and_buttons_ui_resource_id < lhs.track_and_buttons_ui_resource_id)
    return false;
  if (lhs.thumb_ui_resource_id < rhs.thumb_ui_resource_id)
    return true;
  if (rhs.thumb_ui_resource_id < lhs.thumb_ui_resource_id)
    return false;
  return false;
}
template <typename StructPtrType>
SolidColorScrollbarLayerExtraPtr SolidColorScrollbarLayerExtra::Clone() const {
  return New(
      mojo::Clone(scrollbar_base_extra),
      mojo::Clone(thumb_thickness),
      mojo::Clone(track_start),
      mojo::Clone(color)
  );
}

template <typename T, SolidColorScrollbarLayerExtra::EnableIfSame<T>*>
bool SolidColorScrollbarLayerExtra::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scrollbar_base_extra, other_struct.scrollbar_base_extra))
    return false;
  if (!mojo::Equals(this->thumb_thickness, other_struct.thumb_thickness))
    return false;
  if (!mojo::Equals(this->track_start, other_struct.track_start))
    return false;
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  return true;
}

template <typename T, SolidColorScrollbarLayerExtra::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scrollbar_base_extra < rhs.scrollbar_base_extra)
    return true;
  if (rhs.scrollbar_base_extra < lhs.scrollbar_base_extra)
    return false;
  if (lhs.thumb_thickness < rhs.thumb_thickness)
    return true;
  if (rhs.thumb_thickness < lhs.thumb_thickness)
    return false;
  if (lhs.track_start < rhs.track_start)
    return true;
  if (rhs.track_start < lhs.track_start)
    return false;
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  return false;
}
template <typename StructPtrType>
ViewTransitionContentLayerExtraPtr ViewTransitionContentLayerExtra::Clone() const {
  return New(
      mojo::Clone(resource_id),
      mojo::Clone(is_live_content_layer),
      mojo::Clone(max_extents_rect)
  );
}

template <typename T, ViewTransitionContentLayerExtra::EnableIfSame<T>*>
bool ViewTransitionContentLayerExtra::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resource_id, other_struct.resource_id))
    return false;
  if (!mojo::Equals(this->is_live_content_layer, other_struct.is_live_content_layer))
    return false;
  if (!mojo::Equals(this->max_extents_rect, other_struct.max_extents_rect))
    return false;
  return true;
}

template <typename T, ViewTransitionContentLayerExtra::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.resource_id < rhs.resource_id)
    return true;
  if (rhs.resource_id < lhs.resource_id)
    return false;
  if (lhs.is_live_content_layer < rhs.is_live_content_layer)
    return true;
  if (rhs.is_live_content_layer < lhs.is_live_content_layer)
    return false;
  if (lhs.max_extents_rect < rhs.max_extents_rect)
    return true;
  if (rhs.max_extents_rect < lhs.max_extents_rect)
    return false;
  return false;
}
template <typename StructPtrType>
NinePatchLayerExtraPtr NinePatchLayerExtra::Clone() const {
  return New(
      mojo::Clone(image_aperture),
      mojo::Clone(border),
      mojo::Clone(layer_occlusion),
      mojo::Clone(fill_center),
      mojo::Clone(ui_resource_id),
      mojo::Clone(image_bounds),
      mojo::Clone(uv_top_left),
      mojo::Clone(uv_bottom_right)
  );
}

template <typename T, NinePatchLayerExtra::EnableIfSame<T>*>
bool NinePatchLayerExtra::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_aperture, other_struct.image_aperture))
    return false;
  if (!mojo::Equals(this->border, other_struct.border))
    return false;
  if (!mojo::Equals(this->layer_occlusion, other_struct.layer_occlusion))
    return false;
  if (!mojo::Equals(this->fill_center, other_struct.fill_center))
    return false;
  if (!mojo::Equals(this->ui_resource_id, other_struct.ui_resource_id))
    return false;
  if (!mojo::Equals(this->image_bounds, other_struct.image_bounds))
    return false;
  if (!mojo::Equals(this->uv_top_left, other_struct.uv_top_left))
    return false;
  if (!mojo::Equals(this->uv_bottom_right, other_struct.uv_bottom_right))
    return false;
  return true;
}

template <typename T, NinePatchLayerExtra::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_aperture < rhs.image_aperture)
    return true;
  if (rhs.image_aperture < lhs.image_aperture)
    return false;
  if (lhs.border < rhs.border)
    return true;
  if (rhs.border < lhs.border)
    return false;
  if (lhs.layer_occlusion < rhs.layer_occlusion)
    return true;
  if (rhs.layer_occlusion < lhs.layer_occlusion)
    return false;
  if (lhs.fill_center < rhs.fill_center)
    return true;
  if (rhs.fill_center < lhs.fill_center)
    return false;
  if (lhs.ui_resource_id < rhs.ui_resource_id)
    return true;
  if (rhs.ui_resource_id < lhs.ui_resource_id)
    return false;
  if (lhs.image_bounds < rhs.image_bounds)
    return true;
  if (rhs.image_bounds < lhs.image_bounds)
    return false;
  if (lhs.uv_top_left < rhs.uv_top_left)
    return true;
  if (rhs.uv_top_left < lhs.uv_top_left)
    return false;
  if (lhs.uv_bottom_right < rhs.uv_bottom_right)
    return true;
  if (rhs.uv_bottom_right < lhs.uv_bottom_right)
    return false;
  return false;
}
template <typename StructPtrType>
LayerPtr Layer::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(type),
      mojo::Clone(bounds),
      mojo::Clone(contents_opaque),
      mojo::Clone(contents_opaque_for_text),
      mojo::Clone(is_drawable),
      mojo::Clone(layer_property_changed_not_from_property_trees),
      mojo::Clone(layer_property_changed_from_property_trees),
      mojo::Clone(hit_test_opaqueness),
      mojo::Clone(background_color),
      mojo::Clone(safe_opaque_background_color),
      mojo::Clone(element_id),
      mojo::Clone(update_rect),
      mojo::Clone(offset_to_transform_parent),
      mojo::Clone(transform_tree_index),
      mojo::Clone(clip_tree_index),
      mojo::Clone(effect_tree_index),
      mojo::Clone(scroll_tree_index),
      mojo::Clone(should_check_backface_visibility),
      mojo::Clone(rare_properties),
      mojo::Clone(layer_extra)
  );
}

template <typename T, Layer::EnableIfSame<T>*>
bool Layer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->contents_opaque, other_struct.contents_opaque))
    return false;
  if (!mojo::Equals(this->contents_opaque_for_text, other_struct.contents_opaque_for_text))
    return false;
  if (!mojo::Equals(this->is_drawable, other_struct.is_drawable))
    return false;
  if (!mojo::Equals(this->layer_property_changed_not_from_property_trees, other_struct.layer_property_changed_not_from_property_trees))
    return false;
  if (!mojo::Equals(this->layer_property_changed_from_property_trees, other_struct.layer_property_changed_from_property_trees))
    return false;
  if (!mojo::Equals(this->hit_test_opaqueness, other_struct.hit_test_opaqueness))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->safe_opaque_background_color, other_struct.safe_opaque_background_color))
    return false;
  if (!mojo::Equals(this->element_id, other_struct.element_id))
    return false;
  if (!mojo::Equals(this->update_rect, other_struct.update_rect))
    return false;
  if (!mojo::Equals(this->offset_to_transform_parent, other_struct.offset_to_transform_parent))
    return false;
  if (!mojo::Equals(this->transform_tree_index, other_struct.transform_tree_index))
    return false;
  if (!mojo::Equals(this->clip_tree_index, other_struct.clip_tree_index))
    return false;
  if (!mojo::Equals(this->effect_tree_index, other_struct.effect_tree_index))
    return false;
  if (!mojo::Equals(this->scroll_tree_index, other_struct.scroll_tree_index))
    return false;
  if (!mojo::Equals(this->should_check_backface_visibility, other_struct.should_check_backface_visibility))
    return false;
  if (!mojo::Equals(this->rare_properties, other_struct.rare_properties))
    return false;
  if (!mojo::Equals(this->layer_extra, other_struct.layer_extra))
    return false;
  return true;
}

template <typename T, Layer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.contents_opaque < rhs.contents_opaque)
    return true;
  if (rhs.contents_opaque < lhs.contents_opaque)
    return false;
  if (lhs.contents_opaque_for_text < rhs.contents_opaque_for_text)
    return true;
  if (rhs.contents_opaque_for_text < lhs.contents_opaque_for_text)
    return false;
  if (lhs.is_drawable < rhs.is_drawable)
    return true;
  if (rhs.is_drawable < lhs.is_drawable)
    return false;
  if (lhs.layer_property_changed_not_from_property_trees < rhs.layer_property_changed_not_from_property_trees)
    return true;
  if (rhs.layer_property_changed_not_from_property_trees < lhs.layer_property_changed_not_from_property_trees)
    return false;
  if (lhs.layer_property_changed_from_property_trees < rhs.layer_property_changed_from_property_trees)
    return true;
  if (rhs.layer_property_changed_from_property_trees < lhs.layer_property_changed_from_property_trees)
    return false;
  if (lhs.hit_test_opaqueness < rhs.hit_test_opaqueness)
    return true;
  if (rhs.hit_test_opaqueness < lhs.hit_test_opaqueness)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.safe_opaque_background_color < rhs.safe_opaque_background_color)
    return true;
  if (rhs.safe_opaque_background_color < lhs.safe_opaque_background_color)
    return false;
  if (lhs.element_id < rhs.element_id)
    return true;
  if (rhs.element_id < lhs.element_id)
    return false;
  if (lhs.update_rect < rhs.update_rect)
    return true;
  if (rhs.update_rect < lhs.update_rect)
    return false;
  if (lhs.offset_to_transform_parent < rhs.offset_to_transform_parent)
    return true;
  if (rhs.offset_to_transform_parent < lhs.offset_to_transform_parent)
    return false;
  if (lhs.transform_tree_index < rhs.transform_tree_index)
    return true;
  if (rhs.transform_tree_index < lhs.transform_tree_index)
    return false;
  if (lhs.clip_tree_index < rhs.clip_tree_index)
    return true;
  if (rhs.clip_tree_index < lhs.clip_tree_index)
    return false;
  if (lhs.effect_tree_index < rhs.effect_tree_index)
    return true;
  if (rhs.effect_tree_index < lhs.effect_tree_index)
    return false;
  if (lhs.scroll_tree_index < rhs.scroll_tree_index)
    return true;
  if (rhs.scroll_tree_index < lhs.scroll_tree_index)
    return false;
  if (lhs.should_check_backface_visibility < rhs.should_check_backface_visibility)
    return true;
  if (rhs.should_check_backface_visibility < lhs.should_check_backface_visibility)
    return false;
  if (lhs.rare_properties < rhs.rare_properties)
    return true;
  if (rhs.rare_properties < lhs.rare_properties)
    return false;
  if (lhs.layer_extra < rhs.layer_extra)
    return true;
  if (rhs.layer_extra < lhs.layer_extra)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorPositionScrollDataPtr AnchorPositionScrollData::Clone() const {
  return New(
      mojo::Clone(adjustment_container_ids),
      mojo::Clone(accumulated_scroll_origin),
      mojo::Clone(needs_scroll_adjustment_in_x),
      mojo::Clone(needs_scroll_adjustment_in_y)
  );
}

template <typename T, AnchorPositionScrollData::EnableIfSame<T>*>
bool AnchorPositionScrollData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->adjustment_container_ids, other_struct.adjustment_container_ids))
    return false;
  if (!mojo::Equals(this->accumulated_scroll_origin, other_struct.accumulated_scroll_origin))
    return false;
  if (!mojo::Equals(this->needs_scroll_adjustment_in_x, other_struct.needs_scroll_adjustment_in_x))
    return false;
  if (!mojo::Equals(this->needs_scroll_adjustment_in_y, other_struct.needs_scroll_adjustment_in_y))
    return false;
  return true;
}

template <typename T, AnchorPositionScrollData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.adjustment_container_ids < rhs.adjustment_container_ids)
    return true;
  if (rhs.adjustment_container_ids < lhs.adjustment_container_ids)
    return false;
  if (lhs.accumulated_scroll_origin < rhs.accumulated_scroll_origin)
    return true;
  if (rhs.accumulated_scroll_origin < lhs.accumulated_scroll_origin)
    return false;
  if (lhs.needs_scroll_adjustment_in_x < rhs.needs_scroll_adjustment_in_x)
    return true;
  if (rhs.needs_scroll_adjustment_in_x < lhs.needs_scroll_adjustment_in_x)
    return false;
  if (lhs.needs_scroll_adjustment_in_y < rhs.needs_scroll_adjustment_in_y)
    return true;
  if (rhs.needs_scroll_adjustment_in_y < lhs.needs_scroll_adjustment_in_y)
    return false;
  return false;
}
template <typename StructPtrType>
StickyPositionNodeDataPtr StickyPositionNodeData::Clone() const {
  return New(
      mojo::Clone(scroll_ancestor),
      mojo::Clone(is_anchored_left),
      mojo::Clone(is_anchored_right),
      mojo::Clone(is_anchored_top),
      mojo::Clone(is_anchored_bottom),
      mojo::Clone(left_offset),
      mojo::Clone(right_offset),
      mojo::Clone(top_offset),
      mojo::Clone(bottom_offset),
      mojo::Clone(constraint_box_rect),
      mojo::Clone(scroll_container_relative_sticky_box_rect),
      mojo::Clone(scroll_container_relative_containing_block_rect),
      mojo::Clone(pixel_snap_offset),
      mojo::Clone(nearest_node_shifting_sticky_box),
      mojo::Clone(nearest_node_shifting_containing_block),
      mojo::Clone(total_sticky_box_sticky_offset),
      mojo::Clone(total_containing_block_sticky_offset)
  );
}

template <typename T, StickyPositionNodeData::EnableIfSame<T>*>
bool StickyPositionNodeData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scroll_ancestor, other_struct.scroll_ancestor))
    return false;
  if (!mojo::Equals(this->is_anchored_left, other_struct.is_anchored_left))
    return false;
  if (!mojo::Equals(this->is_anchored_right, other_struct.is_anchored_right))
    return false;
  if (!mojo::Equals(this->is_anchored_top, other_struct.is_anchored_top))
    return false;
  if (!mojo::Equals(this->is_anchored_bottom, other_struct.is_anchored_bottom))
    return false;
  if (!mojo::Equals(this->left_offset, other_struct.left_offset))
    return false;
  if (!mojo::Equals(this->right_offset, other_struct.right_offset))
    return false;
  if (!mojo::Equals(this->top_offset, other_struct.top_offset))
    return false;
  if (!mojo::Equals(this->bottom_offset, other_struct.bottom_offset))
    return false;
  if (!mojo::Equals(this->constraint_box_rect, other_struct.constraint_box_rect))
    return false;
  if (!mojo::Equals(this->scroll_container_relative_sticky_box_rect, other_struct.scroll_container_relative_sticky_box_rect))
    return false;
  if (!mojo::Equals(this->scroll_container_relative_containing_block_rect, other_struct.scroll_container_relative_containing_block_rect))
    return false;
  if (!mojo::Equals(this->pixel_snap_offset, other_struct.pixel_snap_offset))
    return false;
  if (!mojo::Equals(this->nearest_node_shifting_sticky_box, other_struct.nearest_node_shifting_sticky_box))
    return false;
  if (!mojo::Equals(this->nearest_node_shifting_containing_block, other_struct.nearest_node_shifting_containing_block))
    return false;
  if (!mojo::Equals(this->total_sticky_box_sticky_offset, other_struct.total_sticky_box_sticky_offset))
    return false;
  if (!mojo::Equals(this->total_containing_block_sticky_offset, other_struct.total_containing_block_sticky_offset))
    return false;
  return true;
}

template <typename T, StickyPositionNodeData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scroll_ancestor < rhs.scroll_ancestor)
    return true;
  if (rhs.scroll_ancestor < lhs.scroll_ancestor)
    return false;
  if (lhs.is_anchored_left < rhs.is_anchored_left)
    return true;
  if (rhs.is_anchored_left < lhs.is_anchored_left)
    return false;
  if (lhs.is_anchored_right < rhs.is_anchored_right)
    return true;
  if (rhs.is_anchored_right < lhs.is_anchored_right)
    return false;
  if (lhs.is_anchored_top < rhs.is_anchored_top)
    return true;
  if (rhs.is_anchored_top < lhs.is_anchored_top)
    return false;
  if (lhs.is_anchored_bottom < rhs.is_anchored_bottom)
    return true;
  if (rhs.is_anchored_bottom < lhs.is_anchored_bottom)
    return false;
  if (lhs.left_offset < rhs.left_offset)
    return true;
  if (rhs.left_offset < lhs.left_offset)
    return false;
  if (lhs.right_offset < rhs.right_offset)
    return true;
  if (rhs.right_offset < lhs.right_offset)
    return false;
  if (lhs.top_offset < rhs.top_offset)
    return true;
  if (rhs.top_offset < lhs.top_offset)
    return false;
  if (lhs.bottom_offset < rhs.bottom_offset)
    return true;
  if (rhs.bottom_offset < lhs.bottom_offset)
    return false;
  if (lhs.constraint_box_rect < rhs.constraint_box_rect)
    return true;
  if (rhs.constraint_box_rect < lhs.constraint_box_rect)
    return false;
  if (lhs.scroll_container_relative_sticky_box_rect < rhs.scroll_container_relative_sticky_box_rect)
    return true;
  if (rhs.scroll_container_relative_sticky_box_rect < lhs.scroll_container_relative_sticky_box_rect)
    return false;
  if (lhs.scroll_container_relative_containing_block_rect < rhs.scroll_container_relative_containing_block_rect)
    return true;
  if (rhs.scroll_container_relative_containing_block_rect < lhs.scroll_container_relative_containing_block_rect)
    return false;
  if (lhs.pixel_snap_offset < rhs.pixel_snap_offset)
    return true;
  if (rhs.pixel_snap_offset < lhs.pixel_snap_offset)
    return false;
  if (lhs.nearest_node_shifting_sticky_box < rhs.nearest_node_shifting_sticky_box)
    return true;
  if (rhs.nearest_node_shifting_sticky_box < lhs.nearest_node_shifting_sticky_box)
    return false;
  if (lhs.nearest_node_shifting_containing_block < rhs.nearest_node_shifting_containing_block)
    return true;
  if (rhs.nearest_node_shifting_containing_block < lhs.nearest_node_shifting_containing_block)
    return false;
  if (lhs.total_sticky_box_sticky_offset < rhs.total_sticky_box_sticky_offset)
    return true;
  if (rhs.total_sticky_box_sticky_offset < lhs.total_sticky_box_sticky_offset)
    return false;
  if (lhs.total_containing_block_sticky_offset < rhs.total_containing_block_sticky_offset)
    return true;
  if (rhs.total_containing_block_sticky_offset < lhs.total_containing_block_sticky_offset)
    return false;
  return false;
}
template <typename StructPtrType>
TransformTreeUpdatePtr TransformTreeUpdate::Clone() const {
  return New(
      mojo::Clone(page_scale_factor),
      mojo::Clone(device_scale_factor),
      mojo::Clone(device_transform_scale_factor),
      mojo::Clone(nodes_affected_by_outer_viewport_bounds_delta),
      mojo::Clone(nodes_affected_by_safe_area_bottom),
      mojo::Clone(sticky_position_data),
      mojo::Clone(anchor_position_scroll_data)
  );
}

template <typename T, TransformTreeUpdate::EnableIfSame<T>*>
bool TransformTreeUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->device_transform_scale_factor, other_struct.device_transform_scale_factor))
    return false;
  if (!mojo::Equals(this->nodes_affected_by_outer_viewport_bounds_delta, other_struct.nodes_affected_by_outer_viewport_bounds_delta))
    return false;
  if (!mojo::Equals(this->nodes_affected_by_safe_area_bottom, other_struct.nodes_affected_by_safe_area_bottom))
    return false;
  if (!mojo::Equals(this->sticky_position_data, other_struct.sticky_position_data))
    return false;
  if (!mojo::Equals(this->anchor_position_scroll_data, other_struct.anchor_position_scroll_data))
    return false;
  return true;
}

template <typename T, TransformTreeUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.page_scale_factor < rhs.page_scale_factor)
    return true;
  if (rhs.page_scale_factor < lhs.page_scale_factor)
    return false;
  if (lhs.device_scale_factor < rhs.device_scale_factor)
    return true;
  if (rhs.device_scale_factor < lhs.device_scale_factor)
    return false;
  if (lhs.device_transform_scale_factor < rhs.device_transform_scale_factor)
    return true;
  if (rhs.device_transform_scale_factor < lhs.device_transform_scale_factor)
    return false;
  if (lhs.nodes_affected_by_outer_viewport_bounds_delta < rhs.nodes_affected_by_outer_viewport_bounds_delta)
    return true;
  if (rhs.nodes_affected_by_outer_viewport_bounds_delta < lhs.nodes_affected_by_outer_viewport_bounds_delta)
    return false;
  if (lhs.nodes_affected_by_safe_area_bottom < rhs.nodes_affected_by_safe_area_bottom)
    return true;
  if (rhs.nodes_affected_by_safe_area_bottom < lhs.nodes_affected_by_safe_area_bottom)
    return false;
  if (lhs.sticky_position_data < rhs.sticky_position_data)
    return true;
  if (rhs.sticky_position_data < lhs.sticky_position_data)
    return false;
  if (lhs.anchor_position_scroll_data < rhs.anchor_position_scroll_data)
    return true;
  if (rhs.anchor_position_scroll_data < lhs.anchor_position_scroll_data)
    return false;
  return false;
}
template <typename StructPtrType>
TransformNodePtr TransformNode::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(parent_id),
      mojo::Clone(parent_frame_id),
      mojo::Clone(element_id),
      mojo::Clone(local),
      mojo::Clone(origin),
      mojo::Clone(post_translation),
      mojo::Clone(to_parent),
      mojo::Clone(scroll_offset),
      mojo::Clone(snap_amount),
      mojo::Clone(sticky_position_constraint_id),
      mojo::Clone(anchor_position_scroll_data_id),
      mojo::Clone(sorting_context_id),
      mojo::Clone(has_potential_animation),
      mojo::Clone(is_currently_animating),
      mojo::Clone(flattens_inherited_transform),
      mojo::Clone(scrolls),
      mojo::Clone(should_undo_overscroll),
      mojo::Clone(should_be_snapped),
      mojo::Clone(moved_by_outer_viewport_bounds_delta_y),
      mojo::Clone(in_subtree_of_page_scale_layer),
      mojo::Clone(transform_changed),
      mojo::Clone(delegates_to_parent_for_backface),
      mojo::Clone(will_change_transform),
      mojo::Clone(maximum_animation_scale),
      mojo::Clone(node_and_ancestors_are_animated_or_invertible),
      mojo::Clone(is_invertible),
      mojo::Clone(ancestors_are_invertible),
      mojo::Clone(node_and_ancestors_are_flat),
      mojo::Clone(node_or_ancestors_will_change_transform),
      mojo::Clone(visible_frame_element_id),
      mojo::Clone(damage_reasons_bit_mask),
      mojo::Clone(moved_by_safe_area_bottom)
  );
}

template <typename T, TransformNode::EnableIfSame<T>*>
bool TransformNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->parent_id, other_struct.parent_id))
    return false;
  if (!mojo::Equals(this->parent_frame_id, other_struct.parent_frame_id))
    return false;
  if (!mojo::Equals(this->element_id, other_struct.element_id))
    return false;
  if (!mojo::Equals(this->local, other_struct.local))
    return false;
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->post_translation, other_struct.post_translation))
    return false;
  if (!mojo::Equals(this->to_parent, other_struct.to_parent))
    return false;
  if (!mojo::Equals(this->scroll_offset, other_struct.scroll_offset))
    return false;
  if (!mojo::Equals(this->snap_amount, other_struct.snap_amount))
    return false;
  if (!mojo::Equals(this->sticky_position_constraint_id, other_struct.sticky_position_constraint_id))
    return false;
  if (!mojo::Equals(this->anchor_position_scroll_data_id, other_struct.anchor_position_scroll_data_id))
    return false;
  if (!mojo::Equals(this->sorting_context_id, other_struct.sorting_context_id))
    return false;
  if (!mojo::Equals(this->has_potential_animation, other_struct.has_potential_animation))
    return false;
  if (!mojo::Equals(this->is_currently_animating, other_struct.is_currently_animating))
    return false;
  if (!mojo::Equals(this->flattens_inherited_transform, other_struct.flattens_inherited_transform))
    return false;
  if (!mojo::Equals(this->scrolls, other_struct.scrolls))
    return false;
  if (!mojo::Equals(this->should_undo_overscroll, other_struct.should_undo_overscroll))
    return false;
  if (!mojo::Equals(this->should_be_snapped, other_struct.should_be_snapped))
    return false;
  if (!mojo::Equals(this->moved_by_outer_viewport_bounds_delta_y, other_struct.moved_by_outer_viewport_bounds_delta_y))
    return false;
  if (!mojo::Equals(this->in_subtree_of_page_scale_layer, other_struct.in_subtree_of_page_scale_layer))
    return false;
  if (!mojo::Equals(this->transform_changed, other_struct.transform_changed))
    return false;
  if (!mojo::Equals(this->delegates_to_parent_for_backface, other_struct.delegates_to_parent_for_backface))
    return false;
  if (!mojo::Equals(this->will_change_transform, other_struct.will_change_transform))
    return false;
  if (!mojo::Equals(this->maximum_animation_scale, other_struct.maximum_animation_scale))
    return false;
  if (!mojo::Equals(this->node_and_ancestors_are_animated_or_invertible, other_struct.node_and_ancestors_are_animated_or_invertible))
    return false;
  if (!mojo::Equals(this->is_invertible, other_struct.is_invertible))
    return false;
  if (!mojo::Equals(this->ancestors_are_invertible, other_struct.ancestors_are_invertible))
    return false;
  if (!mojo::Equals(this->node_and_ancestors_are_flat, other_struct.node_and_ancestors_are_flat))
    return false;
  if (!mojo::Equals(this->node_or_ancestors_will_change_transform, other_struct.node_or_ancestors_will_change_transform))
    return false;
  if (!mojo::Equals(this->visible_frame_element_id, other_struct.visible_frame_element_id))
    return false;
  if (!mojo::Equals(this->damage_reasons_bit_mask, other_struct.damage_reasons_bit_mask))
    return false;
  if (!mojo::Equals(this->moved_by_safe_area_bottom, other_struct.moved_by_safe_area_bottom))
    return false;
  return true;
}

template <typename T, TransformNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.parent_id < rhs.parent_id)
    return true;
  if (rhs.parent_id < lhs.parent_id)
    return false;
  if (lhs.parent_frame_id < rhs.parent_frame_id)
    return true;
  if (rhs.parent_frame_id < lhs.parent_frame_id)
    return false;
  if (lhs.element_id < rhs.element_id)
    return true;
  if (rhs.element_id < lhs.element_id)
    return false;
  if (lhs.local < rhs.local)
    return true;
  if (rhs.local < lhs.local)
    return false;
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.post_translation < rhs.post_translation)
    return true;
  if (rhs.post_translation < lhs.post_translation)
    return false;
  if (lhs.to_parent < rhs.to_parent)
    return true;
  if (rhs.to_parent < lhs.to_parent)
    return false;
  if (lhs.scroll_offset < rhs.scroll_offset)
    return true;
  if (rhs.scroll_offset < lhs.scroll_offset)
    return false;
  if (lhs.snap_amount < rhs.snap_amount)
    return true;
  if (rhs.snap_amount < lhs.snap_amount)
    return false;
  if (lhs.sticky_position_constraint_id < rhs.sticky_position_constraint_id)
    return true;
  if (rhs.sticky_position_constraint_id < lhs.sticky_position_constraint_id)
    return false;
  if (lhs.anchor_position_scroll_data_id < rhs.anchor_position_scroll_data_id)
    return true;
  if (rhs.anchor_position_scroll_data_id < lhs.anchor_position_scroll_data_id)
    return false;
  if (lhs.sorting_context_id < rhs.sorting_context_id)
    return true;
  if (rhs.sorting_context_id < lhs.sorting_context_id)
    return false;
  if (lhs.has_potential_animation < rhs.has_potential_animation)
    return true;
  if (rhs.has_potential_animation < lhs.has_potential_animation)
    return false;
  if (lhs.is_currently_animating < rhs.is_currently_animating)
    return true;
  if (rhs.is_currently_animating < lhs.is_currently_animating)
    return false;
  if (lhs.flattens_inherited_transform < rhs.flattens_inherited_transform)
    return true;
  if (rhs.flattens_inherited_transform < lhs.flattens_inherited_transform)
    return false;
  if (lhs.scrolls < rhs.scrolls)
    return true;
  if (rhs.scrolls < lhs.scrolls)
    return false;
  if (lhs.should_undo_overscroll < rhs.should_undo_overscroll)
    return true;
  if (rhs.should_undo_overscroll < lhs.should_undo_overscroll)
    return false;
  if (lhs.should_be_snapped < rhs.should_be_snapped)
    return true;
  if (rhs.should_be_snapped < lhs.should_be_snapped)
    return false;
  if (lhs.moved_by_outer_viewport_bounds_delta_y < rhs.moved_by_outer_viewport_bounds_delta_y)
    return true;
  if (rhs.moved_by_outer_viewport_bounds_delta_y < lhs.moved_by_outer_viewport_bounds_delta_y)
    return false;
  if (lhs.in_subtree_of_page_scale_layer < rhs.in_subtree_of_page_scale_layer)
    return true;
  if (rhs.in_subtree_of_page_scale_layer < lhs.in_subtree_of_page_scale_layer)
    return false;
  if (lhs.transform_changed < rhs.transform_changed)
    return true;
  if (rhs.transform_changed < lhs.transform_changed)
    return false;
  if (lhs.delegates_to_parent_for_backface < rhs.delegates_to_parent_for_backface)
    return true;
  if (rhs.delegates_to_parent_for_backface < lhs.delegates_to_parent_for_backface)
    return false;
  if (lhs.will_change_transform < rhs.will_change_transform)
    return true;
  if (rhs.will_change_transform < lhs.will_change_transform)
    return false;
  if (lhs.maximum_animation_scale < rhs.maximum_animation_scale)
    return true;
  if (rhs.maximum_animation_scale < lhs.maximum_animation_scale)
    return false;
  if (lhs.node_and_ancestors_are_animated_or_invertible < rhs.node_and_ancestors_are_animated_or_invertible)
    return true;
  if (rhs.node_and_ancestors_are_animated_or_invertible < lhs.node_and_ancestors_are_animated_or_invertible)
    return false;
  if (lhs.is_invertible < rhs.is_invertible)
    return true;
  if (rhs.is_invertible < lhs.is_invertible)
    return false;
  if (lhs.ancestors_are_invertible < rhs.ancestors_are_invertible)
    return true;
  if (rhs.ancestors_are_invertible < lhs.ancestors_are_invertible)
    return false;
  if (lhs.node_and_ancestors_are_flat < rhs.node_and_ancestors_are_flat)
    return true;
  if (rhs.node_and_ancestors_are_flat < lhs.node_and_ancestors_are_flat)
    return false;
  if (lhs.node_or_ancestors_will_change_transform < rhs.node_or_ancestors_will_change_transform)
    return true;
  if (rhs.node_or_ancestors_will_change_transform < lhs.node_or_ancestors_will_change_transform)
    return false;
  if (lhs.visible_frame_element_id < rhs.visible_frame_element_id)
    return true;
  if (rhs.visible_frame_element_id < lhs.visible_frame_element_id)
    return false;
  if (lhs.damage_reasons_bit_mask < rhs.damage_reasons_bit_mask)
    return true;
  if (rhs.damage_reasons_bit_mask < lhs.damage_reasons_bit_mask)
    return false;
  if (lhs.moved_by_safe_area_bottom < rhs.moved_by_safe_area_bottom)
    return true;
  if (rhs.moved_by_safe_area_bottom < lhs.moved_by_safe_area_bottom)
    return false;
  return false;
}
template <typename StructPtrType>
ClipNodePtr ClipNode::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(parent_id),
      mojo::Clone(transform_id),
      mojo::Clone(clip),
      mojo::Clone(pixel_moving_filter_id)
  );
}

template <typename T, ClipNode::EnableIfSame<T>*>
bool ClipNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->parent_id, other_struct.parent_id))
    return false;
  if (!mojo::Equals(this->transform_id, other_struct.transform_id))
    return false;
  if (!mojo::Equals(this->clip, other_struct.clip))
    return false;
  if (!mojo::Equals(this->pixel_moving_filter_id, other_struct.pixel_moving_filter_id))
    return false;
  return true;
}

template <typename T, ClipNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.parent_id < rhs.parent_id)
    return true;
  if (rhs.parent_id < lhs.parent_id)
    return false;
  if (lhs.transform_id < rhs.transform_id)
    return true;
  if (rhs.transform_id < lhs.transform_id)
    return false;
  if (lhs.clip < rhs.clip)
    return true;
  if (rhs.clip < lhs.clip)
    return false;
  if (lhs.pixel_moving_filter_id < rhs.pixel_moving_filter_id)
    return true;
  if (rhs.pixel_moving_filter_id < lhs.pixel_moving_filter_id)
    return false;
  return false;
}
template <typename StructPtrType>
EffectNodePtr EffectNode::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(parent_id),
      mojo::Clone(transform_id),
      mojo::Clone(clip_id),
      mojo::Clone(element_id),
      mojo::Clone(opacity),
      mojo::Clone(render_surface_reason),
      mojo::Clone(surface_contents_scale),
      mojo::Clone(subtree_capture_id),
      mojo::Clone(subtree_size),
      mojo::Clone(blend_mode),
      mojo::Clone(target_id),
      mojo::Clone(view_transition_target_id),
      mojo::Clone(closest_ancestor_with_cached_render_surface_id),
      mojo::Clone(closest_ancestor_with_copy_request_id),
      mojo::Clone(closest_ancestor_being_captured_id),
      mojo::Clone(closest_ancestor_with_shared_element_id),
      mojo::Clone(view_transition_element_resource_id),
      mojo::Clone(filters),
      mojo::Clone(backdrop_filters),
      mojo::Clone(backdrop_filter_bounds),
      mojo::Clone(backdrop_filter_quality),
      mojo::Clone(backdrop_mask_element_id),
      mojo::Clone(mask_filter_info),
      mojo::Clone(cache_render_surface),
      mojo::Clone(double_sided),
      mojo::Clone(trilinear_filtering),
      mojo::Clone(subtree_hidden),
      mojo::Clone(has_potential_filter_animation),
      mojo::Clone(has_potential_backdrop_filter_animation),
      mojo::Clone(has_potential_opacity_animation),
      mojo::Clone(subtree_has_copy_request),
      mojo::Clone(is_fast_rounded_corner),
      mojo::Clone(may_have_backdrop_effect),
      mojo::Clone(needs_effect_for_2d_scale_transform),
      mojo::Clone(copy_output_requests)
  );
}

template <typename T, EffectNode::EnableIfSame<T>*>
bool EffectNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->parent_id, other_struct.parent_id))
    return false;
  if (!mojo::Equals(this->transform_id, other_struct.transform_id))
    return false;
  if (!mojo::Equals(this->clip_id, other_struct.clip_id))
    return false;
  if (!mojo::Equals(this->element_id, other_struct.element_id))
    return false;
  if (!mojo::Equals(this->opacity, other_struct.opacity))
    return false;
  if (!mojo::Equals(this->render_surface_reason, other_struct.render_surface_reason))
    return false;
  if (!mojo::Equals(this->surface_contents_scale, other_struct.surface_contents_scale))
    return false;
  if (!mojo::Equals(this->subtree_capture_id, other_struct.subtree_capture_id))
    return false;
  if (!mojo::Equals(this->subtree_size, other_struct.subtree_size))
    return false;
  if (!mojo::Equals(this->blend_mode, other_struct.blend_mode))
    return false;
  if (!mojo::Equals(this->target_id, other_struct.target_id))
    return false;
  if (!mojo::Equals(this->view_transition_target_id, other_struct.view_transition_target_id))
    return false;
  if (!mojo::Equals(this->closest_ancestor_with_cached_render_surface_id, other_struct.closest_ancestor_with_cached_render_surface_id))
    return false;
  if (!mojo::Equals(this->closest_ancestor_with_copy_request_id, other_struct.closest_ancestor_with_copy_request_id))
    return false;
  if (!mojo::Equals(this->closest_ancestor_being_captured_id, other_struct.closest_ancestor_being_captured_id))
    return false;
  if (!mojo::Equals(this->closest_ancestor_with_shared_element_id, other_struct.closest_ancestor_with_shared_element_id))
    return false;
  if (!mojo::Equals(this->view_transition_element_resource_id, other_struct.view_transition_element_resource_id))
    return false;
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  if (!mojo::Equals(this->backdrop_filters, other_struct.backdrop_filters))
    return false;
  if (!mojo::Equals(this->backdrop_filter_bounds, other_struct.backdrop_filter_bounds))
    return false;
  if (!mojo::Equals(this->backdrop_filter_quality, other_struct.backdrop_filter_quality))
    return false;
  if (!mojo::Equals(this->backdrop_mask_element_id, other_struct.backdrop_mask_element_id))
    return false;
  if (!mojo::Equals(this->mask_filter_info, other_struct.mask_filter_info))
    return false;
  if (!mojo::Equals(this->cache_render_surface, other_struct.cache_render_surface))
    return false;
  if (!mojo::Equals(this->double_sided, other_struct.double_sided))
    return false;
  if (!mojo::Equals(this->trilinear_filtering, other_struct.trilinear_filtering))
    return false;
  if (!mojo::Equals(this->subtree_hidden, other_struct.subtree_hidden))
    return false;
  if (!mojo::Equals(this->has_potential_filter_animation, other_struct.has_potential_filter_animation))
    return false;
  if (!mojo::Equals(this->has_potential_backdrop_filter_animation, other_struct.has_potential_backdrop_filter_animation))
    return false;
  if (!mojo::Equals(this->has_potential_opacity_animation, other_struct.has_potential_opacity_animation))
    return false;
  if (!mojo::Equals(this->subtree_has_copy_request, other_struct.subtree_has_copy_request))
    return false;
  if (!mojo::Equals(this->is_fast_rounded_corner, other_struct.is_fast_rounded_corner))
    return false;
  if (!mojo::Equals(this->may_have_backdrop_effect, other_struct.may_have_backdrop_effect))
    return false;
  if (!mojo::Equals(this->needs_effect_for_2d_scale_transform, other_struct.needs_effect_for_2d_scale_transform))
    return false;
  if (!mojo::Equals(this->copy_output_requests, other_struct.copy_output_requests))
    return false;
  return true;
}

template <typename T, EffectNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.parent_id < rhs.parent_id)
    return true;
  if (rhs.parent_id < lhs.parent_id)
    return false;
  if (lhs.transform_id < rhs.transform_id)
    return true;
  if (rhs.transform_id < lhs.transform_id)
    return false;
  if (lhs.clip_id < rhs.clip_id)
    return true;
  if (rhs.clip_id < lhs.clip_id)
    return false;
  if (lhs.element_id < rhs.element_id)
    return true;
  if (rhs.element_id < lhs.element_id)
    return false;
  if (lhs.opacity < rhs.opacity)
    return true;
  if (rhs.opacity < lhs.opacity)
    return false;
  if (lhs.render_surface_reason < rhs.render_surface_reason)
    return true;
  if (rhs.render_surface_reason < lhs.render_surface_reason)
    return false;
  if (lhs.surface_contents_scale < rhs.surface_contents_scale)
    return true;
  if (rhs.surface_contents_scale < lhs.surface_contents_scale)
    return false;
  if (lhs.subtree_capture_id < rhs.subtree_capture_id)
    return true;
  if (rhs.subtree_capture_id < lhs.subtree_capture_id)
    return false;
  if (lhs.subtree_size < rhs.subtree_size)
    return true;
  if (rhs.subtree_size < lhs.subtree_size)
    return false;
  if (lhs.blend_mode < rhs.blend_mode)
    return true;
  if (rhs.blend_mode < lhs.blend_mode)
    return false;
  if (lhs.target_id < rhs.target_id)
    return true;
  if (rhs.target_id < lhs.target_id)
    return false;
  if (lhs.view_transition_target_id < rhs.view_transition_target_id)
    return true;
  if (rhs.view_transition_target_id < lhs.view_transition_target_id)
    return false;
  if (lhs.closest_ancestor_with_cached_render_surface_id < rhs.closest_ancestor_with_cached_render_surface_id)
    return true;
  if (rhs.closest_ancestor_with_cached_render_surface_id < lhs.closest_ancestor_with_cached_render_surface_id)
    return false;
  if (lhs.closest_ancestor_with_copy_request_id < rhs.closest_ancestor_with_copy_request_id)
    return true;
  if (rhs.closest_ancestor_with_copy_request_id < lhs.closest_ancestor_with_copy_request_id)
    return false;
  if (lhs.closest_ancestor_being_captured_id < rhs.closest_ancestor_being_captured_id)
    return true;
  if (rhs.closest_ancestor_being_captured_id < lhs.closest_ancestor_being_captured_id)
    return false;
  if (lhs.closest_ancestor_with_shared_element_id < rhs.closest_ancestor_with_shared_element_id)
    return true;
  if (rhs.closest_ancestor_with_shared_element_id < lhs.closest_ancestor_with_shared_element_id)
    return false;
  if (lhs.view_transition_element_resource_id < rhs.view_transition_element_resource_id)
    return true;
  if (rhs.view_transition_element_resource_id < lhs.view_transition_element_resource_id)
    return false;
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  if (lhs.backdrop_filters < rhs.backdrop_filters)
    return true;
  if (rhs.backdrop_filters < lhs.backdrop_filters)
    return false;
  if (lhs.backdrop_filter_bounds < rhs.backdrop_filter_bounds)
    return true;
  if (rhs.backdrop_filter_bounds < lhs.backdrop_filter_bounds)
    return false;
  if (lhs.backdrop_filter_quality < rhs.backdrop_filter_quality)
    return true;
  if (rhs.backdrop_filter_quality < lhs.backdrop_filter_quality)
    return false;
  if (lhs.backdrop_mask_element_id < rhs.backdrop_mask_element_id)
    return true;
  if (rhs.backdrop_mask_element_id < lhs.backdrop_mask_element_id)
    return false;
  if (lhs.mask_filter_info < rhs.mask_filter_info)
    return true;
  if (rhs.mask_filter_info < lhs.mask_filter_info)
    return false;
  if (lhs.cache_render_surface < rhs.cache_render_surface)
    return true;
  if (rhs.cache_render_surface < lhs.cache_render_surface)
    return false;
  if (lhs.double_sided < rhs.double_sided)
    return true;
  if (rhs.double_sided < lhs.double_sided)
    return false;
  if (lhs.trilinear_filtering < rhs.trilinear_filtering)
    return true;
  if (rhs.trilinear_filtering < lhs.trilinear_filtering)
    return false;
  if (lhs.subtree_hidden < rhs.subtree_hidden)
    return true;
  if (rhs.subtree_hidden < lhs.subtree_hidden)
    return false;
  if (lhs.has_potential_filter_animation < rhs.has_potential_filter_animation)
    return true;
  if (rhs.has_potential_filter_animation < lhs.has_potential_filter_animation)
    return false;
  if (lhs.has_potential_backdrop_filter_animation < rhs.has_potential_backdrop_filter_animation)
    return true;
  if (rhs.has_potential_backdrop_filter_animation < lhs.has_potential_backdrop_filter_animation)
    return false;
  if (lhs.has_potential_opacity_animation < rhs.has_potential_opacity_animation)
    return true;
  if (rhs.has_potential_opacity_animation < lhs.has_potential_opacity_animation)
    return false;
  if (lhs.subtree_has_copy_request < rhs.subtree_has_copy_request)
    return true;
  if (rhs.subtree_has_copy_request < lhs.subtree_has_copy_request)
    return false;
  if (lhs.is_fast_rounded_corner < rhs.is_fast_rounded_corner)
    return true;
  if (rhs.is_fast_rounded_corner < lhs.is_fast_rounded_corner)
    return false;
  if (lhs.may_have_backdrop_effect < rhs.may_have_backdrop_effect)
    return true;
  if (rhs.may_have_backdrop_effect < lhs.may_have_backdrop_effect)
    return false;
  if (lhs.needs_effect_for_2d_scale_transform < rhs.needs_effect_for_2d_scale_transform)
    return true;
  if (rhs.needs_effect_for_2d_scale_transform < lhs.needs_effect_for_2d_scale_transform)
    return false;
  if (lhs.copy_output_requests < rhs.copy_output_requests)
    return true;
  if (rhs.copy_output_requests < lhs.copy_output_requests)
    return false;
  return false;
}
template <typename StructPtrType>
ScrollTreeUpdatePtr ScrollTreeUpdate::Clone() const {
  return New(
      mojo::Clone(synced_scroll_offsets),
      mojo::Clone(scrolling_contents_cull_rects),
      mojo::Clone(elastic_overscroll)
  );
}

template <typename T, ScrollTreeUpdate::EnableIfSame<T>*>
bool ScrollTreeUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->synced_scroll_offsets, other_struct.synced_scroll_offsets))
    return false;
  if (!mojo::Equals(this->scrolling_contents_cull_rects, other_struct.scrolling_contents_cull_rects))
    return false;
  if (!mojo::Equals(this->elastic_overscroll, other_struct.elastic_overscroll))
    return false;
  return true;
}

template <typename T, ScrollTreeUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.synced_scroll_offsets < rhs.synced_scroll_offsets)
    return true;
  if (rhs.synced_scroll_offsets < lhs.synced_scroll_offsets)
    return false;
  if (lhs.scrolling_contents_cull_rects < rhs.scrolling_contents_cull_rects)
    return true;
  if (rhs.scrolling_contents_cull_rects < lhs.scrolling_contents_cull_rects)
    return false;
  if (lhs.elastic_overscroll < rhs.elastic_overscroll)
    return true;
  if (rhs.elastic_overscroll < lhs.elastic_overscroll)
    return false;
  return false;
}
template <typename StructPtrType>
ScrollNodePtr ScrollNode::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(parent_id),
      mojo::Clone(transform_id),
      mojo::Clone(container_bounds),
      mojo::Clone(bounds),
      mojo::Clone(element_id),
      mojo::Clone(max_scroll_offset_affected_by_page_scale),
      mojo::Clone(scrolls_inner_viewport),
      mojo::Clone(scrolls_outer_viewport),
      mojo::Clone(prevent_viewport_scrolling_from_inner),
      mojo::Clone(user_scrollable_horizontal),
      mojo::Clone(user_scrollable_vertical),
      mojo::Clone(is_composited)
  );
}

template <typename T, ScrollNode::EnableIfSame<T>*>
bool ScrollNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->parent_id, other_struct.parent_id))
    return false;
  if (!mojo::Equals(this->transform_id, other_struct.transform_id))
    return false;
  if (!mojo::Equals(this->container_bounds, other_struct.container_bounds))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->element_id, other_struct.element_id))
    return false;
  if (!mojo::Equals(this->max_scroll_offset_affected_by_page_scale, other_struct.max_scroll_offset_affected_by_page_scale))
    return false;
  if (!mojo::Equals(this->scrolls_inner_viewport, other_struct.scrolls_inner_viewport))
    return false;
  if (!mojo::Equals(this->scrolls_outer_viewport, other_struct.scrolls_outer_viewport))
    return false;
  if (!mojo::Equals(this->prevent_viewport_scrolling_from_inner, other_struct.prevent_viewport_scrolling_from_inner))
    return false;
  if (!mojo::Equals(this->user_scrollable_horizontal, other_struct.user_scrollable_horizontal))
    return false;
  if (!mojo::Equals(this->user_scrollable_vertical, other_struct.user_scrollable_vertical))
    return false;
  if (!mojo::Equals(this->is_composited, other_struct.is_composited))
    return false;
  return true;
}

template <typename T, ScrollNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.parent_id < rhs.parent_id)
    return true;
  if (rhs.parent_id < lhs.parent_id)
    return false;
  if (lhs.transform_id < rhs.transform_id)
    return true;
  if (rhs.transform_id < lhs.transform_id)
    return false;
  if (lhs.container_bounds < rhs.container_bounds)
    return true;
  if (rhs.container_bounds < lhs.container_bounds)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.element_id < rhs.element_id)
    return true;
  if (rhs.element_id < lhs.element_id)
    return false;
  if (lhs.max_scroll_offset_affected_by_page_scale < rhs.max_scroll_offset_affected_by_page_scale)
    return true;
  if (rhs.max_scroll_offset_affected_by_page_scale < lhs.max_scroll_offset_affected_by_page_scale)
    return false;
  if (lhs.scrolls_inner_viewport < rhs.scrolls_inner_viewport)
    return true;
  if (rhs.scrolls_inner_viewport < lhs.scrolls_inner_viewport)
    return false;
  if (lhs.scrolls_outer_viewport < rhs.scrolls_outer_viewport)
    return true;
  if (rhs.scrolls_outer_viewport < lhs.scrolls_outer_viewport)
    return false;
  if (lhs.prevent_viewport_scrolling_from_inner < rhs.prevent_viewport_scrolling_from_inner)
    return true;
  if (rhs.prevent_viewport_scrolling_from_inner < lhs.prevent_viewport_scrolling_from_inner)
    return false;
  if (lhs.user_scrollable_horizontal < rhs.user_scrollable_horizontal)
    return true;
  if (rhs.user_scrollable_horizontal < lhs.user_scrollable_horizontal)
    return false;
  if (lhs.user_scrollable_vertical < rhs.user_scrollable_vertical)
    return true;
  if (rhs.user_scrollable_vertical < lhs.user_scrollable_vertical)
    return false;
  if (lhs.is_composited < rhs.is_composited)
    return true;
  if (rhs.is_composited < lhs.is_composited)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::RareProperties::DataView,
                                         ::viz::mojom::blink::RarePropertiesPtr> {
  static bool IsNull(const ::viz::mojom::blink::RarePropertiesPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::RarePropertiesPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::RareProperties::filter_quality) filter_quality(
      const ::viz::mojom::blink::RarePropertiesPtr& input) {
    return input->filter_quality;
  }

  static const decltype(::viz::mojom::blink::RareProperties::dynamic_range_limit)& dynamic_range_limit(
      const ::viz::mojom::blink::RarePropertiesPtr& input) {
    return input->dynamic_range_limit;
  }

  static const decltype(::viz::mojom::blink::RareProperties::capture_bounds)& capture_bounds(
      const ::viz::mojom::blink::RarePropertiesPtr& input) {
    return input->capture_bounds;
  }

  static bool Read(::viz::mojom::blink::RareProperties::DataView input, ::viz::mojom::blink::RarePropertiesPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::MirrorLayerExtra::DataView,
                                         ::viz::mojom::blink::MirrorLayerExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::MirrorLayerExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::MirrorLayerExtraPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::MirrorLayerExtra::mirrored_layer_id) mirrored_layer_id(
      const ::viz::mojom::blink::MirrorLayerExtraPtr& input) {
    return input->mirrored_layer_id;
  }

  static bool Read(::viz::mojom::blink::MirrorLayerExtra::DataView input, ::viz::mojom::blink::MirrorLayerExtraPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::SurfaceLayerExtra::DataView,
                                         ::viz::mojom::blink::SurfaceLayerExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::SurfaceLayerExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::SurfaceLayerExtraPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::SurfaceLayerExtra::surface_range)& surface_range(
      const ::viz::mojom::blink::SurfaceLayerExtraPtr& input) {
    return input->surface_range;
  }

  static decltype(::viz::mojom::blink::SurfaceLayerExtra::deadline_in_frames) deadline_in_frames(
      const ::viz::mojom::blink::SurfaceLayerExtraPtr& input) {
    return input->deadline_in_frames;
  }

  static decltype(::viz::mojom::blink::SurfaceLayerExtra::stretch_content_to_fill_bounds) stretch_content_to_fill_bounds(
      const ::viz::mojom::blink::SurfaceLayerExtraPtr& input) {
    return input->stretch_content_to_fill_bounds;
  }

  static decltype(::viz::mojom::blink::SurfaceLayerExtra::surface_hit_testable) surface_hit_testable(
      const ::viz::mojom::blink::SurfaceLayerExtraPtr& input) {
    return input->surface_hit_testable;
  }

  static decltype(::viz::mojom::blink::SurfaceLayerExtra::has_pointer_events_none) has_pointer_events_none(
      const ::viz::mojom::blink::SurfaceLayerExtraPtr& input) {
    return input->has_pointer_events_none;
  }

  static decltype(::viz::mojom::blink::SurfaceLayerExtra::is_reflection) is_reflection(
      const ::viz::mojom::blink::SurfaceLayerExtraPtr& input) {
    return input->is_reflection;
  }

  static decltype(::viz::mojom::blink::SurfaceLayerExtra::will_draw_needs_reset) will_draw_needs_reset(
      const ::viz::mojom::blink::SurfaceLayerExtraPtr& input) {
    return input->will_draw_needs_reset;
  }

  static decltype(::viz::mojom::blink::SurfaceLayerExtra::override_child_paint_flags) override_child_paint_flags(
      const ::viz::mojom::blink::SurfaceLayerExtraPtr& input) {
    return input->override_child_paint_flags;
  }

  static bool Read(::viz::mojom::blink::SurfaceLayerExtra::DataView input, ::viz::mojom::blink::SurfaceLayerExtraPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::TextureLayerExtra::DataView,
                                         ::viz::mojom::blink::TextureLayerExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::TextureLayerExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TextureLayerExtraPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::TextureLayerExtra::blend_background_color) blend_background_color(
      const ::viz::mojom::blink::TextureLayerExtraPtr& input) {
    return input->blend_background_color;
  }

  static decltype(::viz::mojom::blink::TextureLayerExtra::force_texture_to_opaque) force_texture_to_opaque(
      const ::viz::mojom::blink::TextureLayerExtraPtr& input) {
    return input->force_texture_to_opaque;
  }

  static const decltype(::viz::mojom::blink::TextureLayerExtra::uv_top_left)& uv_top_left(
      const ::viz::mojom::blink::TextureLayerExtraPtr& input) {
    return input->uv_top_left;
  }

  static const decltype(::viz::mojom::blink::TextureLayerExtra::uv_bottom_right)& uv_bottom_right(
      const ::viz::mojom::blink::TextureLayerExtraPtr& input) {
    return input->uv_bottom_right;
  }

  static const decltype(::viz::mojom::blink::TextureLayerExtra::transferable_resource)& transferable_resource(
      const ::viz::mojom::blink::TextureLayerExtraPtr& input) {
    return input->transferable_resource;
  }

  static bool Read(::viz::mojom::blink::TextureLayerExtra::DataView input, ::viz::mojom::blink::TextureLayerExtraPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::UIResourceLayerExtra::DataView,
                                         ::viz::mojom::blink::UIResourceLayerExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::UIResourceLayerExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::UIResourceLayerExtraPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::UIResourceLayerExtra::ui_resource_id)& ui_resource_id(
      const ::viz::mojom::blink::UIResourceLayerExtraPtr& input) {
    return input->ui_resource_id;
  }

  static const decltype(::viz::mojom::blink::UIResourceLayerExtra::image_bounds)& image_bounds(
      const ::viz::mojom::blink::UIResourceLayerExtraPtr& input) {
    return input->image_bounds;
  }

  static const decltype(::viz::mojom::blink::UIResourceLayerExtra::uv_top_left)& uv_top_left(
      const ::viz::mojom::blink::UIResourceLayerExtraPtr& input) {
    return input->uv_top_left;
  }

  static const decltype(::viz::mojom::blink::UIResourceLayerExtra::uv_bottom_right)& uv_bottom_right(
      const ::viz::mojom::blink::UIResourceLayerExtraPtr& input) {
    return input->uv_bottom_right;
  }

  static bool Read(::viz::mojom::blink::UIResourceLayerExtra::DataView input, ::viz::mojom::blink::UIResourceLayerExtraPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::TileDisplayLayerExtra::DataView,
                                         ::viz::mojom::blink::TileDisplayLayerExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::TileDisplayLayerExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TileDisplayLayerExtraPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::TileDisplayLayerExtra::solid_color)& solid_color(
      const ::viz::mojom::blink::TileDisplayLayerExtraPtr& input) {
    return input->solid_color;
  }

  static decltype(::viz::mojom::blink::TileDisplayLayerExtra::is_backdrop_filter_mask) is_backdrop_filter_mask(
      const ::viz::mojom::blink::TileDisplayLayerExtraPtr& input) {
    return input->is_backdrop_filter_mask;
  }

  static decltype(::viz::mojom::blink::TileDisplayLayerExtra::is_directly_composited_image) is_directly_composited_image(
      const ::viz::mojom::blink::TileDisplayLayerExtraPtr& input) {
    return input->is_directly_composited_image;
  }

  static decltype(::viz::mojom::blink::TileDisplayLayerExtra::nearest_neighbor) nearest_neighbor(
      const ::viz::mojom::blink::TileDisplayLayerExtraPtr& input) {
    return input->nearest_neighbor;
  }

  static decltype(::viz::mojom::blink::TileDisplayLayerExtra::content_color_usage) content_color_usage(
      const ::viz::mojom::blink::TileDisplayLayerExtraPtr& input) {
    return input->content_color_usage;
  }

  static bool Read(::viz::mojom::blink::TileDisplayLayerExtra::DataView input, ::viz::mojom::blink::TileDisplayLayerExtraPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::ScrollbarLayerBaseExtra::DataView,
                                         ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::ScrollbarLayerBaseExtraPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::ScrollbarLayerBaseExtra::scroll_element_id)& scroll_element_id(
      const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) {
    return input->scroll_element_id;
  }

  static decltype(::viz::mojom::blink::ScrollbarLayerBaseExtra::is_overlay_scrollbar) is_overlay_scrollbar(
      const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) {
    return input->is_overlay_scrollbar;
  }

  static decltype(::viz::mojom::blink::ScrollbarLayerBaseExtra::is_web_test) is_web_test(
      const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) {
    return input->is_web_test;
  }

  static decltype(::viz::mojom::blink::ScrollbarLayerBaseExtra::thumb_thickness_scale_factor) thumb_thickness_scale_factor(
      const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) {
    return input->thumb_thickness_scale_factor;
  }

  static decltype(::viz::mojom::blink::ScrollbarLayerBaseExtra::current_pos) current_pos(
      const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) {
    return input->current_pos;
  }

  static decltype(::viz::mojom::blink::ScrollbarLayerBaseExtra::clip_layer_length) clip_layer_length(
      const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) {
    return input->clip_layer_length;
  }

  static decltype(::viz::mojom::blink::ScrollbarLayerBaseExtra::scroll_layer_length) scroll_layer_length(
      const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) {
    return input->scroll_layer_length;
  }

  static decltype(::viz::mojom::blink::ScrollbarLayerBaseExtra::is_horizontal_orientation) is_horizontal_orientation(
      const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) {
    return input->is_horizontal_orientation;
  }

  static decltype(::viz::mojom::blink::ScrollbarLayerBaseExtra::is_left_side_vertical_scrollbar) is_left_side_vertical_scrollbar(
      const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) {
    return input->is_left_side_vertical_scrollbar;
  }

  static decltype(::viz::mojom::blink::ScrollbarLayerBaseExtra::vertical_adjust) vertical_adjust(
      const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) {
    return input->vertical_adjust;
  }

  static decltype(::viz::mojom::blink::ScrollbarLayerBaseExtra::has_find_in_page_tickmarks) has_find_in_page_tickmarks(
      const ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr& input) {
    return input->has_find_in_page_tickmarks;
  }

  static bool Read(::viz::mojom::blink::ScrollbarLayerBaseExtra::DataView input, ::viz::mojom::blink::ScrollbarLayerBaseExtraPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::NinePatchThumbScrollbarLayerExtra::DataView,
                                         ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::NinePatchThumbScrollbarLayerExtra::scrollbar_base_extra)& scrollbar_base_extra(
      const ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr& input) {
    return input->scrollbar_base_extra;
  }

  static decltype(::viz::mojom::blink::NinePatchThumbScrollbarLayerExtra::thumb_thickness) thumb_thickness(
      const ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr& input) {
    return input->thumb_thickness;
  }

  static decltype(::viz::mojom::blink::NinePatchThumbScrollbarLayerExtra::thumb_length) thumb_length(
      const ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr& input) {
    return input->thumb_length;
  }

  static decltype(::viz::mojom::blink::NinePatchThumbScrollbarLayerExtra::track_start) track_start(
      const ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr& input) {
    return input->track_start;
  }

  static decltype(::viz::mojom::blink::NinePatchThumbScrollbarLayerExtra::track_length) track_length(
      const ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr& input) {
    return input->track_length;
  }

  static const decltype(::viz::mojom::blink::NinePatchThumbScrollbarLayerExtra::image_bounds)& image_bounds(
      const ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr& input) {
    return input->image_bounds;
  }

  static const decltype(::viz::mojom::blink::NinePatchThumbScrollbarLayerExtra::aperture)& aperture(
      const ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr& input) {
    return input->aperture;
  }

  static const decltype(::viz::mojom::blink::NinePatchThumbScrollbarLayerExtra::thumb_ui_resource_id)& thumb_ui_resource_id(
      const ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr& input) {
    return input->thumb_ui_resource_id;
  }

  static const decltype(::viz::mojom::blink::NinePatchThumbScrollbarLayerExtra::track_and_buttons_ui_resource_id)& track_and_buttons_ui_resource_id(
      const ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr& input) {
    return input->track_and_buttons_ui_resource_id;
  }

  static bool Read(::viz::mojom::blink::NinePatchThumbScrollbarLayerExtra::DataView input, ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::PaintedScrollbarLayerExtra::DataView,
                                         ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::PaintedScrollbarLayerExtraPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::scrollbar_base_extra)& scrollbar_base_extra(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->scrollbar_base_extra;
  }

  static decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::internal_contents_scale) internal_contents_scale(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->internal_contents_scale;
  }

  static const decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::internal_content_bounds)& internal_content_bounds(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->internal_content_bounds;
  }

  static decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::jump_on_track_click) jump_on_track_click(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->jump_on_track_click;
  }

  static decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::supports_drag_snap_back) supports_drag_snap_back(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->supports_drag_snap_back;
  }

  static decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::thumb_thickness) thumb_thickness(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->thumb_thickness;
  }

  static decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::thumb_length) thumb_length(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->thumb_length;
  }

  static const decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::back_button_rect)& back_button_rect(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->back_button_rect;
  }

  static const decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::forward_button_rect)& forward_button_rect(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->forward_button_rect;
  }

  static const decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::track_rect)& track_rect(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->track_rect;
  }

  static const decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::thumb_color)& thumb_color(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->thumb_color;
  }

  static decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::uses_nine_patch_track_and_buttons) uses_nine_patch_track_and_buttons(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->uses_nine_patch_track_and_buttons;
  }

  static const decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::track_and_buttons_image_bounds)& track_and_buttons_image_bounds(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->track_and_buttons_image_bounds;
  }

  static const decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::track_and_buttons_aperture)& track_and_buttons_aperture(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->track_and_buttons_aperture;
  }

  static decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::painted_opacity) painted_opacity(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->painted_opacity;
  }

  static const decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::track_and_buttons_ui_resource_id)& track_and_buttons_ui_resource_id(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->track_and_buttons_ui_resource_id;
  }

  static const decltype(::viz::mojom::blink::PaintedScrollbarLayerExtra::thumb_ui_resource_id)& thumb_ui_resource_id(
      const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& input) {
    return input->thumb_ui_resource_id;
  }

  static bool Read(::viz::mojom::blink::PaintedScrollbarLayerExtra::DataView input, ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::SolidColorScrollbarLayerExtra::DataView,
                                         ::viz::mojom::blink::SolidColorScrollbarLayerExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::SolidColorScrollbarLayerExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::SolidColorScrollbarLayerExtraPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::SolidColorScrollbarLayerExtra::scrollbar_base_extra)& scrollbar_base_extra(
      const ::viz::mojom::blink::SolidColorScrollbarLayerExtraPtr& input) {
    return input->scrollbar_base_extra;
  }

  static decltype(::viz::mojom::blink::SolidColorScrollbarLayerExtra::thumb_thickness) thumb_thickness(
      const ::viz::mojom::blink::SolidColorScrollbarLayerExtraPtr& input) {
    return input->thumb_thickness;
  }

  static decltype(::viz::mojom::blink::SolidColorScrollbarLayerExtra::track_start) track_start(
      const ::viz::mojom::blink::SolidColorScrollbarLayerExtraPtr& input) {
    return input->track_start;
  }

  static const decltype(::viz::mojom::blink::SolidColorScrollbarLayerExtra::color)& color(
      const ::viz::mojom::blink::SolidColorScrollbarLayerExtraPtr& input) {
    return input->color;
  }

  static bool Read(::viz::mojom::blink::SolidColorScrollbarLayerExtra::DataView input, ::viz::mojom::blink::SolidColorScrollbarLayerExtraPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::ViewTransitionContentLayerExtra::DataView,
                                         ::viz::mojom::blink::ViewTransitionContentLayerExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::ViewTransitionContentLayerExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::ViewTransitionContentLayerExtraPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::ViewTransitionContentLayerExtra::resource_id)& resource_id(
      const ::viz::mojom::blink::ViewTransitionContentLayerExtraPtr& input) {
    return input->resource_id;
  }

  static decltype(::viz::mojom::blink::ViewTransitionContentLayerExtra::is_live_content_layer) is_live_content_layer(
      const ::viz::mojom::blink::ViewTransitionContentLayerExtraPtr& input) {
    return input->is_live_content_layer;
  }

  static const decltype(::viz::mojom::blink::ViewTransitionContentLayerExtra::max_extents_rect)& max_extents_rect(
      const ::viz::mojom::blink::ViewTransitionContentLayerExtraPtr& input) {
    return input->max_extents_rect;
  }

  static bool Read(::viz::mojom::blink::ViewTransitionContentLayerExtra::DataView input, ::viz::mojom::blink::ViewTransitionContentLayerExtraPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::NinePatchLayerExtra::DataView,
                                         ::viz::mojom::blink::NinePatchLayerExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::NinePatchLayerExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::NinePatchLayerExtraPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::NinePatchLayerExtra::image_aperture)& image_aperture(
      const ::viz::mojom::blink::NinePatchLayerExtraPtr& input) {
    return input->image_aperture;
  }

  static const decltype(::viz::mojom::blink::NinePatchLayerExtra::border)& border(
      const ::viz::mojom::blink::NinePatchLayerExtraPtr& input) {
    return input->border;
  }

  static const decltype(::viz::mojom::blink::NinePatchLayerExtra::layer_occlusion)& layer_occlusion(
      const ::viz::mojom::blink::NinePatchLayerExtraPtr& input) {
    return input->layer_occlusion;
  }

  static decltype(::viz::mojom::blink::NinePatchLayerExtra::fill_center) fill_center(
      const ::viz::mojom::blink::NinePatchLayerExtraPtr& input) {
    return input->fill_center;
  }

  static const decltype(::viz::mojom::blink::NinePatchLayerExtra::ui_resource_id)& ui_resource_id(
      const ::viz::mojom::blink::NinePatchLayerExtraPtr& input) {
    return input->ui_resource_id;
  }

  static const decltype(::viz::mojom::blink::NinePatchLayerExtra::image_bounds)& image_bounds(
      const ::viz::mojom::blink::NinePatchLayerExtraPtr& input) {
    return input->image_bounds;
  }

  static const decltype(::viz::mojom::blink::NinePatchLayerExtra::uv_top_left)& uv_top_left(
      const ::viz::mojom::blink::NinePatchLayerExtraPtr& input) {
    return input->uv_top_left;
  }

  static const decltype(::viz::mojom::blink::NinePatchLayerExtra::uv_bottom_right)& uv_bottom_right(
      const ::viz::mojom::blink::NinePatchLayerExtraPtr& input) {
    return input->uv_bottom_right;
  }

  static bool Read(::viz::mojom::blink::NinePatchLayerExtra::DataView input, ::viz::mojom::blink::NinePatchLayerExtraPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::Layer::DataView,
                                         ::viz::mojom::blink::LayerPtr> {
  static bool IsNull(const ::viz::mojom::blink::LayerPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::LayerPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::Layer::id) id(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->id;
  }

  static decltype(::viz::mojom::blink::Layer::type) type(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->type;
  }

  static const decltype(::viz::mojom::blink::Layer::bounds)& bounds(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->bounds;
  }

  static decltype(::viz::mojom::blink::Layer::contents_opaque) contents_opaque(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->contents_opaque;
  }

  static decltype(::viz::mojom::blink::Layer::contents_opaque_for_text) contents_opaque_for_text(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->contents_opaque_for_text;
  }

  static decltype(::viz::mojom::blink::Layer::is_drawable) is_drawable(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->is_drawable;
  }

  static decltype(::viz::mojom::blink::Layer::layer_property_changed_not_from_property_trees) layer_property_changed_not_from_property_trees(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->layer_property_changed_not_from_property_trees;
  }

  static decltype(::viz::mojom::blink::Layer::layer_property_changed_from_property_trees) layer_property_changed_from_property_trees(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->layer_property_changed_from_property_trees;
  }

  static decltype(::viz::mojom::blink::Layer::hit_test_opaqueness) hit_test_opaqueness(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->hit_test_opaqueness;
  }

  static const decltype(::viz::mojom::blink::Layer::background_color)& background_color(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->background_color;
  }

  static const decltype(::viz::mojom::blink::Layer::safe_opaque_background_color)& safe_opaque_background_color(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->safe_opaque_background_color;
  }

  static const decltype(::viz::mojom::blink::Layer::element_id)& element_id(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->element_id;
  }

  static const decltype(::viz::mojom::blink::Layer::update_rect)& update_rect(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->update_rect;
  }

  static const decltype(::viz::mojom::blink::Layer::offset_to_transform_parent)& offset_to_transform_parent(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->offset_to_transform_parent;
  }

  static decltype(::viz::mojom::blink::Layer::transform_tree_index) transform_tree_index(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->transform_tree_index;
  }

  static decltype(::viz::mojom::blink::Layer::clip_tree_index) clip_tree_index(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->clip_tree_index;
  }

  static decltype(::viz::mojom::blink::Layer::effect_tree_index) effect_tree_index(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->effect_tree_index;
  }

  static decltype(::viz::mojom::blink::Layer::scroll_tree_index) scroll_tree_index(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->scroll_tree_index;
  }

  static decltype(::viz::mojom::blink::Layer::should_check_backface_visibility) should_check_backface_visibility(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->should_check_backface_visibility;
  }

  static const decltype(::viz::mojom::blink::Layer::rare_properties)& rare_properties(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->rare_properties;
  }

  static const decltype(::viz::mojom::blink::Layer::layer_extra)& layer_extra(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->layer_extra;
  }

  static bool Read(::viz::mojom::blink::Layer::DataView input, ::viz::mojom::blink::LayerPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::AnchorPositionScrollData::DataView,
                                         ::viz::mojom::blink::AnchorPositionScrollDataPtr> {
  static bool IsNull(const ::viz::mojom::blink::AnchorPositionScrollDataPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::AnchorPositionScrollDataPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::AnchorPositionScrollData::adjustment_container_ids)& adjustment_container_ids(
      const ::viz::mojom::blink::AnchorPositionScrollDataPtr& input) {
    return input->adjustment_container_ids;
  }

  static const decltype(::viz::mojom::blink::AnchorPositionScrollData::accumulated_scroll_origin)& accumulated_scroll_origin(
      const ::viz::mojom::blink::AnchorPositionScrollDataPtr& input) {
    return input->accumulated_scroll_origin;
  }

  static decltype(::viz::mojom::blink::AnchorPositionScrollData::needs_scroll_adjustment_in_x) needs_scroll_adjustment_in_x(
      const ::viz::mojom::blink::AnchorPositionScrollDataPtr& input) {
    return input->needs_scroll_adjustment_in_x;
  }

  static decltype(::viz::mojom::blink::AnchorPositionScrollData::needs_scroll_adjustment_in_y) needs_scroll_adjustment_in_y(
      const ::viz::mojom::blink::AnchorPositionScrollDataPtr& input) {
    return input->needs_scroll_adjustment_in_y;
  }

  static bool Read(::viz::mojom::blink::AnchorPositionScrollData::DataView input, ::viz::mojom::blink::AnchorPositionScrollDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::StickyPositionNodeData::DataView,
                                         ::viz::mojom::blink::StickyPositionNodeDataPtr> {
  static bool IsNull(const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::StickyPositionNodeDataPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::scroll_ancestor) scroll_ancestor(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->scroll_ancestor;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::is_anchored_left) is_anchored_left(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->is_anchored_left;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::is_anchored_right) is_anchored_right(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->is_anchored_right;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::is_anchored_top) is_anchored_top(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->is_anchored_top;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::is_anchored_bottom) is_anchored_bottom(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->is_anchored_bottom;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::left_offset) left_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->left_offset;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::right_offset) right_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->right_offset;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::top_offset) top_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->top_offset;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::bottom_offset) bottom_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->bottom_offset;
  }

  static const decltype(::viz::mojom::blink::StickyPositionNodeData::constraint_box_rect)& constraint_box_rect(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->constraint_box_rect;
  }

  static const decltype(::viz::mojom::blink::StickyPositionNodeData::scroll_container_relative_sticky_box_rect)& scroll_container_relative_sticky_box_rect(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->scroll_container_relative_sticky_box_rect;
  }

  static const decltype(::viz::mojom::blink::StickyPositionNodeData::scroll_container_relative_containing_block_rect)& scroll_container_relative_containing_block_rect(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->scroll_container_relative_containing_block_rect;
  }

  static const decltype(::viz::mojom::blink::StickyPositionNodeData::pixel_snap_offset)& pixel_snap_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->pixel_snap_offset;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::nearest_node_shifting_sticky_box) nearest_node_shifting_sticky_box(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->nearest_node_shifting_sticky_box;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::nearest_node_shifting_containing_block) nearest_node_shifting_containing_block(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->nearest_node_shifting_containing_block;
  }

  static const decltype(::viz::mojom::blink::StickyPositionNodeData::total_sticky_box_sticky_offset)& total_sticky_box_sticky_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->total_sticky_box_sticky_offset;
  }

  static const decltype(::viz::mojom::blink::StickyPositionNodeData::total_containing_block_sticky_offset)& total_containing_block_sticky_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->total_containing_block_sticky_offset;
  }

  static bool Read(::viz::mojom::blink::StickyPositionNodeData::DataView input, ::viz::mojom::blink::StickyPositionNodeDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::TransformTreeUpdate::DataView,
                                         ::viz::mojom::blink::TransformTreeUpdatePtr> {
  static bool IsNull(const ::viz::mojom::blink::TransformTreeUpdatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TransformTreeUpdatePtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::TransformTreeUpdate::page_scale_factor) page_scale_factor(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->page_scale_factor;
  }

  static decltype(::viz::mojom::blink::TransformTreeUpdate::device_scale_factor) device_scale_factor(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->device_scale_factor;
  }

  static decltype(::viz::mojom::blink::TransformTreeUpdate::device_transform_scale_factor) device_transform_scale_factor(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->device_transform_scale_factor;
  }

  static const decltype(::viz::mojom::blink::TransformTreeUpdate::nodes_affected_by_outer_viewport_bounds_delta)& nodes_affected_by_outer_viewport_bounds_delta(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->nodes_affected_by_outer_viewport_bounds_delta;
  }

  static const decltype(::viz::mojom::blink::TransformTreeUpdate::nodes_affected_by_safe_area_bottom)& nodes_affected_by_safe_area_bottom(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->nodes_affected_by_safe_area_bottom;
  }

  static const decltype(::viz::mojom::blink::TransformTreeUpdate::sticky_position_data)& sticky_position_data(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->sticky_position_data;
  }

  static const decltype(::viz::mojom::blink::TransformTreeUpdate::anchor_position_scroll_data)& anchor_position_scroll_data(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->anchor_position_scroll_data;
  }

  static bool Read(::viz::mojom::blink::TransformTreeUpdate::DataView input, ::viz::mojom::blink::TransformTreeUpdatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::TransformNode::DataView,
                                         ::viz::mojom::blink::TransformNodePtr> {
  static bool IsNull(const ::viz::mojom::blink::TransformNodePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TransformNodePtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::TransformNode::id) id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->id;
  }

  static decltype(::viz::mojom::blink::TransformNode::parent_id) parent_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->parent_id;
  }

  static decltype(::viz::mojom::blink::TransformNode::parent_frame_id) parent_frame_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->parent_frame_id;
  }

  static const decltype(::viz::mojom::blink::TransformNode::element_id)& element_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->element_id;
  }

  static const decltype(::viz::mojom::blink::TransformNode::local)& local(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->local;
  }

  static const decltype(::viz::mojom::blink::TransformNode::origin)& origin(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->origin;
  }

  static const decltype(::viz::mojom::blink::TransformNode::post_translation)& post_translation(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->post_translation;
  }

  static const decltype(::viz::mojom::blink::TransformNode::to_parent)& to_parent(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->to_parent;
  }

  static const decltype(::viz::mojom::blink::TransformNode::scroll_offset)& scroll_offset(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->scroll_offset;
  }

  static const decltype(::viz::mojom::blink::TransformNode::snap_amount)& snap_amount(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->snap_amount;
  }

  static decltype(::viz::mojom::blink::TransformNode::sticky_position_constraint_id) sticky_position_constraint_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->sticky_position_constraint_id;
  }

  static decltype(::viz::mojom::blink::TransformNode::anchor_position_scroll_data_id) anchor_position_scroll_data_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->anchor_position_scroll_data_id;
  }

  static decltype(::viz::mojom::blink::TransformNode::sorting_context_id) sorting_context_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->sorting_context_id;
  }

  static decltype(::viz::mojom::blink::TransformNode::has_potential_animation) has_potential_animation(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->has_potential_animation;
  }

  static decltype(::viz::mojom::blink::TransformNode::is_currently_animating) is_currently_animating(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->is_currently_animating;
  }

  static decltype(::viz::mojom::blink::TransformNode::flattens_inherited_transform) flattens_inherited_transform(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->flattens_inherited_transform;
  }

  static decltype(::viz::mojom::blink::TransformNode::scrolls) scrolls(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->scrolls;
  }

  static decltype(::viz::mojom::blink::TransformNode::should_undo_overscroll) should_undo_overscroll(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->should_undo_overscroll;
  }

  static decltype(::viz::mojom::blink::TransformNode::should_be_snapped) should_be_snapped(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->should_be_snapped;
  }

  static decltype(::viz::mojom::blink::TransformNode::moved_by_outer_viewport_bounds_delta_y) moved_by_outer_viewport_bounds_delta_y(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->moved_by_outer_viewport_bounds_delta_y;
  }

  static decltype(::viz::mojom::blink::TransformNode::in_subtree_of_page_scale_layer) in_subtree_of_page_scale_layer(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->in_subtree_of_page_scale_layer;
  }

  static decltype(::viz::mojom::blink::TransformNode::transform_changed) transform_changed(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->transform_changed;
  }

  static decltype(::viz::mojom::blink::TransformNode::delegates_to_parent_for_backface) delegates_to_parent_for_backface(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->delegates_to_parent_for_backface;
  }

  static decltype(::viz::mojom::blink::TransformNode::will_change_transform) will_change_transform(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->will_change_transform;
  }

  static decltype(::viz::mojom::blink::TransformNode::maximum_animation_scale) maximum_animation_scale(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->maximum_animation_scale;
  }

  static decltype(::viz::mojom::blink::TransformNode::node_and_ancestors_are_animated_or_invertible) node_and_ancestors_are_animated_or_invertible(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->node_and_ancestors_are_animated_or_invertible;
  }

  static decltype(::viz::mojom::blink::TransformNode::is_invertible) is_invertible(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->is_invertible;
  }

  static decltype(::viz::mojom::blink::TransformNode::ancestors_are_invertible) ancestors_are_invertible(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->ancestors_are_invertible;
  }

  static decltype(::viz::mojom::blink::TransformNode::node_and_ancestors_are_flat) node_and_ancestors_are_flat(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->node_and_ancestors_are_flat;
  }

  static decltype(::viz::mojom::blink::TransformNode::node_or_ancestors_will_change_transform) node_or_ancestors_will_change_transform(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->node_or_ancestors_will_change_transform;
  }

  static const decltype(::viz::mojom::blink::TransformNode::visible_frame_element_id)& visible_frame_element_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->visible_frame_element_id;
  }

  static decltype(::viz::mojom::blink::TransformNode::damage_reasons_bit_mask) damage_reasons_bit_mask(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->damage_reasons_bit_mask;
  }

  static decltype(::viz::mojom::blink::TransformNode::moved_by_safe_area_bottom) moved_by_safe_area_bottom(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->moved_by_safe_area_bottom;
  }

  static bool Read(::viz::mojom::blink::TransformNode::DataView input, ::viz::mojom::blink::TransformNodePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::ClipNode::DataView,
                                         ::viz::mojom::blink::ClipNodePtr> {
  static bool IsNull(const ::viz::mojom::blink::ClipNodePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::ClipNodePtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::ClipNode::id) id(
      const ::viz::mojom::blink::ClipNodePtr& input) {
    return input->id;
  }

  static decltype(::viz::mojom::blink::ClipNode::parent_id) parent_id(
      const ::viz::mojom::blink::ClipNodePtr& input) {
    return input->parent_id;
  }

  static decltype(::viz::mojom::blink::ClipNode::transform_id) transform_id(
      const ::viz::mojom::blink::ClipNodePtr& input) {
    return input->transform_id;
  }

  static const decltype(::viz::mojom::blink::ClipNode::clip)& clip(
      const ::viz::mojom::blink::ClipNodePtr& input) {
    return input->clip;
  }

  static decltype(::viz::mojom::blink::ClipNode::pixel_moving_filter_id) pixel_moving_filter_id(
      const ::viz::mojom::blink::ClipNodePtr& input) {
    return input->pixel_moving_filter_id;
  }

  static bool Read(::viz::mojom::blink::ClipNode::DataView input, ::viz::mojom::blink::ClipNodePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::EffectNode::DataView,
                                         ::viz::mojom::blink::EffectNodePtr> {
  static bool IsNull(const ::viz::mojom::blink::EffectNodePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::EffectNodePtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::EffectNode::id) id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->id;
  }

  static decltype(::viz::mojom::blink::EffectNode::parent_id) parent_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->parent_id;
  }

  static decltype(::viz::mojom::blink::EffectNode::transform_id) transform_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->transform_id;
  }

  static decltype(::viz::mojom::blink::EffectNode::clip_id) clip_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->clip_id;
  }

  static const decltype(::viz::mojom::blink::EffectNode::element_id)& element_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->element_id;
  }

  static decltype(::viz::mojom::blink::EffectNode::opacity) opacity(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->opacity;
  }

  static decltype(::viz::mojom::blink::EffectNode::render_surface_reason) render_surface_reason(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->render_surface_reason;
  }

  static const decltype(::viz::mojom::blink::EffectNode::surface_contents_scale)& surface_contents_scale(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->surface_contents_scale;
  }

  static const decltype(::viz::mojom::blink::EffectNode::subtree_capture_id)& subtree_capture_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->subtree_capture_id;
  }

  static const decltype(::viz::mojom::blink::EffectNode::subtree_size)& subtree_size(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->subtree_size;
  }

  static decltype(::viz::mojom::blink::EffectNode::blend_mode) blend_mode(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->blend_mode;
  }

  static decltype(::viz::mojom::blink::EffectNode::target_id) target_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->target_id;
  }

  static decltype(::viz::mojom::blink::EffectNode::view_transition_target_id) view_transition_target_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->view_transition_target_id;
  }

  static decltype(::viz::mojom::blink::EffectNode::closest_ancestor_with_cached_render_surface_id) closest_ancestor_with_cached_render_surface_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->closest_ancestor_with_cached_render_surface_id;
  }

  static decltype(::viz::mojom::blink::EffectNode::closest_ancestor_with_copy_request_id) closest_ancestor_with_copy_request_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->closest_ancestor_with_copy_request_id;
  }

  static decltype(::viz::mojom::blink::EffectNode::closest_ancestor_being_captured_id) closest_ancestor_being_captured_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->closest_ancestor_being_captured_id;
  }

  static decltype(::viz::mojom::blink::EffectNode::closest_ancestor_with_shared_element_id) closest_ancestor_with_shared_element_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->closest_ancestor_with_shared_element_id;
  }

  static const decltype(::viz::mojom::blink::EffectNode::view_transition_element_resource_id)& view_transition_element_resource_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->view_transition_element_resource_id;
  }

  static const decltype(::viz::mojom::blink::EffectNode::filters)& filters(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->filters;
  }

  static const decltype(::viz::mojom::blink::EffectNode::backdrop_filters)& backdrop_filters(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->backdrop_filters;
  }

  static const decltype(::viz::mojom::blink::EffectNode::backdrop_filter_bounds)& backdrop_filter_bounds(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->backdrop_filter_bounds;
  }

  static decltype(::viz::mojom::blink::EffectNode::backdrop_filter_quality) backdrop_filter_quality(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->backdrop_filter_quality;
  }

  static const decltype(::viz::mojom::blink::EffectNode::backdrop_mask_element_id)& backdrop_mask_element_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->backdrop_mask_element_id;
  }

  static const decltype(::viz::mojom::blink::EffectNode::mask_filter_info)& mask_filter_info(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->mask_filter_info;
  }

  static decltype(::viz::mojom::blink::EffectNode::cache_render_surface) cache_render_surface(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->cache_render_surface;
  }

  static decltype(::viz::mojom::blink::EffectNode::double_sided) double_sided(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->double_sided;
  }

  static decltype(::viz::mojom::blink::EffectNode::trilinear_filtering) trilinear_filtering(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->trilinear_filtering;
  }

  static decltype(::viz::mojom::blink::EffectNode::subtree_hidden) subtree_hidden(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->subtree_hidden;
  }

  static decltype(::viz::mojom::blink::EffectNode::has_potential_filter_animation) has_potential_filter_animation(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->has_potential_filter_animation;
  }

  static decltype(::viz::mojom::blink::EffectNode::has_potential_backdrop_filter_animation) has_potential_backdrop_filter_animation(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->has_potential_backdrop_filter_animation;
  }

  static decltype(::viz::mojom::blink::EffectNode::has_potential_opacity_animation) has_potential_opacity_animation(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->has_potential_opacity_animation;
  }

  static decltype(::viz::mojom::blink::EffectNode::subtree_has_copy_request) subtree_has_copy_request(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->subtree_has_copy_request;
  }

  static decltype(::viz::mojom::blink::EffectNode::is_fast_rounded_corner) is_fast_rounded_corner(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->is_fast_rounded_corner;
  }

  static decltype(::viz::mojom::blink::EffectNode::may_have_backdrop_effect) may_have_backdrop_effect(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->may_have_backdrop_effect;
  }

  static decltype(::viz::mojom::blink::EffectNode::needs_effect_for_2d_scale_transform) needs_effect_for_2d_scale_transform(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->needs_effect_for_2d_scale_transform;
  }

  static  decltype(::viz::mojom::blink::EffectNode::copy_output_requests)& copy_output_requests(
       ::viz::mojom::blink::EffectNodePtr& input) {
    return input->copy_output_requests;
  }

  static bool Read(::viz::mojom::blink::EffectNode::DataView input, ::viz::mojom::blink::EffectNodePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::ScrollTreeUpdate::DataView,
                                         ::viz::mojom::blink::ScrollTreeUpdatePtr> {
  static bool IsNull(const ::viz::mojom::blink::ScrollTreeUpdatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::ScrollTreeUpdatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::ScrollTreeUpdate::synced_scroll_offsets)& synced_scroll_offsets(
      const ::viz::mojom::blink::ScrollTreeUpdatePtr& input) {
    return input->synced_scroll_offsets;
  }

  static const decltype(::viz::mojom::blink::ScrollTreeUpdate::scrolling_contents_cull_rects)& scrolling_contents_cull_rects(
      const ::viz::mojom::blink::ScrollTreeUpdatePtr& input) {
    return input->scrolling_contents_cull_rects;
  }

  static const decltype(::viz::mojom::blink::ScrollTreeUpdate::elastic_overscroll)& elastic_overscroll(
      const ::viz::mojom::blink::ScrollTreeUpdatePtr& input) {
    return input->elastic_overscroll;
  }

  static bool Read(::viz::mojom::blink::ScrollTreeUpdate::DataView input, ::viz::mojom::blink::ScrollTreeUpdatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::ScrollNode::DataView,
                                         ::viz::mojom::blink::ScrollNodePtr> {
  static bool IsNull(const ::viz::mojom::blink::ScrollNodePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::ScrollNodePtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::ScrollNode::id) id(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->id;
  }

  static decltype(::viz::mojom::blink::ScrollNode::parent_id) parent_id(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->parent_id;
  }

  static decltype(::viz::mojom::blink::ScrollNode::transform_id) transform_id(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->transform_id;
  }

  static const decltype(::viz::mojom::blink::ScrollNode::container_bounds)& container_bounds(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->container_bounds;
  }

  static const decltype(::viz::mojom::blink::ScrollNode::bounds)& bounds(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->bounds;
  }

  static const decltype(::viz::mojom::blink::ScrollNode::element_id)& element_id(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->element_id;
  }

  static decltype(::viz::mojom::blink::ScrollNode::max_scroll_offset_affected_by_page_scale) max_scroll_offset_affected_by_page_scale(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->max_scroll_offset_affected_by_page_scale;
  }

  static decltype(::viz::mojom::blink::ScrollNode::scrolls_inner_viewport) scrolls_inner_viewport(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->scrolls_inner_viewport;
  }

  static decltype(::viz::mojom::blink::ScrollNode::scrolls_outer_viewport) scrolls_outer_viewport(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->scrolls_outer_viewport;
  }

  static decltype(::viz::mojom::blink::ScrollNode::prevent_viewport_scrolling_from_inner) prevent_viewport_scrolling_from_inner(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->prevent_viewport_scrolling_from_inner;
  }

  static decltype(::viz::mojom::blink::ScrollNode::user_scrollable_horizontal) user_scrollable_horizontal(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->user_scrollable_horizontal;
  }

  static decltype(::viz::mojom::blink::ScrollNode::user_scrollable_vertical) user_scrollable_vertical(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->user_scrollable_vertical;
  }

  static decltype(::viz::mojom::blink::ScrollNode::is_composited) is_composited(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->is_composited;
  }

  static bool Read(::viz::mojom::blink::ScrollNode::DataView input, ::viz::mojom::blink::ScrollNodePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::viz::mojom::blink::LayerExtra::DataView,
                                        ::viz::mojom::blink::LayerExtraPtr> {
  static bool IsNull(const ::viz::mojom::blink::LayerExtraPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::LayerExtraPtr* output) { output->reset(); }

  static ::viz::mojom::blink::LayerExtra::Tag GetTag(const ::viz::mojom::blink::LayerExtraPtr& input) {
    return input->which();
  }

  static const ::viz::mojom::blink::MirrorLayerExtraPtr& mirror_layer_extra(const ::viz::mojom::blink::LayerExtraPtr& input) {
    return input->get_mirror_layer_extra();
  }

  static const ::viz::mojom::blink::NinePatchThumbScrollbarLayerExtraPtr& nine_patch_thumb_scrollbar_layer_extra(const ::viz::mojom::blink::LayerExtraPtr& input) {
    return input->get_nine_patch_thumb_scrollbar_layer_extra();
  }

  static const ::viz::mojom::blink::PaintedScrollbarLayerExtraPtr& painted_scrollbar_layer_extra(const ::viz::mojom::blink::LayerExtraPtr& input) {
    return input->get_painted_scrollbar_layer_extra();
  }

  static const ::viz::mojom::blink::SolidColorScrollbarLayerExtraPtr& solid_color_scrollbar_layer_extra(const ::viz::mojom::blink::LayerExtraPtr& input) {
    return input->get_solid_color_scrollbar_layer_extra();
  }

  static const ::viz::mojom::blink::SurfaceLayerExtraPtr& surface_layer_extra(const ::viz::mojom::blink::LayerExtraPtr& input) {
    return input->get_surface_layer_extra();
  }

  static const ::viz::mojom::blink::TextureLayerExtraPtr& texture_layer_extra(const ::viz::mojom::blink::LayerExtraPtr& input) {
    return input->get_texture_layer_extra();
  }

  static const ::viz::mojom::blink::UIResourceLayerExtraPtr& ui_resource_layer_extra(const ::viz::mojom::blink::LayerExtraPtr& input) {
    return input->get_ui_resource_layer_extra();
  }

  static const ::viz::mojom::blink::TileDisplayLayerExtraPtr& tile_display_layer_extra(const ::viz::mojom::blink::LayerExtraPtr& input) {
    return input->get_tile_display_layer_extra();
  }

  static const ::viz::mojom::blink::ViewTransitionContentLayerExtraPtr& view_transition_content_layer_extra(const ::viz::mojom::blink::LayerExtraPtr& input) {
    return input->get_view_transition_content_layer_extra();
  }

  static const ::viz::mojom::blink::NinePatchLayerExtraPtr& nine_patch_layer_extra(const ::viz::mojom::blink::LayerExtraPtr& input) {
    return input->get_nine_patch_layer_extra();
  }

  static bool Read(::viz::mojom::blink::LayerExtra::DataView input, ::viz::mojom::blink::LayerExtraPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_BLINK_H_