// services/viz/public/mojom/compositing/filter_operation.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/filter_operation.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/paint_filter.mojom-shared.h"
#include "skia/public/mojom/tile_mode.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "services/viz/public/mojom/compositing/filter_operation.mojom-data-view.h"




namespace std {

template <>
struct hash<::viz::mojom::FilterType>
    : public mojo::internal::EnumHashImpl<::viz::mojom::FilterType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FilterType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::FilterType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::FilterType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FilterOperationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FilterOperationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::FilterOperation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::viz::mojom::FilterType>(
      Traits::type(input),
      &fragment->type);

    fragment->amount = Traits::amount(input);

    decltype(Traits::offset(input)) in_offset = Traits::offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->offset)::BaseType> offset_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_offset,
      offset_fragment);

    fragment->offset.Set(
        offset_fragment.is_null() ? nullptr : offset_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->offset.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null offset in FilterOperation struct");

    decltype(Traits::drop_shadow_color(input)) in_drop_shadow_color = Traits::drop_shadow_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->drop_shadow_color)::BaseType> drop_shadow_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
      in_drop_shadow_color,
      drop_shadow_color_fragment);

    fragment->drop_shadow_color.Set(
        drop_shadow_color_fragment.is_null() ? nullptr : drop_shadow_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->drop_shadow_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null drop_shadow_color in FilterOperation struct");

    decltype(Traits::image_filter(input)) in_image_filter = Traits::image_filter(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_filter)::BaseType> image_filter_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::PaintFilterDataView>(
      in_image_filter,
      image_filter_fragment);

    fragment->image_filter.Set(
        image_filter_fragment.is_null() ? nullptr : image_filter_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_filter.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_filter in FilterOperation struct");

    decltype(Traits::matrix(input)) in_matrix = Traits::matrix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->matrix)::BaseType>
        matrix_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& matrix_validate_params =
        mojo::internal::GetArrayValidator<20, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_matrix,
      matrix_fragment,
      &matrix_validate_params);

    fragment->matrix.Set(
        matrix_fragment.is_null() ? nullptr : matrix_fragment.data());

    fragment->zoom_inset = Traits::zoom_inset(input);

    
    mojo::internal::Serialize<::skia::mojom::TileMode>(
      Traits::blur_tile_mode(input),
      &fragment->blur_tile_mode);

    decltype(Traits::shape(input)) in_shape = Traits::shape(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shape)::BaseType>
        shape_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& shape_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
      in_shape,
      shape_fragment,
      &shape_validate_params);

    fragment->shape.Set(
        shape_fragment.is_null() ? nullptr : shape_fragment.data());
  }

  static bool Deserialize(::viz::mojom::internal::FilterOperation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::FilterOperationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void FilterOperationDataView::GetOffsetDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->offset.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void FilterOperationDataView::GetDropShadowColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->drop_shadow_color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}
inline void FilterOperationDataView::GetImageFilterDataView(
    ::viz::mojom::PaintFilterDataView* output) {
  auto pointer = data_->image_filter.Get();
  *output = ::viz::mojom::PaintFilterDataView(pointer, message_);
}
inline void FilterOperationDataView::GetMatrixDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->matrix.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void FilterOperationDataView::GetShapeDataView(
    mojo::ArrayDataView<::gfx::mojom::RectDataView>* output) {
  auto pointer = data_->shape.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::RectDataView>(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::FilterType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::FilterType value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_SHARED_H_