// services/viz/public/mojom/compositing/copy_output_request.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/copy_output_request.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/copy_output_request.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/copy_output_request.mojom-blink-import-headers.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace viz::mojom::blink {
CopyOutputRequest::CopyOutputRequest()
    : result_format(),
      result_destination(),
      send_result_delay(),
      scale_from(),
      scale_to(),
      source(),
      area(),
      result_selection(),
      blit_request(),
      result_sender() {}

CopyOutputRequest::CopyOutputRequest(
    ::viz::mojom::blink::CopyOutputResultFormat result_format_in,
    ::viz::mojom::blink::CopyOutputResultDestination result_destination_in,
    ::base::TimeDelta send_result_delay_in,
    const ::gfx::Vector2d& scale_from_in,
    const ::gfx::Vector2d& scale_to_in,
    const std::optional<::base::UnguessableToken>& source_in,
    const std::optional<::gfx::Rect>& area_in,
    const std::optional<::gfx::Rect>& result_selection_in,
    ::viz::mojom::blink::BlitRequestPtr blit_request_in,
    ::mojo::PendingRemote<CopyOutputResultSender> result_sender_in)
    : result_format(std::move(result_format_in)),
      result_destination(std::move(result_destination_in)),
      send_result_delay(std::move(send_result_delay_in)),
      scale_from(std::move(scale_from_in)),
      scale_to(std::move(scale_to_in)),
      source(std::move(source_in)),
      area(std::move(area_in)),
      result_selection(std::move(result_selection_in)),
      blit_request(std::move(blit_request_in)),
      result_sender(std::move(result_sender_in)) {}

CopyOutputRequest::~CopyOutputRequest() = default;

void CopyOutputRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result_format"), this->result_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::CopyOutputResultFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result_destination"), this->result_destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::CopyOutputResultDestination>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_result_delay"), this->send_result_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_from"), this->scale_from,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2d&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_to"), this->scale_to,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2d&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "area"), this->area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result_selection"), this->result_selection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blit_request"), this->blit_request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::BlitRequestPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result_sender"), this->result_sender,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<CopyOutputResultSender>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CopyOutputRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CopyOutputResultSender::IPCStableHashFunction CopyOutputResultSender::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CopyOutputResultSender>(message.name())) {
    case messages::CopyOutputResultSender::kSendResult: {
      return &CopyOutputResultSender::SendResult_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CopyOutputResultSender::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CopyOutputResultSender>(message.name())) {
      case messages::CopyOutputResultSender::kSendResult:
            return "Receive viz::mojom::CopyOutputResultSender::SendResult";
    }
  } else {
    switch (static_cast<messages::CopyOutputResultSender>(message.name())) {
      case messages::CopyOutputResultSender::kSendResult:
            return "Receive reply viz::mojom::CopyOutputResultSender::SendResult";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CopyOutputResultSender::SendResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb5c0e4c7;  // IPCStableHash for viz::mojom::CopyOutputResultSender::SendResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CopyOutputResultSenderProxy::CopyOutputResultSenderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CopyOutputResultSenderProxy::SendResult(
    ::viz::mojom::blink::CopyOutputResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CopyOutputResultSender::SendResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::viz::mojom::blink::CopyOutputResultPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CopyOutputResultSender::kSendResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CopyOutputResultSender_SendResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::CopyOutputResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in CopyOutputResultSender.SendResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CopyOutputResultSender::Name_);
  message.set_method_name("SendResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CopyOutputResultSenderStubDispatch::Accept(
    CopyOutputResultSender* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CopyOutputResultSender>(message->header()->name)) {
    case messages::CopyOutputResultSender::kSendResult: {
      DCHECK(message->is_serialized());
      internal::CopyOutputResultSender_SendResult_Params_Data* params =
          reinterpret_cast<internal::CopyOutputResultSender_SendResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CopyOutputResultSender.0
      bool success = true;
      ::viz::mojom::blink::CopyOutputResultPtr p_result{};
      CopyOutputResultSender_SendResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CopyOutputResultSender::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendResult(        
        std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool CopyOutputResultSenderStubDispatch::AcceptWithResponder(
    CopyOutputResultSender* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CopyOutputResultSender>(message->header()->name)) {
    case messages::CopyOutputResultSender::kSendResult: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCopyOutputResultSenderValidationInfo[] = {
    { &internal::CopyOutputResultSender_SendResult_Params_Data::Validate,
     nullptr /* no response */},
};

bool CopyOutputResultSenderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::blink::CopyOutputResultSender::Name_,
    kCopyOutputResultSenderValidationInfo);
}



}  // viz::mojom::blink


namespace mojo {


// static
bool StructTraits<::viz::mojom::blink::CopyOutputRequest::DataView, ::viz::mojom::blink::CopyOutputRequestPtr>::Read(
    ::viz::mojom::blink::CopyOutputRequest::DataView input,
    ::viz::mojom::blink::CopyOutputRequestPtr* output) {
  bool success = true;
  ::viz::mojom::blink::CopyOutputRequestPtr result(::viz::mojom::blink::CopyOutputRequest::New());
  
      if (success && !input.ReadResultFormat(&result->result_format))
        success = false;
      if (success && !input.ReadResultDestination(&result->result_destination))
        success = false;
      if (success && !input.ReadSendResultDelay(&result->send_result_delay))
        success = false;
      if (success && !input.ReadScaleFrom(&result->scale_from))
        success = false;
      if (success && !input.ReadScaleTo(&result->scale_to))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
      if (success && !input.ReadArea(&result->area))
        success = false;
      if (success && !input.ReadResultSelection(&result->result_selection))
        success = false;
      if (success && !input.ReadBlitRequest(&result->blit_request))
        success = false;
      if (success) {
        result->result_sender =
            input.TakeResultSender<decltype(result->result_sender)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom::blink {


void CopyOutputResultSenderInterceptorForTesting::SendResult(::viz::mojom::blink::CopyOutputResultPtr result) {
  GetForwardingInterface()->SendResult(
    std::move(result)
    );
}
CopyOutputResultSenderAsyncWaiter::CopyOutputResultSenderAsyncWaiter(
    CopyOutputResultSender* proxy) : proxy_(proxy) {}

CopyOutputResultSenderAsyncWaiter::~CopyOutputResultSenderAsyncWaiter() = default;







}  // viz::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif