// services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var compositor_render_pass_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/compositor_render_pass_id.mojom', 'compositor_render_pass_id.mojom.js');
  }
  var view_transition_element_resource_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom', 'view_transition_element_resource_id.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../../../../../third_party/blink/public/mojom/tokens/tokens.mojom.js');
  }
  var display_color_spaces$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/display_color_spaces.mojom', '../../../../../ui/gfx/mojom/display_color_spaces.mojom.js');
  }


  var CompositorFrameTransitionDirectiveType = {};
  CompositorFrameTransitionDirectiveType.kSave = 0;
  CompositorFrameTransitionDirectiveType.kAnimateRenderer = 1;
  CompositorFrameTransitionDirectiveType.kRelease = 2;
  CompositorFrameTransitionDirectiveType.MIN_VALUE = 0;
  CompositorFrameTransitionDirectiveType.MAX_VALUE = 2;

  CompositorFrameTransitionDirectiveType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CompositorFrameTransitionDirectiveType.toKnownEnumValue = function(value) {
    return value;
  };

  CompositorFrameTransitionDirectiveType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CompositorFrameTransitionDirectiveSharedElement(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameTransitionDirectiveSharedElement.prototype.initDefaults_ = function() {
    this.renderPassId = null;
    this.viewTransitionElementResourceId = null;
  };
  CompositorFrameTransitionDirectiveSharedElement.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameTransitionDirectiveSharedElement.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameTransitionDirectiveSharedElement.renderPassId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, compositor_render_pass_id$.CompositorRenderPassId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameTransitionDirectiveSharedElement.viewTransitionElementResourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, view_transition_element_resource_id$.ViewTransitionElementResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositorFrameTransitionDirectiveSharedElement.encodedSize = codec.kStructHeaderSize + 16;

  CompositorFrameTransitionDirectiveSharedElement.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameTransitionDirectiveSharedElement();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.renderPassId =
        decoder.decodeStructPointer(compositor_render_pass_id$.CompositorRenderPassId);
    val.viewTransitionElementResourceId =
        decoder.decodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId);
    return val;
  };

  CompositorFrameTransitionDirectiveSharedElement.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameTransitionDirectiveSharedElement.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(compositor_render_pass_id$.CompositorRenderPassId, val.renderPassId);
    encoder.encodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId, val.viewTransitionElementResourceId);
  };
  function CompositorFrameTransitionDirective(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameTransitionDirective.prototype.initDefaults_ = function() {
    this.transitionToken = null;
    this.maybeCrossFrameSink = false;
    this.sequenceId = 0;
    this.type = 0;
    this.sharedElements = null;
    this.displayColorSpaces = null;
  };
  CompositorFrameTransitionDirective.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameTransitionDirective.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameTransitionDirective.transitionToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.ViewTransitionToken, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate CompositorFrameTransitionDirective.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, CompositorFrameTransitionDirectiveType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameTransitionDirective.sharedElements
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(CompositorFrameTransitionDirectiveSharedElement), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameTransitionDirective.displayColorSpaces
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, display_color_spaces$.DisplayColorSpaces, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositorFrameTransitionDirective.encodedSize = codec.kStructHeaderSize + 40;

  CompositorFrameTransitionDirective.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameTransitionDirective();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transitionToken =
        decoder.decodeStructPointer(tokens$.ViewTransitionToken);
    packed = decoder.readUint8();
    val.maybeCrossFrameSink = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sequenceId =
        decoder.decodeStruct(codec.Uint32);
    val.type =
        decoder.decodeStruct(new codec.Enum(CompositorFrameTransitionDirectiveType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sharedElements =
        decoder.decodeArrayPointer(new codec.PointerTo(CompositorFrameTransitionDirectiveSharedElement));
    val.displayColorSpaces =
        decoder.decodeStructPointer(display_color_spaces$.DisplayColorSpaces);
    return val;
  };

  CompositorFrameTransitionDirective.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameTransitionDirective.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.ViewTransitionToken, val.transitionToken);
    packed = 0;
    packed |= (val.maybeCrossFrameSink & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.sequenceId);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(CompositorFrameTransitionDirectiveSharedElement), val.sharedElements);
    encoder.encodeStructPointer(display_color_spaces$.DisplayColorSpaces, val.displayColorSpaces);
  };
  exports.CompositorFrameTransitionDirectiveType = CompositorFrameTransitionDirectiveType;
  exports.CompositorFrameTransitionDirectiveSharedElement = CompositorFrameTransitionDirectiveSharedElement;
  exports.CompositorFrameTransitionDirective = CompositorFrameTransitionDirective;
})();