// services/viz/public/mojom/compositing/compositor_frame_sink.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared-internal.h"
#include "cc/mojom/scrollbar_animator.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-shared.h"
#include "services/viz/public/mojom/compositing/layer_context.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-shared.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom-shared.h"
#include "services/viz/public/mojom/compositing/thread.mojom-shared.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace viz::mojom {
class LayerContextSettingsDataView;

class CompositorFrameSinkParamsDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::LayerContextSettingsDataView> {
  using Data = ::viz::mojom::internal::LayerContextSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::CompositorFrameSinkParamsDataView> {
  using Data = ::viz::mojom::internal::CompositorFrameSinkParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {
// Interface base classes. They are used for type safety check.
class CompositorFrameSinkInterfaceBase {};

using CompositorFrameSinkPtrDataView =
    mojo::InterfacePtrDataView<CompositorFrameSinkInterfaceBase>;
using CompositorFrameSinkRequestDataView =
    mojo::InterfaceRequestDataView<CompositorFrameSinkInterfaceBase>;
using CompositorFrameSinkAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CompositorFrameSinkInterfaceBase>;
using CompositorFrameSinkAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CompositorFrameSinkInterfaceBase>;
class CompositorFrameSinkClientInterfaceBase {};

using CompositorFrameSinkClientPtrDataView =
    mojo::InterfacePtrDataView<CompositorFrameSinkClientInterfaceBase>;
using CompositorFrameSinkClientRequestDataView =
    mojo::InterfaceRequestDataView<CompositorFrameSinkClientInterfaceBase>;
using CompositorFrameSinkClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CompositorFrameSinkClientInterfaceBase>;
using CompositorFrameSinkClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CompositorFrameSinkClientInterfaceBase>;


class LayerContextSettingsDataView {
 public:
  LayerContextSettingsDataView() = default;

  LayerContextSettingsDataView(
      internal::LayerContextSettings_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool draw_mode_is_gpu() const {
    return data_->draw_mode_is_gpu;
  }
  bool enable_early_damage_check() const {
    return data_->enable_early_damage_check;
  }
  int32_t damaged_frame_limit() const {
    return data_->damaged_frame_limit;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScrollbarAnimator(UserType* output) const {
    auto data_value = data_->scrollbar_animator;
    return mojo::internal::Deserialize<::cc::mojom::ScrollbarAnimator>(
        data_value, output);
  }
  ::cc::mojom::ScrollbarAnimator scrollbar_animator() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::cc::mojom::ScrollbarAnimator>(data_->scrollbar_animator));
  }
  inline void GetScrollbarFadeDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollbarFadeDelay(UserType* output) {
    
    auto* pointer = data_->scrollbar_fade_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetScrollbarFadeDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollbarFadeDuration(UserType* output) {
    
    auto* pointer = data_->scrollbar_fade_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetScrollbarThinningDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollbarThinningDuration(UserType* output) {
    
    auto* pointer = data_->scrollbar_thinning_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  float idle_thickness_scale() const {
    return data_->idle_thickness_scale;
  }
  float top_controls_show_threshold() const {
    return data_->top_controls_show_threshold;
  }
  float top_controls_hide_threshold() const {
    return data_->top_controls_hide_threshold;
  }
  inline void GetMinimumOcclusionTrackingSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinimumOcclusionTrackingSize(UserType* output) {
    
    auto* pointer = data_->minimum_occlusion_tracking_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool enable_edge_anti_aliasing() const {
    return data_->enable_edge_anti_aliasing;
  }
  bool enable_backface_visibility_interop() const {
    return data_->enable_backface_visibility_interop;
  }
  bool enable_fluent_scrollbar() const {
    return data_->enable_fluent_scrollbar;
  }
  bool enable_fluent_overlay_scrollbar() const {
    return data_->enable_fluent_overlay_scrollbar;
  }
 private:
  internal::LayerContextSettings_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CompositorFrameSinkParamsDataView {
 public:
  CompositorFrameSinkParamsDataView() = default;

  CompositorFrameSinkParamsDataView(
      internal::CompositorFrameSinkParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool wants_animate_only_begin_frames() const {
    return data_->wants_animate_only_begin_frames;
  }
  bool auto_needs_begin_frame() const {
    return data_->auto_needs_begin_frame;
  }
  bool no_compositor_frame_acks() const {
    return data_->no_compositor_frame_acks;
  }
 private:
  internal::CompositorFrameSinkParams_Data* data_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_DATA_VIEW_H_