// services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink-import-headers.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "gpu/ipc/common/mailbox_holder_mojom_traits.h"
#include "gpu/ipc/common/mailbox_mojom_traits.h"
#include "gpu/ipc/common/sync_token_mojom_traits.h"
#include "ipc/ipc_message_utils.h"
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_metadata_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_render_pass_id_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_render_pass_mojom_traits.h"
#include "services/viz/public/cpp/compositing/filter_operation_mojom_traits.h"
#include "services/viz/public/cpp/compositing/filter_operations_mojom_traits.h"
#include "services/viz/public/cpp/compositing/quads_mojom_traits.h"
#include "services/viz/public/cpp/compositing/selection_mojom_traits.h"
#include "services/viz/public/cpp/compositing/shared_quad_state_mojom_traits.h"
#include "services/viz/public/cpp/compositing/transferable_resource_mojom_traits.h"
#include "services/viz/public/cpp/compositing/trees_in_viz_timing_mojom_traits.h"
#include "ui/gfx/mojom/selection_bound_mojom_traits.h"
#include "ui/gfx/mojom/transform_mojom_traits.h"
#include "ui/latency/mojom/latency_info_mojom_traits.h"


namespace viz::mojom::blink {
LayerContextSettings::LayerContextSettings()
    : draw_mode_is_gpu(),
      enable_early_damage_check(),
      damaged_frame_limit(),
      scrollbar_animator(),
      scrollbar_fade_delay(),
      scrollbar_fade_duration(),
      scrollbar_thinning_duration(),
      idle_thickness_scale(),
      top_controls_show_threshold(),
      top_controls_hide_threshold(),
      minimum_occlusion_tracking_size(),
      enable_edge_anti_aliasing(),
      enable_backface_visibility_interop(),
      enable_fluent_scrollbar(),
      enable_fluent_overlay_scrollbar() {}

LayerContextSettings::LayerContextSettings(
    bool draw_mode_is_gpu_in,
    bool enable_early_damage_check_in,
    int32_t damaged_frame_limit_in,
    ::cc::mojom::blink::ScrollbarAnimator scrollbar_animator_in,
    ::base::TimeDelta scrollbar_fade_delay_in,
    ::base::TimeDelta scrollbar_fade_duration_in,
    ::base::TimeDelta scrollbar_thinning_duration_in,
    float idle_thickness_scale_in,
    float top_controls_show_threshold_in,
    float top_controls_hide_threshold_in,
    const ::gfx::Size& minimum_occlusion_tracking_size_in,
    bool enable_edge_anti_aliasing_in,
    bool enable_backface_visibility_interop_in,
    bool enable_fluent_scrollbar_in,
    bool enable_fluent_overlay_scrollbar_in)
    : draw_mode_is_gpu(std::move(draw_mode_is_gpu_in)),
      enable_early_damage_check(std::move(enable_early_damage_check_in)),
      damaged_frame_limit(std::move(damaged_frame_limit_in)),
      scrollbar_animator(std::move(scrollbar_animator_in)),
      scrollbar_fade_delay(std::move(scrollbar_fade_delay_in)),
      scrollbar_fade_duration(std::move(scrollbar_fade_duration_in)),
      scrollbar_thinning_duration(std::move(scrollbar_thinning_duration_in)),
      idle_thickness_scale(std::move(idle_thickness_scale_in)),
      top_controls_show_threshold(std::move(top_controls_show_threshold_in)),
      top_controls_hide_threshold(std::move(top_controls_hide_threshold_in)),
      minimum_occlusion_tracking_size(std::move(minimum_occlusion_tracking_size_in)),
      enable_edge_anti_aliasing(std::move(enable_edge_anti_aliasing_in)),
      enable_backface_visibility_interop(std::move(enable_backface_visibility_interop_in)),
      enable_fluent_scrollbar(std::move(enable_fluent_scrollbar_in)),
      enable_fluent_overlay_scrollbar(std::move(enable_fluent_overlay_scrollbar_in)) {}

LayerContextSettings::~LayerContextSettings() = default;

void LayerContextSettings::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "draw_mode_is_gpu"), this->draw_mode_is_gpu,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_early_damage_check"), this->enable_early_damage_check,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "damaged_frame_limit"), this->damaged_frame_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrollbar_animator"), this->scrollbar_animator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::mojom::blink::ScrollbarAnimator>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrollbar_fade_delay"), this->scrollbar_fade_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrollbar_fade_duration"), this->scrollbar_fade_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrollbar_thinning_duration"), this->scrollbar_thinning_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "idle_thickness_scale"), this->idle_thickness_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_show_threshold"), this->top_controls_show_threshold,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_hide_threshold"), this->top_controls_hide_threshold,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minimum_occlusion_tracking_size"), this->minimum_occlusion_tracking_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_edge_anti_aliasing"), this->enable_edge_anti_aliasing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_backface_visibility_interop"), this->enable_backface_visibility_interop,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_fluent_scrollbar"), this->enable_fluent_scrollbar,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_fluent_overlay_scrollbar"), this->enable_fluent_overlay_scrollbar,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LayerContextSettings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CompositorFrameSinkParams::CompositorFrameSinkParams()
    : wants_animate_only_begin_frames(),
      auto_needs_begin_frame(),
      no_compositor_frame_acks() {}

CompositorFrameSinkParams::CompositorFrameSinkParams(
    bool wants_animate_only_begin_frames_in,
    bool auto_needs_begin_frame_in,
    bool no_compositor_frame_acks_in)
    : wants_animate_only_begin_frames(std::move(wants_animate_only_begin_frames_in)),
      auto_needs_begin_frame(std::move(auto_needs_begin_frame_in)),
      no_compositor_frame_acks(std::move(no_compositor_frame_acks_in)) {}

CompositorFrameSinkParams::~CompositorFrameSinkParams() = default;
size_t CompositorFrameSinkParams::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->wants_animate_only_begin_frames);
  seed = mojo::internal::WTFHash(seed, this->auto_needs_begin_frame);
  seed = mojo::internal::WTFHash(seed, this->no_compositor_frame_acks);
  return seed;
}

void CompositorFrameSinkParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wants_animate_only_begin_frames"), this->wants_animate_only_begin_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auto_needs_begin_frame"), this->auto_needs_begin_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_compositor_frame_acks"), this->no_compositor_frame_acks,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CompositorFrameSinkParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CompositorFrameSink::IPCStableHashFunction CompositorFrameSink::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CompositorFrameSink>(message.name())) {
    case messages::CompositorFrameSink::kSetParams: {
      return &CompositorFrameSink::SetParams_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kSetNeedsBeginFrame: {
      return &CompositorFrameSink::SetNeedsBeginFrame_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kSubmitCompositorFrame: {
      return &CompositorFrameSink::SubmitCompositorFrame_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kDidNotProduceFrame: {
      return &CompositorFrameSink::DidNotProduceFrame_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kNotifyNewLocalSurfaceIdExpectedWhilePaused: {
      return &CompositorFrameSink::NotifyNewLocalSurfaceIdExpectedWhilePaused_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kBindLayerContext: {
      return &CompositorFrameSink::BindLayerContext_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CompositorFrameSink::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CompositorFrameSink>(message.name())) {
      case messages::CompositorFrameSink::kSetParams:
            return "Receive viz::mojom::CompositorFrameSink::SetParams";
      case messages::CompositorFrameSink::kSetNeedsBeginFrame:
            return "Receive viz::mojom::CompositorFrameSink::SetNeedsBeginFrame";
      case messages::CompositorFrameSink::kSubmitCompositorFrame:
            return "Receive viz::mojom::CompositorFrameSink::SubmitCompositorFrame";
      case messages::CompositorFrameSink::kDidNotProduceFrame:
            return "Receive viz::mojom::CompositorFrameSink::DidNotProduceFrame";
      case messages::CompositorFrameSink::kNotifyNewLocalSurfaceIdExpectedWhilePaused:
            return "Receive viz::mojom::CompositorFrameSink::NotifyNewLocalSurfaceIdExpectedWhilePaused";
      case messages::CompositorFrameSink::kBindLayerContext:
            return "Receive viz::mojom::CompositorFrameSink::BindLayerContext";
    }
  } else {
    switch (static_cast<messages::CompositorFrameSink>(message.name())) {
      case messages::CompositorFrameSink::kSetParams:
            return "Receive reply viz::mojom::CompositorFrameSink::SetParams";
      case messages::CompositorFrameSink::kSetNeedsBeginFrame:
            return "Receive reply viz::mojom::CompositorFrameSink::SetNeedsBeginFrame";
      case messages::CompositorFrameSink::kSubmitCompositorFrame:
            return "Receive reply viz::mojom::CompositorFrameSink::SubmitCompositorFrame";
      case messages::CompositorFrameSink::kDidNotProduceFrame:
            return "Receive reply viz::mojom::CompositorFrameSink::DidNotProduceFrame";
      case messages::CompositorFrameSink::kNotifyNewLocalSurfaceIdExpectedWhilePaused:
            return "Receive reply viz::mojom::CompositorFrameSink::NotifyNewLocalSurfaceIdExpectedWhilePaused";
      case messages::CompositorFrameSink::kBindLayerContext:
            return "Receive reply viz::mojom::CompositorFrameSink::BindLayerContext";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CompositorFrameSink::SetParams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4fccebc0;  // IPCStableHash for viz::mojom::CompositorFrameSink::SetParams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::SetNeedsBeginFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x39883bea;  // IPCStableHash for viz::mojom::CompositorFrameSink::SetNeedsBeginFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::SubmitCompositorFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x29795692;  // IPCStableHash for viz::mojom::CompositorFrameSink::SubmitCompositorFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::DidNotProduceFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00fe0838;  // IPCStableHash for viz::mojom::CompositorFrameSink::DidNotProduceFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::NotifyNewLocalSurfaceIdExpectedWhilePaused_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24db8ac5;  // IPCStableHash for viz::mojom::CompositorFrameSink::NotifyNewLocalSurfaceIdExpectedWhilePaused
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::BindLayerContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbd8bc047;  // IPCStableHash for viz::mojom::CompositorFrameSink::BindLayerContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CompositorFrameSinkProxy::CompositorFrameSinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
  if (base::FeatureList::IsEnabled(mojo::features::kMojoPredictiveAllocation)) {
    size_estimator_.EnablePredictiveAllocation(base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrame));
  }
}

void CompositorFrameSinkProxy::SetParams(
    CompositorFrameSinkParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSink::SetParams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type CompositorFrameSinkParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kSetParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SetParams_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::CompositorFrameSinkParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in CompositorFrameSink.SetParams request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SetParams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkProxy::SetNeedsBeginFrame(
    bool in_needs_begin_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSink::SetNeedsBeginFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_begin_frame"), in_needs_begin_frame,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kSetNeedsBeginFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data> params(
          message);
  params.Allocate();

  params->needs_begin_frame = in_needs_begin_frame;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SetNeedsBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkProxy::SubmitCompositorFrame(
    const ::viz::LocalSurfaceId& in_local_surface_id, ::viz::CompositorFrame in_frame, std::optional<::viz::HitTestRegionList> in_hit_test_region_list, uint64_t in_submit_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSink::SubmitCompositorFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_surface_id"), in_local_surface_id,
                        "<value of type const ::viz::LocalSurfaceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type ::viz::CompositorFrame>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hit_test_region_list"), in_hit_test_region_list,
                        "<value of type std::optional<::viz::HitTestRegionList>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("submit_time"), in_submit_time,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    size_estimator_.EstimatePayloadSize(base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrame));
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrame), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_surface_id)::BaseType> local_surface_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
    in_local_surface_id,
    local_surface_id_fragment);

  params->local_surface_id.Set(
      local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->local_surface_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null local_surface_id in CompositorFrameSink.SubmitCompositorFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
    in_frame,
    frame_fragment);

  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame in CompositorFrameSink.SubmitCompositorFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->hit_test_region_list)::BaseType> hit_test_region_list_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
    in_hit_test_region_list,
    hit_test_region_list_fragment);

  params->hit_test_region_list.Set(
      hit_test_region_list_fragment.is_null() ? nullptr : hit_test_region_list_fragment.data());

  params->submit_time = in_submit_time;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrame");
#endif
  size_estimator_.TrackPayloadSize(base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrame), message.payload_num_bytes());
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkProxy::DidNotProduceFrame(
    const ::viz::BeginFrameAck& in_ack) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSink::DidNotProduceFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ack"), in_ack,
                        "<value of type const ::viz::BeginFrameAck&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kDidNotProduceFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_DidNotProduceFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ack)::BaseType> ack_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::BeginFrameAckDataView>(
    in_ack,
    ack_fragment);

  params->ack.Set(
      ack_fragment.is_null() ? nullptr : ack_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ack.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ack in CompositorFrameSink.DidNotProduceFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("DidNotProduceFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkProxy::NotifyNewLocalSurfaceIdExpectedWhilePaused(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::CompositorFrameSink::NotifyNewLocalSurfaceIdExpectedWhilePaused");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kNotifyNewLocalSurfaceIdExpectedWhilePaused), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("NotifyNewLocalSurfaceIdExpectedWhilePaused");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkProxy::BindLayerContext(
    ::viz::mojom::blink::PendingLayerContextPtr in_context, LayerContextSettingsPtr in_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSink::BindLayerContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type ::viz::mojom::blink::PendingLayerContextPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings,
                        "<value of type LayerContextSettingsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kBindLayerContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_BindLayerContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->context)::BaseType> context_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::PendingLayerContextDataView>(
    in_context,
    context_fragment);

  params->context.Set(
      context_fragment.is_null() ? nullptr : context_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->context.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null context in CompositorFrameSink.BindLayerContext request");
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType> settings_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::LayerContextSettingsDataView>(
    in_settings,
    settings_fragment);

  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->settings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null settings in CompositorFrameSink.BindLayerContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("BindLayerContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CompositorFrameSinkStubDispatch::Accept(
    CompositorFrameSink* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CompositorFrameSink>(message->header()->name)) {
    case messages::CompositorFrameSink::kSetParams: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SetParams_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SetParams_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSink.0
      bool success = true;
      CompositorFrameSinkParamsPtr p_params{};
      CompositorFrameSink_SetParams_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetParams(        
        std::move(p_params));
      return true;
    }
    case messages::CompositorFrameSink::kSetNeedsBeginFrame: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSink.1
      bool success = true;
      bool p_needs_begin_frame{};
      CompositorFrameSink_SetNeedsBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_needs_begin_frame = input_data_view.needs_begin_frame();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsBeginFrame(        
        std::move(p_needs_begin_frame));
      return true;
    }
    case messages::CompositorFrameSink::kSubmitCompositorFrame: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSink.2
      bool success = true;
      ::viz::LocalSurfaceId p_local_surface_id{};
      ::viz::CompositorFrame p_frame{};
      std::optional<::viz::HitTestRegionList> p_hit_test_region_list{};
      uint64_t p_submit_time{};
      CompositorFrameSink_SubmitCompositorFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalSurfaceId(&p_local_surface_id))
        success = false;
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success && !input_data_view.ReadHitTestRegionList(&p_hit_test_region_list))
        success = false;
      if (success)
        p_submit_time = input_data_view.submit_time();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitCompositorFrame(        
        std::move(p_local_surface_id), 
        std::move(p_frame), 
        std::move(p_hit_test_region_list), 
        std::move(p_submit_time));
      return true;
    }
    case messages::CompositorFrameSink::kDidNotProduceFrame: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_DidNotProduceFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_DidNotProduceFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSink.3
      bool success = true;
      ::viz::BeginFrameAck p_ack{};
      CompositorFrameSink_DidNotProduceFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAck(&p_ack))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidNotProduceFrame(        
        std::move(p_ack));
      return true;
    }
    case messages::CompositorFrameSink::kNotifyNewLocalSurfaceIdExpectedWhilePaused: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSink.4
      bool success = true;
      CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyNewLocalSurfaceIdExpectedWhilePaused(        );
      return true;
    }
    case messages::CompositorFrameSink::kBindLayerContext: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_BindLayerContext_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_BindLayerContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSink.5
      bool success = true;
      ::viz::mojom::blink::PendingLayerContextPtr p_context{};
      LayerContextSettingsPtr p_settings{};
      CompositorFrameSink_BindLayerContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContext(&p_context))
        success = false;
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindLayerContext(        
        std::move(p_context), 
        std::move(p_settings));
      return true;
    }
  }
  return false;
}

// static
bool CompositorFrameSinkStubDispatch::AcceptWithResponder(
    CompositorFrameSink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CompositorFrameSink>(message->header()->name)) {
    case messages::CompositorFrameSink::kSetParams: {
      break;
    }
    case messages::CompositorFrameSink::kSetNeedsBeginFrame: {
      break;
    }
    case messages::CompositorFrameSink::kSubmitCompositorFrame: {
      break;
    }
    case messages::CompositorFrameSink::kDidNotProduceFrame: {
      break;
    }
    case messages::CompositorFrameSink::kNotifyNewLocalSurfaceIdExpectedWhilePaused: {
      break;
    }
    case messages::CompositorFrameSink::kBindLayerContext: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCompositorFrameSinkValidationInfo[] = {
    { &internal::CompositorFrameSink_SetParams_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CompositorFrameSink_DidNotProduceFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CompositorFrameSink_BindLayerContext_Params_Data::Validate,
     nullptr /* no response */},
};

bool CompositorFrameSinkRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::blink::CompositorFrameSink::Name_,
    kCompositorFrameSinkValidationInfo);
}

// The declaration includes the definition on other builds.

CompositorFrameSinkClient::IPCStableHashFunction CompositorFrameSinkClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CompositorFrameSinkClient>(message.name())) {
    case messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck: {
      return &CompositorFrameSinkClient::DidReceiveCompositorFrameAck_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFrame: {
      return &CompositorFrameSinkClient::OnBeginFrame_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged: {
      return &CompositorFrameSinkClient::OnBeginFramePausedChanged_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSinkClient::kReclaimResources: {
      return &CompositorFrameSinkClient::ReclaimResources_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed: {
      return &CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSinkClient::kOnSurfaceEvicted: {
      return &CompositorFrameSinkClient::OnSurfaceEvicted_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CompositorFrameSinkClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CompositorFrameSinkClient>(message.name())) {
      case messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck:
            return "Receive viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck";
      case messages::CompositorFrameSinkClient::kOnBeginFrame:
            return "Receive viz::mojom::CompositorFrameSinkClient::OnBeginFrame";
      case messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged:
            return "Receive viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged";
      case messages::CompositorFrameSinkClient::kReclaimResources:
            return "Receive viz::mojom::CompositorFrameSinkClient::ReclaimResources";
      case messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed:
            return "Receive viz::mojom::CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed";
      case messages::CompositorFrameSinkClient::kOnSurfaceEvicted:
            return "Receive viz::mojom::CompositorFrameSinkClient::OnSurfaceEvicted";
    }
  } else {
    switch (static_cast<messages::CompositorFrameSinkClient>(message.name())) {
      case messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck";
      case messages::CompositorFrameSinkClient::kOnBeginFrame:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::OnBeginFrame";
      case messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged";
      case messages::CompositorFrameSinkClient::kReclaimResources:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::ReclaimResources";
      case messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed";
      case messages::CompositorFrameSinkClient::kOnSurfaceEvicted:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::OnSurfaceEvicted";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CompositorFrameSinkClient::DidReceiveCompositorFrameAck_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb248dd40;  // IPCStableHash for viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSinkClient::OnBeginFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8dc1e3f0;  // IPCStableHash for viz::mojom::CompositorFrameSinkClient::OnBeginFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSinkClient::OnBeginFramePausedChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4252ffaf;  // IPCStableHash for viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSinkClient::ReclaimResources_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3a3547e0;  // IPCStableHash for viz::mojom::CompositorFrameSinkClient::ReclaimResources
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x963ba05f;  // IPCStableHash for viz::mojom::CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSinkClient::OnSurfaceEvicted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xce0bb221;  // IPCStableHash for viz::mojom::CompositorFrameSinkClient::OnSurfaceEvicted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CompositorFrameSinkClientProxy::CompositorFrameSinkClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CompositorFrameSinkClientProxy::DidReceiveCompositorFrameAck(
    ::blink::Vector<::viz::ReturnedResource> in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type ::blink::Vector<::viz::ReturnedResource>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
    in_resources,
    resources_fragment,
    &resources_validate_params);

  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resources.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resources in CompositorFrameSinkClient.DidReceiveCompositorFrameAck request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("DidReceiveCompositorFrameAck");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkClientProxy::OnBeginFrame(
    const ::viz::BeginFrameArgs& in_args, const ::blink::HashMap<uint32_t, ::viz::FrameTimingDetails>& in_details, ::blink::Vector<::viz::ReturnedResource> in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::OnBeginFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type const ::viz::BeginFrameArgs&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type const ::blink::HashMap<uint32_t, ::viz::FrameTimingDetails>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type ::blink::Vector<::viz::ReturnedResource>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kOnBeginFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::BeginFrameArgsDataView>(
    in_args,
    args_fragment);

  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->args.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null args in CompositorFrameSinkClient.OnBeginFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType>
      details_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::viz::mojom::FrameTimingDetailsDataView>>(
    in_details,
    details_fragment,
    &details_validate_params);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in CompositorFrameSinkClient.OnBeginFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
    in_resources,
    resources_fragment,
    &resources_validate_params);

  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resources.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resources in CompositorFrameSinkClient.OnBeginFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkClientProxy::OnBeginFramePausedChanged(
    bool in_paused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("paused"), in_paused,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data> params(
          message);
  params.Allocate();

  params->paused = in_paused;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnBeginFramePausedChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkClientProxy::ReclaimResources(
    ::blink::Vector<::viz::ReturnedResource> in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::ReclaimResources", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type ::blink::Vector<::viz::ReturnedResource>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kReclaimResources), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_ReclaimResources_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
    in_resources,
    resources_fragment,
    &resources_validate_params);

  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resources.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resources in CompositorFrameSinkClient.ReclaimResources request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("ReclaimResources");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkClientProxy::OnCompositorFrameTransitionDirectiveProcessed(
    uint32_t in_sequence_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sequence_id"), in_sequence_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data> params(
          message);
  params.Allocate();

  params->sequence_id = in_sequence_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnCompositorFrameTransitionDirectiveProcessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkClientProxy::OnSurfaceEvicted(
    const ::viz::LocalSurfaceId& in_local_surface_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::OnSurfaceEvicted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_surface_id"), in_local_surface_id,
                        "<value of type const ::viz::LocalSurfaceId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kOnSurfaceEvicted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_OnSurfaceEvicted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_surface_id)::BaseType> local_surface_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
    in_local_surface_id,
    local_surface_id_fragment);

  params->local_surface_id.Set(
      local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->local_surface_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null local_surface_id in CompositorFrameSinkClient.OnSurfaceEvicted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnSurfaceEvicted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CompositorFrameSinkClientStubDispatch::Accept(
    CompositorFrameSinkClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CompositorFrameSinkClient>(message->header()->name)) {
    case messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSinkClient.0
      bool success = true;
      ::blink::Vector<::viz::ReturnedResource> p_resources{};
      CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReceiveCompositorFrameAck(        
        std::move(p_resources));
      return true;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFrame: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSinkClient.1
      bool success = true;
      ::viz::BeginFrameArgs p_args{};
      ::blink::HashMap<uint32_t, ::viz::FrameTimingDetails> p_details{};
      ::blink::Vector<::viz::ReturnedResource> p_resources{};
      CompositorFrameSinkClient_OnBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeginFrame(        
        std::move(p_args), 
        std::move(p_details), 
        std::move(p_resources));
      return true;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSinkClient.2
      bool success = true;
      bool p_paused{};
      CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_paused = input_data_view.paused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeginFramePausedChanged(        
        std::move(p_paused));
      return true;
    }
    case messages::CompositorFrameSinkClient::kReclaimResources: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_ReclaimResources_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_ReclaimResources_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSinkClient.3
      bool success = true;
      ::blink::Vector<::viz::ReturnedResource> p_resources{};
      CompositorFrameSinkClient_ReclaimResources_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReclaimResources(        
        std::move(p_resources));
      return true;
    }
    case messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSinkClient.4
      bool success = true;
      uint32_t p_sequence_id{};
      CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sequence_id = input_data_view.sequence_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCompositorFrameTransitionDirectiveProcessed(        
        std::move(p_sequence_id));
      return true;
    }
    case messages::CompositorFrameSinkClient::kOnSurfaceEvicted: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnSurfaceEvicted_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnSurfaceEvicted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CompositorFrameSinkClient.5
      bool success = true;
      ::viz::LocalSurfaceId p_local_surface_id{};
      CompositorFrameSinkClient_OnSurfaceEvicted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalSurfaceId(&p_local_surface_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSurfaceEvicted(        
        std::move(p_local_surface_id));
      return true;
    }
  }
  return false;
}

// static
bool CompositorFrameSinkClientStubDispatch::AcceptWithResponder(
    CompositorFrameSinkClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CompositorFrameSinkClient>(message->header()->name)) {
    case messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck: {
      break;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFrame: {
      break;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged: {
      break;
    }
    case messages::CompositorFrameSinkClient::kReclaimResources: {
      break;
    }
    case messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed: {
      break;
    }
    case messages::CompositorFrameSinkClient::kOnSurfaceEvicted: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCompositorFrameSinkClientValidationInfo[] = {
    { &internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CompositorFrameSinkClient_ReclaimResources_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CompositorFrameSinkClient_OnSurfaceEvicted_Params_Data::Validate,
     nullptr /* no response */},
};

bool CompositorFrameSinkClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::blink::CompositorFrameSinkClient::Name_,
    kCompositorFrameSinkClientValidationInfo);
}



}  // viz::mojom::blink


namespace mojo {


// static
bool StructTraits<::viz::mojom::blink::LayerContextSettings::DataView, ::viz::mojom::blink::LayerContextSettingsPtr>::Read(
    ::viz::mojom::blink::LayerContextSettings::DataView input,
    ::viz::mojom::blink::LayerContextSettingsPtr* output) {
  bool success = true;
  ::viz::mojom::blink::LayerContextSettingsPtr result(::viz::mojom::blink::LayerContextSettings::New());
  
      if (success)
        result->draw_mode_is_gpu = input.draw_mode_is_gpu();
      if (success)
        result->enable_early_damage_check = input.enable_early_damage_check();
      if (success)
        result->damaged_frame_limit = input.damaged_frame_limit();
      if (success && !input.ReadScrollbarAnimator(&result->scrollbar_animator))
        success = false;
      if (success && !input.ReadScrollbarFadeDelay(&result->scrollbar_fade_delay))
        success = false;
      if (success && !input.ReadScrollbarFadeDuration(&result->scrollbar_fade_duration))
        success = false;
      if (success && !input.ReadScrollbarThinningDuration(&result->scrollbar_thinning_duration))
        success = false;
      if (success)
        result->idle_thickness_scale = input.idle_thickness_scale();
      if (success)
        result->top_controls_show_threshold = input.top_controls_show_threshold();
      if (success)
        result->top_controls_hide_threshold = input.top_controls_hide_threshold();
      if (success && !input.ReadMinimumOcclusionTrackingSize(&result->minimum_occlusion_tracking_size))
        success = false;
      if (success)
        result->enable_edge_anti_aliasing = input.enable_edge_anti_aliasing();
      if (success)
        result->enable_backface_visibility_interop = input.enable_backface_visibility_interop();
      if (success)
        result->enable_fluent_scrollbar = input.enable_fluent_scrollbar();
      if (success)
        result->enable_fluent_overlay_scrollbar = input.enable_fluent_overlay_scrollbar();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::CompositorFrameSinkParams::DataView, ::viz::mojom::blink::CompositorFrameSinkParamsPtr>::Read(
    ::viz::mojom::blink::CompositorFrameSinkParams::DataView input,
    ::viz::mojom::blink::CompositorFrameSinkParamsPtr* output) {
  bool success = true;
  ::viz::mojom::blink::CompositorFrameSinkParamsPtr result(::viz::mojom::blink::CompositorFrameSinkParams::New());
  
      if (success)
        result->wants_animate_only_begin_frames = input.wants_animate_only_begin_frames();
      if (success)
        result->auto_needs_begin_frame = input.auto_needs_begin_frame();
      if (success)
        result->no_compositor_frame_acks = input.no_compositor_frame_acks();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom::blink {


void CompositorFrameSinkInterceptorForTesting::SetParams(CompositorFrameSinkParamsPtr params) {
  GetForwardingInterface()->SetParams(
    std::move(params)
    );
}
void CompositorFrameSinkInterceptorForTesting::SetNeedsBeginFrame(bool needs_begin_frame) {
  GetForwardingInterface()->SetNeedsBeginFrame(
    std::move(needs_begin_frame)
    );
}
void CompositorFrameSinkInterceptorForTesting::SubmitCompositorFrame(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time) {
  GetForwardingInterface()->SubmitCompositorFrame(
    std::move(local_surface_id)
    , 
    std::move(frame)
    , 
    std::move(hit_test_region_list)
    , 
    std::move(submit_time)
    );
}
void CompositorFrameSinkInterceptorForTesting::DidNotProduceFrame(const ::viz::BeginFrameAck& ack) {
  GetForwardingInterface()->DidNotProduceFrame(
    std::move(ack)
    );
}
void CompositorFrameSinkInterceptorForTesting::NotifyNewLocalSurfaceIdExpectedWhilePaused() {
  GetForwardingInterface()->NotifyNewLocalSurfaceIdExpectedWhilePaused();
}
void CompositorFrameSinkInterceptorForTesting::BindLayerContext(::viz::mojom::blink::PendingLayerContextPtr context, LayerContextSettingsPtr settings) {
  GetForwardingInterface()->BindLayerContext(
    std::move(context)
    , 
    std::move(settings)
    );
}
CompositorFrameSinkAsyncWaiter::CompositorFrameSinkAsyncWaiter(
    CompositorFrameSink* proxy) : proxy_(proxy) {}

CompositorFrameSinkAsyncWaiter::~CompositorFrameSinkAsyncWaiter() = default;





void CompositorFrameSinkClientInterceptorForTesting::DidReceiveCompositorFrameAck(::blink::Vector<::viz::ReturnedResource> resources) {
  GetForwardingInterface()->DidReceiveCompositorFrameAck(
    std::move(resources)
    );
}
void CompositorFrameSinkClientInterceptorForTesting::OnBeginFrame(const ::viz::BeginFrameArgs& args, const ::blink::HashMap<uint32_t, ::viz::FrameTimingDetails>& details, ::blink::Vector<::viz::ReturnedResource> resources) {
  GetForwardingInterface()->OnBeginFrame(
    std::move(args)
    , 
    std::move(details)
    , 
    std::move(resources)
    );
}
void CompositorFrameSinkClientInterceptorForTesting::OnBeginFramePausedChanged(bool paused) {
  GetForwardingInterface()->OnBeginFramePausedChanged(
    std::move(paused)
    );
}
void CompositorFrameSinkClientInterceptorForTesting::ReclaimResources(::blink::Vector<::viz::ReturnedResource> resources) {
  GetForwardingInterface()->ReclaimResources(
    std::move(resources)
    );
}
void CompositorFrameSinkClientInterceptorForTesting::OnCompositorFrameTransitionDirectiveProcessed(uint32_t sequence_id) {
  GetForwardingInterface()->OnCompositorFrameTransitionDirectiveProcessed(
    std::move(sequence_id)
    );
}
void CompositorFrameSinkClientInterceptorForTesting::OnSurfaceEvicted(const ::viz::LocalSurfaceId& local_surface_id) {
  GetForwardingInterface()->OnSurfaceEvicted(
    std::move(local_surface_id)
    );
}
CompositorFrameSinkClientAsyncWaiter::CompositorFrameSinkClientAsyncWaiter(
    CompositorFrameSinkClient* proxy) : proxy_(proxy) {}

CompositorFrameSinkClientAsyncWaiter::~CompositorFrameSinkClientAsyncWaiter() = default;







}  // viz::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif