// services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }
  var image_info$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/image_info.mojom', '../../../../../skia/public/mojom/image_info.mojom.js');
  }



  function BitmapInSharedMemory(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BitmapInSharedMemory.prototype.initDefaults_ = function() {
    this.imageInfo = null;
    this.rowBytes = 0;
    this.pixels = null;
  };
  BitmapInSharedMemory.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BitmapInSharedMemory.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitmapInSharedMemory.imageInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, image_info$.ImageInfo, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate BitmapInSharedMemory.pixels
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, shared_memory$.WritableSharedMemoryRegion, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BitmapInSharedMemory.encodedSize = codec.kStructHeaderSize + 24;

  BitmapInSharedMemory.decode = function(decoder) {
    var packed;
    var val = new BitmapInSharedMemory();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.imageInfo =
        decoder.decodeStructPointer(image_info$.ImageInfo);
    val.rowBytes =
        decoder.decodeStruct(codec.Uint64);
    val.pixels =
        decoder.decodeStructPointer(shared_memory$.WritableSharedMemoryRegion);
    return val;
  };

  BitmapInSharedMemory.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BitmapInSharedMemory.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(image_info$.ImageInfo, val.imageInfo);
    encoder.encodeStruct(codec.Uint64, val.rowBytes);
    encoder.encodeStructPointer(shared_memory$.WritableSharedMemoryRegion, val.pixels);
  };
  exports.BitmapInSharedMemory = BitmapInSharedMemory;
})();