// services/viz/public/mojom/compositing/animation.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/animation.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/animation.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/animation.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/animation.mojom-blink-import-headers.h"
#include "services/viz/public/mojom/compositing/animation.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace viz::mojom::blink {
CubicBezierTimingFunction::CubicBezierTimingFunction()
    : x1(),
      y1(),
      x2(),
      y2() {}

CubicBezierTimingFunction::CubicBezierTimingFunction(
    double x1_in,
    double y1_in,
    double x2_in,
    double y2_in)
    : x1(std::move(x1_in)),
      y1(std::move(y1_in)),
      x2(std::move(x2_in)),
      y2(std::move(y2_in)) {}

CubicBezierTimingFunction::~CubicBezierTimingFunction() = default;
size_t CubicBezierTimingFunction::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->x1);
  seed = mojo::internal::WTFHash(seed, this->y1);
  seed = mojo::internal::WTFHash(seed, this->x2);
  seed = mojo::internal::WTFHash(seed, this->y2);
  return seed;
}

void CubicBezierTimingFunction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x1"), this->x1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y1"), this->y1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x2"), this->x2,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y2"), this->y2,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CubicBezierTimingFunction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StepsTimingFunction::StepsTimingFunction()
    : num_steps(),
      step_position() {}

StepsTimingFunction::StepsTimingFunction(
    uint32_t num_steps_in,
    TimingStepPosition step_position_in)
    : num_steps(std::move(num_steps_in)),
      step_position(std::move(step_position_in)) {}

StepsTimingFunction::~StepsTimingFunction() = default;
size_t StepsTimingFunction::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->num_steps);
  seed = mojo::internal::WTFHash(seed, this->step_position);
  return seed;
}

void StepsTimingFunction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_steps"), this->num_steps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "step_position"), this->step_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TimingStepPosition>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StepsTimingFunction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LinearEasingPoint::LinearEasingPoint()
    : in(),
      out() {}

LinearEasingPoint::LinearEasingPoint(
    double in_in,
    double out_in)
    : in(std::move(in_in)),
      out(std::move(out_in)) {}

LinearEasingPoint::~LinearEasingPoint() = default;
size_t LinearEasingPoint::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->in);
  seed = mojo::internal::WTFHash(seed, this->out);
  return seed;
}

void LinearEasingPoint::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in"), this->in,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "out"), this->out,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LinearEasingPoint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AxisAngle::AxisAngle()
    : axis(),
      angle() {}

AxisAngle::AxisAngle(
    const ::gfx::Vector3dF& axis_in,
    float angle_in)
    : axis(std::move(axis_in)),
      angle(std::move(angle_in)) {}

AxisAngle::~AxisAngle() = default;

void AxisAngle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector3dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "angle"), this->angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AxisAngle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnimationKeyframe::AnimationKeyframe()
    : value(),
      start_time(),
      timing_function() {}

AnimationKeyframe::AnimationKeyframe(
    AnimationKeyframeValuePtr value_in,
    ::base::TimeDelta start_time_in,
    TimingFunctionPtr timing_function_in)
    : value(std::move(value_in)),
      start_time(std::move(start_time_in)),
      timing_function(std::move(timing_function_in)) {}

AnimationKeyframe::~AnimationKeyframe() = default;

void AnimationKeyframe::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AnimationKeyframeValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_time"), this->start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timing_function"), this->timing_function,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TimingFunctionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnimationKeyframe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnimationKeyframeModel::AnimationKeyframeModel()
    : id(),
      group_id(),
      target_property_type(),
      element_id(),
      timing_function(),
      keyframes(),
      scaled_duration(),
      direction(),
      fill_mode(),
      playback_rate(),
      iterations(),
      iteration_start(),
      time_offset() {}

AnimationKeyframeModel::AnimationKeyframeModel(
    int32_t id_in,
    int32_t group_id_in,
    int32_t target_property_type_in,
    ::cc::mojom::blink::ElementIdPtr element_id_in,
    TimingFunctionPtr timing_function_in,
    ::blink::Vector<AnimationKeyframePtr> keyframes_in,
    double scaled_duration_in,
    AnimationDirection direction_in,
    AnimationFillMode fill_mode_in,
    double playback_rate_in,
    double iterations_in,
    double iteration_start_in,
    ::base::TimeDelta time_offset_in)
    : id(std::move(id_in)),
      group_id(std::move(group_id_in)),
      target_property_type(std::move(target_property_type_in)),
      element_id(std::move(element_id_in)),
      timing_function(std::move(timing_function_in)),
      keyframes(std::move(keyframes_in)),
      scaled_duration(std::move(scaled_duration_in)),
      direction(std::move(direction_in)),
      fill_mode(std::move(fill_mode_in)),
      playback_rate(std::move(playback_rate_in)),
      iterations(std::move(iterations_in)),
      iteration_start(std::move(iteration_start_in)),
      time_offset(std::move(time_offset_in)) {}

AnimationKeyframeModel::~AnimationKeyframeModel() = default;

void AnimationKeyframeModel::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_property_type"), this->target_property_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::mojom::blink::ElementIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timing_function"), this->timing_function,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TimingFunctionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keyframes"), this->keyframes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<AnimationKeyframePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scaled_duration"), this->scaled_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direction"), this->direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AnimationDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fill_mode"), this->fill_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AnimationFillMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "playback_rate"), this->playback_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "iterations"), this->iterations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "iteration_start"), this->iteration_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_offset"), this->time_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnimationKeyframeModel::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Animation::Animation()
    : id(),
      element_id(),
      keyframe_models() {}

Animation::Animation(
    int32_t id_in,
    ::cc::mojom::blink::ElementIdPtr element_id_in,
    ::blink::Vector<AnimationKeyframeModelPtr> keyframe_models_in)
    : id(std::move(id_in)),
      element_id(std::move(element_id_in)),
      keyframe_models(std::move(keyframe_models_in)) {}

Animation::~Animation() = default;

void Animation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::mojom::blink::ElementIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keyframe_models"), this->keyframe_models,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<AnimationKeyframeModelPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Animation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnimationTimeline::AnimationTimeline()
    : id(),
      new_animations(),
      removed_animations() {}

AnimationTimeline::AnimationTimeline(
    int32_t id_in,
    ::blink::Vector<AnimationPtr> new_animations_in,
    ::blink::Vector<int32_t> removed_animations_in)
    : id(std::move(id_in)),
      new_animations(std::move(new_animations_in)),
      removed_animations(std::move(removed_animations_in)) {}

AnimationTimeline::~AnimationTimeline() = default;

void AnimationTimeline::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_animations"), this->new_animations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<AnimationPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "removed_animations"), this->removed_animations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnimationTimeline::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TimingFunctionPtr
TimingFunction::NewCubicBezier(
    CubicBezierTimingFunctionPtr value) {
  return TimingFunctionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCubicBezier)>,
      std::move(value));
}

TimingFunctionPtr
TimingFunction::NewSteps(
    StepsTimingFunctionPtr value) {
  return TimingFunctionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSteps)>,
      std::move(value));
}

TimingFunctionPtr
TimingFunction::NewLinear(
    ::blink::Vector<LinearEasingPointPtr> value) {
  return TimingFunctionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kLinear)>,
      std::move(value));
}

TimingFunction::TimingFunction(
    std::in_place_index_t<static_cast<size_t>(Tag::kCubicBezier)>,
    CubicBezierTimingFunctionPtr value)
    : tag_(Tag::kCubicBezier),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCubicBezier)>,
            std::move(value)) {}

TimingFunction::TimingFunction(
    std::in_place_index_t<static_cast<size_t>(Tag::kSteps)>,
    StepsTimingFunctionPtr value)
    : tag_(Tag::kSteps),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSteps)>,
            std::move(value)) {}

TimingFunction::TimingFunction(
    std::in_place_index_t<static_cast<size_t>(Tag::kLinear)>,
    ::blink::Vector<LinearEasingPointPtr> value)
    : tag_(Tag::kLinear),
      data_(std::in_place_index<static_cast<size_t>(Tag::kLinear)>,
            std::move(value)) {}
TimingFunction::~TimingFunction() {
  DestroyActive();
}

void TimingFunction::set_cubic_bezier(CubicBezierTimingFunctionPtr cubic_bezier) {
  if (tag_ == Tag::kCubicBezier) {
    data_.cubic_bezier = std::move(cubic_bezier);
  } else {
    DestroyActive();
    tag_ = Tag::kCubicBezier;
    new (&data_.cubic_bezier) CubicBezierTimingFunctionPtr(
        std::move(cubic_bezier));
  }
}

void TimingFunction::set_steps(StepsTimingFunctionPtr steps) {
  if (tag_ == Tag::kSteps) {
    data_.steps = std::move(steps);
  } else {
    DestroyActive();
    tag_ = Tag::kSteps;
    new (&data_.steps) StepsTimingFunctionPtr(
        std::move(steps));
  }
}

void TimingFunction::set_linear(::blink::Vector<LinearEasingPointPtr> linear) {
  if (tag_ == Tag::kLinear) {
    data_.linear = std::move(linear);
  } else {
    DestroyActive();
    tag_ = Tag::kLinear;
    new (&data_.linear) ::blink::Vector<LinearEasingPointPtr>(
        std::move(linear));
  }
}


TimingFunction::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCubicBezier)>,
    CubicBezierTimingFunctionPtr value)
    : cubic_bezier(std::move(value)) {}

TimingFunction::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSteps)>,
    StepsTimingFunctionPtr value)
    : steps(std::move(value)) {}

TimingFunction::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kLinear)>,
    ::blink::Vector<LinearEasingPointPtr> value)
    : linear(std::move(value)) {}

void TimingFunction::DestroyActive() {
  switch (tag_) {

    case Tag::kCubicBezier:
      std::destroy_at(&data_.cubic_bezier);
      break;
    case Tag::kSteps:
      std::destroy_at(&data_.steps);
      break;
    case Tag::kLinear:
      std::destroy_at(&data_.linear);
      break;
  }
}

bool TimingFunction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
TransformOperationPtr
TransformOperation::NewIdentity(
    bool value) {
  return TransformOperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kIdentity)>,
      std::move(value));
}

TransformOperationPtr
TransformOperation::NewPerspectiveDepth(
    float value) {
  return TransformOperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPerspectiveDepth)>,
      std::move(value));
}

TransformOperationPtr
TransformOperation::NewSkew(
    const ::gfx::Vector2dF& value) {
  return TransformOperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSkew)>,
      std::move(value));
}

TransformOperationPtr
TransformOperation::NewScale(
    const ::gfx::Vector3dF& value) {
  return TransformOperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kScale)>,
      std::move(value));
}

TransformOperationPtr
TransformOperation::NewTranslate(
    const ::gfx::Vector3dF& value) {
  return TransformOperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTranslate)>,
      std::move(value));
}

TransformOperationPtr
TransformOperation::NewRotate(
    AxisAnglePtr value) {
  return TransformOperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRotate)>,
      std::move(value));
}

TransformOperationPtr
TransformOperation::NewMatrix(
    const ::gfx::Transform& value) {
  return TransformOperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kMatrix)>,
      std::move(value));
}

TransformOperation::TransformOperation(
    std::in_place_index_t<static_cast<size_t>(Tag::kIdentity)>,
    bool value)
    : tag_(Tag::kIdentity),
      data_(std::in_place_index<static_cast<size_t>(Tag::kIdentity)>,
            std::move(value)) {}

TransformOperation::TransformOperation(
    std::in_place_index_t<static_cast<size_t>(Tag::kPerspectiveDepth)>,
    float value)
    : tag_(Tag::kPerspectiveDepth),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPerspectiveDepth)>,
            std::move(value)) {}

TransformOperation::TransformOperation(
    std::in_place_index_t<static_cast<size_t>(Tag::kSkew)>,
    const ::gfx::Vector2dF& value)
    : tag_(Tag::kSkew),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSkew)>,
            std::move(value)) {}

TransformOperation::TransformOperation(
    std::in_place_index_t<static_cast<size_t>(Tag::kScale)>,
    const ::gfx::Vector3dF& value)
    : tag_(Tag::kScale),
      data_(std::in_place_index<static_cast<size_t>(Tag::kScale)>,
            std::move(value)) {}

TransformOperation::TransformOperation(
    std::in_place_index_t<static_cast<size_t>(Tag::kTranslate)>,
    const ::gfx::Vector3dF& value)
    : tag_(Tag::kTranslate),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTranslate)>,
            std::move(value)) {}

TransformOperation::TransformOperation(
    std::in_place_index_t<static_cast<size_t>(Tag::kRotate)>,
    AxisAnglePtr value)
    : tag_(Tag::kRotate),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRotate)>,
            std::move(value)) {}

TransformOperation::TransformOperation(
    std::in_place_index_t<static_cast<size_t>(Tag::kMatrix)>,
    const ::gfx::Transform& value)
    : tag_(Tag::kMatrix),
      data_(std::in_place_index<static_cast<size_t>(Tag::kMatrix)>,
            std::move(value)) {}
TransformOperation::~TransformOperation() {
  DestroyActive();
}

void TransformOperation::set_identity(bool identity) {
  if (tag_ != Tag::kIdentity) {
    DestroyActive();
    tag_ = Tag::kIdentity;
  }
  data_.identity = identity;
}

void TransformOperation::set_perspective_depth(float perspective_depth) {
  if (tag_ != Tag::kPerspectiveDepth) {
    DestroyActive();
    tag_ = Tag::kPerspectiveDepth;
  }
  data_.perspective_depth = perspective_depth;
}

void TransformOperation::set_skew(const ::gfx::Vector2dF& skew) {
  if (tag_ == Tag::kSkew) {
    data_.skew = std::move(skew);
  } else {
    DestroyActive();
    tag_ = Tag::kSkew;
    new (&data_.skew) ::gfx::Vector2dF(
        std::move(skew));
  }
}

void TransformOperation::set_scale(const ::gfx::Vector3dF& scale) {
  if (tag_ == Tag::kScale) {
    data_.scale = std::move(scale);
  } else {
    DestroyActive();
    tag_ = Tag::kScale;
    new (&data_.scale) ::gfx::Vector3dF(
        std::move(scale));
  }
}

void TransformOperation::set_translate(const ::gfx::Vector3dF& translate) {
  if (tag_ == Tag::kTranslate) {
    data_.translate = std::move(translate);
  } else {
    DestroyActive();
    tag_ = Tag::kTranslate;
    new (&data_.translate) ::gfx::Vector3dF(
        std::move(translate));
  }
}

void TransformOperation::set_rotate(AxisAnglePtr rotate) {
  if (tag_ == Tag::kRotate) {
    data_.rotate = std::move(rotate);
  } else {
    DestroyActive();
    tag_ = Tag::kRotate;
    new (&data_.rotate) AxisAnglePtr(
        std::move(rotate));
  }
}

void TransformOperation::set_matrix(const ::gfx::Transform& matrix) {
  if (tag_ == Tag::kMatrix) {
    data_.matrix = std::move(matrix);
  } else {
    DestroyActive();
    tag_ = Tag::kMatrix;
    new (&data_.matrix) ::gfx::Transform(
        std::move(matrix));
  }
}


TransformOperation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kIdentity)>,
    bool value)
    : identity(std::move(value)) {}

TransformOperation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPerspectiveDepth)>,
    float value)
    : perspective_depth(std::move(value)) {}

TransformOperation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSkew)>,
    const ::gfx::Vector2dF& value)
    : skew(std::move(value)) {}

TransformOperation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kScale)>,
    const ::gfx::Vector3dF& value)
    : scale(std::move(value)) {}

TransformOperation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTranslate)>,
    const ::gfx::Vector3dF& value)
    : translate(std::move(value)) {}

TransformOperation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRotate)>,
    AxisAnglePtr value)
    : rotate(std::move(value)) {}

TransformOperation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kMatrix)>,
    const ::gfx::Transform& value)
    : matrix(std::move(value)) {}

void TransformOperation::DestroyActive() {
  switch (tag_) {

    case Tag::kIdentity:
      std::destroy_at(&data_.identity);
      break;
    case Tag::kPerspectiveDepth:
      std::destroy_at(&data_.perspective_depth);
      break;
    case Tag::kSkew:
      std::destroy_at(&data_.skew);
      break;
    case Tag::kScale:
      std::destroy_at(&data_.scale);
      break;
    case Tag::kTranslate:
      std::destroy_at(&data_.translate);
      break;
    case Tag::kRotate:
      std::destroy_at(&data_.rotate);
      break;
    case Tag::kMatrix:
      std::destroy_at(&data_.matrix);
      break;
  }
}

bool TransformOperation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
AnimationKeyframeValuePtr
AnimationKeyframeValue::NewScalar(
    float value) {
  return AnimationKeyframeValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kScalar)>,
      std::move(value));
}

AnimationKeyframeValuePtr
AnimationKeyframeValue::NewColor(
    ::SkColor value) {
  return AnimationKeyframeValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kColor)>,
      std::move(value));
}

AnimationKeyframeValuePtr
AnimationKeyframeValue::NewSize(
    const ::gfx::SizeF& value) {
  return AnimationKeyframeValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSize)>,
      std::move(value));
}

AnimationKeyframeValuePtr
AnimationKeyframeValue::NewRect(
    const ::gfx::Rect& value) {
  return AnimationKeyframeValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRect)>,
      std::move(value));
}

AnimationKeyframeValuePtr
AnimationKeyframeValue::NewTransform(
    ::blink::Vector<TransformOperationPtr> value) {
  return AnimationKeyframeValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTransform)>,
      std::move(value));
}

AnimationKeyframeValue::AnimationKeyframeValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kScalar)>,
    float value)
    : tag_(Tag::kScalar),
      data_(std::in_place_index<static_cast<size_t>(Tag::kScalar)>,
            std::move(value)) {}

AnimationKeyframeValue::AnimationKeyframeValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kColor)>,
    ::SkColor value)
    : tag_(Tag::kColor),
      data_(std::in_place_index<static_cast<size_t>(Tag::kColor)>,
            std::move(value)) {}

AnimationKeyframeValue::AnimationKeyframeValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kSize)>,
    const ::gfx::SizeF& value)
    : tag_(Tag::kSize),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSize)>,
            std::move(value)) {}

AnimationKeyframeValue::AnimationKeyframeValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kRect)>,
    const ::gfx::Rect& value)
    : tag_(Tag::kRect),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRect)>,
            std::move(value)) {}

AnimationKeyframeValue::AnimationKeyframeValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kTransform)>,
    ::blink::Vector<TransformOperationPtr> value)
    : tag_(Tag::kTransform),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTransform)>,
            std::move(value)) {}
AnimationKeyframeValue::~AnimationKeyframeValue() {
  DestroyActive();
}

void AnimationKeyframeValue::set_scalar(float scalar) {
  if (tag_ != Tag::kScalar) {
    DestroyActive();
    tag_ = Tag::kScalar;
  }
  data_.scalar = scalar;
}

void AnimationKeyframeValue::set_color(::SkColor color) {
  if (tag_ == Tag::kColor) {
    data_.color = std::move(color);
  } else {
    DestroyActive();
    tag_ = Tag::kColor;
    new (&data_.color) ::SkColor(
        std::move(color));
  }
}

void AnimationKeyframeValue::set_size(const ::gfx::SizeF& size) {
  if (tag_ == Tag::kSize) {
    data_.size = std::move(size);
  } else {
    DestroyActive();
    tag_ = Tag::kSize;
    new (&data_.size) ::gfx::SizeF(
        std::move(size));
  }
}

void AnimationKeyframeValue::set_rect(const ::gfx::Rect& rect) {
  if (tag_ == Tag::kRect) {
    data_.rect = std::move(rect);
  } else {
    DestroyActive();
    tag_ = Tag::kRect;
    new (&data_.rect) ::gfx::Rect(
        std::move(rect));
  }
}

void AnimationKeyframeValue::set_transform(::blink::Vector<TransformOperationPtr> transform) {
  if (tag_ == Tag::kTransform) {
    data_.transform = std::move(transform);
  } else {
    DestroyActive();
    tag_ = Tag::kTransform;
    new (&data_.transform) ::blink::Vector<TransformOperationPtr>(
        std::move(transform));
  }
}


AnimationKeyframeValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kScalar)>,
    float value)
    : scalar(std::move(value)) {}

AnimationKeyframeValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kColor)>,
    ::SkColor value)
    : color(std::move(value)) {}

AnimationKeyframeValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSize)>,
    const ::gfx::SizeF& value)
    : size(std::move(value)) {}

AnimationKeyframeValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRect)>,
    const ::gfx::Rect& value)
    : rect(std::move(value)) {}

AnimationKeyframeValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTransform)>,
    ::blink::Vector<TransformOperationPtr> value)
    : transform(std::move(value)) {}

void AnimationKeyframeValue::DestroyActive() {
  switch (tag_) {

    case Tag::kScalar:
      std::destroy_at(&data_.scalar);
      break;
    case Tag::kColor:
      std::destroy_at(&data_.color);
      break;
    case Tag::kSize:
      std::destroy_at(&data_.size);
      break;
    case Tag::kRect:
      std::destroy_at(&data_.rect);
      break;
    case Tag::kTransform:
      std::destroy_at(&data_.transform);
      break;
  }
}

bool AnimationKeyframeValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // viz::mojom::blink


namespace mojo {


// static
bool StructTraits<::viz::mojom::blink::CubicBezierTimingFunction::DataView, ::viz::mojom::blink::CubicBezierTimingFunctionPtr>::Read(
    ::viz::mojom::blink::CubicBezierTimingFunction::DataView input,
    ::viz::mojom::blink::CubicBezierTimingFunctionPtr* output) {
  bool success = true;
  ::viz::mojom::blink::CubicBezierTimingFunctionPtr result(::viz::mojom::blink::CubicBezierTimingFunction::New());
  
      if (success)
        result->x1 = input.x1();
      if (success)
        result->y1 = input.y1();
      if (success)
        result->x2 = input.x2();
      if (success)
        result->y2 = input.y2();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::StepsTimingFunction::DataView, ::viz::mojom::blink::StepsTimingFunctionPtr>::Read(
    ::viz::mojom::blink::StepsTimingFunction::DataView input,
    ::viz::mojom::blink::StepsTimingFunctionPtr* output) {
  bool success = true;
  ::viz::mojom::blink::StepsTimingFunctionPtr result(::viz::mojom::blink::StepsTimingFunction::New());
  
      if (success)
        result->num_steps = input.num_steps();
      if (success && !input.ReadStepPosition(&result->step_position))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::LinearEasingPoint::DataView, ::viz::mojom::blink::LinearEasingPointPtr>::Read(
    ::viz::mojom::blink::LinearEasingPoint::DataView input,
    ::viz::mojom::blink::LinearEasingPointPtr* output) {
  bool success = true;
  ::viz::mojom::blink::LinearEasingPointPtr result(::viz::mojom::blink::LinearEasingPoint::New());
  
      if (success)
        result->in = input.in();
      if (success)
        result->out = input.out();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::AxisAngle::DataView, ::viz::mojom::blink::AxisAnglePtr>::Read(
    ::viz::mojom::blink::AxisAngle::DataView input,
    ::viz::mojom::blink::AxisAnglePtr* output) {
  bool success = true;
  ::viz::mojom::blink::AxisAnglePtr result(::viz::mojom::blink::AxisAngle::New());
  
      if (success && !input.ReadAxis(&result->axis))
        success = false;
      if (success)
        result->angle = input.angle();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::AnimationKeyframe::DataView, ::viz::mojom::blink::AnimationKeyframePtr>::Read(
    ::viz::mojom::blink::AnimationKeyframe::DataView input,
    ::viz::mojom::blink::AnimationKeyframePtr* output) {
  bool success = true;
  ::viz::mojom::blink::AnimationKeyframePtr result(::viz::mojom::blink::AnimationKeyframe::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadStartTime(&result->start_time))
        success = false;
      if (success && !input.ReadTimingFunction(&result->timing_function))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::AnimationKeyframeModel::DataView, ::viz::mojom::blink::AnimationKeyframeModelPtr>::Read(
    ::viz::mojom::blink::AnimationKeyframeModel::DataView input,
    ::viz::mojom::blink::AnimationKeyframeModelPtr* output) {
  bool success = true;
  ::viz::mojom::blink::AnimationKeyframeModelPtr result(::viz::mojom::blink::AnimationKeyframeModel::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->group_id = input.group_id();
      if (success)
        result->target_property_type = input.target_property_type();
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success && !input.ReadTimingFunction(&result->timing_function))
        success = false;
      if (success && !input.ReadKeyframes(&result->keyframes))
        success = false;
      if (success)
        result->scaled_duration = input.scaled_duration();
      if (success && !input.ReadDirection(&result->direction))
        success = false;
      if (success && !input.ReadFillMode(&result->fill_mode))
        success = false;
      if (success)
        result->playback_rate = input.playback_rate();
      if (success)
        result->iterations = input.iterations();
      if (success)
        result->iteration_start = input.iteration_start();
      if (success && !input.ReadTimeOffset(&result->time_offset))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::Animation::DataView, ::viz::mojom::blink::AnimationPtr>::Read(
    ::viz::mojom::blink::Animation::DataView input,
    ::viz::mojom::blink::AnimationPtr* output) {
  bool success = true;
  ::viz::mojom::blink::AnimationPtr result(::viz::mojom::blink::Animation::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success && !input.ReadKeyframeModels(&result->keyframe_models))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::AnimationTimeline::DataView, ::viz::mojom::blink::AnimationTimelinePtr>::Read(
    ::viz::mojom::blink::AnimationTimeline::DataView input,
    ::viz::mojom::blink::AnimationTimelinePtr* output) {
  bool success = true;
  ::viz::mojom::blink::AnimationTimelinePtr result(::viz::mojom::blink::AnimationTimeline::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadNewAnimations(&result->new_animations))
        success = false;
      if (success && !input.ReadRemovedAnimations(&result->removed_animations))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::viz::mojom::blink::TimingFunction::DataView, ::viz::mojom::blink::TimingFunctionPtr>::Read(
    ::viz::mojom::blink::TimingFunction::DataView input,
    ::viz::mojom::blink::TimingFunctionPtr* output) {
  using UnionType = ::viz::mojom::blink::TimingFunction;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kCubicBezier: {
      ::viz::mojom::blink::CubicBezierTimingFunctionPtr result_cubic_bezier{};
      if (!input.ReadCubicBezier(&result_cubic_bezier))
        return false;

      *output = UnionType::NewCubicBezier(
          std::move(result_cubic_bezier));
      break;
    }
    case Tag::kSteps: {
      ::viz::mojom::blink::StepsTimingFunctionPtr result_steps{};
      if (!input.ReadSteps(&result_steps))
        return false;

      *output = UnionType::NewSteps(
          std::move(result_steps));
      break;
    }
    case Tag::kLinear: {
      ::blink::Vector<::viz::mojom::blink::LinearEasingPointPtr> result_linear{};
      if (!input.ReadLinear(&result_linear))
        return false;

      *output = UnionType::NewLinear(
          std::move(result_linear));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::viz::mojom::blink::TransformOperation::DataView, ::viz::mojom::blink::TransformOperationPtr>::Read(
    ::viz::mojom::blink::TransformOperation::DataView input,
    ::viz::mojom::blink::TransformOperationPtr* output) {
  using UnionType = ::viz::mojom::blink::TransformOperation;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kIdentity: {
      *output = UnionType::NewIdentity(input.identity());
      break;
    }
    case Tag::kPerspectiveDepth: {
      *output = UnionType::NewPerspectiveDepth(input.perspective_depth());
      break;
    }
    case Tag::kSkew: {
      ::gfx::Vector2dF result_skew{};
      if (!input.ReadSkew(&result_skew))
        return false;

      *output = UnionType::NewSkew(
          std::move(result_skew));
      break;
    }
    case Tag::kScale: {
      ::gfx::Vector3dF result_scale{};
      if (!input.ReadScale(&result_scale))
        return false;

      *output = UnionType::NewScale(
          std::move(result_scale));
      break;
    }
    case Tag::kTranslate: {
      ::gfx::Vector3dF result_translate{};
      if (!input.ReadTranslate(&result_translate))
        return false;

      *output = UnionType::NewTranslate(
          std::move(result_translate));
      break;
    }
    case Tag::kRotate: {
      ::viz::mojom::blink::AxisAnglePtr result_rotate{};
      if (!input.ReadRotate(&result_rotate))
        return false;

      *output = UnionType::NewRotate(
          std::move(result_rotate));
      break;
    }
    case Tag::kMatrix: {
      ::gfx::Transform result_matrix{};
      if (!input.ReadMatrix(&result_matrix))
        return false;

      *output = UnionType::NewMatrix(
          std::move(result_matrix));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::viz::mojom::blink::AnimationKeyframeValue::DataView, ::viz::mojom::blink::AnimationKeyframeValuePtr>::Read(
    ::viz::mojom::blink::AnimationKeyframeValue::DataView input,
    ::viz::mojom::blink::AnimationKeyframeValuePtr* output) {
  using UnionType = ::viz::mojom::blink::AnimationKeyframeValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kScalar: {
      *output = UnionType::NewScalar(input.scalar());
      break;
    }
    case Tag::kColor: {
      ::SkColor result_color{};
      if (!input.ReadColor(&result_color))
        return false;

      *output = UnionType::NewColor(
          std::move(result_color));
      break;
    }
    case Tag::kSize: {
      ::gfx::SizeF result_size{};
      if (!input.ReadSize(&result_size))
        return false;

      *output = UnionType::NewSize(
          std::move(result_size));
      break;
    }
    case Tag::kRect: {
      ::gfx::Rect result_rect{};
      if (!input.ReadRect(&result_rect))
        return false;

      *output = UnionType::NewRect(
          std::move(result_rect));
      break;
    }
    case Tag::kTransform: {
      ::blink::Vector<::viz::mojom::blink::TransformOperationPtr> result_transform{};
      if (!input.ReadTransform(&result_transform))
        return false;

      *output = UnionType::NewTransform(
          std::move(result_transform));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom::blink {




}  // viz::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif