// services/viz/privileged/mojom/gl/gpu_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/gl/gpu_service.mojom-features.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/device_perf_info.mojom-forward.h"
#include "gpu/ipc/common/gpu_disk_cache_type.mojom.h"
#include "gpu/ipc/common/gpu_feature_info.mojom.h"
#include "gpu/ipc/common/gpu_info.mojom.h"
#include "gpu/ipc/common/gpu_peak_memory.mojom.h"
#include "gpu/ipc/common/memory_stats.mojom.h"
#include "gpu/ipc/common/shared_image_capabilities.mojom.h"
#include "gpu/ipc/common/surface_handle.mojom-forward.h"
#include "gpu/ipc/common/sync_token.mojom-forward.h"
#include "media/mojo/mojom/video_encode_accelerator.mojom-forward.h"
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom.h"
#include "mojo/public/mojom/base/process_id.mojom.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "services/webnn/public/mojom/features.mojom-forward.h"
#include "services/webnn/public/mojom/webnn_context_provider.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"
#include "ui/gfx/mojom/buffer_types.mojom-forward.h"
#include "ui/gl/mojom/gpu_preference.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace viz::mojom {

class GpuServiceProxy;

template <typename ImplRefTraits>
class GpuServiceStub;

class GpuServiceRequestValidator;
class GpuServiceResponseValidator;


class GpuService
    : public GpuServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.GpuService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = true;

  using Base_ = GpuServiceInterfaceBase;
  using Proxy_ = GpuServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = GpuServiceStub<ImplRefTraits>;

  using RequestValidator_ = GpuServiceRequestValidator;
  using ResponseValidator_ = GpuServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kEstablishGpuChannelMinVersion = 0,
    kSetChannelClientPidMinVersion = 0,
    kSetChannelDiskCacheHandleMinVersion = 0,
    kSetChannelPersistentCacheFileMinVersion = 0,
    kOnDiskCacheHandleDestoyedMinVersion = 0,
    kCloseChannelMinVersion = 0,
    kCreateVideoEncodeAcceleratorProviderMinVersion = 0,
    kBindWebNNContextProviderMinVersion = 0,
    kGetVideoMemoryUsageStatsMinVersion = 0,
    kStartPeakMemoryMonitorMinVersion = 0,
    kGetPeakMemoryUsageMinVersion = 0,
    kLoadedBlobMinVersion = 0,
    kWakeUpGpuMinVersion = 0,
    kGpuSwitchedMinVersion = 0,
    kDisplayAddedMinVersion = 0,
    kDisplayRemovedMinVersion = 0,
    kDisplayMetricsChangedMinVersion = 0,
    kDestroyAllChannelsMinVersion = 0,
    kOnBackgroundCleanupMinVersion = 0,
    kOnBackgroundedMinVersion = 0,
    kOnForegroundedMinVersion = 0,
    kOnMemoryPressureMinVersion = 0,
    kBeginCATransactionMinVersion = 0,
    kCommitCATransactionMinVersion = 0,
    kGetDawnInfoMinVersion = 0,
    kCrashMinVersion = 0,
    kHangMinVersion = 0,
    kThrowJavaExceptionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EstablishGpuChannel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetChannelClientPid_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetChannelDiskCacheHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetChannelPersistentCacheFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDiskCacheHandleDestoyed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseChannel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateVideoEncodeAcceleratorProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindWebNNContextProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetVideoMemoryUsageStats_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartPeakMemoryMonitor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPeakMemoryUsage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadedBlob_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WakeUpGpu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GpuSwitched_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisplayAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisplayRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisplayMetricsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DestroyAllChannels_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBackgroundCleanup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBackgrounded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnForegrounded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMemoryPressure_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BeginCATransaction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CommitCATransaction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDawnInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Crash_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Hang_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ThrowJavaException_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GpuService() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool EstablishGpuChannel(int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, ::mojo::ScopedMessagePipeHandle* out_channel_handle, ::gpu::GPUInfo* out_gpu_info, ::gpu::GpuFeatureInfo* out_gpu_feature_info, ::gpu::SharedImageCapabilities* out_shared_image_capabilities);
  using EstablishGpuChannelCallback = base::OnceCallback<void(::mojo::ScopedMessagePipeHandle, const ::gpu::GPUInfo&, const ::gpu::GpuFeatureInfo&, const ::gpu::SharedImageCapabilities&)>;
  using EstablishGpuChannelMojoCallback = base::OnceCallback<void(::mojo::ScopedMessagePipeHandle, const ::gpu::GPUInfo&, const ::gpu::GpuFeatureInfo&, const ::gpu::SharedImageCapabilities&)>;

  virtual void EstablishGpuChannel(int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, EstablishGpuChannelCallback callback) = 0;

  virtual void SetChannelClientPid(int32_t client_id, ::base::ProcessId client_pid) = 0;

  virtual void SetChannelDiskCacheHandle(int32_t client_id, const ::gpu::GpuDiskCacheHandle& cache_handle) = 0;

  virtual void SetChannelPersistentCacheFile(int32_t client_id, const ::gpu::GpuDiskCacheHandle& cache_handle, ::base::File db_file, ::base::File journal_file, ::base::UnsafeSharedMemoryRegion shared_lock) = 0;

  virtual void OnDiskCacheHandleDestoyed(const ::gpu::GpuDiskCacheHandle& cache_handle) = 0;

  virtual void CloseChannel(int32_t client_id) = 0;

  virtual void CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> vea_provider) = 0;

  virtual void BindWebNNContextProvider(::mojo::PendingReceiver<::webnn::mojom::WebNNContextProvider> receiver, int32_t client_id) = 0;

  using GetVideoMemoryUsageStatsCallback = base::OnceCallback<void(const ::gpu::VideoMemoryUsageStats&)>;
  using GetVideoMemoryUsageStatsMojoCallback = base::OnceCallback<void(const ::gpu::VideoMemoryUsageStats&)>;

  virtual void GetVideoMemoryUsageStats(GetVideoMemoryUsageStatsCallback callback) = 0;

  virtual void StartPeakMemoryMonitor(uint32_t sequence_num) = 0;

  using GetPeakMemoryUsageCallback = base::OnceCallback<void(uint64_t, const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>&)>;
  using GetPeakMemoryUsageMojoCallback = base::OnceCallback<void(uint64_t, const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>&)>;

  virtual void GetPeakMemoryUsage(uint32_t sequence_num, GetPeakMemoryUsageCallback callback) = 0;

  virtual void LoadedBlob(const ::gpu::GpuDiskCacheHandle& cache_handle, const std::string& key, const std::string& data) = 0;

  virtual void WakeUpGpu() = 0;

  virtual void GpuSwitched() = 0;

  virtual void DisplayAdded() = 0;

  virtual void DisplayRemoved() = 0;

  virtual void DisplayMetricsChanged() = 0;

  virtual void DestroyAllChannels() = 0;

  virtual void OnBackgroundCleanup() = 0;

  virtual void OnBackgrounded() = 0;

  virtual void OnForegrounded() = 0;

  virtual void OnMemoryPressure(::base::MemoryPressureListener::MemoryPressureLevel level) = 0;

  virtual void BeginCATransaction() = 0;

  using CommitCATransactionCallback = base::OnceCallback<void()>;
  using CommitCATransactionMojoCallback = base::OnceCallback<void()>;

  virtual void CommitCATransaction(CommitCATransactionCallback callback) = 0;

  using GetDawnInfoCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  using GetDawnInfoMojoCallback = base::OnceCallback<void(const std::vector<std::string>&)>;

  virtual void GetDawnInfo(bool collect_metrics, GetDawnInfoCallback callback) = 0;

  virtual void Crash() = 0;

  virtual void Hang() = 0;

  virtual void ThrowJavaException() = 0;
};



class  GpuServiceProxy
    : public GpuService {
 public:
  using InterfaceType = GpuService;

  explicit GpuServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool EstablishGpuChannel(int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, ::mojo::ScopedMessagePipeHandle* out_channel_handle, ::gpu::GPUInfo* out_gpu_info, ::gpu::GpuFeatureInfo* out_gpu_feature_info, ::gpu::SharedImageCapabilities* out_shared_image_capabilities) final;
  
  void EstablishGpuChannel(int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, EstablishGpuChannelCallback callback) final;
  
  void SetChannelClientPid(int32_t client_id, ::base::ProcessId client_pid) final;
  
  void SetChannelDiskCacheHandle(int32_t client_id, const ::gpu::GpuDiskCacheHandle& cache_handle) final;
  
  void SetChannelPersistentCacheFile(int32_t client_id, const ::gpu::GpuDiskCacheHandle& cache_handle, ::base::File db_file, ::base::File journal_file, ::base::UnsafeSharedMemoryRegion shared_lock) final;
  
  void OnDiskCacheHandleDestoyed(const ::gpu::GpuDiskCacheHandle& cache_handle) final;
  
  void CloseChannel(int32_t client_id) final;
  
  void CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> vea_provider) final;
  
  void BindWebNNContextProvider(::mojo::PendingReceiver<::webnn::mojom::WebNNContextProvider> receiver, int32_t client_id) final;
  
  void GetVideoMemoryUsageStats(GetVideoMemoryUsageStatsCallback callback) final;
  
  void StartPeakMemoryMonitor(uint32_t sequence_num) final;
  
  void GetPeakMemoryUsage(uint32_t sequence_num, GetPeakMemoryUsageCallback callback) final;
  
  void LoadedBlob(const ::gpu::GpuDiskCacheHandle& cache_handle, const std::string& key, const std::string& data) final;
  
  void WakeUpGpu() final;
  
  void GpuSwitched() final;
  
  void DisplayAdded() final;
  
  void DisplayRemoved() final;
  
  void DisplayMetricsChanged() final;
  
  void DestroyAllChannels() final;
  
  void OnBackgroundCleanup() final;
  
  void OnBackgrounded() final;
  
  void OnForegrounded() final;
  
  void OnMemoryPressure(::base::MemoryPressureListener::MemoryPressureLevel level) final;
  
  void BeginCATransaction() final;
  
  void CommitCATransaction(CommitCATransactionCallback callback) final;
  
  void GetDawnInfo(bool collect_metrics, GetDawnInfoCallback callback) final;
  
  void Crash() final;
  
  void Hang() final;
  
  void ThrowJavaException() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GpuServiceStubDispatch {
 public:
  static bool Accept(GpuService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GpuService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GpuService>>
class GpuServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GpuServiceStub() = default;
  ~GpuServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GpuServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GpuServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // viz::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_H_