// services/viz/privileged/mojom/gl/gpu_logging.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/gl/gpu_logging.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/gl/gpu_logging.mojom-params-data.h"
#include "services/viz/privileged/mojom/gl/gpu_logging.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/gl/gpu_logging.mojom-import-headers.h"
#include "services/viz/privileged/mojom/gl/gpu_logging.mojom-test-utils.h"


namespace viz::mojom {
// The declaration includes the definition on other builds.

GpuLogging::IPCStableHashFunction GpuLogging::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GpuLogging>(message.name())) {
    case messages::GpuLogging::kRecordLogMessage: {
      return &GpuLogging::RecordLogMessage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GpuLogging::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GpuLogging>(message.name())) {
      case messages::GpuLogging::kRecordLogMessage:
            return "Receive viz::mojom::GpuLogging::RecordLogMessage";
    }
  } else {
    switch (static_cast<messages::GpuLogging>(message.name())) {
      case messages::GpuLogging::kRecordLogMessage:
            return "Receive reply viz::mojom::GpuLogging::RecordLogMessage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GpuLogging::RecordLogMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25b6b352;  // IPCStableHash for viz::mojom::GpuLogging::RecordLogMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

GpuLoggingProxy::GpuLoggingProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuLoggingProxy::RecordLogMessage(
    int32_t in_severity, const std::string& in_header, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuLogging::RecordLogMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("severity"), in_severity,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header"), in_header,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuLogging::kRecordLogMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuLogging_RecordLogMessage_Params_Data> params(
          message);
  params.Allocate();

  params->severity = in_severity;
  mojo::internal::MessageFragment<
      typename decltype(params->header)::BaseType> header_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_header,
    header_fragment);

  params->header.Set(
      header_fragment.is_null() ? nullptr : header_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->header.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null header in GpuLogging.RecordLogMessage request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in GpuLogging.RecordLogMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuLogging::Name_);
  message.set_method_name("RecordLogMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool GpuLoggingStubDispatch::Accept(
    GpuLogging* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GpuLogging>(message->header()->name)) {
    case messages::GpuLogging::kRecordLogMessage: {
      DCHECK(message->is_serialized());
      internal::GpuLogging_RecordLogMessage_Params_Data* params =
          reinterpret_cast<internal::GpuLogging_RecordLogMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuLogging.0
      bool success = true;
      int32_t p_severity{};
      std::string p_header{};
      std::string p_message{};
      GpuLogging_RecordLogMessage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_severity = input_data_view.severity();
      if (success && !input_data_view.ReadHeader(&p_header))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuLogging::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordLogMessage(        
        std::move(p_severity), 
        std::move(p_header), 
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool GpuLoggingStubDispatch::AcceptWithResponder(
    GpuLogging* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GpuLogging>(message->header()->name)) {
    case messages::GpuLogging::kRecordLogMessage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGpuLoggingValidationInfo[] = {
    { &internal::GpuLogging_RecordLogMessage_Params_Data::Validate,
     nullptr /* no response */},
};

bool GpuLoggingRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::GpuLogging::Name_,
    kGpuLoggingValidationInfo);
}



}  // viz::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void GpuLoggingInterceptorForTesting::RecordLogMessage(int32_t severity, const std::string& header, const std::string& message) {
  GetForwardingInterface()->RecordLogMessage(
    std::move(severity)
    , 
    std::move(header)
    , 
    std::move(message)
    );
}
GpuLoggingAsyncWaiter::GpuLoggingAsyncWaiter(
    GpuLogging* proxy) : proxy_(proxy) {}

GpuLoggingAsyncWaiter::~GpuLoggingAsyncWaiter() = default;







}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif