// services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-params-data.h"
namespace viz {
namespace mojom {

namespace internal {


// static
bool RootCompositorFrameSinkParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RootCompositorFrameSinkParams_Data* object =
      static_cast<const RootCompositorFrameSinkParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->widget, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->widget, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->renderer_settings, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->renderer_settings, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->compositor_frame_sink, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->compositor_frame_sink,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->compositor_frame_sink_client, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->compositor_frame_sink_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->display_private, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->display_private,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->display_client, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->display_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->external_begin_frame_controller,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->external_begin_frame_controller_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RootCompositorFrameSinkParams_Data::RootCompositorFrameSinkParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_RegisterFrameSinkId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_RegisterFrameSinkId_Params_Data* object =
      static_cast<const FrameSinkManager_RegisterFrameSinkId_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

FrameSinkManager_RegisterFrameSinkId_Params_Data::FrameSinkManager_RegisterFrameSinkId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_InvalidateFrameSinkId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_InvalidateFrameSinkId_Params_Data* object =
      static_cast<const FrameSinkManager_InvalidateFrameSinkId_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

FrameSinkManager_InvalidateFrameSinkId_Params_Data::FrameSinkManager_InvalidateFrameSinkId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_InvalidateFrameSinkId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_InvalidateFrameSinkId_ResponseParams_Data* object =
      static_cast<const FrameSinkManager_InvalidateFrameSinkId_ResponseParams_Data*>(data);

  return true;
}

FrameSinkManager_InvalidateFrameSinkId_ResponseParams_Data::FrameSinkManager_InvalidateFrameSinkId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_SetFrameSinkDebugLabel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_SetFrameSinkDebugLabel_Params_Data* object =
      static_cast<const FrameSinkManager_SetFrameSinkDebugLabel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_label, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& debug_label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->debug_label, validation_context,
                                         &debug_label_validate_params)) {
    return false;
  }

  return true;
}

FrameSinkManager_SetFrameSinkDebugLabel_Params_Data::FrameSinkManager_SetFrameSinkDebugLabel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_CreateRootCompositorFrameSink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_CreateRootCompositorFrameSink_Params_Data* object =
      static_cast<const FrameSinkManager_CreateRootCompositorFrameSink_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

FrameSinkManager_CreateRootCompositorFrameSink_Params_Data::FrameSinkManager_CreateRootCompositorFrameSink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_CreateFrameSinkBundle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_CreateFrameSinkBundle_Params_Data* object =
      static_cast<const FrameSinkManager_CreateFrameSinkBundle_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bundle_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bundle_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameSinkManager_CreateFrameSinkBundle_Params_Data::FrameSinkManager_CreateFrameSinkBundle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_CreateCompositorFrameSink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_CreateCompositorFrameSink_Params_Data* object =
      static_cast<const FrameSinkManager_CreateCompositorFrameSink_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bundle_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->compositor_frame_sink, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->compositor_frame_sink,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->compositor_frame_sink_client, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->compositor_frame_sink_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

FrameSinkManager_CreateCompositorFrameSink_Params_Data::FrameSinkManager_CreateCompositorFrameSink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_DestroyCompositorFrameSink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_DestroyCompositorFrameSink_Params_Data* object =
      static_cast<const FrameSinkManager_DestroyCompositorFrameSink_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

FrameSinkManager_DestroyCompositorFrameSink_Params_Data::FrameSinkManager_DestroyCompositorFrameSink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data* object =
      static_cast<const FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data*>(data);

  return true;
}

FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data* object =
      static_cast<const FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->child_frame_sink_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->child_frame_sink_id, validation_context))
    return false;

  return true;
}

FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data::FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data* object =
      static_cast<const FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->child_frame_sink_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->child_frame_sink_id, validation_context))
    return false;

  return true;
}

FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data::FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_AddVideoDetectorObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_AddVideoDetectorObserver_Params_Data* object =
      static_cast<const FrameSinkManager_AddVideoDetectorObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameSinkManager_AddVideoDetectorObserver_Params_Data::FrameSinkManager_AddVideoDetectorObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_CreateVideoCapturer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_CreateVideoCapturer_Params_Data* object =
      static_cast<const FrameSinkManager_CreateVideoCapturer_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameSinkManager_CreateVideoCapturer_Params_Data::FrameSinkManager_CreateVideoCapturer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_EvictSurfaces_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_EvictSurfaces_Params_Data* object =
      static_cast<const FrameSinkManager_EvictSurfaces_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& surface_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->surface_ids, validation_context,
                                         &surface_ids_validate_params)) {
    return false;
  }

  return true;
}

FrameSinkManager_EvictSurfaces_Params_Data::FrameSinkManager_EvictSurfaces_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_Throttle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_Throttle_Params_Data* object =
      static_cast<const FrameSinkManager_Throttle_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& frame_sink_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->frame_sink_ids, validation_context,
                                         &frame_sink_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interval, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interval, validation_context))
    return false;

  return true;
}

FrameSinkManager_Throttle_Params_Data::FrameSinkManager_Throttle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_StartThrottlingAllFrameSinks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_StartThrottlingAllFrameSinks_Params_Data* object =
      static_cast<const FrameSinkManager_StartThrottlingAllFrameSinks_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interval, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interval, validation_context))
    return false;

  return true;
}

FrameSinkManager_StartThrottlingAllFrameSinks_Params_Data::FrameSinkManager_StartThrottlingAllFrameSinks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_StopThrottlingAllFrameSinks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_StopThrottlingAllFrameSinks_Params_Data* object =
      static_cast<const FrameSinkManager_StopThrottlingAllFrameSinks_Params_Data*>(data);

  return true;
}

FrameSinkManager_StopThrottlingAllFrameSinks_Params_Data::FrameSinkManager_StopThrottlingAllFrameSinks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_RequestCopyOfOutput_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_RequestCopyOfOutput_Params_Data* object =
      static_cast<const FrameSinkManager_RequestCopyOfOutput_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->surface_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

FrameSinkManager_RequestCopyOfOutput_Params_Data::FrameSinkManager_RequestCopyOfOutput_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_UpdateDebugRendererSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_UpdateDebugRendererSettings_Params_Data* object =
      static_cast<const FrameSinkManager_UpdateDebugRendererSettings_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_settings, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->debug_settings, validation_context))
    return false;

  return true;
}

FrameSinkManager_UpdateDebugRendererSettings_Params_Data::FrameSinkManager_UpdateDebugRendererSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_ClearUnclaimedViewTransitionResources_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_ClearUnclaimedViewTransitionResources_Params_Data* object =
      static_cast<const FrameSinkManager_ClearUnclaimedViewTransitionResources_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transition_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->transition_token, validation_context))
    return false;

  return true;
}

FrameSinkManager_ClearUnclaimedViewTransitionResources_Params_Data::FrameSinkManager_ClearUnclaimedViewTransitionResources_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_CreateMetricsRecorderForTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_CreateMetricsRecorderForTest_Params_Data* object =
      static_cast<const FrameSinkManager_CreateMetricsRecorderForTest_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameSinkManager_CreateMetricsRecorderForTest_Params_Data::FrameSinkManager_CreateMetricsRecorderForTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_EnableFrameSinkManagerTestApi_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_EnableFrameSinkManagerTestApi_Params_Data* object =
      static_cast<const FrameSinkManager_EnableFrameSinkManagerTestApi_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameSinkManager_EnableFrameSinkManagerTestApi_Params_Data::FrameSinkManager_EnableFrameSinkManagerTestApi_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_SetupRendererInputRouterDelegateRegistry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_SetupRendererInputRouterDelegateRegistry_Params_Data* object =
      static_cast<const FrameSinkManager_SetupRendererInputRouterDelegateRegistry_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameSinkManager_SetupRendererInputRouterDelegateRegistry_Params_Data::FrameSinkManager_SetupRendererInputRouterDelegateRegistry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_NotifyRendererBlockStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_NotifyRendererBlockStateChanged_Params_Data* object =
      static_cast<const FrameSinkManager_NotifyRendererBlockStateChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->render_input_routers, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& render_input_routers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->render_input_routers, validation_context,
                                         &render_input_routers_validate_params)) {
    return false;
  }

  return true;
}

FrameSinkManager_NotifyRendererBlockStateChanged_Params_Data::FrameSinkManager_NotifyRendererBlockStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_RequestInputBack_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManager_RequestInputBack_Params_Data* object =
      static_cast<const FrameSinkManager_RequestInputBack_Params_Data*>(data);

  return true;
}

FrameSinkManager_RequestInputBack_Params_Data::FrameSinkManager_RequestInputBack_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data* object =
      static_cast<const FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->surface_info, validation_context))
    return false;

  return true;
}

FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data::FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data* object =
      static_cast<const FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hit_test_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hit_test_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hit_test_data, validation_context,
                                         &hit_test_data_validate_params)) {
    return false;
  }

  return true;
}

FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data::FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManagerClient_OnFrameTokenChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManagerClient_OnFrameTokenChanged_Params_Data* object =
      static_cast<const FrameSinkManagerClient_OnFrameTokenChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->activation_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->activation_time, validation_context))
    return false;

  return true;
}

FrameSinkManagerClient_OnFrameTokenChanged_Params_Data::FrameSinkManagerClient_OnFrameTokenChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManagerClient_OnScreenshotCaptured_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkManagerClient_OnScreenshotCaptured_Params_Data* object =
      static_cast<const FrameSinkManagerClient_OnScreenshotCaptured_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destination_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->destination_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->copy_output_result, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->copy_output_result, validation_context))
    return false;

  return true;
}

FrameSinkManagerClient_OnScreenshotCaptured_Params_Data::FrameSinkManagerClient_OnScreenshotCaptured_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererInputRouterDelegateRegistry_SetupRenderInputRouterDelegateConnection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RendererInputRouterDelegateRegistry_SetupRenderInputRouterDelegateConnection_Params_Data* object =
      static_cast<const RendererInputRouterDelegateRegistry_SetupRenderInputRouterDelegateConnection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->rir_delegate_client_remote, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->rir_delegate_client_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->rir_delegate_receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->rir_delegate_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RendererInputRouterDelegateRegistry_SetupRenderInputRouterDelegateConnection_Params_Data::RendererInputRouterDelegateRegistry_SetupRenderInputRouterDelegateConnection_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz