// services/tracing/public/mojom/system_tracing_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/tracing/public/mojom/system_tracing_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/tracing/public/mojom/system_tracing_service.mojom-params-data.h"
#include "services/tracing/public/mojom/system_tracing_service.mojom-shared-message-ids.h"

#include "services/tracing/public/mojom/system_tracing_service.mojom-import-headers.h"
#include "services/tracing/public/mojom/system_tracing_service.mojom-test-utils.h"


namespace tracing::mojom {
// The declaration includes the definition on other builds.

SystemTracingService::IPCStableHashFunction SystemTracingService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SystemTracingService>(message.name())) {
    case messages::SystemTracingService::kOpenProducerSocket: {
      return &SystemTracingService::OpenProducerSocket_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SystemTracingService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SystemTracingService>(message.name())) {
      case messages::SystemTracingService::kOpenProducerSocket:
            return "Receive tracing::mojom::SystemTracingService::OpenProducerSocket";
    }
  } else {
    switch (static_cast<messages::SystemTracingService>(message.name())) {
      case messages::SystemTracingService::kOpenProducerSocket:
            return "Receive reply tracing::mojom::SystemTracingService::OpenProducerSocket";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SystemTracingService::OpenProducerSocket_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc7120388;  // IPCStableHash for tracing::mojom::SystemTracingService::OpenProducerSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SystemTracingService_OpenProducerSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemTracingService_OpenProducerSocket_ForwardToCallback(
      SystemTracingService::OpenProducerSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  SystemTracingService_OpenProducerSocket_ForwardToCallback(const SystemTracingService_OpenProducerSocket_ForwardToCallback&) = delete;
  SystemTracingService_OpenProducerSocket_ForwardToCallback& operator=(const SystemTracingService_OpenProducerSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SystemTracingService::OpenProducerSocketCallback callback_;
};

SystemTracingServiceProxy::SystemTracingServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SystemTracingServiceProxy::OpenProducerSocket(
    OpenProducerSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tracing::mojom::SystemTracingService::OpenProducerSocket");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemTracingService::kOpenProducerSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::SystemTracingService_OpenProducerSocket_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemTracingService::Name_);
  message.set_method_name("OpenProducerSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemTracingService_OpenProducerSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SystemTracingService_OpenProducerSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SystemTracingService::OpenProducerSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SystemTracingService_OpenProducerSocket_ProxyToResponder> proxy(
        new SystemTracingService_OpenProducerSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SystemTracingService_OpenProducerSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemTracingService_OpenProducerSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SystemTracingService_OpenProducerSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SystemTracingService::OpenProducerSocketCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_traced_socket);
};

bool SystemTracingService_OpenProducerSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SystemTracingService_OpenProducerSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemTracingService_OpenProducerSocket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SystemTracingService.0
  bool success = true;
  ::base::File p_traced_socket{};
  SystemTracingService_OpenProducerSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTracedSocket(&p_traced_socket))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemTracingService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_traced_socket));
  }
  return true;
}

void SystemTracingService_OpenProducerSocket_ProxyToResponder::Run(
    ::base::File in_traced_socket) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tracing::mojom::SystemTracingService::OpenProducerSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traced_socket"), in_traced_socket,
                        "<value of type ::base::File>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemTracingService::kOpenProducerSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::SystemTracingService_OpenProducerSocket_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->traced_socket)::BaseType> traced_socket_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_traced_socket,
    traced_socket_fragment);

  params->traced_socket.Set(
      traced_socket_fragment.is_null() ? nullptr : traced_socket_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemTracingService::Name_);
  message.set_method_name("OpenProducerSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SystemTracingServiceStubDispatch::Accept(
    SystemTracingService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SystemTracingService>(message->header()->name)) {
    case messages::SystemTracingService::kOpenProducerSocket: {
      break;
    }
  }
  return false;
}

// static
bool SystemTracingServiceStubDispatch::AcceptWithResponder(
    SystemTracingService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SystemTracingService>(message->header()->name)) {
    case messages::SystemTracingService::kOpenProducerSocket: {
      internal::SystemTracingService_OpenProducerSocket_Params_Data* params =
          reinterpret_cast<
              internal::SystemTracingService_OpenProducerSocket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SystemTracingService.0
      bool success = true;
      SystemTracingService_OpenProducerSocket_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemTracingService::Name_, 0, false);
        return false;
      }
      auto callback =
          SystemTracingService_OpenProducerSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenProducerSocket(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSystemTracingServiceValidationInfo[] = {
    { &internal::SystemTracingService_OpenProducerSocket_Params_Data::Validate,
     &internal::SystemTracingService_OpenProducerSocket_ResponseParams_Data::Validate},
};

bool SystemTracingServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tracing::mojom::SystemTracingService::Name_,
    kSystemTracingServiceValidationInfo);
}

bool SystemTracingServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::tracing::mojom::SystemTracingService::Name_,
    kSystemTracingServiceValidationInfo);
}


}  // tracing::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace tracing::mojom {


void SystemTracingServiceInterceptorForTesting::OpenProducerSocket(OpenProducerSocketCallback callback) {
  GetForwardingInterface()->OpenProducerSocket(std::move(callback));
}
SystemTracingServiceAsyncWaiter::SystemTracingServiceAsyncWaiter(
    SystemTracingService* proxy) : proxy_(proxy) {}

SystemTracingServiceAsyncWaiter::~SystemTracingServiceAsyncWaiter() = default;


void SystemTracingServiceAsyncWaiter::OpenProducerSocket(
    ::base::File* out_traced_socket) {
  base::RunLoop loop;
  proxy_->OpenProducerSocket(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File* out_traced_socket
,
             ::base::File traced_socket) {*out_traced_socket = std::move(traced_socket);
            loop->Quit();
          },
          &loop,
          out_traced_socket));
  loop.Run();
}

::base::File SystemTracingServiceAsyncWaiter::OpenProducerSocket(
    ) {
  ::base::File async_wait_result;
  OpenProducerSocket(&async_wait_result);
  return async_wait_result;
}






}  // tracing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif