// services/tracing/public/mojom/perfetto_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/tracing/public/mojom/perfetto_service.mojom-features.h"  // IWYU pragma: export
#include "services/tracing/public/mojom/perfetto_service.mojom-shared.h"  // IWYU pragma: export
#include "services/tracing/public/mojom/perfetto_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/token.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/perfetto/include/perfetto/ext/tracing/core/commit_data_request.h"
#include "third_party/perfetto/include/perfetto/tracing/core/chrome_config.h"
#include "third_party/perfetto/include/perfetto/tracing/core/data_source_config.h"
#include "third_party/perfetto/include/perfetto/tracing/core/data_source_descriptor.h"
#include "third_party/perfetto/include/perfetto/tracing/core/trace_config.h"
#include "third_party/perfetto/protos/perfetto/config/interceptor_config.gen.h"
#include "base/component_export.h"




namespace tracing::mojom {

class ProducerHostProxy;

template <typename ImplRefTraits>
class ProducerHostStub;

class ProducerHostRequestValidator;
class ProducerHostResponseValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHost
    : public ProducerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tracing.mojom.ProducerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProducerHostInterfaceBase;
  using Proxy_ = ProducerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProducerHostStub<ImplRefTraits>;

  using RequestValidator_ = ProducerHostRequestValidator;
  using ResponseValidator_ = ProducerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCommitDataMinVersion = 0,
    kRegisterDataSourceMinVersion = 0,
    kUpdateDataSourceMinVersion = 0,
    kRegisterTraceWriterMinVersion = 0,
    kUnregisterTraceWriterMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CommitData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterDataSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateDataSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterTraceWriter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnregisterTraceWriter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProducerHost() = default;

  using CommitDataCallback = base::OnceCallback<void()>;
  using CommitDataMojoCallback = base::OnceCallback<void()>;

  virtual void CommitData(const ::perfetto::CommitDataRequest& data_request, CommitDataCallback callback) = 0;

  virtual void RegisterDataSource(const ::perfetto::DataSourceDescriptor& registration_info) = 0;

  virtual void UpdateDataSource(const ::perfetto::DataSourceDescriptor& registration_info) = 0;

  virtual void RegisterTraceWriter(uint32_t writer_id, uint32_t target_buffer) = 0;

  virtual void UnregisterTraceWriter(uint32_t writer_id) = 0;
};

class ProducerClientProxy;

template <typename ImplRefTraits>
class ProducerClientStub;

class ProducerClientRequestValidator;
class ProducerClientResponseValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClient
    : public ProducerClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tracing.mojom.ProducerClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProducerClientInterfaceBase;
  using Proxy_ = ProducerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProducerClientStub<ImplRefTraits>;

  using RequestValidator_ = ProducerClientRequestValidator;
  using ResponseValidator_ = ProducerClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnTracingStartMinVersion = 0,
    kStartDataSourceMinVersion = 0,
    kStopDataSourceMinVersion = 0,
    kFlushMinVersion = 0,
    kClearIncrementalStateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnTracingStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartDataSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopDataSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Flush_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearIncrementalState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProducerClient() = default;

  virtual void OnTracingStart() = 0;

  using StartDataSourceCallback = base::OnceCallback<void()>;
  using StartDataSourceMojoCallback = base::OnceCallback<void()>;

  virtual void StartDataSource(uint64_t id, const ::perfetto::DataSourceConfig& data_source_config, StartDataSourceCallback callback) = 0;

  using StopDataSourceCallback = base::OnceCallback<void()>;
  using StopDataSourceMojoCallback = base::OnceCallback<void()>;

  virtual void StopDataSource(uint64_t id, StopDataSourceCallback callback) = 0;

  virtual void Flush(uint64_t flush_request_id, const std::vector<uint64_t>& data_source_ids) = 0;

  virtual void ClearIncrementalState() = 0;
};

class PerfettoServiceProxy;

template <typename ImplRefTraits>
class PerfettoServiceStub;

class PerfettoServiceRequestValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoService
    : public PerfettoServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tracing.mojom.PerfettoService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PerfettoServiceInterfaceBase;
  using Proxy_ = PerfettoServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PerfettoServiceStub<ImplRefTraits>;

  using RequestValidator_ = PerfettoServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kConnectToProducerHostMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ConnectToProducerHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PerfettoService() = default;

  virtual void ConnectToProducerHost(::mojo::PendingRemote<ProducerClient> producer_client, ::mojo::PendingReceiver<ProducerHost> producer_host_receiver, ::base::UnsafeSharedMemoryRegion shared_memory, uint64_t shared_memory_buffer_page_size_bytes) = 0;
};

class ConsumerHostProxy;

template <typename ImplRefTraits>
class ConsumerHostStub;

class ConsumerHostRequestValidator;
class ConsumerHostResponseValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) ConsumerHost
    : public ConsumerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tracing.mojom.ConsumerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ConsumerHostInterfaceBase;
  using Proxy_ = ConsumerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ConsumerHostStub<ImplRefTraits>;

  using RequestValidator_ = ConsumerHostRequestValidator;
  using ResponseValidator_ = ConsumerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kEnableTracingMinVersion = 0,
    kCloneSessionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EnableTracing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloneSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ConsumerHost() = default;

  virtual void EnableTracing(::mojo::PendingReceiver<TracingSessionHost> tracing_session_host, ::mojo::PendingRemote<TracingSessionClient> tracing_session_client, const ::perfetto::TraceConfig& config, ::base::File output_file) = 0;

  using CloneSessionCallback = base::OnceCallback<void(bool, const std::string&, const ::base::Token&)>;
  using CloneSessionMojoCallback = base::OnceCallback<void(bool, const std::string&, const ::base::Token&)>;

  virtual void CloneSession(::mojo::PendingReceiver<TracingSessionHost> tracing_session_host, ::mojo::PendingRemote<TracingSessionClient> tracing_session_client, const ::base::UnguessableToken& unguessable_name, bool privacy_filtering_enabled, CloneSessionCallback callback) = 0;
};

class TracingSessionHostProxy;

template <typename ImplRefTraits>
class TracingSessionHostStub;

class TracingSessionHostRequestValidator;
class TracingSessionHostResponseValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHost
    : public TracingSessionHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tracing.mojom.TracingSessionHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TracingSessionHostInterfaceBase;
  using Proxy_ = TracingSessionHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = TracingSessionHostStub<ImplRefTraits>;

  using RequestValidator_ = TracingSessionHostRequestValidator;
  using ResponseValidator_ = TracingSessionHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kChangeTraceConfigMinVersion = 0,
    kDisableTracingMinVersion = 0,
    kReadBuffersMinVersion = 0,
    kRequestBufferUsageMinVersion = 0,
    kDisableTracingAndEmitJsonMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ChangeTraceConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableTracing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadBuffers_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestBufferUsage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableTracingAndEmitJson_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TracingSessionHost() = default;

  virtual void ChangeTraceConfig(const ::perfetto::TraceConfig& config) = 0;

  virtual void DisableTracing() = 0;

  using ReadBuffersCallback = base::OnceCallback<void()>;
  using ReadBuffersMojoCallback = base::OnceCallback<void()>;

  virtual void ReadBuffers(::mojo::ScopedDataPipeProducerHandle stream, ReadBuffersCallback callback) = 0;

  using RequestBufferUsageCallback = base::OnceCallback<void(bool, float, bool)>;
  using RequestBufferUsageMojoCallback = base::OnceCallback<void(bool, float, bool)>;

  virtual void RequestBufferUsage(RequestBufferUsageCallback callback) = 0;

  using DisableTracingAndEmitJsonCallback = base::OnceCallback<void()>;
  using DisableTracingAndEmitJsonMojoCallback = base::OnceCallback<void()>;

  virtual void DisableTracingAndEmitJson(const std::string& agent_label_filter, ::mojo::ScopedDataPipeProducerHandle stream, bool privacy_filtering_enabled, DisableTracingAndEmitJsonCallback callback) = 0;
};

class TracingSessionClientProxy;

template <typename ImplRefTraits>
class TracingSessionClientStub;

class TracingSessionClientRequestValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionClient
    : public TracingSessionClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tracing.mojom.TracingSessionClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TracingSessionClientInterfaceBase;
  using Proxy_ = TracingSessionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = TracingSessionClientStub<ImplRefTraits>;

  using RequestValidator_ = TracingSessionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnTracingEnabledMinVersion = 0,
    kOnTracingDisabledMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnTracingEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTracingDisabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TracingSessionClient() = default;

  virtual void OnTracingEnabled() = 0;

  virtual void OnTracingDisabled(bool tracing_succeeded) = 0;
};



class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHostProxy
    : public ProducerHost {
 public:
  using InterfaceType = ProducerHost;

  explicit ProducerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CommitData(const ::perfetto::CommitDataRequest& data_request, CommitDataCallback callback) final;
  
  void RegisterDataSource(const ::perfetto::DataSourceDescriptor& registration_info) final;
  
  void UpdateDataSource(const ::perfetto::DataSourceDescriptor& registration_info) final;
  
  void RegisterTraceWriter(uint32_t writer_id, uint32_t target_buffer) final;
  
  void UnregisterTraceWriter(uint32_t writer_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClientProxy
    : public ProducerClient {
 public:
  using InterfaceType = ProducerClient;

  explicit ProducerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTracingStart() final;
  
  void StartDataSource(uint64_t id, const ::perfetto::DataSourceConfig& data_source_config, StartDataSourceCallback callback) final;
  
  void StopDataSource(uint64_t id, StopDataSourceCallback callback) final;
  
  void Flush(uint64_t flush_request_id, const std::vector<uint64_t>& data_source_ids) final;
  
  void ClearIncrementalState() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoServiceProxy
    : public PerfettoService {
 public:
  using InterfaceType = PerfettoService;

  explicit PerfettoServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ConnectToProducerHost(::mojo::PendingRemote<ProducerClient> producer_client, ::mojo::PendingReceiver<ProducerHost> producer_host_receiver, ::base::UnsafeSharedMemoryRegion shared_memory, uint64_t shared_memory_buffer_page_size_bytes) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) ConsumerHostProxy
    : public ConsumerHost {
 public:
  using InterfaceType = ConsumerHost;

  explicit ConsumerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EnableTracing(::mojo::PendingReceiver<TracingSessionHost> tracing_session_host, ::mojo::PendingRemote<TracingSessionClient> tracing_session_client, const ::perfetto::TraceConfig& config, ::base::File output_file) final;
  
  void CloneSession(::mojo::PendingReceiver<TracingSessionHost> tracing_session_host, ::mojo::PendingRemote<TracingSessionClient> tracing_session_client, const ::base::UnguessableToken& unguessable_name, bool privacy_filtering_enabled, CloneSessionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHostProxy
    : public TracingSessionHost {
 public:
  using InterfaceType = TracingSessionHost;

  explicit TracingSessionHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ChangeTraceConfig(const ::perfetto::TraceConfig& config) final;
  
  void DisableTracing() final;
  
  void ReadBuffers(::mojo::ScopedDataPipeProducerHandle stream, ReadBuffersCallback callback) final;
  
  void RequestBufferUsage(RequestBufferUsageCallback callback) final;
  
  void DisableTracingAndEmitJson(const std::string& agent_label_filter, ::mojo::ScopedDataPipeProducerHandle stream, bool privacy_filtering_enabled, DisableTracingAndEmitJsonCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionClientProxy
    : public TracingSessionClient {
 public:
  using InterfaceType = TracingSessionClient;

  explicit TracingSessionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTracingEnabled() final;
  
  void OnTracingDisabled(bool tracing_succeeded) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHostStubDispatch {
 public:
  static bool Accept(ProducerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProducerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProducerHost>>
class ProducerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProducerHostStub() = default;
  ~ProducerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProducerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProducerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClientStubDispatch {
 public:
  static bool Accept(ProducerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProducerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProducerClient>>
class ProducerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProducerClientStub() = default;
  ~ProducerClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProducerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProducerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoServiceStubDispatch {
 public:
  static bool Accept(PerfettoService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PerfettoService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PerfettoService>>
class PerfettoServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PerfettoServiceStub() = default;
  ~PerfettoServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PerfettoServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PerfettoServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ConsumerHostStubDispatch {
 public:
  static bool Accept(ConsumerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ConsumerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ConsumerHost>>
class ConsumerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ConsumerHostStub() = default;
  ~ConsumerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConsumerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConsumerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHostStubDispatch {
 public:
  static bool Accept(TracingSessionHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TracingSessionHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TracingSessionHost>>
class TracingSessionHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TracingSessionHostStub() = default;
  ~TracingSessionHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracingSessionHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracingSessionHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionClientStubDispatch {
 public:
  static bool Accept(TracingSessionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TracingSessionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TracingSessionClient>>
class TracingSessionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TracingSessionClientStub() = default;
  ~TracingSessionClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracingSessionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracingSessionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ConsumerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ConsumerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class COMPONENT_EXPORT(TRACING_MOJOM) ChunksToMove {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChunksToMove, T>::value>;
  using DataView = ChunksToMoveDataView;
  using Data_ = internal::ChunksToMove_Data;

  template <typename... Args>
  static ChunksToMovePtr New(Args&&... args) {
    return ChunksToMovePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChunksToMovePtr From(const U& u) {
    return mojo::TypeConverter<ChunksToMovePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChunksToMove>::Convert(*this);
  }


  ChunksToMove();

  ChunksToMove(
      uint32_t page,
      uint32_t chunk,
      uint32_t target_buffer);


  ~ChunksToMove();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChunksToMovePtr>
  ChunksToMovePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChunksToMove::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChunksToMove::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChunksToMove::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChunksToMove_UnserializedMessageContext<
            UserType, ChunksToMove::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ChunksToMove::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ChunksToMove::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChunksToMove_UnserializedMessageContext<
            UserType, ChunksToMove::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChunksToMove::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t page;
  
  uint32_t chunk;
  
  uint32_t target_buffer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class COMPONENT_EXPORT(TRACING_MOJOM) ChromeConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChromeConfig, T>::value>;
  using DataView = ChromeConfigDataView;
  using Data_ = internal::ChromeConfig_Data;

  template <typename... Args>
  static ChromeConfigPtr New(Args&&... args) {
    return ChromeConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChromeConfigPtr From(const U& u) {
    return mojo::TypeConverter<ChromeConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChromeConfig>::Convert(*this);
  }


  ChromeConfig();

  ChromeConfig(
      const std::string& trace_config,
      bool privacy_filtering_enabled,
      bool convert_to_legacy_json,
      bool event_package_name_filter_enabled);


  ~ChromeConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChromeConfigPtr>
  ChromeConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChromeConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChromeConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChromeConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChromeConfig_UnserializedMessageContext<
            UserType, ChromeConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ChromeConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ChromeConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChromeConfig_UnserializedMessageContext<
            UserType, ChromeConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChromeConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string trace_config;
  
  bool privacy_filtering_enabled;
  
  bool convert_to_legacy_json;
  
  bool event_package_name_filter_enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(TRACING_MOJOM) ConsoleConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConsoleConfig, T>::value>;
  using DataView = ConsoleConfigDataView;
  using Data_ = internal::ConsoleConfig_Data;

  template <typename... Args>
  static ConsoleConfigPtr New(Args&&... args) {
    return ConsoleConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConsoleConfigPtr From(const U& u) {
    return mojo::TypeConverter<ConsoleConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConsoleConfig>::Convert(*this);
  }


  ConsoleConfig();

  ConsoleConfig(
      ConsoleOutput output,
      bool enable_colors);


  ~ConsoleConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConsoleConfigPtr>
  ConsoleConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConsoleConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ConsoleConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ConsoleConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConsoleConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConsoleConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConsoleConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConsoleConfig_UnserializedMessageContext<
            UserType, ConsoleConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ConsoleConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ConsoleConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConsoleConfig_UnserializedMessageContext<
            UserType, ConsoleConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConsoleConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ConsoleOutput output;
  
  bool enable_colors;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConsoleConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConsoleConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConsoleConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConsoleConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class COMPONENT_EXPORT(TRACING_MOJOM) BufferConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BufferConfig, T>::value>;
  using DataView = BufferConfigDataView;
  using Data_ = internal::BufferConfig_Data;

  template <typename... Args>
  static BufferConfigPtr New(Args&&... args) {
    return BufferConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BufferConfigPtr From(const U& u) {
    return mojo::TypeConverter<BufferConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BufferConfig>::Convert(*this);
  }


  BufferConfig();

  BufferConfig(
      uint32_t size_kb,
      ::perfetto::TraceConfig::BufferConfig::FillPolicy fill_policy);


  ~BufferConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BufferConfigPtr>
  BufferConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BufferConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BufferConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BufferConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BufferConfig_UnserializedMessageContext<
            UserType, BufferConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BufferConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BufferConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BufferConfig_UnserializedMessageContext<
            UserType, BufferConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BufferConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t size_kb;
  
  ::perfetto::TraceConfig::BufferConfig::FillPolicy fill_policy;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(TRACING_MOJOM) IncrementalStateConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IncrementalStateConfig, T>::value>;
  using DataView = IncrementalStateConfigDataView;
  using Data_ = internal::IncrementalStateConfig_Data;

  template <typename... Args>
  static IncrementalStateConfigPtr New(Args&&... args) {
    return IncrementalStateConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IncrementalStateConfigPtr From(const U& u) {
    return mojo::TypeConverter<IncrementalStateConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IncrementalStateConfig>::Convert(*this);
  }


  IncrementalStateConfig();

  explicit IncrementalStateConfig(
      uint32_t clear_period_ms);


  ~IncrementalStateConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IncrementalStateConfigPtr>
  IncrementalStateConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IncrementalStateConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IncrementalStateConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IncrementalStateConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IncrementalStateConfig_UnserializedMessageContext<
            UserType, IncrementalStateConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IncrementalStateConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IncrementalStateConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IncrementalStateConfig_UnserializedMessageContext<
            UserType, IncrementalStateConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IncrementalStateConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t clear_period_ms;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class COMPONENT_EXPORT(TRACING_MOJOM) ChunkPatch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChunkPatch, T>::value>;
  using DataView = ChunkPatchDataView;
  using Data_ = internal::ChunkPatch_Data;

  template <typename... Args>
  static ChunkPatchPtr New(Args&&... args) {
    return ChunkPatchPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChunkPatchPtr From(const U& u) {
    return mojo::TypeConverter<ChunkPatchPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChunkPatch>::Convert(*this);
  }


  ChunkPatch();

  ChunkPatch(
      uint32_t offset,
      const std::string& data);


  ~ChunkPatch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChunkPatchPtr>
  ChunkPatchPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChunkPatch::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChunkPatch::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChunkPatch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChunkPatch_UnserializedMessageContext<
            UserType, ChunkPatch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ChunkPatch::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ChunkPatch::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChunkPatch_UnserializedMessageContext<
            UserType, ChunkPatch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChunkPatch::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t offset;
  
  std::string data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(TRACING_MOJOM) ChunksToPatch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChunksToPatch, T>::value>;
  using DataView = ChunksToPatchDataView;
  using Data_ = internal::ChunksToPatch_Data;

  template <typename... Args>
  static ChunksToPatchPtr New(Args&&... args) {
    return ChunksToPatchPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChunksToPatchPtr From(const U& u) {
    return mojo::TypeConverter<ChunksToPatchPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChunksToPatch>::Convert(*this);
  }


  ChunksToPatch();

  ChunksToPatch(
      uint32_t target_buffer,
      uint32_t writer_id,
      uint32_t chunk_id,
      std::vector<::perfetto::CommitDataRequest::ChunkToPatch::Patch> patches,
      bool has_more_patches);


  ~ChunksToPatch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChunksToPatchPtr>
  ChunksToPatchPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChunksToPatch::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChunksToPatch::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChunksToPatch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChunksToPatch_UnserializedMessageContext<
            UserType, ChunksToPatch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ChunksToPatch::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ChunksToPatch::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChunksToPatch_UnserializedMessageContext<
            UserType, ChunksToPatch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChunksToPatch::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t target_buffer;
  
  uint32_t writer_id;
  
  uint32_t chunk_id;
  
  std::vector<::perfetto::CommitDataRequest::ChunkToPatch::Patch> patches;
  
  bool has_more_patches;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(TRACING_MOJOM) CommitDataRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CommitDataRequest, T>::value>;
  using DataView = CommitDataRequestDataView;
  using Data_ = internal::CommitDataRequest_Data;

  template <typename... Args>
  static CommitDataRequestPtr New(Args&&... args) {
    return CommitDataRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CommitDataRequestPtr From(const U& u) {
    return mojo::TypeConverter<CommitDataRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CommitDataRequest>::Convert(*this);
  }


  CommitDataRequest();

  CommitDataRequest(
      std::vector<::perfetto::CommitDataRequest::ChunksToMove> chunks_to_move,
      std::vector<::perfetto::CommitDataRequest::ChunkToPatch> chunks_to_patch,
      uint64_t flush_request_id);


  ~CommitDataRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CommitDataRequestPtr>
  CommitDataRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommitDataRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommitDataRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CommitDataRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CommitDataRequest_UnserializedMessageContext<
            UserType, CommitDataRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CommitDataRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CommitDataRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CommitDataRequest_UnserializedMessageContext<
            UserType, CommitDataRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CommitDataRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::perfetto::CommitDataRequest::ChunksToMove> chunks_to_move;
  
  std::vector<::perfetto::CommitDataRequest::ChunkToPatch> chunks_to_patch;
  
  uint64_t flush_request_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(TRACING_MOJOM) InterceptorConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InterceptorConfig, T>::value>;
  using DataView = InterceptorConfigDataView;
  using Data_ = internal::InterceptorConfig_Data;

  template <typename... Args>
  static InterceptorConfigPtr New(Args&&... args) {
    return InterceptorConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InterceptorConfigPtr From(const U& u) {
    return mojo::TypeConverter<InterceptorConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InterceptorConfig>::Convert(*this);
  }


  InterceptorConfig();

  InterceptorConfig(
      const std::string& name,
      ConsoleConfigPtr console_config);

InterceptorConfig(const InterceptorConfig&) = delete;
InterceptorConfig& operator=(const InterceptorConfig&) = delete;

  ~InterceptorConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InterceptorConfigPtr>
  InterceptorConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InterceptorConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InterceptorConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InterceptorConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InterceptorConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InterceptorConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InterceptorConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InterceptorConfig_UnserializedMessageContext<
            UserType, InterceptorConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InterceptorConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InterceptorConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InterceptorConfig_UnserializedMessageContext<
            UserType, InterceptorConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InterceptorConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  ConsoleConfigPtr console_config;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InterceptorConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InterceptorConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InterceptorConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InterceptorConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(TRACING_MOJOM) DataSourceConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataSourceConfig, T>::value>;
  using DataView = DataSourceConfigDataView;
  using Data_ = internal::DataSourceConfig_Data;

  template <typename... Args>
  static DataSourceConfigPtr New(Args&&... args) {
    return DataSourceConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataSourceConfigPtr From(const U& u) {
    return mojo::TypeConverter<DataSourceConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataSourceConfig>::Convert(*this);
  }


  DataSourceConfig();

  DataSourceConfig(
      const std::string& name,
      uint32_t target_buffer,
      uint32_t trace_duration_ms,
      uint64_t tracing_session_id,
      const ::perfetto::ChromeConfig& chrome_config,
      InterceptorConfigPtr interceptor_config,
      const std::string& legacy_config,
      const std::string& track_event_config_raw,
      const std::string& etw_config_raw,
      const std::string& system_metrics_config_raw,
      const std::string& histogram_samples_config_raw);

DataSourceConfig(const DataSourceConfig&) = delete;
DataSourceConfig& operator=(const DataSourceConfig&) = delete;

  ~DataSourceConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataSourceConfigPtr>
  DataSourceConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataSourceConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataSourceConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataSourceConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataSourceConfig_UnserializedMessageContext<
            UserType, DataSourceConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataSourceConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataSourceConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataSourceConfig_UnserializedMessageContext<
            UserType, DataSourceConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataSourceConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  uint32_t target_buffer;
  
  uint32_t trace_duration_ms;
  
  uint64_t tracing_session_id;
  
  ::perfetto::ChromeConfig chrome_config;
  
  InterceptorConfigPtr interceptor_config;
  
  std::string legacy_config;
  
  std::string track_event_config_raw;
  
  std::string etw_config_raw;
  
  std::string system_metrics_config_raw;
  
  std::string histogram_samples_config_raw;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(TRACING_MOJOM) DataSourceRegistration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataSourceRegistration, T>::value>;
  using DataView = DataSourceRegistrationDataView;
  using Data_ = internal::DataSourceRegistration_Data;

  template <typename... Args>
  static DataSourceRegistrationPtr New(Args&&... args) {
    return DataSourceRegistrationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataSourceRegistrationPtr From(const U& u) {
    return mojo::TypeConverter<DataSourceRegistrationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataSourceRegistration>::Convert(*this);
  }


  DataSourceRegistration();

  DataSourceRegistration(
      const std::string& name,
      uint64_t id,
      bool will_notify_on_start,
      bool will_notify_on_stop,
      bool handles_incremental_state_clear);


  ~DataSourceRegistration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataSourceRegistrationPtr>
  DataSourceRegistrationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataSourceRegistration::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataSourceRegistration::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataSourceRegistration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataSourceRegistration_UnserializedMessageContext<
            UserType, DataSourceRegistration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataSourceRegistration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataSourceRegistration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataSourceRegistration_UnserializedMessageContext<
            UserType, DataSourceRegistration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataSourceRegistration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  uint64_t id;
  
  bool will_notify_on_start;
  
  bool will_notify_on_stop;
  
  bool handles_incremental_state_clear;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(TRACING_MOJOM) DataSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataSource, T>::value>;
  using DataView = DataSourceDataView;
  using Data_ = internal::DataSource_Data;

  template <typename... Args>
  static DataSourcePtr New(Args&&... args) {
    return DataSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataSourcePtr From(const U& u) {
    return mojo::TypeConverter<DataSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataSource>::Convert(*this);
  }


  DataSource();

  DataSource(
      const ::perfetto::DataSourceConfig& config,
      std::vector<std::string> producer_name_filter);


  ~DataSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataSourcePtr>
  DataSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataSource::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataSource_UnserializedMessageContext<
            UserType, DataSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataSource_UnserializedMessageContext<
            UserType, DataSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::perfetto::DataSourceConfig config;
  
  std::vector<std::string> producer_name_filter;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoBuiltinDataSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PerfettoBuiltinDataSource, T>::value>;
  using DataView = PerfettoBuiltinDataSourceDataView;
  using Data_ = internal::PerfettoBuiltinDataSource_Data;

  template <typename... Args>
  static PerfettoBuiltinDataSourcePtr New(Args&&... args) {
    return PerfettoBuiltinDataSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PerfettoBuiltinDataSourcePtr From(const U& u) {
    return mojo::TypeConverter<PerfettoBuiltinDataSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PerfettoBuiltinDataSource>::Convert(*this);
  }


  PerfettoBuiltinDataSource();

  PerfettoBuiltinDataSource(
      bool disable_clock_snapshotting,
      bool disable_trace_config,
      bool disable_system_info,
      bool disable_service_events,
      int32_t primary_trace_clock_id);


  ~PerfettoBuiltinDataSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PerfettoBuiltinDataSourcePtr>
  PerfettoBuiltinDataSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerfettoBuiltinDataSource::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerfettoBuiltinDataSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PerfettoBuiltinDataSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PerfettoBuiltinDataSource_UnserializedMessageContext<
            UserType, PerfettoBuiltinDataSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PerfettoBuiltinDataSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PerfettoBuiltinDataSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PerfettoBuiltinDataSource_UnserializedMessageContext<
            UserType, PerfettoBuiltinDataSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PerfettoBuiltinDataSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool disable_clock_snapshotting;
  
  bool disable_trace_config;
  
  bool disable_system_info;
  
  bool disable_service_events;
  
  int32_t primary_trace_clock_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(TRACING_MOJOM) TraceConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TraceConfig, T>::value>;
  using DataView = TraceConfigDataView;
  using Data_ = internal::TraceConfig_Data;

  template <typename... Args>
  static TraceConfigPtr New(Args&&... args) {
    return TraceConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TraceConfigPtr From(const U& u) {
    return mojo::TypeConverter<TraceConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TraceConfig>::Convert(*this);
  }


  TraceConfig();

  TraceConfig(
      std::vector<DataSourcePtr> data_sources,
      const ::perfetto::TraceConfig::BuiltinDataSource& perfetto_builtin_data_source,
      std::vector<BufferConfigPtr> buffers,
      const ::perfetto::TraceConfig::IncrementalStateConfig& incremental_state_config,
      uint32_t duration_ms,
      bool write_into_file,
      const std::optional<::base::Token>& trace_uuid,
      const std::optional<::base::UnguessableToken>& unique_session_name);

TraceConfig(const TraceConfig&) = delete;
TraceConfig& operator=(const TraceConfig&) = delete;

  ~TraceConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TraceConfigPtr>
  TraceConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TraceConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TraceConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TraceConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TraceConfig_UnserializedMessageContext<
            UserType, TraceConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TraceConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TraceConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TraceConfig_UnserializedMessageContext<
            UserType, TraceConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TraceConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<DataSourcePtr> data_sources;
  
  ::perfetto::TraceConfig::BuiltinDataSource perfetto_builtin_data_source;
  
  std::vector<BufferConfigPtr> buffers;
  
  ::perfetto::TraceConfig::IncrementalStateConfig incremental_state_config;
  
  uint32_t duration_ms;
  
  bool write_into_file;
  
  std::optional<::base::Token> trace_uuid;
  
  std::optional<::base::UnguessableToken> unique_session_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ChunksToMovePtr ChunksToMove::Clone() const {
  return New(
      mojo::Clone(page),
      mojo::Clone(chunk),
      mojo::Clone(target_buffer)
  );
}

template <typename T, ChunksToMove::EnableIfSame<T>*>
bool ChunksToMove::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->page, other_struct.page))
    return false;
  if (!mojo::Equals(this->chunk, other_struct.chunk))
    return false;
  if (!mojo::Equals(this->target_buffer, other_struct.target_buffer))
    return false;
  return true;
}

template <typename T, ChunksToMove::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.page < rhs.page)
    return true;
  if (rhs.page < lhs.page)
    return false;
  if (lhs.chunk < rhs.chunk)
    return true;
  if (rhs.chunk < lhs.chunk)
    return false;
  if (lhs.target_buffer < rhs.target_buffer)
    return true;
  if (rhs.target_buffer < lhs.target_buffer)
    return false;
  return false;
}
template <typename StructPtrType>
ChunkPatchPtr ChunkPatch::Clone() const {
  return New(
      mojo::Clone(offset),
      mojo::Clone(data)
  );
}

template <typename T, ChunkPatch::EnableIfSame<T>*>
bool ChunkPatch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, ChunkPatch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
ChunksToPatchPtr ChunksToPatch::Clone() const {
  return New(
      mojo::Clone(target_buffer),
      mojo::Clone(writer_id),
      mojo::Clone(chunk_id),
      mojo::Clone(patches),
      mojo::Clone(has_more_patches)
  );
}

template <typename T, ChunksToPatch::EnableIfSame<T>*>
bool ChunksToPatch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->target_buffer, other_struct.target_buffer))
    return false;
  if (!mojo::Equals(this->writer_id, other_struct.writer_id))
    return false;
  if (!mojo::Equals(this->chunk_id, other_struct.chunk_id))
    return false;
  if (!mojo::Equals(this->patches, other_struct.patches))
    return false;
  if (!mojo::Equals(this->has_more_patches, other_struct.has_more_patches))
    return false;
  return true;
}

template <typename T, ChunksToPatch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.target_buffer < rhs.target_buffer)
    return true;
  if (rhs.target_buffer < lhs.target_buffer)
    return false;
  if (lhs.writer_id < rhs.writer_id)
    return true;
  if (rhs.writer_id < lhs.writer_id)
    return false;
  if (lhs.chunk_id < rhs.chunk_id)
    return true;
  if (rhs.chunk_id < lhs.chunk_id)
    return false;
  if (lhs.patches < rhs.patches)
    return true;
  if (rhs.patches < lhs.patches)
    return false;
  if (lhs.has_more_patches < rhs.has_more_patches)
    return true;
  if (rhs.has_more_patches < lhs.has_more_patches)
    return false;
  return false;
}
template <typename StructPtrType>
CommitDataRequestPtr CommitDataRequest::Clone() const {
  return New(
      mojo::Clone(chunks_to_move),
      mojo::Clone(chunks_to_patch),
      mojo::Clone(flush_request_id)
  );
}

template <typename T, CommitDataRequest::EnableIfSame<T>*>
bool CommitDataRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->chunks_to_move, other_struct.chunks_to_move))
    return false;
  if (!mojo::Equals(this->chunks_to_patch, other_struct.chunks_to_patch))
    return false;
  if (!mojo::Equals(this->flush_request_id, other_struct.flush_request_id))
    return false;
  return true;
}

template <typename T, CommitDataRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.chunks_to_move < rhs.chunks_to_move)
    return true;
  if (rhs.chunks_to_move < lhs.chunks_to_move)
    return false;
  if (lhs.chunks_to_patch < rhs.chunks_to_patch)
    return true;
  if (rhs.chunks_to_patch < lhs.chunks_to_patch)
    return false;
  if (lhs.flush_request_id < rhs.flush_request_id)
    return true;
  if (rhs.flush_request_id < lhs.flush_request_id)
    return false;
  return false;
}
template <typename StructPtrType>
ChromeConfigPtr ChromeConfig::Clone() const {
  return New(
      mojo::Clone(trace_config),
      mojo::Clone(privacy_filtering_enabled),
      mojo::Clone(convert_to_legacy_json),
      mojo::Clone(event_package_name_filter_enabled)
  );
}

template <typename T, ChromeConfig::EnableIfSame<T>*>
bool ChromeConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->trace_config, other_struct.trace_config))
    return false;
  if (!mojo::Equals(this->privacy_filtering_enabled, other_struct.privacy_filtering_enabled))
    return false;
  if (!mojo::Equals(this->convert_to_legacy_json, other_struct.convert_to_legacy_json))
    return false;
  if (!mojo::Equals(this->event_package_name_filter_enabled, other_struct.event_package_name_filter_enabled))
    return false;
  return true;
}

template <typename T, ChromeConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.trace_config < rhs.trace_config)
    return true;
  if (rhs.trace_config < lhs.trace_config)
    return false;
  if (lhs.privacy_filtering_enabled < rhs.privacy_filtering_enabled)
    return true;
  if (rhs.privacy_filtering_enabled < lhs.privacy_filtering_enabled)
    return false;
  if (lhs.convert_to_legacy_json < rhs.convert_to_legacy_json)
    return true;
  if (rhs.convert_to_legacy_json < lhs.convert_to_legacy_json)
    return false;
  if (lhs.event_package_name_filter_enabled < rhs.event_package_name_filter_enabled)
    return true;
  if (rhs.event_package_name_filter_enabled < lhs.event_package_name_filter_enabled)
    return false;
  return false;
}
template <typename StructPtrType>
ConsoleConfigPtr ConsoleConfig::Clone() const {
  return New(
      mojo::Clone(output),
      mojo::Clone(enable_colors)
  );
}

template <typename T, ConsoleConfig::EnableIfSame<T>*>
bool ConsoleConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->output, other_struct.output))
    return false;
  if (!mojo::Equals(this->enable_colors, other_struct.enable_colors))
    return false;
  return true;
}

template <typename T, ConsoleConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.output < rhs.output)
    return true;
  if (rhs.output < lhs.output)
    return false;
  if (lhs.enable_colors < rhs.enable_colors)
    return true;
  if (rhs.enable_colors < lhs.enable_colors)
    return false;
  return false;
}
template <typename StructPtrType>
InterceptorConfigPtr InterceptorConfig::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(console_config)
  );
}

template <typename T, InterceptorConfig::EnableIfSame<T>*>
bool InterceptorConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->console_config, other_struct.console_config))
    return false;
  return true;
}

template <typename T, InterceptorConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.console_config < rhs.console_config)
    return true;
  if (rhs.console_config < lhs.console_config)
    return false;
  return false;
}
template <typename StructPtrType>
DataSourceConfigPtr DataSourceConfig::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(target_buffer),
      mojo::Clone(trace_duration_ms),
      mojo::Clone(tracing_session_id),
      mojo::Clone(chrome_config),
      mojo::Clone(interceptor_config),
      mojo::Clone(legacy_config),
      mojo::Clone(track_event_config_raw),
      mojo::Clone(etw_config_raw),
      mojo::Clone(system_metrics_config_raw),
      mojo::Clone(histogram_samples_config_raw)
  );
}

template <typename T, DataSourceConfig::EnableIfSame<T>*>
bool DataSourceConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->target_buffer, other_struct.target_buffer))
    return false;
  if (!mojo::Equals(this->trace_duration_ms, other_struct.trace_duration_ms))
    return false;
  if (!mojo::Equals(this->tracing_session_id, other_struct.tracing_session_id))
    return false;
  if (!mojo::Equals(this->chrome_config, other_struct.chrome_config))
    return false;
  if (!mojo::Equals(this->interceptor_config, other_struct.interceptor_config))
    return false;
  if (!mojo::Equals(this->legacy_config, other_struct.legacy_config))
    return false;
  if (!mojo::Equals(this->track_event_config_raw, other_struct.track_event_config_raw))
    return false;
  if (!mojo::Equals(this->etw_config_raw, other_struct.etw_config_raw))
    return false;
  if (!mojo::Equals(this->system_metrics_config_raw, other_struct.system_metrics_config_raw))
    return false;
  if (!mojo::Equals(this->histogram_samples_config_raw, other_struct.histogram_samples_config_raw))
    return false;
  return true;
}

template <typename T, DataSourceConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.target_buffer < rhs.target_buffer)
    return true;
  if (rhs.target_buffer < lhs.target_buffer)
    return false;
  if (lhs.trace_duration_ms < rhs.trace_duration_ms)
    return true;
  if (rhs.trace_duration_ms < lhs.trace_duration_ms)
    return false;
  if (lhs.tracing_session_id < rhs.tracing_session_id)
    return true;
  if (rhs.tracing_session_id < lhs.tracing_session_id)
    return false;
  if (lhs.chrome_config < rhs.chrome_config)
    return true;
  if (rhs.chrome_config < lhs.chrome_config)
    return false;
  if (lhs.interceptor_config < rhs.interceptor_config)
    return true;
  if (rhs.interceptor_config < lhs.interceptor_config)
    return false;
  if (lhs.legacy_config < rhs.legacy_config)
    return true;
  if (rhs.legacy_config < lhs.legacy_config)
    return false;
  if (lhs.track_event_config_raw < rhs.track_event_config_raw)
    return true;
  if (rhs.track_event_config_raw < lhs.track_event_config_raw)
    return false;
  if (lhs.etw_config_raw < rhs.etw_config_raw)
    return true;
  if (rhs.etw_config_raw < lhs.etw_config_raw)
    return false;
  if (lhs.system_metrics_config_raw < rhs.system_metrics_config_raw)
    return true;
  if (rhs.system_metrics_config_raw < lhs.system_metrics_config_raw)
    return false;
  if (lhs.histogram_samples_config_raw < rhs.histogram_samples_config_raw)
    return true;
  if (rhs.histogram_samples_config_raw < lhs.histogram_samples_config_raw)
    return false;
  return false;
}
template <typename StructPtrType>
DataSourceRegistrationPtr DataSourceRegistration::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(id),
      mojo::Clone(will_notify_on_start),
      mojo::Clone(will_notify_on_stop),
      mojo::Clone(handles_incremental_state_clear)
  );
}

template <typename T, DataSourceRegistration::EnableIfSame<T>*>
bool DataSourceRegistration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->will_notify_on_start, other_struct.will_notify_on_start))
    return false;
  if (!mojo::Equals(this->will_notify_on_stop, other_struct.will_notify_on_stop))
    return false;
  if (!mojo::Equals(this->handles_incremental_state_clear, other_struct.handles_incremental_state_clear))
    return false;
  return true;
}

template <typename T, DataSourceRegistration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.will_notify_on_start < rhs.will_notify_on_start)
    return true;
  if (rhs.will_notify_on_start < lhs.will_notify_on_start)
    return false;
  if (lhs.will_notify_on_stop < rhs.will_notify_on_stop)
    return true;
  if (rhs.will_notify_on_stop < lhs.will_notify_on_stop)
    return false;
  if (lhs.handles_incremental_state_clear < rhs.handles_incremental_state_clear)
    return true;
  if (rhs.handles_incremental_state_clear < lhs.handles_incremental_state_clear)
    return false;
  return false;
}
template <typename StructPtrType>
BufferConfigPtr BufferConfig::Clone() const {
  return New(
      mojo::Clone(size_kb),
      mojo::Clone(fill_policy)
  );
}

template <typename T, BufferConfig::EnableIfSame<T>*>
bool BufferConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->size_kb, other_struct.size_kb))
    return false;
  if (!mojo::Equals(this->fill_policy, other_struct.fill_policy))
    return false;
  return true;
}

template <typename T, BufferConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.size_kb < rhs.size_kb)
    return true;
  if (rhs.size_kb < lhs.size_kb)
    return false;
  if (lhs.fill_policy < rhs.fill_policy)
    return true;
  if (rhs.fill_policy < lhs.fill_policy)
    return false;
  return false;
}
template <typename StructPtrType>
DataSourcePtr DataSource::Clone() const {
  return New(
      mojo::Clone(config),
      mojo::Clone(producer_name_filter)
  );
}

template <typename T, DataSource::EnableIfSame<T>*>
bool DataSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->config, other_struct.config))
    return false;
  if (!mojo::Equals(this->producer_name_filter, other_struct.producer_name_filter))
    return false;
  return true;
}

template <typename T, DataSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.config < rhs.config)
    return true;
  if (rhs.config < lhs.config)
    return false;
  if (lhs.producer_name_filter < rhs.producer_name_filter)
    return true;
  if (rhs.producer_name_filter < lhs.producer_name_filter)
    return false;
  return false;
}
template <typename StructPtrType>
PerfettoBuiltinDataSourcePtr PerfettoBuiltinDataSource::Clone() const {
  return New(
      mojo::Clone(disable_clock_snapshotting),
      mojo::Clone(disable_trace_config),
      mojo::Clone(disable_system_info),
      mojo::Clone(disable_service_events),
      mojo::Clone(primary_trace_clock_id)
  );
}

template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>*>
bool PerfettoBuiltinDataSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->disable_clock_snapshotting, other_struct.disable_clock_snapshotting))
    return false;
  if (!mojo::Equals(this->disable_trace_config, other_struct.disable_trace_config))
    return false;
  if (!mojo::Equals(this->disable_system_info, other_struct.disable_system_info))
    return false;
  if (!mojo::Equals(this->disable_service_events, other_struct.disable_service_events))
    return false;
  if (!mojo::Equals(this->primary_trace_clock_id, other_struct.primary_trace_clock_id))
    return false;
  return true;
}

template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.disable_clock_snapshotting < rhs.disable_clock_snapshotting)
    return true;
  if (rhs.disable_clock_snapshotting < lhs.disable_clock_snapshotting)
    return false;
  if (lhs.disable_trace_config < rhs.disable_trace_config)
    return true;
  if (rhs.disable_trace_config < lhs.disable_trace_config)
    return false;
  if (lhs.disable_system_info < rhs.disable_system_info)
    return true;
  if (rhs.disable_system_info < lhs.disable_system_info)
    return false;
  if (lhs.disable_service_events < rhs.disable_service_events)
    return true;
  if (rhs.disable_service_events < lhs.disable_service_events)
    return false;
  if (lhs.primary_trace_clock_id < rhs.primary_trace_clock_id)
    return true;
  if (rhs.primary_trace_clock_id < lhs.primary_trace_clock_id)
    return false;
  return false;
}
template <typename StructPtrType>
IncrementalStateConfigPtr IncrementalStateConfig::Clone() const {
  return New(
      mojo::Clone(clear_period_ms)
  );
}

template <typename T, IncrementalStateConfig::EnableIfSame<T>*>
bool IncrementalStateConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->clear_period_ms, other_struct.clear_period_ms))
    return false;
  return true;
}

template <typename T, IncrementalStateConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.clear_period_ms < rhs.clear_period_ms)
    return true;
  if (rhs.clear_period_ms < lhs.clear_period_ms)
    return false;
  return false;
}
template <typename StructPtrType>
TraceConfigPtr TraceConfig::Clone() const {
  return New(
      mojo::Clone(data_sources),
      mojo::Clone(perfetto_builtin_data_source),
      mojo::Clone(buffers),
      mojo::Clone(incremental_state_config),
      mojo::Clone(duration_ms),
      mojo::Clone(write_into_file),
      mojo::Clone(trace_uuid),
      mojo::Clone(unique_session_name)
  );
}

template <typename T, TraceConfig::EnableIfSame<T>*>
bool TraceConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data_sources, other_struct.data_sources))
    return false;
  if (!mojo::Equals(this->perfetto_builtin_data_source, other_struct.perfetto_builtin_data_source))
    return false;
  if (!mojo::Equals(this->buffers, other_struct.buffers))
    return false;
  if (!mojo::Equals(this->incremental_state_config, other_struct.incremental_state_config))
    return false;
  if (!mojo::Equals(this->duration_ms, other_struct.duration_ms))
    return false;
  if (!mojo::Equals(this->write_into_file, other_struct.write_into_file))
    return false;
  if (!mojo::Equals(this->trace_uuid, other_struct.trace_uuid))
    return false;
  if (!mojo::Equals(this->unique_session_name, other_struct.unique_session_name))
    return false;
  return true;
}

template <typename T, TraceConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data_sources < rhs.data_sources)
    return true;
  if (rhs.data_sources < lhs.data_sources)
    return false;
  if (lhs.perfetto_builtin_data_source < rhs.perfetto_builtin_data_source)
    return true;
  if (rhs.perfetto_builtin_data_source < lhs.perfetto_builtin_data_source)
    return false;
  if (lhs.buffers < rhs.buffers)
    return true;
  if (rhs.buffers < lhs.buffers)
    return false;
  if (lhs.incremental_state_config < rhs.incremental_state_config)
    return true;
  if (rhs.incremental_state_config < lhs.incremental_state_config)
    return false;
  if (lhs.duration_ms < rhs.duration_ms)
    return true;
  if (rhs.duration_ms < lhs.duration_ms)
    return false;
  if (lhs.write_into_file < rhs.write_into_file)
    return true;
  if (rhs.write_into_file < lhs.write_into_file)
    return false;
  if (lhs.trace_uuid < rhs.trace_uuid)
    return true;
  if (rhs.trace_uuid < lhs.trace_uuid)
    return false;
  if (lhs.unique_session_name < rhs.unique_session_name)
    return true;
  if (rhs.unique_session_name < lhs.unique_session_name)
    return false;
  return false;
}


}  // tracing::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::ChunksToMove::DataView,
                                         ::tracing::mojom::ChunksToMovePtr> {
  static bool IsNull(const ::tracing::mojom::ChunksToMovePtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::ChunksToMovePtr* output) { output->reset(); }

  static decltype(::tracing::mojom::ChunksToMove::page) page(
      const ::tracing::mojom::ChunksToMovePtr& input) {
    return input->page;
  }

  static decltype(::tracing::mojom::ChunksToMove::chunk) chunk(
      const ::tracing::mojom::ChunksToMovePtr& input) {
    return input->chunk;
  }

  static decltype(::tracing::mojom::ChunksToMove::target_buffer) target_buffer(
      const ::tracing::mojom::ChunksToMovePtr& input) {
    return input->target_buffer;
  }

  static bool Read(::tracing::mojom::ChunksToMove::DataView input, ::tracing::mojom::ChunksToMovePtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::ChunkPatch::DataView,
                                         ::tracing::mojom::ChunkPatchPtr> {
  static bool IsNull(const ::tracing::mojom::ChunkPatchPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::ChunkPatchPtr* output) { output->reset(); }

  static decltype(::tracing::mojom::ChunkPatch::offset) offset(
      const ::tracing::mojom::ChunkPatchPtr& input) {
    return input->offset;
  }

  static const decltype(::tracing::mojom::ChunkPatch::data)& data(
      const ::tracing::mojom::ChunkPatchPtr& input) {
    return input->data;
  }

  static bool Read(::tracing::mojom::ChunkPatch::DataView input, ::tracing::mojom::ChunkPatchPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::ChunksToPatch::DataView,
                                         ::tracing::mojom::ChunksToPatchPtr> {
  static bool IsNull(const ::tracing::mojom::ChunksToPatchPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::ChunksToPatchPtr* output) { output->reset(); }

  static decltype(::tracing::mojom::ChunksToPatch::target_buffer) target_buffer(
      const ::tracing::mojom::ChunksToPatchPtr& input) {
    return input->target_buffer;
  }

  static decltype(::tracing::mojom::ChunksToPatch::writer_id) writer_id(
      const ::tracing::mojom::ChunksToPatchPtr& input) {
    return input->writer_id;
  }

  static decltype(::tracing::mojom::ChunksToPatch::chunk_id) chunk_id(
      const ::tracing::mojom::ChunksToPatchPtr& input) {
    return input->chunk_id;
  }

  static const decltype(::tracing::mojom::ChunksToPatch::patches)& patches(
      const ::tracing::mojom::ChunksToPatchPtr& input) {
    return input->patches;
  }

  static decltype(::tracing::mojom::ChunksToPatch::has_more_patches) has_more_patches(
      const ::tracing::mojom::ChunksToPatchPtr& input) {
    return input->has_more_patches;
  }

  static bool Read(::tracing::mojom::ChunksToPatch::DataView input, ::tracing::mojom::ChunksToPatchPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::CommitDataRequest::DataView,
                                         ::tracing::mojom::CommitDataRequestPtr> {
  static bool IsNull(const ::tracing::mojom::CommitDataRequestPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::CommitDataRequestPtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::CommitDataRequest::chunks_to_move)& chunks_to_move(
      const ::tracing::mojom::CommitDataRequestPtr& input) {
    return input->chunks_to_move;
  }

  static const decltype(::tracing::mojom::CommitDataRequest::chunks_to_patch)& chunks_to_patch(
      const ::tracing::mojom::CommitDataRequestPtr& input) {
    return input->chunks_to_patch;
  }

  static decltype(::tracing::mojom::CommitDataRequest::flush_request_id) flush_request_id(
      const ::tracing::mojom::CommitDataRequestPtr& input) {
    return input->flush_request_id;
  }

  static bool Read(::tracing::mojom::CommitDataRequest::DataView input, ::tracing::mojom::CommitDataRequestPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::ChromeConfig::DataView,
                                         ::tracing::mojom::ChromeConfigPtr> {
  static bool IsNull(const ::tracing::mojom::ChromeConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::ChromeConfigPtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::ChromeConfig::trace_config)& trace_config(
      const ::tracing::mojom::ChromeConfigPtr& input) {
    return input->trace_config;
  }

  static decltype(::tracing::mojom::ChromeConfig::privacy_filtering_enabled) privacy_filtering_enabled(
      const ::tracing::mojom::ChromeConfigPtr& input) {
    return input->privacy_filtering_enabled;
  }

  static decltype(::tracing::mojom::ChromeConfig::convert_to_legacy_json) convert_to_legacy_json(
      const ::tracing::mojom::ChromeConfigPtr& input) {
    return input->convert_to_legacy_json;
  }

  static decltype(::tracing::mojom::ChromeConfig::event_package_name_filter_enabled) event_package_name_filter_enabled(
      const ::tracing::mojom::ChromeConfigPtr& input) {
    return input->event_package_name_filter_enabled;
  }

  static bool Read(::tracing::mojom::ChromeConfig::DataView input, ::tracing::mojom::ChromeConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::ConsoleConfig::DataView,
                                         ::tracing::mojom::ConsoleConfigPtr> {
  static bool IsNull(const ::tracing::mojom::ConsoleConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::ConsoleConfigPtr* output) { output->reset(); }

  static decltype(::tracing::mojom::ConsoleConfig::output) output(
      const ::tracing::mojom::ConsoleConfigPtr& input) {
    return input->output;
  }

  static decltype(::tracing::mojom::ConsoleConfig::enable_colors) enable_colors(
      const ::tracing::mojom::ConsoleConfigPtr& input) {
    return input->enable_colors;
  }

  static bool Read(::tracing::mojom::ConsoleConfig::DataView input, ::tracing::mojom::ConsoleConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::InterceptorConfig::DataView,
                                         ::tracing::mojom::InterceptorConfigPtr> {
  static bool IsNull(const ::tracing::mojom::InterceptorConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::InterceptorConfigPtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::InterceptorConfig::name)& name(
      const ::tracing::mojom::InterceptorConfigPtr& input) {
    return input->name;
  }

  static const decltype(::tracing::mojom::InterceptorConfig::console_config)& console_config(
      const ::tracing::mojom::InterceptorConfigPtr& input) {
    return input->console_config;
  }

  static bool Read(::tracing::mojom::InterceptorConfig::DataView input, ::tracing::mojom::InterceptorConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::DataSourceConfig::DataView,
                                         ::tracing::mojom::DataSourceConfigPtr> {
  static bool IsNull(const ::tracing::mojom::DataSourceConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::DataSourceConfigPtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::DataSourceConfig::name)& name(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->name;
  }

  static decltype(::tracing::mojom::DataSourceConfig::target_buffer) target_buffer(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->target_buffer;
  }

  static decltype(::tracing::mojom::DataSourceConfig::trace_duration_ms) trace_duration_ms(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->trace_duration_ms;
  }

  static decltype(::tracing::mojom::DataSourceConfig::tracing_session_id) tracing_session_id(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->tracing_session_id;
  }

  static const decltype(::tracing::mojom::DataSourceConfig::chrome_config)& chrome_config(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->chrome_config;
  }

  static const decltype(::tracing::mojom::DataSourceConfig::interceptor_config)& interceptor_config(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->interceptor_config;
  }

  static const decltype(::tracing::mojom::DataSourceConfig::legacy_config)& legacy_config(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->legacy_config;
  }

  static const decltype(::tracing::mojom::DataSourceConfig::track_event_config_raw)& track_event_config_raw(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->track_event_config_raw;
  }

  static const decltype(::tracing::mojom::DataSourceConfig::etw_config_raw)& etw_config_raw(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->etw_config_raw;
  }

  static const decltype(::tracing::mojom::DataSourceConfig::system_metrics_config_raw)& system_metrics_config_raw(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->system_metrics_config_raw;
  }

  static const decltype(::tracing::mojom::DataSourceConfig::histogram_samples_config_raw)& histogram_samples_config_raw(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->histogram_samples_config_raw;
  }

  static bool Read(::tracing::mojom::DataSourceConfig::DataView input, ::tracing::mojom::DataSourceConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::DataSourceRegistration::DataView,
                                         ::tracing::mojom::DataSourceRegistrationPtr> {
  static bool IsNull(const ::tracing::mojom::DataSourceRegistrationPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::DataSourceRegistrationPtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::DataSourceRegistration::name)& name(
      const ::tracing::mojom::DataSourceRegistrationPtr& input) {
    return input->name;
  }

  static decltype(::tracing::mojom::DataSourceRegistration::id) id(
      const ::tracing::mojom::DataSourceRegistrationPtr& input) {
    return input->id;
  }

  static decltype(::tracing::mojom::DataSourceRegistration::will_notify_on_start) will_notify_on_start(
      const ::tracing::mojom::DataSourceRegistrationPtr& input) {
    return input->will_notify_on_start;
  }

  static decltype(::tracing::mojom::DataSourceRegistration::will_notify_on_stop) will_notify_on_stop(
      const ::tracing::mojom::DataSourceRegistrationPtr& input) {
    return input->will_notify_on_stop;
  }

  static decltype(::tracing::mojom::DataSourceRegistration::handles_incremental_state_clear) handles_incremental_state_clear(
      const ::tracing::mojom::DataSourceRegistrationPtr& input) {
    return input->handles_incremental_state_clear;
  }

  static bool Read(::tracing::mojom::DataSourceRegistration::DataView input, ::tracing::mojom::DataSourceRegistrationPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::BufferConfig::DataView,
                                         ::tracing::mojom::BufferConfigPtr> {
  static bool IsNull(const ::tracing::mojom::BufferConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::BufferConfigPtr* output) { output->reset(); }

  static decltype(::tracing::mojom::BufferConfig::size_kb) size_kb(
      const ::tracing::mojom::BufferConfigPtr& input) {
    return input->size_kb;
  }

  static decltype(::tracing::mojom::BufferConfig::fill_policy) fill_policy(
      const ::tracing::mojom::BufferConfigPtr& input) {
    return input->fill_policy;
  }

  static bool Read(::tracing::mojom::BufferConfig::DataView input, ::tracing::mojom::BufferConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::DataSource::DataView,
                                         ::tracing::mojom::DataSourcePtr> {
  static bool IsNull(const ::tracing::mojom::DataSourcePtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::DataSourcePtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::DataSource::config)& config(
      const ::tracing::mojom::DataSourcePtr& input) {
    return input->config;
  }

  static const decltype(::tracing::mojom::DataSource::producer_name_filter)& producer_name_filter(
      const ::tracing::mojom::DataSourcePtr& input) {
    return input->producer_name_filter;
  }

  static bool Read(::tracing::mojom::DataSource::DataView input, ::tracing::mojom::DataSourcePtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::PerfettoBuiltinDataSource::DataView,
                                         ::tracing::mojom::PerfettoBuiltinDataSourcePtr> {
  static bool IsNull(const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::PerfettoBuiltinDataSourcePtr* output) { output->reset(); }

  static decltype(::tracing::mojom::PerfettoBuiltinDataSource::disable_clock_snapshotting) disable_clock_snapshotting(
      const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) {
    return input->disable_clock_snapshotting;
  }

  static decltype(::tracing::mojom::PerfettoBuiltinDataSource::disable_trace_config) disable_trace_config(
      const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) {
    return input->disable_trace_config;
  }

  static decltype(::tracing::mojom::PerfettoBuiltinDataSource::disable_system_info) disable_system_info(
      const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) {
    return input->disable_system_info;
  }

  static decltype(::tracing::mojom::PerfettoBuiltinDataSource::disable_service_events) disable_service_events(
      const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) {
    return input->disable_service_events;
  }

  static decltype(::tracing::mojom::PerfettoBuiltinDataSource::primary_trace_clock_id) primary_trace_clock_id(
      const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) {
    return input->primary_trace_clock_id;
  }

  static bool Read(::tracing::mojom::PerfettoBuiltinDataSource::DataView input, ::tracing::mojom::PerfettoBuiltinDataSourcePtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::IncrementalStateConfig::DataView,
                                         ::tracing::mojom::IncrementalStateConfigPtr> {
  static bool IsNull(const ::tracing::mojom::IncrementalStateConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::IncrementalStateConfigPtr* output) { output->reset(); }

  static decltype(::tracing::mojom::IncrementalStateConfig::clear_period_ms) clear_period_ms(
      const ::tracing::mojom::IncrementalStateConfigPtr& input) {
    return input->clear_period_ms;
  }

  static bool Read(::tracing::mojom::IncrementalStateConfig::DataView input, ::tracing::mojom::IncrementalStateConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::TraceConfig::DataView,
                                         ::tracing::mojom::TraceConfigPtr> {
  static bool IsNull(const ::tracing::mojom::TraceConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::TraceConfigPtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::TraceConfig::data_sources)& data_sources(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->data_sources;
  }

  static const decltype(::tracing::mojom::TraceConfig::perfetto_builtin_data_source)& perfetto_builtin_data_source(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->perfetto_builtin_data_source;
  }

  static const decltype(::tracing::mojom::TraceConfig::buffers)& buffers(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->buffers;
  }

  static const decltype(::tracing::mojom::TraceConfig::incremental_state_config)& incremental_state_config(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->incremental_state_config;
  }

  static decltype(::tracing::mojom::TraceConfig::duration_ms) duration_ms(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->duration_ms;
  }

  static decltype(::tracing::mojom::TraceConfig::write_into_file) write_into_file(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->write_into_file;
  }

  static const decltype(::tracing::mojom::TraceConfig::trace_uuid)& trace_uuid(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->trace_uuid;
  }

  static const decltype(::tracing::mojom::TraceConfig::unique_session_name)& unique_session_name(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->unique_session_name;
  }

  static bool Read(::tracing::mojom::TraceConfig::DataView input, ::tracing::mojom::TraceConfigPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_H_