// services/screen_ai/public/mojom/screen_ai_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/screen_ai/public/mojom/screen_ai_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/screen_ai/public/mojom/screen_ai_service.mojom-params-data.h"
#include "services/screen_ai/public/mojom/screen_ai_service.mojom-shared-message-ids.h"

#include "services/screen_ai/public/mojom/screen_ai_service.mojom-import-headers.h"
#include "services/screen_ai/public/mojom/screen_ai_service.mojom-test-utils.h"


namespace screen_ai::mojom {
VisualAnnotation::VisualAnnotation()
    : lines() {}

VisualAnnotation::VisualAnnotation(
    std::vector<LineBoxPtr> lines_in)
    : lines(std::move(lines_in)) {}

VisualAnnotation::~VisualAnnotation() = default;

void VisualAnnotation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lines"), this->lines,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<LineBoxPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VisualAnnotation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LineBox::LineBox()
    : words(),
      text_line(),
      language(),
      block_id(),
      paragraph_id(),
      bounding_box(),
      bounding_box_angle(),
      confidence() {}

LineBox::LineBox(
    std::vector<WordBoxPtr> words_in,
    const std::string& text_line_in,
    const std::string& language_in,
    int32_t block_id_in,
    int32_t paragraph_id_in,
    const ::gfx::Rect& bounding_box_in,
    float bounding_box_angle_in,
    float confidence_in)
    : words(std::move(words_in)),
      text_line(std::move(text_line_in)),
      language(std::move(language_in)),
      block_id(std::move(block_id_in)),
      paragraph_id(std::move(paragraph_id_in)),
      bounding_box(std::move(bounding_box_in)),
      bounding_box_angle(std::move(bounding_box_angle_in)),
      confidence(std::move(confidence_in)) {}

LineBox::~LineBox() = default;

void LineBox::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "words"), this->words,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<WordBoxPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_line"), this->text_line,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "block_id"), this->block_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "paragraph_id"), this->paragraph_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounding_box"), this->bounding_box,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounding_box_angle"), this->bounding_box_angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "confidence"), this->confidence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LineBox::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WordBox::WordBox()
    : word(),
      language(),
      bounding_box(),
      bounding_box_angle(),
      direction(),
      whitespace_bounding_box(),
      whitespace_bounding_box_angle(),
      confidence() {}

WordBox::WordBox(
    const std::string& word_in,
    const std::string& language_in,
    const ::gfx::Rect& bounding_box_in,
    float bounding_box_angle_in,
    Direction direction_in,
    const ::gfx::Rect& whitespace_bounding_box_in,
    float whitespace_bounding_box_angle_in,
    float confidence_in)
    : word(std::move(word_in)),
      language(std::move(language_in)),
      bounding_box(std::move(bounding_box_in)),
      bounding_box_angle(std::move(bounding_box_angle_in)),
      direction(std::move(direction_in)),
      whitespace_bounding_box(std::move(whitespace_bounding_box_in)),
      whitespace_bounding_box_angle(std::move(whitespace_bounding_box_angle_in)),
      confidence(std::move(confidence_in)) {}

WordBox::~WordBox() = default;

void WordBox::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "word"), this->word,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounding_box"), this->bounding_box,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounding_box_angle"), this->bounding_box_angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direction"), this->direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Direction>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "whitespace_bounding_box"), this->whitespace_bounding_box,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "whitespace_bounding_box_angle"), this->whitespace_bounding_box_angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "confidence"), this->confidence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WordBox::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ScreenAIAnnotator::IPCStableHashFunction ScreenAIAnnotator::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ScreenAIAnnotator>(message.name())) {
    case messages::ScreenAIAnnotator::kPerformOcrAndReturnAnnotation: {
      return &ScreenAIAnnotator::PerformOcrAndReturnAnnotation_Sym::IPCStableHash;
    }
    case messages::ScreenAIAnnotator::kSetClientType: {
      return &ScreenAIAnnotator::SetClientType_Sym::IPCStableHash;
    }
    case messages::ScreenAIAnnotator::kGetMaxImageDimension: {
      return &ScreenAIAnnotator::GetMaxImageDimension_Sym::IPCStableHash;
    }
    case messages::ScreenAIAnnotator::kSetOCRLightMode: {
      return &ScreenAIAnnotator::SetOCRLightMode_Sym::IPCStableHash;
    }
    case messages::ScreenAIAnnotator::kIsOCRBusy: {
      return &ScreenAIAnnotator::IsOCRBusy_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ScreenAIAnnotator::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ScreenAIAnnotator>(message.name())) {
      case messages::ScreenAIAnnotator::kPerformOcrAndReturnAnnotation:
            return "Receive screen_ai::mojom::ScreenAIAnnotator::PerformOcrAndReturnAnnotation";
      case messages::ScreenAIAnnotator::kSetClientType:
            return "Receive screen_ai::mojom::ScreenAIAnnotator::SetClientType";
      case messages::ScreenAIAnnotator::kGetMaxImageDimension:
            return "Receive screen_ai::mojom::ScreenAIAnnotator::GetMaxImageDimension";
      case messages::ScreenAIAnnotator::kSetOCRLightMode:
            return "Receive screen_ai::mojom::ScreenAIAnnotator::SetOCRLightMode";
      case messages::ScreenAIAnnotator::kIsOCRBusy:
            return "Receive screen_ai::mojom::ScreenAIAnnotator::IsOCRBusy";
    }
  } else {
    switch (static_cast<messages::ScreenAIAnnotator>(message.name())) {
      case messages::ScreenAIAnnotator::kPerformOcrAndReturnAnnotation:
            return "Receive reply screen_ai::mojom::ScreenAIAnnotator::PerformOcrAndReturnAnnotation";
      case messages::ScreenAIAnnotator::kSetClientType:
            return "Receive reply screen_ai::mojom::ScreenAIAnnotator::SetClientType";
      case messages::ScreenAIAnnotator::kGetMaxImageDimension:
            return "Receive reply screen_ai::mojom::ScreenAIAnnotator::GetMaxImageDimension";
      case messages::ScreenAIAnnotator::kSetOCRLightMode:
            return "Receive reply screen_ai::mojom::ScreenAIAnnotator::SetOCRLightMode";
      case messages::ScreenAIAnnotator::kIsOCRBusy:
            return "Receive reply screen_ai::mojom::ScreenAIAnnotator::IsOCRBusy";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ScreenAIAnnotator::PerformOcrAndReturnAnnotation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x68332cb1;  // IPCStableHash for screen_ai::mojom::ScreenAIAnnotator::PerformOcrAndReturnAnnotation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ScreenAIAnnotator::SetClientType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaa7a8317;  // IPCStableHash for screen_ai::mojom::ScreenAIAnnotator::SetClientType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ScreenAIAnnotator::GetMaxImageDimension_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x40661ec5;  // IPCStableHash for screen_ai::mojom::ScreenAIAnnotator::GetMaxImageDimension
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ScreenAIAnnotator::SetOCRLightMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdace3eef;  // IPCStableHash for screen_ai::mojom::ScreenAIAnnotator::SetOCRLightMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ScreenAIAnnotator::IsOCRBusy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70290799;  // IPCStableHash for screen_ai::mojom::ScreenAIAnnotator::IsOCRBusy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

// static
bool ScreenAIAnnotator::RuntimeFeature_IsEnabled_(bool expected) {
  bool enabled = base::FeatureList::IsEnabled(::ax::mojom::features::kScreenAIOCREnabled);
#if DCHECK_IS_ON()
  if (expected) {
    DCHECK(enabled) << "RuntimeFeature ::ax::mojom::features::kScreenAIOCREnabled for ScreenAIAnnotator is not enabled";
  }
#endif
  return enabled;
}

class ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ForwardToCallback(
      ScreenAIAnnotator::PerformOcrAndReturnAnnotationCallback callback
      ) : callback_(std::move(callback)) {
  }

  ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ForwardToCallback(const ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ForwardToCallback&) = delete;
  ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ForwardToCallback& operator=(const ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ScreenAIAnnotator::PerformOcrAndReturnAnnotationCallback callback_;
};

class ScreenAIAnnotator_GetMaxImageDimension_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ScreenAIAnnotator_GetMaxImageDimension_ForwardToCallback(
      ScreenAIAnnotator::GetMaxImageDimensionCallback callback
      ) : callback_(std::move(callback)) {
  }

  ScreenAIAnnotator_GetMaxImageDimension_ForwardToCallback(const ScreenAIAnnotator_GetMaxImageDimension_ForwardToCallback&) = delete;
  ScreenAIAnnotator_GetMaxImageDimension_ForwardToCallback& operator=(const ScreenAIAnnotator_GetMaxImageDimension_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ScreenAIAnnotator::GetMaxImageDimensionCallback callback_;
};

class ScreenAIAnnotator_IsOCRBusy_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ScreenAIAnnotator_IsOCRBusy_ForwardToCallback(
      ScreenAIAnnotator::IsOCRBusyCallback callback
      ) : callback_(std::move(callback)) {
  }

  ScreenAIAnnotator_IsOCRBusy_ForwardToCallback(const ScreenAIAnnotator_IsOCRBusy_ForwardToCallback&) = delete;
  ScreenAIAnnotator_IsOCRBusy_ForwardToCallback& operator=(const ScreenAIAnnotator_IsOCRBusy_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ScreenAIAnnotator::IsOCRBusyCallback callback_;
};

ScreenAIAnnotatorProxy::ScreenAIAnnotatorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ScreenAIAnnotatorProxy::PerformOcrAndReturnAnnotation(
    const ::SkBitmap& in_image, PerformOcrAndReturnAnnotationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::ScreenAIAnnotator::PerformOcrAndReturnAnnotation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIAnnotator::kPerformOcrAndReturnAnnotation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIAnnotator_PerformOcrAndReturnAnnotation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image in ScreenAIAnnotator.PerformOcrAndReturnAnnotation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIAnnotator::Name_);
  message.set_method_name("PerformOcrAndReturnAnnotation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ScreenAIAnnotatorProxy::SetClientType(
    OcrClientType in_client_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::ScreenAIAnnotator::SetClientType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_type"), in_client_type,
                        "<value of type OcrClientType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIAnnotator::kSetClientType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIAnnotator_SetClientType_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::screen_ai::mojom::OcrClientType>(
    in_client_type,
    &params->client_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIAnnotator::Name_);
  message.set_method_name("SetClientType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ScreenAIAnnotatorProxy::GetMaxImageDimension(
    GetMaxImageDimensionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send screen_ai::mojom::ScreenAIAnnotator::GetMaxImageDimension");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIAnnotator::kGetMaxImageDimension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIAnnotator_GetMaxImageDimension_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIAnnotator::Name_);
  message.set_method_name("GetMaxImageDimension");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ScreenAIAnnotator_GetMaxImageDimension_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ScreenAIAnnotatorProxy::SetOCRLightMode(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::ScreenAIAnnotator::SetOCRLightMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIAnnotator::kSetOCRLightMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIAnnotator_SetOCRLightMode_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIAnnotator::Name_);
  message.set_method_name("SetOCRLightMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ScreenAIAnnotatorProxy::IsOCRBusy(
    IsOCRBusyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send screen_ai::mojom::ScreenAIAnnotator::IsOCRBusy");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIAnnotator::kIsOCRBusy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIAnnotator_IsOCRBusy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIAnnotator::Name_);
  message.set_method_name("IsOCRBusy");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ScreenAIAnnotator_IsOCRBusy_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ScreenAIAnnotator::PerformOcrAndReturnAnnotationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ProxyToResponder> proxy(
        new ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ScreenAIAnnotator::PerformOcrAndReturnAnnotationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      VisualAnnotationPtr in_visual_annotation);
};

bool ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ScreenAIAnnotator.0
  bool success = true;
  VisualAnnotationPtr p_visual_annotation{};
  ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadVisualAnnotation(&p_visual_annotation))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ScreenAIAnnotator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_visual_annotation));
  }
  return true;
}

void ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ProxyToResponder::Run(
    VisualAnnotationPtr in_visual_annotation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply screen_ai::mojom::ScreenAIAnnotator::PerformOcrAndReturnAnnotation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visual_annotation"), in_visual_annotation,
                        "<value of type VisualAnnotationPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIAnnotator::kPerformOcrAndReturnAnnotation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->visual_annotation)::BaseType> visual_annotation_fragment(
          params.message());
  
  mojo::internal::Serialize<::screen_ai::mojom::VisualAnnotationDataView>(
    in_visual_annotation,
    visual_annotation_fragment);

  params->visual_annotation.Set(
      visual_annotation_fragment.is_null() ? nullptr : visual_annotation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->visual_annotation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null visual_annotation in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIAnnotator::Name_);
  message.set_method_name("PerformOcrAndReturnAnnotation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ScreenAIAnnotator_GetMaxImageDimension_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ScreenAIAnnotator::GetMaxImageDimensionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ScreenAIAnnotator_GetMaxImageDimension_ProxyToResponder> proxy(
        new ScreenAIAnnotator_GetMaxImageDimension_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ScreenAIAnnotator_GetMaxImageDimension_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ScreenAIAnnotator_GetMaxImageDimension_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ScreenAIAnnotator_GetMaxImageDimension_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ScreenAIAnnotator::GetMaxImageDimensionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_max_dimension);
};

bool ScreenAIAnnotator_GetMaxImageDimension_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ScreenAIAnnotator_GetMaxImageDimension_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ScreenAIAnnotator_GetMaxImageDimension_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ScreenAIAnnotator.2
  bool success = true;
  uint32_t p_max_dimension{};
  ScreenAIAnnotator_GetMaxImageDimension_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_max_dimension = input_data_view.max_dimension();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ScreenAIAnnotator::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_max_dimension));
  }
  return true;
}

void ScreenAIAnnotator_GetMaxImageDimension_ProxyToResponder::Run(
    uint32_t in_max_dimension) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply screen_ai::mojom::ScreenAIAnnotator::GetMaxImageDimension", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_dimension"), in_max_dimension,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIAnnotator::kGetMaxImageDimension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIAnnotator_GetMaxImageDimension_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->max_dimension = in_max_dimension;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIAnnotator::Name_);
  message.set_method_name("GetMaxImageDimension");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ScreenAIAnnotator_IsOCRBusy_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ScreenAIAnnotator::IsOCRBusyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ScreenAIAnnotator_IsOCRBusy_ProxyToResponder> proxy(
        new ScreenAIAnnotator_IsOCRBusy_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ScreenAIAnnotator_IsOCRBusy_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ScreenAIAnnotator_IsOCRBusy_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ScreenAIAnnotator_IsOCRBusy_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ScreenAIAnnotator::IsOCRBusyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_busy);
};

bool ScreenAIAnnotator_IsOCRBusy_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ScreenAIAnnotator_IsOCRBusy_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ScreenAIAnnotator_IsOCRBusy_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ScreenAIAnnotator.4
  bool success = true;
  bool p_busy{};
  ScreenAIAnnotator_IsOCRBusy_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_busy = input_data_view.busy();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ScreenAIAnnotator::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_busy));
  }
  return true;
}

void ScreenAIAnnotator_IsOCRBusy_ProxyToResponder::Run(
    bool in_busy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply screen_ai::mojom::ScreenAIAnnotator::IsOCRBusy", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("busy"), in_busy,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIAnnotator::kIsOCRBusy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIAnnotator_IsOCRBusy_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->busy = in_busy;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIAnnotator::Name_);
  message.set_method_name("IsOCRBusy");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ScreenAIAnnotatorStubDispatch::Accept(
    ScreenAIAnnotator* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ScreenAIAnnotator>(message->header()->name)) {
    case messages::ScreenAIAnnotator::kPerformOcrAndReturnAnnotation: {
      break;
    }
    case messages::ScreenAIAnnotator::kSetClientType: {
      DCHECK(message->is_serialized());
      internal::ScreenAIAnnotator_SetClientType_Params_Data* params =
          reinterpret_cast<internal::ScreenAIAnnotator_SetClientType_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ScreenAIAnnotator.1
      bool success = true;
      OcrClientType p_client_type{};
      ScreenAIAnnotator_SetClientType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientType(&p_client_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenAIAnnotator::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClientType(        
        std::move(p_client_type));
      return true;
    }
    case messages::ScreenAIAnnotator::kGetMaxImageDimension: {
      break;
    }
    case messages::ScreenAIAnnotator::kSetOCRLightMode: {
      DCHECK(message->is_serialized());
      internal::ScreenAIAnnotator_SetOCRLightMode_Params_Data* params =
          reinterpret_cast<internal::ScreenAIAnnotator_SetOCRLightMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ScreenAIAnnotator.3
      bool success = true;
      bool p_enabled{};
      ScreenAIAnnotator_SetOCRLightMode_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenAIAnnotator::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOCRLightMode(        
        std::move(p_enabled));
      return true;
    }
    case messages::ScreenAIAnnotator::kIsOCRBusy: {
      break;
    }
  }
  return false;
}

// static
bool ScreenAIAnnotatorStubDispatch::AcceptWithResponder(
    ScreenAIAnnotator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ScreenAIAnnotator>(message->header()->name)) {
    case messages::ScreenAIAnnotator::kPerformOcrAndReturnAnnotation: {
      internal::ScreenAIAnnotator_PerformOcrAndReturnAnnotation_Params_Data* params =
          reinterpret_cast<
              internal::ScreenAIAnnotator_PerformOcrAndReturnAnnotation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ScreenAIAnnotator.0
      bool success = true;
      ::SkBitmap p_image{};
      ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenAIAnnotator::Name_, 0, false);
        return false;
      }
      auto callback =
          ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformOcrAndReturnAnnotation(        
        std::move(p_image), std::move(callback));
      return true;
    }
    case messages::ScreenAIAnnotator::kSetClientType: {
      break;
    }
    case messages::ScreenAIAnnotator::kGetMaxImageDimension: {
      internal::ScreenAIAnnotator_GetMaxImageDimension_Params_Data* params =
          reinterpret_cast<
              internal::ScreenAIAnnotator_GetMaxImageDimension_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ScreenAIAnnotator.2
      bool success = true;
      ScreenAIAnnotator_GetMaxImageDimension_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenAIAnnotator::Name_, 2, false);
        return false;
      }
      auto callback =
          ScreenAIAnnotator_GetMaxImageDimension_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMaxImageDimension(std::move(callback));
      return true;
    }
    case messages::ScreenAIAnnotator::kSetOCRLightMode: {
      break;
    }
    case messages::ScreenAIAnnotator::kIsOCRBusy: {
      internal::ScreenAIAnnotator_IsOCRBusy_Params_Data* params =
          reinterpret_cast<
              internal::ScreenAIAnnotator_IsOCRBusy_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ScreenAIAnnotator.4
      bool success = true;
      ScreenAIAnnotator_IsOCRBusy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenAIAnnotator::Name_, 4, false);
        return false;
      }
      auto callback =
          ScreenAIAnnotator_IsOCRBusy_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsOCRBusy(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kScreenAIAnnotatorValidationInfo[] = {
    { &internal::ScreenAIAnnotator_PerformOcrAndReturnAnnotation_Params_Data::Validate,
     &internal::ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ResponseParams_Data::Validate},
    { &internal::ScreenAIAnnotator_SetClientType_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ScreenAIAnnotator_GetMaxImageDimension_Params_Data::Validate,
     &internal::ScreenAIAnnotator_GetMaxImageDimension_ResponseParams_Data::Validate},
    { &internal::ScreenAIAnnotator_SetOCRLightMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ScreenAIAnnotator_IsOCRBusy_Params_Data::Validate,
     &internal::ScreenAIAnnotator_IsOCRBusy_ResponseParams_Data::Validate},
};

bool ScreenAIAnnotatorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::screen_ai::mojom::ScreenAIAnnotator::Name_,
    kScreenAIAnnotatorValidationInfo);
}

bool ScreenAIAnnotatorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::screen_ai::mojom::ScreenAIAnnotator::Name_,
    kScreenAIAnnotatorValidationInfo);
}
// The declaration includes the definition on other builds.

Screen2xMainContentExtractor::IPCStableHashFunction Screen2xMainContentExtractor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Screen2xMainContentExtractor>(message.name())) {
    case messages::Screen2xMainContentExtractor::kExtractMainContent: {
      return &Screen2xMainContentExtractor::ExtractMainContent_Sym::IPCStableHash;
    }
    case messages::Screen2xMainContentExtractor::kExtractMainNode: {
      return &Screen2xMainContentExtractor::ExtractMainNode_Sym::IPCStableHash;
    }
    case messages::Screen2xMainContentExtractor::kIdentifyMainNode: {
      return &Screen2xMainContentExtractor::IdentifyMainNode_Sym::IPCStableHash;
    }
    case messages::Screen2xMainContentExtractor::kSetClientType: {
      return &Screen2xMainContentExtractor::SetClientType_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Screen2xMainContentExtractor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Screen2xMainContentExtractor>(message.name())) {
      case messages::Screen2xMainContentExtractor::kExtractMainContent:
            return "Receive screen_ai::mojom::Screen2xMainContentExtractor::ExtractMainContent";
      case messages::Screen2xMainContentExtractor::kExtractMainNode:
            return "Receive screen_ai::mojom::Screen2xMainContentExtractor::ExtractMainNode";
      case messages::Screen2xMainContentExtractor::kIdentifyMainNode:
            return "Receive screen_ai::mojom::Screen2xMainContentExtractor::IdentifyMainNode";
      case messages::Screen2xMainContentExtractor::kSetClientType:
            return "Receive screen_ai::mojom::Screen2xMainContentExtractor::SetClientType";
    }
  } else {
    switch (static_cast<messages::Screen2xMainContentExtractor>(message.name())) {
      case messages::Screen2xMainContentExtractor::kExtractMainContent:
            return "Receive reply screen_ai::mojom::Screen2xMainContentExtractor::ExtractMainContent";
      case messages::Screen2xMainContentExtractor::kExtractMainNode:
            return "Receive reply screen_ai::mojom::Screen2xMainContentExtractor::ExtractMainNode";
      case messages::Screen2xMainContentExtractor::kIdentifyMainNode:
            return "Receive reply screen_ai::mojom::Screen2xMainContentExtractor::IdentifyMainNode";
      case messages::Screen2xMainContentExtractor::kSetClientType:
            return "Receive reply screen_ai::mojom::Screen2xMainContentExtractor::SetClientType";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Screen2xMainContentExtractor::ExtractMainContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f8943a3;  // IPCStableHash for screen_ai::mojom::Screen2xMainContentExtractor::ExtractMainContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Screen2xMainContentExtractor::ExtractMainNode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x745a8822;  // IPCStableHash for screen_ai::mojom::Screen2xMainContentExtractor::ExtractMainNode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Screen2xMainContentExtractor::IdentifyMainNode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3262e2db;  // IPCStableHash for screen_ai::mojom::Screen2xMainContentExtractor::IdentifyMainNode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Screen2xMainContentExtractor::SetClientType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5db4cc52;  // IPCStableHash for screen_ai::mojom::Screen2xMainContentExtractor::SetClientType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Screen2xMainContentExtractor_ExtractMainContent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Screen2xMainContentExtractor_ExtractMainContent_ForwardToCallback(
      Screen2xMainContentExtractor::ExtractMainContentCallback callback
      ) : callback_(std::move(callback)) {
  }

  Screen2xMainContentExtractor_ExtractMainContent_ForwardToCallback(const Screen2xMainContentExtractor_ExtractMainContent_ForwardToCallback&) = delete;
  Screen2xMainContentExtractor_ExtractMainContent_ForwardToCallback& operator=(const Screen2xMainContentExtractor_ExtractMainContent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Screen2xMainContentExtractor::ExtractMainContentCallback callback_;
};

class Screen2xMainContentExtractor_ExtractMainNode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Screen2xMainContentExtractor_ExtractMainNode_ForwardToCallback(
      Screen2xMainContentExtractor::ExtractMainNodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  Screen2xMainContentExtractor_ExtractMainNode_ForwardToCallback(const Screen2xMainContentExtractor_ExtractMainNode_ForwardToCallback&) = delete;
  Screen2xMainContentExtractor_ExtractMainNode_ForwardToCallback& operator=(const Screen2xMainContentExtractor_ExtractMainNode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Screen2xMainContentExtractor::ExtractMainNodeCallback callback_;
};

class Screen2xMainContentExtractor_IdentifyMainNode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Screen2xMainContentExtractor_IdentifyMainNode_ForwardToCallback(
      Screen2xMainContentExtractor::IdentifyMainNodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  Screen2xMainContentExtractor_IdentifyMainNode_ForwardToCallback(const Screen2xMainContentExtractor_IdentifyMainNode_ForwardToCallback&) = delete;
  Screen2xMainContentExtractor_IdentifyMainNode_ForwardToCallback& operator=(const Screen2xMainContentExtractor_IdentifyMainNode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Screen2xMainContentExtractor::IdentifyMainNodeCallback callback_;
};

Screen2xMainContentExtractorProxy::Screen2xMainContentExtractorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void Screen2xMainContentExtractorProxy::ExtractMainContent(
    const ::ui::AXTreeUpdate& in_snapshot, ExtractMainContentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::Screen2xMainContentExtractor::ExtractMainContent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("snapshot"), in_snapshot,
                        "<value of type const ::ui::AXTreeUpdate&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Screen2xMainContentExtractor::kExtractMainContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::Screen2xMainContentExtractor_ExtractMainContent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->snapshot)::BaseType> snapshot_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
    in_snapshot,
    snapshot_fragment);

  params->snapshot.Set(
      snapshot_fragment.is_null() ? nullptr : snapshot_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->snapshot.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null snapshot in Screen2xMainContentExtractor.ExtractMainContent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Screen2xMainContentExtractor::Name_);
  message.set_method_name("ExtractMainContent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Screen2xMainContentExtractor_ExtractMainContent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void Screen2xMainContentExtractorProxy::ExtractMainNode(
    const ::ui::AXTreeUpdate& in_snapshot, ExtractMainNodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::Screen2xMainContentExtractor::ExtractMainNode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("snapshot"), in_snapshot,
                        "<value of type const ::ui::AXTreeUpdate&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Screen2xMainContentExtractor::kExtractMainNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::Screen2xMainContentExtractor_ExtractMainNode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->snapshot)::BaseType> snapshot_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
    in_snapshot,
    snapshot_fragment);

  params->snapshot.Set(
      snapshot_fragment.is_null() ? nullptr : snapshot_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->snapshot.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null snapshot in Screen2xMainContentExtractor.ExtractMainNode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Screen2xMainContentExtractor::Name_);
  message.set_method_name("ExtractMainNode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Screen2xMainContentExtractor_ExtractMainNode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void Screen2xMainContentExtractorProxy::IdentifyMainNode(
    const ::ui::AXTreeUpdate& in_ax_tree, IdentifyMainNodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::Screen2xMainContentExtractor::IdentifyMainNode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ax_tree"), in_ax_tree,
                        "<value of type const ::ui::AXTreeUpdate&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Screen2xMainContentExtractor::kIdentifyMainNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::Screen2xMainContentExtractor_IdentifyMainNode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ax_tree)::BaseType> ax_tree_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
    in_ax_tree,
    ax_tree_fragment);

  params->ax_tree.Set(
      ax_tree_fragment.is_null() ? nullptr : ax_tree_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ax_tree.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ax_tree in Screen2xMainContentExtractor.IdentifyMainNode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Screen2xMainContentExtractor::Name_);
  message.set_method_name("IdentifyMainNode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Screen2xMainContentExtractor_IdentifyMainNode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void Screen2xMainContentExtractorProxy::SetClientType(
    MceClientType in_client_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::Screen2xMainContentExtractor::SetClientType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_type"), in_client_type,
                        "<value of type MceClientType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Screen2xMainContentExtractor::kSetClientType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::Screen2xMainContentExtractor_SetClientType_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::screen_ai::mojom::MceClientType>(
    in_client_type,
    &params->client_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Screen2xMainContentExtractor::Name_);
  message.set_method_name("SetClientType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Screen2xMainContentExtractor_ExtractMainContent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Screen2xMainContentExtractor::ExtractMainContentCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Screen2xMainContentExtractor_ExtractMainContent_ProxyToResponder> proxy(
        new Screen2xMainContentExtractor_ExtractMainContent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Screen2xMainContentExtractor_ExtractMainContent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Screen2xMainContentExtractor_ExtractMainContent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Screen2xMainContentExtractor_ExtractMainContent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Screen2xMainContentExtractor::ExtractMainContentCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<int32_t>& in_content_node_ids);
};

bool Screen2xMainContentExtractor_ExtractMainContent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Screen2xMainContentExtractor_ExtractMainContent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Screen2xMainContentExtractor_ExtractMainContent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Screen2xMainContentExtractor.0
  bool success = true;
  std::vector<int32_t> p_content_node_ids{};
  Screen2xMainContentExtractor_ExtractMainContent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadContentNodeIds(&p_content_node_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Screen2xMainContentExtractor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_content_node_ids));
  }
  return true;
}

void Screen2xMainContentExtractor_ExtractMainContent_ProxyToResponder::Run(
    const std::vector<int32_t>& in_content_node_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply screen_ai::mojom::Screen2xMainContentExtractor::ExtractMainContent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_node_ids"), in_content_node_ids,
                        "<value of type const std::vector<int32_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Screen2xMainContentExtractor::kExtractMainContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::Screen2xMainContentExtractor_ExtractMainContent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content_node_ids)::BaseType>
      content_node_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& content_node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
    in_content_node_ids,
    content_node_ids_fragment,
    &content_node_ids_validate_params);

  params->content_node_ids.Set(
      content_node_ids_fragment.is_null() ? nullptr : content_node_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_node_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_node_ids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Screen2xMainContentExtractor::Name_);
  message.set_method_name("ExtractMainContent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Screen2xMainContentExtractor_ExtractMainNode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Screen2xMainContentExtractor::ExtractMainNodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Screen2xMainContentExtractor_ExtractMainNode_ProxyToResponder> proxy(
        new Screen2xMainContentExtractor_ExtractMainNode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Screen2xMainContentExtractor_ExtractMainNode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Screen2xMainContentExtractor_ExtractMainNode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Screen2xMainContentExtractor_ExtractMainNode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Screen2xMainContentExtractor::ExtractMainNodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_main_node_id);
};

bool Screen2xMainContentExtractor_ExtractMainNode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Screen2xMainContentExtractor_ExtractMainNode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Screen2xMainContentExtractor_ExtractMainNode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Screen2xMainContentExtractor.1
  bool success = true;
  int32_t p_main_node_id{};
  Screen2xMainContentExtractor_ExtractMainNode_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_main_node_id = input_data_view.main_node_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Screen2xMainContentExtractor::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_main_node_id));
  }
  return true;
}

void Screen2xMainContentExtractor_ExtractMainNode_ProxyToResponder::Run(
    int32_t in_main_node_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply screen_ai::mojom::Screen2xMainContentExtractor::ExtractMainNode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_node_id"), in_main_node_id,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Screen2xMainContentExtractor::kExtractMainNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::Screen2xMainContentExtractor_ExtractMainNode_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->main_node_id = in_main_node_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Screen2xMainContentExtractor::Name_);
  message.set_method_name("ExtractMainNode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Screen2xMainContentExtractor_IdentifyMainNode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Screen2xMainContentExtractor::IdentifyMainNodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Screen2xMainContentExtractor_IdentifyMainNode_ProxyToResponder> proxy(
        new Screen2xMainContentExtractor_IdentifyMainNode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Screen2xMainContentExtractor_IdentifyMainNode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Screen2xMainContentExtractor_IdentifyMainNode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Screen2xMainContentExtractor_IdentifyMainNode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Screen2xMainContentExtractor::IdentifyMainNodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::ui::AXTreeID& in_tree_id, int32_t in_node_id);
};

bool Screen2xMainContentExtractor_IdentifyMainNode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Screen2xMainContentExtractor_IdentifyMainNode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Screen2xMainContentExtractor_IdentifyMainNode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Screen2xMainContentExtractor.2
  bool success = true;
  ::ui::AXTreeID p_tree_id{};
  int32_t p_node_id{};
  Screen2xMainContentExtractor_IdentifyMainNode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTreeId(&p_tree_id))
    success = false;
  if (success)
    p_node_id = input_data_view.node_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Screen2xMainContentExtractor::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_tree_id), 
std::move(p_node_id));
  }
  return true;
}

void Screen2xMainContentExtractor_IdentifyMainNode_ProxyToResponder::Run(
    const ::ui::AXTreeID& in_tree_id, int32_t in_node_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply screen_ai::mojom::Screen2xMainContentExtractor::IdentifyMainNode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_id"), in_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_id"), in_node_id,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Screen2xMainContentExtractor::kIdentifyMainNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::Screen2xMainContentExtractor_IdentifyMainNode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->tree_id)>
      tree_id_fragment(params.message());
  tree_id_fragment.Claim(&params->tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_tree_id,
    tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tree_id in ");

  params->node_id = in_node_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Screen2xMainContentExtractor::Name_);
  message.set_method_name("IdentifyMainNode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool Screen2xMainContentExtractorStubDispatch::Accept(
    Screen2xMainContentExtractor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Screen2xMainContentExtractor>(message->header()->name)) {
    case messages::Screen2xMainContentExtractor::kExtractMainContent: {
      break;
    }
    case messages::Screen2xMainContentExtractor::kExtractMainNode: {
      break;
    }
    case messages::Screen2xMainContentExtractor::kIdentifyMainNode: {
      break;
    }
    case messages::Screen2xMainContentExtractor::kSetClientType: {
      DCHECK(message->is_serialized());
      internal::Screen2xMainContentExtractor_SetClientType_Params_Data* params =
          reinterpret_cast<internal::Screen2xMainContentExtractor_SetClientType_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Screen2xMainContentExtractor.3
      bool success = true;
      MceClientType p_client_type{};
      Screen2xMainContentExtractor_SetClientType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientType(&p_client_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Screen2xMainContentExtractor::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClientType(        
        std::move(p_client_type));
      return true;
    }
  }
  return false;
}

// static
bool Screen2xMainContentExtractorStubDispatch::AcceptWithResponder(
    Screen2xMainContentExtractor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Screen2xMainContentExtractor>(message->header()->name)) {
    case messages::Screen2xMainContentExtractor::kExtractMainContent: {
      internal::Screen2xMainContentExtractor_ExtractMainContent_Params_Data* params =
          reinterpret_cast<
              internal::Screen2xMainContentExtractor_ExtractMainContent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Screen2xMainContentExtractor.0
      bool success = true;
      ::ui::AXTreeUpdate p_snapshot{};
      Screen2xMainContentExtractor_ExtractMainContent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSnapshot(&p_snapshot))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Screen2xMainContentExtractor::Name_, 0, false);
        return false;
      }
      auto callback =
          Screen2xMainContentExtractor_ExtractMainContent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractMainContent(        
        std::move(p_snapshot), std::move(callback));
      return true;
    }
    case messages::Screen2xMainContentExtractor::kExtractMainNode: {
      internal::Screen2xMainContentExtractor_ExtractMainNode_Params_Data* params =
          reinterpret_cast<
              internal::Screen2xMainContentExtractor_ExtractMainNode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Screen2xMainContentExtractor.1
      bool success = true;
      ::ui::AXTreeUpdate p_snapshot{};
      Screen2xMainContentExtractor_ExtractMainNode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSnapshot(&p_snapshot))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Screen2xMainContentExtractor::Name_, 1, false);
        return false;
      }
      auto callback =
          Screen2xMainContentExtractor_ExtractMainNode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractMainNode(        
        std::move(p_snapshot), std::move(callback));
      return true;
    }
    case messages::Screen2xMainContentExtractor::kIdentifyMainNode: {
      internal::Screen2xMainContentExtractor_IdentifyMainNode_Params_Data* params =
          reinterpret_cast<
              internal::Screen2xMainContentExtractor_IdentifyMainNode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Screen2xMainContentExtractor.2
      bool success = true;
      ::ui::AXTreeUpdate p_ax_tree{};
      Screen2xMainContentExtractor_IdentifyMainNode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAxTree(&p_ax_tree))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Screen2xMainContentExtractor::Name_, 2, false);
        return false;
      }
      auto callback =
          Screen2xMainContentExtractor_IdentifyMainNode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IdentifyMainNode(        
        std::move(p_ax_tree), std::move(callback));
      return true;
    }
    case messages::Screen2xMainContentExtractor::kSetClientType: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kScreen2xMainContentExtractorValidationInfo[] = {
    { &internal::Screen2xMainContentExtractor_ExtractMainContent_Params_Data::Validate,
     &internal::Screen2xMainContentExtractor_ExtractMainContent_ResponseParams_Data::Validate},
    { &internal::Screen2xMainContentExtractor_ExtractMainNode_Params_Data::Validate,
     &internal::Screen2xMainContentExtractor_ExtractMainNode_ResponseParams_Data::Validate},
    { &internal::Screen2xMainContentExtractor_IdentifyMainNode_Params_Data::Validate,
     &internal::Screen2xMainContentExtractor_IdentifyMainNode_ResponseParams_Data::Validate},
    { &internal::Screen2xMainContentExtractor_SetClientType_Params_Data::Validate,
     nullptr /* no response */},
};

bool Screen2xMainContentExtractorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::screen_ai::mojom::Screen2xMainContentExtractor::Name_,
    kScreen2xMainContentExtractorValidationInfo);
}

bool Screen2xMainContentExtractorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::screen_ai::mojom::Screen2xMainContentExtractor::Name_,
    kScreen2xMainContentExtractorValidationInfo);
}
// The declaration includes the definition on other builds.

OCRService::IPCStableHashFunction OCRService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OCRService>(message.name())) {
    case messages::OCRService::kBindAnnotator: {
      return &OCRService::BindAnnotator_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OCRService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OCRService>(message.name())) {
      case messages::OCRService::kBindAnnotator:
            return "Receive screen_ai::mojom::OCRService::BindAnnotator";
    }
  } else {
    switch (static_cast<messages::OCRService>(message.name())) {
      case messages::OCRService::kBindAnnotator:
            return "Receive reply screen_ai::mojom::OCRService::BindAnnotator";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OCRService::BindAnnotator_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x779656e2;  // IPCStableHash for screen_ai::mojom::OCRService::BindAnnotator
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

// static
bool OCRService::RuntimeFeature_IsEnabled_(bool expected) {
  bool enabled = base::FeatureList::IsEnabled(::ax::mojom::features::kScreenAIOCREnabled);
#if DCHECK_IS_ON()
  if (expected) {
    DCHECK(enabled) << "RuntimeFeature ::ax::mojom::features::kScreenAIOCREnabled for OCRService is not enabled";
  }
#endif
  return enabled;
}

OCRServiceProxy::OCRServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OCRServiceProxy::BindAnnotator(
    ::mojo::PendingReceiver<ScreenAIAnnotator> in_annotator) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::OCRService::BindAnnotator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("annotator"), in_annotator,
                        "<value of type ::mojo::PendingReceiver<ScreenAIAnnotator>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OCRService::kBindAnnotator), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::OCRService_BindAnnotator_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::screen_ai::mojom::ScreenAIAnnotatorInterfaceBase>>(
    in_annotator,
    &params->annotator,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OCRService::Name_);
  message.set_method_name("BindAnnotator");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool OCRServiceStubDispatch::Accept(
    OCRService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OCRService>(message->header()->name)) {
    case messages::OCRService::kBindAnnotator: {
      DCHECK(message->is_serialized());
      internal::OCRService_BindAnnotator_Params_Data* params =
          reinterpret_cast<internal::OCRService_BindAnnotator_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OCRService.0
      bool success = true;
      ::mojo::PendingReceiver<ScreenAIAnnotator> p_annotator{};
      OCRService_BindAnnotator_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_annotator =
            input_data_view.TakeAnnotator<decltype(p_annotator)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OCRService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAnnotator(        
        std::move(p_annotator));
      return true;
    }
  }
  return false;
}

// static
bool OCRServiceStubDispatch::AcceptWithResponder(
    OCRService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OCRService>(message->header()->name)) {
    case messages::OCRService::kBindAnnotator: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOCRServiceValidationInfo[] = {
    { &internal::OCRService_BindAnnotator_Params_Data::Validate,
     nullptr /* no response */},
};

bool OCRServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::screen_ai::mojom::OCRService::Name_,
    kOCRServiceValidationInfo);
}

// The declaration includes the definition on other builds.

MainContentExtractionService::IPCStableHashFunction MainContentExtractionService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MainContentExtractionService>(message.name())) {
    case messages::MainContentExtractionService::kBindMainContentExtractor: {
      return &MainContentExtractionService::BindMainContentExtractor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MainContentExtractionService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MainContentExtractionService>(message.name())) {
      case messages::MainContentExtractionService::kBindMainContentExtractor:
            return "Receive screen_ai::mojom::MainContentExtractionService::BindMainContentExtractor";
    }
  } else {
    switch (static_cast<messages::MainContentExtractionService>(message.name())) {
      case messages::MainContentExtractionService::kBindMainContentExtractor:
            return "Receive reply screen_ai::mojom::MainContentExtractionService::BindMainContentExtractor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MainContentExtractionService::BindMainContentExtractor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x446e6b97;  // IPCStableHash for screen_ai::mojom::MainContentExtractionService::BindMainContentExtractor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

// static
bool MainContentExtractionService::RuntimeFeature_IsEnabled_(bool expected) {
  bool enabled = base::FeatureList::IsEnabled(::ax::mojom::features::kScreenAIMainContentExtractionEnabled);
#if DCHECK_IS_ON()
  if (expected) {
    DCHECK(enabled) << "RuntimeFeature ::ax::mojom::features::kScreenAIMainContentExtractionEnabled for MainContentExtractionService is not enabled";
  }
#endif
  return enabled;
}

MainContentExtractionServiceProxy::MainContentExtractionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MainContentExtractionServiceProxy::BindMainContentExtractor(
    ::mojo::PendingReceiver<Screen2xMainContentExtractor> in_main_content_extractor) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::MainContentExtractionService::BindMainContentExtractor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_content_extractor"), in_main_content_extractor,
                        "<value of type ::mojo::PendingReceiver<Screen2xMainContentExtractor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MainContentExtractionService::kBindMainContentExtractor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::MainContentExtractionService_BindMainContentExtractor_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::screen_ai::mojom::Screen2xMainContentExtractorInterfaceBase>>(
    in_main_content_extractor,
    &params->main_content_extractor,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MainContentExtractionService::Name_);
  message.set_method_name("BindMainContentExtractor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MainContentExtractionServiceStubDispatch::Accept(
    MainContentExtractionService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MainContentExtractionService>(message->header()->name)) {
    case messages::MainContentExtractionService::kBindMainContentExtractor: {
      DCHECK(message->is_serialized());
      internal::MainContentExtractionService_BindMainContentExtractor_Params_Data* params =
          reinterpret_cast<internal::MainContentExtractionService_BindMainContentExtractor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MainContentExtractionService.0
      bool success = true;
      ::mojo::PendingReceiver<Screen2xMainContentExtractor> p_main_content_extractor{};
      MainContentExtractionService_BindMainContentExtractor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_main_content_extractor =
            input_data_view.TakeMainContentExtractor<decltype(p_main_content_extractor)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MainContentExtractionService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindMainContentExtractor(        
        std::move(p_main_content_extractor));
      return true;
    }
  }
  return false;
}

// static
bool MainContentExtractionServiceStubDispatch::AcceptWithResponder(
    MainContentExtractionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MainContentExtractionService>(message->header()->name)) {
    case messages::MainContentExtractionService::kBindMainContentExtractor: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMainContentExtractionServiceValidationInfo[] = {
    { &internal::MainContentExtractionService_BindMainContentExtractor_Params_Data::Validate,
     nullptr /* no response */},
};

bool MainContentExtractionServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::screen_ai::mojom::MainContentExtractionService::Name_,
    kMainContentExtractionServiceValidationInfo);
}



}  // screen_ai::mojom


namespace mojo {


// static
bool StructTraits<::screen_ai::mojom::VisualAnnotation::DataView, ::screen_ai::mojom::VisualAnnotationPtr>::Read(
    ::screen_ai::mojom::VisualAnnotation::DataView input,
    ::screen_ai::mojom::VisualAnnotationPtr* output) {
  bool success = true;
  ::screen_ai::mojom::VisualAnnotationPtr result(::screen_ai::mojom::VisualAnnotation::New());
  
      if (success && !input.ReadLines(&result->lines))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::screen_ai::mojom::LineBox::DataView, ::screen_ai::mojom::LineBoxPtr>::Read(
    ::screen_ai::mojom::LineBox::DataView input,
    ::screen_ai::mojom::LineBoxPtr* output) {
  bool success = true;
  ::screen_ai::mojom::LineBoxPtr result(::screen_ai::mojom::LineBox::New());
  
      if (success && !input.ReadWords(&result->words))
        success = false;
      if (success && !input.ReadTextLine(&result->text_line))
        success = false;
      if (success && !input.ReadLanguage(&result->language))
        success = false;
      if (success)
        result->block_id = input.block_id();
      if (success)
        result->paragraph_id = input.paragraph_id();
      if (success && !input.ReadBoundingBox(&result->bounding_box))
        success = false;
      if (success)
        result->bounding_box_angle = input.bounding_box_angle();
      if (success)
        result->confidence = input.confidence();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::screen_ai::mojom::WordBox::DataView, ::screen_ai::mojom::WordBoxPtr>::Read(
    ::screen_ai::mojom::WordBox::DataView input,
    ::screen_ai::mojom::WordBoxPtr* output) {
  bool success = true;
  ::screen_ai::mojom::WordBoxPtr result(::screen_ai::mojom::WordBox::New());
  
      if (success && !input.ReadWord(&result->word))
        success = false;
      if (success && !input.ReadLanguage(&result->language))
        success = false;
      if (success && !input.ReadBoundingBox(&result->bounding_box))
        success = false;
      if (success)
        result->bounding_box_angle = input.bounding_box_angle();
      if (success && !input.ReadDirection(&result->direction))
        success = false;
      if (success && !input.ReadWhitespaceBoundingBox(&result->whitespace_bounding_box))
        success = false;
      if (success)
        result->whitespace_bounding_box_angle = input.whitespace_bounding_box_angle();
      if (success)
        result->confidence = input.confidence();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace screen_ai::mojom {


void ScreenAIAnnotatorInterceptorForTesting::PerformOcrAndReturnAnnotation(const ::SkBitmap& image, PerformOcrAndReturnAnnotationCallback callback) {
  GetForwardingInterface()->PerformOcrAndReturnAnnotation(
    std::move(image)
    , std::move(callback));
}
void ScreenAIAnnotatorInterceptorForTesting::SetClientType(OcrClientType client_type) {
  GetForwardingInterface()->SetClientType(
    std::move(client_type)
    );
}
void ScreenAIAnnotatorInterceptorForTesting::GetMaxImageDimension(GetMaxImageDimensionCallback callback) {
  GetForwardingInterface()->GetMaxImageDimension(std::move(callback));
}
void ScreenAIAnnotatorInterceptorForTesting::SetOCRLightMode(bool enabled) {
  GetForwardingInterface()->SetOCRLightMode(
    std::move(enabled)
    );
}
void ScreenAIAnnotatorInterceptorForTesting::IsOCRBusy(IsOCRBusyCallback callback) {
  GetForwardingInterface()->IsOCRBusy(std::move(callback));
}
ScreenAIAnnotatorAsyncWaiter::ScreenAIAnnotatorAsyncWaiter(
    ScreenAIAnnotator* proxy) : proxy_(proxy) {}

ScreenAIAnnotatorAsyncWaiter::~ScreenAIAnnotatorAsyncWaiter() = default;


void ScreenAIAnnotatorAsyncWaiter::PerformOcrAndReturnAnnotation(
    const ::SkBitmap& image, VisualAnnotationPtr* out_visual_annotation) {
  base::RunLoop loop;
  proxy_->PerformOcrAndReturnAnnotation(
      std::move(image),
      base::BindOnce(
          [](base::RunLoop* loop,
             VisualAnnotationPtr* out_visual_annotation
,
             VisualAnnotationPtr visual_annotation) {*out_visual_annotation = std::move(visual_annotation);
            loop->Quit();
          },
          &loop,
          out_visual_annotation));
  loop.Run();
}

VisualAnnotationPtr ScreenAIAnnotatorAsyncWaiter::PerformOcrAndReturnAnnotation(
    const ::SkBitmap& image) {
  VisualAnnotationPtr async_wait_result;
  PerformOcrAndReturnAnnotation(std::move(image),&async_wait_result);
  return async_wait_result;
}

void ScreenAIAnnotatorAsyncWaiter::GetMaxImageDimension(
    uint32_t* out_max_dimension) {
  base::RunLoop loop;
  proxy_->GetMaxImageDimension(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_max_dimension
,
             uint32_t max_dimension) {*out_max_dimension = std::move(max_dimension);
            loop->Quit();
          },
          &loop,
          out_max_dimension));
  loop.Run();
}

uint32_t ScreenAIAnnotatorAsyncWaiter::GetMaxImageDimension(
    ) {
  uint32_t async_wait_result;
  GetMaxImageDimension(&async_wait_result);
  return async_wait_result;
}

void ScreenAIAnnotatorAsyncWaiter::IsOCRBusy(
    bool* out_busy) {
  base::RunLoop loop;
  proxy_->IsOCRBusy(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_busy
,
             bool busy) {*out_busy = std::move(busy);
            loop->Quit();
          },
          &loop,
          out_busy));
  loop.Run();
}

bool ScreenAIAnnotatorAsyncWaiter::IsOCRBusy(
    ) {
  bool async_wait_result;
  IsOCRBusy(&async_wait_result);
  return async_wait_result;
}




void Screen2xMainContentExtractorInterceptorForTesting::ExtractMainContent(const ::ui::AXTreeUpdate& snapshot, ExtractMainContentCallback callback) {
  GetForwardingInterface()->ExtractMainContent(
    std::move(snapshot)
    , std::move(callback));
}
void Screen2xMainContentExtractorInterceptorForTesting::ExtractMainNode(const ::ui::AXTreeUpdate& snapshot, ExtractMainNodeCallback callback) {
  GetForwardingInterface()->ExtractMainNode(
    std::move(snapshot)
    , std::move(callback));
}
void Screen2xMainContentExtractorInterceptorForTesting::IdentifyMainNode(const ::ui::AXTreeUpdate& ax_tree, IdentifyMainNodeCallback callback) {
  GetForwardingInterface()->IdentifyMainNode(
    std::move(ax_tree)
    , std::move(callback));
}
void Screen2xMainContentExtractorInterceptorForTesting::SetClientType(MceClientType client_type) {
  GetForwardingInterface()->SetClientType(
    std::move(client_type)
    );
}
Screen2xMainContentExtractorAsyncWaiter::Screen2xMainContentExtractorAsyncWaiter(
    Screen2xMainContentExtractor* proxy) : proxy_(proxy) {}

Screen2xMainContentExtractorAsyncWaiter::~Screen2xMainContentExtractorAsyncWaiter() = default;


void Screen2xMainContentExtractorAsyncWaiter::ExtractMainContent(
    const ::ui::AXTreeUpdate& snapshot, std::vector<int32_t>* out_content_node_ids) {
  base::RunLoop loop;
  proxy_->ExtractMainContent(
      std::move(snapshot),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<int32_t>* out_content_node_ids
,
             const std::vector<int32_t>& content_node_ids) {*out_content_node_ids = std::move(content_node_ids);
            loop->Quit();
          },
          &loop,
          out_content_node_ids));
  loop.Run();
}

std::vector<int32_t> Screen2xMainContentExtractorAsyncWaiter::ExtractMainContent(
    const ::ui::AXTreeUpdate& snapshot) {
  std::vector<int32_t> async_wait_result;
  ExtractMainContent(std::move(snapshot),&async_wait_result);
  return async_wait_result;
}

void Screen2xMainContentExtractorAsyncWaiter::ExtractMainNode(
    const ::ui::AXTreeUpdate& snapshot, int32_t* out_main_node_id) {
  base::RunLoop loop;
  proxy_->ExtractMainNode(
      std::move(snapshot),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_main_node_id
,
             int32_t main_node_id) {*out_main_node_id = std::move(main_node_id);
            loop->Quit();
          },
          &loop,
          out_main_node_id));
  loop.Run();
}

int32_t Screen2xMainContentExtractorAsyncWaiter::ExtractMainNode(
    const ::ui::AXTreeUpdate& snapshot) {
  int32_t async_wait_result;
  ExtractMainNode(std::move(snapshot),&async_wait_result);
  return async_wait_result;
}

void Screen2xMainContentExtractorAsyncWaiter::IdentifyMainNode(
    const ::ui::AXTreeUpdate& ax_tree, ::ui::AXTreeID* out_tree_id, int32_t* out_node_id) {
  base::RunLoop loop;
  proxy_->IdentifyMainNode(
      std::move(ax_tree),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::ui::AXTreeID* out_tree_id
,
             int32_t* out_node_id
,
             const ::ui::AXTreeID& tree_id,
             int32_t node_id) {*out_tree_id = std::move(tree_id);*out_node_id = std::move(node_id);
            loop->Quit();
          },
          &loop,
          out_tree_id,
          out_node_id));
  loop.Run();
}






void OCRServiceInterceptorForTesting::BindAnnotator(::mojo::PendingReceiver<ScreenAIAnnotator> annotator) {
  GetForwardingInterface()->BindAnnotator(
    std::move(annotator)
    );
}
OCRServiceAsyncWaiter::OCRServiceAsyncWaiter(
    OCRService* proxy) : proxy_(proxy) {}

OCRServiceAsyncWaiter::~OCRServiceAsyncWaiter() = default;





void MainContentExtractionServiceInterceptorForTesting::BindMainContentExtractor(::mojo::PendingReceiver<Screen2xMainContentExtractor> main_content_extractor) {
  GetForwardingInterface()->BindMainContentExtractor(
    std::move(main_content_extractor)
    );
}
MainContentExtractionServiceAsyncWaiter::MainContentExtractionServiceAsyncWaiter(
    MainContentExtractionService* proxy) : proxy_(proxy) {}

MainContentExtractionServiceAsyncWaiter::~MainContentExtractionServiceAsyncWaiter() = default;







}  // screen_ai::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif