// services/screen_ai/public/mojom/screen_ai_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_SHARED_H_
#define SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/screen_ai/public/mojom/screen_ai_service.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/accessibility/ax_features.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/screen_ai/public/mojom/screen_ai_service.mojom-data-view.h"




namespace std {

template <>
struct hash<::screen_ai::mojom::Direction>
    : public mojo::internal::EnumHashImpl<::screen_ai::mojom::Direction> {};

template <>
struct hash<::screen_ai::mojom::OcrClientType>
    : public mojo::internal::EnumHashImpl<::screen_ai::mojom::OcrClientType> {};

template <>
struct hash<::screen_ai::mojom::MceClientType>
    : public mojo::internal::EnumHashImpl<::screen_ai::mojom::MceClientType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::screen_ai::mojom::Direction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::screen_ai::mojom::Direction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::screen_ai::mojom::Direction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::screen_ai::mojom::OcrClientType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::screen_ai::mojom::OcrClientType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::screen_ai::mojom::OcrClientType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::screen_ai::mojom::MceClientType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::screen_ai::mojom::MceClientType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::screen_ai::mojom::MceClientType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::screen_ai::mojom::VisualAnnotationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::screen_ai::mojom::VisualAnnotationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::screen_ai::mojom::internal::VisualAnnotation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::lines(input)) in_lines = Traits::lines(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lines)::BaseType>
        lines_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& lines_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::screen_ai::mojom::LineBoxDataView>>(
      in_lines,
      lines_fragment,
      &lines_validate_params);

    fragment->lines.Set(
        lines_fragment.is_null() ? nullptr : lines_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->lines.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null lines in VisualAnnotation struct");
  }

  static bool Deserialize(::screen_ai::mojom::internal::VisualAnnotation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::screen_ai::mojom::VisualAnnotationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::screen_ai::mojom::LineBoxDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::screen_ai::mojom::LineBoxDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::screen_ai::mojom::internal::LineBox_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::words(input)) in_words = Traits::words(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->words)::BaseType>
        words_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& words_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::screen_ai::mojom::WordBoxDataView>>(
      in_words,
      words_fragment,
      &words_validate_params);

    fragment->words.Set(
        words_fragment.is_null() ? nullptr : words_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->words.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null words in LineBox struct");

    decltype(Traits::text_line(input)) in_text_line = Traits::text_line(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_line)::BaseType> text_line_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text_line,
      text_line_fragment);

    fragment->text_line.Set(
        text_line_fragment.is_null() ? nullptr : text_line_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text_line.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_line in LineBox struct");

    decltype(Traits::language(input)) in_language = Traits::language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language)::BaseType> language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_language,
      language_fragment);

    fragment->language.Set(
        language_fragment.is_null() ? nullptr : language_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->language.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null language in LineBox struct");

    fragment->block_id = Traits::block_id(input);

    fragment->paragraph_id = Traits::paragraph_id(input);

    decltype(Traits::bounding_box(input)) in_bounding_box = Traits::bounding_box(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounding_box)::BaseType> bounding_box_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounding_box,
      bounding_box_fragment);

    fragment->bounding_box.Set(
        bounding_box_fragment.is_null() ? nullptr : bounding_box_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bounding_box.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounding_box in LineBox struct");

    fragment->bounding_box_angle = Traits::bounding_box_angle(input);

    fragment->confidence = Traits::confidence(input);
  }

  static bool Deserialize(::screen_ai::mojom::internal::LineBox_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::screen_ai::mojom::LineBoxDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::screen_ai::mojom::WordBoxDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::screen_ai::mojom::WordBoxDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::screen_ai::mojom::internal::WordBox_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::word(input)) in_word = Traits::word(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->word)::BaseType> word_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_word,
      word_fragment);

    fragment->word.Set(
        word_fragment.is_null() ? nullptr : word_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->word.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null word in WordBox struct");

    decltype(Traits::language(input)) in_language = Traits::language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language)::BaseType> language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_language,
      language_fragment);

    fragment->language.Set(
        language_fragment.is_null() ? nullptr : language_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->language.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null language in WordBox struct");

    decltype(Traits::bounding_box(input)) in_bounding_box = Traits::bounding_box(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounding_box)::BaseType> bounding_box_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounding_box,
      bounding_box_fragment);

    fragment->bounding_box.Set(
        bounding_box_fragment.is_null() ? nullptr : bounding_box_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bounding_box.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounding_box in WordBox struct");

    fragment->bounding_box_angle = Traits::bounding_box_angle(input);

    
    mojo::internal::Serialize<::screen_ai::mojom::Direction>(
      Traits::direction(input),
      &fragment->direction);

    decltype(Traits::whitespace_bounding_box(input)) in_whitespace_bounding_box = Traits::whitespace_bounding_box(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->whitespace_bounding_box)::BaseType> whitespace_bounding_box_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_whitespace_bounding_box,
      whitespace_bounding_box_fragment);

    fragment->whitespace_bounding_box.Set(
        whitespace_bounding_box_fragment.is_null() ? nullptr : whitespace_bounding_box_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->whitespace_bounding_box.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null whitespace_bounding_box in WordBox struct");

    fragment->whitespace_bounding_box_angle = Traits::whitespace_bounding_box_angle(input);

    fragment->confidence = Traits::confidence(input);
  }

  static bool Deserialize(::screen_ai::mojom::internal::WordBox_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::screen_ai::mojom::WordBoxDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace screen_ai::mojom {

inline void VisualAnnotationDataView::GetLinesDataView(
    mojo::ArrayDataView<LineBoxDataView>* output) {
  auto pointer = data_->lines.Get();
  *output = mojo::ArrayDataView<LineBoxDataView>(pointer, message_);
}


inline void LineBoxDataView::GetWordsDataView(
    mojo::ArrayDataView<WordBoxDataView>* output) {
  auto pointer = data_->words.Get();
  *output = mojo::ArrayDataView<WordBoxDataView>(pointer, message_);
}
inline void LineBoxDataView::GetTextLineDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_line.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LineBoxDataView::GetLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->language.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LineBoxDataView::GetBoundingBoxDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->bounding_box.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}


inline void WordBoxDataView::GetWordDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->word.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WordBoxDataView::GetLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->language.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WordBoxDataView::GetBoundingBoxDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->bounding_box.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void WordBoxDataView::GetWhitespaceBoundingBoxDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->whitespace_bounding_box.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}



}  // screen_ai::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::screen_ai::mojom::Direction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::screen_ai::mojom::Direction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::screen_ai::mojom::OcrClientType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::screen_ai::mojom::OcrClientType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::screen_ai::mojom::MceClientType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::screen_ai::mojom::MceClientType value);
};

} // namespace perfetto

#endif  // SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_SHARED_H_