// services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_MEMORY_INSTRUMENTATION_MEMORY_INSTRUMENTATION_MOJOM_TEST_UTILS_H_
#define SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_MEMORY_INSTRUMENTATION_MEMORY_INSTRUMENTATION_MOJOM_TEST_UTILS_H_

#include "services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom.h"
#include "base/component_export.h"


namespace memory_instrumentation::mojom {


class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) ClientProcessInterceptorForTesting : public ClientProcess {
  virtual ClientProcess* GetForwardingInterface() = 0;
  void RequestChromeMemoryDump(const ::base::trace_event::MemoryDumpRequestArgs& args, RequestChromeMemoryDumpCallback callback) override;
  void RequestOSMemoryDump(MemoryMapOption option, const std::vector<MemDumpFlags>& flags, const std::vector<::base::ProcessId>& pids, RequestOSMemoryDumpCallback callback) override;
};
class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) ClientProcessAsyncWaiter {
 public:
  explicit ClientProcessAsyncWaiter(ClientProcess* proxy);

  ClientProcessAsyncWaiter(const ClientProcessAsyncWaiter&) = delete;
  ClientProcessAsyncWaiter& operator=(const ClientProcessAsyncWaiter&) = delete;

  ~ClientProcessAsyncWaiter();
  void RequestChromeMemoryDump(
      const ::base::trace_event::MemoryDumpRequestArgs& args, bool* out_success, uint64_t* out_dump_id, ::std::unique_ptr<::base::trace_event::ProcessMemoryDump>* out_raw_process_memory_dump);
  
  void RequestOSMemoryDump(
      MemoryMapOption option, const std::vector<MemDumpFlags>& flags, const std::vector<::base::ProcessId>& pids, bool* out_success, base::flat_map<::base::ProcessId, RawOSMemDumpPtr>* out_dumps);
  

 private:
  ClientProcess* const proxy_;
};


class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) HeapProfilerInterceptorForTesting : public HeapProfiler {
  virtual HeapProfiler* GetForwardingInterface() = 0;
  void DumpProcessesForTracing(bool strip_path_from_mapped_files, bool write_proto, DumpProcessesForTracingCallback callback) override;
};
class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) HeapProfilerAsyncWaiter {
 public:
  explicit HeapProfilerAsyncWaiter(HeapProfiler* proxy);

  HeapProfilerAsyncWaiter(const HeapProfilerAsyncWaiter&) = delete;
  HeapProfilerAsyncWaiter& operator=(const HeapProfilerAsyncWaiter&) = delete;

  ~HeapProfilerAsyncWaiter();
  void DumpProcessesForTracing(
      bool strip_path_from_mapped_files, bool write_proto, std::vector<HeapProfileResultPtr>* out_results);
  std::vector<HeapProfileResultPtr> DumpProcessesForTracing(bool strip_path_from_mapped_files, bool write_proto);

 private:
  HeapProfiler* const proxy_;
};


class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) HeapProfilerHelperInterceptorForTesting : public HeapProfilerHelper {
  virtual HeapProfilerHelper* GetForwardingInterface() = 0;
  void GetVmRegionsForHeapProfiler(const std::vector<::base::ProcessId>& pids, GetVmRegionsForHeapProfilerCallback callback) override;
};
class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) HeapProfilerHelperAsyncWaiter {
 public:
  explicit HeapProfilerHelperAsyncWaiter(HeapProfilerHelper* proxy);

  HeapProfilerHelperAsyncWaiter(const HeapProfilerHelperAsyncWaiter&) = delete;
  HeapProfilerHelperAsyncWaiter& operator=(const HeapProfilerHelperAsyncWaiter&) = delete;

  ~HeapProfilerHelperAsyncWaiter();
  void GetVmRegionsForHeapProfiler(
      const std::vector<::base::ProcessId>& pids, base::flat_map<::base::ProcessId, std::vector<VmRegionPtr>>* out_vm_regions);
  base::flat_map<::base::ProcessId, std::vector<VmRegionPtr>> GetVmRegionsForHeapProfiler(const std::vector<::base::ProcessId>& pids);

 private:
  HeapProfilerHelper* const proxy_;
};


class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) CoordinatorInterceptorForTesting : public Coordinator {
  virtual Coordinator* GetForwardingInterface() = 0;
  void RequestGlobalMemoryDump(::base::trace_event::MemoryDumpType dump_type, ::base::trace_event::MemoryDumpLevelOfDetail level_of_detail, ::base::trace_event::MemoryDumpDeterminism determinism, const std::vector<std::string>& allocator_dump_names, RequestGlobalMemoryDumpCallback callback) override;
  void RequestGlobalMemoryDumpForPid(::base::ProcessId pid, const std::vector<std::string>& allocator_dump_names, RequestGlobalMemoryDumpForPidCallback callback) override;
  void RequestPrivateMemoryFootprint(::base::ProcessId pid, RequestPrivateMemoryFootprintCallback callback) override;
  void RequestGlobalMemoryDumpAndAppendToTrace(::base::trace_event::MemoryDumpType dump_type, ::base::trace_event::MemoryDumpLevelOfDetail level_of_detail, ::base::trace_event::MemoryDumpDeterminism determinism, RequestGlobalMemoryDumpAndAppendToTraceCallback callback) override;
};
class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) CoordinatorAsyncWaiter {
 public:
  explicit CoordinatorAsyncWaiter(Coordinator* proxy);

  CoordinatorAsyncWaiter(const CoordinatorAsyncWaiter&) = delete;
  CoordinatorAsyncWaiter& operator=(const CoordinatorAsyncWaiter&) = delete;

  ~CoordinatorAsyncWaiter();
  void RequestGlobalMemoryDump(
      ::base::trace_event::MemoryDumpType dump_type, ::base::trace_event::MemoryDumpLevelOfDetail level_of_detail, ::base::trace_event::MemoryDumpDeterminism determinism, const std::vector<std::string>& allocator_dump_names, bool* out_success, GlobalMemoryDumpPtr* out_global_memory_dump);
  
  void RequestGlobalMemoryDumpForPid(
      ::base::ProcessId pid, const std::vector<std::string>& allocator_dump_names, bool* out_success, GlobalMemoryDumpPtr* out_global_memory_dump);
  
  void RequestPrivateMemoryFootprint(
      ::base::ProcessId pid, bool* out_success, GlobalMemoryDumpPtr* out_global_memory_dump);
  
  void RequestGlobalMemoryDumpAndAppendToTrace(
      ::base::trace_event::MemoryDumpType dump_type, ::base::trace_event::MemoryDumpLevelOfDetail level_of_detail, ::base::trace_event::MemoryDumpDeterminism determinism, bool* out_success, uint64_t* out_dump_id);
  

 private:
  Coordinator* const proxy_;
};


class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) CoordinatorConnectorInterceptorForTesting : public CoordinatorConnector {
  virtual CoordinatorConnector* GetForwardingInterface() = 0;
  void RegisterCoordinatorClient(::mojo::PendingReceiver<Coordinator> receiver, ::mojo::PendingRemote<ClientProcess> client_process) override;
};
class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) CoordinatorConnectorAsyncWaiter {
 public:
  explicit CoordinatorConnectorAsyncWaiter(CoordinatorConnector* proxy);

  CoordinatorConnectorAsyncWaiter(const CoordinatorConnectorAsyncWaiter&) = delete;
  CoordinatorConnectorAsyncWaiter& operator=(const CoordinatorConnectorAsyncWaiter&) = delete;

  ~CoordinatorConnectorAsyncWaiter();

 private:
  CoordinatorConnector* const proxy_;
};




}  // memory_instrumentation::mojom

#endif  // SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_MEMORY_INSTRUMENTATION_MEMORY_INSTRUMENTATION_MOJOM_TEST_UTILS_H_