// services/preferences/public/mojom/preferences.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/preferences/public/mojom/preferences.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/preferences/public/mojom/preferences.mojom-params-data.h"
#include "services/preferences/public/mojom/preferences.mojom-shared-message-ids.h"

#include "services/preferences/public/mojom/preferences.mojom-import-headers.h"
#include "services/preferences/public/mojom/preferences.mojom-test-utils.h"


namespace prefs::mojom {
TrackedPersistentPrefStoreConfiguration::TrackedPersistentPrefStoreConfiguration()
    : unprotected_pref_filename(),
      protected_pref_filename(),
      tracking_configuration(),
      reporting_ids_count(),
      seed(),
      registry_seed(),
      registry_path(),
      validation_delegate(),
      reset_on_load_observer() {}

TrackedPersistentPrefStoreConfiguration::TrackedPersistentPrefStoreConfiguration(
    const ::base::FilePath& unprotected_pref_filename_in,
    const ::base::FilePath& protected_pref_filename_in,
    std::vector<TrackedPreferenceMetadataPtr> tracking_configuration_in,
    uint64_t reporting_ids_count_in,
    const std::string& seed_in,
    const std::string& registry_seed_in,
    const ::std::u16string& registry_path_in,
    ::mojo::PendingRemote<::prefs::mojom::TrackedPreferenceValidationDelegate> validation_delegate_in,
    ::mojo::PendingRemote<ResetOnLoadObserver> reset_on_load_observer_in)
    : unprotected_pref_filename(std::move(unprotected_pref_filename_in)),
      protected_pref_filename(std::move(protected_pref_filename_in)),
      tracking_configuration(std::move(tracking_configuration_in)),
      reporting_ids_count(std::move(reporting_ids_count_in)),
      seed(std::move(seed_in)),
      registry_seed(std::move(registry_seed_in)),
      registry_path(std::move(registry_path_in)),
      validation_delegate(std::move(validation_delegate_in)),
      reset_on_load_observer(std::move(reset_on_load_observer_in)) {}

TrackedPersistentPrefStoreConfiguration::~TrackedPersistentPrefStoreConfiguration() = default;

void TrackedPersistentPrefStoreConfiguration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unprotected_pref_filename"), this->unprotected_pref_filename,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protected_pref_filename"), this->protected_pref_filename,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tracking_configuration"), this->tracking_configuration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TrackedPreferenceMetadataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_ids_count"), this->reporting_ids_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seed"), this->seed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registry_seed"), this->registry_seed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registry_path"), this->registry_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "validation_delegate"), this->validation_delegate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::prefs::mojom::TrackedPreferenceValidationDelegate>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reset_on_load_observer"), this->reset_on_load_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<ResetOnLoadObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrackedPersistentPrefStoreConfiguration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrackedPreferenceMetadata::TrackedPreferenceMetadata()
    : reporting_id(),
      name(),
      enforcement_level(),
      strategy(),
      value_type() {}

TrackedPreferenceMetadata::TrackedPreferenceMetadata(
    uint64_t reporting_id_in,
    const std::string& name_in,
    TrackedPreferenceMetadata::EnforcementLevel enforcement_level_in,
    TrackedPreferenceMetadata::PrefTrackingStrategy strategy_in,
    TrackedPreferenceMetadata::ValueType value_type_in)
    : reporting_id(std::move(reporting_id_in)),
      name(std::move(name_in)),
      enforcement_level(std::move(enforcement_level_in)),
      strategy(std::move(strategy_in)),
      value_type(std::move(value_type_in)) {}

TrackedPreferenceMetadata::~TrackedPreferenceMetadata() = default;
size_t TrackedPreferenceMetadata::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->reporting_id);
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->enforcement_level);
  seed = mojo::internal::Hash(seed, this->strategy);
  seed = mojo::internal::Hash(seed, this->value_type);
  return seed;
}

void TrackedPreferenceMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_id"), this->reporting_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enforcement_level"), this->enforcement_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrackedPreferenceMetadata::EnforcementLevel>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strategy"), this->strategy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrackedPreferenceMetadata::PrefTrackingStrategy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value_type"), this->value_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrackedPreferenceMetadata::ValueType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrackedPreferenceMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ResetOnLoadObserver::IPCStableHashFunction ResetOnLoadObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ResetOnLoadObserver>(message.name())) {
    case messages::ResetOnLoadObserver::kOnResetOnLoad: {
      return &ResetOnLoadObserver::OnResetOnLoad_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ResetOnLoadObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ResetOnLoadObserver>(message.name())) {
      case messages::ResetOnLoadObserver::kOnResetOnLoad:
            return "Receive prefs::mojom::ResetOnLoadObserver::OnResetOnLoad";
    }
  } else {
    switch (static_cast<messages::ResetOnLoadObserver>(message.name())) {
      case messages::ResetOnLoadObserver::kOnResetOnLoad:
            return "Receive reply prefs::mojom::ResetOnLoadObserver::OnResetOnLoad";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ResetOnLoadObserver::OnResetOnLoad_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1526918c;  // IPCStableHash for prefs::mojom::ResetOnLoadObserver::OnResetOnLoad
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ResetOnLoadObserverProxy::ResetOnLoadObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResetOnLoadObserverProxy::OnResetOnLoad(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send prefs::mojom::ResetOnLoadObserver::OnResetOnLoad");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResetOnLoadObserver::kOnResetOnLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::prefs::mojom::internal::ResetOnLoadObserver_OnResetOnLoad_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResetOnLoadObserver::Name_);
  message.set_method_name("OnResetOnLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ResetOnLoadObserverStubDispatch::Accept(
    ResetOnLoadObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ResetOnLoadObserver>(message->header()->name)) {
    case messages::ResetOnLoadObserver::kOnResetOnLoad: {
      DCHECK(message->is_serialized());
      internal::ResetOnLoadObserver_OnResetOnLoad_Params_Data* params =
          reinterpret_cast<internal::ResetOnLoadObserver_OnResetOnLoad_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ResetOnLoadObserver.0
      bool success = true;
      ResetOnLoadObserver_OnResetOnLoad_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResetOnLoadObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResetOnLoad(        );
      return true;
    }
  }
  return false;
}

// static
bool ResetOnLoadObserverStubDispatch::AcceptWithResponder(
    ResetOnLoadObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ResetOnLoadObserver>(message->header()->name)) {
    case messages::ResetOnLoadObserver::kOnResetOnLoad: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kResetOnLoadObserverValidationInfo[] = {
    { &internal::ResetOnLoadObserver_OnResetOnLoad_Params_Data::Validate,
     nullptr /* no response */},
};

bool ResetOnLoadObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::prefs::mojom::ResetOnLoadObserver::Name_,
    kResetOnLoadObserverValidationInfo);
}



}  // prefs::mojom


namespace mojo {


// static
bool StructTraits<::prefs::mojom::TrackedPersistentPrefStoreConfiguration::DataView, ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr>::Read(
    ::prefs::mojom::TrackedPersistentPrefStoreConfiguration::DataView input,
    ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr* output) {
  bool success = true;
  ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr result(::prefs::mojom::TrackedPersistentPrefStoreConfiguration::New());
  
      if (success && !input.ReadUnprotectedPrefFilename(&result->unprotected_pref_filename))
        success = false;
      if (success && !input.ReadProtectedPrefFilename(&result->protected_pref_filename))
        success = false;
      if (success && !input.ReadTrackingConfiguration(&result->tracking_configuration))
        success = false;
      if (success)
        result->reporting_ids_count = input.reporting_ids_count();
      if (success && !input.ReadSeed(&result->seed))
        success = false;
      if (success && !input.ReadRegistrySeed(&result->registry_seed))
        success = false;
      if (success && !input.ReadRegistryPath(&result->registry_path))
        success = false;
      if (success) {
        result->validation_delegate =
            input.TakeValidationDelegate<decltype(result->validation_delegate)>();
      }
      if (success) {
        result->reset_on_load_observer =
            input.TakeResetOnLoadObserver<decltype(result->reset_on_load_observer)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::prefs::mojom::TrackedPreferenceMetadata::DataView, ::prefs::mojom::TrackedPreferenceMetadataPtr>::Read(
    ::prefs::mojom::TrackedPreferenceMetadata::DataView input,
    ::prefs::mojom::TrackedPreferenceMetadataPtr* output) {
  bool success = true;
  ::prefs::mojom::TrackedPreferenceMetadataPtr result(::prefs::mojom::TrackedPreferenceMetadata::New());
  
      if (success)
        result->reporting_id = input.reporting_id();
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadEnforcementLevel(&result->enforcement_level))
        success = false;
      if (success && !input.ReadStrategy(&result->strategy))
        success = false;
      if (success && !input.ReadValueType(&result->value_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace prefs::mojom {


void ResetOnLoadObserverInterceptorForTesting::OnResetOnLoad() {
  GetForwardingInterface()->OnResetOnLoad();
}
ResetOnLoadObserverAsyncWaiter::ResetOnLoadObserverAsyncWaiter(
    ResetOnLoadObserver* proxy) : proxy_(proxy) {}

ResetOnLoadObserverAsyncWaiter::~ResetOnLoadObserverAsyncWaiter() = default;







}  // prefs::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif