// services/preferences/public/mojom/preferences.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_PREFERENCES_PUBLIC_MOJOM_PREFERENCES_MOJOM_DATA_VIEW_H_
#define SERVICES_PREFERENCES_PUBLIC_MOJOM_PREFERENCES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/preferences/public/mojom/preferences.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "services/preferences/public/mojom/tracked_preference_validation_delegate.mojom-shared.h"


namespace prefs::mojom {
class TrackedPersistentPrefStoreConfigurationDataView;

class TrackedPreferenceMetadataDataView;



}  // prefs::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::prefs::mojom::TrackedPersistentPrefStoreConfigurationDataView> {
  using Data = ::prefs::mojom::internal::TrackedPersistentPrefStoreConfiguration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::prefs::mojom::TrackedPreferenceMetadataDataView> {
  using Data = ::prefs::mojom::internal::TrackedPreferenceMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace prefs::mojom {


enum class TrackedPreferenceMetadata_EnforcementLevel : int32_t {
  
  NO_ENFORCEMENT = 0,
  
  ENFORCE_ON_LOAD = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, TrackedPreferenceMetadata_EnforcementLevel value);
inline bool IsKnownEnumValue(TrackedPreferenceMetadata_EnforcementLevel value) {
  return internal::TrackedPreferenceMetadata_EnforcementLevel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrackedPreferenceMetadata_PrefTrackingStrategy : int32_t {
  
  ATOMIC = 0,
  
  SPLIT = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, TrackedPreferenceMetadata_PrefTrackingStrategy value);
inline bool IsKnownEnumValue(TrackedPreferenceMetadata_PrefTrackingStrategy value) {
  return internal::TrackedPreferenceMetadata_PrefTrackingStrategy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrackedPreferenceMetadata_ValueType : int32_t {
  
  IMPERSONAL = 0,
  
  PERSONAL = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, TrackedPreferenceMetadata_ValueType value);
inline bool IsKnownEnumValue(TrackedPreferenceMetadata_ValueType value) {
  return internal::TrackedPreferenceMetadata_ValueType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ResetOnLoadObserverInterfaceBase {};

using ResetOnLoadObserverPtrDataView =
    mojo::InterfacePtrDataView<ResetOnLoadObserverInterfaceBase>;
using ResetOnLoadObserverRequestDataView =
    mojo::InterfaceRequestDataView<ResetOnLoadObserverInterfaceBase>;
using ResetOnLoadObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ResetOnLoadObserverInterfaceBase>;
using ResetOnLoadObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ResetOnLoadObserverInterfaceBase>;


class TrackedPersistentPrefStoreConfigurationDataView {
 public:
  TrackedPersistentPrefStoreConfigurationDataView() = default;

  TrackedPersistentPrefStoreConfigurationDataView(
      internal::TrackedPersistentPrefStoreConfiguration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUnprotectedPrefFilenameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnprotectedPrefFilename(UserType* output) {
    
    auto* pointer = data_->unprotected_pref_filename.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetProtectedPrefFilenameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtectedPrefFilename(UserType* output) {
    
    auto* pointer = data_->protected_pref_filename.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetTrackingConfigurationDataView(
      mojo::ArrayDataView<TrackedPreferenceMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackingConfiguration(UserType* output) {
    
    auto* pointer = data_->tracking_configuration.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::prefs::mojom::TrackedPreferenceMetadataDataView>>(
        pointer, output, message_);
  }
  uint64_t reporting_ids_count() const {
    return data_->reporting_ids_count;
  }
  inline void GetSeedDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeed(UserType* output) {
    
    auto* pointer = data_->seed.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRegistrySeedDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistrySeed(UserType* output) {
    
    auto* pointer = data_->registry_seed.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRegistryPathDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistryPath(UserType* output) {
    
    auto* pointer = data_->registry_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeValidationDelegate() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::prefs::mojom::TrackedPreferenceValidationDelegateInterfaceBase>>(
            &data_->validation_delegate, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeResetOnLoadObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::prefs::mojom::ResetOnLoadObserverInterfaceBase>>(
            &data_->reset_on_load_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::TrackedPersistentPrefStoreConfiguration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrackedPreferenceMetadataDataView {
 public:
  TrackedPreferenceMetadataDataView() = default;

  TrackedPreferenceMetadataDataView(
      internal::TrackedPreferenceMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t reporting_id() const {
    return data_->reporting_id;
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEnforcementLevel(UserType* output) const {
    auto data_value = data_->enforcement_level;
    return mojo::internal::Deserialize<::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel>(
        data_value, output);
  }
  TrackedPreferenceMetadata_EnforcementLevel enforcement_level() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel>(data_->enforcement_level));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStrategy(UserType* output) const {
    auto data_value = data_->strategy;
    return mojo::internal::Deserialize<::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy>(
        data_value, output);
  }
  TrackedPreferenceMetadata_PrefTrackingStrategy strategy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy>(data_->strategy));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadValueType(UserType* output) const {
    auto data_value = data_->value_type;
    return mojo::internal::Deserialize<::prefs::mojom::TrackedPreferenceMetadata_ValueType>(
        data_value, output);
  }
  TrackedPreferenceMetadata_ValueType value_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::prefs::mojom::TrackedPreferenceMetadata_ValueType>(data_->value_type));
  }
 private:
  internal::TrackedPreferenceMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // prefs::mojom

#endif  // SERVICES_PREFERENCES_PUBLIC_MOJOM_PREFERENCES_MOJOM_DATA_VIEW_H_