// services/passage_embeddings/public/mojom/passage_embeddings.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_H_
#define SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-features.h"  // IWYU pragma: export
#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-shared.h"  // IWYU pragma: export
#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace passage_embeddings::mojom {

class PassageEmbedderProxy;

template <typename ImplRefTraits>
class PassageEmbedderStub;

class PassageEmbedderRequestValidator;
class PassageEmbedderResponseValidator;


class PassageEmbedder
    : public PassageEmbedderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "passage_embeddings.mojom.PassageEmbedder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kOnDeviceModelExecution;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PassageEmbedderInterfaceBase;
  using Proxy_ = PassageEmbedderProxy;

  template <typename ImplRefTraits>
  using Stub_ = PassageEmbedderStub<ImplRefTraits>;

  using RequestValidator_ = PassageEmbedderRequestValidator;
  using ResponseValidator_ = PassageEmbedderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGenerateEmbeddingsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GenerateEmbeddings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PassageEmbedder() = default;

  using GenerateEmbeddingsCallback = base::OnceCallback<void(std::vector<PassageEmbeddingsResultPtr>)>;
  using GenerateEmbeddingsMojoCallback = base::OnceCallback<void(std::vector<PassageEmbeddingsResultPtr>)>;

  virtual void GenerateEmbeddings(const std::vector<std::string>& passages, PassagePriority priority, GenerateEmbeddingsCallback callback) = 0;
};

class PassageEmbeddingsServiceProxy;

template <typename ImplRefTraits>
class PassageEmbeddingsServiceStub;

class PassageEmbeddingsServiceRequestValidator;
class PassageEmbeddingsServiceResponseValidator;


class PassageEmbeddingsService
    : public PassageEmbeddingsServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "passage_embeddings.mojom.PassageEmbeddingsService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kOnDeviceModelExecution;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PassageEmbeddingsServiceInterfaceBase;
  using Proxy_ = PassageEmbeddingsServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PassageEmbeddingsServiceStub<ImplRefTraits>;

  using RequestValidator_ = PassageEmbeddingsServiceRequestValidator;
  using ResponseValidator_ = PassageEmbeddingsServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kLoadModelsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct LoadModels_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PassageEmbeddingsService() = default;

  using LoadModelsCallback = base::OnceCallback<void(bool)>;
  using LoadModelsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void LoadModels(PassageEmbeddingsLoadModelsParamsPtr model_params, PassageEmbedderParamsPtr params, ::mojo::PendingReceiver<PassageEmbedder> model, LoadModelsCallback callback) = 0;
};



class  PassageEmbedderProxy
    : public PassageEmbedder {
 public:
  using InterfaceType = PassageEmbedder;

  explicit PassageEmbedderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GenerateEmbeddings(const std::vector<std::string>& passages, PassagePriority priority, GenerateEmbeddingsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PassageEmbeddingsServiceProxy
    : public PassageEmbeddingsService {
 public:
  using InterfaceType = PassageEmbeddingsService;

  explicit PassageEmbeddingsServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void LoadModels(PassageEmbeddingsLoadModelsParamsPtr model_params, PassageEmbedderParamsPtr params, ::mojo::PendingReceiver<PassageEmbedder> model, LoadModelsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PassageEmbedderStubDispatch {
 public:
  static bool Accept(PassageEmbedder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PassageEmbedder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PassageEmbedder>>
class PassageEmbedderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PassageEmbedderStub() = default;
  ~PassageEmbedderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PassageEmbedderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PassageEmbedderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PassageEmbeddingsServiceStubDispatch {
 public:
  static bool Accept(PassageEmbeddingsService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PassageEmbeddingsService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PassageEmbeddingsService>>
class PassageEmbeddingsServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PassageEmbeddingsServiceStub() = default;
  ~PassageEmbeddingsServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PassageEmbeddingsServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PassageEmbeddingsServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PassageEmbedderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PassageEmbeddingsServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PassageEmbedderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PassageEmbeddingsServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  PassageEmbeddingsResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PassageEmbeddingsResult, T>::value>;
  using DataView = PassageEmbeddingsResultDataView;
  using Data_ = internal::PassageEmbeddingsResult_Data;

  template <typename... Args>
  static PassageEmbeddingsResultPtr New(Args&&... args) {
    return PassageEmbeddingsResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PassageEmbeddingsResultPtr From(const U& u) {
    return mojo::TypeConverter<PassageEmbeddingsResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PassageEmbeddingsResult>::Convert(*this);
  }


  PassageEmbeddingsResult();

  explicit PassageEmbeddingsResult(
      std::vector<float> embeddings);


  ~PassageEmbeddingsResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PassageEmbeddingsResultPtr>
  PassageEmbeddingsResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PassageEmbeddingsResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PassageEmbeddingsResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PassageEmbeddingsResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PassageEmbeddingsResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PassageEmbeddingsResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PassageEmbeddingsResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PassageEmbeddingsResult_UnserializedMessageContext<
            UserType, PassageEmbeddingsResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PassageEmbeddingsResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PassageEmbeddingsResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PassageEmbeddingsResult_UnserializedMessageContext<
            UserType, PassageEmbeddingsResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PassageEmbeddingsResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<float> embeddings;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PassageEmbeddingsResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PassageEmbeddingsResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PassageEmbeddingsResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PassageEmbeddingsResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PassageEmbeddingsLoadModelsParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PassageEmbeddingsLoadModelsParams, T>::value>;
  using DataView = PassageEmbeddingsLoadModelsParamsDataView;
  using Data_ = internal::PassageEmbeddingsLoadModelsParams_Data;

  template <typename... Args>
  static PassageEmbeddingsLoadModelsParamsPtr New(Args&&... args) {
    return PassageEmbeddingsLoadModelsParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PassageEmbeddingsLoadModelsParamsPtr From(const U& u) {
    return mojo::TypeConverter<PassageEmbeddingsLoadModelsParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PassageEmbeddingsLoadModelsParams>::Convert(*this);
  }


  PassageEmbeddingsLoadModelsParams();

  PassageEmbeddingsLoadModelsParams(
      ::base::File embeddings_model,
      ::base::File sp_model,
      uint32_t input_window_size);

PassageEmbeddingsLoadModelsParams(const PassageEmbeddingsLoadModelsParams&) = delete;
PassageEmbeddingsLoadModelsParams& operator=(const PassageEmbeddingsLoadModelsParams&) = delete;

  ~PassageEmbeddingsLoadModelsParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PassageEmbeddingsLoadModelsParamsPtr>
  PassageEmbeddingsLoadModelsParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PassageEmbeddingsLoadModelsParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PassageEmbeddingsLoadModelsParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PassageEmbeddingsLoadModelsParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PassageEmbeddingsLoadModelsParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PassageEmbeddingsLoadModelsParams_UnserializedMessageContext<
            UserType, PassageEmbeddingsLoadModelsParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PassageEmbeddingsLoadModelsParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PassageEmbeddingsLoadModelsParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PassageEmbeddingsLoadModelsParams_UnserializedMessageContext<
            UserType, PassageEmbeddingsLoadModelsParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PassageEmbeddingsLoadModelsParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::File embeddings_model;
  
  ::base::File sp_model;
  
  uint32_t input_window_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PassageEmbeddingsLoadModelsParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PassageEmbeddingsLoadModelsParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PassageEmbeddingsLoadModelsParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PassageEmbeddingsLoadModelsParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PassageEmbedderParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PassageEmbedderParams, T>::value>;
  using DataView = PassageEmbedderParamsDataView;
  using Data_ = internal::PassageEmbedderParams_Data;

  template <typename... Args>
  static PassageEmbedderParamsPtr New(Args&&... args) {
    return PassageEmbedderParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PassageEmbedderParamsPtr From(const U& u) {
    return mojo::TypeConverter<PassageEmbedderParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PassageEmbedderParams>::Convert(*this);
  }


  PassageEmbedderParams();

  PassageEmbedderParams(
      uint32_t user_initiated_priority_num_threads,
      uint32_t urgent_priority_num_threads,
      uint32_t passive_priority_num_threads,
      uint32_t embedder_cache_size,
      bool allow_gpu_execution);


  ~PassageEmbedderParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PassageEmbedderParamsPtr>
  PassageEmbedderParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PassageEmbedderParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PassageEmbedderParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PassageEmbedderParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PassageEmbedderParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PassageEmbedderParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PassageEmbedderParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PassageEmbedderParams_UnserializedMessageContext<
            UserType, PassageEmbedderParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PassageEmbedderParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PassageEmbedderParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PassageEmbedderParams_UnserializedMessageContext<
            UserType, PassageEmbedderParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PassageEmbedderParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t user_initiated_priority_num_threads;
  
  uint32_t urgent_priority_num_threads;
  
  uint32_t passive_priority_num_threads;
  
  uint32_t embedder_cache_size;
  
  bool allow_gpu_execution;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PassageEmbedderParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PassageEmbedderParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PassageEmbedderParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PassageEmbedderParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PassageEmbeddingsResultPtr PassageEmbeddingsResult::Clone() const {
  return New(
      mojo::Clone(embeddings)
  );
}

template <typename T, PassageEmbeddingsResult::EnableIfSame<T>*>
bool PassageEmbeddingsResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->embeddings, other_struct.embeddings))
    return false;
  return true;
}

template <typename T, PassageEmbeddingsResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.embeddings < rhs.embeddings)
    return true;
  if (rhs.embeddings < lhs.embeddings)
    return false;
  return false;
}
template <typename StructPtrType>
PassageEmbeddingsLoadModelsParamsPtr PassageEmbeddingsLoadModelsParams::Clone() const {
  return New(
      mojo::Clone(embeddings_model),
      mojo::Clone(sp_model),
      mojo::Clone(input_window_size)
  );
}

template <typename T, PassageEmbeddingsLoadModelsParams::EnableIfSame<T>*>
bool PassageEmbeddingsLoadModelsParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->embeddings_model, other_struct.embeddings_model))
    return false;
  if (!mojo::Equals(this->sp_model, other_struct.sp_model))
    return false;
  if (!mojo::Equals(this->input_window_size, other_struct.input_window_size))
    return false;
  return true;
}

template <typename T, PassageEmbeddingsLoadModelsParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.embeddings_model < rhs.embeddings_model)
    return true;
  if (rhs.embeddings_model < lhs.embeddings_model)
    return false;
  if (lhs.sp_model < rhs.sp_model)
    return true;
  if (rhs.sp_model < lhs.sp_model)
    return false;
  if (lhs.input_window_size < rhs.input_window_size)
    return true;
  if (rhs.input_window_size < lhs.input_window_size)
    return false;
  return false;
}
template <typename StructPtrType>
PassageEmbedderParamsPtr PassageEmbedderParams::Clone() const {
  return New(
      mojo::Clone(user_initiated_priority_num_threads),
      mojo::Clone(urgent_priority_num_threads),
      mojo::Clone(passive_priority_num_threads),
      mojo::Clone(embedder_cache_size),
      mojo::Clone(allow_gpu_execution)
  );
}

template <typename T, PassageEmbedderParams::EnableIfSame<T>*>
bool PassageEmbedderParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->user_initiated_priority_num_threads, other_struct.user_initiated_priority_num_threads))
    return false;
  if (!mojo::Equals(this->urgent_priority_num_threads, other_struct.urgent_priority_num_threads))
    return false;
  if (!mojo::Equals(this->passive_priority_num_threads, other_struct.passive_priority_num_threads))
    return false;
  if (!mojo::Equals(this->embedder_cache_size, other_struct.embedder_cache_size))
    return false;
  if (!mojo::Equals(this->allow_gpu_execution, other_struct.allow_gpu_execution))
    return false;
  return true;
}

template <typename T, PassageEmbedderParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.user_initiated_priority_num_threads < rhs.user_initiated_priority_num_threads)
    return true;
  if (rhs.user_initiated_priority_num_threads < lhs.user_initiated_priority_num_threads)
    return false;
  if (lhs.urgent_priority_num_threads < rhs.urgent_priority_num_threads)
    return true;
  if (rhs.urgent_priority_num_threads < lhs.urgent_priority_num_threads)
    return false;
  if (lhs.passive_priority_num_threads < rhs.passive_priority_num_threads)
    return true;
  if (rhs.passive_priority_num_threads < lhs.passive_priority_num_threads)
    return false;
  if (lhs.embedder_cache_size < rhs.embedder_cache_size)
    return true;
  if (rhs.embedder_cache_size < lhs.embedder_cache_size)
    return false;
  if (lhs.allow_gpu_execution < rhs.allow_gpu_execution)
    return true;
  if (rhs.allow_gpu_execution < lhs.allow_gpu_execution)
    return false;
  return false;
}


}  // passage_embeddings::mojom

namespace mojo {


template <>
struct  StructTraits<::passage_embeddings::mojom::PassageEmbeddingsResult::DataView,
                                         ::passage_embeddings::mojom::PassageEmbeddingsResultPtr> {
  static bool IsNull(const ::passage_embeddings::mojom::PassageEmbeddingsResultPtr& input) { return !input; }
  static void SetToNull(::passage_embeddings::mojom::PassageEmbeddingsResultPtr* output) { output->reset(); }

  static const decltype(::passage_embeddings::mojom::PassageEmbeddingsResult::embeddings)& embeddings(
      const ::passage_embeddings::mojom::PassageEmbeddingsResultPtr& input) {
    return input->embeddings;
  }

  static bool Read(::passage_embeddings::mojom::PassageEmbeddingsResult::DataView input, ::passage_embeddings::mojom::PassageEmbeddingsResultPtr* output);
};


template <>
struct  StructTraits<::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParams::DataView,
                                         ::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsPtr> {
  static bool IsNull(const ::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsPtr& input) { return !input; }
  static void SetToNull(::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsPtr* output) { output->reset(); }

  static  decltype(::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParams::embeddings_model)& embeddings_model(
       ::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsPtr& input) {
    return input->embeddings_model;
  }

  static  decltype(::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParams::sp_model)& sp_model(
       ::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsPtr& input) {
    return input->sp_model;
  }

  static decltype(::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParams::input_window_size) input_window_size(
      const ::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsPtr& input) {
    return input->input_window_size;
  }

  static bool Read(::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParams::DataView input, ::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsPtr* output);
};


template <>
struct  StructTraits<::passage_embeddings::mojom::PassageEmbedderParams::DataView,
                                         ::passage_embeddings::mojom::PassageEmbedderParamsPtr> {
  static bool IsNull(const ::passage_embeddings::mojom::PassageEmbedderParamsPtr& input) { return !input; }
  static void SetToNull(::passage_embeddings::mojom::PassageEmbedderParamsPtr* output) { output->reset(); }

  static decltype(::passage_embeddings::mojom::PassageEmbedderParams::user_initiated_priority_num_threads) user_initiated_priority_num_threads(
      const ::passage_embeddings::mojom::PassageEmbedderParamsPtr& input) {
    return input->user_initiated_priority_num_threads;
  }

  static decltype(::passage_embeddings::mojom::PassageEmbedderParams::urgent_priority_num_threads) urgent_priority_num_threads(
      const ::passage_embeddings::mojom::PassageEmbedderParamsPtr& input) {
    return input->urgent_priority_num_threads;
  }

  static decltype(::passage_embeddings::mojom::PassageEmbedderParams::passive_priority_num_threads) passive_priority_num_threads(
      const ::passage_embeddings::mojom::PassageEmbedderParamsPtr& input) {
    return input->passive_priority_num_threads;
  }

  static decltype(::passage_embeddings::mojom::PassageEmbedderParams::embedder_cache_size) embedder_cache_size(
      const ::passage_embeddings::mojom::PassageEmbedderParamsPtr& input) {
    return input->embedder_cache_size;
  }

  static decltype(::passage_embeddings::mojom::PassageEmbedderParams::allow_gpu_execution) allow_gpu_execution(
      const ::passage_embeddings::mojom::PassageEmbedderParamsPtr& input) {
    return input->allow_gpu_execution;
  }

  static bool Read(::passage_embeddings::mojom::PassageEmbedderParams::DataView input, ::passage_embeddings::mojom::PassageEmbedderParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_H_