// services/on_device_model/public/mojom/on_device_model_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/on_device_model/public/mojom/on_device_model_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/on_device_model/public/mojom/on_device_model_service.mojom-params-data.h"
#include "services/on_device_model/public/mojom/on_device_model_service.mojom-shared-message-ids.h"

#include "services/on_device_model/public/mojom/on_device_model_service.mojom-import-headers.h"
#include "services/on_device_model/public/mojom/on_device_model_service.mojom-test-utils.h"


namespace on_device_model::mojom {
ModelAssets::ModelAssets()
    : weights(mojo::internal::DefaultConstructTag()),
      sp_model_path(),
      cache(),
      encoder_cache(),
      adapter_cache() {}

ModelAssets::ModelAssets(
    ::on_device_model::ModelFile weights_in,
    const std::optional<::base::FilePath>& sp_model_path_in,
    ::base::File cache_in,
    ::base::File encoder_cache_in,
    ::base::File adapter_cache_in)
    : weights(std::move(weights_in)),
      sp_model_path(std::move(sp_model_path_in)),
      cache(std::move(cache_in)),
      encoder_cache(std::move(encoder_cache_in)),
      adapter_cache(std::move(adapter_cache_in)) {}

ModelAssets::~ModelAssets() = default;

void ModelAssets::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weights"), this->weights,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::on_device_model::ModelFile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sp_model_path"), this->sp_model_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache"), this->cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoder_cache"), this->encoder_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "adapter_cache"), this->adapter_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ModelAssets::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LoadModelParams::LoadModelParams()
    : backend_type(),
      assets(mojo::internal::DefaultConstructTag()),
      max_tokens(),
      adaptation_ranks(),
      performance_hint(mojo::internal::ConvertEnumValue<ModelPerformanceHint, ::ml::ModelPerformanceHint>(ModelPerformanceHint::kHighestQuality)) {}

LoadModelParams::LoadModelParams(
    ::ml::ModelBackendType backend_type_in,
    ::on_device_model::ModelAssets assets_in,
    uint32_t max_tokens_in,
    std::vector<uint32_t> adaptation_ranks_in,
    ::ml::ModelPerformanceHint performance_hint_in)
    : backend_type(std::move(backend_type_in)),
      assets(std::move(assets_in)),
      max_tokens(std::move(max_tokens_in)),
      adaptation_ranks(std::move(adaptation_ranks_in)),
      performance_hint(std::move(performance_hint_in)) {}

LoadModelParams::~LoadModelParams() = default;

void LoadModelParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "backend_type"), this->backend_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ml::ModelBackendType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "assets"), this->assets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::on_device_model::ModelAssets>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_tokens"), this->max_tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "adaptation_ranks"), this->adaptation_ranks,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "performance_hint"), this->performance_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ml::ModelPerformanceHint>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LoadModelParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextSafetyModelAssets::TextSafetyModelAssets()
    : data(),
      sp_model() {}

TextSafetyModelAssets::TextSafetyModelAssets(
    ::base::File data_in,
    ::base::File sp_model_in)
    : data(std::move(data_in)),
      sp_model(std::move(sp_model_in)) {}

TextSafetyModelAssets::~TextSafetyModelAssets() = default;

void TextSafetyModelAssets::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sp_model"), this->sp_model,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TextSafetyModelAssets::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BertSafetyModelAssets::BertSafetyModelAssets()
    : model() {}

BertSafetyModelAssets::BertSafetyModelAssets(
    ::base::File model_in)
    : model(std::move(model_in)) {}

BertSafetyModelAssets::~BertSafetyModelAssets() = default;

void BertSafetyModelAssets::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model"), this->model,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BertSafetyModelAssets::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LanguageModelAssets::LanguageModelAssets()
    : model() {}

LanguageModelAssets::LanguageModelAssets(
    ::base::File model_in)
    : model(std::move(model_in)) {}

LanguageModelAssets::~LanguageModelAssets() = default;

void LanguageModelAssets::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model"), this->model,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LanguageModelAssets::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextSafetyModelParams::TextSafetyModelParams()
    : safety_assets(),
      language_assets() {}

TextSafetyModelParams::TextSafetyModelParams(
    SafetyModelAssetsPtr safety_assets_in,
    LanguageModelAssetsPtr language_assets_in)
    : safety_assets(std::move(safety_assets_in)),
      language_assets(std::move(language_assets_in)) {}

TextSafetyModelParams::~TextSafetyModelParams() = default;

void TextSafetyModelParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "safety_assets"), this->safety_assets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SafetyModelAssetsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language_assets"), this->language_assets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LanguageModelAssetsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TextSafetyModelParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ModelFilePtr
ModelFile::NewFile(
    ::base::File value) {
  return ModelFilePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFile)>,
      std::move(value));
}

ModelFilePtr
ModelFile::NewPath(
    const ::base::FilePath& value) {
  return ModelFilePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPath)>,
      std::move(value));
}

ModelFile::ModelFile(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    ::base::File value)
    : tag_(Tag::kFile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFile)>,
            std::move(value)) {}

ModelFile::ModelFile(
    std::in_place_index_t<static_cast<size_t>(Tag::kPath)>,
    const ::base::FilePath& value)
    : tag_(Tag::kPath),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPath)>,
            std::move(value)) {}
ModelFile::~ModelFile() {
  DestroyActive();
}

void ModelFile::set_file(::base::File file) {
  if (tag_ == Tag::kFile) {
    data_.file = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::kFile;
    new (&data_.file) ::base::File(
        std::move(file));
  }
}

void ModelFile::set_path(const ::base::FilePath& path) {
  if (tag_ == Tag::kPath) {
    data_.path = std::move(path);
  } else {
    DestroyActive();
    tag_ = Tag::kPath;
    new (&data_.path) ::base::FilePath(
        std::move(path));
  }
}


ModelFile::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    ::base::File value)
    : file(std::move(value)) {}

ModelFile::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPath)>,
    const ::base::FilePath& value)
    : path(std::move(value)) {}

void ModelFile::DestroyActive() {
  switch (tag_) {

    case Tag::kFile:
      std::destroy_at(&data_.file);
      break;
    case Tag::kPath:
      std::destroy_at(&data_.path);
      break;
  }
}

bool ModelFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
SafetyModelAssetsPtr
SafetyModelAssets::NewTsAssets(
    TextSafetyModelAssetsPtr value) {
  return SafetyModelAssetsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTsAssets)>,
      std::move(value));
}

SafetyModelAssetsPtr
SafetyModelAssets::NewBsAssets(
    BertSafetyModelAssetsPtr value) {
  return SafetyModelAssetsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBsAssets)>,
      std::move(value));
}

SafetyModelAssets::SafetyModelAssets(
    std::in_place_index_t<static_cast<size_t>(Tag::kTsAssets)>,
    TextSafetyModelAssetsPtr value)
    : tag_(Tag::kTsAssets),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTsAssets)>,
            std::move(value)) {}

SafetyModelAssets::SafetyModelAssets(
    std::in_place_index_t<static_cast<size_t>(Tag::kBsAssets)>,
    BertSafetyModelAssetsPtr value)
    : tag_(Tag::kBsAssets),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBsAssets)>,
            std::move(value)) {}
SafetyModelAssets::~SafetyModelAssets() {
  DestroyActive();
}

void SafetyModelAssets::set_ts_assets(TextSafetyModelAssetsPtr ts_assets) {
  if (tag_ == Tag::kTsAssets) {
    data_.ts_assets = std::move(ts_assets);
  } else {
    DestroyActive();
    tag_ = Tag::kTsAssets;
    new (&data_.ts_assets) TextSafetyModelAssetsPtr(
        std::move(ts_assets));
  }
}

void SafetyModelAssets::set_bs_assets(BertSafetyModelAssetsPtr bs_assets) {
  if (tag_ == Tag::kBsAssets) {
    data_.bs_assets = std::move(bs_assets);
  } else {
    DestroyActive();
    tag_ = Tag::kBsAssets;
    new (&data_.bs_assets) BertSafetyModelAssetsPtr(
        std::move(bs_assets));
  }
}


SafetyModelAssets::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTsAssets)>,
    TextSafetyModelAssetsPtr value)
    : ts_assets(std::move(value)) {}

SafetyModelAssets::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBsAssets)>,
    BertSafetyModelAssetsPtr value)
    : bs_assets(std::move(value)) {}

void SafetyModelAssets::DestroyActive() {
  switch (tag_) {

    case Tag::kTsAssets:
      std::destroy_at(&data_.ts_assets);
      break;
    case Tag::kBsAssets:
      std::destroy_at(&data_.bs_assets);
      break;
  }
}

bool SafetyModelAssets::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

PlatformModelProgressObserver::IPCStableHashFunction PlatformModelProgressObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PlatformModelProgressObserver>(message.name())) {
    case messages::PlatformModelProgressObserver::kProgress: {
      return &PlatformModelProgressObserver::Progress_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PlatformModelProgressObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PlatformModelProgressObserver>(message.name())) {
      case messages::PlatformModelProgressObserver::kProgress:
            return "Receive on_device_model::mojom::PlatformModelProgressObserver::Progress";
    }
  } else {
    switch (static_cast<messages::PlatformModelProgressObserver>(message.name())) {
      case messages::PlatformModelProgressObserver::kProgress:
            return "Receive reply on_device_model::mojom::PlatformModelProgressObserver::Progress";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PlatformModelProgressObserver::Progress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9396c8b2;  // IPCStableHash for on_device_model::mojom::PlatformModelProgressObserver::Progress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PlatformModelProgressObserverProxy::PlatformModelProgressObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PlatformModelProgressObserverProxy::Progress(
    double in_progress) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::PlatformModelProgressObserver::Progress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("progress"), in_progress,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PlatformModelProgressObserver::kProgress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::PlatformModelProgressObserver_Progress_Params_Data> params(
          message);
  params.Allocate();

  params->progress = in_progress;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlatformModelProgressObserver::Name_);
  message.set_method_name("Progress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PlatformModelProgressObserverStubDispatch::Accept(
    PlatformModelProgressObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PlatformModelProgressObserver>(message->header()->name)) {
    case messages::PlatformModelProgressObserver::kProgress: {
      DCHECK(message->is_serialized());
      internal::PlatformModelProgressObserver_Progress_Params_Data* params =
          reinterpret_cast<internal::PlatformModelProgressObserver_Progress_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PlatformModelProgressObserver.0
      bool success = true;
      double p_progress{};
      PlatformModelProgressObserver_Progress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_progress = input_data_view.progress();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlatformModelProgressObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Progress(        
        std::move(p_progress));
      return true;
    }
  }
  return false;
}

// static
bool PlatformModelProgressObserverStubDispatch::AcceptWithResponder(
    PlatformModelProgressObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PlatformModelProgressObserver>(message->header()->name)) {
    case messages::PlatformModelProgressObserver::kProgress: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPlatformModelProgressObserverValidationInfo[] = {
    { &internal::PlatformModelProgressObserver_Progress_Params_Data::Validate,
     nullptr /* no response */},
};

bool PlatformModelProgressObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_model::mojom::PlatformModelProgressObserver::Name_,
    kPlatformModelProgressObserverValidationInfo);
}

// The declaration includes the definition on other builds.

OnDeviceModelService::IPCStableHashFunction OnDeviceModelService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OnDeviceModelService>(message.name())) {
    case messages::OnDeviceModelService::kLoadModel: {
      return &OnDeviceModelService::LoadModel_Sym::IPCStableHash;
    }
    case messages::OnDeviceModelService::kGetCapabilities: {
      return &OnDeviceModelService::GetCapabilities_Sym::IPCStableHash;
    }
    case messages::OnDeviceModelService::kLoadTextSafetyModel: {
      return &OnDeviceModelService::LoadTextSafetyModel_Sym::IPCStableHash;
    }
    case messages::OnDeviceModelService::kGetDeviceAndPerformanceInfo: {
      return &OnDeviceModelService::GetDeviceAndPerformanceInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OnDeviceModelService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OnDeviceModelService>(message.name())) {
      case messages::OnDeviceModelService::kLoadModel:
            return "Receive on_device_model::mojom::OnDeviceModelService::LoadModel";
      case messages::OnDeviceModelService::kGetCapabilities:
            return "Receive on_device_model::mojom::OnDeviceModelService::GetCapabilities";
      case messages::OnDeviceModelService::kLoadTextSafetyModel:
            return "Receive on_device_model::mojom::OnDeviceModelService::LoadTextSafetyModel";
      case messages::OnDeviceModelService::kGetDeviceAndPerformanceInfo:
            return "Receive on_device_model::mojom::OnDeviceModelService::GetDeviceAndPerformanceInfo";
    }
  } else {
    switch (static_cast<messages::OnDeviceModelService>(message.name())) {
      case messages::OnDeviceModelService::kLoadModel:
            return "Receive reply on_device_model::mojom::OnDeviceModelService::LoadModel";
      case messages::OnDeviceModelService::kGetCapabilities:
            return "Receive reply on_device_model::mojom::OnDeviceModelService::GetCapabilities";
      case messages::OnDeviceModelService::kLoadTextSafetyModel:
            return "Receive reply on_device_model::mojom::OnDeviceModelService::LoadTextSafetyModel";
      case messages::OnDeviceModelService::kGetDeviceAndPerformanceInfo:
            return "Receive reply on_device_model::mojom::OnDeviceModelService::GetDeviceAndPerformanceInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OnDeviceModelService::LoadModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15bc6200;  // IPCStableHash for on_device_model::mojom::OnDeviceModelService::LoadModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceModelService::GetCapabilities_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbd8f10d8;  // IPCStableHash for on_device_model::mojom::OnDeviceModelService::GetCapabilities
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceModelService::LoadTextSafetyModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x18dcabca;  // IPCStableHash for on_device_model::mojom::OnDeviceModelService::LoadTextSafetyModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceModelService::GetDeviceAndPerformanceInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd186ed92;  // IPCStableHash for on_device_model::mojom::OnDeviceModelService::GetDeviceAndPerformanceInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class OnDeviceModelService_LoadModel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceModelService_LoadModel_ForwardToCallback(
      OnDeviceModelService::LoadModelCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceModelService_LoadModel_ForwardToCallback(const OnDeviceModelService_LoadModel_ForwardToCallback&) = delete;
  OnDeviceModelService_LoadModel_ForwardToCallback& operator=(const OnDeviceModelService_LoadModel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceModelService::LoadModelCallback callback_;
};

class OnDeviceModelService_GetCapabilities_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceModelService_GetCapabilities_ForwardToCallback(
      OnDeviceModelService::GetCapabilitiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceModelService_GetCapabilities_ForwardToCallback(const OnDeviceModelService_GetCapabilities_ForwardToCallback&) = delete;
  OnDeviceModelService_GetCapabilities_ForwardToCallback& operator=(const OnDeviceModelService_GetCapabilities_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceModelService::GetCapabilitiesCallback callback_;
};

class OnDeviceModelService_GetDeviceAndPerformanceInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceModelService_GetDeviceAndPerformanceInfo_ForwardToCallback(
      OnDeviceModelService::GetDeviceAndPerformanceInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceModelService_GetDeviceAndPerformanceInfo_ForwardToCallback(const OnDeviceModelService_GetDeviceAndPerformanceInfo_ForwardToCallback&) = delete;
  OnDeviceModelService_GetDeviceAndPerformanceInfo_ForwardToCallback& operator=(const OnDeviceModelService_GetDeviceAndPerformanceInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceModelService::GetDeviceAndPerformanceInfoCallback callback_;
};

OnDeviceModelServiceProxy::OnDeviceModelServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OnDeviceModelServiceProxy::LoadModel(
    LoadModelParamsPtr in_params, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> in_model, LoadModelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::OnDeviceModelService::LoadModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type LoadModelParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model"), in_model,
                        "<value of type ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelService::kLoadModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelService_LoadModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::LoadModelParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in OnDeviceModelService.LoadModel request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::OnDeviceModelInterfaceBase>>(
    in_model,
    &params->model,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->model)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid model in OnDeviceModelService.LoadModel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelService::Name_);
  message.set_method_name("LoadModel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceModelService_LoadModel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OnDeviceModelServiceProxy::GetCapabilities(
    ::on_device_model::ModelFile in_weights, GetCapabilitiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::OnDeviceModelService::GetCapabilities", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("weights"), in_weights,
                        "<value of type ::on_device_model::ModelFile>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelService::kGetCapabilities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelService_GetCapabilities_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->weights)>
      weights_fragment(params.message());
  weights_fragment.Claim(&params->weights);
  
  mojo::internal::Serialize<::on_device_model::mojom::ModelFileDataView>(
    in_weights,
    weights_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->weights.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null weights in OnDeviceModelService.GetCapabilities request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelService::Name_);
  message.set_method_name("GetCapabilities");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceModelService_GetCapabilities_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OnDeviceModelServiceProxy::LoadTextSafetyModel(
    TextSafetyModelParamsPtr in_params, ::mojo::PendingReceiver<::on_device_model::mojom::TextSafetyModel> in_model) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::OnDeviceModelService::LoadTextSafetyModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type TextSafetyModelParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model"), in_model,
                        "<value of type ::mojo::PendingReceiver<::on_device_model::mojom::TextSafetyModel>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelService::kLoadTextSafetyModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelService_LoadTextSafetyModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::TextSafetyModelParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in OnDeviceModelService.LoadTextSafetyModel request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::TextSafetyModelInterfaceBase>>(
    in_model,
    &params->model,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->model)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid model in OnDeviceModelService.LoadTextSafetyModel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelService::Name_);
  message.set_method_name("LoadTextSafetyModel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void OnDeviceModelServiceProxy::GetDeviceAndPerformanceInfo(
    GetDeviceAndPerformanceInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send on_device_model::mojom::OnDeviceModelService::GetDeviceAndPerformanceInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelService::kGetDeviceAndPerformanceInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelService_GetDeviceAndPerformanceInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelService::Name_);
  message.set_method_name("GetDeviceAndPerformanceInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceModelService_GetDeviceAndPerformanceInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class OnDeviceModelService_LoadModel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceModelService::LoadModelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceModelService_LoadModel_ProxyToResponder> proxy(
        new OnDeviceModelService_LoadModel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceModelService_LoadModel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceModelService_LoadModel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceModelService_LoadModel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceModelService::LoadModelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::on_device_model::mojom::LoadModelResult in_result);
};

bool OnDeviceModelService_LoadModel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceModelService_LoadModel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceModelService_LoadModel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceModelService.0
  bool success = true;
  ::on_device_model::mojom::LoadModelResult p_result{};
  OnDeviceModelService_LoadModel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceModelService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void OnDeviceModelService_LoadModel_ProxyToResponder::Run(
    ::on_device_model::mojom::LoadModelResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::OnDeviceModelService::LoadModel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::on_device_model::mojom::LoadModelResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelService::kLoadModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelService_LoadModel_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::on_device_model::mojom::LoadModelResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelService::Name_);
  message.set_method_name("LoadModel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OnDeviceModelService_GetCapabilities_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceModelService::GetCapabilitiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceModelService_GetCapabilities_ProxyToResponder> proxy(
        new OnDeviceModelService_GetCapabilities_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceModelService_GetCapabilities_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceModelService_GetCapabilities_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceModelService_GetCapabilities_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceModelService::GetCapabilitiesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::on_device_model::Capabilities& in_capabilities);
};

bool OnDeviceModelService_GetCapabilities_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceModelService_GetCapabilities_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceModelService_GetCapabilities_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceModelService.1
  bool success = true;
  ::on_device_model::Capabilities p_capabilities{};
  OnDeviceModelService_GetCapabilities_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCapabilities(&p_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceModelService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_capabilities));
  }
  return true;
}

void OnDeviceModelService_GetCapabilities_ProxyToResponder::Run(
    const ::on_device_model::Capabilities& in_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::OnDeviceModelService::GetCapabilities", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capabilities"), in_capabilities,
                        "<value of type const ::on_device_model::Capabilities&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelService::kGetCapabilities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelService_GetCapabilities_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->capabilities)::BaseType> capabilities_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::CapabilitiesDataView>(
    in_capabilities,
    capabilities_fragment);

  params->capabilities.Set(
      capabilities_fragment.is_null() ? nullptr : capabilities_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->capabilities.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null capabilities in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelService::Name_);
  message.set_method_name("GetCapabilities");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OnDeviceModelService_GetDeviceAndPerformanceInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceModelService::GetDeviceAndPerformanceInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceModelService_GetDeviceAndPerformanceInfo_ProxyToResponder> proxy(
        new OnDeviceModelService_GetDeviceAndPerformanceInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceModelService_GetDeviceAndPerformanceInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceModelService_GetDeviceAndPerformanceInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceModelService_GetDeviceAndPerformanceInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceModelService::GetDeviceAndPerformanceInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::on_device_model::mojom::DevicePerformanceInfoPtr in_performanceInfo, ::on_device_model::mojom::DeviceInfoPtr in_device_info);
};

bool OnDeviceModelService_GetDeviceAndPerformanceInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceModelService.3
  bool success = true;
  ::on_device_model::mojom::DevicePerformanceInfoPtr p_performanceInfo{};
  ::on_device_model::mojom::DeviceInfoPtr p_device_info{};
  OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPerformanceInfo(&p_performanceInfo))
    success = false;
  if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceModelService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_performanceInfo), 
std::move(p_device_info));
  }
  return true;
}

void OnDeviceModelService_GetDeviceAndPerformanceInfo_ProxyToResponder::Run(
    ::on_device_model::mojom::DevicePerformanceInfoPtr in_performanceInfo, ::on_device_model::mojom::DeviceInfoPtr in_device_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::OnDeviceModelService::GetDeviceAndPerformanceInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("performanceInfo"), in_performanceInfo,
                        "<value of type ::on_device_model::mojom::DevicePerformanceInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type ::on_device_model::mojom::DeviceInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelService::kGetDeviceAndPerformanceInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->performanceInfo)::BaseType> performanceInfo_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::DevicePerformanceInfoDataView>(
    in_performanceInfo,
    performanceInfo_fragment);

  params->performanceInfo.Set(
      performanceInfo_fragment.is_null() ? nullptr : performanceInfo_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->performanceInfo.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null performanceInfo in ");
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::DeviceInfoDataView>(
    in_device_info,
    device_info_fragment);

  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelService::Name_);
  message.set_method_name("GetDeviceAndPerformanceInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OnDeviceModelServiceStubDispatch::Accept(
    OnDeviceModelService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OnDeviceModelService>(message->header()->name)) {
    case messages::OnDeviceModelService::kLoadModel: {
      break;
    }
    case messages::OnDeviceModelService::kGetCapabilities: {
      break;
    }
    case messages::OnDeviceModelService::kLoadTextSafetyModel: {
      DCHECK(message->is_serialized());
      internal::OnDeviceModelService_LoadTextSafetyModel_Params_Data* params =
          reinterpret_cast<internal::OnDeviceModelService_LoadTextSafetyModel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OnDeviceModelService.2
      bool success = true;
      TextSafetyModelParamsPtr p_params{};
      ::mojo::PendingReceiver<::on_device_model::mojom::TextSafetyModel> p_model{};
      OnDeviceModelService_LoadTextSafetyModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_model =
            input_data_view.TakeModel<decltype(p_model)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModelService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadTextSafetyModel(        
        std::move(p_params), 
        std::move(p_model));
      return true;
    }
    case messages::OnDeviceModelService::kGetDeviceAndPerformanceInfo: {
      break;
    }
  }
  return false;
}

// static
bool OnDeviceModelServiceStubDispatch::AcceptWithResponder(
    OnDeviceModelService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OnDeviceModelService>(message->header()->name)) {
    case messages::OnDeviceModelService::kLoadModel: {
      internal::OnDeviceModelService_LoadModel_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceModelService_LoadModel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceModelService.0
      bool success = true;
      LoadModelParamsPtr p_params{};
      ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> p_model{};
      OnDeviceModelService_LoadModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_model =
            input_data_view.TakeModel<decltype(p_model)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModelService::Name_, 0, false);
        return false;
      }
      auto callback =
          OnDeviceModelService_LoadModel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadModel(        
        std::move(p_params), 
        std::move(p_model), std::move(callback));
      return true;
    }
    case messages::OnDeviceModelService::kGetCapabilities: {
      internal::OnDeviceModelService_GetCapabilities_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceModelService_GetCapabilities_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceModelService.1
      bool success = true;
      ::on_device_model::ModelFile p_weights{mojo::internal::DefaultConstructTag()};
      OnDeviceModelService_GetCapabilities_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWeights(&p_weights))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModelService::Name_, 1, false);
        return false;
      }
      auto callback =
          OnDeviceModelService_GetCapabilities_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCapabilities(        
        std::move(p_weights), std::move(callback));
      return true;
    }
    case messages::OnDeviceModelService::kLoadTextSafetyModel: {
      break;
    }
    case messages::OnDeviceModelService::kGetDeviceAndPerformanceInfo: {
      internal::OnDeviceModelService_GetDeviceAndPerformanceInfo_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceModelService_GetDeviceAndPerformanceInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceModelService.3
      bool success = true;
      OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModelService::Name_, 3, false);
        return false;
      }
      auto callback =
          OnDeviceModelService_GetDeviceAndPerformanceInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceAndPerformanceInfo(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOnDeviceModelServiceValidationInfo[] = {
    { &internal::OnDeviceModelService_LoadModel_Params_Data::Validate,
     &internal::OnDeviceModelService_LoadModel_ResponseParams_Data::Validate},
    { &internal::OnDeviceModelService_GetCapabilities_Params_Data::Validate,
     &internal::OnDeviceModelService_GetCapabilities_ResponseParams_Data::Validate},
    { &internal::OnDeviceModelService_LoadTextSafetyModel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::OnDeviceModelService_GetDeviceAndPerformanceInfo_Params_Data::Validate,
     &internal::OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams_Data::Validate},
};

bool OnDeviceModelServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_model::mojom::OnDeviceModelService::Name_,
    kOnDeviceModelServiceValidationInfo);
}

bool OnDeviceModelServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::on_device_model::mojom::OnDeviceModelService::Name_,
    kOnDeviceModelServiceValidationInfo);
}
// The declaration includes the definition on other builds.

OnDeviceModelPlatformService::IPCStableHashFunction OnDeviceModelPlatformService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OnDeviceModelPlatformService>(message.name())) {
    case messages::OnDeviceModelPlatformService::kLoadPlatformModel: {
      return &OnDeviceModelPlatformService::LoadPlatformModel_Sym::IPCStableHash;
    }
    case messages::OnDeviceModelPlatformService::kGetPlatformModelState: {
      return &OnDeviceModelPlatformService::GetPlatformModelState_Sym::IPCStableHash;
    }
    case messages::OnDeviceModelPlatformService::kGetEstimatedPerformanceClass: {
      return &OnDeviceModelPlatformService::GetEstimatedPerformanceClass_Sym::IPCStableHash;
    }
    case messages::OnDeviceModelPlatformService::kFormatInput: {
      return &OnDeviceModelPlatformService::FormatInput_Sym::IPCStableHash;
    }
    case messages::OnDeviceModelPlatformService::kValidateSafetyResult: {
      return &OnDeviceModelPlatformService::ValidateSafetyResult_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OnDeviceModelPlatformService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OnDeviceModelPlatformService>(message.name())) {
      case messages::OnDeviceModelPlatformService::kLoadPlatformModel:
            return "Receive on_device_model::mojom::OnDeviceModelPlatformService::LoadPlatformModel";
      case messages::OnDeviceModelPlatformService::kGetPlatformModelState:
            return "Receive on_device_model::mojom::OnDeviceModelPlatformService::GetPlatformModelState";
      case messages::OnDeviceModelPlatformService::kGetEstimatedPerformanceClass:
            return "Receive on_device_model::mojom::OnDeviceModelPlatformService::GetEstimatedPerformanceClass";
      case messages::OnDeviceModelPlatformService::kFormatInput:
            return "Receive on_device_model::mojom::OnDeviceModelPlatformService::FormatInput";
      case messages::OnDeviceModelPlatformService::kValidateSafetyResult:
            return "Receive on_device_model::mojom::OnDeviceModelPlatformService::ValidateSafetyResult";
    }
  } else {
    switch (static_cast<messages::OnDeviceModelPlatformService>(message.name())) {
      case messages::OnDeviceModelPlatformService::kLoadPlatformModel:
            return "Receive reply on_device_model::mojom::OnDeviceModelPlatformService::LoadPlatformModel";
      case messages::OnDeviceModelPlatformService::kGetPlatformModelState:
            return "Receive reply on_device_model::mojom::OnDeviceModelPlatformService::GetPlatformModelState";
      case messages::OnDeviceModelPlatformService::kGetEstimatedPerformanceClass:
            return "Receive reply on_device_model::mojom::OnDeviceModelPlatformService::GetEstimatedPerformanceClass";
      case messages::OnDeviceModelPlatformService::kFormatInput:
            return "Receive reply on_device_model::mojom::OnDeviceModelPlatformService::FormatInput";
      case messages::OnDeviceModelPlatformService::kValidateSafetyResult:
            return "Receive reply on_device_model::mojom::OnDeviceModelPlatformService::ValidateSafetyResult";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OnDeviceModelPlatformService::LoadPlatformModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x328e9022;  // IPCStableHash for on_device_model::mojom::OnDeviceModelPlatformService::LoadPlatformModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceModelPlatformService::GetPlatformModelState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1bbc1a5d;  // IPCStableHash for on_device_model::mojom::OnDeviceModelPlatformService::GetPlatformModelState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceModelPlatformService::GetEstimatedPerformanceClass_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23e1bae1;  // IPCStableHash for on_device_model::mojom::OnDeviceModelPlatformService::GetEstimatedPerformanceClass
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceModelPlatformService::FormatInput_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc7f97f85;  // IPCStableHash for on_device_model::mojom::OnDeviceModelPlatformService::FormatInput
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceModelPlatformService::ValidateSafetyResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3ab9b859;  // IPCStableHash for on_device_model::mojom::OnDeviceModelPlatformService::ValidateSafetyResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class OnDeviceModelPlatformService_LoadPlatformModel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceModelPlatformService_LoadPlatformModel_ForwardToCallback(
      OnDeviceModelPlatformService::LoadPlatformModelCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceModelPlatformService_LoadPlatformModel_ForwardToCallback(const OnDeviceModelPlatformService_LoadPlatformModel_ForwardToCallback&) = delete;
  OnDeviceModelPlatformService_LoadPlatformModel_ForwardToCallback& operator=(const OnDeviceModelPlatformService_LoadPlatformModel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceModelPlatformService::LoadPlatformModelCallback callback_;
};

class OnDeviceModelPlatformService_GetPlatformModelState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceModelPlatformService_GetPlatformModelState_ForwardToCallback(
      OnDeviceModelPlatformService::GetPlatformModelStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceModelPlatformService_GetPlatformModelState_ForwardToCallback(const OnDeviceModelPlatformService_GetPlatformModelState_ForwardToCallback&) = delete;
  OnDeviceModelPlatformService_GetPlatformModelState_ForwardToCallback& operator=(const OnDeviceModelPlatformService_GetPlatformModelState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceModelPlatformService::GetPlatformModelStateCallback callback_;
};

class OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ForwardToCallback(
      OnDeviceModelPlatformService::GetEstimatedPerformanceClassCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ForwardToCallback(const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ForwardToCallback&) = delete;
  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ForwardToCallback& operator=(const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceModelPlatformService::GetEstimatedPerformanceClassCallback callback_;
};

class OnDeviceModelPlatformService_FormatInput_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceModelPlatformService_FormatInput_ForwardToCallback(
      OnDeviceModelPlatformService::FormatInputCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceModelPlatformService_FormatInput_ForwardToCallback(const OnDeviceModelPlatformService_FormatInput_ForwardToCallback&) = delete;
  OnDeviceModelPlatformService_FormatInput_ForwardToCallback& operator=(const OnDeviceModelPlatformService_FormatInput_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceModelPlatformService::FormatInputCallback callback_;
};

class OnDeviceModelPlatformService_ValidateSafetyResult_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceModelPlatformService_ValidateSafetyResult_ForwardToCallback(
      OnDeviceModelPlatformService::ValidateSafetyResultCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceModelPlatformService_ValidateSafetyResult_ForwardToCallback(const OnDeviceModelPlatformService_ValidateSafetyResult_ForwardToCallback&) = delete;
  OnDeviceModelPlatformService_ValidateSafetyResult_ForwardToCallback& operator=(const OnDeviceModelPlatformService_ValidateSafetyResult_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceModelPlatformService::ValidateSafetyResultCallback callback_;
};

OnDeviceModelPlatformServiceProxy::OnDeviceModelPlatformServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OnDeviceModelPlatformServiceProxy::LoadPlatformModel(
    const ::base::Uuid& in_uuid, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> in_model, ::mojo::PendingRemote<PlatformModelProgressObserver> in_progress_observer, LoadPlatformModelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::OnDeviceModelPlatformService::LoadPlatformModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model"), in_model,
                        "<value of type ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("progress_observer"), in_progress_observer,
                        "<value of type ::mojo::PendingRemote<PlatformModelProgressObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelPlatformService::kLoadPlatformModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelPlatformService_LoadPlatformModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in OnDeviceModelPlatformService.LoadPlatformModel request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::OnDeviceModelInterfaceBase>>(
    in_model,
    &params->model,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->model)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid model in OnDeviceModelPlatformService.LoadPlatformModel request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::on_device_model::mojom::PlatformModelProgressObserverInterfaceBase>>(
    in_progress_observer,
    &params->progress_observer,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelPlatformService::Name_);
  message.set_method_name("LoadPlatformModel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceModelPlatformService_LoadPlatformModel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OnDeviceModelPlatformServiceProxy::GetPlatformModelState(
    const ::base::Uuid& in_uuid, GetPlatformModelStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::OnDeviceModelPlatformService::GetPlatformModelState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelPlatformService::kGetPlatformModelState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelPlatformService_GetPlatformModelState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in OnDeviceModelPlatformService.GetPlatformModelState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelPlatformService::Name_);
  message.set_method_name("GetPlatformModelState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceModelPlatformService_GetPlatformModelState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OnDeviceModelPlatformServiceProxy::GetEstimatedPerformanceClass(
    GetEstimatedPerformanceClassCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send on_device_model::mojom::OnDeviceModelPlatformService::GetEstimatedPerformanceClass");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelPlatformService::kGetEstimatedPerformanceClass), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelPlatformService::Name_);
  message.set_method_name("GetEstimatedPerformanceClass");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OnDeviceModelPlatformServiceProxy::FormatInput(
    const ::base::Uuid& in_uuid, FormatFeature in_feature, const base::flat_map<std::string, std::string>& in_fields, FormatInputCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::OnDeviceModelPlatformService::FormatInput", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type FormatFeature>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fields"), in_fields,
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelPlatformService::kFormatInput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelPlatformService_FormatInput_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in OnDeviceModelPlatformService.FormatInput request");

  
  mojo::internal::Serialize<::on_device_model::mojom::FormatFeature>(
    in_feature,
    &params->feature);
  mojo::internal::MessageFragment<
      typename decltype(params->fields)::BaseType>
      fields_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
    in_fields,
    fields_fragment,
    &fields_validate_params);

  params->fields.Set(
      fields_fragment.is_null() ? nullptr : fields_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->fields.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null fields in OnDeviceModelPlatformService.FormatInput request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelPlatformService::Name_);
  message.set_method_name("FormatInput");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceModelPlatformService_FormatInput_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OnDeviceModelPlatformServiceProxy::ValidateSafetyResult(
    SafetyFeature in_safety_feature, const std::string& in_text, ::on_device_model::mojom::SafetyInfoPtr in_safety_info, ValidateSafetyResultCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::OnDeviceModelPlatformService::ValidateSafetyResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("safety_feature"), in_safety_feature,
                        "<value of type SafetyFeature>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("safety_info"), in_safety_info,
                        "<value of type ::on_device_model::mojom::SafetyInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelPlatformService::kValidateSafetyResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelPlatformService_ValidateSafetyResult_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::on_device_model::mojom::SafetyFeature>(
    in_safety_feature,
    &params->safety_feature);
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in OnDeviceModelPlatformService.ValidateSafetyResult request");
  mojo::internal::MessageFragment<
      typename decltype(params->safety_info)::BaseType> safety_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::SafetyInfoDataView>(
    in_safety_info,
    safety_info_fragment);

  params->safety_info.Set(
      safety_info_fragment.is_null() ? nullptr : safety_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->safety_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null safety_info in OnDeviceModelPlatformService.ValidateSafetyResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelPlatformService::Name_);
  message.set_method_name("ValidateSafetyResult");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceModelPlatformService_ValidateSafetyResult_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class OnDeviceModelPlatformService_LoadPlatformModel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceModelPlatformService::LoadPlatformModelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceModelPlatformService_LoadPlatformModel_ProxyToResponder> proxy(
        new OnDeviceModelPlatformService_LoadPlatformModel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceModelPlatformService_LoadPlatformModel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceModelPlatformService_LoadPlatformModel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceModelPlatformService_LoadPlatformModel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceModelPlatformService::LoadPlatformModelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::on_device_model::mojom::LoadModelResult in_result);
};

bool OnDeviceModelPlatformService_LoadPlatformModel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceModelPlatformService.0
  bool success = true;
  ::on_device_model::mojom::LoadModelResult p_result{};
  OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceModelPlatformService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void OnDeviceModelPlatformService_LoadPlatformModel_ProxyToResponder::Run(
    ::on_device_model::mojom::LoadModelResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::OnDeviceModelPlatformService::LoadPlatformModel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::on_device_model::mojom::LoadModelResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelPlatformService::kLoadPlatformModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::on_device_model::mojom::LoadModelResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelPlatformService::Name_);
  message.set_method_name("LoadPlatformModel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OnDeviceModelPlatformService_GetPlatformModelState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceModelPlatformService::GetPlatformModelStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceModelPlatformService_GetPlatformModelState_ProxyToResponder> proxy(
        new OnDeviceModelPlatformService_GetPlatformModelState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceModelPlatformService_GetPlatformModelState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceModelPlatformService_GetPlatformModelState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceModelPlatformService_GetPlatformModelState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceModelPlatformService::GetPlatformModelStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PlatformModelState in_result);
};

bool OnDeviceModelPlatformService_GetPlatformModelState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceModelPlatformService.1
  bool success = true;
  PlatformModelState p_result{};
  OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceModelPlatformService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void OnDeviceModelPlatformService_GetPlatformModelState_ProxyToResponder::Run(
    PlatformModelState in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::OnDeviceModelPlatformService::GetPlatformModelState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PlatformModelState>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelPlatformService::kGetPlatformModelState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::on_device_model::mojom::PlatformModelState>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelPlatformService::Name_);
  message.set_method_name("GetPlatformModelState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceModelPlatformService::GetEstimatedPerformanceClassCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ProxyToResponder> proxy(
        new OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceModelPlatformService::GetEstimatedPerformanceClassCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::on_device_model::mojom::PerformanceClass in_performance_class);
};

bool OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceModelPlatformService.2
  bool success = true;
  ::on_device_model::mojom::PerformanceClass p_performance_class{};
  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPerformanceClass(&p_performance_class))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceModelPlatformService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_performance_class));
  }
  return true;
}

void OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ProxyToResponder::Run(
    ::on_device_model::mojom::PerformanceClass in_performance_class) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::OnDeviceModelPlatformService::GetEstimatedPerformanceClass", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("performance_class"), in_performance_class,
                        "<value of type ::on_device_model::mojom::PerformanceClass>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelPlatformService::kGetEstimatedPerformanceClass), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::on_device_model::mojom::PerformanceClass>(
    in_performance_class,
    &params->performance_class);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelPlatformService::Name_);
  message.set_method_name("GetEstimatedPerformanceClass");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OnDeviceModelPlatformService_FormatInput_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceModelPlatformService::FormatInputCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceModelPlatformService_FormatInput_ProxyToResponder> proxy(
        new OnDeviceModelPlatformService_FormatInput_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceModelPlatformService_FormatInput_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceModelPlatformService_FormatInput_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceModelPlatformService_FormatInput_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceModelPlatformService::FormatInputCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_result);
};

bool OnDeviceModelPlatformService_FormatInput_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceModelPlatformService_FormatInput_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceModelPlatformService_FormatInput_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceModelPlatformService.3
  bool success = true;
  std::optional<std::string> p_result{};
  OnDeviceModelPlatformService_FormatInput_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceModelPlatformService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void OnDeviceModelPlatformService_FormatInput_ProxyToResponder::Run(
    const std::optional<std::string>& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::OnDeviceModelPlatformService::FormatInput", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelPlatformService::kFormatInput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelPlatformService_FormatInput_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelPlatformService::Name_);
  message.set_method_name("FormatInput");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OnDeviceModelPlatformService_ValidateSafetyResult_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceModelPlatformService::ValidateSafetyResultCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceModelPlatformService_ValidateSafetyResult_ProxyToResponder> proxy(
        new OnDeviceModelPlatformService_ValidateSafetyResult_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceModelPlatformService_ValidateSafetyResult_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceModelPlatformService_ValidateSafetyResult_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceModelPlatformService_ValidateSafetyResult_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceModelPlatformService::ValidateSafetyResultCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool OnDeviceModelPlatformService_ValidateSafetyResult_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceModelPlatformService.4
  bool success = true;
  bool p_result{};
  OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceModelPlatformService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void OnDeviceModelPlatformService_ValidateSafetyResult_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::OnDeviceModelPlatformService::ValidateSafetyResult", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModelPlatformService::kValidateSafetyResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModelPlatformService::Name_);
  message.set_method_name("ValidateSafetyResult");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OnDeviceModelPlatformServiceStubDispatch::Accept(
    OnDeviceModelPlatformService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OnDeviceModelPlatformService>(message->header()->name)) {
    case messages::OnDeviceModelPlatformService::kLoadPlatformModel: {
      break;
    }
    case messages::OnDeviceModelPlatformService::kGetPlatformModelState: {
      break;
    }
    case messages::OnDeviceModelPlatformService::kGetEstimatedPerformanceClass: {
      break;
    }
    case messages::OnDeviceModelPlatformService::kFormatInput: {
      break;
    }
    case messages::OnDeviceModelPlatformService::kValidateSafetyResult: {
      break;
    }
  }
  return false;
}

// static
bool OnDeviceModelPlatformServiceStubDispatch::AcceptWithResponder(
    OnDeviceModelPlatformService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OnDeviceModelPlatformService>(message->header()->name)) {
    case messages::OnDeviceModelPlatformService::kLoadPlatformModel: {
      internal::OnDeviceModelPlatformService_LoadPlatformModel_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceModelPlatformService_LoadPlatformModel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceModelPlatformService.0
      bool success = true;
      ::base::Uuid p_uuid{};
      ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> p_model{};
      ::mojo::PendingRemote<PlatformModelProgressObserver> p_progress_observer{};
      OnDeviceModelPlatformService_LoadPlatformModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success) {
        p_model =
            input_data_view.TakeModel<decltype(p_model)>();
      }
      if (success) {
        p_progress_observer =
            input_data_view.TakeProgressObserver<decltype(p_progress_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModelPlatformService::Name_, 0, false);
        return false;
      }
      auto callback =
          OnDeviceModelPlatformService_LoadPlatformModel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadPlatformModel(        
        std::move(p_uuid), 
        std::move(p_model), 
        std::move(p_progress_observer), std::move(callback));
      return true;
    }
    case messages::OnDeviceModelPlatformService::kGetPlatformModelState: {
      internal::OnDeviceModelPlatformService_GetPlatformModelState_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceModelPlatformService_GetPlatformModelState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceModelPlatformService.1
      bool success = true;
      ::base::Uuid p_uuid{};
      OnDeviceModelPlatformService_GetPlatformModelState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModelPlatformService::Name_, 1, false);
        return false;
      }
      auto callback =
          OnDeviceModelPlatformService_GetPlatformModelState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPlatformModelState(        
        std::move(p_uuid), std::move(callback));
      return true;
    }
    case messages::OnDeviceModelPlatformService::kGetEstimatedPerformanceClass: {
      internal::OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceModelPlatformService.2
      bool success = true;
      OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModelPlatformService::Name_, 2, false);
        return false;
      }
      auto callback =
          OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEstimatedPerformanceClass(std::move(callback));
      return true;
    }
    case messages::OnDeviceModelPlatformService::kFormatInput: {
      internal::OnDeviceModelPlatformService_FormatInput_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceModelPlatformService_FormatInput_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceModelPlatformService.3
      bool success = true;
      ::base::Uuid p_uuid{};
      FormatFeature p_feature{};
      base::flat_map<std::string, std::string> p_fields{};
      OnDeviceModelPlatformService_FormatInput_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (success && !input_data_view.ReadFields(&p_fields))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModelPlatformService::Name_, 3, false);
        return false;
      }
      auto callback =
          OnDeviceModelPlatformService_FormatInput_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FormatInput(        
        std::move(p_uuid), 
        std::move(p_feature), 
        std::move(p_fields), std::move(callback));
      return true;
    }
    case messages::OnDeviceModelPlatformService::kValidateSafetyResult: {
      internal::OnDeviceModelPlatformService_ValidateSafetyResult_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceModelPlatformService_ValidateSafetyResult_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceModelPlatformService.4
      bool success = true;
      SafetyFeature p_safety_feature{};
      std::string p_text{};
      ::on_device_model::mojom::SafetyInfoPtr p_safety_info{};
      OnDeviceModelPlatformService_ValidateSafetyResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSafetyFeature(&p_safety_feature))
        success = false;
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadSafetyInfo(&p_safety_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModelPlatformService::Name_, 4, false);
        return false;
      }
      auto callback =
          OnDeviceModelPlatformService_ValidateSafetyResult_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ValidateSafetyResult(        
        std::move(p_safety_feature), 
        std::move(p_text), 
        std::move(p_safety_info), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOnDeviceModelPlatformServiceValidationInfo[] = {
    { &internal::OnDeviceModelPlatformService_LoadPlatformModel_Params_Data::Validate,
     &internal::OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams_Data::Validate},
    { &internal::OnDeviceModelPlatformService_GetPlatformModelState_Params_Data::Validate,
     &internal::OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams_Data::Validate},
    { &internal::OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params_Data::Validate,
     &internal::OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams_Data::Validate},
    { &internal::OnDeviceModelPlatformService_FormatInput_Params_Data::Validate,
     &internal::OnDeviceModelPlatformService_FormatInput_ResponseParams_Data::Validate},
    { &internal::OnDeviceModelPlatformService_ValidateSafetyResult_Params_Data::Validate,
     &internal::OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams_Data::Validate},
};

bool OnDeviceModelPlatformServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_model::mojom::OnDeviceModelPlatformService::Name_,
    kOnDeviceModelPlatformServiceValidationInfo);
}

bool OnDeviceModelPlatformServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::on_device_model::mojom::OnDeviceModelPlatformService::Name_,
    kOnDeviceModelPlatformServiceValidationInfo);
}


}  // on_device_model::mojom


namespace mojo {


// static
bool StructTraits<::on_device_model::mojom::ModelAssets::DataView, ::on_device_model::mojom::ModelAssetsPtr>::Read(
    ::on_device_model::mojom::ModelAssets::DataView input,
    ::on_device_model::mojom::ModelAssetsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::ModelAssetsPtr result(::on_device_model::mojom::ModelAssets::New());
  
      if (success && !input.ReadWeights(&result->weights))
        success = false;
      if (success && !input.ReadSpModelPath(&result->sp_model_path))
        success = false;
      if (success && !input.ReadCache(&result->cache))
        success = false;
      if (success && !input.ReadEncoderCache(&result->encoder_cache))
        success = false;
      if (success && !input.ReadAdapterCache(&result->adapter_cache))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::LoadModelParams::DataView, ::on_device_model::mojom::LoadModelParamsPtr>::Read(
    ::on_device_model::mojom::LoadModelParams::DataView input,
    ::on_device_model::mojom::LoadModelParamsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::LoadModelParamsPtr result(::on_device_model::mojom::LoadModelParams::New());
  
      if (success && !input.ReadBackendType(&result->backend_type))
        success = false;
      if (success && !input.ReadAssets(&result->assets))
        success = false;
      if (success)
        result->max_tokens = input.max_tokens();
      if (success && !input.ReadAdaptationRanks(&result->adaptation_ranks))
        success = false;
      if (success && !input.ReadPerformanceHint(&result->performance_hint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::TextSafetyModelAssets::DataView, ::on_device_model::mojom::TextSafetyModelAssetsPtr>::Read(
    ::on_device_model::mojom::TextSafetyModelAssets::DataView input,
    ::on_device_model::mojom::TextSafetyModelAssetsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::TextSafetyModelAssetsPtr result(::on_device_model::mojom::TextSafetyModelAssets::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadSpModel(&result->sp_model))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::BertSafetyModelAssets::DataView, ::on_device_model::mojom::BertSafetyModelAssetsPtr>::Read(
    ::on_device_model::mojom::BertSafetyModelAssets::DataView input,
    ::on_device_model::mojom::BertSafetyModelAssetsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::BertSafetyModelAssetsPtr result(::on_device_model::mojom::BertSafetyModelAssets::New());
  
      if (success && !input.ReadModel(&result->model))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::LanguageModelAssets::DataView, ::on_device_model::mojom::LanguageModelAssetsPtr>::Read(
    ::on_device_model::mojom::LanguageModelAssets::DataView input,
    ::on_device_model::mojom::LanguageModelAssetsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::LanguageModelAssetsPtr result(::on_device_model::mojom::LanguageModelAssets::New());
  
      if (success && !input.ReadModel(&result->model))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::TextSafetyModelParams::DataView, ::on_device_model::mojom::TextSafetyModelParamsPtr>::Read(
    ::on_device_model::mojom::TextSafetyModelParams::DataView input,
    ::on_device_model::mojom::TextSafetyModelParamsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::TextSafetyModelParamsPtr result(::on_device_model::mojom::TextSafetyModelParams::New());
  
      if (success && !input.ReadSafetyAssets(&result->safety_assets))
        success = false;
      if (success && !input.ReadLanguageAssets(&result->language_assets))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::on_device_model::mojom::ModelFile::DataView, ::on_device_model::mojom::ModelFilePtr>::Read(
    ::on_device_model::mojom::ModelFile::DataView input,
    ::on_device_model::mojom::ModelFilePtr* output) {
  using UnionType = ::on_device_model::mojom::ModelFile;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFile: {
      ::base::File result_file{};
      if (!input.ReadFile(&result_file))
        return false;

      *output = UnionType::NewFile(
          std::move(result_file));
      break;
    }
    case Tag::kPath: {
      ::base::FilePath result_path{};
      if (!input.ReadPath(&result_path))
        return false;

      *output = UnionType::NewPath(
          std::move(result_path));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::on_device_model::mojom::SafetyModelAssets::DataView, ::on_device_model::mojom::SafetyModelAssetsPtr>::Read(
    ::on_device_model::mojom::SafetyModelAssets::DataView input,
    ::on_device_model::mojom::SafetyModelAssetsPtr* output) {
  using UnionType = ::on_device_model::mojom::SafetyModelAssets;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kTsAssets: {
      ::on_device_model::mojom::TextSafetyModelAssetsPtr result_ts_assets{};
      if (!input.ReadTsAssets(&result_ts_assets))
        return false;

      *output = UnionType::NewTsAssets(
          std::move(result_ts_assets));
      break;
    }
    case Tag::kBsAssets: {
      ::on_device_model::mojom::BertSafetyModelAssetsPtr result_bs_assets{};
      if (!input.ReadBsAssets(&result_bs_assets))
        return false;

      *output = UnionType::NewBsAssets(
          std::move(result_bs_assets));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace on_device_model::mojom {


void PlatformModelProgressObserverInterceptorForTesting::Progress(double progress) {
  GetForwardingInterface()->Progress(
    std::move(progress)
    );
}
PlatformModelProgressObserverAsyncWaiter::PlatformModelProgressObserverAsyncWaiter(
    PlatformModelProgressObserver* proxy) : proxy_(proxy) {}

PlatformModelProgressObserverAsyncWaiter::~PlatformModelProgressObserverAsyncWaiter() = default;





void OnDeviceModelServiceInterceptorForTesting::LoadModel(LoadModelParamsPtr params, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, LoadModelCallback callback) {
  GetForwardingInterface()->LoadModel(
    std::move(params)
    , 
    std::move(model)
    , std::move(callback));
}
void OnDeviceModelServiceInterceptorForTesting::GetCapabilities(::on_device_model::ModelFile weights, GetCapabilitiesCallback callback) {
  GetForwardingInterface()->GetCapabilities(
    std::move(weights)
    , std::move(callback));
}
void OnDeviceModelServiceInterceptorForTesting::LoadTextSafetyModel(TextSafetyModelParamsPtr params, ::mojo::PendingReceiver<::on_device_model::mojom::TextSafetyModel> model) {
  GetForwardingInterface()->LoadTextSafetyModel(
    std::move(params)
    , 
    std::move(model)
    );
}
void OnDeviceModelServiceInterceptorForTesting::GetDeviceAndPerformanceInfo(GetDeviceAndPerformanceInfoCallback callback) {
  GetForwardingInterface()->GetDeviceAndPerformanceInfo(std::move(callback));
}
OnDeviceModelServiceAsyncWaiter::OnDeviceModelServiceAsyncWaiter(
    OnDeviceModelService* proxy) : proxy_(proxy) {}

OnDeviceModelServiceAsyncWaiter::~OnDeviceModelServiceAsyncWaiter() = default;


void OnDeviceModelServiceAsyncWaiter::LoadModel(
    LoadModelParamsPtr params, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, ::on_device_model::mojom::LoadModelResult* out_result) {
  base::RunLoop loop;
  proxy_->LoadModel(
      std::move(params),
      std::move(model),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::on_device_model::mojom::LoadModelResult* out_result
,
             ::on_device_model::mojom::LoadModelResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::on_device_model::mojom::LoadModelResult OnDeviceModelServiceAsyncWaiter::LoadModel(
    LoadModelParamsPtr params, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model) {
  ::on_device_model::mojom::LoadModelResult async_wait_result;
  LoadModel(std::move(params),std::move(model),&async_wait_result);
  return async_wait_result;
}

void OnDeviceModelServiceAsyncWaiter::GetCapabilities(
    ::on_device_model::ModelFile weights, ::on_device_model::Capabilities* out_capabilities) {
  base::RunLoop loop;
  proxy_->GetCapabilities(
      std::move(weights),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::on_device_model::Capabilities* out_capabilities
,
             const ::on_device_model::Capabilities& capabilities) {*out_capabilities = std::move(capabilities);
            loop->Quit();
          },
          &loop,
          out_capabilities));
  loop.Run();
}

::on_device_model::Capabilities OnDeviceModelServiceAsyncWaiter::GetCapabilities(
    ::on_device_model::ModelFile weights) {
  ::on_device_model::Capabilities async_wait_result;
  GetCapabilities(std::move(weights),&async_wait_result);
  return async_wait_result;
}

void OnDeviceModelServiceAsyncWaiter::GetDeviceAndPerformanceInfo(
    ::on_device_model::mojom::DevicePerformanceInfoPtr* out_performanceInfo, ::on_device_model::mojom::DeviceInfoPtr* out_device_info) {
  base::RunLoop loop;
  proxy_->GetDeviceAndPerformanceInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::on_device_model::mojom::DevicePerformanceInfoPtr* out_performanceInfo
,
             ::on_device_model::mojom::DeviceInfoPtr* out_device_info
,
             ::on_device_model::mojom::DevicePerformanceInfoPtr performanceInfo,
             ::on_device_model::mojom::DeviceInfoPtr device_info) {*out_performanceInfo = std::move(performanceInfo);*out_device_info = std::move(device_info);
            loop->Quit();
          },
          &loop,
          out_performanceInfo,
          out_device_info));
  loop.Run();
}






void OnDeviceModelPlatformServiceInterceptorForTesting::LoadPlatformModel(const ::base::Uuid& uuid, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, ::mojo::PendingRemote<PlatformModelProgressObserver> progress_observer, LoadPlatformModelCallback callback) {
  GetForwardingInterface()->LoadPlatformModel(
    std::move(uuid)
    , 
    std::move(model)
    , 
    std::move(progress_observer)
    , std::move(callback));
}
void OnDeviceModelPlatformServiceInterceptorForTesting::GetPlatformModelState(const ::base::Uuid& uuid, GetPlatformModelStateCallback callback) {
  GetForwardingInterface()->GetPlatformModelState(
    std::move(uuid)
    , std::move(callback));
}
void OnDeviceModelPlatformServiceInterceptorForTesting::GetEstimatedPerformanceClass(GetEstimatedPerformanceClassCallback callback) {
  GetForwardingInterface()->GetEstimatedPerformanceClass(std::move(callback));
}
void OnDeviceModelPlatformServiceInterceptorForTesting::FormatInput(const ::base::Uuid& uuid, FormatFeature feature, const base::flat_map<std::string, std::string>& fields, FormatInputCallback callback) {
  GetForwardingInterface()->FormatInput(
    std::move(uuid)
    , 
    std::move(feature)
    , 
    std::move(fields)
    , std::move(callback));
}
void OnDeviceModelPlatformServiceInterceptorForTesting::ValidateSafetyResult(SafetyFeature safety_feature, const std::string& text, ::on_device_model::mojom::SafetyInfoPtr safety_info, ValidateSafetyResultCallback callback) {
  GetForwardingInterface()->ValidateSafetyResult(
    std::move(safety_feature)
    , 
    std::move(text)
    , 
    std::move(safety_info)
    , std::move(callback));
}
OnDeviceModelPlatformServiceAsyncWaiter::OnDeviceModelPlatformServiceAsyncWaiter(
    OnDeviceModelPlatformService* proxy) : proxy_(proxy) {}

OnDeviceModelPlatformServiceAsyncWaiter::~OnDeviceModelPlatformServiceAsyncWaiter() = default;


void OnDeviceModelPlatformServiceAsyncWaiter::LoadPlatformModel(
    const ::base::Uuid& uuid, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, ::mojo::PendingRemote<PlatformModelProgressObserver> progress_observer, ::on_device_model::mojom::LoadModelResult* out_result) {
  base::RunLoop loop;
  proxy_->LoadPlatformModel(
      std::move(uuid),
      std::move(model),
      std::move(progress_observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::on_device_model::mojom::LoadModelResult* out_result
,
             ::on_device_model::mojom::LoadModelResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::on_device_model::mojom::LoadModelResult OnDeviceModelPlatformServiceAsyncWaiter::LoadPlatformModel(
    const ::base::Uuid& uuid, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, ::mojo::PendingRemote<PlatformModelProgressObserver> progress_observer) {
  ::on_device_model::mojom::LoadModelResult async_wait_result;
  LoadPlatformModel(std::move(uuid),std::move(model),std::move(progress_observer),&async_wait_result);
  return async_wait_result;
}

void OnDeviceModelPlatformServiceAsyncWaiter::GetPlatformModelState(
    const ::base::Uuid& uuid, PlatformModelState* out_result) {
  base::RunLoop loop;
  proxy_->GetPlatformModelState(
      std::move(uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             PlatformModelState* out_result
,
             PlatformModelState result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

PlatformModelState OnDeviceModelPlatformServiceAsyncWaiter::GetPlatformModelState(
    const ::base::Uuid& uuid) {
  PlatformModelState async_wait_result;
  GetPlatformModelState(std::move(uuid),&async_wait_result);
  return async_wait_result;
}

void OnDeviceModelPlatformServiceAsyncWaiter::GetEstimatedPerformanceClass(
    ::on_device_model::mojom::PerformanceClass* out_performance_class) {
  base::RunLoop loop;
  proxy_->GetEstimatedPerformanceClass(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::on_device_model::mojom::PerformanceClass* out_performance_class
,
             ::on_device_model::mojom::PerformanceClass performance_class) {*out_performance_class = std::move(performance_class);
            loop->Quit();
          },
          &loop,
          out_performance_class));
  loop.Run();
}

::on_device_model::mojom::PerformanceClass OnDeviceModelPlatformServiceAsyncWaiter::GetEstimatedPerformanceClass(
    ) {
  ::on_device_model::mojom::PerformanceClass async_wait_result;
  GetEstimatedPerformanceClass(&async_wait_result);
  return async_wait_result;
}

void OnDeviceModelPlatformServiceAsyncWaiter::FormatInput(
    const ::base::Uuid& uuid, FormatFeature feature, const base::flat_map<std::string, std::string>& fields, std::optional<std::string>* out_result) {
  base::RunLoop loop;
  proxy_->FormatInput(
      std::move(uuid),
      std::move(feature),
      std::move(fields),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_result
,
             const std::optional<std::string>& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

std::optional<std::string> OnDeviceModelPlatformServiceAsyncWaiter::FormatInput(
    const ::base::Uuid& uuid, FormatFeature feature, const base::flat_map<std::string, std::string>& fields) {
  std::optional<std::string> async_wait_result;
  FormatInput(std::move(uuid),std::move(feature),std::move(fields),&async_wait_result);
  return async_wait_result;
}

void OnDeviceModelPlatformServiceAsyncWaiter::ValidateSafetyResult(
    SafetyFeature safety_feature, const std::string& text, ::on_device_model::mojom::SafetyInfoPtr safety_info, bool* out_result) {
  base::RunLoop loop;
  proxy_->ValidateSafetyResult(
      std::move(safety_feature),
      std::move(text),
      std::move(safety_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool OnDeviceModelPlatformServiceAsyncWaiter::ValidateSafetyResult(
    SafetyFeature safety_feature, const std::string& text, ::on_device_model::mojom::SafetyInfoPtr safety_info) {
  bool async_wait_result;
  ValidateSafetyResult(std::move(safety_feature),std::move(text),std::move(safety_info),&async_wait_result);
  return async_wait_result;
}






}  // on_device_model::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif