// services/network/public/mojom/websocket.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/websocket.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"

#include "services/network/public/mojom/websocket.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::WebSocketMessageType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::HttpHeaderDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HttpHeaderDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HttpHeader_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in HttpHeader struct");

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in HttpHeader struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::WebSocketHandshakeRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebSocketHandshakeRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebSocketHandshakeRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in WebSocketHandshakeRequest struct");

      decltype(Traits::headers(input)) in_headers = Traits::headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->headers)::BaseType>
          headers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpHeaderDataView>, send_validation>(
        in_headers,
        headers_fragment,
        &headers_validate_params);

      fragment->headers.Set(
          headers_fragment.is_null() ? nullptr : headers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->headers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in WebSocketHandshakeRequest struct");

      decltype(Traits::headers_text(input)) in_headers_text = Traits::headers_text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->headers_text)::BaseType> headers_text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_headers_text,
        headers_text_fragment);

      fragment->headers_text.Set(
          headers_text_fragment.is_null() ? nullptr : headers_text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->headers_text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers_text in WebSocketHandshakeRequest struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::WebSocketHandshakeResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebSocketHandshakeResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebSocketHandshakeResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in WebSocketHandshakeResponse struct");

      decltype(Traits::http_version(input)) in_http_version = Traits::http_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->http_version)::BaseType> http_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::HttpVersionDataView, send_validation>(
        in_http_version,
        http_version_fragment);

      fragment->http_version.Set(
          http_version_fragment.is_null() ? nullptr : http_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->http_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null http_version in WebSocketHandshakeResponse struct");

      fragment->status_code = Traits::status_code(input);

      decltype(Traits::status_text(input)) in_status_text = Traits::status_text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->status_text)::BaseType> status_text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_status_text,
        status_text_fragment);

      fragment->status_text.Set(
          status_text_fragment.is_null() ? nullptr : status_text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->status_text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null status_text in WebSocketHandshakeResponse struct");

      decltype(Traits::remote_endpoint(input)) in_remote_endpoint = Traits::remote_endpoint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->remote_endpoint)::BaseType> remote_endpoint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IPEndPointDataView, send_validation>(
        in_remote_endpoint,
        remote_endpoint_fragment);

      fragment->remote_endpoint.Set(
          remote_endpoint_fragment.is_null() ? nullptr : remote_endpoint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->remote_endpoint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null remote_endpoint in WebSocketHandshakeResponse struct");

      decltype(Traits::headers(input)) in_headers = Traits::headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->headers)::BaseType>
          headers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpHeaderDataView>, send_validation>(
        in_headers,
        headers_fragment,
        &headers_validate_params);

      fragment->headers.Set(
          headers_fragment.is_null() ? nullptr : headers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->headers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in WebSocketHandshakeResponse struct");

      decltype(Traits::headers_text(input)) in_headers_text = Traits::headers_text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->headers_text)::BaseType> headers_text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_headers_text,
        headers_text_fragment);

      fragment->headers_text.Set(
          headers_text_fragment.is_null() ? nullptr : headers_text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->headers_text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers_text in WebSocketHandshakeResponse struct");

      decltype(Traits::selected_protocol(input)) in_selected_protocol = Traits::selected_protocol(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->selected_protocol)::BaseType> selected_protocol_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_selected_protocol,
        selected_protocol_fragment);

      fragment->selected_protocol.Set(
          selected_protocol_fragment.is_null() ? nullptr : selected_protocol_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->selected_protocol.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selected_protocol in WebSocketHandshakeResponse struct");

      decltype(Traits::extensions(input)) in_extensions = Traits::extensions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extensions)::BaseType> extensions_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_extensions,
        extensions_fragment);

      fragment->extensions.Set(
          extensions_fragment.is_null() ? nullptr : extensions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->extensions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extensions in WebSocketHandshakeResponse struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_SEND_VALIDATION_H_