// services/network/public/mojom/websocket.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  WebSocketAuthenticationHandler_OnAuthRequired_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::AuthChallengeInfo_Data> info;
  mojo::internal::Pointer<::network::mojom::internal::HttpResponseHeaders_Data> headers;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> remote_endpoint;

 private:
  friend class mojo::internal::MessageFragment<WebSocketAuthenticationHandler_OnAuthRequired_Params_Data>;

  WebSocketAuthenticationHandler_OnAuthRequired_Params_Data();
  ~WebSocketAuthenticationHandler_OnAuthRequired_Params_Data() = delete;
};
static_assert(sizeof(WebSocketAuthenticationHandler_OnAuthRequired_Params_Data) == 32,
              "Bad sizeof(WebSocketAuthenticationHandler_OnAuthRequired_Params_Data)");
class  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::AuthCredentials_Data> credentials;

 private:
  friend class mojo::internal::MessageFragment<WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data>;

  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data();
  ~WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data() = delete;
};
static_assert(sizeof(WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data) == 16,
              "Bad sizeof(WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data)");
class  WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebSocketHandshakeRequest_Data> request;

 private:
  friend class mojo::internal::MessageFragment<WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data>;

  WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data();
  ~WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data() = delete;
};
static_assert(sizeof(WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data) == 16,
              "Bad sizeof(WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data)");
class  WebSocketHandshakeClient_OnFailure_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> message;
  int32_t net_error;
  int32_t response_code;

 private:
  friend class mojo::internal::MessageFragment<WebSocketHandshakeClient_OnFailure_Params_Data>;

  WebSocketHandshakeClient_OnFailure_Params_Data();
  ~WebSocketHandshakeClient_OnFailure_Params_Data() = delete;
};
static_assert(sizeof(WebSocketHandshakeClient_OnFailure_Params_Data) == 24,
              "Bad sizeof(WebSocketHandshakeClient_OnFailure_Params_Data)");
class  WebSocketHandshakeClient_OnConnectionEstablished_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data socket;
  mojo::internal::Handle_Data client_receiver;
  mojo::internal::Handle_Data readable;
  mojo::internal::Pointer<internal::WebSocketHandshakeResponse_Data> response;
  mojo::internal::Handle_Data writable;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<WebSocketHandshakeClient_OnConnectionEstablished_Params_Data>;

  WebSocketHandshakeClient_OnConnectionEstablished_Params_Data();
  ~WebSocketHandshakeClient_OnConnectionEstablished_Params_Data() = delete;
};
static_assert(sizeof(WebSocketHandshakeClient_OnConnectionEstablished_Params_Data) == 40,
              "Bad sizeof(WebSocketHandshakeClient_OnConnectionEstablished_Params_Data)");
class  WebSocketClient_OnDataFrame_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t fin : 1;
  uint8_t pad0_[3];
  int32_t type;
  uint64_t data_length;

 private:
  friend class mojo::internal::MessageFragment<WebSocketClient_OnDataFrame_Params_Data>;

  WebSocketClient_OnDataFrame_Params_Data();
  ~WebSocketClient_OnDataFrame_Params_Data() = delete;
};
static_assert(sizeof(WebSocketClient_OnDataFrame_Params_Data) == 24,
              "Bad sizeof(WebSocketClient_OnDataFrame_Params_Data)");
class  WebSocketClient_OnDropChannel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t was_clean : 1;
  uint8_t pad0_[1];
  uint16_t code;
  uint8_t pad1_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> reason;

 private:
  friend class mojo::internal::MessageFragment<WebSocketClient_OnDropChannel_Params_Data>;

  WebSocketClient_OnDropChannel_Params_Data();
  ~WebSocketClient_OnDropChannel_Params_Data() = delete;
};
static_assert(sizeof(WebSocketClient_OnDropChannel_Params_Data) == 24,
              "Bad sizeof(WebSocketClient_OnDropChannel_Params_Data)");
class  WebSocketClient_OnClosingHandshake_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<WebSocketClient_OnClosingHandshake_Params_Data>;

  WebSocketClient_OnClosingHandshake_Params_Data();
  ~WebSocketClient_OnClosingHandshake_Params_Data() = delete;
};
static_assert(sizeof(WebSocketClient_OnClosingHandshake_Params_Data) == 8,
              "Bad sizeof(WebSocketClient_OnClosingHandshake_Params_Data)");
class  WebSocket_SendMessage_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  uint64_t data_length;

 private:
  friend class mojo::internal::MessageFragment<WebSocket_SendMessage_Params_Data>;

  WebSocket_SendMessage_Params_Data();
  ~WebSocket_SendMessage_Params_Data() = delete;
};
static_assert(sizeof(WebSocket_SendMessage_Params_Data) == 24,
              "Bad sizeof(WebSocket_SendMessage_Params_Data)");
class  WebSocket_StartReceiving_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<WebSocket_StartReceiving_Params_Data>;

  WebSocket_StartReceiving_Params_Data();
  ~WebSocket_StartReceiving_Params_Data() = delete;
};
static_assert(sizeof(WebSocket_StartReceiving_Params_Data) == 8,
              "Bad sizeof(WebSocket_StartReceiving_Params_Data)");
class  WebSocket_StartClosingHandshake_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint16_t code;
  uint8_t pad0_[6];
  mojo::internal::Pointer<mojo::internal::String_Data> reason;

 private:
  friend class mojo::internal::MessageFragment<WebSocket_StartClosingHandshake_Params_Data>;

  WebSocket_StartClosingHandshake_Params_Data();
  ~WebSocket_StartClosingHandshake_Params_Data() = delete;
};
static_assert(sizeof(WebSocket_StartClosingHandshake_Params_Data) == 24,
              "Bad sizeof(WebSocket_StartClosingHandshake_Params_Data)");

}  // namespace internal


class WebSocketAuthenticationHandler_OnAuthRequired_ParamsDataView {
 public:
  WebSocketAuthenticationHandler_OnAuthRequired_ParamsDataView() = default;

  WebSocketAuthenticationHandler_OnAuthRequired_ParamsDataView(
      internal::WebSocketAuthenticationHandler_OnAuthRequired_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      ::network::mojom::AuthChallengeInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::network::mojom::AuthChallengeInfoDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      ::network::mojom::HttpResponseHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpResponseHeadersDataView>(
        pointer, output, message_);
  }
  inline void GetRemoteEndpointDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteEndpoint(UserType* output) {
    
    auto* pointer = data_->remote_endpoint.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebSocketAuthenticationHandler_OnAuthRequired_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsDataView {
 public:
  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsDataView() = default;

  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsDataView(
      internal::WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCredentialsDataView(
      ::network::mojom::AuthCredentialsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentials(UserType* output) {
    
    auto* pointer = data_->credentials.Get();
    return mojo::internal::Deserialize<::network::mojom::AuthCredentialsDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsDataView {
 public:
  WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsDataView() = default;

  WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsDataView(
      internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestDataView(
      WebSocketHandshakeRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::network::mojom::WebSocketHandshakeRequestDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebSocketHandshakeClient_OnFailure_ParamsDataView {
 public:
  WebSocketHandshakeClient_OnFailure_ParamsDataView() = default;

  WebSocketHandshakeClient_OnFailure_ParamsDataView(
      internal::WebSocketHandshakeClient_OnFailure_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t net_error() const {
    return data_->net_error;
  }
  int32_t response_code() const {
    return data_->response_code;
  }
 private:
  internal::WebSocketHandshakeClient_OnFailure_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebSocketHandshakeClient_OnConnectionEstablished_ParamsDataView {
 public:
  WebSocketHandshakeClient_OnConnectionEstablished_ParamsDataView() = default;

  WebSocketHandshakeClient_OnConnectionEstablished_ParamsDataView(
      internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSocket() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::WebSocketInterfaceBase>>(
            &data_->socket, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::WebSocketClientInterfaceBase>>(
            &data_->client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetResponseDataView(
      WebSocketHandshakeResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::network::mojom::WebSocketHandshakeResponseDataView>(
        pointer, output, message_);
  }
  mojo::ScopedDataPipeConsumerHandle TakeReadable() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->readable, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeProducerHandle TakeWritable() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->writable, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebSocketClient_OnDataFrame_ParamsDataView {
 public:
  WebSocketClient_OnDataFrame_ParamsDataView() = default;

  WebSocketClient_OnDataFrame_ParamsDataView(
      internal::WebSocketClient_OnDataFrame_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool fin() const {
    return data_->fin;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::WebSocketMessageType>(
        data_value, output);
  }
  WebSocketMessageType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::WebSocketMessageType>(data_->type));
  }
  uint64_t data_length() const {
    return data_->data_length;
  }
 private:
  internal::WebSocketClient_OnDataFrame_Params_Data* data_ = nullptr;
};


class WebSocketClient_OnDropChannel_ParamsDataView {
 public:
  WebSocketClient_OnDropChannel_ParamsDataView() = default;

  WebSocketClient_OnDropChannel_ParamsDataView(
      internal::WebSocketClient_OnDropChannel_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool was_clean() const {
    return data_->was_clean;
  }
  uint16_t code() const {
    return data_->code;
  }
  inline void GetReasonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) {
    
    auto* pointer = data_->reason.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebSocketClient_OnDropChannel_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebSocketClient_OnClosingHandshake_ParamsDataView {
 public:
  WebSocketClient_OnClosingHandshake_ParamsDataView() = default;

  WebSocketClient_OnClosingHandshake_ParamsDataView(
      internal::WebSocketClient_OnClosingHandshake_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::WebSocketClient_OnClosingHandshake_Params_Data* data_ = nullptr;
};


class WebSocket_SendMessage_ParamsDataView {
 public:
  WebSocket_SendMessage_ParamsDataView() = default;

  WebSocket_SendMessage_ParamsDataView(
      internal::WebSocket_SendMessage_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::WebSocketMessageType>(
        data_value, output);
  }
  WebSocketMessageType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::WebSocketMessageType>(data_->type));
  }
  uint64_t data_length() const {
    return data_->data_length;
  }
 private:
  internal::WebSocket_SendMessage_Params_Data* data_ = nullptr;
};


class WebSocket_StartReceiving_ParamsDataView {
 public:
  WebSocket_StartReceiving_ParamsDataView() = default;

  WebSocket_StartReceiving_ParamsDataView(
      internal::WebSocket_StartReceiving_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::WebSocket_StartReceiving_Params_Data* data_ = nullptr;
};


class WebSocket_StartClosingHandshake_ParamsDataView {
 public:
  WebSocket_StartClosingHandshake_ParamsDataView() = default;

  WebSocket_StartClosingHandshake_ParamsDataView(
      internal::WebSocket_StartClosingHandshake_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint16_t code() const {
    return data_->code;
  }
  inline void GetReasonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) {
    
    auto* pointer = data_->reason.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebSocket_StartClosingHandshake_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void WebSocketAuthenticationHandler_OnAuthRequired_ParamsDataView::GetInfoDataView(
    ::network::mojom::AuthChallengeInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = ::network::mojom::AuthChallengeInfoDataView(pointer, message_);
}
inline void WebSocketAuthenticationHandler_OnAuthRequired_ParamsDataView::GetHeadersDataView(
    ::network::mojom::HttpResponseHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = ::network::mojom::HttpResponseHeadersDataView(pointer, message_);
}
inline void WebSocketAuthenticationHandler_OnAuthRequired_ParamsDataView::GetRemoteEndpointDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->remote_endpoint.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}


inline void WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsDataView::GetCredentialsDataView(
    ::network::mojom::AuthCredentialsDataView* output) {
  auto pointer = data_->credentials.Get();
  *output = ::network::mojom::AuthCredentialsDataView(pointer, message_);
}


inline void WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsDataView::GetRequestDataView(
    WebSocketHandshakeRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = WebSocketHandshakeRequestDataView(pointer, message_);
}


inline void WebSocketHandshakeClient_OnFailure_ParamsDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebSocketHandshakeClient_OnConnectionEstablished_ParamsDataView::GetResponseDataView(
    WebSocketHandshakeResponseDataView* output) {
  auto pointer = data_->response.Get();
  *output = WebSocketHandshakeResponseDataView(pointer, message_);
}




inline void WebSocketClient_OnDropChannel_ParamsDataView::GetReasonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reason.Get();
  *output = mojo::StringDataView(pointer, message_);
}








inline void WebSocket_StartClosingHandshake_ParamsDataView::GetReasonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reason.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_PARAMS_DATA_H_