// services/network/public/mojom/url_response_head.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec,
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  AlternateProtocolUsage as network_mojom_AlternateProtocolUsage,
  AlternateProtocolUsageSpec as network_mojom_AlternateProtocolUsageSpec
} from './alternate_protocol_usage.mojom.m.js';

import {
  PrivateNetworkAccessPreflightResult as network_mojom_PrivateNetworkAccessPreflightResult,
  PrivateNetworkAccessPreflightResultSpec as network_mojom_PrivateNetworkAccessPreflightResultSpec
} from './cors.mojom.m.js';

import {
  DeviceBoundSessionUsage as network_mojom_DeviceBoundSessionUsage,
  DeviceBoundSessionUsageSpec as network_mojom_DeviceBoundSessionUsageSpec
} from './device_bound_sessions.mojom.m.js';

import {
  EncodedBodyLength as network_mojom_EncodedBodyLength,
  EncodedBodyLengthSpec as network_mojom_EncodedBodyLengthSpec
} from './encoded_body_length.mojom.m.js';

import {
  FetchResponseSource as network_mojom_FetchResponseSource,
  FetchResponseSourceSpec as network_mojom_FetchResponseSourceSpec,
  FetchResponseType as network_mojom_FetchResponseType,
  FetchResponseTypeSpec as network_mojom_FetchResponseTypeSpec
} from './fetch_api.mojom.m.js';

import {
  IPAddressSpace as network_mojom_IPAddressSpace,
  IPAddressSpaceSpec as network_mojom_IPAddressSpaceSpec
} from './ip_address_space.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from './ip_endpoint.mojom.m.js';

import {
  LoadTimingInfo as network_mojom_LoadTimingInfo,
  LoadTimingInfoSpec as network_mojom_LoadTimingInfoSpec
} from './load_timing_info.mojom.m.js';

import {
  LoadTimingInternalInfo as network_mojom_LoadTimingInternalInfo,
  LoadTimingInternalInfoSpec as network_mojom_LoadTimingInternalInfoSpec
} from './load_timing_internal_info.mojom.m.js';

import {
  AuthChallengeInfo as network_mojom_AuthChallengeInfo,
  AuthChallengeInfoSpec as network_mojom_AuthChallengeInfoSpec,
  HttpResponseHeaders as network_mojom_HttpResponseHeaders,
  HttpResponseHeadersSpec as network_mojom_HttpResponseHeadersSpec,
  ProxyChain as network_mojom_ProxyChain,
  ProxyChainSpec as network_mojom_ProxyChainSpec,
  SSLInfo as network_mojom_SSLInfo,
  SSLInfoSpec as network_mojom_SSLInfoSpec
} from './network_param.mojom.m.js';

import {
  ConnectionInfo as network_mojom_ConnectionInfo,
  ConnectionInfoSpec as network_mojom_ConnectionInfoSpec
} from './network_types.mojom.m.js';

import {
  ParsedHeaders as network_mojom_ParsedHeaders,
  ParsedHeadersSpec as network_mojom_ParsedHeadersSpec
} from './parsed_headers.mojom.m.js';

import {
  ParsedRequestCookie as network_mojom_ParsedRequestCookie,
  ParsedRequestCookieSpec as network_mojom_ParsedRequestCookieSpec
} from './parsed_request_cookie.mojom.m.js';

import {
  ServiceWorkerStatus as network_mojom_ServiceWorkerStatus,
  ServiceWorkerStatusSpec as network_mojom_ServiceWorkerStatusSpec,
  ServiceWorkerRouterInfo as network_mojom_ServiceWorkerRouterInfo,
  ServiceWorkerRouterInfoSpec as network_mojom_ServiceWorkerRouterInfoSpec
} from './service_worker_router_info.mojom.m.js';

import {
  SourceType as network_mojom_SourceType,
  SourceTypeSpec as network_mojom_SourceTypeSpec
} from './source_type.mojom.m.js';

import {
  UnencodedDigests as network_mojom_UnencodedDigests,
  UnencodedDigestsSpec as network_mojom_UnencodedDigestsSpec
} from './unencoded_digest.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const NavigationDeliveryTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const NavigationDeliveryType = {
  
  kDefault: 0,
  kNavigationalPrefetch: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLResponseHeadSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    URLResponseHeadSpec.$,
    'URLResponseHead',
    [
      mojo.internal.StructField(
        'requestTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originalResponseTime', 16,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 24,
        0,
        network_mojom_HttpResponseHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mimeType', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'charset', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentLength', 48,
        0,
        mojo.internal.Int64,
        BigInt('-1'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encodedDataLength', 56,
        0,
        mojo.internal.Int64,
        BigInt('-1'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encodedBodyLength', 64,
        0,
        network_mojom_EncodedBodyLengthSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAccessed', 72,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'loadTiming', 80,
        0,
        network_mojom_LoadTimingInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'loadTimingInternalInfo', 88,
        0,
        network_mojom_LoadTimingInternalInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'emittedExtraInfo', 72,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasFetchedViaSpdy', 72,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasAlpnNegotiated', 72,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasAlternateProtocolAvailable', 72,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectionInfo', 76,
        0,
        network_mojom_ConnectionInfoSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alpnNegotiatedProtocol', 96,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alternateProtocolUsage', 104,
        0,
        network_mojom_AlternateProtocolUsageSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 112,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientAddressSpace', 108,
        0,
        network_mojom_IPAddressSpaceSpec.$,
        network_mojom_IPAddressSpace.kUnknown,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseAddressSpace', 120,
        0,
        network_mojom_IPAddressSpaceSpec.$,
        network_mojom_IPAddressSpace.kUnknown,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isValidated', 72,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasFetchedViaCache', 72,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationDeliveryType', 124,
        0,
        NavigationDeliveryTypeSpec.$,
        NavigationDeliveryType.kDefault,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'proxyChain', 128,
        0,
        network_mojom_ProxyChainSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 72,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerResponseSource', 136,
        0,
        network_mojom_FetchResponseSourceSpec.$,
        network_mojom_FetchResponseSource.kUnspecified,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'urlListViaServiceWorker', 144,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initial_service_worker_status_$flag', 73,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "initial_service_worker_status_$value",
          originalFieldName: "initialServiceWorkerStatus",
        }
      ),
      mojo.internal.StructField(
        'initial_service_worker_status_$value', 140,
        0,
        network_mojom_ServiceWorkerStatusSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "initialServiceWorkerStatus",
        }
      ),
      mojo.internal.StructField(
        'serviceWorkerRouterInfo', 152,
        0,
        network_mojom_ServiceWorkerRouterInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseType', 160,
        0,
        network_mojom_FetchResponseTypeSpec.$,
        network_mojom_FetchResponseType.kDefault,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'padding', 168,
        0,
        mojo.internal.Int64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cacheStorageCacheName', 176,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'certStatus', 164,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sslInfo', 184,
        0,
        network_mojom_SSLInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestCookies', 192,
        0,
        mojo.internal.Array(network_mojom_ParsedRequestCookieSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'corsExposedHeaderNames', 200,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'didServiceWorkerNavigationPreload', 73,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'asyncRevalidationRequested', 73,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'didMimeSniff', 73,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isSignedExchangeInnerResponse', 73,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isWebBundleInnerResponse', 73,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasInPrefetchCache', 73,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPrefetchWithCrossSiteContamination', 73,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasCookieInRequest', 74,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interceptedByPlugin', 74,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasRangeRequested', 74,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timingAllowPassed', 74,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'authChallengeInfo', 208,
        0,
        network_mojom_AuthChallengeInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestStart', 216,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseStart', 224,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parsedHeaders', 232,
        0,
        network_mojom_ParsedHeadersSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'recursivePrefetchToken', 240,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dnsAliases', 248,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasAuthorizationCoveredByWildcardOnPreflight', 74,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestIncludeCredentials', 74,
        5,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldUseSourceHashForJsCodeCache', 74,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'privateNetworkAccessPreflightResult', 256,
        0,
        network_mojom_PrivateNetworkAccessPreflightResultSpec.$,
        network_mojom_PrivateNetworkAccessPreflightResult.kNone,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'didUseSharedDictionary', 74,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'loadWithStorageAccess', 75,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientSideContentDecodingTypes', 264,
        0,
        mojo.internal.Array(network_mojom_SourceTypeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceBoundSessionUsage', 260,
        0,
        network_mojom_DeviceBoundSessionUsageSpec.$,
        network_mojom_DeviceBoundSessionUsage.kUnknown,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fromSyntheticResponse', 75,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bypassRedirectChecks', 75,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unencodedDigests', 272,
        0,
        network_mojom_UnencodedDigestsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 288],]);



/**
 * @record
 */
export class URLResponseHead {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.requestTime;
    /** @type { !mojoBase_mojom_Time } */
    this.responseTime;
    /** @type { !mojoBase_mojom_Time } */
    this.originalResponseTime;
    /** @type { !network_mojom_HttpResponseHeaders } */
    this.headers;
    /** @type { !string } */
    this.mimeType;
    /** @type { !string } */
    this.charset;
    /** @type { !bigint } */
    this.contentLength;
    /** @type { !bigint } */
    this.encodedDataLength;
    /** @type { (network_mojom_EncodedBodyLength|undefined) } */
    this.encodedBodyLength;
    /** @type { !boolean } */
    this.networkAccessed;
    /** @type { !network_mojom_LoadTimingInfo } */
    this.loadTiming;
    /** @type { (network_mojom_LoadTimingInternalInfo|undefined) } */
    this.loadTimingInternalInfo;
    /** @type { !boolean } */
    this.emittedExtraInfo;
    /** @type { !boolean } */
    this.wasFetchedViaSpdy;
    /** @type { !boolean } */
    this.wasAlpnNegotiated;
    /** @type { !boolean } */
    this.wasAlternateProtocolAvailable;
    /** @type { !network_mojom_ConnectionInfo } */
    this.connectionInfo;
    /** @type { !string } */
    this.alpnNegotiatedProtocol;
    /** @type { !network_mojom_AlternateProtocolUsage } */
    this.alternateProtocolUsage;
    /** @type { !network_mojom_IPEndPoint } */
    this.remoteEndpoint;
    /** @type { !network_mojom_IPAddressSpace } */
    this.clientAddressSpace;
    /** @type { !network_mojom_IPAddressSpace } */
    this.responseAddressSpace;
    /** @type { !boolean } */
    this.isValidated;
    /** @type { !boolean } */
    this.wasFetchedViaCache;
    /** @type { !NavigationDeliveryType } */
    this.navigationDeliveryType;
    /** @type { !network_mojom_ProxyChain } */
    this.proxyChain;
    /** @type { !boolean } */
    this.wasFetchedViaServiceWorker;
    /** @type { !network_mojom_FetchResponseSource } */
    this.serviceWorkerResponseSource;
    /** @type { !Array<!url_mojom_Url> } */
    this.urlListViaServiceWorker;
    /** @type { (network_mojom_ServiceWorkerStatus|undefined) } */
    this.initialServiceWorkerStatus;
    /** @type { (network_mojom_ServiceWorkerRouterInfo|undefined) } */
    this.serviceWorkerRouterInfo;
    /** @type { !network_mojom_FetchResponseType } */
    this.responseType;
    /** @type { !bigint } */
    this.padding;
    /** @type { !string } */
    this.cacheStorageCacheName;
    /** @type { !number } */
    this.certStatus;
    /** @type { (network_mojom_SSLInfo|undefined) } */
    this.sslInfo;
    /** @type { !Array<!network_mojom_ParsedRequestCookie> } */
    this.requestCookies;
    /** @type { !Array<!string> } */
    this.corsExposedHeaderNames;
    /** @type { !boolean } */
    this.didServiceWorkerNavigationPreload;
    /** @type { !boolean } */
    this.asyncRevalidationRequested;
    /** @type { !boolean } */
    this.didMimeSniff;
    /** @type { !boolean } */
    this.isSignedExchangeInnerResponse;
    /** @type { !boolean } */
    this.isWebBundleInnerResponse;
    /** @type { !boolean } */
    this.wasInPrefetchCache;
    /** @type { !boolean } */
    this.isPrefetchWithCrossSiteContamination;
    /** @type { !boolean } */
    this.wasCookieInRequest;
    /** @type { !boolean } */
    this.interceptedByPlugin;
    /** @type { !boolean } */
    this.hasRangeRequested;
    /** @type { !boolean } */
    this.timingAllowPassed;
    /** @type { (network_mojom_AuthChallengeInfo|undefined) } */
    this.authChallengeInfo;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.requestStart;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.responseStart;
    /** @type { (network_mojom_ParsedHeaders|undefined) } */
    this.parsedHeaders;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.recursivePrefetchToken;
    /** @type { !Array<!string> } */
    this.dnsAliases;
    /** @type { !boolean } */
    this.hasAuthorizationCoveredByWildcardOnPreflight;
    /** @type { !boolean } */
    this.requestIncludeCredentials;
    /** @type { !boolean } */
    this.shouldUseSourceHashForJsCodeCache;
    /** @type { !network_mojom_PrivateNetworkAccessPreflightResult } */
    this.privateNetworkAccessPreflightResult;
    /** @type { !boolean } */
    this.didUseSharedDictionary;
    /** @type { !boolean } */
    this.loadWithStorageAccess;
    /** @type { !Array<!network_mojom_SourceType> } */
    this.clientSideContentDecodingTypes;
    /** @type { !network_mojom_DeviceBoundSessionUsage } */
    this.deviceBoundSessionUsage;
    /** @type { !boolean } */
    this.fromSyntheticResponse;
    /** @type { !boolean } */
    this.bypassRedirectChecks;
    /** @type { (network_mojom_UnencodedDigests|undefined) } */
    this.unencodedDigests;
  }
}

