// services/network/public/mojom/url_loader_network_service_observer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  AdAuctionEventRecord as network_mojom_AdAuctionEventRecord,
  AdAuctionEventRecordSpec as network_mojom_AdAuctionEventRecordSpec
} from './ad_auction.mojom.m.js';

import {
  CookiePartitionKey as network_mojom_CookiePartitionKey,
  CookiePartitionKeySpec as network_mojom_CookiePartitionKeySpec
} from './cookie_partition_key.mojom.m.js';

import {
  IPAddressSpace as network_mojom_IPAddressSpace,
  IPAddressSpaceSpec as network_mojom_IPAddressSpaceSpec
} from './ip_address_space.mojom.m.js';

import {
  AuthChallengeInfo as network_mojom_AuthChallengeInfo,
  AuthChallengeInfoSpec as network_mojom_AuthChallengeInfoSpec,
  AuthCredentials as network_mojom_AuthCredentials,
  AuthCredentialsSpec as network_mojom_AuthCredentialsSpec,
  HttpResponseHeaders as network_mojom_HttpResponseHeaders,
  HttpResponseHeadersSpec as network_mojom_HttpResponseHeadersSpec,
  SSLCertRequestInfo as network_mojom_SSLCertRequestInfo,
  SSLCertRequestInfoSpec as network_mojom_SSLCertRequestInfoSpec,
  SSLInfo as network_mojom_SSLInfo,
  SSLInfoSpec as network_mojom_SSLInfoSpec,
  X509Certificate as network_mojom_X509Certificate,
  X509CertificateSpec as network_mojom_X509CertificateSpec
} from './network_param.mojom.m.js';

import {
  LockName as network_mojom_LockName,
  LockNameSpec as network_mojom_LockNameSpec,
  SharedStorageBatchUpdateMethodsArgument as network_mojom_SharedStorageBatchUpdateMethodsArgument,
  SharedStorageBatchUpdateMethodsArgumentSpec as network_mojom_SharedStorageBatchUpdateMethodsArgumentSpec
} from './shared_storage.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ClientCertificateResponderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.ClientCertificateResponder', scope);
  }
}

/** @interface */
export class ClientCertificateResponderInterface {
  
  /**
   * @param { !network_mojom_X509Certificate } x509Certificate
   * @param { !string } providerName
   * @param { !Array<!number> } algorithmPreferences
   * @param { !SSLPrivateKeyRemote } sslPrivateKey
   */

  continueWithCertificate(x509Certificate, providerName, algorithmPreferences, sslPrivateKey) {}
  
  /**
   */

  continueWithoutCertificate() {}
  
  /**
   */

  cancelRequest() {}
}

/**
 * @implements { ClientCertificateResponderInterface }
 */
export class ClientCertificateResponderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ClientCertificateResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ClientCertificateResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ClientCertificateResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_X509Certificate } x509Certificate
   * @param { !string } providerName
   * @param { !Array<!number> } algorithmPreferences
   * @param { !SSLPrivateKeyRemote } sslPrivateKey
   */

  continueWithCertificate(
      x509Certificate,
      providerName,
      algorithmPreferences,
      sslPrivateKey) {
    this.proxy.sendMessage(
        0,
        ClientCertificateResponder_ContinueWithCertificate_ParamsSpec.$,
        null,
        [
          x509Certificate,
          providerName,
          algorithmPreferences,
          sslPrivateKey
        ],
        false);
  }

  
  /**
   */

  continueWithoutCertificate() {
    this.proxy.sendMessage(
        1,
        ClientCertificateResponder_ContinueWithoutCertificate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  cancelRequest() {
    this.proxy.sendMessage(
        2,
        ClientCertificateResponder_CancelRequest_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ClientCertificateResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ClientCertificateResponderReceiver {
  /**
   * @param {!ClientCertificateResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ClientCertificateResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ClientCertificateResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ClientCertificateResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ClientCertificateResponder_ContinueWithCertificate_ParamsSpec.$,
        null,
        impl.continueWithCertificate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ClientCertificateResponder_ContinueWithoutCertificate_ParamsSpec.$,
        null,
        impl.continueWithoutCertificate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ClientCertificateResponder_CancelRequest_ParamsSpec.$,
        null,
        impl.cancelRequest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ClientCertificateResponder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ClientCertificateResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ClientCertificateResponderRemote}
   */
  static getRemote() {
    let remote = new ClientCertificateResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ClientCertificateResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ClientCertificateResponderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ClientCertificateResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ClientCertificateResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.continueWithCertificate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ClientCertificateResponder_ContinueWithCertificate_ParamsSpec.$,
        null,
        this.continueWithCertificate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.continueWithoutCertificate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ClientCertificateResponder_ContinueWithoutCertificate_ParamsSpec.$,
        null,
        this.continueWithoutCertificate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ClientCertificateResponder_CancelRequest_ParamsSpec.$,
        null,
        this.cancelRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SSLPrivateKeyPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.SSLPrivateKey', scope);
  }
}

/** @interface */
export class SSLPrivateKeyInterface {
  
  /**
   * @param { !number } algorithm
   * @param { !Array<!number> } input
   * @return {!Promise<{
        netError: !number,
        signature: !Array<!number>,
   *  }>}
   */

  sign(algorithm, input) {}
}

/**
 * @implements { SSLPrivateKeyInterface }
 */
export class SSLPrivateKeyRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SSLPrivateKeyPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SSLPrivateKeyPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SSLPrivateKeyPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } algorithm
   * @param { !Array<!number> } input
   * @return {!Promise<{
        netError: !number,
        signature: !Array<!number>,
   *  }>}
   */

  sign(
      algorithm,
      input) {
    return this.proxy.sendMessage(
        0,
        SSLPrivateKey_Sign_ParamsSpec.$,
        SSLPrivateKey_Sign_ResponseParamsSpec.$,
        [
          algorithm,
          input
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SSLPrivateKey
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SSLPrivateKeyReceiver {
  /**
   * @param {!SSLPrivateKeyInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SSLPrivateKeyRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SSLPrivateKeyRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SSLPrivateKeyRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SSLPrivateKey_Sign_ParamsSpec.$,
        SSLPrivateKey_Sign_ResponseParamsSpec.$,
        impl.sign.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SSLPrivateKey {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SSLPrivateKey";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SSLPrivateKeyRemote}
   */
  static getRemote() {
    let remote = new SSLPrivateKeyRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SSLPrivateKey
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SSLPrivateKeyCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SSLPrivateKeyRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SSLPrivateKeyRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sign =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SSLPrivateKey_Sign_ParamsSpec.$,
        SSLPrivateKey_Sign_ResponseParamsSpec.$,
        this.sign.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AuthChallengeResponderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.AuthChallengeResponder', scope);
  }
}

/** @interface */
export class AuthChallengeResponderInterface {
  
  /**
   * @param { ?network_mojom_AuthCredentials } credentials
   */

  onAuthCredentials(credentials) {}
}

/**
 * @implements { AuthChallengeResponderInterface }
 */
export class AuthChallengeResponderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AuthChallengeResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AuthChallengeResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AuthChallengeResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?network_mojom_AuthCredentials } credentials
   */

  onAuthCredentials(
      credentials) {
    this.proxy.sendMessage(
        0,
        AuthChallengeResponder_OnAuthCredentials_ParamsSpec.$,
        null,
        [
          credentials
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AuthChallengeResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AuthChallengeResponderReceiver {
  /**
   * @param {!AuthChallengeResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AuthChallengeResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AuthChallengeResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AuthChallengeResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AuthChallengeResponder_OnAuthCredentials_ParamsSpec.$,
        null,
        impl.onAuthCredentials.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AuthChallengeResponder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.AuthChallengeResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AuthChallengeResponderRemote}
   */
  static getRemote() {
    let remote = new AuthChallengeResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AuthChallengeResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AuthChallengeResponderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AuthChallengeResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AuthChallengeResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAuthCredentials =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AuthChallengeResponder_OnAuthCredentials_ParamsSpec.$,
        null,
        this.onAuthCredentials.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class URLLoaderNetworkServiceObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.URLLoaderNetworkServiceObserver', scope);
  }
}

/** @interface */
export class URLLoaderNetworkServiceObserverInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !number } netError
   * @param { !network_mojom_SSLInfo } sslInfo
   * @param { !boolean } fatal
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  onSSLCertificateError(url, netError, sslInfo, fatal) {}
  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } windowId
   * @param { !network_mojom_SSLCertRequestInfo } certInfo
   * @param { !ClientCertificateResponderRemote } certResponder
   */

  onCertificateRequested(windowId, certInfo, certResponder) {}
  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } windowId
   * @param { !number } requestId
   * @param { !url_mojom_Url } url
   * @param { !boolean } firstAuthAttempt
   * @param { !network_mojom_AuthChallengeInfo } authInfo
   * @param { ?network_mojom_HttpResponseHeaders } headHeaders
   * @param { !AuthChallengeResponderRemote } authChallengeResponder
   */

  onAuthRequired(windowId, requestId, url, firstAuthAttempt, authInfo, headHeaders, authChallengeResponder) {}
  
  /**
   * @return {!Promise<{
        permissionGranted: !boolean,
   *  }>}
   */

  onLocalNetworkAccessPermissionRequired() {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } headerValue
   * @param { !number } loadFlags
   * @param { ?network_mojom_CookiePartitionKey } cookiePartitionKey
   * @param { !boolean } partitionedStateAllowedOnly
   * @return {!Promise}
   */

  onClearSiteData(url, headerValue, loadFlags, cookiePartitionKey, partitionedStateAllowedOnly) {}
  
  /**
   * @param { !LoadInfo } info
   * @return {!Promise}
   */

  onLoadingStateUpdate(info) {}
  
  /**
   * @param { !number } networkTrafficAnnotationIdHash
   * @param { !bigint } recvBytes
   * @param { !bigint } sentBytes
   */

  onDataUseUpdate(networkTrafficAnnotationIdHash, recvBytes, sentBytes) {}
  
  /**
   * @param { !url_mojom_Origin } requestOrigin
   * @param { !network_mojom_SharedStorageBatchUpdateMethodsArgument } methodsWithOptions
   * @param { ?network_mojom_LockName } withLock
   * @return {!Promise}
   */

  onSharedStorageHeaderReceived(requestOrigin, methodsWithOptions, withLock) {}
  
  /**
   * @param { !network_mojom_AdAuctionEventRecord } adAuctionEventRecord
   * @param { ?url_mojom_Origin } topFrameOrigin
   */

  onAdAuctionEventRecordHeaderReceived(adAuctionEventRecord, topFrameOrigin) {}
  
  /**
   * @param { !URLLoaderNetworkServiceObserverPendingReceiver } listener
   */

  clone(listener) {}
  
  /**
   * @param { !url_mojom_Url } requestUrl
   * @param { !network_mojom_IPAddressSpace } ipAddressSpace
   */

  onWebSocketConnectedToPrivateNetwork(requestUrl, ipAddressSpace) {}
  
  /**
   * @param { !url_mojom_Url } requestUrl
   * @param { !network_mojom_IPAddressSpace } responseAddressSpace
   * @param { !network_mojom_IPAddressSpace } clientAddressSpace
   * @param { !network_mojom_IPAddressSpace } targetAddressSpace
   */

  onUrlLoaderConnectedToPrivateNetwork(requestUrl, responseAddressSpace, clientAddressSpace, targetAddressSpace) {}
}

/**
 * @implements { URLLoaderNetworkServiceObserverInterface }
 */
export class URLLoaderNetworkServiceObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!URLLoaderNetworkServiceObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          URLLoaderNetworkServiceObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!URLLoaderNetworkServiceObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !number } netError
   * @param { !network_mojom_SSLInfo } sslInfo
   * @param { !boolean } fatal
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  onSSLCertificateError(
      url,
      netError,
      sslInfo,
      fatal) {
    return this.proxy.sendMessage(
        0,
        URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsSpec.$,
        [
          url,
          netError,
          sslInfo,
          fatal
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } windowId
   * @param { !network_mojom_SSLCertRequestInfo } certInfo
   * @param { !ClientCertificateResponderRemote } certResponder
   */

  onCertificateRequested(
      windowId,
      certInfo,
      certResponder) {
    this.proxy.sendMessage(
        1,
        URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsSpec.$,
        null,
        [
          windowId,
          certInfo,
          certResponder
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } windowId
   * @param { !number } requestId
   * @param { !url_mojom_Url } url
   * @param { !boolean } firstAuthAttempt
   * @param { !network_mojom_AuthChallengeInfo } authInfo
   * @param { ?network_mojom_HttpResponseHeaders } headHeaders
   * @param { !AuthChallengeResponderRemote } authChallengeResponder
   */

  onAuthRequired(
      windowId,
      requestId,
      url,
      firstAuthAttempt,
      authInfo,
      headHeaders,
      authChallengeResponder) {
    this.proxy.sendMessage(
        2,
        URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsSpec.$,
        null,
        [
          windowId,
          requestId,
          url,
          firstAuthAttempt,
          authInfo,
          headHeaders,
          authChallengeResponder
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        permissionGranted: !boolean,
   *  }>}
   */

  onLocalNetworkAccessPermissionRequired() {
    return this.proxy.sendMessage(
        3,
        URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } headerValue
   * @param { !number } loadFlags
   * @param { ?network_mojom_CookiePartitionKey } cookiePartitionKey
   * @param { !boolean } partitionedStateAllowedOnly
   * @return {!Promise}
   */

  onClearSiteData(
      url,
      headerValue,
      loadFlags,
      cookiePartitionKey,
      partitionedStateAllowedOnly) {
    return this.proxy.sendMessage(
        4,
        URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsSpec.$,
        [
          url,
          headerValue,
          loadFlags,
          cookiePartitionKey,
          partitionedStateAllowedOnly
        ],
        false);
  }

  
  /**
   * @param { !LoadInfo } info
   * @return {!Promise}
   */

  onLoadingStateUpdate(
      info) {
    return this.proxy.sendMessage(
        5,
        URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsSpec.$,
        [
          info
        ],
        false);
  }

  
  /**
   * @param { !number } networkTrafficAnnotationIdHash
   * @param { !bigint } recvBytes
   * @param { !bigint } sentBytes
   */

  onDataUseUpdate(
      networkTrafficAnnotationIdHash,
      recvBytes,
      sentBytes) {
    this.proxy.sendMessage(
        6,
        URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsSpec.$,
        null,
        [
          networkTrafficAnnotationIdHash,
          recvBytes,
          sentBytes
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } requestOrigin
   * @param { !network_mojom_SharedStorageBatchUpdateMethodsArgument } methodsWithOptions
   * @param { ?network_mojom_LockName } withLock
   * @return {!Promise}
   */

  onSharedStorageHeaderReceived(
      requestOrigin,
      methodsWithOptions,
      withLock) {
    return this.proxy.sendMessage(
        7,
        URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsSpec.$,
        [
          requestOrigin,
          methodsWithOptions,
          withLock
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_AdAuctionEventRecord } adAuctionEventRecord
   * @param { ?url_mojom_Origin } topFrameOrigin
   */

  onAdAuctionEventRecordHeaderReceived(
      adAuctionEventRecord,
      topFrameOrigin) {
    this.proxy.sendMessage(
        8,
        URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsSpec.$,
        null,
        [
          adAuctionEventRecord,
          topFrameOrigin
        ],
        false);
  }

  
  /**
   * @param { !URLLoaderNetworkServiceObserverPendingReceiver } listener
   */

  clone(
      listener) {
    this.proxy.sendMessage(
        9,
        URLLoaderNetworkServiceObserver_Clone_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } requestUrl
   * @param { !network_mojom_IPAddressSpace } ipAddressSpace
   */

  onWebSocketConnectedToPrivateNetwork(
      requestUrl,
      ipAddressSpace) {
    this.proxy.sendMessage(
        10,
        URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        [
          requestUrl,
          ipAddressSpace
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } requestUrl
   * @param { !network_mojom_IPAddressSpace } responseAddressSpace
   * @param { !network_mojom_IPAddressSpace } clientAddressSpace
   * @param { !network_mojom_IPAddressSpace } targetAddressSpace
   */

  onUrlLoaderConnectedToPrivateNetwork(
      requestUrl,
      responseAddressSpace,
      clientAddressSpace,
      targetAddressSpace) {
    this.proxy.sendMessage(
        11,
        URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        [
          requestUrl,
          responseAddressSpace,
          clientAddressSpace,
          targetAddressSpace
        ],
        false);
  }
}

/**
 * An object which receives request messages for the URLLoaderNetworkServiceObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class URLLoaderNetworkServiceObserverReceiver {
  /**
   * @param {!URLLoaderNetworkServiceObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!URLLoaderNetworkServiceObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        URLLoaderNetworkServiceObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!URLLoaderNetworkServiceObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsSpec.$,
        impl.onSSLCertificateError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsSpec.$,
        null,
        impl.onCertificateRequested.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsSpec.$,
        null,
        impl.onAuthRequired.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsSpec.$,
        impl.onLocalNetworkAccessPermissionRequired.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsSpec.$,
        impl.onClearSiteData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsSpec.$,
        impl.onLoadingStateUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsSpec.$,
        null,
        impl.onDataUseUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsSpec.$,
        impl.onSharedStorageHeaderReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsSpec.$,
        null,
        impl.onAdAuctionEventRecordHeaderReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        URLLoaderNetworkServiceObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        impl.onWebSocketConnectedToPrivateNetwork.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        impl.onUrlLoaderConnectedToPrivateNetwork.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class URLLoaderNetworkServiceObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.URLLoaderNetworkServiceObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!URLLoaderNetworkServiceObserverRemote}
   */
  static getRemote() {
    let remote = new URLLoaderNetworkServiceObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the URLLoaderNetworkServiceObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class URLLoaderNetworkServiceObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      URLLoaderNetworkServiceObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!URLLoaderNetworkServiceObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSSLCertificateError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsSpec.$,
        this.onSSLCertificateError.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCertificateRequested =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsSpec.$,
        null,
        this.onCertificateRequested.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAuthRequired =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsSpec.$,
        null,
        this.onAuthRequired.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLocalNetworkAccessPermissionRequired =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsSpec.$,
        this.onLocalNetworkAccessPermissionRequired.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClearSiteData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsSpec.$,
        this.onClearSiteData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLoadingStateUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsSpec.$,
        this.onLoadingStateUpdate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDataUseUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsSpec.$,
        null,
        this.onDataUseUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSharedStorageHeaderReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsSpec.$,
        URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsSpec.$,
        this.onSharedStorageHeaderReceived.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAdAuctionEventRecordHeaderReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsSpec.$,
        null,
        this.onAdAuctionEventRecordHeaderReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        URLLoaderNetworkServiceObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWebSocketConnectedToPrivateNetwork =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        this.onWebSocketConnectedToPrivateNetwork.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onUrlLoaderConnectedToPrivateNetwork =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        this.onUrlLoaderConnectedToPrivateNetwork.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LoadInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClientCertificateResponder_ContinueWithCertificate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClientCertificateResponder_ContinueWithoutCertificate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClientCertificateResponder_CancelRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SSLPrivateKey_Sign_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SSLPrivateKey_Sign_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuthChallengeResponder_OnAuthCredentials_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    LoadInfoSpec.$,
    'LoadInfo',
    [
      mojo.internal.StructField(
        'timestamp', 0,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'host', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'loadState', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stateParam', 24,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uploadPosition', 32,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uploadSize', 40,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class LoadInfo {
  constructor() {
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.timestamp;
    /** @type { !string } */
    this.host;
    /** @type { !number } */
    this.loadState;
    /** @type { !mojoBase_mojom_String16 } */
    this.stateParam;
    /** @type { !bigint } */
    this.uploadPosition;
    /** @type { !bigint } */
    this.uploadSize;
  }
}



mojo.internal.Struct(
    ClientCertificateResponder_ContinueWithCertificate_ParamsSpec.$,
    'ClientCertificateResponder_ContinueWithCertificate_Params',
    [
      mojo.internal.StructField(
        'x509Certificate', 0,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'providerName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'algorithmPreferences', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint16, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sslPrivateKey', 24,
        0,
        mojo.internal.InterfaceProxy(SSLPrivateKeyRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ClientCertificateResponder_ContinueWithCertificate_Params {
  constructor() {
    /** @type { !network_mojom_X509Certificate } */
    this.x509Certificate;
    /** @type { !string } */
    this.providerName;
    /** @type { !Array<!number> } */
    this.algorithmPreferences;
    /** @type { !SSLPrivateKeyRemote } */
    this.sslPrivateKey;
  }
}



mojo.internal.Struct(
    ClientCertificateResponder_ContinueWithoutCertificate_ParamsSpec.$,
    'ClientCertificateResponder_ContinueWithoutCertificate_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ClientCertificateResponder_ContinueWithoutCertificate_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ClientCertificateResponder_CancelRequest_ParamsSpec.$,
    'ClientCertificateResponder_CancelRequest_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ClientCertificateResponder_CancelRequest_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SSLPrivateKey_Sign_ParamsSpec.$,
    'SSLPrivateKey_Sign_Params',
    [
      mojo.internal.StructField(
        'algorithm', 0,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'input', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SSLPrivateKey_Sign_Params {
  constructor() {
    /** @type { !number } */
    this.algorithm;
    /** @type { !Array<!number> } */
    this.input;
  }
}



mojo.internal.Struct(
    SSLPrivateKey_Sign_ResponseParamsSpec.$,
    'SSLPrivateKey_Sign_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'signature', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SSLPrivateKey_Sign_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
    /** @type { !Array<!number> } */
    this.signature;
  }
}



mojo.internal.Struct(
    AuthChallengeResponder_OnAuthCredentials_ParamsSpec.$,
    'AuthChallengeResponder_OnAuthCredentials_Params',
    [
      mojo.internal.StructField(
        'credentials', 0,
        0,
        network_mojom_AuthCredentialsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AuthChallengeResponder_OnAuthCredentials_Params {
  constructor() {
    /** @type { (network_mojom_AuthCredentials|undefined) } */
    this.credentials;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'netError', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sslInfo', 16,
        0,
        network_mojom_SSLInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fatal', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !number } */
    this.netError;
    /** @type { !network_mojom_SSLInfo } */
    this.sslInfo;
    /** @type { !boolean } */
    this.fatal;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnCertificateRequested_Params',
    [
      mojo.internal.StructField(
        'windowId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'certInfo', 8,
        0,
        network_mojom_SSLCertRequestInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'certResponder', 16,
        0,
        mojo.internal.InterfaceProxy(ClientCertificateResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnCertificateRequested_Params {
  constructor() {
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.windowId;
    /** @type { !network_mojom_SSLCertRequestInfo } */
    this.certInfo;
    /** @type { !ClientCertificateResponderRemote } */
    this.certResponder;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnAuthRequired_Params',
    [
      mojo.internal.StructField(
        'windowId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'firstAuthAttempt', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'authInfo', 24,
        0,
        network_mojom_AuthChallengeInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headHeaders', 32,
        0,
        network_mojom_HttpResponseHeadersSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'authChallengeResponder', 40,
        0,
        mojo.internal.InterfaceProxy(AuthChallengeResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnAuthRequired_Params {
  constructor() {
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.windowId;
    /** @type { !number } */
    this.requestId;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !boolean } */
    this.firstAuthAttempt;
    /** @type { !network_mojom_AuthChallengeInfo } */
    this.authInfo;
    /** @type { (network_mojom_HttpResponseHeaders|undefined) } */
    this.headHeaders;
    /** @type { !AuthChallengeResponderRemote } */
    this.authChallengeResponder;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams',
    [
      mojo.internal.StructField(
        'permissionGranted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.permissionGranted;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnClearSiteData_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headerValue', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'loadFlags', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookiePartitionKey', 24,
        0,
        network_mojom_CookiePartitionKeySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'partitionedStateAllowedOnly', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnClearSiteData_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.headerValue;
    /** @type { !number } */
    this.loadFlags;
    /** @type { (network_mojom_CookiePartitionKey|undefined) } */
    this.cookiePartitionKey;
    /** @type { !boolean } */
    this.partitionedStateAllowedOnly;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        LoadInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params {
  constructor() {
    /** @type { !LoadInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params',
    [
      mojo.internal.StructField(
        'networkTrafficAnnotationIdHash', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'recvBytes', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sentBytes', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params {
  constructor() {
    /** @type { !number } */
    this.networkTrafficAnnotationIdHash;
    /** @type { !bigint } */
    this.recvBytes;
    /** @type { !bigint } */
    this.sentBytes;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params',
    [
      mojo.internal.StructField(
        'requestOrigin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'methodsWithOptions', 8,
        0,
        network_mojom_SharedStorageBatchUpdateMethodsArgumentSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'withLock', 16,
        0,
        network_mojom_LockNameSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.requestOrigin;
    /** @type { !network_mojom_SharedStorageBatchUpdateMethodsArgument } */
    this.methodsWithOptions;
    /** @type { (network_mojom_LockName|undefined) } */
    this.withLock;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params',
    [
      mojo.internal.StructField(
        'adAuctionEventRecord', 0,
        0,
        network_mojom_AdAuctionEventRecordSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params {
  constructor() {
    /** @type { !network_mojom_AdAuctionEventRecord } */
    this.adAuctionEventRecord;
    /** @type { (url_mojom_Origin|undefined) } */
    this.topFrameOrigin;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_Clone_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceRequest(URLLoaderNetworkServiceObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_Clone_Params {
  constructor() {
    /** @type { !URLLoaderNetworkServiceObserverPendingReceiver } */
    this.listener;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params',
    [
      mojo.internal.StructField(
        'requestUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ipAddressSpace', 8,
        0,
        network_mojom_IPAddressSpaceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.requestUrl;
    /** @type { !network_mojom_IPAddressSpace } */
    this.ipAddressSpace;
  }
}



mojo.internal.Struct(
    URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params',
    [
      mojo.internal.StructField(
        'requestUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseAddressSpace', 8,
        0,
        network_mojom_IPAddressSpaceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientAddressSpace', 12,
        0,
        network_mojom_IPAddressSpaceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetAddressSpace', 16,
        0,
        network_mojom_IPAddressSpaceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.requestUrl;
    /** @type { !network_mojom_IPAddressSpace } */
    this.responseAddressSpace;
    /** @type { !network_mojom_IPAddressSpace } */
    this.clientAddressSpace;
    /** @type { !network_mojom_IPAddressSpace } */
    this.targetAddressSpace;
  }
}

