// services/network/public/mojom/url_loader_network_service_observer.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  ClientCertificateResponder_ContinueWithCertificate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::X509Certificate_Data> x509_certificate;
  mojo::internal::Pointer<mojo::internal::String_Data> provider_name;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint16_t>> algorithm_preferences;
  mojo::internal::Interface_Data ssl_private_key;

 private:
  friend class mojo::internal::MessageFragment<ClientCertificateResponder_ContinueWithCertificate_Params_Data>;

  ClientCertificateResponder_ContinueWithCertificate_Params_Data();
  ~ClientCertificateResponder_ContinueWithCertificate_Params_Data() = delete;
};
static_assert(sizeof(ClientCertificateResponder_ContinueWithCertificate_Params_Data) == 40,
              "Bad sizeof(ClientCertificateResponder_ContinueWithCertificate_Params_Data)");
class  ClientCertificateResponder_ContinueWithoutCertificate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<ClientCertificateResponder_ContinueWithoutCertificate_Params_Data>;

  ClientCertificateResponder_ContinueWithoutCertificate_Params_Data();
  ~ClientCertificateResponder_ContinueWithoutCertificate_Params_Data() = delete;
};
static_assert(sizeof(ClientCertificateResponder_ContinueWithoutCertificate_Params_Data) == 8,
              "Bad sizeof(ClientCertificateResponder_ContinueWithoutCertificate_Params_Data)");
class  ClientCertificateResponder_CancelRequest_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<ClientCertificateResponder_CancelRequest_Params_Data>;

  ClientCertificateResponder_CancelRequest_Params_Data();
  ~ClientCertificateResponder_CancelRequest_Params_Data() = delete;
};
static_assert(sizeof(ClientCertificateResponder_CancelRequest_Params_Data) == 8,
              "Bad sizeof(ClientCertificateResponder_CancelRequest_Params_Data)");
class  SSLPrivateKey_Sign_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint16_t algorithm;
  uint8_t pad0_[6];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> input;

 private:
  friend class mojo::internal::MessageFragment<SSLPrivateKey_Sign_Params_Data>;

  SSLPrivateKey_Sign_Params_Data();
  ~SSLPrivateKey_Sign_Params_Data() = delete;
};
static_assert(sizeof(SSLPrivateKey_Sign_Params_Data) == 24,
              "Bad sizeof(SSLPrivateKey_Sign_Params_Data)");
class  SSLPrivateKey_Sign_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t net_error;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> signature;

 private:
  friend class mojo::internal::MessageFragment<SSLPrivateKey_Sign_ResponseParams_Data>;

  SSLPrivateKey_Sign_ResponseParams_Data();
  ~SSLPrivateKey_Sign_ResponseParams_Data() = delete;
};
static_assert(sizeof(SSLPrivateKey_Sign_ResponseParams_Data) == 24,
              "Bad sizeof(SSLPrivateKey_Sign_ResponseParams_Data)");
class  AuthChallengeResponder_OnAuthCredentials_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::AuthCredentials_Data> credentials;

 private:
  friend class mojo::internal::MessageFragment<AuthChallengeResponder_OnAuthCredentials_Params_Data>;

  AuthChallengeResponder_OnAuthCredentials_Params_Data();
  ~AuthChallengeResponder_OnAuthCredentials_Params_Data() = delete;
};
static_assert(sizeof(AuthChallengeResponder_OnAuthCredentials_Params_Data) == 16,
              "Bad sizeof(AuthChallengeResponder_OnAuthCredentials_Params_Data)");
class  URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  int32_t net_error;
  uint8_t fatal : 1;
  uint8_t pad2_[3];
  mojo::internal::Pointer<::network::mojom::internal::SSLInfo_Data> ssl_info;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data>;

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data();
  ~URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data) == 32,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data)");
class  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t net_error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data>;

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data();
  ~URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data) == 16,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data)");
class  URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> window_id;
  mojo::internal::Pointer<::network::mojom::internal::SSLCertRequestInfo_Data> cert_info;
  mojo::internal::Interface_Data cert_responder;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data>;

  URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data();
  ~URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data) == 32,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data)");
class  URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> window_id;
  int32_t request_id;
  uint8_t first_auth_attempt : 1;
  uint8_t pad2_[3];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::network::mojom::internal::AuthChallengeInfo_Data> auth_info;
  mojo::internal::Pointer<::network::mojom::internal::HttpResponseHeaders_Data> head_headers;
  mojo::internal::Interface_Data auth_challenge_responder;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data>;

  URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data();
  ~URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data) == 56,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data)");
class  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data>;

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data();
  ~URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data) == 8,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data)");
class  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t permission_granted : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data>;

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data();
  ~URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data) == 16,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data)");
class  URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<mojo::internal::String_Data> header_value;
  int32_t load_flags;
  uint8_t partitioned_state_allowed_only : 1;
  uint8_t pad3_[3];
  mojo::internal::Pointer<::network::mojom::internal::CookiePartitionKey_Data> cookie_partition_key;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data>;

  URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data();
  ~URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data) == 40,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data)");
class  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data>;

  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data();
  ~URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data) == 8,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data)");
class  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::LoadInfo_Data> info;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data>;

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data();
  ~URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data) == 16,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data)");
class  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data>;

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data();
  ~URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data) == 8,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data)");
class  URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t network_traffic_annotation_id_hash;
  uint8_t pad0_[4];
  int64_t recv_bytes;
  int64_t sent_bytes;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data>;

  URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data();
  ~URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data) == 32,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data)");
class  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> request_origin;
  mojo::internal::Pointer<::network::mojom::internal::SharedStorageBatchUpdateMethodsArgument_Data> methods_with_options;
  mojo::internal::Pointer<::network::mojom::internal::LockName_Data> with_lock;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data>;

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data();
  ~URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data) == 32,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data)");
class  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data>;

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data();
  ~URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data) == 8,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data)");
class  URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::AdAuctionEventRecord_Data> ad_auction_event_record;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> top_frame_origin;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data>;

  URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data();
  ~URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data) == 24,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data)");
class  URLLoaderNetworkServiceObserver_Clone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data listener;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_Clone_Params_Data>;

  URLLoaderNetworkServiceObserver_Clone_Params_Data();
  ~URLLoaderNetworkServiceObserver_Clone_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_Clone_Params_Data) == 16,
              "Bad sizeof(URLLoaderNetworkServiceObserver_Clone_Params_Data)");
class  URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> request_url;
  int32_t ip_address_space;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data>;

  URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data();
  ~URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data) == 24,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data)");
class  URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> request_url;
  int32_t response_address_space;
  int32_t client_address_space;
  int32_t target_address_space;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data>;

  URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data();
  ~URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data) == 32,
              "Bad sizeof(URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data)");

}  // namespace internal


class ClientCertificateResponder_ContinueWithCertificate_ParamsDataView {
 public:
  ClientCertificateResponder_ContinueWithCertificate_ParamsDataView() = default;

  ClientCertificateResponder_ContinueWithCertificate_ParamsDataView(
      internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetX509CertificateDataView(
      ::network::mojom::X509CertificateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadX509Certificate(UserType* output) {
    
    auto* pointer = data_->x509_certificate.Get();
    return mojo::internal::Deserialize<::network::mojom::X509CertificateDataView>(
        pointer, output, message_);
  }
  inline void GetProviderNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProviderName(UserType* output) {
    
    auto* pointer = data_->provider_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAlgorithmPreferencesDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlgorithmPreferences(UserType* output) {
    
    auto* pointer = data_->algorithm_preferences.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeSslPrivateKey() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::SSLPrivateKeyInterfaceBase>>(
            &data_->ssl_private_key, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClientCertificateResponder_ContinueWithoutCertificate_ParamsDataView {
 public:
  ClientCertificateResponder_ContinueWithoutCertificate_ParamsDataView() = default;

  ClientCertificateResponder_ContinueWithoutCertificate_ParamsDataView(
      internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data* data_ = nullptr;
};


class ClientCertificateResponder_CancelRequest_ParamsDataView {
 public:
  ClientCertificateResponder_CancelRequest_ParamsDataView() = default;

  ClientCertificateResponder_CancelRequest_ParamsDataView(
      internal::ClientCertificateResponder_CancelRequest_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ClientCertificateResponder_CancelRequest_Params_Data* data_ = nullptr;
};


class SSLPrivateKey_Sign_ParamsDataView {
 public:
  SSLPrivateKey_Sign_ParamsDataView() = default;

  SSLPrivateKey_Sign_ParamsDataView(
      internal::SSLPrivateKey_Sign_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint16_t algorithm() const {
    return data_->algorithm;
  }
  inline void GetInputDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = data_->input.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::SSLPrivateKey_Sign_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SSLPrivateKey_Sign_ResponseParamsDataView {
 public:
  SSLPrivateKey_Sign_ResponseParamsDataView() = default;

  SSLPrivateKey_Sign_ResponseParamsDataView(
      internal::SSLPrivateKey_Sign_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t net_error() const {
    return data_->net_error;
  }
  inline void GetSignatureDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignature(UserType* output) {
    
    auto* pointer = data_->signature.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::SSLPrivateKey_Sign_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuthChallengeResponder_OnAuthCredentials_ParamsDataView {
 public:
  AuthChallengeResponder_OnAuthCredentials_ParamsDataView() = default;

  AuthChallengeResponder_OnAuthCredentials_ParamsDataView(
      internal::AuthChallengeResponder_OnAuthCredentials_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCredentialsDataView(
      ::network::mojom::AuthCredentialsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentials(UserType* output) {
    
    auto* pointer = data_->credentials.Get();
    return mojo::internal::Deserialize<::network::mojom::AuthCredentialsDataView>(
        pointer, output, message_);
  }
 private:
  internal::AuthChallengeResponder_OnAuthCredentials_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int32_t net_error() const {
    return data_->net_error;
  }
  inline void GetSslInfoDataView(
      ::network::mojom::SSLInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSslInfo(UserType* output) {
    
    auto* pointer = data_->ssl_info.Get();
    return mojo::internal::Deserialize<::network::mojom::SSLInfoDataView>(
        pointer, output, message_);
  }
  bool fatal() const {
    return data_->fatal;
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t net_error() const {
    return data_->net_error;
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data* data_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWindowIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindowId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `window_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWindowId` instead "
    "of `ReadWindowId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->window_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetCertInfoDataView(
      ::network::mojom::SSLCertRequestInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCertInfo(UserType* output) {
    
    auto* pointer = data_->cert_info.Get();
    return mojo::internal::Deserialize<::network::mojom::SSLCertRequestInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCertResponder() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::ClientCertificateResponderInterfaceBase>>(
            &data_->cert_responder, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWindowIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindowId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `window_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWindowId` instead "
    "of `ReadWindowId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->window_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  int32_t request_id() const {
    return data_->request_id;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool first_auth_attempt() const {
    return data_->first_auth_attempt;
  }
  inline void GetAuthInfoDataView(
      ::network::mojom::AuthChallengeInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuthInfo(UserType* output) {
    
    auto* pointer = data_->auth_info.Get();
    return mojo::internal::Deserialize<::network::mojom::AuthChallengeInfoDataView>(
        pointer, output, message_);
  }
  inline void GetHeadHeadersDataView(
      ::network::mojom::HttpResponseHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeadHeaders(UserType* output) {
    
    auto* pointer = data_->head_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpResponseHeadersDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeAuthChallengeResponder() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::AuthChallengeResponderInterfaceBase>>(
            &data_->auth_challenge_responder, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data* data_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool permission_granted() const {
    return data_->permission_granted;
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data* data_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetHeaderValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaderValue(UserType* output) {
    
    auto* pointer = data_->header_value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t load_flags() const {
    return data_->load_flags;
  }
  inline void GetCookiePartitionKeyDataView(
      ::network::mojom::CookiePartitionKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookiePartitionKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CookiePartitionKeyDataView, UserType>(),
    "Attempting to read the optional `cookie_partition_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookiePartitionKey` instead "
    "of `ReadCookiePartitionKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_partition_key.Get();
    return mojo::internal::Deserialize<::network::mojom::CookiePartitionKeyDataView>(
        pointer, output, message_);
  }
  bool partitioned_state_allowed_only() const {
    return data_->partitioned_state_allowed_only;
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data* data_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      LoadInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::network::mojom::LoadInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data* data_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t network_traffic_annotation_id_hash() const {
    return data_->network_traffic_annotation_id_hash;
  }
  int64_t recv_bytes() const {
    return data_->recv_bytes;
  }
  int64_t sent_bytes() const {
    return data_->sent_bytes;
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data* data_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestOrigin(UserType* output) {
    
    auto* pointer = data_->request_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetMethodsWithOptionsDataView(
      ::network::mojom::SharedStorageBatchUpdateMethodsArgumentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethodsWithOptions(UserType* output) {
    
    auto* pointer = data_->methods_with_options.Get();
    return mojo::internal::Deserialize<::network::mojom::SharedStorageBatchUpdateMethodsArgumentDataView>(
        pointer, output, message_);
  }
  inline void GetWithLockDataView(
      ::network::mojom::LockNameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWithLock(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::LockNameDataView, UserType>(),
    "Attempting to read the optional `with_lock` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWithLock` instead "
    "of `ReadWithLock if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->with_lock.Get();
    return mojo::internal::Deserialize<::network::mojom::LockNameDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data* data_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAdAuctionEventRecordDataView(
      ::network::mojom::AdAuctionEventRecordDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdAuctionEventRecord(UserType* output) {
    
    auto* pointer = data_->ad_auction_event_record.Get();
    return mojo::internal::Deserialize<::network::mojom::AdAuctionEventRecordDataView>(
        pointer, output, message_);
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `top_frame_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTopFrameOrigin` instead "
    "of `ReadTopFrameOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderNetworkServiceObserver_Clone_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_Clone_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_Clone_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_Clone_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
            &data_->listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::URLLoaderNetworkServiceObserver_Clone_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestUrl(UserType* output) {
    
    auto* pointer = data_->request_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadIpAddressSpace(UserType* output) const {
    auto data_value = data_->ip_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace ip_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->ip_address_space));
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsDataView {
 public:
  URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsDataView() = default;

  URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsDataView(
      internal::URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestUrl(UserType* output) {
    
    auto* pointer = data_->request_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResponseAddressSpace(UserType* output) const {
    auto data_value = data_->response_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace response_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->response_address_space));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadClientAddressSpace(UserType* output) const {
    auto data_value = data_->client_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace client_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->client_address_space));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTargetAddressSpace(UserType* output) const {
    auto data_value = data_->target_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace target_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->target_address_space));
  }
 private:
  internal::URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void ClientCertificateResponder_ContinueWithCertificate_ParamsDataView::GetX509CertificateDataView(
    ::network::mojom::X509CertificateDataView* output) {
  auto pointer = data_->x509_certificate.Get();
  *output = ::network::mojom::X509CertificateDataView(pointer, message_);
}
inline void ClientCertificateResponder_ContinueWithCertificate_ParamsDataView::GetProviderNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->provider_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClientCertificateResponder_ContinueWithCertificate_ParamsDataView::GetAlgorithmPreferencesDataView(
    mojo::ArrayDataView<uint16_t>* output) {
  auto pointer = data_->algorithm_preferences.Get();
  *output = mojo::ArrayDataView<uint16_t>(pointer, message_);
}






inline void SSLPrivateKey_Sign_ParamsDataView::GetInputDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->input.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void SSLPrivateKey_Sign_ResponseParamsDataView::GetSignatureDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->signature.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void AuthChallengeResponder_OnAuthCredentials_ParamsDataView::GetCredentialsDataView(
    ::network::mojom::AuthCredentialsDataView* output) {
  auto pointer = data_->credentials.Get();
  *output = ::network::mojom::AuthCredentialsDataView(pointer, message_);
}


inline void URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsDataView::GetSslInfoDataView(
    ::network::mojom::SSLInfoDataView* output) {
  auto pointer = data_->ssl_info.Get();
  *output = ::network::mojom::SSLInfoDataView(pointer, message_);
}




inline void URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsDataView::GetWindowIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->window_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsDataView::GetCertInfoDataView(
    ::network::mojom::SSLCertRequestInfoDataView* output) {
  auto pointer = data_->cert_info.Get();
  *output = ::network::mojom::SSLCertRequestInfoDataView(pointer, message_);
}


inline void URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsDataView::GetWindowIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->window_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsDataView::GetAuthInfoDataView(
    ::network::mojom::AuthChallengeInfoDataView* output) {
  auto pointer = data_->auth_info.Get();
  *output = ::network::mojom::AuthChallengeInfoDataView(pointer, message_);
}
inline void URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsDataView::GetHeadHeadersDataView(
    ::network::mojom::HttpResponseHeadersDataView* output) {
  auto pointer = data_->head_headers.Get();
  *output = ::network::mojom::HttpResponseHeadersDataView(pointer, message_);
}






inline void URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsDataView::GetHeaderValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header_value.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsDataView::GetCookiePartitionKeyDataView(
    ::network::mojom::CookiePartitionKeyDataView* output) {
  auto pointer = data_->cookie_partition_key.Get();
  *output = ::network::mojom::CookiePartitionKeyDataView(pointer, message_);
}




inline void URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsDataView::GetInfoDataView(
    LoadInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = LoadInfoDataView(pointer, message_);
}






inline void URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsDataView::GetRequestOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->request_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsDataView::GetMethodsWithOptionsDataView(
    ::network::mojom::SharedStorageBatchUpdateMethodsArgumentDataView* output) {
  auto pointer = data_->methods_with_options.Get();
  *output = ::network::mojom::SharedStorageBatchUpdateMethodsArgumentDataView(pointer, message_);
}
inline void URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsDataView::GetWithLockDataView(
    ::network::mojom::LockNameDataView* output) {
  auto pointer = data_->with_lock.Get();
  *output = ::network::mojom::LockNameDataView(pointer, message_);
}




inline void URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsDataView::GetAdAuctionEventRecordDataView(
    ::network::mojom::AdAuctionEventRecordDataView* output) {
  auto pointer = data_->ad_auction_event_record.Get();
  *output = ::network::mojom::AdAuctionEventRecordDataView(pointer, message_);
}
inline void URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}




inline void URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsDataView::GetRequestUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->request_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsDataView::GetRequestUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->request_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_PARAMS_DATA_H_