// services/network/public/mojom/url_loader_factory.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/url_loader_factory.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var mutable_network_traffic_annotation_tag$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom', 'mutable_network_traffic_annotation_tag.mojom.js');
  }
  var url_loader$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader.mojom', 'url_loader.mojom.js');
  }
  var url_request$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_request.mojom', 'url_request.mojom.js');
  }


  var URL_LOAD_OPTION_NONE = 0;
  var URL_LOAD_OPTION_SEND_SSL_INFO_WITH_RESPONSE = 1;
  var URL_LOAD_OPTION_SNIFF_MIME_TYPE = 2;
  var URL_LOAD_OPTION_SYNCHRONOUS = 4;
  var URL_LOAD_OPTION_SEND_SSL_INFO_FOR_CERTIFICATE_ERROR = 8;
  var URL_LOAD_OPTION_USE_HEADER_CLIENT = 16;
  var URL_LOAD_OPTION_BLOCK_ALL_COOKIES = 32;
  var URL_LOAD_OPTION_BLOCK_THIRD_PARTY_COOKIES = 64;
  var URL_LOAD_OPTION_AS_CORS_PREFLIGHT = 128;
  var URL_LOAD_OPTION_BLOCK_LOCAL_REQUEST = 256;
  var URL_LOAD_OPTION_READ_AND_DISCARD_BODY = 512;

  function URLLoaderFactory_CreateLoaderAndStart_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderFactory_CreateLoaderAndStart_Params.prototype.initDefaults_ = function() {
    this.loader = new bindings.InterfaceRequest();
    this.requestId = 0;
    this.options = 0;
    this.request = null;
    this.client = new url_loader$.URLLoaderClientPtr();
    this.trafficAnnotation = null;
  };
  URLLoaderFactory_CreateLoaderAndStart_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderFactory_CreateLoaderAndStart_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactory_CreateLoaderAndStart_Params.loader
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate URLLoaderFactory_CreateLoaderAndStart_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url_request$.URLRequest, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactory_CreateLoaderAndStart_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 24, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactory_CreateLoaderAndStart_Params.trafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderFactory_CreateLoaderAndStart_Params.encodedSize = codec.kStructHeaderSize + 40;

  URLLoaderFactory_CreateLoaderAndStart_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderFactory_CreateLoaderAndStart_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.loader =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    val.options =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.request =
        decoder.decodeStructPointer(url_request$.URLRequest);
    val.client =
        decoder.decodeStruct(new codec.Interface(url_loader$.URLLoaderClientPtr));
    val.trafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    return val;
  };

  URLLoaderFactory_CreateLoaderAndStart_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderFactory_CreateLoaderAndStart_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.loader);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.encodeStruct(codec.Uint32, val.options);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url_request$.URLRequest, val.request);
    encoder.encodeStruct(new codec.Interface(url_loader$.URLLoaderClientPtr), val.client);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.trafficAnnotation);
  };
  function URLLoaderFactory_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderFactory_Clone_Params.prototype.initDefaults_ = function() {
    this.factory = new bindings.InterfaceRequest();
  };
  URLLoaderFactory_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderFactory_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactory_Clone_Params.factory
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderFactory_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  URLLoaderFactory_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderFactory_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.factory =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  URLLoaderFactory_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderFactory_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.factory);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kURLLoaderFactory_CreateLoaderAndStart_Name = 0;
  var kURLLoaderFactory_Clone_Name = 1;

  function URLLoaderFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(URLLoaderFactory,
                                                   handleOrPtrInfo);
  }

  function URLLoaderFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        URLLoaderFactory, associatedInterfacePtrInfo);
  }

  URLLoaderFactoryAssociatedPtr.prototype =
      Object.create(URLLoaderFactoryPtr.prototype);
  URLLoaderFactoryAssociatedPtr.prototype.constructor =
      URLLoaderFactoryAssociatedPtr;

  function URLLoaderFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  URLLoaderFactoryPtr.prototype.createLoaderAndStart = function() {
    return URLLoaderFactoryProxy.prototype.createLoaderAndStart
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderFactoryProxy.prototype.createLoaderAndStart = function(loader, requestId, options, request, client, trafficAnnotation) {
    var params_ = new URLLoaderFactory_CreateLoaderAndStart_Params();
    params_.loader = loader;
    params_.requestId = requestId;
    params_.options = options;
    params_.request = request;
    params_.client = client;
    params_.trafficAnnotation = trafficAnnotation;
    var builder = new codec.MessageV0Builder(
        kURLLoaderFactory_CreateLoaderAndStart_Name,
        codec.align(URLLoaderFactory_CreateLoaderAndStart_Params.encodedSize));
    builder.encodeStruct(URLLoaderFactory_CreateLoaderAndStart_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderFactoryPtr.prototype.clone = function() {
    return URLLoaderFactoryProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderFactoryProxy.prototype.clone = function(factory) {
    var params_ = new URLLoaderFactory_Clone_Params();
    params_.factory = factory;
    var builder = new codec.MessageV0Builder(
        kURLLoaderFactory_Clone_Name,
        codec.align(URLLoaderFactory_Clone_Params.encodedSize));
    builder.encodeStruct(URLLoaderFactory_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function URLLoaderFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  URLLoaderFactoryStub.prototype.createLoaderAndStart = function(loader, requestId, options, request, client, trafficAnnotation) {
    return this.delegate_ && this.delegate_.createLoaderAndStart && this.delegate_.createLoaderAndStart(loader, requestId, options, request, client, trafficAnnotation);
  }
  URLLoaderFactoryStub.prototype.clone = function(factory) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(factory);
  }

  URLLoaderFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kURLLoaderFactory_CreateLoaderAndStart_Name:
      var params = reader.decodeStruct(URLLoaderFactory_CreateLoaderAndStart_Params);
      this.createLoaderAndStart(params.loader, params.requestId, params.options, params.request, params.client, params.trafficAnnotation);
      return true;
    case kURLLoaderFactory_Clone_Name:
      var params = reader.decodeStruct(URLLoaderFactory_Clone_Params);
      this.clone(params.factory);
      return true;
    default:
      return false;
    }
  };

  URLLoaderFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateURLLoaderFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kURLLoaderFactory_CreateLoaderAndStart_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderFactory_CreateLoaderAndStart_Params;
      break;
      case kURLLoaderFactory_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderFactory_Clone_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateURLLoaderFactoryResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var URLLoaderFactory = {
    name: 'network.mojom.URLLoaderFactory',
    kVersion: 0,
    ptrClass: URLLoaderFactoryPtr,
    proxyClass: URLLoaderFactoryProxy,
    stubClass: URLLoaderFactoryStub,
    validateRequest: validateURLLoaderFactoryRequest,
    validateResponse: null,
  };
  URLLoaderFactoryStub.prototype.validator = validateURLLoaderFactoryRequest;
  URLLoaderFactoryProxy.prototype.validator = null;
  exports.URL_LOAD_OPTION_NONE = URL_LOAD_OPTION_NONE;
  exports.URL_LOAD_OPTION_SEND_SSL_INFO_WITH_RESPONSE = URL_LOAD_OPTION_SEND_SSL_INFO_WITH_RESPONSE;
  exports.URL_LOAD_OPTION_SNIFF_MIME_TYPE = URL_LOAD_OPTION_SNIFF_MIME_TYPE;
  exports.URL_LOAD_OPTION_SYNCHRONOUS = URL_LOAD_OPTION_SYNCHRONOUS;
  exports.URL_LOAD_OPTION_SEND_SSL_INFO_FOR_CERTIFICATE_ERROR = URL_LOAD_OPTION_SEND_SSL_INFO_FOR_CERTIFICATE_ERROR;
  exports.URL_LOAD_OPTION_USE_HEADER_CLIENT = URL_LOAD_OPTION_USE_HEADER_CLIENT;
  exports.URL_LOAD_OPTION_BLOCK_ALL_COOKIES = URL_LOAD_OPTION_BLOCK_ALL_COOKIES;
  exports.URL_LOAD_OPTION_BLOCK_THIRD_PARTY_COOKIES = URL_LOAD_OPTION_BLOCK_THIRD_PARTY_COOKIES;
  exports.URL_LOAD_OPTION_AS_CORS_PREFLIGHT = URL_LOAD_OPTION_AS_CORS_PREFLIGHT;
  exports.URL_LOAD_OPTION_BLOCK_LOCAL_REQUEST = URL_LOAD_OPTION_BLOCK_LOCAL_REQUEST;
  exports.URL_LOAD_OPTION_READ_AND_DISCARD_BODY = URL_LOAD_OPTION_READ_AND_DISCARD_BODY;
  exports.URLLoaderFactory = URLLoaderFactory;
  exports.URLLoaderFactoryPtr = URLLoaderFactoryPtr;
  exports.URLLoaderFactoryAssociatedPtr = URLLoaderFactoryAssociatedPtr;
})();