// services/network/public/mojom/url_loader_factory.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_loader_factory.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_loader_factory.mojom-params-data.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_loader_factory.mojom-blink-import-headers.h"
#include "services/network/public/mojom/url_loader_factory.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"


namespace network::mojom::blink {
// The declaration includes the definition on other builds.

URLLoaderFactory::IPCStableHashFunction URLLoaderFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::URLLoaderFactory>(message.name())) {
    case messages::URLLoaderFactory::kCreateLoaderAndStart: {
      return &URLLoaderFactory::CreateLoaderAndStart_Sym::IPCStableHash;
    }
    case messages::URLLoaderFactory::kClone: {
      return &URLLoaderFactory::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* URLLoaderFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::URLLoaderFactory>(message.name())) {
      case messages::URLLoaderFactory::kCreateLoaderAndStart:
            return "Receive network::mojom::URLLoaderFactory::CreateLoaderAndStart";
      case messages::URLLoaderFactory::kClone:
            return "Receive network::mojom::URLLoaderFactory::Clone";
    }
  } else {
    switch (static_cast<messages::URLLoaderFactory>(message.name())) {
      case messages::URLLoaderFactory::kCreateLoaderAndStart:
            return "Receive reply network::mojom::URLLoaderFactory::CreateLoaderAndStart";
      case messages::URLLoaderFactory::kClone:
            return "Receive reply network::mojom::URLLoaderFactory::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t URLLoaderFactory::CreateLoaderAndStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb9364fb;  // IPCStableHash for network::mojom::URLLoaderFactory::CreateLoaderAndStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderFactory::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x008dde27;  // IPCStableHash for network::mojom::URLLoaderFactory::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

URLLoaderFactoryProxy::URLLoaderFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderFactoryProxy::CreateLoaderAndStart(
    ::mojo::PendingReceiver<::network::mojom::blink::URLLoader> in_loader, int32_t in_request_id, uint32_t in_options, const ::network::ResourceRequest& in_request, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderClient> in_client, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderFactory::CreateLoaderAndStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("loader"), in_loader,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::URLLoader>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type const ::network::ResourceRequest&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::URLLoaderClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderFactory::kCreateLoaderAndStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderFactory_CreateLoaderAndStart_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderInterfaceBase>>(
    in_loader,
    &params->loader,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->loader)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid loader in URLLoaderFactory.CreateLoaderAndStart request");

  params->request_id = in_request_id;

  params->options = in_options;
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in URLLoaderFactory.CreateLoaderAndStart request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in URLLoaderFactory.CreateLoaderAndStart request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
    in_traffic_annotation,
    traffic_annotation_fragment);

  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->traffic_annotation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null traffic_annotation in URLLoaderFactory.CreateLoaderAndStart request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderFactory::Name_);
  message.set_method_name("CreateLoaderAndStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderFactoryProxy::Clone(
    ::mojo::PendingReceiver<URLLoaderFactory> in_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderFactory::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingReceiver<URLLoaderFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderFactory::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderFactory_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
    in_factory,
    &params->factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid factory in URLLoaderFactory.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderFactory::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool URLLoaderFactoryStubDispatch::Accept(
    URLLoaderFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::URLLoaderFactory>(message->header()->name)) {
    case messages::URLLoaderFactory::kCreateLoaderAndStart: {
      DCHECK(message->is_serialized());
      internal::URLLoaderFactory_CreateLoaderAndStart_Params_Data* params =
          reinterpret_cast<internal::URLLoaderFactory_CreateLoaderAndStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderFactory.0
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::blink::URLLoader> p_loader{};
      int32_t p_request_id{};
      uint32_t p_options{};
      ::network::ResourceRequest p_request{};
      ::mojo::PendingRemote<::network::mojom::blink::URLLoaderClient> p_client{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      URLLoaderFactory_CreateLoaderAndStart_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_loader =
            input_data_view.TakeLoader<decltype(p_loader)>();
      }
      if (success)
        p_request_id = input_data_view.request_id();
      if (success)
        p_options = input_data_view.options();
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateLoaderAndStart(        
        std::move(p_loader), 
        std::move(p_request_id), 
        std::move(p_options), 
        p_request, 
        std::move(p_client), 
        std::move(p_traffic_annotation));
      return true;
    }
    case messages::URLLoaderFactory::kClone: {
      DCHECK(message->is_serialized());
      internal::URLLoaderFactory_Clone_Params_Data* params =
          reinterpret_cast<internal::URLLoaderFactory_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderFactory.1
      bool success = true;
      ::mojo::PendingReceiver<URLLoaderFactory> p_factory{};
      URLLoaderFactory_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_factory));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderFactoryStubDispatch::AcceptWithResponder(
    URLLoaderFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::URLLoaderFactory>(message->header()->name)) {
    case messages::URLLoaderFactory::kCreateLoaderAndStart: {
      break;
    }
    case messages::URLLoaderFactory::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kURLLoaderFactoryValidationInfo[] = {
    { &internal::URLLoaderFactory_CreateLoaderAndStart_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::URLLoaderFactory_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool URLLoaderFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::URLLoaderFactory::Name_,
    kURLLoaderFactoryValidationInfo);
}



}  // network::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void URLLoaderFactoryInterceptorForTesting::CreateLoaderAndStart(::mojo::PendingReceiver<::network::mojom::blink::URLLoader> loader, int32_t request_id, uint32_t options, const ::network::ResourceRequest& request, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderClient> client, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) {
  GetForwardingInterface()->CreateLoaderAndStart(
    std::move(loader)
    , 
    std::move(request_id)
    , 
    std::move(options)
    , 
    request, 
    std::move(client)
    , 
    std::move(traffic_annotation)
    );
}
void URLLoaderFactoryInterceptorForTesting::Clone(::mojo::PendingReceiver<URLLoaderFactory> factory) {
  GetForwardingInterface()->Clone(
    std::move(factory)
    );
}
URLLoaderFactoryAsyncWaiter::URLLoaderFactoryAsyncWaiter(
    URLLoaderFactory* proxy) : proxy_(proxy) {}

URLLoaderFactoryAsyncWaiter::~URLLoaderFactoryAsyncWaiter() = default;







}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif