// services/network/public/mojom/udp_socket.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ReadOnlyBuffer as mojoBase_mojom_ReadOnlyBuffer,
  ReadOnlyBufferSpec as mojoBase_mojom_ReadOnlyBufferSpec
} from '../../../../mojo/public/mojom/base/read_only_buffer.mojom.m.js';

import {
  IPAddress as network_mojom_IPAddress,
  IPAddressSpec as network_mojom_IPAddressSpec
} from './ip_address.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from './ip_endpoint.mojom.m.js';

import {
  MutableNetworkTrafficAnnotationTag as network_mojom_MutableNetworkTrafficAnnotationTag,
  MutableNetworkTrafficAnnotationTagSpec as network_mojom_MutableNetworkTrafficAnnotationTagSpec
} from './mutable_network_traffic_annotation_tag.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class UDPSocketPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.UDPSocket', scope);
  }
}

/** @interface */
export class UDPSocketInterface {
  
  /**
   * @param { !network_mojom_IPEndPoint } localAddr
   * @param { ?UDPSocketOptions } socketOptions
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network_mojom_IPEndPoint,
   *  }>}
   */

  bind(localAddr, socketOptions) {}
  
  /**
   * @param { !network_mojom_IPEndPoint } remoteAddr
   * @param { ?UDPSocketOptions } socketOptions
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network_mojom_IPEndPoint,
   *  }>}
   */

  connect(remoteAddr, socketOptions) {}
  
  /**
   * @param { !boolean } broadcast
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  setBroadcast(broadcast) {}
  
  /**
   * @param { !number } sendBufferSize
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  setSendBufferSize(sendBufferSize) {}
  
  /**
   * @param { !number } receiveBufferSize
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  setReceiveBufferSize(receiveBufferSize) {}
  
  /**
   * @param { !network_mojom_IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  joinGroup(groupAddress) {}
  
  /**
   * @param { !network_mojom_IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  leaveGroup(groupAddress) {}
  
  /**
   * @param { !number } numAdditionalDatagrams
   */

  receiveMore(numAdditionalDatagrams) {}
  
  /**
   * @param { !number } numAdditionalDatagrams
   * @param { !number } bufferSize
   */

  receiveMoreWithBufferSize(numAdditionalDatagrams, bufferSize) {}
  
  /**
   * @param { !network_mojom_IPEndPoint } destAddr
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  sendTo(destAddr, data, trafficAnnotation) {}
  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  send(data, trafficAnnotation) {}
  
  /**
   */

  close() {}
}

/**
 * @implements { UDPSocketInterface }
 */
export class UDPSocketRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!UDPSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UDPSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!UDPSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_IPEndPoint } localAddr
   * @param { ?UDPSocketOptions } socketOptions
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network_mojom_IPEndPoint,
   *  }>}
   */

  bind(
      localAddr,
      socketOptions) {
    return this.proxy.sendMessage(
        0,
        UDPSocket_Bind_ParamsSpec.$,
        UDPSocket_Bind_ResponseParamsSpec.$,
        [
          localAddr,
          socketOptions
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_IPEndPoint } remoteAddr
   * @param { ?UDPSocketOptions } socketOptions
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network_mojom_IPEndPoint,
   *  }>}
   */

  connect(
      remoteAddr,
      socketOptions) {
    return this.proxy.sendMessage(
        1,
        UDPSocket_Connect_ParamsSpec.$,
        UDPSocket_Connect_ResponseParamsSpec.$,
        [
          remoteAddr,
          socketOptions
        ],
        false);
  }

  
  /**
   * @param { !boolean } broadcast
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  setBroadcast(
      broadcast) {
    return this.proxy.sendMessage(
        2,
        UDPSocket_SetBroadcast_ParamsSpec.$,
        UDPSocket_SetBroadcast_ResponseParamsSpec.$,
        [
          broadcast
        ],
        false);
  }

  
  /**
   * @param { !number } sendBufferSize
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  setSendBufferSize(
      sendBufferSize) {
    return this.proxy.sendMessage(
        3,
        UDPSocket_SetSendBufferSize_ParamsSpec.$,
        UDPSocket_SetSendBufferSize_ResponseParamsSpec.$,
        [
          sendBufferSize
        ],
        false);
  }

  
  /**
   * @param { !number } receiveBufferSize
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  setReceiveBufferSize(
      receiveBufferSize) {
    return this.proxy.sendMessage(
        4,
        UDPSocket_SetReceiveBufferSize_ParamsSpec.$,
        UDPSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        [
          receiveBufferSize
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  joinGroup(
      groupAddress) {
    return this.proxy.sendMessage(
        5,
        UDPSocket_JoinGroup_ParamsSpec.$,
        UDPSocket_JoinGroup_ResponseParamsSpec.$,
        [
          groupAddress
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  leaveGroup(
      groupAddress) {
    return this.proxy.sendMessage(
        6,
        UDPSocket_LeaveGroup_ParamsSpec.$,
        UDPSocket_LeaveGroup_ResponseParamsSpec.$,
        [
          groupAddress
        ],
        false);
  }

  
  /**
   * @param { !number } numAdditionalDatagrams
   */

  receiveMore(
      numAdditionalDatagrams) {
    this.proxy.sendMessage(
        7,
        UDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        [
          numAdditionalDatagrams
        ],
        false);
  }

  
  /**
   * @param { !number } numAdditionalDatagrams
   * @param { !number } bufferSize
   */

  receiveMoreWithBufferSize(
      numAdditionalDatagrams,
      bufferSize) {
    this.proxy.sendMessage(
        8,
        UDPSocket_ReceiveMoreWithBufferSize_ParamsSpec.$,
        null,
        [
          numAdditionalDatagrams,
          bufferSize
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_IPEndPoint } destAddr
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  sendTo(
      destAddr,
      data,
      trafficAnnotation) {
    return this.proxy.sendMessage(
        9,
        UDPSocket_SendTo_ParamsSpec.$,
        UDPSocket_SendTo_ResponseParamsSpec.$,
        [
          destAddr,
          data,
          trafficAnnotation
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  send(
      data,
      trafficAnnotation) {
    return this.proxy.sendMessage(
        10,
        UDPSocket_Send_ParamsSpec.$,
        UDPSocket_Send_ResponseParamsSpec.$,
        [
          data,
          trafficAnnotation
        ],
        false);
  }

  
  /**
   */

  close() {
    this.proxy.sendMessage(
        11,
        UDPSocket_Close_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the UDPSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UDPSocketReceiver {
  /**
   * @param {!UDPSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!UDPSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UDPSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UDPSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UDPSocket_Bind_ParamsSpec.$,
        UDPSocket_Bind_ResponseParamsSpec.$,
        impl.bind.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        UDPSocket_Connect_ParamsSpec.$,
        UDPSocket_Connect_ResponseParamsSpec.$,
        impl.connect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        UDPSocket_SetBroadcast_ParamsSpec.$,
        UDPSocket_SetBroadcast_ResponseParamsSpec.$,
        impl.setBroadcast.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        UDPSocket_SetSendBufferSize_ParamsSpec.$,
        UDPSocket_SetSendBufferSize_ResponseParamsSpec.$,
        impl.setSendBufferSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        UDPSocket_SetReceiveBufferSize_ParamsSpec.$,
        UDPSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        impl.setReceiveBufferSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        UDPSocket_JoinGroup_ParamsSpec.$,
        UDPSocket_JoinGroup_ResponseParamsSpec.$,
        impl.joinGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        UDPSocket_LeaveGroup_ParamsSpec.$,
        UDPSocket_LeaveGroup_ResponseParamsSpec.$,
        impl.leaveGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        UDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        impl.receiveMore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        UDPSocket_ReceiveMoreWithBufferSize_ParamsSpec.$,
        null,
        impl.receiveMoreWithBufferSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        UDPSocket_SendTo_ParamsSpec.$,
        UDPSocket_SendTo_ResponseParamsSpec.$,
        impl.sendTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        UDPSocket_Send_ParamsSpec.$,
        UDPSocket_Send_ResponseParamsSpec.$,
        impl.send.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        UDPSocket_Close_ParamsSpec.$,
        null,
        impl.close.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UDPSocket {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.UDPSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!UDPSocketRemote}
   */
  static getRemote() {
    let remote = new UDPSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the UDPSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UDPSocketCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UDPSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UDPSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bind =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UDPSocket_Bind_ParamsSpec.$,
        UDPSocket_Bind_ResponseParamsSpec.$,
        this.bind.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UDPSocket_Connect_ParamsSpec.$,
        UDPSocket_Connect_ResponseParamsSpec.$,
        this.connect.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setBroadcast =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        UDPSocket_SetBroadcast_ParamsSpec.$,
        UDPSocket_SetBroadcast_ResponseParamsSpec.$,
        this.setBroadcast.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSendBufferSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        UDPSocket_SetSendBufferSize_ParamsSpec.$,
        UDPSocket_SetSendBufferSize_ResponseParamsSpec.$,
        this.setSendBufferSize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReceiveBufferSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        UDPSocket_SetReceiveBufferSize_ParamsSpec.$,
        UDPSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        this.setReceiveBufferSize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.joinGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        UDPSocket_JoinGroup_ParamsSpec.$,
        UDPSocket_JoinGroup_ResponseParamsSpec.$,
        this.joinGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.leaveGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        UDPSocket_LeaveGroup_ParamsSpec.$,
        UDPSocket_LeaveGroup_ResponseParamsSpec.$,
        this.leaveGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.receiveMore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        UDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        this.receiveMore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.receiveMoreWithBufferSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        UDPSocket_ReceiveMoreWithBufferSize_ParamsSpec.$,
        null,
        this.receiveMoreWithBufferSize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        UDPSocket_SendTo_ParamsSpec.$,
        UDPSocket_SendTo_ResponseParamsSpec.$,
        this.sendTo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.send =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        UDPSocket_Send_ParamsSpec.$,
        UDPSocket_Send_ResponseParamsSpec.$,
        this.send.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        UDPSocket_Close_ParamsSpec.$,
        null,
        this.close.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class UDPSocketListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.UDPSocketListener', scope);
  }
}

/** @interface */
export class UDPSocketListenerInterface {
  
  /**
   * @param { !number } result
   * @param { ?network_mojom_IPEndPoint } srcAddr
   * @param { ?mojoBase_mojom_ReadOnlyBuffer } data
   */

  onReceived(result, srcAddr, data) {}
}

/**
 * @implements { UDPSocketListenerInterface }
 */
export class UDPSocketListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!UDPSocketListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UDPSocketListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!UDPSocketListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } result
   * @param { ?network_mojom_IPEndPoint } srcAddr
   * @param { ?mojoBase_mojom_ReadOnlyBuffer } data
   */

  onReceived(
      result,
      srcAddr,
      data) {
    this.proxy.sendMessage(
        0,
        UDPSocketListener_OnReceived_ParamsSpec.$,
        null,
        [
          result,
          srcAddr,
          data
        ],
        false);
  }
}

/**
 * An object which receives request messages for the UDPSocketListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UDPSocketListenerReceiver {
  /**
   * @param {!UDPSocketListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!UDPSocketListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UDPSocketListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UDPSocketListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UDPSocketListener_OnReceived_ParamsSpec.$,
        null,
        impl.onReceived.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UDPSocketListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.UDPSocketListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!UDPSocketListenerRemote}
   */
  static getRemote() {
    let remote = new UDPSocketListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the UDPSocketListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UDPSocketListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UDPSocketListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UDPSocketListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UDPSocketListener_OnReceived_ParamsSpec.$,
        null,
        this.onReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_Bind_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_Bind_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_Connect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_SetBroadcast_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_SetBroadcast_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_SetSendBufferSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_SetSendBufferSize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_SetReceiveBufferSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_SetReceiveBufferSize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_JoinGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_JoinGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_LeaveGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_LeaveGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_ReceiveMore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_ReceiveMoreWithBufferSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_SendTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_SendTo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_Send_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_Send_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocket_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UDPSocketListener_OnReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    UDPSocketOptionsSpec.$,
    'UDPSocketOptions',
    [
      mojo.internal.StructField(
        'allowAddressReuse', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowBroadcast', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowAddressSharingForMulticast', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'multicastInterface', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'multicastTimeToLive', 8,
        0,
        mojo.internal.Uint32,
        1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'multicastLoopbackMode', 0,
        3,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendBufferSize', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiveBufferSize', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ipv6_only_$flag', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "ipv6_only_$value",
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'ipv6_only_$value', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "ipv6Only",
        }
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class UDPSocketOptions {
  constructor() {
    /** @type { !boolean } */
    this.allowAddressReuse;
    /** @type { !boolean } */
    this.allowBroadcast;
    /** @type { !boolean } */
    this.allowAddressSharingForMulticast;
    /** @type { !number } */
    this.multicastInterface;
    /** @type { !number } */
    this.multicastTimeToLive;
    /** @type { !boolean } */
    this.multicastLoopbackMode;
    /** @type { !number } */
    this.sendBufferSize;
    /** @type { !number } */
    this.receiveBufferSize;
    /** @type { (boolean|undefined) } */
    this.ipv6Only;
  }
}



mojo.internal.Struct(
    UDPSocket_Bind_ParamsSpec.$,
    'UDPSocket_Bind_Params',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'socketOptions', 8,
        0,
        UDPSocketOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UDPSocket_Bind_Params {
  constructor() {
    /** @type { !network_mojom_IPEndPoint } */
    this.localAddr;
    /** @type { (UDPSocketOptions|undefined) } */
    this.socketOptions;
  }
}



mojo.internal.Struct(
    UDPSocket_Bind_ResponseParamsSpec.$,
    'UDPSocket_Bind_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddrOut', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UDPSocket_Bind_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddrOut;
  }
}



mojo.internal.Struct(
    UDPSocket_Connect_ParamsSpec.$,
    'UDPSocket_Connect_Params',
    [
      mojo.internal.StructField(
        'remoteAddr', 0,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'socketOptions', 8,
        0,
        UDPSocketOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UDPSocket_Connect_Params {
  constructor() {
    /** @type { !network_mojom_IPEndPoint } */
    this.remoteAddr;
    /** @type { (UDPSocketOptions|undefined) } */
    this.socketOptions;
  }
}



mojo.internal.Struct(
    UDPSocket_Connect_ResponseParamsSpec.$,
    'UDPSocket_Connect_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddrOut', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UDPSocket_Connect_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddrOut;
  }
}



mojo.internal.Struct(
    UDPSocket_SetBroadcast_ParamsSpec.$,
    'UDPSocket_SetBroadcast_Params',
    [
      mojo.internal.StructField(
        'broadcast', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_SetBroadcast_Params {
  constructor() {
    /** @type { !boolean } */
    this.broadcast;
  }
}



mojo.internal.Struct(
    UDPSocket_SetBroadcast_ResponseParamsSpec.$,
    'UDPSocket_SetBroadcast_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_SetBroadcast_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    UDPSocket_SetSendBufferSize_ParamsSpec.$,
    'UDPSocket_SetSendBufferSize_Params',
    [
      mojo.internal.StructField(
        'sendBufferSize', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_SetSendBufferSize_Params {
  constructor() {
    /** @type { !number } */
    this.sendBufferSize;
  }
}



mojo.internal.Struct(
    UDPSocket_SetSendBufferSize_ResponseParamsSpec.$,
    'UDPSocket_SetSendBufferSize_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_SetSendBufferSize_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    UDPSocket_SetReceiveBufferSize_ParamsSpec.$,
    'UDPSocket_SetReceiveBufferSize_Params',
    [
      mojo.internal.StructField(
        'receiveBufferSize', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_SetReceiveBufferSize_Params {
  constructor() {
    /** @type { !number } */
    this.receiveBufferSize;
  }
}



mojo.internal.Struct(
    UDPSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
    'UDPSocket_SetReceiveBufferSize_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_SetReceiveBufferSize_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    UDPSocket_JoinGroup_ParamsSpec.$,
    'UDPSocket_JoinGroup_Params',
    [
      mojo.internal.StructField(
        'groupAddress', 0,
        0,
        network_mojom_IPAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_JoinGroup_Params {
  constructor() {
    /** @type { !network_mojom_IPAddress } */
    this.groupAddress;
  }
}



mojo.internal.Struct(
    UDPSocket_JoinGroup_ResponseParamsSpec.$,
    'UDPSocket_JoinGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_JoinGroup_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    UDPSocket_LeaveGroup_ParamsSpec.$,
    'UDPSocket_LeaveGroup_Params',
    [
      mojo.internal.StructField(
        'groupAddress', 0,
        0,
        network_mojom_IPAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_LeaveGroup_Params {
  constructor() {
    /** @type { !network_mojom_IPAddress } */
    this.groupAddress;
  }
}



mojo.internal.Struct(
    UDPSocket_LeaveGroup_ResponseParamsSpec.$,
    'UDPSocket_LeaveGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_LeaveGroup_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    UDPSocket_ReceiveMore_ParamsSpec.$,
    'UDPSocket_ReceiveMore_Params',
    [
      mojo.internal.StructField(
        'numAdditionalDatagrams', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_ReceiveMore_Params {
  constructor() {
    /** @type { !number } */
    this.numAdditionalDatagrams;
  }
}



mojo.internal.Struct(
    UDPSocket_ReceiveMoreWithBufferSize_ParamsSpec.$,
    'UDPSocket_ReceiveMoreWithBufferSize_Params',
    [
      mojo.internal.StructField(
        'numAdditionalDatagrams', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bufferSize', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_ReceiveMoreWithBufferSize_Params {
  constructor() {
    /** @type { !number } */
    this.numAdditionalDatagrams;
    /** @type { !number } */
    this.bufferSize;
  }
}



mojo.internal.Struct(
    UDPSocket_SendTo_ParamsSpec.$,
    'UDPSocket_SendTo_Params',
    [
      mojo.internal.StructField(
        'destAddr', 0,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 16,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class UDPSocket_SendTo_Params {
  constructor() {
    /** @type { !network_mojom_IPEndPoint } */
    this.destAddr;
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
}



mojo.internal.Struct(
    UDPSocket_SendTo_ResponseParamsSpec.$,
    'UDPSocket_SendTo_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_SendTo_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    UDPSocket_Send_ParamsSpec.$,
    'UDPSocket_Send_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 8,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UDPSocket_Send_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
}



mojo.internal.Struct(
    UDPSocket_Send_ResponseParamsSpec.$,
    'UDPSocket_Send_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UDPSocket_Send_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    UDPSocket_Close_ParamsSpec.$,
    'UDPSocket_Close_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class UDPSocket_Close_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    UDPSocketListener_OnReceived_ParamsSpec.$,
    'UDPSocketListener_OnReceived_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'srcAddr', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 16,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class UDPSocketListener_OnReceived_Params {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.srcAddr;
    /** @type { (mojoBase_mojom_ReadOnlyBuffer|undefined) } */
    this.data;
  }
}

